/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.pur;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPurchaseCostForPurInVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckPurchaseCostForPurInVRule.class);

    public CheckPurchaseCostForPurInVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurInWarehsBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        PurInWarehsBillInfo purInWarehsBillInfo = (PurInWarehsBillInfo)bean;
        PurInWarehsEntryCollection entrys = purInWarehsBillInfo.getEntry();
        boolean isForwardAmt = false;
        TransactionTypeInfo transactionType = purInWarehsBillInfo.getTransactionType();
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            MaterialCompanyInfoInfo mcInfo;
            StoreTypeInfo storeTypeInfo;
            PurInWarehsEntryInfo entry = (PurInWarehsEntryInfo)entrys.getObject(j);
            isForwardAmt = false;
            InvUpdateTypeInfo invUpdateTypeInfo = entry.getInvUpdateType();
            if (invUpdateTypeInfo != null && invUpdateTypeInfo.getStoreType() != null && invUpdateTypeInfo.getStoreType().getId() != null && (storeTypeInfo = this.getStoreTypeInfoById(this.getCtx(), invUpdateTypeInfo.getStoreType().getId().toString())).isIsForwardAmt()) {
                isForwardAmt = true;
            }
            if ((mcInfo = this.getMaterialCompanyInfo(entry.getMaterial().getId().toString(), entry.getCompanyOrgUnit().getId().toString())) == null || !mcInfo.getAccountType().equals((Object)AccountType.MOVE_ADD_AVERAGE) || entry.isIsPresent() || !isForwardAmt || !transactionType.isIsCalculate() || purInWarehsBillInfo.isIsInitBill()) continue;
            if (entry.getUnitPurchaseCost() == null || entry.getUnitPurchaseCost().compareTo(SysConstant.BIGZERO) <= 0) {
                throw new InvBizException(InvBizException.UNITPURCHASECOST_IS_NOT_NULL, new Object[]{String.valueOf(j + 1)});
            }
            if (entry.getPurchaseCost() != null && entry.getPurchaseCost().compareTo(SysConstant.BIGZERO) != 0) continue;
            throw new InvBizException(InvBizException.PURCHASECOST_IS_NOT_NULL, new Object[]{String.valueOf(j + 1)});
        }
    }

    private StoreTypeInfo getStoreTypeInfoById(Context ctx, String storeTypeId) throws EASBizException, BOSException {
        if (this.getDataCache().contain(storeTypeId, DataTypeEnum.STORE_TYPE)) {
            return (StoreTypeInfo)this.getDataCache().get(storeTypeId, DataTypeEnum.STORE_TYPE);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u5e93\u5b58\u7c7b\u578b\u65f6\uff0c\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7f13\u5b58\u6570\u636e\uff0c\u53ef\u80fd\u4f1a\u5b58\u5728\u5faa\u73af\u6570\u636e\u5e93\u64cd\u4f5c\u3002class.method:com.kingdee.eas.scm.im.inv.vrule.CheckPurchaseCostForPurInVRule.getStoreTypeInfoById(Context, String)");
        }
        StoreTypeInfo storeTypeInfo = null;
        if (!StringUtil.isEmpty((String)storeTypeId)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("storeFlag"));
            sic.add(new SelectorItemInfo("isForwardAmt"));
            IStoreType iStoreType = null;
            if (ctx == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u5e93\u5b58\u7c7b\u578b\u65f6\uff0c\u5b58\u5728RPC\u8c03\u7528\uff0c\u4e0d\u5efa\u8bae\u5728\u5ba2\u6237\u7aef\u4f7f\u7528\u3002class.method:com.kingdee.eas.scm.im.inv.vrule.CheckPurchaseCostForPurInVRule.getStoreTypeInfoById(Context, String)");
                }
                iStoreType = StoreTypeFactory.getRemoteInstance();
            } else {
                iStoreType = StoreTypeFactory.getLocalInstance((Context)ctx);
            }
            storeTypeInfo = iStoreType.getStoreTypeInfo((IObjectPK)new ObjectUuidPK(storeTypeId), sic);
            this.getDataCache().put(storeTypeId, (Object)storeTypeInfo, DataTypeEnum.STORE_TYPE);
        }
        return storeTypeInfo;
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfo(String materialId, String couId) throws BOSException {
        if (this.getDataCache().contain(materialId + couId, DataTypeEnum.MATERIAL_COMPANY)) {
            return (MaterialCompanyInfoInfo)this.getDataCache().get(materialId + couId, DataTypeEnum.MATERIAL_COMPANY);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u7269\u6599\u7684\u8d22\u52a1\u9875\u7b7e\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7f13\u5b58\u3002class.method:com.kingdee.eas.scm.im.inv.vrule.CheckMaterialCompanyVRule.getMaterialCompanyInfo(String, String)");
        }
        IMaterialCompanyInfo iMaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialId));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)couId));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountType");
        entityView.setSelector(selector);
        MaterialCompanyInfoCollection col = iMaterialCompany.getMaterialCompanyInfoCollection(entityView);
        MaterialCompanyInfoInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        this.getDataCache().put(materialId + couId, (Object)info, DataTypeEnum.MATERIAL_COMPANY);
        return info;
    }
}

