/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;

public class CheckPriceAndAmountVRule
implements IVRule {
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleIssueBillInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache injectData) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        this.checkPriceAndAmount(bean);
    }

    protected boolean checkPriceAndAmount(IObjectValue model) throws BOSException, EASBizException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        SaleIssueBillInfo billInfo = (SaleIssueBillInfo)aSCMBillBaseInfo;
        boolean noPriceAndAmount = false;
        if (billInfo != null && billInfo.getEntry() != null) {
            SaleIssueEntryCollection entryCol = billInfo.getEntry();
            int step = 0;
            StringBuilder materialNumber = new StringBuilder("");
            if (billInfo.isIsInTax()) {
                int size = entryCol.size();
                for (int i = 0; i < size; ++i) {
                    SaleIssueEntryInfo entry = entryCol.get(i);
                    if (entry.isIsPresent() || entry.getTaxPrice() != null && entry.getAmount() != null && entry.getTaxPrice().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 && entry.getAmount().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) continue;
                    noPriceAndAmount = true;
                    if (step == 0) {
                        materialNumber.append(i + 1 + "");
                    } else {
                        materialNumber.append("\u3001" + (i + 1) + "");
                    }
                    ++step;
                }
            } else {
                int size = entryCol.size();
                for (int i = 0; i < size; ++i) {
                    SaleIssueEntryInfo entry = entryCol.get(i);
                    if (entry.isIsPresent() || entry.getPrice() != null && entry.getNonTaxAmount() != null && entry.getPrice().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 && entry.getNonTaxAmount().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) continue;
                    noPriceAndAmount = true;
                    if (step == 0) {
                        materialNumber.append(i + 1 + "");
                    } else {
                        materialNumber.append("\u3001" + (i + 1) + "");
                    }
                    ++step;
                }
            }
            if (noPriceAndAmount) {
                if (billInfo.isIsInTax()) {
                    throw new SCMBillException(SCMBillException.ENTRYSNOTAXPRICEANDTAXAMOUNT, new Object[]{materialNumber.toString()});
                }
                throw new SCMBillException(SCMBillException.ENTRYSNOPRICEANDAMOUNT, new Object[]{materialNumber.toString()});
            }
        }
        return true;
    }
}

