/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;

public class CheckSaleIssueBizConsignmentVRule
extends AbstractServerVRule {
    public CheckSaleIssueBizConsignmentVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleIssueBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        SaleIssueBillInfo info = (SaleIssueBillInfo)bean;
        if (this.isConsignmentBizType(info)) {
            this.checkBizConsignment(this.getCtx(), info);
        }
    }

    private void checkBizConsignment(Context ctx, SaleIssueBillInfo saleIssueBillInfo) throws EASBizException, BOSException {
        if (null == saleIssueBillInfo || null == saleIssueBillInfo.getTransactionType()) {
            return;
        }
        boolean isWriteOff = this.isWriteOffSaleIssueBill(ctx, saleIssueBillInfo);
        boolean isInvUpdateByARBill = false;
        CompanyOrgUnitInfo cou = this.getSouDelegateCou(saleIssueBillInfo.getStorageOrgUnit());
        if (cou == null) {
            return;
        }
        String isInvUpdateByARBillStr = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(cou.getId()), "CONSIGNSALES");
        if (!StringUtils.isEmpty((String)isInvUpdateByARBillStr) && "true".equalsIgnoreCase(isInvUpdateByARBillStr.trim())) {
            isInvUpdateByARBill = true;
        }
        if (isInvUpdateByARBill && !isWriteOff) {
            throw new InvBizException(InvBizException.ISUPDATEBYARBILL_FOR_CONSIGNMENT_ISWRITEOFF);
        }
    }

    private CompanyOrgUnitInfo getSouDelegateCou(StorageOrgUnitInfo sou) throws EASBizException, BOSException {
        if (sou == null) {
            return null;
        }
        String souId = sou.getId().toString();
        if (this.getDataCache().contain(souId, DataTypeEnum.MAINORGUNIT_2_COMPANY)) {
            return (CompanyOrgUnitInfo)this.getDataCache().get(souId, DataTypeEnum.MAINORGUNIT_2_COMPANY);
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)this.getCtx());
        OrgUnitCollection col = iOrgUnitRelation.getToUnit(souId, 4, 1);
        if (col != null && col.size() > 0) {
            return (CompanyOrgUnitInfo)col.get(0);
        }
        return null;
    }

    private boolean isConsignmentBizType(InvBillBaseInfo invBillBaseInfo) {
        boolean isConsignmentBizType = false;
        if (invBillBaseInfo != null && invBillBaseInfo.getTransactionType() != null && invBillBaseInfo.getBizType() != null && "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(invBillBaseInfo.getBizType().getId().toString())) {
            isConsignmentBizType = true;
        }
        return isConsignmentBizType;
    }

    private boolean isConsOutSaleIssueBill(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        String riTypeID;
        boolean isConsOut = false;
        if (this.isConsignmentBizType(invBillBaseInfo) && invBillBaseInfo.getTransactionType().getRiType() != null && RecIssueTypeConstant.CONSIGNOUT_RITYPEID.equals(riTypeID = invBillBaseInfo.getTransactionType().getRiType().getId().toString())) {
            isConsOut = true;
        }
        return isConsOut;
    }

    private boolean isWriteOffSaleIssueBill(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isWriteOff"));
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)invBillBaseInfo.getTransactionType().getId().toString()));
        ev.setSelector(sic);
        ev.setFilter(fi);
        TransactionTypeCollection transTypeCol = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeCollection(ev);
        if (!transTypeCol.isEmpty()) {
            return transTypeCol.get(0).isIsWriteOff();
        }
        return true;
    }

    private boolean isConsRtSaleIssueBill(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        String riTypeID;
        boolean isConsRt = false;
        if (this.isConsignmentBizType(invBillBaseInfo) && invBillBaseInfo.getTransactionType().getRiType() != null && RecIssueTypeConstant.CONSIGNRT_RITYPEID.equals(riTypeID = invBillBaseInfo.getTransactionType().getRiType().getId().toString())) {
            isConsRt = true;
        }
        return isConsRt;
    }
}

