/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.credit.CreditParamFacadeFactory;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryCollection;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CheckSaleIssueCanAuditVRule
extends AbstractServerVRule {
    private static final String SCM_SALEISSUEBILL_AUDIT = "SCM_SALEISSUEBILL_AUDIT";

    public CheckSaleIssueCanAuditVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleIssueBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        InvBillBaseInfo info = (InvBillBaseInfo)bean;
        if (this.isHasBizFlow(info)) {
            return;
        }
        this.checkBillCanAudit(this.getCtx(), info);
        this.checkConsignReturn(this.getCtx(), info);
    }

    private void checkBillCanAudit(Context ctx, InvBillBaseInfo invBillBaseInfo) throws EASBizException, BOSException {
        boolean isCanAuditReverse;
        boolean connotAudit = true;
        boolean conmotAuditByPostRequisition = true;
        StringBuffer postEntryIds = new StringBuffer();
        StringBuffer coreIds = new StringBuffer();
        StringBuffer coreEntryIds = new StringBuffer();
        HashMap<String, String> coreEntryIdsMap = new HashMap<String, String>();
        SaleIssueEntryCollection entryCollection = (SaleIssueEntryCollection)((Object)invBillBaseInfo.get("entry"));
        ISaleIssueBill isaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
        BillTypeInfo coreBillType = null;
        HashMap<String, SaleOrderInfo> saleOrdMap = new HashMap<String, SaleOrderInfo>();
        HashMap<ObjectUuidPK, String> paramMap = new HashMap<ObjectUuidPK, String>();
        boolean isCanAuditNotReverse = false;
        boolean bl = isCanAuditReverse = invBillBaseInfo.isIsReversed() && !BillBaseStatusEnum.AUDITED.equals((Object)invBillBaseInfo.getBaseStatus());
        if (invBillBaseInfo.getTransactionType() != null) {
            String id = invBillBaseInfo.getTransactionType().getId().toString();
            TransactionTypeInfo typeInfo = invBillBaseInfo.getTransactionType();
            if (typeInfo.getRiType() == null || typeInfo.getRiType().getBizDirection() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("riType.id"));
                sic.add(new SelectorItemInfo("riType.bizDirection"));
                typeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(id), sic);
            }
            this.checkBySaleissueBill(ctx, invBillBaseInfo, typeInfo);
            isCanAuditNotReverse = this.isCanAuditNotReverse(invBillBaseInfo, typeInfo);
            if (isCanAuditNotReverse) {
                SaleIssueEntryInfo entry = null;
                BillTypeInfo sourceTypeInfo = invBillBaseInfo.getSourceBillType();
                if (sourceTypeInfo != null) {
                    int size = entryCollection.size();
                    for (int i = 0; i < size; ++i) {
                        entry = entryCollection.get(i);
                        if ("510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(sourceTypeInfo.getId().toString())) {
                            if (postEntryIds.length() > 0) {
                                postEntryIds.append(",");
                            }
                            postEntryIds.append(entry.getSourceBillEntryId());
                        }
                        coreBillType = entry.getCoreBillType();
                        String coreType = null;
                        if (coreBillType != null && coreBillType.getId() != null && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreType = coreBillType.getId().toString())) {
                            if (!"510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreType) || entry.getSaleOrder() == null) continue;
                            if (coreIds.length() > 0) {
                                coreIds.append(",");
                            }
                            coreIds.append(entry.getSaleOrder());
                            if (entry.getSaleOrderEntry() == null) continue;
                            if (coreEntryIds.length() > 0) {
                                coreEntryIds.append(",");
                            }
                            coreEntryIds.append(entry.getSaleOrderEntry());
                            coreEntryIdsMap.put(entry.getSaleOrderEntry(), entry.getSaleOrderEntry());
                            continue;
                        }
                        break;
                    }
                }
            }
        } else if (isCanAuditReverse) {
            SaleIssueEntryInfo entry = null;
            BillTypeInfo sourceTypeInfo = invBillBaseInfo.getSourceBillType();
            if (sourceTypeInfo != null && sourceTypeInfo.getId() != null && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(sourceTypeInfo.getId().toString())) {
                String sourceID = invBillBaseInfo.getSourceBillId();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("sourceBillType"));
                SaleIssueBillInfo info = isaleIssueBill.getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(sourceID), selector);
                if (info.getSourceBillType() != null) {
                    String paramID = null;
                    SaleOrderInfo saleOrderInfo = null;
                    SaleOrderEntryCollection saleOrderEntryCollection = null;
                    SaleOrderEntryInfo saleOrderEntry = null;
                    int size = entryCollection.size();
                    for (int i = 0; i < size; ++i) {
                        entry = entryCollection.get(i);
                        coreBillType = entry.getCoreBillType();
                        String coreType = null;
                        if (coreBillType != null && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreType = coreBillType.getId().toString())) {
                            String key;
                            if (coreIds.length() > 0) {
                                coreIds.append(",");
                            }
                            coreIds.append(entry.getSaleOrder());
                            if (entry.getSaleOrderEntry() != null) {
                                if (coreEntryIds.length() > 0) {
                                    coreEntryIds.append(",");
                                }
                                coreEntryIds.append(entry.getSaleOrderEntry());
                                coreEntryIdsMap.put(entry.getSaleOrderEntry(), entry.getSaleOrderEntry());
                            }
                            if (saleOrdMap.containsKey(key = entry.getSaleOrder())) {
                                saleOrderInfo = (SaleOrderInfo)saleOrdMap.get(key);
                            } else {
                                selector.clear();
                                selector.add(new SelectorItemInfo("id"));
                                selector.add(new SelectorItemInfo("entries.id"));
                                selector.add(new SelectorItemInfo("entries.baseStatus"));
                                saleOrderInfo = iSaleOrder.getSaleOrderInfo((IObjectPK)new ObjectUuidPK(key), selector);
                                saleOrdMap.put(key, saleOrderInfo);
                            }
                            saleOrderEntryCollection = saleOrderInfo.getEntries();
                            saleOrderEntry = saleOrderEntryCollection.get((Object)BOSUuid.read((String)entry.getSaleOrderEntry()));
                            if (entry.getSaleOrgUnit() != null) {
                                ObjectUuidPK orgID = new ObjectUuidPK(entry.getSaleOrgUnit().getId());
                                if (paramMap.containsKey(orgID)) {
                                    paramID = (String)paramMap.get(orgID);
                                } else {
                                    paramID = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(entry.getSaleOrgUnit().getId()), (String)SCM_SALEISSUEBILL_AUDIT);
                                    paramMap.put(orgID, paramID);
                                }
                            }
                            if (!EntryBaseStatusEnum.CLOSED.equals((Object)saleOrderEntry.getBaseStatus()) || Boolean.valueOf(paramID).booleanValue()) continue;
                            connotAudit = false;
                        }
                        break;
                    }
                }
            }
        }
        if (postEntryIds.length() > 0) {
            PostRequisitionEntryCollection postEntryCollection = this.getPostRequisitionEntryCollection(ctx, postEntryIds.toString());
            int size = postEntryCollection.size();
            for (int i = 0; i < size; ++i) {
                PostRequisitionEntryInfo entryInfo = postEntryCollection.get(i);
                if (!entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) continue;
                conmotAuditByPostRequisition = false;
                break;
            }
        }
        if (!conmotAuditByPostRequisition) {
            throw new InvBizException(InvBizException.POSTREQUISITIONENTRYCLOSED_CONNOTAUDIT, new Object[]{invBillBaseInfo.getNumber(), ""});
        }
        if (coreIds.length() > 0 && coreEntryIdsMap.size() > 0 && isCanAuditNotReverse) {
            SaleOrderCollection saleorderCollection = this.getSaleOrderCollection(ctx, coreIds.toString());
            boolean isStartStrategy = this.isStartCreditStrategy(ctx, invBillBaseInfo);
            connotAudit = this.isSaleOrderClosed(saleorderCollection, coreEntryIdsMap, isStartStrategy);
        }
        if (!connotAudit) {
            throw new SCMBillException(SCMBillException.SALEORDERENTRYNOTAUDIT_CONNOTAUDIT, new Object[]{invBillBaseInfo.getNumber(), ""});
        }
    }

    private SaleOrderCollection getSaleOrderCollection(Context ctx, String coreIds) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.baseStatus"));
        sic.add(new SelectorItemInfo("entries.quantityUnCtrl"));
        viewInfo.setSelector(sic);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)coreIds, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
        SaleOrderCollection saleorderCollection = iSaleOrder.getSaleOrderCollection(viewInfo);
        return saleorderCollection;
    }

    private boolean isSaleOrderClosed(SaleOrderCollection soc, Map<String, String> coreEntryIdsMap, Boolean isStartCreditStategy) {
        SaleOrderInfo saleOrdInfo = null;
        SaleOrderEntryInfo entryInfo = null;
        int size = soc.size();
        for (int i = 0; i < size; ++i) {
            saleOrdInfo = soc.get(i);
            if (saleOrdInfo == null) continue;
            int count = saleOrdInfo.getEntries().size();
            for (int j = 0; j < count; ++j) {
                entryInfo = saleOrdInfo.getEntries().get(j);
                if (entryInfo == null || !coreEntryIdsMap.containsKey(entryInfo.getId().toString()) || !(!EntryBaseStatusEnum.AUDITED.equals((Object)entryInfo.getBaseStatus()) && !EntryBaseStatusEnum.CLOSED.equals((Object)entryInfo.getBaseStatus()) || EntryBaseStatusEnum.CLOSED.equals((Object)entryInfo.getBaseStatus()) && !entryInfo.isQuantityUnCtrl()) && (!EntryBaseStatusEnum.CLOSED.equals((Object)entryInfo.getBaseStatus()) || !entryInfo.isQuantityUnCtrl() || !isStartCreditStategy.booleanValue())) continue;
                return false;
            }
        }
        return true;
    }

    private PostRequisitionEntryCollection getPostRequisitionEntryCollection(Context ctx, String postEntryIds) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        viewInfo.setSelector(sic);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)postEntryIds, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        PostRequisitionEntryCollection postEntryCollection = PostRequisitionEntryFactory.getLocalInstance((Context)ctx).getPostRequisitionEntryCollection(viewInfo);
        return postEntryCollection;
    }

    private void checkBySaleissueBill(Context ctx, InvBillBaseInfo invBillBaseInfo, TransactionTypeInfo typeInfo) throws InvBizException, BOSException {
        SaleIssueEntryCollection entryCollection = (SaleIssueEntryCollection)((Object)invBillBaseInfo.get("entry"));
        boolean conmotAuditBySaleissueBill = true;
        StringBuffer saleissueEntryIds = new StringBuffer();
        if (!BillBaseStatusEnum.AUDITED.equals((Object)invBillBaseInfo.getBaseStatus()) && !invBillBaseInfo.isIsReversed() && invBillBaseInfo.getSourceBillType() != null) {
            BillTypeInfo sourceTypeInfo = invBillBaseInfo.getSourceBillType();
            SaleIssueEntryInfo entry = null;
            if (sourceTypeInfo != null && "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(sourceTypeInfo.getId().toString())) {
                int size = entryCollection.size();
                for (int i = 0; i < size; ++i) {
                    entry = entryCollection.get(i);
                    if (saleissueEntryIds.length() > 0) {
                        saleissueEntryIds.append(",");
                    }
                    saleissueEntryIds.append(entry.getSourceBillEntryId());
                }
            }
        }
        if (saleissueEntryIds.length() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)saleissueEntryIds.toString(), CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            SaleReturnsEntryCollection saleReturnsEntry = SaleReturnsEntryFactory.getLocalInstance((Context)ctx).getSaleReturnsEntryCollection(viewInfo);
            SaleReturnsEntryInfo entryInfo = null;
            int size = saleReturnsEntry.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = saleReturnsEntry.get(i);
                if (!EntryBaseStatusEnum.CLOSED.equals((Object)entryInfo.getBaseStatus())) continue;
                conmotAuditBySaleissueBill = false;
                break;
            }
        }
        if (!conmotAuditBySaleissueBill) {
            throw new InvBizException(InvBizException.SALERETURNBILLENTRYCLOSED_CONNOTAUDIT, new Object[]{invBillBaseInfo.getNumber(), ""});
        }
    }

    private boolean isCanAuditNotReverse(InvBillBaseInfo invBillBaseInfo, TransactionTypeInfo typeInfo) {
        boolean isCanAuditNotReverse = false;
        int bizDirection = typeInfo.getRiType().getBizDirection().getValue();
        isCanAuditNotReverse = !BillBaseStatusEnum.AUDITED.equals((Object)invBillBaseInfo.getBaseStatus()) && !invBillBaseInfo.isIsReversed() && invBillBaseInfo.getSourceBillType() != null && bizDirection == 1 && "d8e80652-010e-1000-e000-04c5c0a812202407435C".equals(invBillBaseInfo.getBizType().getId().toString());
        return isCanAuditNotReverse;
    }

    private void checkConsignReturn(Context ctx, InvBillBaseInfo invBillBaseInfo) throws EASBizException, BOSException {
        SaleIssueEntryCollection entryCollection;
        String riTypeId = null;
        TransactionTypeInfo transactionTypeInfo = invBillBaseInfo.getTransactionType();
        if (transactionTypeInfo != null && transactionTypeInfo.getRiType() == null) {
            transactionTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeInfo.getId().toString()));
        }
        riTypeId = transactionTypeInfo.getRiType().getId().toString();
        if (this.isBotpBill(invBillBaseInfo) && invBillBaseInfo.getBizType().getId().toString().equals("d8e80652-0114-1000-e000-04c5c0a812202407435C") && invBillBaseInfo.getTransactionType() != null && RecIssueTypeConstant.CONSIGNRT_RITYPEID.equals(riTypeId) && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(invBillBaseInfo.getSourceBillType().getId().toString()) && !CollectionUtil.isEmpty((AbstractObjectCollection)(entryCollection = (SaleIssueEntryCollection)((Object)invBillBaseInfo.get("entry"))))) {
            SaleIssueEntryInfo entry = null;
            HashSet<String> sourceIds = new HashSet<String>();
            int size = entryCollection.size();
            for (int i = 0; i < size; ++i) {
                entry = entryCollection.get(i);
                String sourceEntryId = entry.getSourceBillEntryId();
                if (null == sourceEntryId) continue;
                sourceIds.add(sourceEntryId);
            }
            if (sourceIds.size() > 0) {
                int i;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", sourceIds, CompareType.INCLUDE));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("unSettleBaseQty"));
                view.setFilter(filter);
                view.setSelector(sic);
                SaleIssueEntryCollection sec = SaleIssueEntryFactory.getLocalInstance(ctx).getSaleIssueEntryCollection(view);
                HashMap<String, SaleIssueEntryInfo> map = new HashMap<String, SaleIssueEntryInfo>();
                entry = null;
                SaleIssueEntryInfo sourceEntry = null;
                int size2 = sec.size();
                for (i = 0; i < size2; ++i) {
                    if (sec == null) continue;
                    entry = sec.get(i);
                    map.put(entry.getId().toString(), entry);
                }
                size2 = entryCollection.size();
                for (i = 0; i < size2; ++i) {
                    entry = entryCollection.get(i);
                    BigDecimal baseQty = entry.getBaseQty();
                    String sourceEntryId = entry.getSourceBillEntryId();
                    if (null == sourceEntryId || !map.containsKey(sourceEntryId)) continue;
                    sourceEntry = (SaleIssueEntryInfo)map.get(sourceEntryId);
                    BigDecimal unSettleBaseQty = sourceEntry.getUnSettleBaseQty();
                    if (baseQty.abs().compareTo(unSettleBaseQty) <= 0) continue;
                    throw new InvBizException(InvBizException.CONSIGNRT_QTY_INVALID);
                }
            }
        }
    }

    protected boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo) {
        boolean isBotpBill = false;
        if (scmBillBaseInfo != null && scmBillBaseInfo.getSourceBillType() != null) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    private boolean isHasBizFlow(InvBillBaseInfo info) throws BOSException {
        boolean isHasValue = false;
        if (info == null) {
            return isHasValue;
        }
        String tableName = "T_IM_SaleIssueEntry";
        HashSet<String> idSet = new HashSet<String>();
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            idSet.add(info.getEntries().getObject(i).get("id").toString());
        }
        if (SCMServerUtils.isExistsBizFlowField((Context)this.getCtx(), (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.getCtx(), (String)tableName, idSet)) {
            isHasValue = true;
        }
        return isHasValue;
    }

    private boolean isStartCreditStrategy(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        boolean isStart = false;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("entry.companyorgunit.id"));
        selector.add(new SelectorItemInfo("customer.iscredited"));
        SaleIssueBillInfo info = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(invBillBaseInfo.getId().toString()), selector);
        String companyId = info.getEntry().get(0).getCompanyOrgUnit().getId().toString();
        String paramValueStr = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(companyId), "G004");
        CreditParamInfo cInfo = CreditParamFacadeFactory.getLocalInstance((Context)ctx).getParameter(companyId);
        isStart = "true".equals(paramValueStr) && info.getCustomer().isIsCredited() && cInfo != null && (cInfo.isCtrlSaleOrderAmount() || cInfo.isCtrlSaleOrderTimeLimit() || cInfo.isCtrlIssuedAmount() || cInfo.isCtrlIssuedTimeLimit() || cInfo.isCtrlARAmount() || cInfo.isCtrlARTimeLimit() || cInfo.isCtrlPostbillAmount() || cInfo.isCtrlPostbillTimeLimit());
        return isStart;
    }
}

