/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;

public class CheckCompanyOrStorageOrgSameVRule
implements IVRule {
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return TransferOrderBillInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        TransferOrderBillInfo billInfo = (TransferOrderBillInfo)bean;
        TransferOrderBillEntryCollection entryCol = billInfo.getEntry();
        BizTypeInfo bizType = billInfo.getBizType();
        String requireSouId = billInfo.getReceiptStorageOrgUnit().getId().toString();
        String requireCouId = billInfo.getReceiptCompanyOrgUnit().getId().toString();
        String supplyCouId = billInfo.getIssueCompanyOrgUnit().getId().toString();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            TransferOrderBillEntryInfo entry = entryCol.get(i);
            if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType.getId().toString()) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType.getId().toString())) {
                if (entry.getReceiveStorageOrgUnit() != null && entry.getReceiveStorageOrgUnit().getId().toString().equals(requireSouId)) continue;
                throw new InvBizException(InvBizException.TRANORD_3SIDECHECK, new String[]{i + 1 + ""});
            }
            if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType.getId().toString()) && !"ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizType.getId().toString())) continue;
            String receiveCompanyOrgUnitID = "";
            if (null != entry.getReceiveCompanyOrgUnit()) {
                receiveCompanyOrgUnitID = entry.getReceiveCompanyOrgUnit().getId().toString();
            }
            String issueCompanyOrgUnitID = "";
            if (null != entry.getIssueCompanyOrgUnit()) {
                issueCompanyOrgUnitID = entry.getIssueCompanyOrgUnit().getId().toString();
            }
            boolean isRepeat = false;
            String[] arr = new String[]{requireCouId, supplyCouId, issueCompanyOrgUnitID, receiveCompanyOrgUnitID};
            for (int index = 0; index < arr.length; ++index) {
                String str = arr[index];
                for (int j = index + 1; j < arr.length; ++j) {
                    if (!str.equals(arr[j])) continue;
                    isRepeat = true;
                    break;
                }
                if (isRepeat) break;
            }
            if (!isRepeat) continue;
            throw new InvBizException(InvBizException.TRANORD_4SIDE_CHECK, new String[]{i + 1 + ""});
        }
    }
}

