/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillException;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckIsSameWarehouseVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckIsSameWarehouseVRule.class);

    public CheckIsSameWarehouseVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return StockTransferBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        if (bean instanceof StockTransferBillInfo) {
            this.validate4StockTransferBill((StockTransferBillInfo)bean);
        }
    }

    private void validate4StockTransferBill(StockTransferBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBizType().getId().toString().equals("d8e80652-0119-1000-e000-04c5c0a812202407435C") || billInfo.getBizType().getId().toString().equals("d8e80652-011b-1000-e000-04c5c0a812202407435C")) {
            StockTransferBillEntryCollection transferBillEntryCollection = billInfo.getEntry();
            StockTransferBillEntryInfo transferBillEntryInfo = null;
            for (int i = 0; i < transferBillEntryCollection.size(); ++i) {
                transferBillEntryInfo = transferBillEntryCollection.get(i);
                if (transferBillEntryInfo.getIssueWarehouse() == null || transferBillEntryInfo.getReceiptWarehouse() == null || !transferBillEntryInfo.getIssueWarehouse().getId().toString().equals(transferBillEntryInfo.getReceiptWarehouse().getId().toString())) continue;
                throw new StockTransferBillException(StockTransferBillException.SAME_WAREHOUSE, new Integer[]{i + 1});
            }
        }
    }
}

