/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckMaterialInventoryAncCompanyVrule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckMaterialInventoryAncCompanyVrule.class);

    public CheckMaterialInventoryAncCompanyVrule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return StockTransferBillInfo.class.isAssignableFrom(clazz) || TransferOrderBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        if (bean instanceof StockTransferBillInfo) {
            this.validate4StockTransferBill((StockTransferBillInfo)bean);
        } else if (bean instanceof TransferOrderBillInfo) {
            this.validate4TransferOrderBill((TransferOrderBillInfo)bean);
        }
    }

    private void validate4StockTransferBill(StockTransferBillInfo billInfo) throws InvBizException, BOSException, SCMBillException {
        boolean notInStorage;
        String bizType = null;
        if (billInfo.getBizType() == null) {
            throw new SCMBillException(SCMBillException.BIZTYPE_IS_NULL, new Object[]{billInfo.getNumber()});
        }
        bizType = billInfo.getBizType().getId().toString();
        boolean bl = notInStorage = !"d8e80652-0119-1000-e000-04c5c0a812202407435C".equals(bizType);
        if (notInStorage) {
            this.checkMaterialInventory(billInfo);
        }
        if (billInfo.getSourceBillType() == null || !"B2aZSVXaSx6qxdfekgCmrEY+1VI=".equalsIgnoreCase(billInfo.getSourceBillType().getId().toString())) {
            this.checkMaterialCompany(billInfo);
        }
    }

    private void validate4TransferOrderBill(TransferOrderBillInfo billInfo) throws BOSException, EASBizException {
        TransferOrderBillEntryInfo entryInfo = null;
        TransferOrderBillEntryCollection entryCol = billInfo.getEntry();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            MaterialInfo material = entryInfo.getMaterial();
            String materialId = entryInfo.getMaterial().getId().toString();
            String matNumber = material.getNumber();
            if (this.getMaterialCompanyInfo(materialId, billInfo.getIssueCompanyOrgUnit().getId().toString()) == null) {
                errorMsgList.add(new InvBizException(InvBizException.MATERIAL_MOVEISSUE_COM_NULL, new String[]{matNumber}).getMessage());
                continue;
            }
            if (this.getMaterialCompanyInfo(materialId, billInfo.getReceiptCompanyOrgUnit().getId().toString()) == null) {
                errorMsgList.add(new InvBizException(InvBizException.MATERIAL_MOVEIN_COM_NULL, new String[]{matNumber}).getMessage());
                continue;
            }
            if (this.getMaterialInventoryInfo(materialId, billInfo.getReceiptStorageOrgUnit().getId().toString()) == null) {
                errorMsgList.add(new InvBizException(InvBizException.MATERIAL_MOVEIN_INV_NULL, new String[]{matNumber}).getMessage());
                continue;
            }
            if (this.getMaterialCompanyInfo(materialId, entryInfo.getIssueCompanyOrgUnit().getId().toString()) == null) {
                errorMsgList.add(new InvBizException(InvBizException.MATERIAL_ISSUE_COM_NULL, new String[]{matNumber}).getMessage());
                continue;
            }
            if (this.getMaterialCompanyInfo(materialId, entryInfo.getReceiveCompanyOrgUnit().getId().toString()) == null) {
                errorMsgList.add(new InvBizException(InvBizException.MATERIAL_RECEIVE_COM_NULL, new String[]{matNumber}).getMessage());
                continue;
            }
            if (this.getMaterialInventoryInfo(materialId, entryInfo.getIssueStorageOrgUnit().getId().toString()) == null) {
                errorMsgList.add(new InvBizException(InvBizException.MATERIAL_ISSUE_SOU_NULL, new String[]{matNumber}).getMessage());
                continue;
            }
            if (this.getMaterialInventoryInfo(materialId, entryInfo.getReceiveStorageOrgUnit().getId().toString()) != null) continue;
            errorMsgList.add(new InvBizException(InvBizException.MATERIAL_RECEIVE_SOU_NULL, new String[]{matNumber}).getMessage());
        }
        if (errorMsgList.size() != 0) {
            StringBuilder errorMessage = new StringBuilder();
            for (String s : errorMsgList) {
                errorMessage.append(s).append("\n\r");
            }
            throw new InvBizException(InvBizException.COMMON, new String[]{errorMessage.substring(0, errorMessage.length() - 2)});
        }
    }

    private void checkMaterialCompany(StockTransferBillInfo billInfo) throws BOSException, InvBizException {
        CompanyOrgUnitInfo company = billInfo.getIssueCompanyOrgUnit();
        if (null == company) {
            return;
        }
        StockTransferBillEntryCollection col = billInfo.getEntry();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            MaterialCompanyInfoInfo matCompany;
            StockTransferBillEntryInfo entry = col.get(i);
            if (entry.getMaterial() == null || null != (matCompany = this.getMaterialCompanyInfo(entry.getMaterial().getId().toString(), company.getId().toString()))) continue;
            throw new InvBizException(InvBizException.MATERIALNOTFI, new Object[]{entry.getMaterial().getNumber()});
        }
    }

    private void checkMaterialInventory(StockTransferBillInfo billInfo) throws BOSException, InvBizException {
        StockTransferBillEntryCollection col = billInfo.getEntry();
        String souId = billInfo.getReceiptStorageOrgUnit().getId().toString();
        StringBuilder errors = new StringBuilder();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            MaterialInventoryInfo miInfo;
            StockTransferBillEntryInfo entry = col.get(i);
            MaterialInfo materialInfo = entry.getMaterial();
            if (materialInfo == null || null != (miInfo = this.getMaterialInventoryInfo(materialInfo.getId().toString(), souId))) continue;
            errors.append(materialInfo.getNumber()).append(",");
        }
        if (errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new InvBizException(InvBizException.MATERIAL_INVENTORY_UNAPPROVE, new Object[]{errors.toString()});
        }
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfo(String materialId, String couId) throws BOSException {
        if (this.getDataCache().contain(materialId + couId, DataTypeEnum.MATERIAL_COMPANY)) {
            return (MaterialCompanyInfoInfo)this.getDataCache().get(materialId + couId, DataTypeEnum.MATERIAL_COMPANY);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u7269\u6599\u7684\u8d22\u52a1\u9875\u7b7e\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7f13\u5b58\u3002class.method:com.kingdee.eas.scm.im.inv.vrule.CheckMaterialCompanyVRule.getMaterialCompanyInfo(String, String)");
        }
        IMaterialCompanyInfo iMaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialId));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)couId));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        entityView.setSelector(selector);
        MaterialCompanyInfoCollection col = iMaterialCompany.getMaterialCompanyInfoCollection(entityView);
        MaterialCompanyInfoInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        this.getDataCache().put(materialId + couId, (Object)info, DataTypeEnum.MATERIAL_COMPANY);
        return info;
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(String materialId, String souId) throws BOSException {
        assert (!StringUtils.isEmpty((String)souId));
        assert (StringUtils.isEmpty((String)materialId));
        if (this.getDataCache().contain(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY)) {
            return (MaterialInventoryInfo)this.getDataCache().get(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u7269\u6599\u5e93\u5b58\u9875\u7b7e\u65f6\uff0c\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7684\u6570\u636e\u7f13\u5b58\u3002class-method: com.kingdee.eas.scm.im.inv.vrule.CheckMaterialInventoryVRule.getMaterialInventoryInfo(String, String)");
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)souId));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isSequenceNo");
        entityViewInfo.setSelector(selector);
        MaterialInventoryCollection col = iMaterialInventory.getMaterialInventoryCollection(entityViewInfo);
        MaterialInventoryInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        this.getDataCache().put(materialId + souId, (Object)info, DataTypeEnum.MATERIAL_INVENTORY);
        return info;
    }
}

