/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import java.util.Calendar;

public class CheckPlanDateVRule
implements IVRule {
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return StockTransferBillInfo.class.isAssignableFrom(clazz) || TransferOrderBillInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SCMBillBaseInfo scmBillInfo = (SCMBillBaseInfo)bean;
        IObjectCollection entryCol = scmBillInfo.getEntries();
        StringBuilder entryIndex = new StringBuilder();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue entry = entryCol.getObject(i);
            if (entry.getDate("issuePlanDate") == null || entry.getDate("receiptPlanDate") == null || !entry.getDate("receiptPlanDate").before(entry.getDate("issuePlanDate"))) continue;
            Calendar inCal = Calendar.getInstance();
            Calendar outCal = Calendar.getInstance();
            inCal.setTime(entry.getDate("receiptPlanDate"));
            outCal.setTime(entry.getDate("issuePlanDate"));
            if (outCal.get(1) == inCal.get(1) && outCal.get(2) == inCal.get(2) && outCal.get(5) == inCal.get(5)) continue;
            entryIndex.append(i + 1).append(",");
        }
        if (entryIndex.length() > 0) {
            entryIndex.setLength(entryIndex.length() - 1);
            throw new InvBizException(InvBizException.MOVEINOUTPLANERROR, new Object[]{entryIndex});
        }
    }
}

