/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class CheckQtyValid
extends AbstractServerVRule {
    private String bizAction;

    public String getBizAction() {
        return this.bizAction;
    }

    public void setBizAction(String bizAction) {
        this.bizAction = bizAction;
    }

    public CheckQtyValid(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return StockTransferBillInfo.class.isAssignableFrom(clazz) || TransferOrderBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        String msg = null;
        String tableNames = "";
        BizActionEnum actionEnum = BizActionEnum.getEnum((String)this.bizAction);
        if (bean instanceof StockTransferBillInfo) {
            tableNames = "T_IM_STOCKTRANSFERBILLENTRY";
        } else if (bean instanceof TransferOrderBillInfo) {
            tableNames = "T_IM_TRANSFERORDERBILLENTRY";
        }
        if (!StringUtils.isEmpty((String)tableNames) && SCMServerUtils.isExistsBizFlowField((Context)this.getCtx(), (String)tableNames) && SCMServerUtils.isHasBizFlowValue((Context)this.getCtx(), (String)tableNames, (String)bean.getString("id"))) {
            return;
        }
        if (bean instanceof StockTransferBillInfo) {
            msg = this.checkQtyValid(this.getCtx(), (StockTransferBillInfo)bean, actionEnum);
        } else if (bean instanceof TransferOrderBillInfo) {
            msg = this.checkQtyValid(this.getCtx(), (TransferOrderBillInfo)bean, actionEnum);
        }
        if (!StringUtils.isEmpty(msg)) {
            throw new InvUpdateException(InvUpdateException.MOVEQTYVALID, new String[]{msg});
        }
    }

    private String checkQtyValid(Context ctx, StockTransferBillInfo billInfo, BizActionEnum action) throws EASBizException, BOSException {
        String msg;
        block22: {
            msg = "";
            if (billInfo.getSourceBillType() == null || billInfo.getSourceBillType().getId() == null) break block22;
            int size = billInfo.getEntry().size();
            StockTransferBillEntryInfo entry = null;
            if (size > 0) {
                entry = billInfo.getEntry().get(0);
                BigDecimal validQty = new BigDecimal("0.00");
                if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billInfo.getSourceBillType().getId().toString())) {
                    IPurInWarehsEntry ipe = PurInWarehsEntryFactory.getLocalInstance(ctx);
                    PurInWarehsEntryInfo purInWarehsEntryInfo = null;
                    IPurOrderEntry ipo = PurOrderEntryFactory.getLocalInstance((Context)ctx);
                    PurOrderEntryInfo purOrderEntryInfo = null;
                    BigDecimal purEntryQty = new BigDecimal("0.00");
                    BigDecimal ordEntryQty = new BigDecimal("0.00");
                    for (int i = 0; i < size; ++i) {
                        entry = billInfo.getEntry().get(i);
                        purEntryQty = entry.getQty();
                        purInWarehsEntryInfo = ipe.getPurInWarehsEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)entry.getSourceBillEntryId())));
                        if (!purInWarehsEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                            purEntryQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), purInWarehsEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                        }
                        if (purInWarehsEntryInfo.getCoreBillType() == null || !"510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(purInWarehsEntryInfo.getCoreBillType().getId().toString())) continue;
                        if (BizActionEnum.AUDIT.equals((Object)action)) {
                            validQty = purInWarehsEntryInfo.getQty().subtract(purInWarehsEntryInfo.getTotalMoveQty().add(purEntryQty));
                            if ((validQty = validQty.subtract(purInWarehsEntryInfo.getReverseQty())).signum() < 0) {
                                validQty = validQty.setScale(6, 4);
                                BigDecimal moreMoveQty = purInWarehsEntryInfo.getQty().subtract(purInWarehsEntryInfo.getTotalMoveQty()).subtract(purInWarehsEntryInfo.getReverseQty());
                                String tmp = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"TransferQtyIllegeal", (String[])new String[]{String.valueOf(i + 1), InvAppUtils.getDecimalFormatString(ctx, purEntryQty, purEntryQty.scale()), InvAppUtils.getDecimalFormatString(ctx, moreMoveQty, moreMoveQty.scale())});
                                msg = msg + "\n" + tmp;
                                continue;
                            }
                            if (msg.length() > 0) continue;
                            purInWarehsEntryInfo.setTotalMoveQty(purInWarehsEntryInfo.getTotalMoveQty().add(purEntryQty));
                            ordEntryQty = entry.getQty();
                            purOrderEntryInfo = ipo.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)purInWarehsEntryInfo.getPurOrderEntry())));
                            if (!purOrderEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                                ordEntryQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), purOrderEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                            }
                            purOrderEntryInfo.setTotalMoveQty(purOrderEntryInfo.getTotalMoveQty().add(ordEntryQty));
                            if (purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalReceiptQty()).signum() >= 0) {
                                purOrderEntryInfo.setCanInvMoveQty(purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalMoveQty()));
                            } else {
                                purOrderEntryInfo.setCanInvMoveQty(purOrderEntryInfo.getTotalReceiptQty().subtract(purOrderEntryInfo.getTotalMoveQty()));
                            }
                            ipe.update((IObjectPK)new ObjectUuidPK(purInWarehsEntryInfo.getId()), (CoreBaseInfo)purInWarehsEntryInfo);
                            ipo.update((IObjectPK)new ObjectUuidPK(purOrderEntryInfo.getId()), (CoreBaseInfo)purOrderEntryInfo);
                            continue;
                        }
                        purInWarehsEntryInfo.setTotalMoveQty(purInWarehsEntryInfo.getTotalMoveQty().subtract(purEntryQty));
                        ipe.update((IObjectPK)new ObjectUuidPK(purInWarehsEntryInfo.getId()), (CoreBaseInfo)purInWarehsEntryInfo);
                        ordEntryQty = entry.getQty();
                        purOrderEntryInfo = ipo.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)purInWarehsEntryInfo.getPurOrderEntry())));
                        if (!purOrderEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                            ordEntryQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), purOrderEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                        }
                        purOrderEntryInfo.setTotalMoveQty(purOrderEntryInfo.getTotalMoveQty().subtract(ordEntryQty));
                        if (purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalReceiptQty()).signum() >= 0) {
                            purOrderEntryInfo.setCanInvMoveQty(purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalMoveQty()));
                        } else {
                            purOrderEntryInfo.setCanInvMoveQty(purOrderEntryInfo.getTotalReceiptQty().subtract(purOrderEntryInfo.getTotalMoveQty()));
                        }
                        ipo.update((IObjectPK)new ObjectUuidPK(purOrderEntryInfo.getId()), (CoreBaseInfo)purOrderEntryInfo);
                    }
                } else if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(billInfo.getSourceBillType().getId().toString())) {
                    PurOrderEntryInfo purOrderEntryInfo = null;
                    IPurOrderEntry ipo = PurOrderEntryFactory.getLocalInstance((Context)ctx);
                    BigDecimal ordEntryQty = new BigDecimal("0");
                    for (int i = 0; i < size; ++i) {
                        entry = billInfo.getEntry().get(i);
                        ordEntryQty = entry.getQty();
                        purOrderEntryInfo = ipo.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)entry.getSourceBillEntryId())));
                        if (!purOrderEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                            ordEntryQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), purOrderEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                        }
                        validQty = purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalMoveQty().add(ordEntryQty));
                        if (BizActionEnum.AUDIT.equals((Object)action)) {
                            if (validQty.signum() < 0) {
                                validQty = validQty.setScale(6, 4);
                                BigDecimal moreMoveQty = purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalMoveQty());
                                String tmp = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"TransferQtyIllegeal", (String[])new String[]{String.valueOf(i + 1), InvAppUtils.getDecimalFormatString(ctx, ordEntryQty, ordEntryQty.scale()), InvAppUtils.getDecimalFormatString(ctx, moreMoveQty, moreMoveQty.scale())});
                                msg = msg + "\n" + tmp;
                                continue;
                            }
                            if (msg.length() > 0) continue;
                            purOrderEntryInfo.setTotalMoveQty(purOrderEntryInfo.getTotalMoveQty().add(ordEntryQty));
                            if (purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalReceiptQty()).signum() >= 0) {
                                purOrderEntryInfo.setCanInvMoveQty(purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalMoveQty()));
                            } else {
                                purOrderEntryInfo.setCanInvMoveQty(purOrderEntryInfo.getTotalReceiptQty().subtract(purOrderEntryInfo.getTotalMoveQty()));
                            }
                            ipo.update((IObjectPK)new ObjectUuidPK(purOrderEntryInfo.getId()), (CoreBaseInfo)purOrderEntryInfo);
                            continue;
                        }
                        purOrderEntryInfo.setTotalMoveQty(purOrderEntryInfo.getTotalMoveQty().subtract(ordEntryQty));
                        if (purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalReceiptQty()).signum() >= 0) {
                            purOrderEntryInfo.setCanInvMoveQty(purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalMoveQty()));
                        } else {
                            purOrderEntryInfo.setCanInvMoveQty(purOrderEntryInfo.getTotalReceiptQty().subtract(purOrderEntryInfo.getTotalMoveQty()));
                        }
                        ipo.update((IObjectPK)new ObjectUuidPK(purOrderEntryInfo.getId()), (CoreBaseInfo)purOrderEntryInfo);
                    }
                }
            }
        }
        return msg;
    }

    private String checkQtyValid(Context ctx, TransferOrderBillInfo billInfo, BizActionEnum action) throws EASBizException, BOSException {
        StringBuffer msg;
        block16: {
            msg = new StringBuffer();
            if (billInfo.getSourceBillType() == null || billInfo.getSourceBillType().getId() == null) break block16;
            int size = billInfo.getEntry().size();
            TransferOrderBillEntryInfo entry = null;
            if (size > 0) {
                entry = billInfo.getEntry().get(0);
                BigDecimal validQty = new BigDecimal("0.00");
                if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billInfo.getSourceBillType().getId().toString())) {
                    IPurInWarehsEntry ipe = PurInWarehsEntryFactory.getLocalInstance(ctx);
                    PurInWarehsEntryInfo piwEntryInfo = null;
                    BigDecimal purEntryQty = new BigDecimal("0.00");
                    for (int i = 0; i < size; ++i) {
                        entry = billInfo.getEntry().get(i);
                        purEntryQty = entry.getQty();
                        piwEntryInfo = ipe.getPurInWarehsEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)entry.getSourceBillEntryId())));
                        if (!piwEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                            purEntryQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), piwEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                        }
                        if (BizActionEnum.AUDIT.equals((Object)action)) {
                            validQty = piwEntryInfo.getQty().subtract(piwEntryInfo.getTotalMoveQty().add(purEntryQty));
                            validQty = validQty.subtract(piwEntryInfo.getReverseQty());
                            if ((validQty = validQty.setScale(6, 4)).signum() < 0) {
                                validQty = validQty.setScale(6, 4);
                                BigDecimal moreMoveQty = piwEntryInfo.getQty().subtract(piwEntryInfo.getTotalMoveQty()).subtract(piwEntryInfo.getReverseQty());
                                String tmp = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"TransferQtyIllegeal", (String[])new String[]{String.valueOf(i + 1), InvAppUtils.getDecimalFormatString(ctx, purEntryQty, purEntryQty.scale()), InvAppUtils.getDecimalFormatString(ctx, moreMoveQty, moreMoveQty.scale())});
                                msg.append("\n").append(tmp);
                                continue;
                            }
                            if (msg.length() > 0) continue;
                            piwEntryInfo.setTotalMoveQty(piwEntryInfo.getTotalMoveQty().add(purEntryQty));
                            ipe.update((IObjectPK)new ObjectUuidPK(piwEntryInfo.getId()), (CoreBaseInfo)piwEntryInfo);
                            continue;
                        }
                        piwEntryInfo.setTotalMoveQty(piwEntryInfo.getTotalMoveQty().subtract(purEntryQty));
                        ipe.update((IObjectPK)new ObjectUuidPK(piwEntryInfo.getId()), (CoreBaseInfo)piwEntryInfo);
                    }
                } else if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(billInfo.getSourceBillType().getId().toString())) {
                    PurOrderEntryInfo poEntryInfo = null;
                    IPurOrderEntry ipo = PurOrderEntryFactory.getLocalInstance((Context)ctx);
                    BigDecimal ordEntryQty = new BigDecimal("0");
                    for (int i = 0; i < size; ++i) {
                        entry = billInfo.getEntry().get(i);
                        ordEntryQty = entry.getQty();
                        poEntryInfo = ipo.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)entry.getSourceBillEntryId())));
                        if (!poEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                            ordEntryQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), poEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                        }
                        validQty = poEntryInfo.getQty().subtract(poEntryInfo.getTotalMoveQty().add(ordEntryQty));
                        if (BizActionEnum.AUDIT.equals((Object)action)) {
                            if (validQty.signum() < 0) {
                                validQty = validQty.setScale(6, 4);
                                BigDecimal moreMoveQty = poEntryInfo.getQty().subtract(poEntryInfo.getTotalMoveQty());
                                String tmp = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"TransferQtyIllegeal", (String[])new String[]{String.valueOf(i + 1), InvAppUtils.getDecimalFormatString(ctx, ordEntryQty, ordEntryQty.scale()), InvAppUtils.getDecimalFormatString(ctx, moreMoveQty, moreMoveQty.scale())});
                                msg.append("\n").append(tmp);
                                continue;
                            }
                            if (msg.length() > 0) continue;
                            poEntryInfo.setTotalMoveQty(poEntryInfo.getTotalMoveQty().add(ordEntryQty));
                            if (poEntryInfo.getQty().subtract(poEntryInfo.getTotalReceiptQty()).signum() >= 0) {
                                poEntryInfo.setCanInvMoveQty(poEntryInfo.getQty().subtract(poEntryInfo.getTotalMoveQty()));
                            } else {
                                poEntryInfo.setCanInvMoveQty(poEntryInfo.getTotalReceiptQty().subtract(poEntryInfo.getTotalMoveQty()));
                            }
                            ipo.update((IObjectPK)new ObjectUuidPK(poEntryInfo.getId()), (CoreBaseInfo)poEntryInfo);
                            continue;
                        }
                        poEntryInfo.setTotalMoveQty(poEntryInfo.getTotalMoveQty().subtract(ordEntryQty));
                        if (poEntryInfo.getQty().subtract(poEntryInfo.getTotalReceiptQty()).signum() >= 0) {
                            poEntryInfo.setCanInvMoveQty(poEntryInfo.getQty().subtract(poEntryInfo.getTotalMoveQty()));
                        } else {
                            poEntryInfo.setCanInvMoveQty(poEntryInfo.getTotalReceiptQty().subtract(poEntryInfo.getTotalMoveQty()));
                        }
                        ipo.update((IObjectPK)new ObjectUuidPK(poEntryInfo.getId()), (CoreBaseInfo)poEntryInfo);
                    }
                }
            }
        }
        return msg.toString();
    }
}

