/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.StockReqFacadeFactory;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.util.StringUtils;

public class CheckSrcBillStockReqAuditVRule
extends AbstractServerVRule {
    public CheckSrcBillStockReqAuditVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return TransferOrderBillInfo.class.isAssignableFrom(clazz) || StockReqInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        String tableNames = "";
        SCMBillBaseInfo billInfo = (SCMBillBaseInfo)bean;
        if (this.isBotpBill(billInfo, "MmEE6VBsR0KaUDQmebwhP0Y+1VI=")) {
            ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
            if (bean instanceof StockReqInfo) {
                tableNames = "T_IM_StockReqEntry";
            } else if (bean instanceof TransferOrderBillInfo) {
                tableNames = "T_IM_TRANSFERORDERBILLENTRY";
            }
            if (!StringUtils.isEmpty((String)tableNames) && SCMServerUtils.isExistsBizFlowField((Context)this.getCtx(), (String)tableNames) && SCMServerUtils.isHasBizFlowValue((Context)this.getCtx(), (String)tableNames, (String)bean.getString("id"))) {
                return;
            }
            StockReqFacadeFactory.getLocalInstance(this.getCtx()).checkSrcBillStockReqAudit((IObjectPK)pk, (IObjectValue)billInfo);
        }
    }

    protected boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo, String sourceBillTypeID) {
        boolean isBotpBill = false;
        if (this.isBotpBill(scmBillBaseInfo) && scmBillBaseInfo.getSourceBillType().getId().toString().equals(sourceBillTypeID)) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    protected boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo) {
        boolean isBotpBill = false;
        if (scmBillBaseInfo != null && scmBillBaseInfo.getSourceBillType() != null) {
            isBotpBill = true;
        }
        return isBotpBill;
    }
}

