/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberException;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CheckStockTransferSerialNumberVrule
extends AbstractServerVRule {
    public CheckStockTransferSerialNumberVrule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return StockTransferBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        StockTransferBillInfo billInfo = (StockTransferBillInfo)bean;
        this.serialNumVerify(this.getCtx(), billInfo);
    }

    private void serialNumVerify(Context ctx, StockTransferBillInfo billInfo) throws EASBizException, BOSException {
        StockTransferBillEntryCollection entryCol = billInfo.getEntry();
        int entrySize = entryCol.size();
        StockTransferBillEntryInfo entryInfo = null;
        MaterialSerialNumberInfo snInfo = null;
        MaterialInfo material = null;
        IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
        String[] materialIDs = new String[entrySize];
        String[] souIDs = new String[entrySize];
        String souID = "";
        souID = billInfo.getIssueStorageOrgUnit().getId().toString() == null ? null : billInfo.getIssueStorageOrgUnit().getId().toString();
        for (int i = 0; i < entrySize; ++i) {
            entryInfo = entryCol.get(i);
            materialIDs[i] = entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null ? null : entryInfo.getMaterial().getId().toString();
            souIDs[i] = souID;
        }
        Map<String, MaterialInventoryInfo> materialInventoryCol = this.getMaterialInventoryCollection(ctx, materialIDs, souIDs);
        MaterialSerialNumberInfo[] serialNumberInfos = new MaterialSerialNumberInfo[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            BigDecimal qty;
            entryInfo = entryCol.get(i);
            MaterialInventoryInfo miInfo = null;
            if (materialInventoryCol.get(entryInfo.getMaterial().getId().toString() + souID) != null) {
                miInfo = materialInventoryCol.get(entryInfo.getMaterial().getId().toString() + souID);
            }
            if (miInfo == null || !miInfo.isIsSequenceNo() || entryInfo == null) continue;
            snInfo = new MaterialSerialNumberInfo();
            snInfo.setBillID(billInfo.getId().toString());
            snInfo.setBillEntryID(entryInfo.getId().toString());
            snInfo.setBillType(billInfo.getBillType());
            snInfo.setBillNumber(billInfo.getNumber());
            snInfo.setBillEntrySeq(entryInfo.getSeq());
            snInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
            snInfo.setStorageOrgUnit(billInfo.getIssueStorageOrgUnit());
            snInfo.setMaterial(entryInfo.getMaterial());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("seqUnit.number"));
            sic.add(new SelectorItemInfo("seqUnit.name"));
            material = entryInfo.getMaterial();
            MeasureUnitInfo sNUnitInfo = material.getSeqUnit();
            if (sNUnitInfo == null && (sNUnitInfo = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId())).getSeqUnit()) == null) {
                return;
            }
            BigDecimal sNqty = qty = entryInfo.getQty();
            snInfo.setSnUnit(sNUnitInfo);
            snInfo.setSnQty(sNqty);
            snInfo.put("isSaleBack", false);
            serialNumberInfos[i] = snInfo;
        }
        this.stockCheckSNDup(ctx, snInfo);
    }

    private void stockCheckSNDup(Context ctx, MaterialSerialNumberInfo snInfo) throws BOSException, EASBizException {
        if (snInfo == null) {
            return;
        }
        String strMaterialID = snInfo.getMaterial().getId().toString();
        StringBuffer checkQtySame = new StringBuffer();
        IRowSet rsQtySame = null;
        try {
            checkQtySame.append("select count(B.fid) as fids from T_IV_MaterialSerialNumber A ").append(" LEFT OUTER JOIN T_IV_MaterialSerialNumberEntry B ON B.FParentID = A.FID where A.fbillid = '").append(snInfo.getBillID()).append("' and A.fbillentryid = '").append(snInfo.getBillEntryID()).append("'");
            String sqlCheckQtySame = checkQtySame.toString();
            rsQtySame = DbUtil.executeQuery((Context)ctx, (String)sqlCheckQtySame);
            while (rsQtySame.next()) {
                int snNum = rsQtySame.getInt("fids");
                if (snNum == snInfo.getSnQty().abs().intValue() || snNum == 0) continue;
                if (snInfo.getMaterial().getName() == null || snInfo.getMaterial().getName().length() == 0) {
                    MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(strMaterialID));
                    snInfo.setMaterial(material);
                }
                throw new SerialNumberException(SerialNumberException.SEQNUMNOTSAMEBILL, new String[]{snInfo.getMaterial().getName()});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected Map<String, MaterialInventoryInfo> getMaterialInventoryCollection(Context ctx, String[] materialIDS, String[] orgIDs) throws BOSException {
        if (null == materialIDS || null == orgIDs || materialIDS.length != orgIDs.length || materialIDS.length == 0) {
            return new HashMap<String, MaterialInventoryInfo>();
        }
        HashMap<String, MaterialInventoryInfo> matInventory = new HashMap<String, MaterialInventoryInfo>();
        EntityViewInfo view = new EntityViewInfo();
        MaterialInventoryInfo materialInventoryInfo = null;
        String key = "";
        FilterInfo filter = new FilterInfo();
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> orgUnitIdSet = new HashSet<String>();
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        if (materialIDS != null && orgIDs != null) {
            int size = materialIDS.length;
            for (int i = 0; i < size; ++i) {
                if (materialIDS[i] == null || orgIDs[i] == null) continue;
                materialIdSet.add(materialIDS[i].toString());
                orgUnitIdSet.add(orgIDs[i].toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("material", materialIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", orgUnitIdSet, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("isSequenceNo"));
            view.setSelector(sic);
            view.setFilter(filter);
            MaterialInventoryCollection coll = iMaterialInventory.getMaterialInventoryCollection(view);
            if (coll != null) {
                block1: for (int j = 0; j < coll.size(); ++j) {
                    materialInventoryInfo = coll.get(j);
                    for (int g = 0; g < materialIDS.length; ++g) {
                        if (materialInventoryInfo == null || materialInventoryInfo.getMaterial() == null || materialInventoryInfo.getOrgUnit() == null || !materialInventoryInfo.getMaterial().getId().toString().equals(materialIDS[g].toString()) || !materialInventoryInfo.getOrgUnit().getId().toString().equals(orgIDs[g].toString())) continue;
                        key = materialInventoryInfo.getMaterial().getId().toString() + materialInventoryInfo.getOrgUnit().getId().toString();
                        matInventory.put(key, materialInventoryInfo);
                        continue block1;
                    }
                }
            }
        }
        return matInventory;
    }
}

