/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.IReservationFacade;
import com.kingdee.eas.scm.im.reservation.IReservationSchema;
import com.kingdee.eas.scm.im.reservation.ReservationFacadeFactory;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaCollection;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaFactory;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSupplyObjectInfo;
import com.kingdee.eas.scm.im.reservation.ReservationTypeEnum;
import com.kingdee.eas.scm.im.reservation.app.AbstractBillReservationFacadeControllerBean;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingCollection;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingProperty;
import com.kingdee.eas.scm.im.reservation.model.ReservationModel;
import com.kingdee.eas.scm.im.reservation.service.BillAutoReservationService;
import com.kingdee.eas.scm.im.reservation.service.ReservationBillActionCheckService;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BillReservationFacadeControllerBean
extends AbstractBillReservationFacadeControllerBean {
    private static final long serialVersionUID = -1052209942193987817L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.BillReservationFacadeControllerBean");

    @Override
    protected List _doBillAutoReservation(Context ctx, IObjectCollection billCollection) throws BOSException, EASBizException {
        BillAutoReservationService autoReservationService = BillAutoReservationService.getInstance();
        return autoReservationService.doBillAutoReservation(ctx, billCollection);
    }

    @Override
    protected List _doBillAutoReservation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BillAutoReservationService autoReservationService = BillAutoReservationService.getInstance();
        return autoReservationService.doBillAutoReservation(ctx, model);
    }

    @Override
    public void _billAlterReservationCheck(Context ctx, IObjectCollection billCollection) throws BOSException, EASBizException {
        ReservationBillActionCheckService checkService = ReservationBillActionCheckService.getInstance();
        checkService.setBizAction(BizActionEnum.ALTER);
        checkService.doCheck(ctx, billCollection);
    }

    @Override
    public void _billActionReservationCheck(Context ctx, IObjectCollection billCollection, BizActionEnum bizAction) throws BOSException, EASBizException {
        ReservationBillActionCheckService checkService = ReservationBillActionCheckService.getInstance();
        checkService.setBizAction(bizAction);
        checkService.doCheck(ctx, billCollection);
    }

    @Override
    protected Map _doWebBillReservation(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        String bosType = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("billInfo").toString()).get("bosType").toString();
        IObjectValue model = this.getModelByJson(ctx, bosType, paramMap.get("billInfo").toString());
        ReservationSchemaInfo reservationSchemaInfo = (ReservationSchemaInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("reservationSchemaInfo").toString(), ReservationSchemaInfo.class);
        return this.getWebBillReservationData(ctx, model, reservationSchemaInfo);
    }

    @Override
    protected Map _webBillReservationCheck(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ReservationSchemaCollection reservationSchemaCol;
        HashMap result = new HashMap();
        boolean checkBill = false;
        if (paramMap.get("checkBill") != null) {
            checkBill = Boolean.parseBoolean(paramMap.get("checkBill").toString());
        }
        String bosType = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("billInfo").toString()).get("bosType").toString();
        IObjectValue model = this.getModelByJson(ctx, bosType, paramMap.get("billInfo").toString());
        if (checkBill) {
            ReservationSchemaInfo reservationSchemaInfo = (ReservationSchemaInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("reservationSchemaInfo").toString(), ReservationSchemaInfo.class);
            Map webBillReservationData = this.getWebBillReservationData(ctx, model, reservationSchemaInfo);
            if (webBillReservationData.get("error") != null) {
                result.put("error", webBillReservationData.get("error"));
                return result;
            }
            if (!this.canBillReservate(ctx, model, reservationSchemaInfo)) {
                result.put("error", ReservationUtil.getResourceString("BILL_NOT_MATCH_CANNOT_RESERVATION"));
                return result;
            }
        }
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return null;
        }
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = ReservationUtil.getEntityObjectInfo(ctx, model.getBOSType().toString());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (!CollectionUtil.isEmpty((IObjectCollection)entries)) {
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entry = entries.getObject(i);
                String id = entry.get("ID").toString();
                String reservationBillObjectId = (String)entry.get("reservationBillObjectId");
                if (StringUtil.isEmpty((String)reservationBillObjectId)) {
                    reservationBillObjectId = ReservationUtil.getReservationBillObjectID(ctx, id);
                }
                if (reservationBillObjectId == null || reservationBillObjectId.equals(id)) continue;
                result.put("error", ReservationUtil.getResourceString("UPPER_HAS_RESERVATION_CANNOT_RESERVATION"));
                return result;
            }
        }
        if (CollectionUtil.isEmpty((AbstractObjectCollection)(reservationSchemaCol = ReservationUtil.getBillReservationSchema(ctx, model, false)))) {
            result.put("error", ReservationUtil.getResourceString("NORESERVATIONSCHEMA_MATCH"));
            return result;
        }
        String cuID = ReservationUtil.getCuByModel(ctx, model);
        reservationSchemaCol = this.getRequireBillReservationSchema(ctx, bosType, cuID);
        if (reservationSchemaCol == null || reservationSchemaCol.size() == 0) {
            return result;
        }
        result.put("reservationCol", reservationSchemaCol);
        return result;
    }

    private Map getWebBillReservationData(Context ctx, IObjectValue billInfo, ReservationSchemaInfo reservationSchemaInfo) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        EntityViewInfo requireBillView = new EntityViewInfo();
        if (billInfo.get("id") != null) {
            FilterInfo requireBillFilter;
            try {
                requireBillFilter = reservationSchemaInfo.getFilterInfo();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (requireBillFilter == null) {
                requireBillFilter = new FilterInfo();
            }
            FilterInfo billFilter = new FilterInfo();
            billFilter.getFilterItems().add(new FilterItemInfo("id", (Object)billInfo.get("id").toString(), CompareType.EQUALS));
            requireBillFilter.mergeFilter(billFilter, "AND");
            requireBillView.setFilter(requireBillFilter);
        }
        String settingStr = reservationSchemaInfo.getBillTableSetting();
        BillReservationTableSettingCollection tableSettingCol = new BillReservationTableSettingCollection(settingStr);
        List<BillReservationTableSettingProperty> tabSettingCollection = tableSettingCol.getTabSettingCollection();
        ArrayList<Map<Object, Object>> columnList = new ArrayList<Map<Object, Object>>();
        Map<Object, Object> column = null;
        for (BillReservationTableSettingProperty property : tabSettingCollection) {
            column = new HashMap<String, Object>();
            column.put("filedName", property.getFieldName());
            String align = property.isNumeric() ? "right" : "left";
            column.put("align", align);
            column.put("isHide", !property.isShow());
            column.put("width", property.getColumnWidth());
            column.put("headName", property.getHeadName());
            columnList.add(column);
        }
        result.put("columnList", columnList);
        IReservationFacade iReservationFacade = ReservationFacadeFactory.getLocalInstance(ctx);
        int count = columnList.size();
        String billQueryPK = reservationSchemaInfo.getBillQueryPK();
        IRowSet rs = iReservationFacade.getBillRowSet(billQueryPK, requireBillView, (IObjectValue)reservationSchemaInfo);
        if (rs == null || rs.size() == 0) {
            result.put("error", ReservationUtil.getResourceString("NO_BILL_ENTRY_CAN_RESERVATION"));
            return result;
        }
        ArrayList columnModle = new ArrayList();
        HashMap<String, Object> rowData = null;
        ArrayList<String> idList = new ArrayList<String>();
        String entryFieldName = reservationSchemaInfo.getEntryIDFieldName();
        String baseQtyFieldName = reservationSchemaInfo.getBaseQtyFieldName();
        String assistQtyFieldName = reservationSchemaInfo.getAssistQtyFieldName();
        BigDecimal assistQty = BigDecimal.ZERO;
        try {
            while (rs.next()) {
                assistQty = BigDecimal.ZERO;
                rowData = new HashMap<String, Object>();
                for (int i = 0; i < count; ++i) {
                    String alias;
                    column = (Map)columnList.get(i);
                    String columnName = (String)column.get("filedName");
                    if (columnName.equals("id")) continue;
                    if ("baseStatus".equals(columnName)) {
                        if (rs.getObject("baseStatus") != null) {
                            rowData.put(columnName, BillBaseStatusEnum.getEnum((int)Integer.parseInt(rs.getObject("baseStatus").toString())).getAlias());
                        }
                    } else {
                        rowData.put(columnName, rs.getObject(columnName));
                    }
                    if (StringUtil.isEmpty((String)(alias = ReservationUtil.getEnumAlias(ReservationUtil.getQueryBizEnumInfo(billQueryPK, columnName), rs.getString(columnName))))) continue;
                    rowData.put("filedName", alias);
                }
                idList.add(rs.getString(entryFieldName));
                if (rs.getBigDecimal(assistQtyFieldName) != null) {
                    assistQty = rs.getBigDecimal(assistQtyFieldName);
                }
                rowData.put("auto_add_reservationBaseQty", BigDecimal.ZERO);
                rowData.put("auto_add_unReservationBaseQty", rs.getBigDecimal(baseQtyFieldName));
                rowData.put("auto_add_curReservationBaseQty", rs.getBigDecimal(baseQtyFieldName));
                rowData.put("auto_add_reservationAssistQty", BigDecimal.ZERO);
                rowData.put("auto_add_unReservationAssistQty", assistQty);
                rowData.put("auto_add_curReservationAssistQty", assistQty);
                columnModle.add(rowData);
            }
            column = this.buildAutoAddColumns("auto_add_reservationBaseQty", ReservationUtil.getResourceString("COL_TITLE_RESERVATIONBASEQTY"));
            columnList.add(0, column);
            column = this.buildAutoAddColumns("auto_add_unReservationBaseQty", ReservationUtil.getResourceString("COL_TITLE_UNRESERVATIONBASEQTY"));
            columnList.add(1, column);
            column = this.buildAutoAddColumns("auto_add_curReservationBaseQty", ResourceBase.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"24_BillReservationOptionUI", (Locale)ctx.getLocale()));
            columnList.add(2, column);
            column = this.buildAutoAddColumns("auto_add_reservationAssistQty", ReservationUtil.getResourceString("COL_TITLE_RESERVATIONASSISTQTY"));
            columnList.add(3, column);
            column = this.buildAutoAddColumns("auto_add_unReservationAssistQty", ReservationUtil.getResourceString("COL_TITLE_UNRESERVATIONASSISTQTY"));
            columnList.add(4, column);
            column = this.buildAutoAddColumns("auto_add_curReservationAssistQty", ReservationUtil.getResourceString("COL_TITLE_CURRESERVATIONASSISTQTY"));
            columnList.add(5, column);
            List list = iReservationFacade.getReservationData("FREQUIREBILLENTRYID", true, idList);
            ReservationModel reservationModel = null;
            Map curRowData = null;
            for (int j = columnModle.size() - 1; j >= 0; --j) {
                curRowData = (Map)columnModle.get(j);
                for (int i = list.size() - 1; i >= 0; --i) {
                    reservationModel = (ReservationModel)list.get(i);
                    assistQty = BigDecimal.ZERO;
                    if (curRowData.get(assistQtyFieldName) != null) {
                        assistQty = (BigDecimal)curRowData.get(assistQtyFieldName);
                    }
                    if (!reservationModel.getFieldValue().equals(curRowData.get(entryFieldName))) continue;
                    curRowData.put("auto_add_reservationBaseQty", reservationModel.getTotalReservationBaseQty());
                    curRowData.put("auto_add_unReservationBaseQty", ((BigDecimal)curRowData.get(baseQtyFieldName)).subtract(reservationModel.getTotalReservationBaseQty()));
                    curRowData.put("auto_add_curReservationBaseQty", ((BigDecimal)curRowData.get(baseQtyFieldName)).subtract(reservationModel.getTotalReservationBaseQty()));
                    curRowData.put("auto_add_reservationAssistQty", reservationModel.getTotalReservationAssistQty());
                    curRowData.put("auto_add_unReservationAssistQty", assistQty.subtract(reservationModel.getTotalReservationAssistQty()));
                    curRowData.put("auto_add_curReservationAssistQty", assistQty.subtract(reservationModel.getTotalReservationAssistQty()));
                    break;
                }
                if (((BigDecimal)curRowData.get("auto_add_unReservationBaseQty")).compareTo(BigDecimal.ZERO) > 0) continue;
                columnModle.remove(j);
            }
            result.put("columnModle", columnModle);
            if (columnModle.size() == 0) {
                result.put("error", ReservationUtil.getResourceString("NO_BILL_ENTRY_CAN_RESERVATION"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _getWebReservationPrecision(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String bosType = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("billInfoJson").toString()).get("bosType").toString();
        IObjectValue billInfo = this.getModelByJson(ctx, bosType, paramMap.get("billInfoJson").toString());
        ReservationSchemaInfo reservationSchemaInfo = (ReservationSchemaInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("reservationInfoJson").toString(), ReservationSchemaInfo.class);
        result.put("billInfo", billInfo);
        result.put("reservationInfo", reservationSchemaInfo);
        result.put("entryIdField", reservationSchemaInfo.getEntryIDFieldName());
        reservationSchemaInfo.getEntryMaterialIDFieldName();
        IObjectCollection entries = null;
        entries = (IObjectCollection)billInfo.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)billInfo.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = ReservationUtil.getEntityObjectInfo(billInfo.getBOSType().toString());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)billInfo.get(entryPropertyName);
        }
        if (entries == null) {
            return null;
        }
        String materialFied = reservationSchemaInfo.getEntryMaterialPropertyName();
        IObjectValue entry = null;
        HashSet<String> materialIDset = new HashSet<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.getObject(i);
            materialIDset.add(((MaterialInfo)entry.get(materialFied)).getId().toString());
        }
        IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("assistUnit.id"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", materialIDset, CompareType.INCLUDE));
        view.setSelector(sic);
        view.setFilter(filter);
        MaterialCollection materialCol = imaterial.getMaterialCollection(view);
        MaterialInfo materialInfo = null;
        HashSet<String> unitSet = new HashSet<String>();
        int size2 = materialCol.size();
        for (int i = 0; i < size2; ++i) {
            materialInfo = materialCol.get(i);
            if (materialInfo.getAssistUnit() != null) {
                unitSet.add(materialInfo.getAssistUnit().getId().toString());
            }
            unitSet.add(materialInfo.getBaseUnit().getId().toString());
        }
        if (unitSet.size() > 0) {
            EntityViewInfo assitView = new EntityViewInfo();
            FilterInfo assitFilterInfo = new FilterInfo();
            SelectorItemCollection assitSic = new SelectorItemCollection();
            assitSic.add(new SelectorItemInfo("material.id"));
            assitSic.add(new SelectorItemInfo("measureUnit.id"));
            assitSic.add(new SelectorItemInfo("baseConvsRate"));
            assitSic.add(new SelectorItemInfo("qtyPrecision"));
            assitFilterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialIDset, CompareType.INCLUDE));
            assitFilterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", unitSet, CompareType.INCLUDE));
            assitView.setFilter(assitFilterInfo);
            assitView.setSelector(assitSic);
            MultiMeasureUnitCollection multiMeasureUnitCol = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(assitView);
            HashMap<String, MultiMeasureUnitInfo> multiMeasureUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
            MultiMeasureUnitInfo unitInfo = null;
            int size3 = multiMeasureUnitCol.size();
            for (int i = 0; i < size3; ++i) {
                unitInfo = multiMeasureUnitCol.get(i);
                multiMeasureUnitMap.put(unitInfo.getMaterial().getId().toString() + unitInfo.getMeasureUnit().getId().toString(), unitInfo);
            }
            HashMap<String, Integer> baseQtyPrecisionMap = new HashMap<String, Integer>();
            HashMap<String, Integer> assitQtyPrecisionMap = new HashMap<String, Integer>();
            HashMap<String, BigDecimal> convertRateMap = new HashMap<String, BigDecimal>();
            int size4 = materialCol.size();
            for (int i = 0; i < size4; ++i) {
                materialInfo = materialCol.get(i);
                if (materialInfo.getAssistUnit() != null) {
                    unitInfo = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(materialInfo.getId().toString() + materialInfo.getAssistUnit().getId().toString());
                    assitQtyPrecisionMap.put(materialInfo.getId().toString(), unitInfo.getQtyPrecision());
                    convertRateMap.put(materialInfo.getId().toString(), unitInfo.getBaseConvsRate());
                }
                unitInfo = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(materialInfo.getId().toString() + materialInfo.getBaseUnit().getId().toString());
                baseQtyPrecisionMap.put(materialInfo.getId().toString(), unitInfo.getQtyPrecision());
            }
            result.put("baseQtyPrecisionMap", baseQtyPrecisionMap);
            result.put("assistQtyPrecisionMap", assitQtyPrecisionMap);
            result.put("convertRateMap", convertRateMap);
            result.put("materialFied", materialFied);
        }
        return result;
    }

    @Override
    protected Map _getWebReservationInvData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        IRowSetMetaData rowSetMetaData;
        HashMap<String, String> reqEntryMatchFilter = new HashMap<String, String>();
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        String bosType = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("billInfo").toString()).get("bosType").toString();
        IObjectValue billInfo = this.getModelByJson(ctx, bosType, paramMap.get("billInfo").toString());
        ReservationSchemaInfo reservationSchemaInfo = (ReservationSchemaInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("reservationSchemaInfo").toString(), ReservationSchemaInfo.class);
        ArrayList selectIds = (ArrayList)paramMap.get("selectedIds");
        FilterInfo invFilterInfo = new FilterInfo();
        if (paramMap.get("invFilter") != null) {
            String invFilterStr = paramMap.get("invFilter").toString();
            try {
                invFilterInfo = new FilterInfo(invFilterStr);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        EntityViewInfo invView = new EntityViewInfo();
        FilterInfo inventoryDataFilter = null;
        ReservationSupplyObjectInfo invSupplyInfo = reservationSchemaInfo.getInventoryEntry();
        if (invSupplyInfo != null) {
            try {
                inventoryDataFilter = invSupplyInfo.getFilterInfo();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (inventoryDataFilter == null) {
            inventoryDataFilter = new FilterInfo();
        }
        FilterInfo bilFilters = new FilterInfo();
        String materialField = reservationSchemaInfo.getEntryMaterialPropertyName();
        HashMap<String, String> material2EntryIDMap = new HashMap<String, String>();
        String curId = null;
        for (int i = 0; i < selectIds.size(); ++i) {
            curId = (String)selectIds.get(i);
            IObjectValue curEntryInfo = this.getEntryInfo(billInfo, curId);
            FilterInfo matchFilter = new FilterInfo();
            if (reservationSchemaInfo.getInventoryEntry() != null && reservationSchemaInfo.getInventoryEntry().getMatchPropertyCollection(reservationSchemaInfo.getBillFullName()) != null) {
                matchFilter = ReservationUtil.getMatchFilterInfo(reservationSchemaInfo.getInventoryEntry().getMatchPropertyCollection(reservationSchemaInfo.getBillFullName()), billInfo, curEntryInfo);
            }
            FilterInfo requireBillFilter = new FilterInfo();
            String curStorageUnitID = ReservationUtil.getRequireBillStorageUnit(reservationSchemaInfo, billInfo, curEntryInfo);
            String curMaterialID = ((MaterialInfo)curEntryInfo.get(materialField)).getId().toString();
            material2EntryIDMap.put(curMaterialID, curEntryInfo.get("id").toString());
            if (!StringUtil.isEmpty((String)curMaterialID)) {
                requireBillFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)curMaterialID, CompareType.EQUALS));
            }
            if (!StringUtil.isEmpty((String)curStorageUnitID)) {
                requireBillFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)curStorageUnitID, CompareType.EQUALS));
            }
            requireBillFilter.mergeFilter(matchFilter, "AND");
            if (bilFilters.getFilterItems() != null && bilFilters.getFilterItems().size() > 0) {
                bilFilters.mergeFilter(requireBillFilter, "OR");
            } else {
                bilFilters = (FilterInfo)requireBillFilter.clone();
            }
            FilterInfo eachFilter = new FilterInfo();
            eachFilter.mergeFilter(inventoryDataFilter, "and");
            eachFilter.mergeFilter(requireBillFilter, "and");
            eachFilter.mergeFilter(invFilterInfo, "and");
            reqEntryMatchFilter.put(curId, "where " + eachFilter.toString());
        }
        inventoryDataFilter.mergeFilter(bilFilters, "AND");
        inventoryDataFilter.mergeFilter(invFilterInfo, "AND");
        invView.setFilter(inventoryDataFilter);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.scm.im.reservation.InvReservationQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(invView);
        IRowSet rs = exec.executeQuery();
        try {
            rowSetMetaData = rs.getRowSetMetaData();
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        ArrayList<String> idList = new ArrayList<String>();
        String entryFieldName = "id";
        String baseQtyFieldName = "baseQty";
        String assistQtyFieldName = "curStoreAssistQty";
        ArrayList columnModle = new ArrayList();
        HashMap<String, Object> rowData = null;
        BigDecimal assistQty = BigDecimal.ZERO;
        try {
            while (rs.next()) {
                assistQty = BigDecimal.ZERO;
                rowData = new HashMap<String, Object>();
                int count = rowSetMetaData.getColumnCount();
                for (int i = 1; i < count; ++i) {
                    String columnName = rowSetMetaData.getColumnName(i);
                    rowData.put(columnName, rs.getObject(columnName));
                }
                columnModle.add(rowData);
                idList.add(rs.getString(entryFieldName));
                if (rs.getBigDecimal(assistQtyFieldName) != null) {
                    assistQty = rs.getBigDecimal(assistQtyFieldName);
                }
                rowData.put("requireEntryId", material2EntryIDMap.get(rs.getString("material.id")));
                rowData.put("reservationBaseQty", BigDecimal.ZERO);
                rowData.put("unreservationBaseQty", rs.getBigDecimal(baseQtyFieldName));
                rowData.put("curReservationBaseQty", BigDecimal.ZERO);
                rowData.put("reservationedAssitQty", BigDecimal.ZERO);
                rowData.put("unreservationedAssitQty", assistQty);
                rowData.put("curReservationedAssitQty", BigDecimal.ZERO);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IReservationFacade iReservationFacade = ReservationFacadeFactory.getLocalInstance(ctx);
        List list = iReservationFacade.getReservationData("FINVENTORYID", true, idList);
        ReservationModel reservationModel = null;
        Map curRowData = null;
        for (int j = columnModle.size() - 1; j >= 0; --j) {
            curRowData = (Map)columnModle.get(j);
            for (int i = list.size() - 1; i >= 0; --i) {
                reservationModel = (ReservationModel)list.get(i);
                if (!reservationModel.getFieldValue().equals(curRowData.get(entryFieldName))) continue;
                curRowData.put("reservationBaseQty", reservationModel.getTotalReservationBaseQty());
                curRowData.put("unreservationBaseQty", ((BigDecimal)curRowData.get(baseQtyFieldName)).subtract(reservationModel.getTotalReservationBaseQty()));
                curRowData.put("reservationedAssitQty", reservationModel.getTotalReservationAssistQty());
                curRowData.put("unreservationedAssitQty", ((BigDecimal)curRowData.get(assistQtyFieldName)).subtract(reservationModel.getTotalReservationAssistQty()));
                break;
            }
            if (((BigDecimal)curRowData.get("unreservationBaseQty")).compareTo(BigDecimal.ZERO) > 0) continue;
            columnModle.remove(j);
        }
        result.put("columnModle", columnModle);
        result.put("reqEntryMatchFilter", reqEntryMatchFilter);
        return result;
    }

    private IObjectValue getEntryInfo(IObjectValue billInfo, String curId) {
        IObjectCollection entries = null;
        entries = (IObjectCollection)billInfo.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)billInfo.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = ReservationUtil.getEntityObjectInfo(billInfo.getBOSType().toString());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)billInfo.get(entryPropertyName);
        }
        if (!CollectionUtil.isEmpty((IObjectCollection)entries)) {
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                if (!curId.equals(entries.getObject(i).get("id").toString())) continue;
                return entries.getObject(i);
            }
        }
        return null;
    }

    private Map<String, Object> buildAutoAddColumns(String filedName, String headName) {
        HashMap<String, Object> column = new HashMap<String, Object>();
        column.put("filedName", filedName);
        column.put("align", "right");
        column.put("isHide", false);
        column.put("width", 120);
        column.put("headName", headName);
        return column;
    }

    private boolean canBillReservate(Context ctx, IObjectValue billInfo, ReservationSchemaInfo reservationSchemaInfo) throws BOSException {
        FilterInfo requireBillFilter;
        EntityViewInfo requireBillView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        requireBillView.setSelector(sic);
        try {
            requireBillFilter = reservationSchemaInfo.getFilterInfo();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (requireBillFilter == null) {
            requireBillFilter = new FilterInfo();
        }
        FilterInfo billFilter = new FilterInfo();
        billFilter.getFilterItems().add(new FilterItemInfo("id", billInfo.get("id"), CompareType.EQUALS));
        requireBillFilter.mergeFilter(billFilter, "AND");
        requireBillView.setFilter(requireBillFilter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)reservationSchemaInfo.getBillQueryPK()));
        exec.option().isIgnorePermissionCheck = true;
        exec.setObjectView(requireBillView);
        return exec.getRowCount() != 0;
    }

    private ReservationSchemaCollection getRequireBillReservationSchema(Context ctx, String bosType, String cuID) throws EASBizException, BOSException {
        Object reservationSchemaInfo = null;
        IReservationSchema iReservationSchema = ReservationSchemaFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtil.isEmpty((String)bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)bosType, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isAutoSchema", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        if (cuID != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
        }
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        view.setFilter(filter);
        ReservationSchemaCollection col = iReservationSchema.getReservationSchemaCollection(view);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            reservationSchemaInfo = null;
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NORESERVATIONSCHEMA_MATCH"));
            SysUtil.abort();
        }
        return col;
    }

    private IObjectValue getModelByJson(Context ctx, String bosType, String json) throws BOSException {
        Class<?> clz;
        EntityObjectInfo entityInfo = CommonUtils.getEntityByBosType((String)bosType);
        try {
            clz = Class.forName(entityInfo.getObjectValueClass());
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        Object obj = JSONUtils.convertJsonToObject((Context)ctx, (String)json, clz);
        return (IObjectValue)obj;
    }

    @Override
    protected Map _addWebReservationInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        List reservationInfoList = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)paramMap.get("reservationInfos")), ArrayList.class);
        Map reservationMap = null;
        ReservationInfo reservationInfo = null;
        HashSet materialIdSet = new HashSet();
        int size = reservationInfoList.size();
        for (int i = 0; i < size; ++i) {
            reservationMap = (Map)reservationInfoList.get(i);
            materialIdSet.add(reservationMap.get("materialID"));
        }
        IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("assistUnit.id"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", materialIdSet, CompareType.INCLUDE));
        view.setSelector(sic);
        view.setFilter(filter);
        MaterialCollection materialCol = imaterial.getMaterialCollection(view);
        HashMap<String, MaterialInfo> materialMap = new HashMap<String, MaterialInfo>();
        int size2 = materialCol.size();
        for (int i = 0; i < size2; ++i) {
            materialMap.put(materialCol.get(i).getId().toString(), materialCol.get(i));
        }
        MaterialInfo curMaterialInfo = null;
        ArrayList<ReservationInfo> list = new ArrayList<ReservationInfo>();
        int size3 = reservationInfoList.size();
        for (int i = 0; i < size3; ++i) {
            reservationMap = (Map)reservationInfoList.get(i);
            reservationInfo = new ReservationInfo();
            curMaterialInfo = (MaterialInfo)materialMap.get(reservationMap.get("materialID"));
            reservationInfo.setId(BOSUuid.create((String)"8D307D69"));
            reservationInfo.setReservationType(ReservationTypeEnum.ReservationType_Bill);
            StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
            sou.setId(BOSUuid.read((String)reservationMap.get("storageOrgId").toString()));
            reservationInfo.setMaterial(curMaterialInfo);
            reservationInfo.setBaseUnit(curMaterialInfo.getBaseUnit());
            reservationInfo.setStorageOrg(sou);
            reservationInfo.setReservationBaseQty(new BigDecimal(reservationMap.get("reservationBaseQty").toString()));
            reservationInfo.setAssistUnit(curMaterialInfo.getAssistUnit());
            reservationInfo.setReservationAssistQty(new BigDecimal(reservationMap.get("reservationAssistQty").toString()));
            reservationInfo.setInventoryID((String)reservationMap.get("inventoryID"));
            reservationInfo.setRequireBillID((String)reservationMap.get("requireBillID"));
            reservationInfo.setRequireBillEntryID((String)reservationMap.get("requireBillEntryID"));
            reservationInfo.setRequireBillBosType((String)reservationMap.get("requireBillBosType"));
            if (reservationMap.get("reservationCustomerId") != null) {
                CustomerInfo customer = new CustomerInfo();
                customer.setId(BOSUuid.read((String)((String)reservationMap.get("reservationCustomerId"))));
                reservationInfo.setReservationCustomer(customer);
            }
            list.add(reservationInfo);
        }
        IReservation iReservation = ReservationFactory.getRemoteInstance();
        iReservation.doBillReservation(list, "");
        return null;
    }
}

