/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.IReservationSchema;
import com.kingdee.eas.scm.im.reservation.ReservationCollection;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaFactory;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSupplyObjectInfo;
import com.kingdee.eas.scm.im.reservation.ReservationTypeEnum;
import com.kingdee.eas.scm.im.reservation.app.AbstractReservationFacadeControllerBean;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingCollection;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingProperty;
import com.kingdee.eas.scm.im.reservation.model.ReservationConversionModel;
import com.kingdee.eas.scm.im.reservation.model.ReservationModel;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReservationFacadeControllerBean
extends AbstractReservationFacadeControllerBean {
    private static final long serialVersionUID = -8920557037241835128L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.ReservationFacadeControllerBean");
    static Map<String, IObjectValue> map = new HashMap<String, IObjectValue>();
    static Map<String, MetaDataPK> billQueryMap = new HashMap<String, MetaDataPK>(5);

    private List getNeedCancelReservationIDs(Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sql = new StringBuffer(512);
        sql.append("SELECT FID FROM T_IM_RESERVATION AS A ");
        sql.append(" WHERE dateadd(day,(SELECT ISNULL(B.FRESERVATIONDATE,0) FROM T_BD_MATERIALINVENTORY AS B WHERE B.FISRESERVATION=1 AND B.FRESERVATIONDATE>0 AND A.FSTORAGEORGID=B.FORGUNIT AND A.FMATERIALID=B.FMATERIALID), FRESERVATIONBEGINDATE) < now()");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                list.add(rs.getString("FID"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    @Override
    protected void _autoCancelReservation(Context ctx) throws EASBizException, BOSException {
        List idList = this.getNeedCancelReservationIDs(ctx);
        IReservation iReservation = ReservationFactory.getLocalInstance(ctx);
        iReservation.cancelReservation(idList);
    }

    @Override
    protected List _getReservationData(Context ctx, String fieldName, List idList) throws BOSException, EASBizException {
        return this._getReservationData(ctx, fieldName, true, idList);
    }

    @Override
    protected List _getReservationData(Context ctx, String fieldName, boolean isIncludeInvReservation, List idList) throws BOSException, EASBizException {
        ArrayList<ReservationModel> list = new ArrayList<ReservationModel>();
        if (StringUtil.isEmpty((String)fieldName) || CollectionUtil.isEmpty((Collection)idList)) {
            return list;
        }
        String sql = "";
        String ids = CollectionUtil.convertList2String((List)idList);
        sql = "SELECT FID,isnull(FTOTALRESERVATIONQTY, 0) AS FTOTALRESERVATIONQTY,isnull(FTOTALRESERVATIONBASEQTY, 0) AS FTOTALRESERVATIONBASEQTY,isnull(SUM(FRESERVATIONASSISTQTY), 0) as FTOTALRESERVATIONASSISTQTY FROM " + fieldName + " WHERE FID IN(" + ids + ")";
        sql = "SELECT " + fieldName + " as FID,isnull(SUM(FRESERVATIONQTY), 0) as FTOTALRESERVATIONQTY,isnull(SUM(FRESERVATIONBASEQTY), 0) as FTOTALRESERVATIONBASEQTY,isnull(SUM(FRESERVATIONASSISTQTY), 0) as FTOTALRESERVATIONASSISTQTY FROM T_IM_Reservation WHERE 1=1 ";
        sql = sql + " AND " + fieldName + " IN(" + ids + ") ";
        if (!isIncludeInvReservation) {
            sql = sql + "AND FINVENTORYID IS NULL ";
        }
        sql = sql + " GROUP BY " + fieldName + "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            ReservationModel reservationModel = null;
            while (rs.next()) {
                reservationModel = new ReservationModel(fieldName);
                reservationModel.setFieldValue(rs.getString("FID"));
                reservationModel.setTotalReservationQty(rs.getBigDecimal("FTOTALRESERVATIONQTY"));
                reservationModel.setTotalReservationBaseQty(rs.getBigDecimal("FTOTALRESERVATIONBASEQTY"));
                reservationModel.setTotalReservationAssistQty(rs.getBigDecimal("FTOTALRESERVATIONASSISTQTY"));
                list.add(reservationModel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    @Override
    protected IRowSet _getBillRowSet(Context ctx, String sql) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)sql)) {
            return null;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs;
    }

    @Override
    protected void _bill2BillReservation(Context ctx, List list) throws BOSException, EASBizException {
        this.billReservationConversion(ctx, list, "billReservation_B2B");
    }

    @Override
    protected void _object2BillReservation(Context ctx, List list) throws BOSException, EASBizException {
        this.billReservationConversion(ctx, list, "billReservation_O2B");
    }

    private void billReservationConversion(Context ctx, List list, String logItem) throws BOSException, EASBizException {
        if (CollectionUtil.isEmpty((Collection)list)) {
            return;
        }
        ReservationConversionModel conversionModel = null;
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<Object[]> batchList = new ArrayList<Object[]>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            conversionModel = (ReservationConversionModel)list.get(i);
            idList.add(conversionModel.getReservationId());
            Object[] arr = new Object[]{conversionModel.getReservationId(), conversionModel.getConversionBaseQty(), conversionModel.getConversionAssistQty()};
            batchList.add(arr);
        }
        ReservationUtil.lockReservationRecords(ctx, idList);
        String createTableSql = "CREATE TABLE RESERVATION_TEMP(FID VARCHAR(44),FReservationBaseQty NUMERIC(28,16) DEFAULT 0 NOT NULL,FReservationAssistQty NUMERIC(28,16))";
        String tempTable = KsqlUtil.createTempTable((Context)ctx, (String)createTableSql);
        String insertSql = "INSERT INTO " + tempTable + "(FID, FReservationBaseQty, FReservationAssistQty) values(?,?,?)";
        DbUtil.executeBatch((Context)ctx, (String)insertSql, batchList);
        try {
            String requireBillBosType = "";
            String requireBillEntryId = "";
            HashSet<String> set = new HashSet<String>();
            int size2 = list.size();
            for (int i = 0; i < size2; ++i) {
                conversionModel = (ReservationConversionModel)list.get(i);
                set.add(conversionModel.getReservationId());
            }
            if (CollectionUtil.isEmpty(set)) {
                return;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            IReservation iReservation = ReservationFactory.getLocalInstance(ctx);
            ReservationCollection reservationCol = iReservation.getReservationCollection(view);
            ReservationInfo newReservationInfo = null;
            CoreBaseCollection batchAddCol = new CoreBaseCollection();
            HashMap<String, ReservationSchemaInfo> map = new HashMap<String, ReservationSchemaInfo>();
            IReservationSchema iReservationSchema = ReservationSchemaFactory.getLocalInstance(ctx);
            int size3 = reservationCol.size();
            for (int i = 0; i < size3; ++i) {
                ReservationInfo reservationInfo = reservationCol.get(i);
                int nsize = list.size();
                for (int n = 0; n < nsize; ++n) {
                    conversionModel = (ReservationConversionModel)list.get(n);
                    if (reservationInfo.getId().toString().equals(conversionModel.getReservationId())) break;
                }
                if (conversionModel == null) continue;
                requireBillEntryId = conversionModel.getRequireBillEntryId();
                if (StringUtil.isEmpty((String)requireBillBosType) && !StringUtil.isEmpty((String)requireBillEntryId)) {
                    requireBillBosType = new ObjectUuidPK(requireBillEntryId).getObjectType().toString();
                }
                newReservationInfo = (ReservationInfo)reservationInfo.clone();
                newReservationInfo.setId(null);
                newReservationInfo.setObjectID(null);
                newReservationInfo.setReservationObject(null);
                newReservationInfo.setReservationType(ReservationTypeEnum.ReservationType_Bill);
                newReservationInfo.setRequireBillBosType(conversionModel.getRequireBillBosType());
                newReservationInfo.setRequireBillID(conversionModel.getRequireBillId());
                newReservationInfo.setRequireBillEntryID(conversionModel.getRequireBillEntryId());
                String billNum = this.getBillSomething(ctx, conversionModel.getRequireBillId(), "number");
                newReservationInfo.setRequireBillNum(billNum);
                String str = this.getBillSomething(ctx, conversionModel.getRequireBillEntryId(), "seq");
                if (!StringUtil.isEmpty((String)str)) {
                    int seq = Integer.parseInt(str);
                    newReservationInfo.setRequireBillEntrySeq(seq);
                }
                if (!StringUtil.isEmpty((String)conversionModel.getAssistUnitId())) {
                    MeasureUnitInfo assistUnit = new MeasureUnitInfo();
                    assistUnit.setId(BOSUuid.read((String)conversionModel.getAssistUnitId()));
                    newReservationInfo.setAssistUnit(assistUnit);
                }
                if (conversionModel.getConversionBaseQty().compareTo(reservationInfo.getReservationBaseQty()) >= 0) {
                    newReservationInfo.setReservationBaseQty(reservationInfo.getReservationBaseQty());
                    newReservationInfo.setReservationAssistQty(reservationInfo.getReservationAssistQty());
                } else {
                    newReservationInfo.setReservationBaseQty(conversionModel.getConversionBaseQty());
                    newReservationInfo.setReservationAssistQty(conversionModel.getConversionAssistQty());
                }
                if (!StringUtil.isEmpty((String)conversionModel.getReservationSchemaId())) {
                    String reservationSchemaId = conversionModel.getReservationSchemaId();
                    ReservationSchemaInfo reservationSchemaInfo = null;
                    if (map.containsKey(reservationSchemaId)) {
                        reservationSchemaInfo = (ReservationSchemaInfo)map.get(reservationSchemaId);
                    } else {
                        reservationSchemaInfo = iReservationSchema.getReservationSchemaInfo((IObjectPK)new ObjectUuidPK(reservationSchemaId));
                        map.put(reservationSchemaId, reservationSchemaInfo);
                    }
                    ReservationUtil.matchReservationEx(ctx, newReservationInfo, reservationSchemaInfo, this.getObjectById(ctx, conversionModel.getRequireBillId()), this.getObjectById(ctx, conversionModel.getRequireBillEntryId()));
                }
                batchAddCol.add((CoreBaseInfo)newReservationInfo);
            }
            Object[] pks = iReservation.saveBatchData(batchAddCol);
            String updateSql = "UPDATE T_IM_RESERVATION AS A SET (FRESERVATIONBASEQTY, FRESERVATIONASSISTQTY)";
            updateSql = updateSql + " =( SELECT A.FRESERVATIONBASEQTY-B.FRESERVATIONBASEQTY, A.FRESERVATIONASSISTQTY-B.FRESERVATIONASSISTQTY ";
            updateSql = updateSql + " FROM " + tempTable + " AS B WHERE B.FID=A.FID)";
            updateSql = updateSql + " WHERE A.FID IN (" + CollectionUtil.convertList2String(idList) + ")";
            DbUtil.execute((Context)ctx, (String)updateSql);
            updateSql = "DELETE FROM T_IM_RESERVATION WHERE FRESERVATIONBASEQTY<=0";
            updateSql = updateSql + " AND FID IN (" + CollectionUtil.convertList2String(idList) + ")";
            DbUtil.execute((Context)ctx, (String)updateSql);
            if (!StringUtil.isEmpty((String)requireBillBosType)) {
                EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(ctx, requireBillBosType);
                String tableName = entity.getTable().getName();
                PropertyInfo property = entity.getPropertyByName("reservationBillObjectId");
                if (property != null) {
                    String fieldName = property.getMappingField().getName();
                    updateSql = "UPDATE " + tableName + " AS BILL SET " + fieldName + "=FID WHERE 1=1";
                    if (!StringUtil.isEmpty((String)requireBillEntryId)) {
                        updateSql = updateSql + " AND EXISTS (SELECT 1 FROM T_IM_RESERVATION AS RESERVATION WHERE RESERVATION.FREQUIREBILLENTRYID=BILL.FID)";
                        updateSql = updateSql + " AND BILL.FID=?";
                        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{requireBillEntryId});
                    }
                }
            }
            if (ArrayUtil.isEmpty((Object[])pks)) {
                return;
            }
            Object pk = pks[0];
            if (pk != null) {
                ReservationInfo addReservationInfo = iReservation.getReservationInfo((IObjectPK)pk);
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"noLogForReservation", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(addReservationInfo.getId().toString()), (String)addReservationInfo.getRequireBillNum(), (String)logItem);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EASBizException(null);
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
        }
    }

    private IObjectValue getObjectById(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        IObjectValue model = null;
        if (map.containsKey(id)) {
            model = map.get(id);
        } else {
            ObjectUuidPK pk;
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            model = iDynamicObject.getValue((pk = new ObjectUuidPK(id)).getObjectType(), (IObjectPK)pk);
            if (model != null) {
                map.put(id, model);
            }
        }
        return model;
    }

    String getBillSomething(Context ctx, String id, String propertyName) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)id) || StringUtil.isEmpty((String)propertyName)) {
            return null;
        }
        String str = "";
        IObjectValue model = null;
        model = this.getObjectById(ctx, id);
        if (model != null) {
            str = model.getString(propertyName);
        }
        return str;
    }

    @Override
    protected OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, String permItem) throws BOSException, EASBizException {
        OrgUnitCollection collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)orgType, (String)permItem);
        return SCMGroupServerUtils.getOrgUnitInfosByType((Context)ctx, (OrgUnitCollection)collection, (OrgType)orgType);
    }

    @Override
    protected List _getBillReservationInfoList(Context ctx, List entryIdList) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)entryIdList)) {
            return list;
        }
        String entryId = entryIdList.get(0).toString();
        if (StringUtil.isEmpty((String)entryId)) {
            return list;
        }
        ObjectUuidPK pk = new ObjectUuidPK(entryId);
        pk.getObjectType();
        EntityObjectInfo entity = Util.getEntity((BOSObjectType)pk.getObjectType());
        String entryTable = "";
        if (entity != null && entity.getTable() != null) {
            entryTable = entity.getTable().getName();
        }
        if (StringUtil.isEmpty((String)entryTable)) {
            return list;
        }
        try {
            String ids = CollectionUtil.convertList2String((List)entryIdList);
            String sql = "SELECT FRESERVATIONOBJECTID, FRESERVATIONIN FROM " + entryTable + " WHERE FID IN(" + ids + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ReservationInfo info = null;
            while (rs.next()) {
                info = new ReservationInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected IRowSet _getBillRowSet(Context ctx, String billQueryPK, EntityViewInfo view, IObjectValue info) throws BOSException, EASBizException {
        String propertyName;
        SelectorItemCollection sic;
        List<BillReservationTableSettingProperty> tabSettingCollection;
        BillReservationTableSettingCollection tableSettingCol;
        if (StringUtil.isEmpty((String)billQueryPK)) {
            return null;
        }
        if (view == null) {
            view = new EntityViewInfo();
        }
        String sql = "";
        MetaDataPK md = null;
        if (billQueryMap.containsKey(billQueryPK)) {
            md = billQueryMap.get(billQueryPK);
        } else {
            md = MetaDataPK.create((String)billQueryPK);
            billQueryMap.put(billQueryPK, md);
        }
        IQueryDataAccess qda = QueryDataAccessFactory.getLocalInstance((Context)ctx);
        int max_row_count = 0;
        String orderByStr = "";
        if (info instanceof ReservationSchemaInfo) {
            ReservationSchemaInfo reservationSchemaInfo = (ReservationSchemaInfo)info;
            max_row_count = reservationSchemaInfo.getBillTableMaxRow();
            if (max_row_count <= 0) {
                max_row_count = 200;
            }
            orderByStr = reservationSchemaInfo.getOrderByStr();
            tableSettingCol = new BillReservationTableSettingCollection(reservationSchemaInfo.getBillTableSetting());
            tabSettingCollection = tableSettingCol.getTabSettingCollection();
            sic = new SelectorItemCollection();
            for (BillReservationTableSettingProperty property : tabSettingCollection) {
                propertyName = property.getFieldName();
                sic.add(new SelectorItemInfo(propertyName));
            }
            view.setSelector(sic);
            QueryExecuteOption option = new QueryExecuteOption();
            option.isIgnorePermissionCheck = true;
            sql = qda.getQuerySql((IMetaDataPK)md, view, option);
            if (sql.lastIndexOf("ORDER BY") > 1) {
                sql = sql.substring(0, sql.lastIndexOf("ORDER BY "));
            }
            Map<String, PropertyInfo> map = ReservationUtil.getEntityProperty(ctx, reservationSchemaInfo.getBillBosType());
            String orgField = reservationSchemaInfo.getOrgField();
            PropertyInfo property = map.get(orgField);
            String dbFieldName = property.getMappingField().getName();
            String fieldName = orgField.indexOf(".") > 1 ? reservationSchemaInfo.getEntryIDFieldName() : reservationSchemaInfo.getBillIDFieldName();
            String alias = ReservationUtil.getQueryFeildShowValue(billQueryPK, fieldName);
            String storageAlias = "";
            if (!StringUtil.isEmpty((String)alias)) {
                storageAlias = alias.split("\\.")[0] + "." + dbFieldName;
            }
            String materialAlias = ReservationUtil.getQueryFeildShowValue(billQueryPK, reservationSchemaInfo.getEntryMaterialIDFieldName());
            sql = sql + " AND " + materialAlias + " in (SELECT FMATERIALID FROM T_BD_MATERIALINVENTORY WHERE FISRESERVATION = 1 AND FOrgUnit=" + storageAlias + ")";
        }
        if (info instanceof ReservationSupplyObjectInfo) {
            ReservationSupplyObjectInfo supplyObject = (ReservationSupplyObjectInfo)info;
            max_row_count = supplyObject.getBillTableMaxRow();
            if (max_row_count <= 0) {
                max_row_count = 200;
            }
            orderByStr = supplyObject.getOrderByStr();
            tableSettingCol = new BillReservationTableSettingCollection(supplyObject.getBillTableSetting());
            tabSettingCollection = tableSettingCol.getTabSettingCollection();
            sic = new SelectorItemCollection();
            for (BillReservationTableSettingProperty property : tabSettingCollection) {
                propertyName = property.getFieldName();
                sic.add(new SelectorItemInfo(propertyName));
            }
            view.setSelector(sic);
            sql = qda.getQuerySql((IMetaDataPK)md, view);
            sql = "select top " + max_row_count + " " + sql.substring(6);
            if (sql.lastIndexOf("ORDER BY") > 1) {
                sql = sql.substring(0, sql.lastIndexOf("ORDER BY "));
            }
            Map<String, PropertyInfo> map = ReservationUtil.getEntityProperty(ctx, supplyObject.getBillBosType());
            String orgField = supplyObject.getOrgField();
            PropertyInfo property = map.get(orgField);
            String dbFieldName = property.getMappingField().getName();
            String fieldName = orgField.indexOf(".") > 1 ? supplyObject.getEntryIDFieldName() : supplyObject.getBillIDFieldName();
            String alias = ReservationUtil.getQueryFeildShowValue(billQueryPK, fieldName);
            String storageAlias = "";
            if (!StringUtil.isEmpty((String)alias)) {
                storageAlias = alias.split("\\.")[0] + "." + dbFieldName;
            }
            String materialAlias = ReservationUtil.getQueryFeildShowValue(billQueryPK, supplyObject.getEntryMaterialIDFieldName());
            sql = sql + " AND " + materialAlias + " in (SELECT FMATERIALID FROM T_BD_MATERIALINVENTORY WHERE FISRESERVATION = 1 AND FOrgUnit=" + storageAlias + ")";
        }
        if (!StringUtil.isEmpty((String)orderByStr)) {
            sql = sql + " ORDER BY " + orderByStr;
        }
        return this._getBillRowSet(ctx, sql);
    }

    private String parseQuerySql(Context ctx, String sql, ReservationSchemaInfo reservationSchemaInfo) {
        if (StringUtil.isEmpty((String)sql)) {
            return sql;
        }
        int max_row_count = 0;
        max_row_count = reservationSchemaInfo.getBillTableMaxRow();
        if (max_row_count <= 0) {
            max_row_count = 200;
        }
        if (sql.lastIndexOf("ORDER BY") > 1) {
            sql = sql.substring(0, sql.lastIndexOf("ORDER BY "));
        }
        StringBuffer needFields = new StringBuffer(512);
        String entryMaterialfield = "";
        String sqlFrom = "";
        String sqlFields = "";
        if (sql.split("FROM").length > 2) {
            sqlFrom = sql.substring(6);
            sqlFields = sql;
            String[] fieldArr = sqlFields.toUpperCase().split(",");
            try {
                int len = fieldArr.length;
                for (int i = 0; i < len; ++i) {
                    String field = fieldArr[i].substring(fieldArr[i].indexOf(" AS ") + 4).trim();
                    if (!(field = field.substring(1, field.length() - 1)).equalsIgnoreCase(reservationSchemaInfo.getEntryMaterialIDFieldName())) continue;
                    entryMaterialfield = fieldArr[i].substring(0, fieldArr[i].indexOf(" AS ")).trim();
                }
                if (needFields.length() > 0) {
                    needFields.delete(0, 1);
                }
            }
            catch (Exception i) {}
        } else {
            sqlFields = sql.substring(6, sql.indexOf("FROM"));
            sqlFrom = sql.substring(sql.indexOf("FROM"));
            String[] fieldArr = sqlFields.toUpperCase().split(",");
            try {
                BillReservationTableSettingCollection tableSettingCol = new BillReservationTableSettingCollection(reservationSchemaInfo.getBillTableSetting());
                List<BillReservationTableSettingProperty> tabSettingCollection = tableSettingCol.getTabSettingCollection();
                int len = fieldArr.length;
                for (int i = 0; i < len; ++i) {
                    String field = fieldArr[i].substring(fieldArr[i].indexOf(" AS ") + 4).trim();
                    field = field.substring(1, field.length() - 1);
                    for (BillReservationTableSettingProperty property : tabSettingCollection) {
                        String propertyName = property.getFieldName();
                        if (!propertyName.equalsIgnoreCase(field)) continue;
                        needFields.append("," + fieldArr[i]);
                        break;
                    }
                    if (!field.equalsIgnoreCase(reservationSchemaInfo.getEntryMaterialIDFieldName())) continue;
                    entryMaterialfield = fieldArr[i].substring(0, fieldArr[i].indexOf(" AS ")).trim();
                }
                if (needFields.length() > 0) {
                    needFields.delete(0, 1);
                }
            }
            catch (Exception tableSettingCol) {
                // empty catch block
            }
        }
        String realSql = "";
        realSql = needFields.length() > 0 ? "SELECT TOP " + max_row_count + needFields.toString() + " " + sqlFrom : "SELECT TOP " + max_row_count + " " + sqlFrom;
        if (!StringUtil.isEmpty((String)entryMaterialfield)) {
            String orgField = null;
            String dbFieldName = null;
            String billQuery = null;
            String fieldName = "";
            String tableAlias = "";
            Map<String, PropertyInfo> map = ReservationUtil.getEntityProperty(ctx, reservationSchemaInfo.getBillBosType());
            orgField = reservationSchemaInfo.getOrgField();
            PropertyInfo property = map.get(orgField);
            dbFieldName = property.getMappingField().getName();
            billQuery = reservationSchemaInfo.getBillQueryPK();
            fieldName = orgField.indexOf(".") > 1 ? reservationSchemaInfo.getEntryIDFieldName() : reservationSchemaInfo.getBillIDFieldName();
            tableAlias = ReservationUtil.getQueryPropertyParentAlias(billQuery, fieldName);
            tableAlias = "\"" + tableAlias + "\"";
            dbFieldName = tableAlias + "." + dbFieldName;
            realSql = realSql + " AND " + entryMaterialfield + " in (SELECT FMATERIALID FROM T_BD_MATERIALINVENTORY WHERE FISRESERVATION = 1 AND FOrgUnit=" + dbFieldName + ")";
        }
        String orderByStr = "";
        orderByStr = reservationSchemaInfo.getOrderByStr();
        if (!StringUtil.isEmpty((String)orderByStr)) {
            realSql = realSql + " ORDER BY " + orderByStr;
        }
        return realSql;
    }

    private String parseQuerySql(Context ctx, String sql, ReservationSupplyObjectInfo supplyObject) {
        if (StringUtil.isEmpty((String)sql)) {
            return sql;
        }
        int max_row_count = 0;
        max_row_count = supplyObject.getBillTableMaxRow();
        if (max_row_count <= 0) {
            max_row_count = 200;
        }
        if (sql.lastIndexOf("ORDER BY") > 1) {
            sql = sql.substring(0, sql.lastIndexOf("ORDER BY "));
        }
        StringBuffer needFields = new StringBuffer(512);
        String entryMaterialfield = "";
        String sqlFrom = "";
        String sqlFields = "";
        if (sql.split("FROM").length > 2) {
            sqlFrom = sql.substring(6);
            sqlFields = sql;
            String[] fieldArr = sqlFields.toUpperCase().split(",");
            try {
                int len = fieldArr.length;
                for (int i = 0; i < len; ++i) {
                    String field = fieldArr[i].substring(fieldArr[i].indexOf(" AS ") + 4).trim();
                    if (!(field = field.substring(1, field.length() - 1)).equalsIgnoreCase(supplyObject.getEntryMaterialIDFieldName())) continue;
                    entryMaterialfield = fieldArr[i].substring(0, fieldArr[i].indexOf(" AS ")).trim();
                }
                if (needFields.length() > 0) {
                    needFields.delete(0, 1);
                }
            }
            catch (Exception i) {}
        } else {
            sqlFields = sql.substring(6, sql.indexOf("FROM"));
            sqlFrom = sql.substring(sql.indexOf("FROM"));
            String[] fieldArr = sqlFields.toUpperCase().split(",");
            try {
                BillReservationTableSettingCollection tableSettingCol = new BillReservationTableSettingCollection(supplyObject.getBillTableSetting());
                List<BillReservationTableSettingProperty> tabSettingCollection = tableSettingCol.getTabSettingCollection();
                int len = fieldArr.length;
                for (int i = 0; i < len; ++i) {
                    String field = fieldArr[i].substring(fieldArr[i].indexOf(" AS ") + 4).trim();
                    field = field.substring(1, field.length() - 1);
                    for (BillReservationTableSettingProperty property : tabSettingCollection) {
                        String propertyName = property.getFieldName();
                        if (!propertyName.equalsIgnoreCase(field)) continue;
                        needFields.append("," + fieldArr[i]);
                        break;
                    }
                    if (!field.equalsIgnoreCase(supplyObject.getEntryMaterialIDFieldName())) continue;
                    entryMaterialfield = fieldArr[i].substring(0, fieldArr[i].indexOf(" AS ")).trim();
                }
                if (needFields.length() > 0) {
                    needFields.delete(0, 1);
                }
            }
            catch (Exception tableSettingCol) {
                // empty catch block
            }
        }
        String realSql = "";
        realSql = needFields.length() > 0 ? "SELECT TOP " + max_row_count + needFields.toString() + " " + sqlFrom : "SELECT TOP " + max_row_count + " " + sqlFrom;
        if (!StringUtil.isEmpty((String)entryMaterialfield)) {
            String orgField = null;
            String dbFieldName = null;
            String billQuery = null;
            String fieldName = "";
            String tableAlias = "";
            Map<String, PropertyInfo> map = ReservationUtil.getEntityProperty(ctx, supplyObject.getBillBosType());
            orgField = supplyObject.getOrgField();
            PropertyInfo property = map.get(orgField);
            dbFieldName = property.getMappingField().getName();
            billQuery = supplyObject.getBillQueryPK();
            fieldName = orgField.indexOf(".") > 1 ? supplyObject.getEntryIDFieldName() : supplyObject.getBillIDFieldName();
            tableAlias = ReservationUtil.getQueryPropertyParentAlias(billQuery, fieldName);
            tableAlias = "\"" + tableAlias + "\"";
            dbFieldName = tableAlias + "." + dbFieldName;
            realSql = realSql + " AND " + entryMaterialfield + " in (SELECT FMATERIALID FROM T_BD_MATERIALINVENTORY WHERE FISRESERVATION = 1 AND FOrgUnit=" + dbFieldName + ")";
        }
        String orderByStr = "";
        orderByStr = supplyObject.getOrderByStr();
        if (!StringUtil.isEmpty((String)orderByStr)) {
            realSql = realSql + " ORDER BY " + orderByStr;
        }
        return realSql;
    }
}

