/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.im.reservation.IReservationSchema;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaCollection;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaFactory;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.app.AbstractReservationSchemaControllerBean;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class ReservationSchemaControllerBean
extends AbstractReservationSchemaControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected List _setState(Context ctx, List pks, UseStatusEnum state) throws BOSException, EASBizException {
        ArrayList<InvReservationException> list = new ArrayList<InvReservationException>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(pks);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ReservationSchemaCollection col = this.getReservationSchemaCollection(ctx, view);
        if (col == null || col.size() == 0) {
            return list;
        }
        String permissionItem = 1 == state.getValue() ? "reservationSchema_enable" : "reservationSchema_disable";
        this.checkCUPermission(ctx, permissionItem);
        ArrayList<String> allowList = new ArrayList<String>();
        StringBuffer errors = new StringBuffer(20);
        ReservationSchemaInfo reservationSchema = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            reservationSchema = col.get(i);
            if (2 == state.getValue() && 2 == reservationSchema.getState().getValue()) {
                errors.append("," + reservationSchema.getNumber());
                list.add(new InvReservationException(InvReservationException.RESERVATIONSCHEMA_ISINACTIVED, new Object[]{reservationSchema.getNumber()}));
                continue;
            }
            if (1 == state.getValue() && 1 == reservationSchema.getState().getValue()) {
                errors.append("," + reservationSchema.getNumber());
                list.add(new InvReservationException(InvReservationException.RESERVATIONSCHEMA_ISACTIVED, new Object[]{reservationSchema.getNumber()}));
                continue;
            }
            if (1 == state.getValue() && reservationSchema.isIsAutoSchema() && this.checkHasAutoSchema(ctx, reservationSchema.getBillBosType())) {
                list.add(new InvReservationException(InvReservationException.REQUIREBILL_HAS_AUTO_RESERVATION, new Object[]{reservationSchema.getNumber()}));
                continue;
            }
            if (reservationSchema.isIsAutoSchema()) {
                String sql = "update T_IM_ReservationSchema set fstate=" + state.getValue() + " where fid='" + reservationSchema.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            } else {
                allowList.add(reservationSchema.getId().toString());
            }
            reservationSchema.setState(state);
        }
        if (allowList.size() > 0) {
            String sql = "update T_IM_ReservationSchema set fstate=" + state.getValue() + " where fid in(" + CollectionUtil.convertList2String(allowList) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        return list;
    }

    private void checkCUPermission(Context ctx, String permissionItem) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ctrlUnitInfo.getId());
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)ctx);
        ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permissionItem);
    }

    private boolean checkHasAutoSchema(Context ctx, String billBosType) throws BOSException, EASBizException {
        IReservationSchema iReservation = ReservationSchemaFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)billBosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoSchema", (Object)1, CompareType.EQUALS));
        CtrlUnitInfo cu = null;
        cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (cu != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        ReservationSchemaCollection col = iReservation.getReservationSchemaCollection(view);
        return !CollectionUtil.isEmpty((AbstractObjectCollection)col);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = null;
        coreBaseInfo = (CoreBaseInfo)model;
        super._update(ctx, pk, (IObjectValue)coreBaseInfo);
    }

    protected CtrlUnitInfo getCU(Context ctx, ObjectBaseInfo model) {
        CtrlUnitInfo cu = null;
        cu = model.getCU() != null ? model.getCU() : ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return cu;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkExist(ctx, pk);
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("state"));
        sics.add(new SelectorItemInfo("scheduled"));
        ReservationSchemaInfo reservationSchemaInfo = this.getReservationSchemaInfo(ctx, pk, sics);
        if (reservationSchemaInfo.isScheduled()) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"SCHEDULED_SCHEMA_CANNOT_DELETE", (Locale)ctx.getLocale());
            throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{msg});
        }
        if (reservationSchemaInfo.getState() != UseStatusEnum.SAVED) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"RESERVATIONSCHEMA_ISNOT_SAVESTATE_CANNOT_DELETE", (Locale)ctx.getLocale());
            throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{msg});
        }
        super._delete(ctx, pk);
    }

    private void checkExist(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (!this.exists(ctx, pk)) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND", (Locale)ctx.getLocale());
            throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{msg});
        }
    }
}

