/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.ISCMBizChainParams;
import com.kingdee.eas.scm.common.SCMBizChainParamsFactory;
import com.kingdee.eas.scm.common.app.bizprocess.processor.AbstractSCMBusinessProcessor;
import com.kingdee.eas.scm.im.reservation.processor.ProcessorUtil;
import com.kingdee.eas.scm.im.reservation.service.BillAutoReservationService;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class BillAutoReservationProcessor
extends AbstractSCMBusinessProcessor {
    private static final long serialVersionUID = 4757142262178131067L;
    BillAutoReservationService billAutoReservationService = null;

    public BillAutoReservationProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public BillAutoReservationProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public BillAutoReservationProcessor(ExecuteContext executeContext) {
        super(executeContext);
        this.billAutoReservationService = BillAutoReservationService.getInstance();
    }

    protected final void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ISCMBizChainParams iSCMBizChainParams = SCMBizChainParamsFactory.getLocalInstance((Context)this.ctx);
        boolean isStartUsed = iSCMBizChainParams.isStartUsed(this.bosType.toString(), this.batchAction.getBizAction(), "BillAutoReservationProcessor");
        if (!isStartUsed) {
            return;
        }
        if (this.billAutoReservationService == null) {
            this.billAutoReservationService = BillAutoReservationService.getInstance();
        }
        IObjectCollection collection = batchResults.getObjCollection();
        collection = ProcessorUtil.getBatchObjectCollection(this.ctx, batchResults);
        if (collection == null) {
            return;
        }
        IObjectValue model = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            model = collection.getObject(i);
            List<EASBizException> autoReservationExceptionList = this.billAutoReservationService.doBillAutoReservation(this.ctx, model);
            if (CollectionUtil.isEmpty(autoReservationExceptionList)) continue;
            List<EASBizException> list = new ArrayList<EASBizException>();
            if (this.ctx.get((Object)"CTX_BATCHACTION") != null && this.ctx.get((Object)"CTX_BATCHACTION") instanceof List) {
                list = (List)this.ctx.get((Object)"CTX_BATCHACTION");
                list.addAll(autoReservationExceptionList);
            } else {
                list = new ArrayList();
                list.addAll(autoReservationExceptionList);
            }
            this.ctx.put((Object)"CTX_BATCHACTION", list);
        }
    }
}

