/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.invconfig.AbstractBillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.IBillInventoryConfig;
import com.kingdee.eas.scm.im.inv.invconfig.util.CompareValueUtil;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReservationBalanceUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.reservation.util.ReservationBalanceUtil");
    static Map<String, BillInventoryConfigInfo> billConfigMap = new HashMap<String, BillInventoryConfigInfo>();
    private static Map<String, IObjectValue> storeTypeMap = new HashMap<String, IObjectValue>();
    private static StoreTypeInfo storeTypeInfo = null;
    private static Map<String, IObjectValue> linkPropertyMap = new HashMap<String, IObjectValue>();

    public static BillInventoryConfigInfo getBillBalanceConfig(Context ctx, IObjectValue model) throws BOSException {
        if (model == null || model.getBOSType() == null) {
            return null;
        }
        String bosType = model.getBOSType().toString();
        BillInventoryConfigInfo config = null;
        if (billConfigMap.containsKey(bosType)) {
            return billConfigMap.get(bosType);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        SorterItemCollection sic = new SorterItemCollection();
        sic.add(new SorterItemInfo("number"));
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sic);
        IBillInventoryConfig iBillConfig = ctx == null ? BillInventoryConfigFactory.getRemoteInstance() : BillInventoryConfigFactory.getLocalInstance(ctx);
        BillInventoryConfigCollection col = iBillConfig.getBillInventoryConfigCollection(viewInfo);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            config = col.get(i);
            if (!ReservationBalanceUtil.isMatch(config, model)) continue;
            billConfigMap.put(bosType, config);
            return config;
        }
        return null;
    }

    private static boolean isMatch(BillInventoryConfigInfo info, IObjectValue billInfo) {
        if (info == null) {
            return false;
        }
        if (StringUtil.isEmpty((String)info.getFilter())) {
            return true;
        }
        boolean isMatch = true;
        try {
            FilterInfo filter = new FilterInfo(info.getFilter());
            isMatch = CompareValueUtil.isMatch(filter, billInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return isMatch;
    }

    public static boolean isBillConfigMatched(IObjectValue billInfo, BillInventoryConfigInfo configInfo) {
        boolean isMatach = false;
        return isMatach;
    }

    public static String matchInventoryBalance(Context ctx, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        if (model == null || model.getBOSType() == null) {
            return null;
        }
        AbstractBillInventoryConfigInfo config = null;
        if (config == null) {
            return null;
        }
        BillInventoryConfigEntryCollection configEntries = config.getEntry();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)configEntries)) {
            return null;
        }
        BillInventoryConfigEntryInfo configEntry = null;
        FilterInfo filter = new FilterInfo();
        int size = configEntries.size();
        for (int i = 0; i < size; ++i) {
            configEntry = configEntries.get(i);
            if (StringUtil.isEmpty((String)configEntry.getBillProperty())) continue;
            String billProperty = configEntry.getBillProperty();
            String string = configEntry.getInvProperty();
        }
        return null;
    }

    private static StoreTypeInfo getStoreType(Context ctx, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        if (model == null || model.getBOSType() == null) {
            return null;
        }
        BillInventoryConfigInfo config = null;
        config = ReservationBalanceUtil.getBillBalanceConfig(ctx, model);
        if (config == null) {
            return null;
        }
        BillInventoryConfigEntryCollection configEntries = config.getEntry();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)configEntries)) {
            return null;
        }
        BillInventoryConfigEntryInfo configEntry = null;
        StringBuffer sqlSelect = new StringBuffer(1024);
        sqlSelect.append("FID");
        StringBuffer sqlWhere = new StringBuffer(1024);
        sqlWhere.append(" where 1=1");
        int size = configEntries.size();
        for (int i = 0; i < size; ++i) {
            configEntry = configEntries.get(i);
            if (StringUtil.isEmpty((String)configEntry.getBillProperty())) continue;
            String billProperty = configEntry.getBillProperty();
            StoreTypeInfo storeType = ReservationBalanceUtil.getStoreTypeInfo(ctx, model, billProperty);
            if (storeType != null) {
                return storeType;
            }
            storeType = ReservationBalanceUtil.getStoreTypeInfo(ctx, entry, billProperty);
            if (storeType == null) continue;
            return storeType;
        }
        return null;
    }

    private static StoreTypeInfo getStoreTypeInfo(Context ctx, IObjectValue entry, String billProperty) {
        String[] arr = billProperty.split("\\.");
        IObjectValue obj = null;
        obj = entry;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            if (obj.get(arr[i]) == null || !(obj.get(arr[i]) instanceof IObjectValue) || !((obj = (IObjectValue)obj.get(arr[i])) instanceof StoreTypeInfo)) continue;
            return (StoreTypeInfo)obj;
        }
        if (obj != entry && obj != null && obj instanceof StoreTypeInfo) {
            return (StoreTypeInfo)obj;
        }
        return null;
    }

    private static String getEntrySomeInfo(IObjectValue entry, String billProperty) {
        String[] arr = billProperty.split("\\.");
        IObjectValue obj = null;
        obj = entry;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            if (obj.get(arr[i]) == null) continue;
            if (obj.get(arr[i]) instanceof IObjectValue) {
                obj = (IObjectValue)obj.get(arr[i]);
                continue;
            }
            if (obj.get(arr[i]) instanceof String) {
                return (String)obj.get(arr[i]);
            }
            return "";
        }
        if (obj != entry && obj != null) {
            if (obj instanceof StoreTypeInfo) {
                storeTypeMap.put(obj.get("id").toString(), obj);
            }
            return obj.get("id").toString();
        }
        return "";
    }

    private static String getInventoryWhereSql(Context ctx, IObjectValue model, IObjectValue entry, String billProperty, String invField) {
        if (model == null || entry == null || StringUtil.isEmpty((String)billProperty) || StringUtil.isEmpty((String)invField)) {
            return "";
        }
        String billEntryPropertyName = "";
        billEntryPropertyName = ReservationUtil.getBillEntryPropertyName(model.getBOSType().toString());
        String SPLITMARK = ".";
        StringBuffer sqlWhere = new StringBuffer(128);
        String value = ReservationBalanceUtil.getEntrySomeInfo(entry, billProperty);
        if (!StringUtil.isEmpty((String)value)) {
            sqlWhere.append(invField);
            sqlWhere.append("=");
            sqlWhere.append("'" + value + "'");
        }
        return sqlWhere.toString();
    }

    public static String buildInventorySql(Context ctx, IObjectValue model, IObjectValue entry, String inventoryId) throws BOSException, EASBizException {
        if (model == null || model.getBOSType() == null) {
            return null;
        }
        BillInventoryConfigInfo config = null;
        config = ReservationBalanceUtil.getBillBalanceConfig(ctx, model);
        if (config == null) {
            return null;
        }
        BillInventoryConfigEntryCollection configEntries = config.getEntry();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)configEntries)) {
            return null;
        }
        StringBuffer sqlSelect = new StringBuffer(1024);
        sqlSelect.append("FID");
        StringBuffer sqlWhere = new StringBuffer(1024);
        sqlWhere.append(" where fid='" + inventoryId + "' ");
        BillInventoryConfigEntryInfo configEntry = null;
        int size = configEntries.size();
        for (int i = 0; i < size; ++i) {
            configEntry = configEntries.get(i);
            if (StringUtil.isEmpty((String)configEntry.getBillProperty())) continue;
            String invField = configEntry.getInvField();
            if ("FLot".equals(invField)) {
                sqlSelect.append(",CASE WHEN FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE FLot END AS FLot");
                continue;
            }
            if ("FAssistPropertyID".equals(invField)) {
                sqlSelect.append(",CASE WHEN FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' THEN NULL ELSE FAssistPropertyID END AS FAssistPropertyID");
                continue;
            }
            if ("FLocationID".equals(invField)) {
                sqlSelect.append(",CASE WHEN FLocationID = '").append("EgkAAABc3XMgX/hq").append("' THEN NULL ELSE FLocationID END AS FLocationID");
                continue;
            }
            if ("FWarehouseID".equals(invField)) {
                sqlSelect.append(",CASE WHEN FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' THEN NULL ELSE FWarehouseID END AS FWarehouseID");
                continue;
            }
            if ("FSupplierID".equals(invField)) {
                sqlSelect.append(",CASE WHEN FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' THEN NULL ELSE FSupplierID END AS FSupplierID");
                continue;
            }
            if ("FCustomerID".equals(invField)) {
                sqlSelect.append(",CASE WHEN FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' THEN NULL ELSE FCustomerID END AS FCustomerID");
                continue;
            }
            if ("FProjectID".equals(invField)) {
                sqlSelect.append(",CASE WHEN FProjectID = '").append("EgkAAABc3Xza3gXu").append("' THEN NULL ELSE FProjectID END AS FProjectID");
                continue;
            }
            if ("FTrackNumberID".equals(invField)) {
                sqlSelect.append(",CASE WHEN FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' THEN NULL ELSE FTrackNumberID END AS FTrackNumberID");
                continue;
            }
            sqlSelect.append(", " + invField);
        }
        if (StringUtil.isEmpty((String)inventoryId)) {
            return "SELECT " + sqlSelect.toString() + " FROM T_IM_INVENTORY " + sqlWhere.toString();
        }
        return "SELECT " + sqlSelect.toString() + " FROM T_IM_INVENTORY WHERE FID='" + inventoryId + "'";
    }

    public static Map matchInventory(Context ctx, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        return ReservationBalanceUtil.matchInventory(ctx, model, entry, null);
    }

    public static Map matchInventory(Context ctx, IObjectValue model, IObjectValue entry, String inventoryId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (model == null || model.getBOSType() == null) {
            return null;
        }
        BillInventoryConfigInfo config = null;
        config = ReservationBalanceUtil.getBillBalanceConfig(ctx, model);
        if (config == null) {
            return null;
        }
        BillInventoryConfigEntryCollection configEntries = config.getEntry();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)configEntries)) {
            return null;
        }
        BillInventoryConfigEntryInfo configEntry = null;
        String sql = ReservationBalanceUtil.buildInventorySql(ctx, model, entry, inventoryId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            IDynamicObject iDynamicObject = null;
            iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
            BOSObjectType storageOrgBosType = new StorageOrgUnitInfo().getBOSType();
            while (rs.next()) {
                int size = configEntries.size();
                for (int i = 0; i < size; ++i) {
                    configEntry = configEntries.get(i);
                    String billProperty = configEntry.getBillProperty();
                    String invProperty = configEntry.getInvProperty();
                    String invField = configEntry.getInvField();
                    try {
                        if (rs.getObject(invField) == null) continue;
                        if (rs.getObject(invField) instanceof BigDecimal) {
                            map.put(billProperty, rs.getBigDecimal(invField));
                            continue;
                        }
                        String id = rs.getString(invField);
                        if (ReservationBalanceUtil.isLinkProperty(ctx, model, entry, billProperty)) {
                            IObjectValue propertyValue = null;
                            if (linkPropertyMap.containsKey(id)) {
                                propertyValue = linkPropertyMap.get(id);
                            } else {
                                ObjectUuidPK pk = new ObjectUuidPK(id);
                                propertyValue = "FStorageOrgUnitID".equals(invField) ? iDynamicObject.getValue(storageOrgBosType, (IObjectPK)pk) : iDynamicObject.getValue(pk.getObjectType(), (IObjectPK)pk);
                                linkPropertyMap.put(id, propertyValue);
                            }
                            map.put(billProperty, propertyValue);
                            continue;
                        }
                        map.put(billProperty, rs.getString(invField));
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return map;
    }

    public static String matchInventoryId(Context ctx, IObjectValue model, IObjectValue entry, String inventoryId) throws BOSException, EASBizException {
        if (model == null || model.getBOSType() == null) {
            return null;
        }
        BillInventoryConfigInfo config = null;
        config = ReservationBalanceUtil.getBillBalanceConfig(ctx, model);
        if (config == null) {
            return null;
        }
        BillInventoryConfigEntryCollection configEntries = config.getEntry();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)configEntries)) {
            return null;
        }
        String sql = ReservationBalanceUtil.buildInventorySql(ctx, model, entry, inventoryId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return rs.getString("FID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static boolean isLinkProperty(Context ctx, IObjectValue model, IObjectValue entry, String billProperty) {
        if (model == null || entry == null || StringUtil.isEmpty((String)billProperty)) {
            return false;
        }
        if (billProperty.indexOf(".") > 1) {
            String bosType = entry.getBOSType().toString();
            String[] arr = billProperty.split("\\.");
            return ReservationUtil.isLinkProperty(ctx, bosType, arr[1]);
        }
        String bosType = model.getBOSType().toString();
        return ReservationUtil.isLinkProperty(ctx, bosType, billProperty);
    }
}

