/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.InventoryPageHelper;
import com.kingdee.eas.scm.im.inv.invconfig.GeneralInventoryConfigEntryCollection;
import com.kingdee.eas.scm.im.inv.invconfig.GeneralInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.GeneralInventoryConfigFactory;
import com.kingdee.eas.scm.im.inv.invconfig.GeneralInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.SQLDataAccessFacadeFactory;
import com.kingdee.eas.scm.util.entity.EntityObjectInfoHelp;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class InventoryGeneralRptPageHelper
extends InventoryPageHelper {
    private String warepermSql = null;
    private String tempTable_reservationInv = null;
    boolean isOnload = false;
    Map params = null;
    String groupFieldStr = "";
    String[] needFields = new String[]{"FStoreStatusID", "FCompanyOrgUnitID", "FStorageOrgUnitID", "FWarehouseID", "FMaterialID", "FBaseUnitID", "FAssistUnitID"};
    Map<String, String> invFieldMap = new HashMap<String, String>();
    List<String> needShowFieldsList = new ArrayList<String>();

    public InventoryGeneralRptPageHelper(Context ctx, Map params) {
        this.ctx = ctx;
        this.params = params;
    }

    private int getRowCount(String tempTableName) throws EASBizException, BOSException, SQLException {
        int rowCount = 0;
        String sql = "select count (id) as count from " + tempTableName;
        try {
            IRowSet rs = SQLDataAccessFacadeFactory.getRemoteInstance().executeQuery(sql);
            if (rs.next()) {
                rowCount = rs.getInt("count");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowCount;
    }

    public Map createTempTable() throws EASBizException, BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.initPermSql();
        this.initReservationInvTempTable();
        this.initGroupFieldStr();
        this.initNeedShowFields();
        this.handleOrgSet();
        String bosType = (String)this.params.get("bosType");
        String entryBosType = (String)this.params.get("entryBosType");
        String entryName = (String)this.params.get("entryName");
        IObjectValue billInfo = null;
        IObjectValue billEntryInfo = null;
        try {
            EntityObjectInfo entityObj = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosType));
            Class infoClass = entityObj.getObjectValueClazzRuntime();
            billInfo = (IObjectValue)infoClass.newInstance();
            EntityObjectInfo entityEntryObj = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)entryBosType));
            Class entryClass = entityEntryObj.getObjectValueClazzRuntime();
            billEntryInfo = (IObjectValue)entryClass.newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String insertSql = this.getInsertInvReservationTempTableSql(this.params);
        DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
        String sql = "";
        this.entryName = entryName;
        try {
            this.buildConfigMapping(this.ctx, billInfo, billEntryInfo, 1);
            sql = this.getQuerySQL();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String tempTableName = SQLDataAccessFacadeFactory.getLocalInstance(this.ctx).createTempTable(this.getCreateTempTableSQL(), sql, this.fieldSQL.toString(), null);
        String newTempTableName = this.getTempTableName("t_im_Inventory_temp");
        this.doGroupByInvGeneralConfig(tempTableName, newTempTableName);
        this.fieldSQL.append(" FReservationQty, ");
        this.fieldSQL.append(" FTotalReservationQty, ");
        this.fieldSQL.append(" FReservationAssistQty, ");
        this.fieldSQL.append(" FTotalReservationAssistQty, ");
        String updateData = "update " + newTempTableName + " set FUnReservationQty=isnull(FUsableQty, 0)-isnull(FReservationQty,0),FTotalUnReservationQty=isnull(FtotalQty,0)-isnull(FTotalReservationQty,0),FUnReservationAssistQty=isnull(FAssiUsableQty,0)-isnull(FReservationAssistQty,0),FTotalUnReservationAssistQty=isnull(FAssitotalQty,0)-isnull(FTotalReservationAssistQty,0),FReservationQty=isnull(FReservationQty,0),FTotalReservationQty=isnull(FTotalReservationQty,0),FReservationAssistQty=isnull(FReservationAssistQty,0),FTotalReservationAssistQty=isnull(FTotalReservationAssistQty,0)";
        this.executeSQL(updateData);
        this.updateLeaf(newTempTableName, this.params);
        sql = this.getGroup1(newTempTableName, this.params);
        this.executeSQL(sql);
        int queryType = (Integer)this.params.get("queryType");
        if (queryType == 0) {
            this.levelGroupByStorageOrg(newTempTableName, this.params);
        } else {
            sql = this.getGroup2(newTempTableName, this.params);
            this.executeSQL(sql);
            this.updateOrgName(newTempTableName, this.params);
        }
        this.executeSQL(updateData);
        this.updateZeroToNull(newTempTableName);
        this.dropTable(this.tempTable_reservationInv);
        this.dropTable(tempTableName);
        map.put("tempTable", newTempTableName);
        map.put("resMap", this.resMap);
        map.put("groupFieldStr", this.groupFieldStr);
        map.put("needShowFieldsList", this.needShowFieldsList);
        map.put("invFieldMap", this.invFieldMap);
        map.put("fieldTypeMap", this.fieldTypeMap);
        return map;
    }

    private void handleOrgSet() throws EASBizException, BOSException {
        int i;
        Object[] orgs = (Object[])this.params.get("storageOrgSet");
        StorageOrgUnitCollection storageOrgUnitCollection = null;
        StorageOrgUnitInfo orgInfo = null;
        HashSet<String> orgIdSet = new HashSet<String>();
        for (int i2 = 0; i2 < orgs.length; ++i2) {
            orgIdSet.add(((StorageOrgUnitInfo)orgs[i2]).getId().toString());
        }
        IObjectPK userPK = this.ctx.getCaller();
        HashSet<String> authorizedOrgSet = new HashSet<String>();
        FullOrgUnitCollection unitCollection = PermissionFactory.getRemoteInstance().getAuthorizedOrg(userPK, OrgType.Storage, null, "im_inventorygeneralrpt_view");
        for (i = 0; i < unitCollection.size(); ++i) {
            authorizedOrgSet.add(unitCollection.get(i).getId().toString());
        }
        for (i = 0; i < orgs.length; ++i) {
            HashSet<String> childOrgSet = new HashSet<String>();
            orgInfo = (StorageOrgUnitInfo)orgs[i];
            if (orgInfo.isIsLeaf()) continue;
            OrgUnitCollection orgUnitCollection = OrgUnitUtils.getChildrenOrgCollection((Context)this.ctx, (String)orgInfo.getId().toString(), (int)3, (boolean)true, (SortType)SortType.DESCEND, (OrgType)OrgType.Storage, (String)SCMServerUtils.getInStringFromSet(authorizedOrgSet));
            for (int j = 0; j < orgUnitCollection.size(); ++j) {
                childOrgSet.add(orgUnitCollection.get(j).getId().toString());
            }
            orgIdSet.addAll(childOrgSet);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        storageOrgUnitCollection = StorageOrgUnitFactory.getLocalInstance((Context)this.ctx).getStorageOrgUnitCollection(view);
        for (int i3 = 0; i3 < storageOrgUnitCollection.size(); ++i3) {
            orgInfo = storageOrgUnitCollection.get(i3);
            if (orgInfo.getParent() != null && orgIdSet.contains(orgInfo.getParent().getId().toString())) continue;
            orgInfo.setParent(null);
            int spreadLevel = orgInfo.getLevel() - 1;
            for (int j = 0; j < storageOrgUnitCollection.size(); ++j) {
                String longnumber = orgInfo.getLongNumber();
                if (!storageOrgUnitCollection.get(j).getLongNumber().startsWith(longnumber)) continue;
                storageOrgUnitCollection.get(j).setLevel(storageOrgUnitCollection.get(j).getLevel() - spreadLevel);
            }
        }
        this.params.put("storageOrgSet", storageOrgUnitCollection.toArray());
    }

    private void initNeedShowFields() throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)this.groupFieldStr)) {
            String[] groupFiledArr = this.groupFieldStr.split(",");
            for (int i = 0; i < groupFiledArr.length; ++i) {
                if (groupFiledArr[i].equals("FStoreStatusID")) continue;
                this.needShowFieldsList.add(groupFiledArr[i]);
            }
        }
    }

    private void initGroupFieldStr() throws EASBizException, BOSException {
        GeneralInventoryConfigInfo configInfo = GeneralInventoryConfigFactory.getLocalInstance(this.ctx).getGeneralInventoryConfigInfo((IObjectPK)new ObjectUuidPK("UfIMYe1mSRCQNuU877SAoUW3j88="));
        GeneralInventoryConfigEntryCollection entryCollection = configInfo.getEntry();
        GeneralInventoryConfigEntryInfo entry = null;
        if (entryCollection.size() == 0) {
            throw new InvBizException(InvBizException.INV_CONFIG_NOTSAVE);
        }
        Arrays.sort(this.needFields);
        if (this.groupFieldStr.length() == 0) {
            BalanceFieldModelCollection balanceModelColl;
            try {
                balanceModelColl = this.getBalanceFieldModelCollInOrder();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            BalanceFieldModelInfo field = null;
            for (int i = 0; i < entryCollection.size(); ++i) {
                entry = entryCollection.get(i);
                if (!entry.isIsGroup() || Arrays.binarySearch(this.needFields, entry.getInvField()) >= 0) continue;
                boolean isValid = true;
                for (int j = 0; j < balanceModelColl.size(); ++j) {
                    field = balanceModelColl.get(j);
                    if (!field.getFieldName().equals(entry.getInvField()) || !DataTypeEnum.Amount.equals((Object)field.getDataType()) && !DataTypeEnum.Qty.equals((Object)field.getDataType()) && !DataTypeEnum.Price.equals((Object)field.getDataType()) && !"ID".equals(field.getName()) && !"BillEntryID".equals(field.getName()) && !"EntrySeq".equals(field.getName()) && (field.getBizDataType() != BizDataTypeEnum.AssistInfo || field.isIsSPvisible())) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) continue;
                this.groupFieldStr = this.groupFieldStr + entry.getInvField() + ",";
                if (!entry.getInvField().endsWith("ID")) continue;
                this.groupFieldStr = this.groupFieldStr + entry.getInvField() + "pk_hide" + ",";
                this.invFieldMap.put(entry.getInvField() + "pk_hide", entry.getInvField());
            }
        }
    }

    private void doGroupByInvGeneralConfig(String tempTableName, String newTempTableName) throws EASBizException, BOSException {
        block2: {
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            sql.append("newbosid('88888888') as FID,");
            sql.append("FOrgUnitID,");
            sql.append("FOrgUnitIDpk_hide,");
            sql.append(this.groupFieldStr);
            sql.append("sum(FUsableQty) as FUsableQty,");
            sql.append("sum(FLockBaseQty) as FLockBaseQty,");
            sql.append("sum(FWaitCheckQty) as FWaitCheckQty,");
            sql.append("sum(FFreezeQuery) as FFreezeQuery,");
            sql.append("sum(FUsableQty) + sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) as FtotalQty,");
            sql.append("sum(FAssiUsableQty) as FAssiUsableQty,");
            sql.append("sum(FAssiLockQty) as FAssiLockQty,");
            sql.append("sum(FAssiWaitCheckQty) as FAssiWaitCheckQty,");
            sql.append("sum(FAssiFreezeQuery) as FAssiFreezeQuery,");
            sql.append("sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) as FAssitotalQty,");
            sql.append("max(Fisleaf) as Fisleaf,");
            sql.append("max(FLevel) as FLevel");
            sql.append(",sum(FReservationQty) as FReservationQty");
            sql.append(",sum(FUsableQty) - sum(FReservationQty) as FUnReservationQty");
            sql.append(",sum(FTotalReservationQty) as FTotalReservationQty");
            sql.append(",sum(FUsableQty) + sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) - sum(FTotalReservationQty) as FTotalUnReservationQty");
            sql.append(",sum(FReservationAssistQty) as FReservationAssistQty");
            sql.append(",sum(FAssiUsableQty) - sum(FReservationAssistQty) as FUnReservationAssistQty");
            sql.append(",sum(FTotalReservationAssistQty) as FTotalReservationAssistQty");
            sql.append(",sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) - sum(FTotalReservationAssistQty) as FTotalUnReservationAssistQty");
            sql.append(",FStorageOrgUnitIDpk_hide as FParentID");
            sql.append(",FCompanyorgUnitIDpk_hide as FCompanyorgUnitIDpk_hide");
            sql.append(",FStorageOrgUnitIDpk_hide as FStorageOrgUnitIDpk_hide");
            sql.append(",FWarehouseIDpk_hide as FWarehouseIDpk_hide");
            sql.append(",FCompanyOrgUnitID as FCompanyOrgUnitID");
            sql.append(",FStorageOrgUnitID as FStorageOrgUnitID");
            sql.append(" into " + newTempTableName + " ");
            sql.append(" from " + tempTableName + " ");
            sql.append(" group by ");
            sql.append(this.groupFieldStr);
            sql.append(" FOrgUnitID,FOrgUnitIDpk_hide,FCompanyorgunitIDpk_hide,FStorageorgunitIDpk_hide,FWarehouseIDpk_hide,FCompanyOrgUnitID,FStorageOrgUnitID");
            try {
                DbUtil.execute((Context)this.ctx, (String)sql.toString());
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof SQLException)) break block2;
                throw new InvBizException(InvBizException.SYNCHRONIZED_UPDATA);
            }
        }
    }

    private IRowSet executeQuery(String tempTableName, int from, int len) throws EASBizException, BOSException {
        StringBuilder querySQL = new StringBuilder();
        querySQL.append("select * from ").append(tempTableName);
        querySQL.append(" ORDER BY ");
        querySQL.append(" WAREHOUSENUMBER ASC, LOCATIONNUMBER ASC, MATERIALNUMBER ASC ");
        return SQLDataAccessFacadeFactory.getRemoteInstance().getRowSet(querySQL.toString(), from, len);
    }

    @Override
    protected String getQuerySQL() throws Exception {
        String invField = null;
        this.initDefaultProperty();
        StringBuilder sqlSelect = this.getDefaultSelectSQL();
        StringBuilder sqlFrom = this.getDefaultFromSQL();
        StringBuilder sqlWhere = this.getDefaultWhereSQL();
        StringBuilder extendFilterSQL = new StringBuilder();
        this.initCreateTempTableSQL();
        this.initFieldSQL();
        String linkTable = null;
        String tableAlias = null;
        BalanceFieldModelCollection coll = this.getBalanceFieldModelCollInOrder();
        BalanceFieldModelInfo fieldInfo = null;
        this.tableHeadKeyList.clear();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.getBizDataType() == BizDataTypeEnum.AssistInfo && !fieldInfo.isIsSPvisible()) continue;
            invField = fieldInfo.getFieldName();
            this.fieldTypeMap.put(invField, fieldInfo.getDataType().getValue());
            if (DataTypeEnum.Boolean.equals((Object)fieldInfo.getDataType())) {
                this.boolPropSet.add(invField);
            } else if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                this.linkPropBosTypeMap.put(invField, fieldInfo.getBaseDataBOSType());
            }
            if (this.defaultProperty.contains(invField)) {
                if (invField.equalsIgnoreCase("FMaterialID")) {
                    this.tableHeadKeyList.add(invField);
                    this.tableHeadKeyList.add("MaterialNumber");
                    this.tableHeadKeyList.add("MaterialName");
                    this.tableHeadKeyList.add("MaterialModel");
                    this.resMap.put("MaterialNumber", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"materialNumber", null));
                    this.resMap.put("MaterialName", fieldInfo.getAlias());
                    this.resMap.put("MaterialModel", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"materialModel", null));
                    continue;
                }
                if (invField.equalsIgnoreCase("FLot")) {
                    this.tableHeadKeyList.add(invField);
                    this.tableHeadKeyList.add("Mfg");
                    this.tableHeadKeyList.add("Exp");
                    this.resMap.put(invField, fieldInfo.getAlias());
                    this.resMap.put("Mfg", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"mfg", null));
                    this.resMap.put("Exp", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"exp", null));
                    continue;
                }
                this.tableHeadKeyList.add(invField);
                String key = invField;
                if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                    if (fieldInfo.getBaseDataBOSType() == null) {
                        this.tableHeadKeyList.add("id");
                        continue;
                    }
                    this.tableHeadKeyList.add(key);
                }
                this.resMap.put(key, fieldInfo.getAlias());
                continue;
            }
            this.tableHeadKeyList.add(invField);
            tableAlias = "t" + i;
            if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                sqlSelect.append(", ").append(tableAlias).append(".fname_").append(this.loc).append(" as ").append(invField + "pk_hide").append(" \r\n");
                sqlSelect.append(", ").append(tableAlias).append(".fid as ").append(invField).append(" \r\n");
                IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldInfo.getBaseDataBOSType()));
                EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                linkTable = entityObjInfo.getTable().getName();
                sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on TEMP.").append(invField).append("=").append(tableAlias).append(".fid \r\n");
                this.tableHeadKeyList.add(invField);
                this.resMap.put(invField, fieldInfo.getAlias());
                this.createTempTableSQL.append(", ").append(invField + "pk_hide").append(" nvarchar(255)");
                this.createTempTableSQL.append(", ").append(invField).append(" varchar(44)");
                this.fieldSQL.append(" , ").append(invField + "pk_hide");
                this.fieldSQL.append(" , ").append(invField);
                continue;
            }
            sqlSelect.append(", TEMP.").append(invField);
            this.resMap.put(invField, fieldInfo.getAlias());
            DataTypeEnum dataType = fieldInfo.getDataType();
            if (DataTypeEnum.String.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" nvarchar(255)");
            } else if (DataTypeEnum.Integer.equals((Object)dataType) || DataTypeEnum.Boolean.equals((Object)dataType) || DataTypeEnum.Enum.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" int");
            } else if (DataTypeEnum.Date.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" datetime");
            } else if (DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Amount.equals((Object)dataType) || DataTypeEnum.Price.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" Decimal(28,10) default 0");
            }
            this.fieldSQL.append(" , ").append(invField);
        }
        this.tableHeadKeyList.remove("FCompanyOrgUnitID");
        this.tableHeadKeyList.remove("FCompanyOrgUnitIDpk_hide");
        this.tableHeadKeyList.remove("FID");
        this.tableHeadKeyList.remove("FAmount");
        this.tableHeadKeyList.remove("FLockQty");
        this.tableHeadKeyList.remove("FLockBaseQty");
        this.tableHeadKeyList.remove("FLockAssistQty");
        this.resMap.put("boolFieldSet", this.boolPropSet);
        this.tableHeadKeyList.add("FReservationQty");
        this.tableHeadKeyList.add("FReservationBaseQty");
        this.resMap.put("FReservationQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationQty", null));
        this.resMap.put("FReservationBaseQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationBaseQty", null));
        this.resMap.put("FCurStoreQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realQty", null));
        this.resMap.put("FCurStoreAssistQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realAssistQty", null));
        this.resMap.put("FBaseQty", ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realBaseQty", null));
        StringBuilder sql = new StringBuilder();
        if (!StringUtil.isEmpty((String)extendFilterSQL.toString())) {
            sqlWhere.append((CharSequence)extendFilterSQL);
        }
        sql.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom).append((CharSequence)sqlWhere);
        return sql.toString();
    }

    @Override
    public String getCreateTempTableSQL() {
        return this.createTempTableSQL.toString() + ")";
    }

    @Override
    protected void initCreateTempTableSQL() {
        this.createTempTableSQL = new StringBuilder();
        this.createTempTableSQL.append("create table temp_table(");
        this.createTempTableSQL.append("FID varchar(44),");
        this.createTempTableSQL.append("FOrgUnitID nvarchar(255),");
        this.createTempTableSQL.append("FOrgUnitIDpk_hide varchar(44),");
        this.createTempTableSQL.append("FUsableQty numeric(31,10),");
        this.createTempTableSQL.append("FLockBaseQty numeric(31,10),");
        this.createTempTableSQL.append("FWaitCheckQty numeric(31,10),");
        this.createTempTableSQL.append("FFreezeQuery numeric(31,10),");
        this.createTempTableSQL.append("FTotalQty numeric(31,10),");
        this.createTempTableSQL.append("FAssiUsableQty numeric(31,10),");
        this.createTempTableSQL.append("FAssiLockQty numeric(31,10),");
        this.createTempTableSQL.append("FAssiWaitCheckQty numeric(31,10),");
        this.createTempTableSQL.append("FAssiFreezeQuery numeric(31,10),");
        this.createTempTableSQL.append("FAssiTotalQty numeric(31,10),");
        this.createTempTableSQL.append("FParentID varchar(44),");
        this.createTempTableSQL.append("Fisleaf int,");
        this.createTempTableSQL.append("FLevel int ");
        this.createTempTableSQL.append(",FReservationQty numeric(31,10)");
        this.createTempTableSQL.append(",FUnReservationQty numeric(31,10)");
        this.createTempTableSQL.append(",FTotalReservationQty numeric(31,10)");
        this.createTempTableSQL.append(",FTotalUnReservationQty numeric(31,10)");
        this.createTempTableSQL.append(",FReservationAssistQty numeric(31,10)");
        this.createTempTableSQL.append(",FUnReservationAssistQty numeric(31,10)");
        this.createTempTableSQL.append(",FTotalReservationAssistQty numeric(31,10)");
        this.createTempTableSQL.append(",FTotalUnReservationAssistQty numeric(31,10)");
        this.createTempTableSQL.append(",FLot nvarchar(80)");
        this.createTempTableSQL.append(",Mfg datetime");
        this.createTempTableSQL.append(",EXP datetime");
        this.createTempTableSQL.append(",FUnitIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",UNITNUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FUnitID nvarchar(255)");
        this.createTempTableSQL.append(",FAssistUnitID nvarchar(255)");
        this.createTempTableSQL.append(",ASSISTUNITNUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FAssistUnitIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FAssistPropertyIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FAssistPropertyID nvarchar(255)");
        this.createTempTableSQL.append(",ASSISTPROPERTYNUMBER nvarchar(80)");
        this.createTempTableSQL.append(",ASSISTPROPERTYTYPE nvarchar(2000)");
        this.createTempTableSQL.append(",FWarehouseID nvarchar(255)");
        this.createTempTableSQL.append(",WAREHOUSENUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FWarehouseIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FLocationID nvarchar(255)");
        this.createTempTableSQL.append(",LOCATIONNUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FLocationIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FStoreTypeID nvarchar(255)");
        this.createTempTableSQL.append(",STORETYPENUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FStoreTypeIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FStoreStatusID nvarchar(255)");
        this.createTempTableSQL.append(",STORESTATUSNUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FStoreStatusIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FProjectID nvarchar(255)");
        this.createTempTableSQL.append(",FProjectIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FTrackNumberID nvarchar(255)");
        this.createTempTableSQL.append(",FTrackNumberIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FCustomerID nvarchar(255)");
        this.createTempTableSQL.append(",CUSTOMERNUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FCustomerIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FSupplierID nvarchar(255)");
        this.createTempTableSQL.append(",SUPPLIERNUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FSupplierIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FStorageOrgUnitID nvarchar(255)");
        this.createTempTableSQL.append(",STORAGEORGNUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FStorageOrgUnitIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",FCompanyOrgUnitID nvarchar(255)");
        this.createTempTableSQL.append(",COMPANYORGUNITNUMBER nvarchar(80)");
        this.createTempTableSQL.append(",FCompanyOrgUnitIDpk_hide varchar(44)");
        this.createTempTableSQL.append(",MULTIASSISTUNITQTYPRECISION int");
        this.createTempTableSQL.append(",MULTIBASEUNITQTYPRECISION int");
        this.createTempTableSQL.append(",MULTIUNITQTYPRECISION int");
        this.createTempTableSQL.append(",INVENTORYUNITNAME nvarchar(255)");
        this.createTempTableSQL.append(",MULTIINVENTORYUNITQTYPRECIS54 int");
    }

    @Override
    public String getFieldSQL() {
        return this.fieldSQL.toString();
    }

    @Override
    protected void initFieldSQL() {
        this.fieldSQL = new StringBuilder();
        this.fieldSQL.append(" FID, ");
        this.fieldSQL.append(" FOrgUnitIDpk_hide, ");
        this.fieldSQL.append(" FOrgUnitID, ");
        this.fieldSQL.append(" FUsableQty, ");
        this.fieldSQL.append(" FLockBaseQty, ");
        this.fieldSQL.append(" FWaitCheckQty, ");
        this.fieldSQL.append(" FFreezeQuery, ");
        this.fieldSQL.append(" FTotalQty, ");
        this.fieldSQL.append(" FAssiUsableQty, ");
        this.fieldSQL.append(" FAssiLockQty, ");
        this.fieldSQL.append(" FAssiWaitCheckQty, ");
        this.fieldSQL.append(" FAssiFreezeQuery, ");
        this.fieldSQL.append(" FAssiTotalQty, ");
        this.fieldSQL.append(" FParentID, ");
        this.fieldSQL.append(" Fisleaf, ");
        this.fieldSQL.append(" FLevel, ");
        this.fieldSQL.append(" FReservationQty, ");
        this.fieldSQL.append(" FUnReservationQty, ");
        this.fieldSQL.append(" FTotalReservationQty, ");
        this.fieldSQL.append(" FTotalUnReservationQty, ");
        this.fieldSQL.append(" FReservationAssistQty, ");
        this.fieldSQL.append(" FUnReservationAssistQty, ");
        this.fieldSQL.append(" FTotalReservationAssistQty, ");
        this.fieldSQL.append(" FTotalUnReservationAssistQty, ");
        this.fieldSQL.append(" FLot, ");
        this.fieldSQL.append(" Mfg, ");
        this.fieldSQL.append(" EXP, ");
        this.fieldSQL.append(" FUnitID, ");
        this.fieldSQL.append(" UNITNUMBER, ");
        this.fieldSQL.append(" FUnitIDpk_hide, ");
        this.fieldSQL.append(" FAssistUnitIDpk_hide, ");
        this.fieldSQL.append(" ASSISTUNITNUMBER, ");
        this.fieldSQL.append(" FAssistUnitID, ");
        this.fieldSQL.append(" FAssistPropertyID, ");
        this.fieldSQL.append(" FAssistPropertyIDpk_hide, ");
        this.fieldSQL.append(" ASSISTPROPERTYTYPE, ");
        this.fieldSQL.append(" ASSISTPROPERTYNUMBER, ");
        this.fieldSQL.append(" FWarehouseIDpk_hide, ");
        this.fieldSQL.append(" WAREHOUSENUMBER, ");
        this.fieldSQL.append(" FWarehouseID, ");
        this.fieldSQL.append(" FLocationIDpk_hide, ");
        this.fieldSQL.append(" LOCATIONNUMBER, ");
        this.fieldSQL.append(" FLocationID, ");
        this.fieldSQL.append(" FStoreTypeIDpk_hide, ");
        this.fieldSQL.append(" STORETYPENUMBER, ");
        this.fieldSQL.append(" FStoreTypeID, ");
        this.fieldSQL.append(" FStoreStatusIDpk_hide, ");
        this.fieldSQL.append(" STORESTATUSNUMBER, ");
        this.fieldSQL.append(" FStoreStatusID, ");
        this.fieldSQL.append(" FProjectIDpk_hide, ");
        this.fieldSQL.append(" FProjectID, ");
        this.fieldSQL.append(" FTrackNumberIDpk_hide, ");
        this.fieldSQL.append(" FTrackNumberID, ");
        this.fieldSQL.append(" FCustomerIDpk_hide,");
        this.fieldSQL.append(" FCustomerID, ");
        this.fieldSQL.append(" CUSTOMERNUMBER,");
        this.fieldSQL.append(" FSupplierIDpk_hide,");
        this.fieldSQL.append(" SUPPLIERNUMBER,");
        this.fieldSQL.append(" FSupplierID,");
        this.fieldSQL.append(" FStorageOrgUnitIDpk_hide,");
        this.fieldSQL.append(" STORAGEORGNUMBER,");
        this.fieldSQL.append(" FStorageOrgUnitID,");
        this.fieldSQL.append(" FCompanyOrgUnitIDpk_hide,");
        this.fieldSQL.append(" COMPANYORGUNITNUMBER,");
        this.fieldSQL.append(" FCompanyOrgUnitID,");
        this.fieldSQL.append(" MULTIASSISTUNITQTYPRECISION,");
        this.fieldSQL.append(" MULTIBASEUNITQTYPRECISION,");
        this.fieldSQL.append(" MULTIUNITQTYPRECISION,");
        this.fieldSQL.append(" INVENTORYUNITNAME,");
        this.fieldSQL.append(" MULTIINVENTORYUNITQTYPRECIS54");
    }

    @Override
    protected StringBuilder getDefaultSelectSQL() {
        StringBuilder sql = new StringBuilder();
        String lang = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append("select ");
        sql.append("newbosid('88888888') as FID,");
        sql.append("TEMP.FWarehouseID as FOrgUnitIDpk_hide, WAREHOUSE.fname_").append(lang).append(" as FOrgUnitID,");
        sql.append("case STORESTATE.FStoreStateType when 1 then TEMP.FBaseQty else 0 end  as FUsableQty,");
        sql.append("TEMP.FLockBaseQty as FLockBaseQty,");
        sql.append("case STORESTATE.FStoreStateType when 2 then TEMP.FBaseQty else 0 end  as FWaitCheckQty,");
        sql.append("case STORESTATE.FStoreStateType when  3 then TEMP.FBaseQty else 0 end  as FFreezeQuery,");
        sql.append("case STORESTATE.FStoreStateType when 1 then TEMP.FBaseQty else 0 end  + ");
        sql.append("TEMP.FLockBaseQty +  ");
        sql.append("case STORESTATE.FStoreStateType when 2 then TEMP.FBaseQty else 0 end  + ");
        sql.append("case STORESTATE.FStoreStateType when  3 then TEMP.FBaseQty else 0 end  ");
        sql.append("as FTotalQty,");
        sql.append("case STORESTATE.FStoreStateType when  1 then TEMP.FCurStoreAssistQty else 0 end  as FAssiUsableQty,");
        sql.append("TEMP.FLockAssistQty as FAssiLockQty,");
        sql.append("case STORESTATE.FStoreStateType when 2 then TEMP.FCurStoreAssistQty else 0 end  as FAssiWaitCheckQty,");
        sql.append("case STORESTATE.FStoreStateType when  3 then TEMP.FCurStoreAssistQty else 0 end  as FAssiFreezeQuery,");
        sql.append("case STORESTATE.FStoreStateType when  1 then TEMP.FCurStoreAssistQty else 0 end  + ");
        sql.append("TEMP.FLockAssistQty + ");
        sql.append("case STORESTATE.FStoreStateType when 2 then TEMP.FCurStoreAssistQty else 0 end  + ");
        sql.append("case STORESTATE.FStoreStateType when  3 then TEMP.FCurStoreAssistQty else 0 end  ");
        sql.append("as FAssiTotalQty,");
        sql.append("TEMP.FStorageOrgUnitID as FParentID,");
        sql.append("1 as Fisleaf,");
        sql.append("3 as FLevel ");
        sql.append(",case STORESTATE.FStoreStateType when 1 then TEMP.FReservationBaseQty else 0 end  as FReservationQty,");
        sql.append(" 0 as FUnReservationQty,");
        sql.append("TEMP.FReservationBaseQty as FTotalReservationQty,");
        sql.append(" 0 as FTotalUnReservationQty,");
        sql.append("case STORESTATE.FStoreStateType when 1 then TEMP.FReservationAssistQty else 0 end  as FReservationAssistQty,");
        sql.append(" 0 as FUnReservationAssistQty,");
        sql.append("TEMP.FReservationAssistQty as FTotalReservationAssistQty,");
        sql.append(" 0 as FTotalUnReservationAssistQty ,");
        sql.append(" CASE  WHEN TEMP.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE TEMP.FLot END AS FLot,  \r\n");
        sql.append(" DATEOFMINDURABILITY.FMfg AS Mfg,     \r\n");
        sql.append(" DATEOFMINDURABILITY.FExp AS Exp,    \r\n");
        sql.append(" UNIT.FName_").append(this.loc).append(" AS FUnitID,    \r\n");
        sql.append(" UNIT.FNumber AS UNITNUMBER,    \r\n");
        sql.append(" TEMP.FUnitID AS FUnitIDpk_hide,     \r\n");
        sql.append(" CASE  WHEN TEMP.FAssistUnitID = '").append("EgkAAAA5EWFbglxX").append("' THEN NULL ELSE TEMP.FAssistUnitID END AS FAssistUnitIDpk_hide,   \r\n");
        sql.append(" ASSISTUNIT.FNumber AS ASSISTUNITNUMBER,   \r\n");
        sql.append(" ASSISTUNIT.FName_").append(this.loc).append(" AS FAssistUnitID,   \r\n");
        sql.append(" ASSISTPROPERTY.FName_").append(this.loc).append(" AS FAssistPropertyID,   \r\n");
        sql.append(" CASE  WHEN TEMP.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' THEN NULL ELSE TEMP.FAssistPropertyID END AS FAssistPropertyIDpk_hide,    \r\n");
        sql.append(" ASSISTPROPERTY.FType AS ASSISTPROPERTYTYPE,   \r\n");
        sql.append(" ASSISTPROPERTY.FNumber AS ASSISTPROPERTYNUMBER,    \r\n");
        sql.append(" CASE  WHEN TEMP.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' THEN NULL ELSE TEMP.FWarehouseID END AS FWarehouseIDpk_hide,  \r\n");
        sql.append(" WAREHOUSE.FNumber AS WAREHOUSENUMBER,  \r\n");
        sql.append(" WAREHOUSE.FName_").append(this.loc).append(" AS FWarehouseID,  \r\n");
        sql.append(" CASE  WHEN TEMP.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' THEN NULL ELSE TEMP.FLocationID END AS FLocationIDpk_hide,  \r\n");
        sql.append(" LOCATION.FNumber AS LOCATIONNUMBER,  \r\n");
        sql.append(" LOCATION.FName_").append(this.loc).append(" AS FLocationID,  \r\n");
        sql.append(" TEMP.FStoreTypeID AS FStoreTypeIDpk_hide,  \r\n");
        sql.append(" STORETYPE.FNumber AS STORETYPENUMBER,  \r\n");
        sql.append(" STORETYPE.FName_").append(this.loc).append(" AS FStoreTypeID,  \r\n");
        sql.append(" TEMP.FStoreStatusID AS FStoreStatusIDpk_hide,  \r\n");
        sql.append(" STORESTATE.FNumber AS STORESTATUSNUMBER,   \r\n");
        sql.append(" STORESTATE.FName_").append(this.loc).append(" AS FStoreStatusID,   \r\n");
        sql.append(" CASE  WHEN TEMP.FProjectID = '").append("EgkAAABc3Xza3gXu").append("' THEN NULL ELSE TEMP.FProjectID END AS FProjectIDpk_hide,   \r\n");
        sql.append(" PROJECT.FNumber AS FProjectID,    \r\n");
        sql.append(" CASE  WHEN TEMP.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' THEN NULL ELSE TEMP.FTrackNumberID END AS FTrackNumberIDpk_hide,   \r\n");
        sql.append(" TRACKNUMBER.FNumber AS FTrackNumberID,    \r\n");
        sql.append(" CASE  WHEN TEMP.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' THEN NULL ELSE TEMP.FCustomerID END AS FCustomerIDpk_hide,   \r\n");
        sql.append(" CUSTOMER.FName_").append(this.loc).append(" AS FCustomerID,  \r\n");
        sql.append(" CUSTOMER.FNumber AS CUSTOMERNUMBER,   \r\n");
        sql.append(" CASE  WHEN TEMP.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' THEN NULL ELSE TEMP.FSupplierID END AS FSupplierIDpk_hide,   \r\n");
        sql.append(" SUPPLIER.FNumber AS SUPPLIERNUMBER,   \r\n");
        sql.append(" SUPPLIER.FName_").append(this.loc).append(" AS FSupplierID,   \r\n");
        sql.append(" TEMP.FStorageOrgUnitID AS FStorageOrgUnitIDpk_hide,  \r\n");
        sql.append(" STORAGEORGUNIT.FNumber AS STORAGEORGNUMBER,  \r\n");
        sql.append(" STORAGEORGUNIT.FName_").append(this.loc).append(" AS FStorageOrgUnitID,  \r\n");
        sql.append(" TEMP.FCompanyOrgUnitID AS FCompanyOrgUnitIDpk_hide,    \r\n");
        sql.append(" COMPANYORGUNIT.FNumber AS COMPANYORGNUMBER,    \r\n");
        sql.append(" COMPANYORGUNIT.FName_").append(this.loc).append(" AS FCompanyOrgUnitID,    \r\n");
        sql.append(" MULTIASSISTUNIT.FQtyPrecision AS MULTIASSISTUNITQTYPRECISION,    \r\n");
        sql.append(" MULTIBASEUNIT.FQtyPrecision AS MULTIBASEUNITQTYPRECISION,     \r\n");
        sql.append(" MULTIUNIT.FQtyPrecision AS MULTIUNITQTYPRECISION,    \r\n");
        sql.append(" INVENTORYUNIT.FName_").append(this.loc).append(" AS INVENTORYUNITNAME,     \r\n");
        sql.append(" MULTIINVENTORYUNIT.FQtyPrecision AS MULTIINVENTORYUNITQTYPRECIS54 ");
        return sql;
    }

    @Override
    protected StringBuilder getDefaultFromSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM ").append(this.tempTable_reservationInv).append(" AS TEMP \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON TEMP.FCustomerID = CUSTOMER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON TEMP.FSupplierID = SUPPLIER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATE ON TEMP.FStoreStatusID = STORESTATE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON TEMP.FStoreTypeID = STORETYPE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON TEMP.FLocationID = LOCATION.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON TEMP.FWarehouseID = WAREHOUSE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT ON TEMP.FStorageOrgUnitID = STORAGEORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON TEMP.FMaterialID = MATERIAL.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON TEMP.FUnitID = UNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS BBASEUNIT ON TEMP.FBaseUnitID = BBASEUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON TEMP.FAssistUnitID = ASSISTUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON TEMP.FMaterialID = MULTIUNIT.FMaterialID AND TEMP.FUnitID = MULTIUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON TEMP.FMaterialID = MULTIBASEUNIT.FMaterialID AND TEMP.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSISTUNIT ON TEMP.FMaterialID = MULTIASSISTUNIT.FMaterialID AND TEMP.FAssistUnitID = MULTIASSISTUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON TEMP.FAssistPropertyID = ASSISTPROPERTY.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ON TEMP.FCompanyOrgUnitID = COMPANYORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON TEMP.FProjectID = PROJECT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON TEMP.FTrackNumberID = TRACKNUMBER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialInventory AS MATINVENTORY ON TEMP.FStorageOrgUnitID = MATINVENTORY.FOrgUnit AND TEMP.FMaterialID = MATINVENTORY.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON TEMP.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND TEMP.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND TEMP.FLot = DATEOFMINDURABILITY.FLot \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS INVENTORYUNIT ON MATINVENTORY.FUnitID = INVENTORYUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIINVENTORYUNIT ON MATINVENTORY.FMaterialID = MULTIINVENTORYUNIT.FMaterialID AND MATINVENTORY.FUnitID = MULTIINVENTORYUNIT.FMeasureUnitID \r\n");
        return sb;
    }

    @Override
    protected StringBuilder getDefaultWhereSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("WHERE 1 = 1 ");
        MaterialInfo material = (MaterialInfo)this.params.get("material");
        Object[] storage = (Object[])this.params.get("storageOrgSet");
        if (material == null) {
            sb.append(" and 1=2 ");
            return sb;
        }
        sb.append(" and TEMP.FMaterialid = '").append(material.getId().toString()).append("' ");
        String sqlOrg = "";
        int n = storage.length;
        for (int i = 0; i < n; ++i) {
            sqlOrg = sqlOrg + "or TEMP.FStorageOrgUnitID = '" + ((OrgUnitInfo)storage[i]).getId().toString() + "' ";
        }
        sqlOrg = storage.length > 0 ? sqlOrg.substring(2, sqlOrg.length()) : "1 = 2 ";
        sb.append(" and ( TEMP.fbaseqty <> 0 or TEMP.flockbaseqty <>0)");
        sb.append(" and (" + sqlOrg + ") ");
        if (this.warepermSql != null) {
            sb.append(this.warepermSql);
        }
        return sb;
    }

    @Override
    protected StringBuilder getDefaultOrderBySQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ORDER BY WAREHOUSE.NUMBER ASC, LOCATION.NUMBER ASC, MATERIAL.NUMBER ASC");
        return sb;
    }

    protected StringBuilder getDefaultGroupBySQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ORDER BY WAREHOUSE.NUMBER ASC, LOCATION.NUMBER ASC, MATERIAL.NUMBER ASC");
        return sb;
    }

    private String getCreateInvReservationTempTableSql() throws BOSException, EASBizException {
        StringBuilder sb = new StringBuilder(512);
        sb.append("Create Table ").append(this.tempTable_reservationInv);
        sb.append("( ");
        sb.append("FID VARCHAR(44) DEFAULT '' NOT NULL");
        sb.append(",FCompanyOrgUnitID VARCHAR(44)");
        sb.append(",FStorageOrgUnitID VARCHAR(44)");
        sb.append(",FWarehouseID VARCHAR(44)");
        sb.append(",FLocationID VARCHAR(44)");
        sb.append(",FStoreTypeID VARCHAR(44)");
        sb.append(",FStoreStatusID VARCHAR(44)");
        sb.append(",FLot NVARCHAR(80)");
        sb.append(",FSupplierID VARCHAR(44)");
        sb.append(",FCustomerID VARCHAR(44)");
        sb.append(",FMaterialID VARCHAR(44)");
        sb.append(",FUnitID VARCHAR(44)");
        sb.append(",FCurStoreQty NUMERIC(28,16) DEFAULT 0");
        sb.append(",FAssistUnitID VARCHAR(44)");
        sb.append(",FCurStoreAssistQty NUMERIC(28,16)");
        sb.append(",FBaseQty NUMERIC(28,16) DEFAULT 0");
        sb.append(",FAmount NUMERIC(19,4) DEFAULT 0");
        sb.append(",FControlUnitID VARCHAR(44)");
        sb.append(",FBaseUnitID VARCHAR(44)");
        sb.append(",FExp DateTime");
        sb.append(",FAssistPropertyID VARCHAR(44)");
        sb.append(",FLockQty NUMERIC(28,16) DEFAULT 0 NOT NULL");
        sb.append(",FLockBaseQty NUMERIC(28,16) DEFAULT 0 NOT NULL");
        sb.append(",FLockAssistQty NUMERIC(28,16) DEFAULT 0 NOT NULL");
        sb.append(",FLastUpdateTime DateTime NOT NULL ");
        sb.append(",FCreatorID VARCHAR(44)");
        sb.append(",FCreateTime DateTime");
        sb.append(",FLastUpdateUserID VARCHAR(44)");
        sb.append(",FProjectID VARCHAR(44) DEFAULT ''");
        sb.append(",FTrackNumberID VARCHAR(44) DEFAULT ''");
        sb.append(",FReservationBaseQty NUMERIC(28,16) DEFAULT 0");
        sb.append(",FReservationAssistQty NUMERIC(28,16) DEFAULT 0");
        sb.append(")");
        return sb.toString();
    }

    private String getInsertInvReservationTempTableSql(Map params) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder(512);
        sql.append("select TEMP.*,reservation.FReservationBaseQty as FReservationBaseQty,reservation.FReservationAssistQty as FReservationAssistQty");
        sql.append(" into ").append(this.tempTable_reservationInv);
        sql.append(" from t_im_inventory as TEMP left outer join ");
        sql.append(" (");
        sql.append(" select finventoryid, sum(FReservationBaseQty) as FReservationBaseQty,isnull(sum(FReservationAssistQty), 0) as FReservationAssistQty");
        sql.append(" from t_im_reservation where finventoryid is not null and FReservationBaseQty>0");
        sql.append(" group by finventoryid");
        sql.append(" ) as reservation on TEMP.fid=reservation.finventoryid");
        MaterialInfo material = (MaterialInfo)params.get("material");
        Object[] storage = (Object[])params.get("storageOrgSet");
        if (material == null) {
            sql.append(" where 1=2 ");
            return sql.toString();
        }
        sql.append(" where TEMP.fmaterialid = '" + material.getId() + "' ");
        String sqlOrg = "";
        int n = storage.length;
        for (int i = 0; i < n; ++i) {
            sqlOrg = sqlOrg + "or TEMP.FStorageOrgUnitID = '" + ((OrgUnitInfo)storage[i]).getId().toString() + "' ";
        }
        sqlOrg = storage.length > 0 ? sqlOrg.substring(2, sqlOrg.length()) : "1 = 2 ";
        sql.append(" and ( TEMP.fbaseqty <> 0 or TEMP.flockbaseqty <>0)");
        sql.append(" and (" + sqlOrg + ") ");
        if (this.warepermSql != null) {
            sql.append(this.warepermSql);
        }
        return sql.toString();
    }

    protected String getTempTableName(String desc) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)this.ctx).getTableName(desc);
    }

    private void initReservationInvTempTable() throws BOSException {
        if (this.tempTable_reservationInv == null) {
            this.tempTable_reservationInv = this.getTempTableName("t_im_reservationInventory_temp");
        }
    }

    private void initPermSql() {
        Set cuUnitSets = InvServerUtils.getAuthorizedf7Orgs(this.ctx);
        Map warepermRuleMap = InvServerUtils.getPemissionSqlMap(this.ctx, cuUnitSets, "WAREHOUSE.", "warehous_view");
        this.warepermSql = InvServerUtils.getPermSql(warepermRuleMap, "TEMP.");
    }

    private String getQuerySql(Map params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select FOrgUnitID,FOrgUnitName,");
        sql.append("FStoreTypeName,sum(FUsableQty),sum(FReservationQty),sum(FUnReservationQty),sum(FLockBaseQty),sum(FWaitCheckQty),sum(FFreezeQuery),");
        sql.append("sum(FTotalQty),sum(FTotalReservationQty),sum(FTotalUnReservationQty),sum(FAssiUsableQty)");
        sql.append(",sum(FReservationAssistQty),sum(FUnReservationAssistQty),sum(FAssiLockQty),sum(FAssiWaitCheckQty),sum(FAssiFreezeQuery),sum(FAssiTotalQty),sum(FTotalReservationAssistQty),sum(FTotalUnReservationAssistQty),FCompanyorgUnitID,");
        sql.append("FStorageOrgUnitID,FWarehouseID,FStoreTypeID,FParentID,FLevel,Fisleaf");
        sql.append(" from ");
        sql.append(params.get("tempTable").toString() + " ");
        return sql.toString();
    }

    private void updateLeaf(String tempTable, Map params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + tempTable + " set ");
        sql.append("FOrgUnitIDpk_hide = FStorageOrgUnitIDpk_hide,");
        sql.append("FOrgUnitID = FStorageOrgUnitID,");
        sql.append("FParentID = FCompanyorgunitID,");
        sql.append("Fisleaf = 0,");
        sql.append("FLevel = 2");
        sql.append("where ");
        sql.append("FWarehouseIDpk_hide is null");
    }

    private String getGroup1(String tempTable, Map params) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTable + " ");
        sql.append("select ");
        sql.append("newbosid('88888888'),");
        sql.append("FStorageOrgUnitID as FOrgUnitID,");
        sql.append("FStorageOrgUnitIDpk_hide as FOrgUnitIDpk_hide,");
        sql.append(this.groupFieldStr);
        sql.append("sum(FUsableQty) as FUsableQty,");
        sql.append("sum(FLockBaseQty) as FLockBaseQty,");
        sql.append("sum(FWaitCheckQty) as FWaitCheckQty,");
        sql.append("sum(FFreezeQuery) as FFreezeQuery,");
        sql.append("sum(FUsableQty) + sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) as FtotalQty,");
        sql.append("sum(FAssiUsableQty) as FAssiUsableQty,");
        sql.append("sum(FAssiLockQty) as FAssiLockQty,");
        sql.append("sum(FAssiWaitCheckQty) as FAssiWaitCheckQty,");
        sql.append("sum(FAssiFreezeQuery) as FAssiFreezeQuery,");
        sql.append("sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) as FAssitotalQty,");
        sql.append("0 as Fisleaf,");
        sql.append("2 as FLevel ");
        sql.append(",sum(FReservationQty) as FReservationQty");
        sql.append(",sum(FUsableQty) - sum(FReservationQty) as FUnReservationQty");
        sql.append(",sum(FTotalReservationQty) as FTotalReservationQty");
        sql.append(",sum(FUsableQty) + sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) - sum(FTotalReservationQty) as FTotalUnReservationQty");
        sql.append(",sum(FReservationAssistQty) as FReservationAssistQty");
        sql.append(",sum(FAssiUsableQty) - sum(FReservationAssistQty) as FUnReservationAssistQty");
        sql.append(",sum(FTotalReservationAssistQty) as FTotalReservationAssistQty");
        sql.append(",sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) - sum(FTotalReservationAssistQty) as FTotalUnReservationAssistQty");
        sql.append(",FCompanyOrgUnitIDpk_hide as FParentID");
        sql.append(",FCompanyorgUnitIDpk_hide as FCompanyorgUnitIDpk_hide");
        sql.append(",FStorageOrgUnitIDpk_hide as FStorageOrgUnitIDpk_hide");
        sql.append(",null as FWarehouseIDpk_hide");
        sql.append(",FCompanyOrgUnitID as FCompanyOrgUnitID");
        sql.append(",FStorageOrgUnitID as FStorageOrgUnitID");
        sql.append(" from " + tempTable + " ");
        sql.append(" where flevel = 3 ");
        sql.append(" group by ");
        sql.append(this.groupFieldStr);
        sql.append(" FCompanyOrgUnitIDpk_hide,FStorageOrgUnitIDpk_hide,FCompanyOrgUnitID,FStorageOrgUnitID ");
        return sql.toString();
    }

    private String getGroup2(String tempTable, Map params) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTable + " ");
        sql.append("select ");
        sql.append("newbosid('88888888'),");
        sql.append("FCompanyOrgUnitID as FOrgUnitID,");
        sql.append("FCompanyOrgUnitIDpk_hide as FOrgUnitIDpk_hide,");
        sql.append(this.groupFieldStr);
        sql.append("sum(FUsableQty) as FUsableQty,");
        sql.append("sum(FLockBaseQty) as FLockBaseQty,");
        sql.append("sum(FWaitCheckQty) as FWaitCheckQty,");
        sql.append("sum(FFreezeQuery) as FFreezeQuery,");
        sql.append("sum(FUsableQty) +  sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) as FtotalQty,");
        sql.append("sum(FAssiUsableQty) as FAssiUsableQty,");
        sql.append("sum(FAssiLockQty) as FAssiLockQty,");
        sql.append("sum(FAssiWaitCheckQty) as FAssiWaitCheckQty,");
        sql.append("sum(FAssiFreezeQuery) as FAssiFreezeQuery,");
        sql.append("sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) as FAssitotalQty,");
        sql.append("0 as Fisleaf,");
        sql.append("1 as FLevel ");
        sql.append(",sum(FReservationQty) as FReservationQty");
        sql.append(",sum(FUsableQty) - sum(FReservationQty) as FUnReservationQty");
        sql.append(",sum(FTotalReservationQty) as FTotalReservationQty");
        sql.append(",sum(FUsableQty) + sum(FLockBaseQty) + sum(FWaitCheckQty) + sum(FFreezeQuery) - sum(FTotalReservationQty) as FTotalUnReservationQty");
        sql.append(",sum(FReservationAssistQty) as FReservationAssistQty");
        sql.append(",sum(FAssiUsableQty) - sum(FReservationAssistQty) as FUnReservationAssistQty");
        sql.append(",sum(FTotalReservationAssistQty) as FTotalReservationAssistQty");
        sql.append(",sum(FAssiUsableQty) + sum(FAssiLockQty) + sum(FAssiWaitCheckQty) + sum(FAssiFreezeQuery) - sum(FTotalReservationAssistQty) as FTotalUnReservationAssistQty");
        sql.append(",null as FParentID");
        sql.append(",FCompanyorgUnitIDpk_hide as FCompanyorgUnitIDpk_hide");
        sql.append(",null as FStorageOrgUnitIDpk_hide");
        sql.append(",null as FWarehouseIDpk_hide");
        sql.append(",FCompanyOrgUnitID as FCompanyOrgUnitID");
        sql.append(",null as FStorageOrgUnitID");
        sql.append(" from " + tempTable + " ");
        sql.append("where flevel = 2 ");
        sql.append("group by ");
        sql.append(this.groupFieldStr);
        sql.append(" FCompanyOrgUnitIDpk_hide,FCompanyOrgUnitID ");
        return sql.toString();
    }

    private void updateOrgName(String tempTable, Map params) throws BOSException {
        String resFile = "com.kingdee.eas.scm.im.rpt.IMRptResource";
        String companyOrgUnit = SCMUtils.getResource((String)resFile, (String)"companyOrgUnit", (Context)this.ctx);
        String storageOrgUnit = SCMUtils.getResource((String)resFile, (String)"storageOrgUnit", (Context)this.ctx);
        String sql = "update " + tempTable + " set FOrgUnitID = FOrgUnitID || '(" + companyOrgUnit + ")' where flevel = 1 ";
        this.executeSQL(sql);
        sql = "update " + tempTable + " set FOrgUnitID = FOrgUnitID || '(" + storageOrgUnit + ")' where flevel = 2 ";
        this.executeSQL(sql);
    }

    private void updateZeroToNull(String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String[] fields = new String[]{"FUsableQty", "FLockBaseQty", "FWaitCheckQty", "FFreezeQty", "FTotalQty", "FAssiUsableQty", "FAssiLockQty", "FAssiWaitCheckQty", "FAssiFreezeQuery", "FAssiTotalQty"};
        sql.append("update " + tempTable + " set (FUsableQty,FLockBaseQty,FWaitCheckQty,FFreezeQty,");
        sql.append("FAssiUsableQty,FAssiLockQty,FAssiWaitCheckQty,FAssiFreezeQuery,FReservationQty,FUnReservationQty,FTotalReservationQty,FTotalUnReservationQty,FReservationAssistQty,FUnReservationAssistQty,FTotalReservationAssistQty,FTotalUnReservationAssistQty) =  ");
        sql.append("");
    }

    private void levelGroupByStorageOrg(String newTempTableName, Map params) throws BOSException, EASBizException {
        String tempTable = newTempTableName;
        String orgTempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"134_InventoryGeneralRptFacadeControllerBean", (Locale)this.ctx.getLocale()));
        StringBuffer sql = new StringBuffer();
        sql.append("create table " + orgTempTable + " (");
        sql.append("fid varchar(44),");
        sql.append("fname varchar(100),");
        sql.append("fparentid varchar(44),");
        sql.append("frootid varchar(44),");
        sql.append("flevel int,");
        sql.append("fisleaf int");
        sql.append(")");
        this.executeSQL(sql.toString());
        Object[] storageOrg = (Object[])params.get("storageOrgSet");
        if (storageOrg == null) {
            return;
        }
        sql = new StringBuffer();
        int maxLevel = 0;
        Vector<String> v = new Vector<String>();
        OrgUnitInfo orgUnitInfo = null;
        String fLongNumber = null;
        String frootid = null;
        HashMap<String, String> map = new HashMap<String, String>();
        int n = storageOrg.length;
        for (int i = 0; i < n; ++i) {
            orgUnitInfo = (OrgUnitInfo)storageOrg[i];
            fLongNumber = (String)orgUnitInfo.get("longNumber");
            map.put(fLongNumber, orgUnitInfo.get("id").toString());
        }
        String pSql = "insert into " + orgTempTable + "(fid,fname,fparentid,frootid,flevel,fisleaf) values(?,?,?,?,?,?)";
        int n2 = storageOrg.length;
        for (int i = 0; i < n2; ++i) {
            Integer fisleaf;
            orgUnitInfo = (OrgUnitInfo)storageOrg[i];
            frootid = null;
            fLongNumber = (String)orgUnitInfo.get("longNumber");
            StringBuffer parentLongNumber = new StringBuffer();
            String[] lnSecs = fLongNumber.split("!");
            int m = lnSecs.length - 1;
            for (int j = 0; j < m; ++j) {
                if (j != 0) {
                    parentLongNumber.append("!");
                }
                parentLongNumber.append(lnSecs[j]);
                if (!map.containsKey(parentLongNumber.toString())) continue;
                frootid = (String)map.get(parentLongNumber.toString());
                break;
            }
            if (frootid == null) {
                frootid = (String)map.get(fLongNumber);
            }
            String fid = orgUnitInfo.get("id").toString();
            Integer flevel = (Integer)orgUnitInfo.get("level");
            String fname = (String)orgUnitInfo.get("name");
            OrgUnitInfo parent = (OrgUnitInfo)orgUnitInfo.get("parent");
            Integer n3 = fisleaf = ((OrgUnitInfo)storageOrg[i]).isIsLeaf() ? new Integer("1") : new Integer("0");
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            SqlParams sqlParams = new SqlParams();
            sqlParams.addString(fid);
            if (fname != null) {
                sqlParams.addString(fname);
            } else {
                sqlParams.addString(null);
            }
            if (parent != null) {
                sqlParams.addString(parent.getId().toString());
            } else {
                sqlParams.addString(null);
            }
            sqlParams.addString(frootid);
            sqlParams.addInt(flevel.intValue());
            sqlParams.addInt(fisleaf.intValue());
            DbUtil.execute((Context)this.ctx, (String)pSql, (Object[])sqlParams.getParams());
        }
        sql = new StringBuffer();
        sql.append("update " + tempTable + " set (FStorageOrgUnitID,FLevel) = (");
        sql.append("select b.fname,b.flevel + 1 from " + orgTempTable + " b where ");
        sql.append("b.fid = " + tempTable + ".FParentID and " + tempTable + ".FWarehouseIDpk_hide is not null ");
        sql.append(")");
        this.executeSQL(sql.toString());
        sql = new StringBuffer();
        sql.append("update " + tempTable + " set (FStorageOrgUnitID,FLevel) = (");
        sql.append("select b.fname,b.flevel from " + orgTempTable + " b where ");
        sql.append("b.fid = " + tempTable + ".FOrgUnitIDpk_hide ");
        sql.append(")");
        this.executeSQL(sql.toString());
        String sqle = "";
        sql = new StringBuffer();
        sql.append("insert into " + tempTable);
        sql.append(" select ");
        sql.append("newbosid('88888888'),");
        sql.append("null as FOrgUnitID,");
        sql.append("b.FParentID as FOrgUnitIDpk_hide,");
        sql.append(this.groupFieldStr);
        sql.append("sum(a.FUsableQty) as FUsableQty,");
        sql.append("sum(a.FLockBaseQty) as FLockBaseQty,");
        sql.append("sum(a.FWaitCheckQty) as FWaitCheckQty,");
        sql.append("sum(a.FFreezeQuery) as FFreezeQuery,");
        sql.append("sum(a.FUsableQty) +  sum(FLockBaseQty) + sum(a.FWaitCheckQty) + sum(a.FFreezeQuery) as FtotalQty,");
        sql.append("sum(a.FAssiUsableQty) as FAssiUsableQty,");
        sql.append("sum(a.FAssiLockQty) as FAssiLockQty,");
        sql.append("sum(a.FAssiWaitCheckQty) as FAssiWaitCheckQty,");
        sql.append("sum(a.FAssiFreezeQuery) as FAssiFreezeQuery,");
        sql.append("sum(a.FAssiUsableQty) + sum(a.FAssiLockQty) + sum(a.FAssiWaitCheckQty) + sum(a.FAssiFreezeQuery) as FAssitotalQty,");
        sql.append("0 as Fisleaf,");
        sql.append("b.Flevel - 1 as FLevel ");
        sql.append(",sum(a.FReservationQty) as FReservationQty");
        sql.append(",sum(a.FUsableQty) - sum(a.FReservationQty) as FUnReservationQty");
        sql.append(",sum(a.FTotalReservationQty) as FTotalReservationQty");
        sql.append(",sum(a.FUsableQty) + sum(a.FLockBaseQty) + sum(a.FWaitCheckQty) + sum(a.FFreezeQuery) - sum(a.FTotalReservationQty) as FTotalUnReservationQty");
        sql.append(",sum(a.FReservationAssistQty) as FReservationAssistQty");
        sql.append(",sum(a.FAssiUsableQty) - sum(a.FReservationAssistQty) as FUnReservationAssistQty");
        sql.append(",sum(a.FTotalReservationAssistQty) as FTotalReservationAssistQty");
        sql.append(",sum(a.FAssiUsableQty) + sum(a.FAssiLockQty) + sum(a.FAssiWaitCheckQty) + sum(a.FAssiFreezeQuery) - sum(a.FTotalReservationAssistQty) as FTotalUnReservationAssistQty");
        sql.append(",null as FParentID");
        sql.append(",null as FCompanyorgUnitIDpk_hide");
        sql.append(",b.FParentID as FStorageOrgUnitIDpk_hide");
        sql.append(",null as FWarehouseIDpk_hide");
        sql.append(",null as FCompanyOrgUnitID");
        sql.append(",null as FStorageOrgUnitID");
        sql.append(" from  " + tempTable + " a,");
        sql.append(orgTempTable + " b ");
        sql.append(" where a.FOrgUnitIDpk_hide is not null and a.fstorageorgunitidpk_hide = b.fid and a.fwarehouseidpk_hide is null and b.flevel = ");
        for (int i = maxLevel; i > 1; --i) {
            sqle = sql.toString() + i + " group by " + this.groupFieldStr + "b.fparentid,b.flevel ";
            this.executeSQL(sqle);
        }
        sql = new StringBuffer();
        sql.append("update " + tempTable + " set (FOrgUnitID,FStorageOrgUnitID,FParentID) = (");
        sql.append("select b.fname,b.fname,b.fparentid from " + orgTempTable + " b where ");
        sql.append("b.fid = " + tempTable + ".FOrgUnitIDpk_hide ");
        sql.append(")");
        this.executeSQL(sql.toString());
        sql = new StringBuffer();
        sql.append("update " + tempTable + " set (FCompanyOrgUnitIDpk_hide,FCompanyOrgUnitID) = (");
        sql.append("select b.frootid,'' from " + orgTempTable + " b where ");
        sql.append("b.fid = " + tempTable + ".FStorageOrgUnitIDpk_hide ");
        sql.append(")");
        this.executeSQL(sql.toString());
        this.dropTable(orgTempTable);
    }

    private void executeSQL(String sql) throws BOSException {
        DbUtil.execute((Context)this.ctx, (String)sql);
    }

    protected void dropTable(String tableName) throws BOSException {
        if (tableName == null) {
            return;
        }
        ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)this.ctx);
        manager.releaseTableName(tableName);
    }
}

