/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.app.AbstractInventoryLogFacadeControllerBean;
import com.kingdee.util.LocaleUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryLogFacadeControllerBean
extends AbstractInventoryLogFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.rpt.app.InventoryLogFacadeControllerBean");
    private static String res = "com.kingdee.eas.scm.im.rpt.IMRptResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = this.crtTempTable(ctx, params);
        params.setObject("tempTable", (Object)tempTable);
        this.insertLogData(ctx, params);
        RptTableHeader header = this.buildHead(ctx, params);
        StringBuffer countSql = new StringBuffer("select count(1) from ").append(tempTable).append(" t ");
        RptRowSet rsCount = this.executeQuery(countSql.toString(), null, ctx);
        rsCount.next();
        int count = rsCount.getInt(0);
        RptParams result = new RptParams();
        result.setInt("totalCount", count);
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        return result;
    }

    protected void insertBillData(Context ctx, RptParams params, String beginDate) throws BOSException {
        String[][] tableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}};
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append("insert into ").append(tempTable).append(" ").append("(").append("FIndex,FStorageOrgUnitID,FMaterialID,FWarehouseID,FLocationID,FLot,FAssistProPertyID,").append(beginDate == null ? "FBillQty" : "FBeginQty").append(") ").append("\r\n");
        sql.append("select  ").append("-1 as FIndex,a.FStorageOrgUnitID,a.FMaterialID,a.FWarehouseID,a.FLocationID,a.FLot,a.FAssistProPertyID,").append("sum(FBaseQty) as FBillQty ").append("from ( ").append("\r\n");
        for (int i = 0; i < tableName.length; ++i) {
            if (i != 0) {
                sql.append(" union all ").append("\r\n");
            }
            sql.append(this.getBillSql(params, tableName[i][0], tableName[i][1], beginDate, ctx)).append(" ");
            sql.append("\r\n");
        }
        sql.append("\r\n").append(") a ").append("group by ").append("a.FStorageOrgUnitID,a.FMaterialID,a.FWarehouseID,a.FLocationID,a.FLot,a.FAssistProPertyID ");
        this.executeSQL(ctx, sql.toString());
    }

    protected String getInsertSql(RptParams params) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append("insert into ").append(tempTable).append(" ").append("()").append("FStorageOrgUnitID,FTransactiontypeID,FBillNumber,FBizdate,").append("FMaterialID,FWarehouseID,FLocationID,FLot,FAssistProPertyID,FStoreTypeID,FStoreStatusID,").append("FBeginQty,FInQty,FOutQty,FEndQty,FBillInQty,FBillOutQty,FInventoryQty");
        return sql.toString();
    }

    protected void insertBalanceData(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String so = (String)params.getObject("bizStorageOrgUnit");
        so = so.replaceAll(" ", "");
        String dpDate = params.getObject("dpDate").toString();
        dpDate = dpDate.substring(0, dpDate.indexOf(" "));
        Date dateFrom = null;
        try {
            dateFrom = IMRptUtils.getStrDate(dpDate, null);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        StringTokenizer st = new StringTokenizer(so, ";");
        String storageOrgUnit = (String)st.nextElement();
        sql.append("select ").append("case when to_date('").append(dpDate).append("') <=  g.fbegindate  then g.fbegindate ").append("when to_date('").append(dpDate).append("') >= h.fbegindate  then h.fbegindate ").append("else to_date('").append(dpDate).append("') end as bdate,").append("g.ftypeid as fperiodtypeid ").append("from t_org_storage a ").append("inner join T_ORG_UnitRelation b  on a.fid = b.ffromunitid ").append("inner join T_ORG_TypeRelation c  on b.FTypeRelationID = c.FID ").append("inner join t_org_company d on  b.ftounitid = d.fid ").append("inner join T_BD_SystemStatusCtrol e on e.FCompanyID = d.fid ").append("inner join T_BD_SystemStatus f on e.FSystemStatusID = f.fid ").append("inner join t_bd_period g on e.fstartperiodid = g.fid ").append("inner join t_bd_period h on e.fcurrentperiodid = h.fid ").append("where ").append("a.fnumber = '").append(storageOrgUnit).append("' ").append("and c.FFromType = ").append(4).append(" ").append("and c.FToType = ").append(1).append(" ").append("and  f.fname = ").append(2).append(" ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        Date bDate = null;
        String fperiodtypeid = "";
        if (rs.next()) {
            bDate = (Date)rs.getObject("bdate");
            fperiodtypeid = rs.getString("fperiodtypeid");
        }
        if (bDate == null) {
            bDate = new Date();
        }
        sql = new StringBuffer();
        sql.append("select fperiodYear,fperiodNumber,fbeginDate from t_bd_period where ftypeid = '").append(fperiodtypeid).append("' ").append("and fbeginDate <= to_date('").append(IMRptUtils.getFmtDate(bDate)).append("') ").append("and fendDate >= to_date('").append(IMRptUtils.getFmtDate(bDate)).append("') ");
        rs = this.executeQuery(sql.toString(), null, ctx);
        int beginYear = 0;
        int beginPeriod = 0;
        if (rs.next()) {
            beginYear = rs.getInt("fperiodYear");
            beginPeriod = rs.getInt("fperiodNumber");
            bDate = (Date)rs.getObject("fbeginDate");
        }
        sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append("insert into ").append(tempTable).append(" ").append("(").append("FIndex,FStorageOrgUnitID,").append("FMaterialID,FWarehouseID,FLocationID,FLot,FAssistProPertyID,FStoreStatusID,").append("FBeginQty) ");
        sql.append("select ").append("-1 as FIndex,d.FStorageOrgUnitID,").append("d.FMaterialID,d.FWarehouseID,d.FLocationID,d.FLot,d.FAssistProPertyID,d.FStoreStatusID,").append("d.FPeriodBeginQty ").append("from t_im_inventorybalance d ").append(this.getJoinSql(params, "d")).append("where 1 = 1 ").append("and d.FYear = ").append(beginYear).append(" ").append("and d.FPeriod = ").append(beginPeriod).append(" ").append("and ").append(this.getWhereSql(params, ctx));
        this.executeSQL(ctx, sql.toString());
        if (!IMRptUtils.getFmtDate(bDate).equals(dpDate)) {
            this.insertBillData(ctx, params, IMRptUtils.getFmtDate(bDate));
        }
        this.executeSQL(ctx, "update " + tempTable + " set FEndQty = FBeginQty + FQty ");
    }

    protected void insertInventoryData(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append("insert into ").append(tempTable).append(" ").append("(").append("FIndex,FStorageOrgUnitID,").append("FMaterialID,FWarehouseID,FLocationID,FLot,FAssistProPertyID,FStoreStatusID,").append("FInventoryQty) ");
        sql.append("select ").append("-1 as FIndex,d.FStorageOrgUnitID,").append("d.FMaterialID,d.FWarehouseID,d.FLocationID,d.FLot,d.FAssistProPertyID,d.FStoreStatusID,").append("d.FBaseQty ").append("from t_im_inventory d ").append(this.getJoinSql(params, "d")).append("where 1 = 1 ").append("and ").append(this.getWhereSql(params, ctx));
        this.executeSQL(ctx, sql.toString());
    }

    protected void insertLogData(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String locName = this.getLocName(ctx);
        sql.append("insert into ").append(tempTable).append(" ").append("(").append("FIndex,FStorageOrgUnitID,FStorageOrgUnitNumber,FStorageOrgUnitName,FTransactiontypeID,FtransactionTypeName,").append("FBillTypeName,FBillNumber,FBizdate,FOperateType,FAuditTime,").append("FMaterialID,FMaterialNumber,FMaterialName,FModel,FWarehouseID,FWarehouseName,FLocationID,FLocationName,").append("FLot,FAssistProPertyID,FAssistProPertyName,").append("FProjectID,FProjectNumber,FProjectName,FTrackNumID,FTrackNumNumber,FTrackNumName,").append("FStoreTypeID,FStoreTypeName,FStoreStatusID,FStoreStatusName,FQty,FPreInvQty) ");
        sql.append("select ").append("-1 as FIndex,d.FStorageOrgUnitID,so.FNumber as FStorageOrgUnitNumber,so." + locName + ",d.FTransactiontypeID,tr." + locName + ",").append("bt." + locName + ",d.FBillNumber,d.FBizdate,d.FOperateType,d.FUpdateTime,").append("d.FMaterialID,m.FNumber,m." + locName + ",m.FModel,d.FWarehouseID,w." + locName + ",").append("d.FLocationID,l." + locName + ",d.FLot,d.FAssistProPertyID,a." + locName + ",").append("d.FProjectID,p.FNumber,p." + locName + ",d.FTrackNumberID,t.FNumber,t." + locName + ",").append("d.FStoreTypeID,st." + locName + ",d.FStoreStatusID,ss." + locName + ",").append("d.FBaseQty,d.FInvBaseQty  ").append("from t_im_inventorylog d ").append(this.getJoinSql(params, "d")).append("inner join t_scm_transactiontype tr on d.FTransactionTypeID = tr.FID ").append("inner join t_scm_billtype bt on tr.FBillTypeID = bt.FID ");
        sql.append("where ").append(this.getWhereSql(params, ctx));
        this.executeSQL(ctx, sql.toString());
    }

    protected String getBillSql(RptParams params, String headTb, String entryTb, String beginDate, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String dpDate = params.getObject("dpDate").toString();
        String dpDateTo = params.getObject("dpDateTo").toString();
        boolean ckOnlyShowInOut = params.getBoolean("ckOnlyShowInOut");
        boolean ckOnlyShowExcept = params.getBoolean("ckOnlyShowExcept");
        String sign = "1";
        if (headTb.equals("T_IM_MaterialReqBill") || headTb.equals("T_IM_SaleIssueBill") || headTb.equals("T_IM_MoveIssueBill") || headTb.equals("T_IM_OtherIssueBill")) {
            sign = "-1";
        }
        if (beginDate != null) {
            dpDateTo = dpDate;
            dpDate = beginDate;
        }
        sql.append("select ").append("d.FStorageOrgUnitID,d.FMaterialID,d.FWarehouseID,d.FLocationID,d.FLot,d.FAssistProPertyID,").append(sign).append("*d.FBaseQty as FBaseQty ");
        StringBuffer joinSql = new StringBuffer(this.getJoinSql(params, "d"));
        StringBuffer sqlWhere = new StringBuffer(this.getWhereSql(params, ctx));
        if (params.getString("bizTransaction") != null) {
            sqlWhere.append(" and tr.FNumber >= '").append(params.getString("bizTransaction")).append("' ");
        }
        if (params.getString("bizTransactionTo") != null) {
            sqlWhere.append(" and tr.FNumber <= '").append(params.getString("bizTransactionTo")).append("' ");
        }
        if (params.getString("bizBillType") != null) {
            sqlWhere.append(" and bt.FNumber >= '").append(params.getString("bizBillType")).append("' ");
        }
        if (params.getString("bizBillTypeTo") != null) {
            sqlWhere.append(" and bt.FNumber <= '").append(params.getString("bizBillTypeTo")).append("' ");
        }
        sql.append("from ").append(headTb).append(" h ").append("inner join ").append(entryTb).append(" d  on ").append(" h.fid = d.fparentid ").append(joinSql).append("inner join t_scm_transactiontype tr on tr.fid = h.ftransactiontypeid ").append("inner join t_scm_billtype bt on tr.FBillTypeID = bt.FID ").append("where ").append("h.FBizDate >= to_date('").append(dpDate).append("') ").append("and h.FBizDate <= to_date('").append(dpDateTo).append("') ").append("and h.FBaseStatus = ").append(4).append(" ");
        if (headTb.equals("T_IM_SaleIssueBill") || headTb.equals("T_IM_PurInWarehsBill")) {
            sql.append("and (h.FIsInitBill = 0 or  h.FIsInitBill is null) ");
            if (ckOnlyShowExcept) {
                sql.append("and tr.FNumber <> '214E' ");
            }
        }
        sql.append("and ").append(sqlWhere);
        return sql.toString();
    }

    protected String getWhereSql(RptParams params, Context ctx) {
        String[] numArray;
        StringBuffer sqlWhere = new StringBuffer();
        String so = (String)params.getObject("bizStorageOrgUnit");
        so = so.replaceAll(" ", "");
        StringTokenizer st = new StringTokenizer(so, ";");
        sqlWhere.append(" so.FNumber in (");
        if (st.hasMoreElements()) {
            sqlWhere.append("'").append(st.nextElement()).append("'");
        }
        while (st.hasMoreElements()) {
            sqlWhere.append(",'").append(st.nextElement()).append("'");
        }
        sqlWhere.append(") ");
        String dpDate = params.getObject("dpDate").toString();
        String dpDateTo = params.getObject("dpDateTo").toString();
        sqlWhere.append("and d.FBizDate >= to_date('").append(dpDate).append("') ");
        sqlWhere.append("and d.FBizDate <= to_date('").append(dpDateTo).append("') ");
        if (params.getObject("bizTransaction") != null) {
            numArray = SCMUtil.getF7Numbers((Object)params.getObject("bizTransaction"));
            if (numArray[0] != null) {
                sqlWhere.append(" and tr.FNumber >= '").append(numArray[0]).append("' ");
            } else if (numArray[1] != null) {
                sqlWhere.append(" and tr.FNumber in (").append(numArray[1]).append(") ");
            }
        }
        if (params.getString("bizTransactionTo") != null) {
            sqlWhere.append(" and tr.FNumber <= '").append(params.getString("bizTransactionTo")).append("' ");
        }
        if (params.getString("bizBillType") != null) {
            sqlWhere.append(" and bt.FNumber >= '").append(params.getString("bizBillType")).append("' ");
        }
        if (params.getString("bizBillTypeTo") != null) {
            sqlWhere.append(" and bt.FNumber <= '").append(params.getString("bizBillTypeTo")).append("' ");
        }
        if (params.getString("txtBillNumber") != null) {
            sqlWhere.append(" and d.FBillNumber >= '").append(params.getString("txtBillNumber")).append("' ");
        }
        if (params.getString("txtBillNumberTo") != null) {
            sqlWhere.append(" and d.FBillNumber <= '").append(params.getString("txtBillNumberTo")).append("' ");
        }
        if (params.getObject("bizMaterial") != null) {
            numArray = SCMUtil.getF7Numbers((Object)params.getObject("bizMaterial"));
            if (numArray[0] != null) {
                sqlWhere.append(" and m.FNumber >= '").append(numArray[0]).append("' ");
            } else if (numArray[1] != null) {
                sqlWhere.append(" and m.FNumber in (").append(numArray[1]).append(") ");
            }
        }
        if (params.getString("bizMaterialTo") != null) {
            sqlWhere.append(" and m.FNumber <= '").append(params.getString("bizMaterialTo")).append("' ");
        }
        if (params.getObject("bizWarehouse") != null) {
            numArray = SCMUtil.getF7Numbers((Object)params.getObject("bizWarehouse"));
            if (numArray[0] != null) {
                sqlWhere.append(" and w.FNumber >= '").append(numArray[0]).append("' ");
            } else if (numArray[1] != null) {
                sqlWhere.append(" and w.FNumber in (").append(numArray[1]).append(") ");
            }
        }
        if (params.getString("bizWarehouseTo") != null) {
            sqlWhere.append(" and w.FNumber <= '").append(params.getString("bizWarehouseTo")).append("' ");
        }
        if (params.getObject("bizLocation") != null) {
            numArray = SCMUtil.getF7Numbers((Object)params.getObject("bizLocation"));
            if (numArray[0] != null) {
                sqlWhere.append(" and l.FNumber >= '").append(numArray[0]).append("' ");
            } else if (numArray[1] != null) {
                sqlWhere.append(" and l.FNumber in (").append(numArray[1]).append(") ");
            }
        }
        if (params.getString("bizLocationTo") != null) {
            sqlWhere.append(" and l.FNumber <= '").append(params.getString("bizLocationTo")).append("' ");
        }
        if (params.getString("txtLot") != null) {
            sqlWhere.append(" and d.FLot >= '").append(params.getString("txtLot")).append("' ");
        }
        if (params.getString("txtLotTo") != null) {
            sqlWhere.append(" and d.FLot <= '").append(params.getString("txtLotTo")).append("' ");
        }
        if (params.getString("bizAsstProp") != null) {
            sqlWhere.append(" and a.FNumber >= '").append(params.getString("bizAsstProp")).append("' ");
        }
        if (params.getString("bizAsstPropTo") != null) {
            sqlWhere.append(" and a.FNumber <= '").append(params.getString("bizAsstPropTo")).append("' ");
        }
        if (params.getString("bizProjectNumFrom") != null) {
            sqlWhere.append(" and p.FNumber >= '").append(params.getString("bizProjectNumFrom")).append("' ");
        }
        if (params.getString("bizProjectNumTo") != null) {
            sqlWhere.append(" and p.FNumber <= '").append(params.getString("bizProjectNumTo")).append("' ");
        }
        if (params.getString("bizTrackNumFrom") != null) {
            sqlWhere.append(" and t.FNumber >= '").append(params.getString("bizTrackNumFrom")).append("' ");
        }
        if (params.getString("bizTrackNumTo") != null) {
            sqlWhere.append(" and t.FNumber <= '").append(params.getString("bizTrackNumTo")).append("' ");
        }
        if (params.getString("bizStoreType") != null) {
            sqlWhere.append(" and st.FNumber = '").append(params.getString("bizStoreType")).append("' ");
        }
        if (params.getString("bizStoreStatus") != null) {
            sqlWhere.append(" and ss.FNumber = '").append(params.getString("bizStoreStatus")).append("' ");
        }
        return sqlWhere.toString();
    }

    protected String getJoinSql(RptParams params, String tbAlias) {
        StringBuffer joinSql = new StringBuffer();
        joinSql.append("inner join t_org_storage so on ").append(tbAlias).append(".FStorageOrgUnitID = so.FID ");
        joinSql.append("inner join t_bd_material m on  ").append(tbAlias).append(".FMaterialID = m.FID ");
        joinSql.append("left join t_db_warehouse w on  ").append(tbAlias).append(".FWarehouseID = w.FID ");
        joinSql.append("left join t_db_location l on  ").append(tbAlias).append(".FLocationID = l.FID ");
        joinSql.append("left join t_bd_asstattrvalue a on ").append(tbAlias).append(".FASSISTPROPERTYID = a.FID ");
        joinSql.append("left join t_mm_project p on ").append(tbAlias).append(".FProjectID = p.FID ");
        joinSql.append("left join t_mm_tracknumber t on ").append(tbAlias).append(".FTrackNumberID = t.FID ");
        joinSql.append("left join t_im_storetype st on  ").append(tbAlias).append(".fstoretypeid = st.fid ");
        joinSql.append("left join t_im_storestate ss on ").append(tbAlias).append(".fstorestatusid = ss.fid ");
        if (params.getString("materialTypeFrom") != null || params.getString("materialTypeTo") != null) {
            String mgStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
            joinSql.append("inner join T_BD_MaterialGroupDetial MGD on (MGD.FMaterialID = m.fid and MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("')  ");
            joinSql.append("inner join t_bd_materialGroup mg on MGD.fmaterialGroupid = mg.fid ");
        }
        return joinSql.toString();
    }

    protected void insertCheckData(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlBill = new StringBuffer();
        StringBuffer sqlWhere = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append("insert into ").append(tempTable).append("(").append("FStorageOrgUnitNum,FStorageOrgUnitName,FMaterialID,FMaterialNumber,").append("FMaterialName,FInvQty,FInvBaseQty,FBillQty,FBillBaseQty,").append("FLot,FWarehouseNum,FWarehouseName,FInventoryID,FUpdateSql) ").append("\r\n");
        String so = (String)params.getObject("bizStorageOrgUnit");
        so = so.replaceAll(" ", "");
        StringTokenizer st = new StringTokenizer(so, ";");
        if (st.hasMoreElements()) {
            sqlWhere.append("'").append(st.nextElement()).append("'");
        }
        while (st.hasMoreElements()) {
            sqlWhere.append(",'").append(st.nextElement()).append("'");
        }
        String[][] tableName = new String[][]{{"t_im_inventoryinitbill", "t_im_inventoryinitentry"}, {"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}};
        for (int i = 0; i < tableName.length; ++i) {
            if (i != 0) {
                sqlBill.append(" union all ").append("\r\n");
            }
            String sign = "1";
            if (tableName[i][0].equals("T_IM_SaleIssueBill") || tableName[i][0].equals("T_IM_MaterialReqBill") || tableName[i][0].equals("T_IM_MoveIssueBill") || tableName[i][0].equals("T_IM_OtherIssueBill")) {
                sign = "-1";
            }
            sqlBill.append("select ").append(sign).append("*b.fbaseqty as fbaseqty,").append(sign).append("*b.fqty as fqty,").append("b.fmaterialid,b.fstorageorgunitid,b.fwarehouseid,b.funitid,b.flot,b.flocationId  ").append("from ").append(tableName[i][0]).append(" a,").append(tableName[i][1]).append(" b,t_org_storage c where a.fid = b.fparentid ").append("and b.fstorageorgunitid = c.fid and c.fnumber in (").append(sqlWhere).append(") ").append("and a.fbasestatus = 4 ");
            if (tableName[i][0].equals("T_IM_PurInWarehsBill") || tableName[i][0].equals("T_IM_SaleIssueBill")) {
                sqlBill.append("and fisinitbill <>1 ");
            }
            sqlBill.append("\r\n");
        }
        sql.append("select e.fnumber as FStorageOrgUnitNum,e.fname_l2 as FStorageOrgUnitName,a.fmaterialid as FMaterialID,c.fnumber as ").append("FMaterialNumber,c.fname_l2  as FMaterialName,a.fqty as FInvQty ,").append("a.fbaseqty as FInvBaseQty,b.fqty as FBillQty,b.fbaseqty as FBillQty,b.flot FLot,").append(" d.fnumber as FWarehouseNum,d.fname_l2 as FWarehouseName,a.FID as FInventoryID,").append("'update t_im_inventory set fcurstoreqty = fcurstoreqty + (' || to_char(b.fqty - a.fqty) || ").append("'),fbaseqty = fbaseqty + (' || to_char(b.fbaseqty-a.fbaseqty) || ') where fid = ''' || a.fid || ''';' as FUpdateSql  from (").append("\r\n").append("select i.fid as fid,i.fstorageorgunitid as fstorageorgunitid,i.fmaterialid as fmaterialid,").append("i.fcurstoreqty as fqty,i.fbaseqty as fbaseqty,i.fwarehouseid as fwarehouseid,").append("i.funitid as funitid,i.flot as flot,i.flocationId as flocationId  ").append("from t_im_inventory i,t_org_storage o  ").append("where i.fstorageorgunitid = o.fid ").append("and o.fnumber in (").append(sqlWhere).append(")").append(" ) a ,").append("\r\n").append(" (").append("select fbaseqty,fqty,fmaterialid,fstorageorgunitid,fwarehouseid,funitid,flot,flocationId from (").append("\r\n").append("select sum(fbaseqty) as fbaseqty,sum(fqty) as fqty,fmaterialid,fstorageorgunitid,fwarehouseid,funitid,flot,flocationId from (").append("\r\n").append(sqlBill).append(") t group by fmaterialid,fstorageorgunitid,fwarehouseid,flot,funitid,flocationId").append(") t0  ").append(") b,t_bd_material c ,t_db_warehouse d,t_org_storage e ").append(" where a.fstorageorgunitid = b.fstorageorgunitid ").append(" and a.fmaterialid = b.fmaterialid").append(" and a.fwarehouseid = b.fwarehouseid").append(" and a.funitid = b.funitid ").append(" and a.fstorageorgunitid = e.fid ").append(" and (a.flot = b.flot or (a.flot is null and b.flot is null)) ").append(" and (a.flocationId = b.flocationId or (a.flocationId is null and b.flocationId is null)) ").append(" and a.fbaseqty <> b.fbaseqty").append(" and a.fmaterialid = c.fid ").append(" and a.fwarehouseid = d.fid ").append("");
        this.executeSQL(ctx, sql.toString());
    }

    protected void groupTemp(Context ctx, RptParams params) throws BOSException {
        int kcGroupBy = new Integer(params.getObject("kcGroupBy").toString());
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        if (kcGroupBy == 1) {
            sql.append("insert into ").append(tempTable).append(" ").append("(FIndex,FStorageOrgUnitID,FMaterialID,").append("FBeginQty,FQty,FEndQty,FBillQty,FInventoryQty").append(") ").append("select  0 as FIndex,FStorageOrgUnitID,FMaterialID,").append("sum(FBeginQty),sum(FQty),sum(FEndQty),sum(FBillQty),sum(FInventoryQty)").append("from ").append(tempTable).append(" ").append("group by FStorageOrgUnitID,FMaterialID ");
        } else if (kcGroupBy == 2) {
            sql.append("insert into ").append(tempTable).append(" ").append("(FIndex,FStorageOrgUnitID,FMaterialID,FWarehouseID,").append("FBeginQty,FQty,FEndQty,FBillQty,FInventoryQty").append(") ").append("select  0 as FIndex,FStorageOrgUnitID,FMaterialID,FWarehouseID,").append("sum(FBeginQty),sum(FQty),sum(FEndQty),sum(FBillQty),sum(FInventoryQty)").append("from ").append(tempTable).append(" ").append("group by FStorageOrgUnitID,FMaterialID,FWarehouseID ");
        } else if (kcGroupBy == 3) {
            sql.append("insert into ").append(tempTable).append(" ").append("(FIndex,FStorageOrgUnitID,FMaterialID,FWarehouseID,FLot,").append("FBeginQty,FQty,FEndQty,FBillQty,FInventoryQty").append(") ").append("select  0 as FIndex,FStorageOrgUnitID,FMaterialID,FWarehouseID,FLot,").append("sum(FBeginQty),sum(FQty),sum(FEndQty),sum(FBillQty),sum(FInventoryQty)").append("from ").append(tempTable).append(" ").append("group by FStorageOrgUnitID,FMaterialID,FWarehouseID,FLot ");
        }
        this.executeSQL(ctx, sql.toString());
        this.executeSQL(ctx, "delete from " + tempTable + " where FIndex = -1 ");
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        int kcOrderBy = 1;
        if (params.getObject("kcOrderBy") != null) {
            kcOrderBy = new Integer(params.getObject("kcOrderBy").toString());
        }
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append("select ").append("FStorageOrgUnitName,FtransactionTypeName,FBillNumber,FBizDate,FOperateType,FAuditTime,FMaterialNumber,FMaterialName,").append("FModel as fmaterialmodel,FWarehouseName,FLocationName,FLot,FAssistProPertyName,").append("FProjectNumber,FProjectName,FTrackNumNumber,FTrackNumName,").append("FStoreTypeName,FStoreStatusName,FPreInvQty,FQty,(FPreInvQty+FQty) as FAfterInvQty ").append("from ").append(tempTable).append(" t ");
        if (kcOrderBy == 1) {
            sql.append("order by FStorageOrgUnitNumber,FBizDate,FBillNumber ");
        } else if (kcOrderBy == 2) {
            sql.append("order by FStorageOrgUnitNumber,FBizDate,FMaterialNumber ");
        } else if (kcOrderBy == 3) {
            sql.append("order by FStorageOrgUnitNumber,FBillNumber ");
        } else if (kcOrderBy == 4) {
            sql.append("order by FStorageOrgUnitNumber,FAuditTime ");
        } else {
            sql.append("order by FStorageOrgUnitNumber,FBizDate,FBillNumber ");
        }
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected String crtTempTable(Context ctx, RptParams params) throws BOSException {
        return KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateTempTable(params));
    }

    protected String getCreateTempTable(RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(" InventroyLog ").append("( ").append("FINDEX Int  NOT NULL Default -1 , ").append("FStorageOrgUnitID Varchar(44),").append("FStorageOrgUnitNumber NVarchar(80),").append("FStorageOrgUnitName NVarchar(255),").append("FTransactiontypeID Varchar(44),").append("FtransactionTypeName NVarchar(255),").append("FBillTypeName NVarchar(255),").append("FBillNumber NVarchar(80),").append("FBizdate datetime,").append("FOperateType NVarchar(80),").append("FAuditTime datetime,").append("FMaterialID Varchar(44),").append("FMaterialNumber NVarchar(80),").append("FMaterialName NVarchar(255),").append("FModel NVarchar(255),").append("FWarehouseID Varchar(44),").append("FWarehouseName NVarchar(255),").append("FLocationID Varchar(44),").append("FLocationName NVarchar(255),").append("FLot NVarchar(255),").append("FAssistProPertyID Varchar(44),").append("FAssistProPertyName NVarchar(255),").append("FProjectID Varchar(44),").append("FProjectNumber NVarchar(80),").append("FProjectName NVarchar(255),").append("FTrackNumID Varchar(44),").append("FTrackNumNumber NVarchar(80),").append("FTrackNumName NVarchar(255),").append("FStoreTypeID Varchar(44),").append("FStoreTypeName NVarchar(255),").append("FStoreStatusID Varchar(44),").append("FStoreStatusName NVarchar(255),").append("FQty NUMERIC(28,16) NOT NULL DEFAULT 0,").append("FPreInvQty NUMERIC(28,16) NOT NULL DEFAULT 0").append(")");
        return sql.toString();
    }

    protected static void setHeadCol(RptTableHeader header, String colName, int colLength, String fmt) {
        RptTableColumn col = new RptTableColumn(colName);
        col.setWidth(colLength);
        if (colLength == -1) {
            col.setHided(true);
        }
        if (fmt != null) {
            col.setFormatPattern(fmt);
        }
        header.addColumn(col);
    }

    protected RptTableHeader buildHead(Context ctx, RptParams params) {
        RptTableHeader header = new RptTableHeader();
        String textFmt = null;
        String qtyFmt = CalculateUtil.getFormatPattern((int)6);
        String dateFmt = "yyyy-MM-dd";
        String dateTimeFmt = "yyyy-MM-dd hh:mm:ss";
        Vector vlabel = new Vector();
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "rptstorageorg", 120, textFmt, vlabel, "rptstorageorg");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "transactionType", 120, textFmt, vlabel, "transactionType");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "billNumber", 120, textFmt, vlabel, "billNumber");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "bizDate", 80, dateFmt, vlabel, "bizDate");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "OperateType", 50, dateTimeFmt, vlabel, "OperateType");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "OperateTime", 130, dateTimeFmt, vlabel, "OperateTime");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "materialNumber", 80, textFmt, vlabel, "materialNumber");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "materialName", 120, textFmt, vlabel, "materialName");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "materialModel", 80, textFmt, vlabel, "materialModel");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "warehouse", 100, textFmt, vlabel, "warehouse");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "location", 80, textFmt, vlabel, "location");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "lot", 80, textFmt, vlabel, "lot");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "assistProperty", 80, textFmt, vlabel, "assistProperty");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "projectNumber", 80, textFmt, vlabel, "projectNumber");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "projectName", 80, textFmt, vlabel, "projectName");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "trackNumber", 80, textFmt, vlabel, "trackNumber");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "projectName", 80, textFmt, vlabel, "projectName");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "storetype", 60, textFmt, vlabel, "storetype");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "storeStatus", 60, textFmt, vlabel, "storeStatus");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "PreInvQty", 100, qtyFmt, vlabel, "PreInvQty");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "logQty", 100, qtyFmt, vlabel, "logQty");
        InventoryLogFacadeControllerBean.setHeadCol(ctx, params, header, "afterInvQty", 100, qtyFmt, vlabel, "afterInvQty");
        Object[] labels1 = vlabel.toArray();
        Object[] labels2 = (Object[])labels1.clone();
        Object[][] labels = new Object[][]{labels1, labels2};
        header.setLabels(labels, true);
        return header;
    }

    protected static void setHeadCol(Context ctx, RptParams params, RptTableHeader header, String colName, int colLength, String fmt, List vlabel, String resName) {
        InventoryLogFacadeControllerBean.setHeadCol(header, colName, colLength, fmt);
        if (resName.indexOf("__") > 0) {
            vlabel.add(resName.substring(0, resName.indexOf("_")));
        } else {
            vlabel.add(SCMUtils.getResource((String)res, (String)resName, (Context)ctx));
        }
    }

    protected String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    @Override
    protected RptParams _updateInventory(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer errorData = new StringBuffer();
        String inventoryIDs = params.getString("inventoryIDs");
        String updateSql = params.getString("updateSql");
        boolean isError = false;
        RptParams rtParams = new RptParams();
        if (inventoryIDs == null || inventoryIDs.trim().equals("")) {
            return null;
        }
        sql.append("select b.fnumber as snum,c.fnumber as mnum,d.fnumber as wnum from (").append("select count(FMATERIALID) as cnt,FSTORAGEORGUNITID as FSTORAGEORGUNITID,").append("FMATERIALID as FMATERIALID,FWAREHOUSEID as FWAREHOUSEID from t_im_inventory ").append("where fid in (").append(inventoryIDs).append(") ").append("group by ").append("FCOMPANYORGUNITID,FSTORAGEORGUNITID,FWAREHOUSEID,").append("FLOT,FMATERIALID,FUNITID,flocationId ").append(" having count(FMATERIALID) > 1 ) a,t_org_storage b ,t_bd_material c,t_db_warehouse d ").append("where  a.FSTORAGEORGUNITID = b.fid ").append("and a.FMATERIALID = c.fid ").append("and a.FWAREHOUSEID = d.fid ").append("order by b.fnumber,c.fnumber ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        while (rs.next()) {
            isError = true;
            errorData.append("Storage: ").append(rs.getString("snum"));
            errorData.append("Material: ").append(rs.getString("mnum"));
            errorData.append("Warehouse: ").append(rs.getString("wnum"));
            errorData.append("\n");
        }
        if (isError) {
            rtParams.setString("errorData", errorData.toString());
            return rtParams;
        }
        StringTokenizer st = new StringTokenizer(updateSql, ";");
        while (st.hasMoreElements()) {
            this.executeSQL(ctx, (String)st.nextElement());
        }
        return rtParams;
    }
}

