/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.app.AbstractInventoryTypeGatherReportFacadeControllerBean;
import com.kingdee.eas.scm.im.rpt.util.RptParamSqlUtil;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryTypeGatherReportFacadeControllerBean
extends AbstractInventoryTypeGatherReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.rpt.app.InventoryTypeGatherReportFacadeControllerBean");
    public static final String NEWLINE = "\t\n";
    private String orgTempTableStr = "orgTempTable";
    private String leafStorageOrgUnitStr = "leafStorageOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    private String resMapStr = "resMap";
    private String loc = "L2";
    private String hMatPermJoinSql = null;
    private String hWarePermJoinSql = null;
    private String matpermSql = null;
    private String warepermSql = null;
    private boolean isSupplierTypeByPurInWarehs = false;
    private static final String[][] invTableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_PurReceivalBill", "T_IM_PurReceivalEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}};

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        Boolean ckBxShowsumRow;
        Boolean ckBoxShowGatherLine;
        this.getPerm(ctx, params);
        this.loc = this.getLoc(ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.dropTempTable(params.getString("detailTempTable"), ctx);
        this.dropTempTable(params.getString(this.orgTempTableStr), ctx);
        String tempTable2 = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"124_InOutStoreGatherReportFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        String tempTable_Temp = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"126_InOutStoreGatherReportFacadeControllerBean_temp", (Locale)ctx.getLocale()), ctx);
        String tempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"124_InOutStoreGatherReportFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        String orgTempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"125_InOutStoreGatherReportFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        params.setObject("idList", null);
        params.setString("tempTable", tempTable);
        params.setString("tempTable_Temp", tempTable_Temp);
        params.setString(this.orgTempTableStr, orgTempTable);
        Boolean ckBxByStatUnit = (Boolean)params.getObject("ckBxByStatUnit");
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        Boolean ckBoxStoreTypeGather = (Boolean)params.getObject("ckBoxStoreTypeGather");
        long lstart = 0L;
        long lstop = 0L;
        long begin = System.currentTimeMillis();
        logger.info((Object)"====================BeginInventoryTypeGatherReportQuery==========================");
        logger.info((Object)"########### buildStorageOrgTable start ");
        lstart = System.currentTimeMillis();
        this.buildStorageOrgTable(ctx, orgTempTable, params);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### buildStorageOrgTable end : " + (lstop - lstart)));
        logger.info((Object)"########### CreateTempTable start ");
        lstart = System.currentTimeMillis();
        String sql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, sql);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### CreateTempTable end : " + (lstop - lstart)));
        logger.info((Object)"########### CreateTempTable_temp start ");
        lstart = System.currentTimeMillis();
        String sqls = this.getCreateTempTable(tempTable_Temp, params);
        this.executeSQL(ctx, sqls);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### CreateTempTable_temp end : " + (lstop - lstart)));
        logger.info((Object)"########### updateStorageOrgBeingDate start ");
        lstart = System.currentTimeMillis();
        this.updateStorageOrgBeingDate(ctx, orgTempTable, params);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### updateStorageOrgBeingDate end : " + (lstop - lstart)));
        logger.info((Object)"########### insertBillDateToTempTable start ");
        lstart = System.currentTimeMillis();
        this.insertBillDateToTempTable(ctx, orgTempTable, params);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### insertBillDateToTempTable end: " + (lstop - lstart)));
        logger.info((Object)"########### updateNoAmtPermssion start ");
        lstart = System.currentTimeMillis();
        this.updateNoAmtPermssion(ctx, params);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### updateNoAmtPermssion end : " + (lstop - lstart)));
        logger.info((Object)"########### groupTempTable start ");
        lstart = System.currentTimeMillis();
        this.groupTempTable(ctx, orgTempTable, params);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### groupTempTable end : " + (lstop - lstart)));
        logger.info((Object)"########### updateNoAmtStoreType start ");
        lstart = System.currentTimeMillis();
        this.updateNoAmtStoreType(ctx, params);
        logger.info((Object)("########### updateNoAmtStoreType end: " + (lstop - lstart)));
        Boolean ckBxOnlyShowDetail = (Boolean)params.getObject("ckBxOnlyShowDetail");
        if (!ckBxOnlyShowDetail.booleanValue()) {
            logger.info((Object)"########### groupTempTableForWhsLot start ");
            lstart = System.currentTimeMillis();
            this.groupTempTableForWhsLot(ctx, orgTempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### groupTempTableForWhsLot end : " + (lstop - lstart)));
            logger.info((Object)"########### levelTempTable start ");
            lstart = System.currentTimeMillis();
            this.levelTempTable(ctx, orgTempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### levelTempTable end : " + (lstop - lstart)));
            logger.info((Object)"########### updateEnd start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.updateEnd(ctx, tempTable, params, 0);
            this.updateEnd(ctx, tempTable, params, 1);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updateEnd end : " + (lstop - lstart)));
            logger.info((Object)"########### deleteNoInOut start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.deleteNoInOut(ctx, tempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### deleteNoInOut end : " + (lstop - lstart)));
            logger.info((Object)"########### levelTempTableGroup start ");
            lstart = System.currentTimeMillis();
            this.levelTempTableGroup(ctx, orgTempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### levelTempTableGroup end : " + (lstop - lstart)));
            logger.info((Object)"########### updateEnd start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.updateEnd(ctx, tempTable, params, 2);
            this.updateEnd(ctx, tempTable, params, 3);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updateEnd end : " + (lstop - lstart)));
        } else {
            logger.info((Object)"########### updateEnd start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.updateEnd(ctx, tempTable, params, -10);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updateEnd end : " + (lstop - lstart)));
            logger.info((Object)"########### deleteNoInOut start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.deleteNoInOut(ctx, tempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### deleteNoInOut end : " + (lstop - lstart)));
        }
        if (!ckBoxLevelGather.booleanValue() && ckBxByStatUnit.booleanValue()) {
            logger.info((Object)"########### updateStatUnit start ");
            lstart = System.currentTimeMillis();
            tempTable = params.getString("tempTable");
            this.updateStatUnit(ctx, tempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### updateStatUnit end : " + (lstop - lstart)));
        }
        logger.info((Object)"########### insertNeedInfo start ");
        lstart = System.currentTimeMillis();
        this.insertNeedInfo(ctx, orgTempTable, params);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### insertNeedInfo end: " + (lstop - lstart)));
        logger.info((Object)"########### finalUpdateTempTable start ");
        lstart = System.currentTimeMillis();
        this.finalUpdateTempTable(ctx, orgTempTable, params);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### finalUpdateTempTable end : " + (lstop - lstart)));
        if (ckBoxStoreTypeGather.booleanValue() && ckBxByStatUnit.booleanValue()) {
            this.updateTotalLine(ctx, orgTempTable, params);
        }
        if ((ckBoxShowGatherLine = (Boolean)params.getObject("ckBoxShowGatherLine")).booleanValue()) {
            logger.info((Object)"########### viewTotalLine start ");
            lstart = System.currentTimeMillis();
            this.viewTotalLine(ctx, orgTempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### viewTotalLine end : " + (lstop - lstart)));
        }
        if ((ckBxShowsumRow = (Boolean)params.getObject("ckBxShowsumRow")).booleanValue()) {
            logger.info((Object)"########### addsumRow start ");
            lstart = System.currentTimeMillis();
            this.addSumRow(ctx, orgTempTable, params);
            lstop = System.currentTimeMillis();
            logger.info((Object)("########### addsumRow end : " + (lstop - lstart)));
        }
        StringBuffer countSql = new StringBuffer();
        tempTable = params.getString("tempTable");
        countSql.append("select count(1) cc from ").append(tempTable).append("  where flevel = 1");
        RptRowSet rsCount = this.executeQuery(countSql.toString(), null, ctx);
        rsCount.next();
        int count = rsCount.getInt(0);
        String sql2 = this.getCreateTempTable(tempTable2, params);
        this.executeSQL(ctx, sql2);
        String gatherTempTable = null;
        String detailTempTable = null;
        try {
            detailTempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable_Temp, params));
            TempTablePool.getInstance((Context)ctx).createIndex(detailTempTable, "KSQL_SEQ", false, false);
            if (!ckBxOnlyShowDetail.booleanValue()) {
                gatherTempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable_Temp, params));
                TempTablePool.getInstance((Context)ctx).createIndex(gatherTempTable, "KSQL_SEQ", false, false);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.copyToNewTempTable(ctx, detailTempTable, tempTable, params, 1);
        if (!ckBxOnlyShowDetail.booleanValue()) {
            this.copyToNewTempTable(ctx, gatherTempTable, tempTable, params, 0);
        }
        HashMap resMap = this.getResource(ctx, params);
        params.setObject(this.resMapStr, (Object)resMap);
        IRowSet idList = this.getIdList(ctx, params);
        RptTableHeader header = this.getReportHeader(params);
        RptParams result = new RptParams();
        if (!ckBxOnlyShowDetail.booleanValue()) {
            result.setString("tempTable", gatherTempTable);
            result.setString("detailTempTable", detailTempTable);
        } else {
            result.setString("tempTable", detailTempTable);
        }
        this.dropTempTable(ctx, tempTable);
        result.setString(this.orgTempTableStr, orgTempTable);
        result.setInt("totalCount", count);
        result.setObject("header", (Object)header);
        result.setObject("idList", (Object)idList);
        result.setObject("queryHeader", (Object)this.buildQueryHead(ctx, params));
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### total time: " + (lstop - begin)));
        return result;
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    private void copyToNewTempTable(Context ctx, String newTempTable, String tempTable, RptParams params, int isDetailTable) throws BOSException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        Boolean ckBoxStoreTypeGather = (Boolean)params.getObject("ckBoxStoreTypeGather");
        Boolean ckBxOnlyShowDetail = (Boolean)params.getObject("ckBxOnlyShowDetail");
        StringBuffer copySql = new StringBuffer();
        copySql.append("insert into ").append(newTempTable).append(" (ksql_seq,").append(this.allQueryFields()).append(")");
        copySql.append(" select ").append(this.allQueryFields()).append(" from ").append(tempTable);
        copySql.append(" where 1 = 1 ");
        if (isDetailTable == 0 || ckBxOnlyShowDetail.booleanValue()) {
            copySql.append(" and flevel = 1");
        } else {
            copySql.append(" and flevel <> 1");
        }
        if (ckBxOnlyShowDetail.booleanValue()) {
            copySql.append(" order by Findex");
        } else {
            copySql.append(" order by Findex desc");
        }
        if (ckBoxLevelGather.booleanValue() && coBoxGatherCondition == 1) {
            copySql.append(",FMaterialCostType");
        } else if (ckBoxStoreTypeGather.booleanValue()) {
            copySql.append(",FStoreTypeID");
        } else {
            copySql.append(",FMaterialGroupNumber,FMaterialNumber,fwarehouseid,FLot,FProjectId,FTrackNumberId,FAssistProperty,FId ");
        }
        DbUtil.execute((Context)ctx, (String)copySql.toString());
    }

    private String allQueryFields() {
        StringBuffer fields = new StringBuffer("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FStoreTypeID,FStoreTypePreID,FWarehouseID,FLocationID,FMaterialID,FLot,FProjectID,");
        fields.append("FProjectNumber,FProjectName,FTrackNumberID,FTrackNumNumber,FTrackNumName,FAssistPropertyID,FSupplierID,FCustomerID,FBeginQty,FOriBeginQty,FBeginAmt,FriInQty,FriInAmt,");
        fields.append("FriOutQty,FriOutAmt,FEndQty,FEndAmt,FBeginAssQty,FriInAssQty,FriOutAssQty,FEndAssQty,FStoreTypeName,FMaterialGroupName,FMaterialGroupNumber,FMaterialNumber,FMaterialName,FShortName,");
        fields.append("FMaterialSize,FAssistProperty,FBaseUnit,FAssistUnit,FStorageOrgName,FWarehouseName,FWarehouseNumber,FLocationName,FSupplierName,FCustomerName,flevel,fisleaf,fparentid,");
        fields.append("FMaterialGroupID,FMaterialCostType,FMaterialCostTypeName,FBlockID,FStatUnitID,FisfinalData");
        return fields.toString();
    }

    private void buildStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table " + orgTempTable + " (");
        sql.append("fid varchar(44) not null  primary key ,");
        sql.append("fname_" + this.loc + "  varchar(100),");
        sql.append("fparentid varchar(44),");
        sql.append("flevel int,");
        sql.append("fisleaf int,");
        sql.append("fbegindate datetime,");
        sql.append("fbeginyear int,");
        sql.append("fbeginperiod int ");
        sql.append(")");
        this.executeSQL(ctx, sql.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Set cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"inoutstoregatherreport_view");
        Set orgUnitSets = InvServerUtils.getSelAuthorUnit(cuUnitSets, (Object[])params.getObject("fullStorageOrgUnit"));
        Object[] storageOrg = orgUnitSets.toArray();
        String orgSql = "insert into " + orgTempTable + "(fid,fname_" + this.loc + " ,fparentid,flevel,fisleaf,fbegindate,fbeginyear,fbeginperiod) values(?,?,?,?,?,to_date('1999-01-01'),?,?)";
        if (storageOrg != null) {
            long start = System.currentTimeMillis();
            logger.info((Object)"########### insert into buildStorageOrgTable start ");
            int n = storageOrg.length;
            for (int i = 0; i < n; ++i) {
                Integer fisleaf;
                String fid = ((OrgUnitInfo)storageOrg[i]).get("id").toString();
                Integer flevel = (Integer)((OrgUnitInfo)storageOrg[i]).get("level");
                String fname = (String)((OrgUnitInfo)storageOrg[i]).get("name");
                OrgUnitInfo parent = (OrgUnitInfo)((OrgUnitInfo)storageOrg[i]).get("parent");
                Integer n2 = fisleaf = ((OrgUnitInfo)storageOrg[i]).isIsLeaf() ? new Integer("1") : new Integer("0");
                if (fisleaf == 1) {
                    v.add(fid);
                }
                if (flevel > maxLevel) {
                    maxLevel = flevel;
                }
                String fparentid = parent == null ? null : parent.getId().toString();
                SqlParams parameters = new SqlParams();
                parameters.addString(fid);
                parameters.addString(fname);
                parameters.addString(fparentid);
                parameters.addInt(flevel.intValue());
                parameters.addInt(fisleaf.intValue());
                parameters.addInt(1999);
                parameters.addInt(1);
                this.executeUpdate(ctx, orgSql, parameters);
            }
            long end = System.currentTimeMillis();
            logger.info((Object)("########### insert into buildStorageOrgTable end " + (end - start)));
        }
        params.setObject(this.leafStorageOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
        String index_name = "orgTemp_" + InventoryTypeGatherReportFacadeControllerBean.genRandomNum(5);
        this.executeSQL(ctx, "create index " + index_name + " on " + orgTempTable + "(fbegindate)");
    }

    private void updateStorageOrgBeingDate(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        java.util.Date dateFrom = (java.util.Date)params.getObject("dateFrom");
        PeriodInfo periodInfo = IMRptUtils.getPeriodInfo(ctx, dateFrom, this.getPeriodTypeId(ctx, orgTempTable));
        if (periodInfo == null) {
            periodInfo = IMRptUtils.getPeriodInfo(ctx, dateFrom);
        }
        if (periodInfo == null) {
            return;
        }
        String periodBegin = IMRptUtils.getFilterBeginDate(periodInfo.getBeginDate());
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(orgTempTable).append(" as t set(fid,fbegindate,fbeginyear,fbeginperiod) = (");
        sql.append("select a.fid,").append("case when g.fbegindate >= to_date('").append(periodBegin).append("') then g.fbegindate ").append("when h.fbegindate <= to_date('").append(periodBegin).append("') then h.fbegindate ").append("else to_date('").append(periodBegin).append("') end as fbegindate,").append("case when g.fbegindate >= to_date('").append(periodBegin).append("') then g.fperiodyear ").append("when h.fbegindate <= to_date('").append(periodBegin).append("') then h.fperiodyear ").append("else ").append(periodInfo.getPeriodYear()).append(" end as fbeginyear,").append("case when g.fbegindate >= to_date('").append(periodBegin).append("') then g.fperiodnumber ").append("when h.fbegindate <= to_date('").append(periodBegin).append("') then h.fperiodnumber ").append("else ").append(periodInfo.getPeriodNumber()).append(" end as fbegindate ").append("from ").append(orgTempTable).append(" a ").append("inner join T_ORG_UnitRelation b  on a.fid = b.ffromunitid ").append("inner join T_ORG_TypeRelation c  on b.FTypeRelationID = c.FID ").append("inner join t_org_company d on  b.ftounitid = d.fid ").append("inner join T_BD_SystemStatusCtrol e on e.FCompanyID = d.fid ").append("inner join T_BD_SystemStatus f on e.FSystemStatusID = f.fid ").append("inner join t_bd_period g on e.fstartperiodid = g.fid ").append("inner join t_bd_period h on e.fcurrentperiodid = h.fid ").append("where ").append("c.FFromType = ").append(4).append(" ").append("and c.FToType = ").append(1).append(" ").append("and  f.fname = ").append(2).append(" ");
        sql.append("and t.fid = a.fid )");
        this.executeSQL(ctx, sql.toString());
    }

    private boolean isFromAfterBeginDate(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        java.util.Date dateFrom = (java.util.Date)params.getObject("dateFrom");
        StringBuffer sql = new StringBuffer();
        sql.append("select min(fbegindate) from ").append(orgTempTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                Date endDate = rs.getDate(1);
                if (endDate == null) continue;
                return dateFrom.after(endDate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ").append(tempTable).append("(");
        sql.append("KSQL_SEQ INT IDENTITY(1,1),");
        sql.append("FID Varchar(44),");
        sql.append("FIndex int default 0,");
        sql.append("FCompanyOrgUnitID Varchar(44),");
        sql.append("FStorageOrgUnitID Varchar(44),");
        sql.append("FStoreTypeID varchar(44),");
        sql.append("FStoreTypePreID varchar(44),");
        sql.append("FWarehouseID Varchar(44),");
        sql.append("FLocationID Varchar(44),");
        sql.append("FMaterialID Varchar(44),");
        sql.append("FLot nvarchar(80),");
        sql.append("FProjectID nvarchar(44),");
        sql.append("FProjectNumber nvarchar(80),");
        sql.append("FProjectName nvarchar(255),");
        sql.append("FTrackNumberID nvarchar(44),");
        sql.append("FTrackNumNumber nvarchar(80),");
        sql.append("FTrackNumName nvarchar(255),");
        sql.append("FAssistPropertyID Varchar(44),");
        sql.append("FSupplierID varchar(44),");
        sql.append("FCustomerID varchar(44),");
        sql.append("FBeginQty Decimal(28,10) not null default 0,");
        sql.append("FOriBeginQty Decimal(28,10) not null default 0,");
        sql.append("FBeginAmt Decimal(28,10) not null default 0,");
        sql.append("FriInQty Decimal(28,10) not null default 0,");
        sql.append("FriInAmt Decimal(28,10) not null default 0,");
        sql.append("FriOutQty Decimal(28,10) not null default 0,");
        sql.append("FriOutAmt Decimal(28,10) not null default 0,");
        sql.append("FEndQty Decimal(28,10) not null default 0,");
        sql.append("FEndAmt Decimal(28,10) not null default 0,");
        sql.append("FBeginAssQty Decimal(28,10) not null default 0,");
        sql.append("FriInAssQty Decimal(28,10) not null default 0,");
        sql.append("FriOutAssQty Decimal(28,10) not null default 0,");
        sql.append("FEndAssQty Decimal(28,10) not null default 0,");
        sql.append("FStoreTypeName nvarchar(255),");
        sql.append("FMaterialGroupName nvarchar(255),");
        sql.append("FMaterialGroupNumber nvarchar(80),");
        sql.append("FMaterialNumber nvarchar(80),");
        sql.append("FMaterialName nvarchar(255),");
        sql.append("FShortName nvarchar(255),");
        sql.append("FMaterialSize nvarchar(255),");
        sql.append("FAssistProperty nvarchar(255),");
        sql.append("FBaseUnit nvarchar(80),");
        sql.append("FAssistUnit nvarchar(80),");
        sql.append("FStorageOrgName nvarchar(255),");
        sql.append("FWarehouseName nvarchar(255),");
        sql.append("FWarehouseNumber nvarchar(255),");
        sql.append("FLocationName nvarchar(255),");
        sql.append("FSupplierName nvarchar(255),");
        sql.append("FCustomerName nvarchar(255),");
        sql.append("flevel int,");
        sql.append("fisleaf int,");
        sql.append("fparentid varchar(44),");
        sql.append("FMaterialGroupID varchar(44),");
        sql.append("FMaterialCostType char(2),");
        sql.append("FMaterialCostTypeName varchar(44),");
        sql.append("FBlockID varchar(44),");
        sql.append("FStatUnitID varchar(44),");
        sql.append("FisfinalData int default 0");
        sql.append(");");
        return sql.toString();
    }

    private void insertBeginDataForCombinTable(Context ctx, RptParams params, String orgTempTable, String insertStr) throws BOSException, EASBizException {
        long lstart = 0L;
        long lstop = 0L;
        logger.info((Object)"########### insertBeginDataForCombinTable start ");
        lstart = System.currentTimeMillis();
        StringBuffer initSelector = new StringBuffer(insertStr);
        initSelector.append("select newbosid('88888888'),-2 as FIndex,h.FCompanyOrgUnitID,h.FStorageOrgUnitID,h.FMaterialID,h.FStoreTypeID,");
        initSelector.append("null as FStoreTypePreID,h.FSupplierID,h.FCustomerID,h.FWarehouseID,h.FLocationID,h.FLot,h.FProjectId,h.FTrackNumberId,h.FAssistPropertyID,");
        initSelector.append("sum(h.FPeriodBeginQty) as FBeginQty,");
        initSelector.append("sum(h.FPeriodBeginActualCost) as FBeginAmt,");
        initSelector.append("sum(h.FPERIODBEGINASSISTQTY) as FBeginAssQty ");
        initSelector.append("from T_IM_InventoryBalance h ");
        initSelector.append("inner join ").append(orgTempTable).append(" o on h.fstorageorgunitid = o.fid ");
        initSelector.append("and h.fyear = o.fbeginyear and h.fperiod = o.fbeginperiod ");
        String initJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, false);
        initJoinStr = initJoinStr + this.builderJoinForStoreTypeAndCS(params, "T_IM_InventoryBalance", false);
        initJoinStr = initJoinStr.replaceAll("et\\.", "h.");
        initSelector.append(initJoinStr);
        StringBuffer initExtendWhere = new StringBuffer();
        initExtendWhere.append(" where o.fisleaf = 1 ");
        initExtendWhere.append(this.buildParamWhereStr(ctx, params, false));
        initExtendWhere.append(" and h.FStoreTypeID is not null ");
        boolean noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        boolean noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        if (noSelectStorageMoveBill) {
            initExtendWhere.append(" AND h.FMoveType <> 1 ");
        }
        if (noSelectWarehouseMoveBill) {
            initExtendWhere.append(" AND h.FMoveType <> 2 ");
        }
        String initSqlWhere = initExtendWhere.toString().replaceAll("et.", "h.");
        initSelector.append(initSqlWhere);
        java.util.Date dateTo = (java.util.Date)params.getObject("dateTo");
        PeriodInfo dateToperiodInfo = IMRptUtils.getPeriodInfo(ctx, dateTo, this.getPeriodTypeId(ctx, orgTempTable));
        if (dateToperiodInfo != null) {
            initSelector.append(" and (h.fyear * 100 + h.FPERIOD) <=  ").append(dateToperiodInfo.getPeriodYear() * 100 + dateToperiodInfo.getPeriodNumber());
        }
        initSelector.append(" Group by h.FCompanyOrgUnitID,h.FStorageOrgUnitID,h.FStoreTypeID,h.FSupplierID,h.FCustomerID,h.FWarehouseID,h.FMaterialID,h.FLocationID");
        initSelector.append(",h.FLot,h.FProjectId,h.FTrackNumberId,h.FAssistPropertyID");
        this.executeBatchUpdate(ctx, new String[]{initSelector.toString()});
        this.insertInitInventoryBill(ctx, params, orgTempTable, insertStr);
        this.insertInitInventoryBillNoStart(ctx, params, orgTempTable, insertStr);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### insertBeginDataForCombinTable end : " + (lstop - lstart)));
    }

    private void insertInitInventoryBill(Context ctx, RptParams params, String orgTempTable, String insertStr) throws EASBizException, BOSException {
        long lstart = 0L;
        long lstop = 0L;
        logger.info((Object)"########### insertInitInventoryBill start ");
        lstart = System.currentTimeMillis();
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        StringBuffer initSelector = new StringBuffer(insertStr);
        initSelector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,et.FStoreTypeID,null as FStoreTypePreID,et.FSupplierID,et.FCustomerID,et.FWarehouseID,et.FLocationID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,sum(et.FBaseqty) as FBeginQty,sum(et.famount) as FBeginAmt,sum(et.fassistqty) as FBeginAssQty from T_IM_InventoryInitentry et inner join T_IM_InventoryInitbill h on et.fparentid = h.fid ");
        initSelector.append(billJoinStr);
        initSelector.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_InventoryInitentry", false));
        initSelector.append(" left join T_DB_SOAccreditWH sowh on et.FWarehouseID = sowh.FWarehouseID and et.FStorageOrgUnitID =sowh.FSTORAGEORGID");
        initSelector.append(" left join t_bd_period pe on sowh.FPERIODID = pe.fid ");
        initSelector.append(this.getInitInventoryDataWhereSQL(ctx, params, false));
        initSelector.append(" and et.FStoreTypeID is not null and sowh.FIsStarted = 1").append(NEWLINE);
        initSelector.append("group by et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FStoreTypeID,et.FCustomerID,et.FSupplierID,");
        initSelector.append("et.FWarehouseID,et.FLocationID,et.FMaterialID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID");
        this.executeBatchUpdate(ctx, new String[]{initSelector.toString()});
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### insertInitInventoryBill end " + (lstop - lstart)));
    }

    private String getInitInventoryDataWhereSQL(Context ctx, RptParams params, boolean isHasST2) throws EASBizException, BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        java.util.Date dateTo = (java.util.Date)params.getObject("dateTo");
        sqlWhere.append(" where o.fisleaf = 1 and h.fbasestatus = 4 ");
        sqlWhere.append(this.buildParamWhereStr(ctx, params, isHasST2)).append(NEWLINE);
        PeriodInfo dateToperiodInfo = IMRptUtils.getPeriodInfo(ctx, dateTo);
        sqlWhere.append(" and (o.fbeginyear * 100 + o.fbeginperiod <   pe.FPERIODYear * 100 + pe.FPERIODNUMBER ) ");
        if (dateToperiodInfo != null) {
            sqlWhere.append(" and ( pe.FPERIODYear * 100 + pe.FPERIODNUMBER <=  ").append(dateToperiodInfo.getPeriodYear() * 100 + dateToperiodInfo.getPeriodNumber()).append(" ) ");
        }
        return sqlWhere.toString();
    }

    private void insertInitInventoryBillNoStart(Context ctx, RptParams params, String orgTempTable, String insertStr) throws EASBizException, BOSException {
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        StringBuffer initSelector = new StringBuffer(insertStr);
        initSelector.append("select newbosid('88888888'), -2 as FIndex, et.FCompanyOrgUnitID, et.FStorageOrgUnitID, et.FMaterialID, et.FStoreTypeID, null as FStoreTypePreID, et.FSupplierID, et.FCustomerID, et.FWarehouseID, et.FLocationID, et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID, sum(et.FBaseqty) as FBeginQty, sum(et.famount) as FBeginAmt, sum(et.fassistqty) as FBeginAssQty from T_IM_InventoryInitentry et inner join T_IM_InventoryInitbill h on et.fparentid = h.fid ");
        initSelector.append(billJoinStr);
        initSelector.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_InventoryInitentry", false));
        initSelector.append(" left join T_DB_SOAccreditWH sowh on et.FWarehouseID = sowh.FWarehouseID and et.FStorageOrgUnitID =sowh.FSTORAGEORGID");
        initSelector.append(this.getInitInventoryNoStartDataWhereSQL(ctx, params, false));
        initSelector.append(" and et.FStoreTypeID is not null and sowh.FIsStarted = 0 ").append(NEWLINE);
        initSelector.append("group by et.FCompanyOrgUnitID, et.FStorageOrgUnitID, et.FStoreTypeID, et.FCustomerID, et.FSupplierID, ");
        initSelector.append("et.FWarehouseID, et.FLocationID, et.FMaterialID, et.FLot,et.FProjectId,et.FTrackNumberId, et.FAssistPropertyID ");
        this.executeBatchUpdate(ctx, new String[]{initSelector.toString()});
    }

    private String getInitInventoryNoStartDataWhereSQL(Context ctx, RptParams params, boolean isHasST2) throws EASBizException, BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        java.util.Date dateFrom = (java.util.Date)params.getObject("dateFrom");
        java.util.Date dateTo = (java.util.Date)params.getObject("dateTo");
        sqlWhere.append(" where o.fisleaf = 1 and h.fbasestatus = 4 ");
        sqlWhere.append(this.buildParamWhereStr(ctx, params, isHasST2)).append(NEWLINE);
        sqlWhere.append(" and h.fbizdate >= to_date('").append(IMRptUtils.getFmtDate(dateFrom)).append("')");
        sqlWhere.append(" and h.fbizdate <= to_date('").append(IMRptUtils.getFmtDate(dateTo)).append("')");
        return sqlWhere.toString();
    }

    private String buildParamWhereStr(Context ctx, RptParams params, boolean isHasST2) throws BOSException {
        String querySql;
        String txtLotLike;
        String querySql2;
        StringBuffer sqlWhere = new StringBuffer();
        Boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        if (params.getObject("materialFrom") != null) {
            querySql2 = RptParamSqlUtil.getQuerySql("m.fnumber", params.getObject("materialFrom"), MaterialInfo.class, "getNumber");
            sqlWhere.append(querySql2);
        }
        if (params.getObject("materialTo") != null) {
            querySql2 = RptParamSqlUtil.getQuerySql("m.fnumber", params.getObject("materialTo"), MaterialInfo.class, "getNumber", CompareType.LESS_EQUALS);
            sqlWhere.append(querySql2);
        }
        if (ckBxShowMShortName.booleanValue()) {
            String txtMShortNameFrom = (String)params.getObject("shortNameFrom");
            String txtMShortNameTo = (String)params.getObject("shortNameTo");
            if (txtMShortNameFrom != null && txtMShortNameFrom.trim().length() > 0) {
                if (txtMShortNameFrom.indexOf("'") != -1) {
                    txtMShortNameFrom = txtMShortNameFrom.replaceAll("'", "''");
                }
                sqlWhere.append("and m.FShortName >= '").append(txtMShortNameFrom.trim()).append("' ");
            }
            if (txtMShortNameTo != null && txtMShortNameTo.trim().length() > 0) {
                if (txtMShortNameTo.indexOf("'") != -1) {
                    txtMShortNameTo = txtMShortNameTo.replaceAll("'", "''");
                }
                sqlWhere.append("and m.FShortName <= '").append(txtMShortNameTo.trim()).append("' ").append(NEWLINE);
            }
        }
        if (((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString() != null) {
            String mgStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
            sqlWhere.append(" and MGD.FMATERIALGROUPSTANDARDID ='").append(mgStandardID).append("'  ");
        }
        if (params.getObject("warehouseFrom") != null) {
            querySql2 = RptParamSqlUtil.getQuerySql("wh.FNumber", params.getObject("warehouseFrom"), WarehouseInfo.class, "getNumber");
            sqlWhere.append(querySql2);
        }
        if (params.getObject("warehouseTo") != null) {
            String warehouseNumber = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            sqlWhere.append("and wh.FNumber <= '" + warehouseNumber + "' ").append(NEWLINE);
        }
        String projectQuerySql = RptParamSqlUtil.getQuerySql("project.fnumber", params.getObject("projectFrom"));
        sqlWhere.append(projectQuerySql);
        if (!"".equals(params.getString("projectTo"))) {
            sqlWhere.append(" and project.fnumber  <='" + params.getString("projectTo") + "' ").append(NEWLINE);
        }
        String trackQuerySql = RptParamSqlUtil.getQuerySql("track.fnumber", params.getObject("trackNumFrom"));
        sqlWhere.append(trackQuerySql);
        if (!"".equals(params.getString("trackNumTo"))) {
            sqlWhere.append(" and track.fnumber  <='" + params.getString("trackNumTo") + "' ").append(NEWLINE);
        }
        if (!StringUtil.isEmpty((String)this.matpermSql)) {
            sqlWhere.append(this.matpermSql);
        }
        if (!StringUtil.isEmpty((String)this.warepermSql)) {
            sqlWhere.append(this.warepermSql);
        }
        if (params.getObject("locationFrom") != null) {
            String querySql3 = RptParamSqlUtil.getQuerySql("lo.FNumber", params.getObject("locationFrom"), LocationInfo.class, "getNumber");
            sqlWhere.append(querySql3);
        }
        if (params.getObject("locationTo") != null) {
            String locationTo = ((LocationInfo)params.getObject("locationTo")).getNumber();
            sqlWhere.append("and lo.FNumber <= '" + locationTo + "' ").append(NEWLINE);
        }
        String txtLotFrom = (String)params.getObject("lotFrom");
        String txtLotTo = (String)params.getObject("lotTo");
        if (txtLotFrom != null && txtLotFrom.trim().length() > 0) {
            sqlWhere.append("and et.FLot >= '").append(txtLotFrom).append("' ");
        }
        if (txtLotTo != null && txtLotTo.trim().length() > 0) {
            sqlWhere.append("and et.FLot <= '").append(txtLotTo).append("' ").append(NEWLINE);
        }
        if ((txtLotLike = (String)params.getObject("txtLotLike")) != null && txtLotLike.trim().length() > 0) {
            sqlWhere.append(" and    et.FLot like '%").append(txtLotLike).append("%'").append(NEWLINE);
        }
        if (params.getObject("asstAttrFrom") != null) {
            querySql = RptParamSqlUtil.getQuerySql("asst.FNumber", params, AsstAttrValueInfo.class, "getNumber");
            sqlWhere.append(querySql);
        }
        if (params.getObject("asstAttrTo") != null) {
            String asstAttrTo = ((AsstAttrValueInfo)params.getObject("asstAttrTo")).getNumber();
            sqlWhere.append("and asst.FNumber <= '" + asstAttrTo + "' ").append(NEWLINE);
        }
        if (this.getStoreTypeNumber(ctx, params) != null) {
            String storeTypeNumber = this.getStoreTypeNumber(ctx, params);
            if (this.isSupplierTypeByPurInWarehs) {
                sqlWhere.append("and st2.FNumber in (").append(storeTypeNumber).append(") ");
            } else if (isHasST2) {
                sqlWhere.append("and (st.FNumber in (").append(storeTypeNumber).append(") ");
                sqlWhere.append(" or st2.FNumber in (").append(storeTypeNumber).append(")) ");
            } else {
                sqlWhere.append("and st.FNumber in (").append(storeTypeNumber).append(") ");
            }
        }
        if (RptParamSqlUtil.getObject(params, "supplierFrom") != null) {
            Object supplierO = params.getObject("supplierFrom");
            String querySql4 = RptParamSqlUtil.getQuerySql("su.FNumber", supplierO, SupplierInfo.class, "getNumber");
            sqlWhere.append(querySql4);
        }
        if (params.getObject("supplierTo") != null) {
            String supplierTo = ((SupplierInfo)params.getObject("supplierTo")).getNumber();
            sqlWhere.append("and su.FNumber <= '" + supplierTo + "' ").append(NEWLINE);
        }
        if (params.getObject("customerFrom") != null) {
            querySql = RptParamSqlUtil.getQuerySql("cu.FNumber", params.getObject("customerFrom"), CustomerInfo.class, "getNumber");
            sqlWhere.append(querySql);
        }
        if (params.getObject("customerTo") != null) {
            String customerTo = ((CustomerInfo)params.getObject("customerTo")).getNumber();
            sqlWhere.append("and cu.FNumber <= '" + customerTo + "' ").append(NEWLINE);
        }
        sqlWhere.append(this.getMaterialTypeWhere(ctx, params));
        return sqlWhere.toString();
    }

    private String getStoreTypeNumber(Context ctx, RptParams params) {
        Object[] obj;
        if (params.getObject("storeType") != null && (obj = (Object[])params.getObject("storeType")) != null && obj[0] != null && obj.length > 0) {
            StoreTypeInfo storeTypeInfo = null;
            String storeTypeNumber = "";
            for (int i = 0; i < obj.length; ++i) {
                storeTypeInfo = (StoreTypeInfo)obj[i];
                storeTypeNumber = storeTypeNumber + "'" + storeTypeInfo.getNumber() + "',";
            }
            storeTypeNumber = storeTypeNumber + "' '";
            return storeTypeNumber;
        }
        return null;
    }

    private String getMaterialTypeWhere(Context ctx, RptParams params) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        Object materialTypeFrom = null;
        String materialTypeTo = null;
        if (params.getObject("materialTypeFrom") != null) {
            materialTypeFrom = params.getObject("materialTypeFrom");
        }
        if (params.getObject("materialTypeTo") != null) {
            materialTypeTo = ((MaterialGroupInfo)params.getObject("materialTypeTo")).getLongNumber();
        }
        if (materialTypeFrom != null || materialTypeTo != null) {
            StringBuffer sql22 = new StringBuffer();
            if (materialTypeFrom != null) {
                String querySql = RptParamSqlUtil.getMaterialGroupQuerySql(materialTypeFrom, "g.flongnumber", true);
                sql22.append(querySql);
            }
            if (materialTypeTo != null) {
                sql22.append(" and ");
                sql22.append("(g.flongnumber <= '").append(materialTypeTo).append("' ");
                sql22.append(" or g.flongnumber like '").append(materialTypeTo).append("!%')");
            }
            sqlWhere.append(sql22);
        }
        return sqlWhere.toString();
    }

    private void updateNoAmtPermssion(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        Vector orgVct = (Vector)params.getObject("amtPermssionOrg");
        sql.append("update ").append(tempTable).append(" ").append("set ").append("FBeginAmt =0,FriInAmt=0,FriOutAmt=0").append(" where fstorageorgunitid in (");
        if (orgVct != null && orgVct.size() > 0) {
            Object[] orgIDs = orgVct.toArray();
            for (int i = 0; i < orgIDs.length; ++i) {
                if (i != 0) {
                    sql.append(",");
                }
                sql.append("'").append(orgIDs[i]).append("'");
            }
        }
        sql.append(")");
        if (orgVct != null && orgVct.size() > 0) {
            this.executeSQL(ctx, sql.toString());
        }
    }

    private void updateNoAmtStoreType(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer sq1 = new StringBuffer();
        sq1.append("update ").append(tempTable).append(" set  FBeginAmt =0,FriInAmt=0,FriOutAmt=0 ");
        sq1.append("where FStoreTypeID  in (select FID from T_IM_StoreType where FISFORWARDAMT =0)");
        sq1.append("update ").append(tempTable).append(" set FEndAmt = FBeginAmt + FriInAmt - FriOutAmt ");
        this.executeBatchUpdate(ctx, sq1.toString().split(";"));
    }

    private void groupTempTable(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        Boolean isShowProject = params.getBoolean("isShowProject");
        Boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        sql.append(this.getInsertFiledsSql(params, true)).append(NEWLINE);
        sql.append("select newbosid('88888888'),-1 as Findex,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,");
        if (ckBxShowWhs.booleanValue()) {
            sql.append("FWarehouseID,");
        } else {
            sql.append("'1',");
        }
        if (ckBxShowLocation.booleanValue()) {
            sql.append("FLocationID,");
        } else {
            sql.append("'1',");
        }
        if (ckBxShowLot.booleanValue()) {
            sql.append("FLot,");
        } else {
            sql.append("'1',");
        }
        if (isShowProject.booleanValue()) {
            sql.append("FProjectId,");
        } else {
            sql.append("'1',");
        }
        if (isShowTrackNum.booleanValue()) {
            sql.append("FTrackNumberId,");
        } else {
            sql.append("'1',");
        }
        if (ckBxShowAsstAttr.booleanValue()) {
            sql.append("FAssistPropertyID,");
        } else {
            sql.append("'1',");
        }
        sql.append("FSupplierID,FCustomerID,");
        sql.append(this.getGroupFiledsSql(params)).append(" from ").append(tempTable).append(NEWLINE);
        sql.append("group by FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,FSupplierID,FCustomerID");
        if (ckBxShowWhs.booleanValue()) {
            sql.append(",FWarehouseID");
        }
        if (ckBxShowLocation.booleanValue()) {
            sql.append(",FLocationID");
        }
        if (ckBxShowLot.booleanValue()) {
            sql.append(",FLot");
        }
        if (isShowProject.booleanValue()) {
            sql.append(",FProjectId");
        }
        if (isShowTrackNum.booleanValue()) {
            sql.append(",FTrackNumberId");
        }
        if (ckBxShowAsstAttr.booleanValue()) {
            sql.append(",FAssistPropertyID");
        }
        this.executeSQL(ctx, sql.toString());
        this.exchangeTemptable(ctx, params);
    }

    private void exchangeTemptable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = (String)params.getObject("tempTable");
        String tempTable_temp = (String)params.getObject("tempTable_Temp");
        String sqlTrunc = " TRUNCATE TABLE " + tempTable + " ;";
        this.executeSQL(ctx, sqlTrunc);
        params.setString("tempTable", tempTable_temp);
        params.setString("tempTable_Temp", tempTable);
    }

    private void updateStatUnit(Context ctx, String tempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tempTable).append(" set FOriBeginQty = FBeginQty ");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" set (FStatUnitID,").append("FBeginQty,FriInQty,FriOutQty,FEndQty").append(") = (select fmeasureunitid,").append("round(decimal(FBeginQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FriInQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FriOutQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision),").append("round(decimal(FEndQty,21,8)/decimal(mm.FBaseConvsRate,21,8),mm.FQtyPrecision) ").append("from t_bd_multimeasureunit mm ").append("where ").append(tempTable).append(".fmaterialid = mm.fmaterialid and mm.fisstatunit = 1 ").append(")");
        this.executeSQL(ctx, sql.toString());
    }

    private void groupTempTableForWhsLot(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        boolean isShowProject = params.getBoolean("isShowProject");
        boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        if (ckBxShowWhs.booleanValue() && ckBxShowLocation.booleanValue() && ckBxShowLot.booleanValue() && ckBxShowAsstAttr.booleanValue() && isShowProject && isShowTrackNum || !ckBxShowWhs.booleanValue() && !ckBxShowLocation.booleanValue() && !ckBxShowLot.booleanValue() && !ckBxShowAsstAttr.booleanValue() && !isShowProject && !isShowTrackNum) {
            sql.append("update ").append(tempTable).append(" set FIndex = 0");
            this.executeSQL(ctx, sql.toString());
        } else {
            sql.append(this.getInsertFiledsSql(params)).append(" ").append("select newbosid('88888888'),0 as Findex,FCompanyOrgUnitID,FStorageOrgUnitID,FStoreTypeID,FSupplierID,FCustomerID,").append(ckBxShowWhs != false ? "" : " null as ").append("FWarehouseID,").append(ckBxShowLocation != false ? "" : " null as ").append("FLocationID,").append("FMaterialID,").append(ckBxShowLot != false ? "" : "null as ").append("FLot,").append(isShowProject ? "" : "null as ").append("FProjectId,").append(isShowTrackNum ? "" : "null as ").append("FTrackNumberId,").append(ckBxShowAsstAttr != false ? "" : "null as ").append("FAssistPropertyID,").append(this.getGroupFiledsSql(params)).append(" ").append("from ").append(tempTable).append(" ").append("group by FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,FSupplierID,FCustomerID").append(ckBxShowWhs != false ? ",FWarehouseID" : "").append(ckBxShowLocation != false ? ",FLocationID" : "").append(ckBxShowLot != false ? ",FLot" : "").append(isShowProject ? ",FProjectId" : "").append(isShowTrackNum ? ",FTrackNumberId" : "").append(ckBxShowAsstAttr != false ? ",FAssistPropertyID" : "");
            this.executeSQL(ctx, sql.toString());
            String sqlDel = "delete from " + tempTable + " where Findex = -1 ";
            this.executeSQL(ctx, sqlDel);
        }
    }

    private void levelTempTable(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        Boolean ckBoxStoreTypeGather = (Boolean)params.getObject("ckBoxStoreTypeGather");
        if (ckBoxStoreTypeGather.booleanValue()) {
            this.levelToStoreType(ctx, orgTempTable, params);
        } else {
            this.levelToStorageOrg(ctx, orgTempTable, params);
        }
    }

    protected void levelTempTableGroup(Context ctx, String orgTempTable, RptParams params) throws EASBizException, BOSException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        Boolean ckBoxStoreTypeGather = (Boolean)params.getObject("ckBoxStoreTypeGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        Boolean ckBxByStatUnit = (Boolean)params.getObject("ckBxByStatUnit");
        if (ckBoxLevelGather.booleanValue()) {
            this.updateNeedInfo(ctx, orgTempTable, params);
            if (ckBxByStatUnit.booleanValue()) {
                this.updateStatUnit(ctx, params.getString("tempTable"), params);
            }
            this.levelToRootOrg(ctx, orgTempTable, params);
            if (coBoxGatherCondition == 0) {
                this.levelByMaterialGroup(ctx, orgTempTable, params);
            } else {
                this.levelByCalType(ctx, orgTempTable, params);
            }
        } else if (ckBoxStoreTypeGather.booleanValue()) {
            this.levelByStoreType(ctx, orgTempTable, params);
        } else {
            this.levelByStorageOrg(ctx, orgTempTable, params);
        }
    }

    private void levelToStorageOrg(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        boolean isShowProject = params.getBoolean("isShowProject");
        boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        boolean isUseTempTable_temp = false;
        if (!(ckBxShowWhs.booleanValue() || ckBxShowLocation.booleanValue() || ckBxShowLot.booleanValue() || ckBxShowAsstAttr.booleanValue() || isShowProject || isShowTrackNum)) {
            isUseTempTable_temp = true;
        }
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append(this.getInsertFiledsSql(params, isUseTempTable_temp));
        sql.append("select ").append("newbosid('88888888'),1 as Findex,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,").append("null as FWarehouseID,null as FLocationID,null as FLot,null as FProjectId,null as FTrackNumberId,null as FAssistPropertyID,").append(isUseTempTable_temp ? "FSupplierID," : "null as FSupplierID,").append(isUseTempTable_temp ? "FCustomerID," : "null as FCustomerID,").append(this.getGroupFiledsSql(params)).append(" ").append("from ").append(tempTable).append(" ").append("group by FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID ");
        if (isUseTempTable_temp) {
            sql.append(",FSupplierID,FCustomerID ");
        }
        this.executeSQL(ctx, sql.toString());
        if (isUseTempTable_temp) {
            String sqlDel = "delete from " + tempTable + " where Findex = 0 ";
            this.executeSQL(ctx, sqlDel);
            this.exchangeTemptable(ctx, params);
        }
    }

    private void levelToStoreType(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        boolean isShowProject = params.getBoolean("isShowProject");
        boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        sql.append(this.getInsertFiledsSql(params, true));
        sql.append("select ").append("newbosid('88888888'),1 as Findex,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,").append(ckBxShowWhs != false ? "FWarehouseID," : "null as FWarehouseID,").append(ckBxShowLocation != false ? "FLocationID," : "null as FLocationID,").append(ckBxShowLot != false ? "FLot," : "null as FLot,").append(isShowProject ? "FProjectId," : "null as FProjectId,").append(isShowTrackNum ? "FTrackNumberId," : "null as FTrackNumberId,").append(ckBxShowAsstAttr != false ? "FAssistPropertyID," : "null as FAssistPropertyID,").append("FSupplierID,FCustomerID,").append(this.getGroupFiledsSql(params)).append(" ").append("from ").append(tempTable).append(" ").append("group by FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,FSupplierID,FCustomerID");
        if (ckBxShowWhs.booleanValue()) {
            sql.append(",FWarehouseID");
        }
        if (ckBxShowLocation.booleanValue()) {
            sql.append(",FLocationID");
        }
        if (ckBxShowLot.booleanValue()) {
            sql.append(",FLot");
        }
        if (isShowProject) {
            sql.append(",FProjectId");
        }
        if (isShowTrackNum) {
            sql.append(",FTrackNumberId");
        }
        if (ckBxShowAsstAttr.booleanValue()) {
            sql.append(",FAssistPropertyID");
        }
        this.executeSQL(ctx, sql.toString());
        String sqlDel = "delete from " + tempTable + " where Findex = 0 ";
        this.executeSQL(ctx, sqlDel);
        this.exchangeTemptable(ctx, params);
    }

    private void updateNeedInfo(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String mgStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        if (coBoxGatherCondition == 0) {
            sql.append("update ").append(tempTable).append(" set (fmaterialgroupid) = ").append("(select isnull(g.Fid, 'X') from t_bd_material m ").append(" left join T_BD_MaterialGroupDetial as  MGD on MGD.FMaterialID = m.fid AND MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("'  ").append(" left join T_BD_MaterialGroup as g on g.FID = MGD.FMaterialGroupID  ").append("where m.fid = ").append(tempTable).append(".fmaterialid").append(")");
        } else {
            sql.append("update ").append(tempTable).append(" set (FMaterialCostType) = ").append("(select to_char(mc.FStoreType) from T_BD_MaterialCost mc ").append("where mc.fmaterialid = ").append(tempTable).append(".fmaterialid ").append("and mc.FOrgUnit = ").append(tempTable).append(".FCompanyOrgUnitID").append(")");
        }
        this.executeSQL(ctx, sql.toString());
    }

    private void levelToRootOrg(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String storageorgid = "";
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        RptRowSet rs = this.executeQuery("select top 1 fid as fstorageorgunitid  from " + orgTempTable + " where flevel is not null order by flevel asc", null, ctx);
        if (rs.next()) {
            storageorgid = rs.getString("fstorageorgunitid");
        }
        sql.append(this.getInsertFiledsSql(params, new String[]{coBoxGatherCondition == 0 ? "FMaterialGroupID" : "FMaterialCostType"}));
        sql.append("select ").append("newbosid('88888888'),2 as Findex,null as FCompanyOrgUnitID,").append("'").append(storageorgid).append("' as FStorageOrgUnitID,null as FStoreTypeID,null as FSupplierID,null as FCustomerID,").append("null as FWarehouseID,null as FLocationID,null as FMaterialID,null as FLot,null as FProjectId,null as FTrackNumberId,null as FAssistPropertyID,").append(coBoxGatherCondition == 0 ? "FMaterialGroupID" : "FMaterialCostType").append(",").append(this.getGroupFiledsSql(params)).append(" ").append("from ").append(tempTable).append(" ").append("where Findex <> 0 ").append("group by ").append(coBoxGatherCondition == 0 ? "FMaterialGroupID" : "FMaterialCostType");
        this.executeSQL(ctx, sql.toString());
    }

    private void levelByStoreType(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String storageorgid = "";
        RptRowSet rs = this.executeQuery("select top 1 fid as fstorageorgunitid  from " + orgTempTable + " where flevel is not null order by flevel,fid asc", null, ctx);
        if (rs.next()) {
            storageorgid = rs.getString("fstorageorgunitid");
        }
        sql.append(this.getInsertFiledsSql(params)).append(" ");
        sql.append("select ").append("newbosid('88888888'),2 as FIndex,null as FCompanyOrgUnitID,").append("'").append(storageorgid).append("' as FStorageOrgUnitID,FStoreTypeID,null as FSupplierID,null as FCustomerID,").append("null as FWarehouseID,null as FLocationID,null as FMaterialID,null as FLot,null as FProjectId,null as FTrackNumberId,null as FAssistPropertyID,").append(this.getGroupFiledsSql(params)).append(" ").append("from ").append(tempTable).append(" where Findex <> 0 ").append("group by FStoreTypeID");
        this.executeSQL(ctx, sql.toString());
    }

    private void levelByStorageOrg(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String sqle = "";
        String tempTable = params.getString("tempTable");
        int level = (Integer)params.getObject(this.maxLevelStr);
        sql.append(this.getInsertFiledsSql(params)).append(" ");
        sql.append("select ").append("newbosid('88888888'),2 as FIndex,null as FCompanyOrgUnitID,b.fparentid as FStorageOrgUnitID,FStoreTypeID,").append("null as FSupplierID,null as FCustomerID,null as FWarehouseID,null as FLocationID,a.FMaterialID,").append("null as FLot,null as FProjectId,null as FTrackNumberId,null as FAssistPropertyID,").append(this.getGroupFiledsSql(params)).append(" ").append("from ").append(tempTable).append(" a,").append(orgTempTable).append(" b where a.fstorageorgunitid = b.fid and  b.flevel =");
        for (int i = level; i > 1; --i) {
            sqle = sql.toString() + i + " and findex <>0 group by b.fparentid,a.fmaterialid,FStoreTypeID ";
            this.executeSQL(ctx, sqle);
        }
    }

    private void levelByMaterialGroup(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String sqle = "";
        String tempTable = params.getString("tempTable");
        int level = this.getMaterialGroupMaxLevel(ctx, tempTable, params);
        params.setInt("maxMaterialGroupLevel", level);
        sql.append(this.getInsertFiledsSql(params, new String[]{"FMaterialGroupID"})).append(" ");
        sql.append("select ").append("newbosid('88888888'),3 as FIndex,null as FCompanyOrgUnitID,a.FStorageOrgUnitID as FStorageOrgUnitID,null as FStoreTypeID,null as FSupplierID,null as FCustomerID,").append("null as FWarehouseID,null as FLocationID,null as FMaterialID,null as FLot,null as FProjectId,null as FTrackNumberId,null as FAssistPropertyID,b.fparentid as FMaterialGroupID,").append(this.getGroupFiledsSql(params)).append(" ").append("from ").append(tempTable).append(" a,").append("t_bd_materialgroup b where a.fmaterialgroupid = b.fid and  b.flevel =");
        for (int i = level; i > 1; --i) {
            sqle = sql.toString() + i + " and findex >= 2 group by b.fparentid,a.FStorageOrgUnitID ";
            this.executeSQL(ctx, sqle);
        }
    }

    private void levelByCalType(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
    }

    private String getInsertFiledsSql(RptParams params, boolean isUseTempTable_Temp) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        if (isUseTempTable_Temp) {
            tempTable = params.getString("tempTable_Temp");
        }
        sql.append("insert into ").append(tempTable).append("(").append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,").append("FWarehouseID,FLocationID,FLot,FProjectId,FTrackNumberId,FAssistPropertyID,FSupplierID,FCustomerID,").append("FBeginQty,FBeginAmt,FBeginAssQty,").append("FriInQty,FriInAmt,FriInAssQty,").append("FriOutQty,FriOutAmt,FriOutAssQty ").append(") ");
        return sql.toString();
    }

    private String getInsertFiledsSql(RptParams params) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append("insert into ").append(tempTable).append("(").append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FStoreTypeID,FSupplierID,FCustomerID,").append("FWarehouseID,FLocationID,FMaterialID,FLot,FProjectId,FTrackNumberId,FAssistPropertyID,").append("FBeginQty,FBeginAmt,FBeginAssQty,").append("FriInQty,FriInAmt,FriInAssQty,").append("FriOutQty,FriOutAmt,FriOutAssQty ").append(") ");
        return sql.toString();
    }

    private String getInsertFiledsSql(RptParams params, String[] addFields) {
        StringBuffer sql = new StringBuffer();
        StringBuffer fields = new StringBuffer();
        String tempTable = params.getString("tempTable");
        for (int i = 0; i < addFields.length; ++i) {
            fields.append(addFields[i]).append(",");
        }
        sql.append("insert into ").append(tempTable).append("(").append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FStoreTypeID,FSupplierID,FCustomerID,").append("FWarehouseID,FLocationID,FMaterialID,FLot,FProjectId,FTrackNumberId,FAssistPropertyID,").append(fields).append("FBeginQty,FBeginAmt,FBeginAssQty,").append("FriInQty,FriInAmt,FriInAssQty,").append("FriOutQty,FriOutAmt,FriOutAssQty").append(") ");
        return sql.toString();
    }

    private String getGroupFiledsSql(RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("sum(FBeginQty),sum(FBeginAmt),sum(FBeginAssQty),").append("sum(FriInQty),sum(FriInAmt),sum(FriInAssQty),").append("sum(FriOutQty),sum(FriOutAmt),sum(FriOutAssQty) ");
        return sql.toString();
    }

    private int getMaterialGroupMaxLevel(Context ctx, String tempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        int maxLevel = 1;
        sql.append("select isnull(max(b.flevel),0) as flevel from " + tempTable + " a ");
        sql.append("left join t_bd_materialgroup b on a.fmaterialgroupid = b.fid ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        if (rs.next()) {
            maxLevel = rs.getInt("flevel");
        }
        return maxLevel;
    }

    private void deleteNoInOut(Context ctx, String tempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        int coBoxZeroCondition = params.getInt("coBoxZeroCondition");
        if (coBoxZeroCondition == 1) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FriInQty = 0");
        } else if (coBoxZeroCondition == 2) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FriOutQty = 0");
        } else if (coBoxZeroCondition == 3) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FriInQty = 0 and  FriOutQty = 0");
        } else if (coBoxZeroCondition == 4) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FBeginQty = 0");
        } else if (coBoxZeroCondition == 5) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FEndQty = 0");
        } else if (coBoxZeroCondition == 6) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FEndQty <> 0");
        } else if (coBoxZeroCondition == 7) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FEndQty <> 0 or FEndAmt = 0 ");
        } else if (coBoxZeroCondition == 8) {
            sql.append("delete from ").append(tempTable).append(" where ").append("FBeginQty = 0 and FBeginAmt = 0 ").append("and FriInQty = 0 and FriOutQty = 0 ").append("and FriInAmt = 0 and FriOutAmt = 0 ");
        }
        this.executeSQL(ctx, sql.toString());
    }

    private void updateEnd(Context ctx, String tempTable, RptParams params, int index) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTable).append(" set ").append("FEndQty = FBeginQty + FriInQty - FriOutQty,").append("FEndAmt = FBeginAmt + FriInAmt - FriOutAmt,").append("FEndAssQty = FBeginAssQty + FriInAssQty - FriOutAssQty  ");
        if (index != -10) {
            sql.append(" where findex = " + index);
        }
        this.executeSQL(ctx, sql.toString());
    }

    private void insertNeedInfo(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        Boolean ckBoxStoreTypeGather = (Boolean)params.getObject("ckBoxStoreTypeGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        boolean ckBxByStatUnit = (Boolean)params.getObject("ckBxByStatUnit");
        String mgStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable).append("(").append("FID,FIndex,FStoreTypeName,FMaterialGroupName,FMaterialGroupNumber,FMaterialNumber,").append("FMaterialName,FShortName,FMaterialSize,FAssistProperty,FAssistPropertyID,FBaseUnit,FAssistUnit,FStorageOrgName,").append("FWarehouseName,FWarehouseNumber,FLocationName,FSupplierName,FCustomerName,").append("FBeginQty,FBeginAmt,FriInQty,FriInAmt,FriOutQty,FriOutAmt,FEndQty,FEndAmt,FBeginAssQty,FriInAssQty,FriOutAssQty,FEndAssQty,").append("FStorageOrgUnitID,FStoreTypeID,FWarehouseID,").append("FMaterialID,FLot,FProjectID,FProjectNumber,FProjectName,FTrackNumberID,FTrackNumNumber,FTrackNumName,FMaterialGroupID,FBlockID,Fisfinaldata,FOriBeginQty,").append("flevel,fisleaf,fparentid,FMaterialCostType").append(") ");
        sql.append("Select ").append("t.FID as FID,t.FIndex as FIndex,").append("store.FName_" + this.loc + "  as FStoreTypeName,").append("g.FName_" + this.loc + "  as FMaterialGroupName,").append("g.FNumber as FMaterialGroupNumber,").append("m.FNumber as FMaterialNumber,").append("isnull(m.FName_" + this.loc + " ,'" + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"129_InOutStoreGatherReportFacadeControllerBean", (Locale)ctx.getLocale()) + "') as FMaterialName,").append("isnull(m.FShortName,'') as FShortName,").append("m.FModel as FMaterialSize,").append("asst.FName_" + this.loc + "  as FAssistProperty,").append("asst.FID as FAssistPropertyID,").append("u.FName_" + this.loc + "  as FBaseUnit,").append("u2.FName_" + this.loc + "  as FAssistUnit,").append("o.FName_" + this.loc + "  as FStorageOrgName,").append("wh.FName_" + this.loc + "  as FWarehouseName,").append("wh.FNumber as FWarehouseNumber,").append("lo.FName_" + this.loc + "  as FLocationName,").append("su.FName_" + this.loc + "  as FSupplierName,").append("cu.FName_" + this.loc + "  as FCustomerName,").append("t.FBeginQty,t.FBeginAmt,t.FriInQty,t.FriInAmt,t.FriOutQty,t.FriOutAmt,t.FEndQty,t.FEndAmt,t.FBeginAssQty,t.FriInAssQty,t.FriOutAssQty,t.FEndAssQty,").append("t.FStorageOrgUnitID,t.FStoreTypeID,t.FWarehouseID,t.FMaterialID,t.FLot,").append("t.FProjectId,project.FNumber FProjectNumber,project.FName_" + this.loc + " FProjectName,").append("t.FTrackNumberId,track.FNumber FTrackNumNumber,track.FName_" + this.loc + " FTrackNumName,").append("ISNULL(g.FID,'X') as FMaterialGroupID,isnull(t.FBlockID,'X') as FBlockID,1 as Fisfinaldata,t.FOriBeginQty,");
        if (ckBoxLevelGather.booleanValue()) {
            if (coBoxGatherCondition == 0) {
                sql.append("g.flevel,g.fisleaf,ISNULL(g.fparentid,'X'),'-1' as FMaterialCostType ");
            } else {
                sql.append("0 as flevel,0 as fisleaf,null as fparentid,t.FMaterialCostType as FMaterialCostType ");
            }
        } else if (ckBoxStoreTypeGather.booleanValue()) {
            sql.append("0 as flevel,0 as fisleaf,null as fparentid,'-1' as FMaterialCostType ");
        } else {
            sql.append("o.flevel,o.fisleaf,o.fparentid,'-1' as FMaterialCostType ");
        }
        sql.append("From ").append(tempTable).append(" t ").append("LEFT JOIN T_BD_Material m On t.FMaterialID = m.FID ").append("inner JOIN " + orgTempTable + " o ON t.FStorageOrgUnitID = o.FID ").append("LEFT JOIN T_BD_MeasureUnit u ON ").append(ckBxByStatUnit ? "t.FStatUnitID" : "m.FBaseUnit").append(" = u.FID ").append("LEFT JOIN T_BD_MeasureUnit u2 ON m.FAssistUnit = u2.FID ");
        if (ckBoxLevelGather.booleanValue() && coBoxGatherCondition == 0) {
            sql.append("LEFT JOIN T_BD_MaterialGroup g on ISNULL(t.FMaterialGroupID,'X') = ISNULL(g.FID,'X') ");
        } else {
            sql.append("LEFT JOIN T_BD_MaterialGroupDetial as  MGD on MGD.FMaterialID = m.fid AND MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("'  ").append("LEFT JOIN T_BD_MaterialGroup as g on g.FID = MGD.FMaterialGroupID  ");
        }
        sql.append("LEFT JOIN T_DB_Warehouse wh on t.FWarehouseID = wh.FID ").append("LEFT JOIN T_DB_Location lo on t.FLocationID = lo.FID ").append("LEFT JOIN T_BD_AsstAttrValue asst ON t.FAssistPropertyID = asst.FID ").append("LEFT JOIN T_IM_STORETYPE store ON t.FStoreTypeID = store.FID ").append("LEFT JOIN t_bd_supplier su ON t.fsupplierid = su.fid ").append("LEFT JOIN t_bd_customer cu ON t.fcustomerid = cu.fid ").append("LEFT JOIN T_MM_Project project on t.FProjectID = project.FID ").append("LEFT join T_MM_TrackNumber track on t.FTrackNumberID = track.FID ");
        this.executeSQL(ctx, sql.toString());
        this.executeSQL(ctx, "delete from " + tempTable + " where Fisfinaldata = 0 ");
    }

    private void finalUpdateTempTable(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        String sql;
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        boolean isShowProject = params.getBoolean("isShowProject");
        boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        String tempTable = params.getString("tempTable");
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        Boolean ckBoxStoreTypeGather = (Boolean)params.getObject("ckBoxStoreTypeGather");
        Boolean ckBxOnlyShowDetail = (Boolean)params.getObject("ckBxOnlyShowDetail");
        if (ckBxOnlyShowDetail.booleanValue()) {
            this.executeSQL(ctx, "update " + tempTable + " set fisleaf = 1,flevel = 1 ");
            return;
        }
        if (ckBoxLevelGather.booleanValue()) {
            if (coBoxGatherCondition == 0) {
                sql = "update " + tempTable + " set fisleaf = 0 where findex >= 2 ";
                this.executeSQL(ctx, sql);
                sql = "update " + tempTable + " set fisleaf = 0, flevel =1 where findex >= 2 and flevel is null and fmaterialgroupid = 'X'";
                sql = "update " + tempTable + " set fisleaf = 0, flevel =1 where findex >= 2 and flevel is null";
                this.executeSQL(ctx, sql);
                sql = "update " + tempTable + " set fisleaf = 1, flevel = flevel + 1,fparentid = fmaterialgroupid  where findex = 1 ";
                this.executeSQL(ctx, sql);
                sql = "update " + tempTable + " set fisleaf = 1, flevel = ISNULL(flevel,1) + 1,fparentid = fmaterialgroupid  where findex = 1 and flevel is null and fmaterialgroupid = 'X'";
                sql = "update " + tempTable + " set fisleaf = 1, flevel = ISNULL(flevel,1) + 1,fparentid = fmaterialgroupid  where findex = 1 and flevel is null ";
                this.executeSQL(ctx, sql);
                sql = "update " + tempTable + " set  flevel = flevel + 1  where findex = 0 ";
                this.executeSQL(ctx, sql);
                sql = "update " + tempTable + " set  flevel = ISNULL(flevel,1) + 1  where findex = 0 and flevel is null and fmaterialgroupid = 'X'";
                sql = "update " + tempTable + " set  flevel = ISNULL(flevel,1) + 1  where findex = 0 and flevel is null ";
                this.executeSQL(ctx, sql);
                StringBuffer sql2 = new StringBuffer();
                sql2.append("select mg.fid as fid,flongnumber as flongnumber from t_bd_materialGroup mg left join ").append(tempTable).append(" t on mg.fid = t.fmaterialgroupid where ").append(" t.flevel = 1");
                RptRowSet rs = this.executeQuery(sql2.toString(), null, ctx);
                FilterInfo filter = null;
                while (rs.next()) {
                    StringBuffer sql3 = new StringBuffer();
                    sql3.append("update ").append(tempTable).append(" set (FBlockID) = (").append("select '").append(rs.getString("fid")).append("' ").append("from t_bd_materialgroup g where ").append(tempTable).append(".fmaterialgroupid = g.fid and (");
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("g.flongnumber", (Object)rs.getString("flongnumber")));
                    sql3.append(" (" + filter.toSql() + " or ");
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("g.flongnumber", (Object)(rs.getString("flongnumber") + "!%"), CompareType.LIKE));
                    sql3.append(filter.toSql() + ")");
                    sql3.append("))");
                    this.executeSQL(ctx, sql3.toString());
                }
            } else {
                this.executeSQL(ctx, "update " + tempTable + " set flevel = 1 where findex = 2");
                this.executeSQL(ctx, "update " + tempTable + " set flevel = 2,fisleaf = 1,fparentid = FMaterialCostType where findex = 1");
                this.executeSQL(ctx, "update " + tempTable + " set flevel = 2,fparentid = FMaterialCostType where findex = 0");
            }
        } else if (ckBoxStoreTypeGather.booleanValue()) {
            this.executeSQL(ctx, "update " + tempTable + " set flevel = 1 where findex = 2");
            this.executeSQL(ctx, "update " + tempTable + " set flevel = 2,fisleaf = 1,fparentid = FStoreTypeID where findex = 1");
        }
        if ((ckBxShowWhs.booleanValue() || ckBxShowLocation.booleanValue() || ckBxShowLot.booleanValue() || ckBxShowAsstAttr.booleanValue() || isShowProject || isShowTrackNum) && !ckBoxStoreTypeGather.booleanValue()) {
            sql = "update " + tempTable + " set fisleaf = 0 where findex = 1 ";
            this.executeSQL(ctx, sql);
            sql = "update " + tempTable + " set fisleaf = 0, flevel =1 where findex = 1 and flevel is null and fmaterialgroupid = 'X'";
            this.executeSQL(ctx, sql);
            sql = "update " + tempTable + " set fisleaf = 1,flevel = flevel + 1 where findex = 0 ";
            this.executeSQL(ctx, sql);
            sql = "update " + tempTable + " set fisleaf = 1,flevel = ISNULL(flevel,1) + 1 where findex = 0 and flevel is null and fmaterialgroupid = 'X'";
            this.executeSQL(ctx, sql);
        } else {
            this.executeSQL(ctx, "delete from " + tempTable + " where findex = 0");
        }
        int spinQtyPrecision = params.getInt("spinQtyPrecission");
        int spinAmtPrecision = params.getInt("spinAmountPrecission");
        int spinAssistQtyPrecision = params.getInt("spinAssQtyPrecission");
        StringBuffer sqlb = new StringBuffer();
        sqlb.append("update ").append(tempTable).append(" set ").append("FBeginQty = round(FBeginQty,").append(spinQtyPrecision).append("),").append("FBeginAmt = round(FBeginAmt,").append(spinAmtPrecision).append("),").append("FriInQty = round(FriInQty,").append(spinQtyPrecision).append("),").append("FriInAmt = round(FriInAmt,").append(spinAmtPrecision).append("),").append("FriOutQty = round(FriOutQty,").append(spinQtyPrecision).append("),").append("FriOutAmt = round(FriOutAmt,").append(spinAmtPrecision).append("),").append("FEndQty = round(FEndQty,").append(spinQtyPrecision).append("),").append("FEndAmt = round(FEndAmt,").append(spinAmtPrecision).append("),").append("FBeginAssQty = round(FBeginAssQty,").append(spinAssistQtyPrecision).append("),").append("FriInAssQty = round(FriInAssQty,").append(spinAssistQtyPrecision).append("),").append("FriOutAssQty = round(FriOutAssQty,").append(spinAssistQtyPrecision).append("),").append("FEndAssQty = round(FEndAssQty,").append(spinAssistQtyPrecision).append(") ");
        this.executeSQL(ctx, sqlb.toString());
    }

    private void updateTotalLine(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(tempTable).append(" AS A SET(FBEGINQTY,FRIINQTY,FRIOUTQTY,FENDQTY)=");
        sql.append(" (SELECT FBEGINQTY,FRIINQTY,FRIOUTQTY,FENDQTY FROM");
        sql.append(" (");
        sql.append(" SELECT B.FSTORETYPEID, SUM(B.FBEGINQTY) AS FBEGINQTY,SUM(B.FRIINQTY) AS FRIINQTY");
        sql.append(" ,SUM(B.FRIOUTQTY) AS FRIOUTQTY,SUM(B.FENDQTY) AS FENDQTY FROM ").append(tempTable);
        sql.append(" AS B WHERE B.FLEVEL = 2 GROUP BY B.FSTORETYPEID");
        sql.append(" ) AS T WHERE A.FLEVEL=1 AND A.FSTORETYPEID=T.FSTORETYPEID )");
        this.executeSQL(ctx, sql.toString());
    }

    private void viewTotalLine(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        this.executeSQL(ctx, "delete from " + tempTable + " where flevel <> 1");
        this.executeSQL(ctx, "update " + tempTable + " set fisleaf = 1");
    }

    private void addSumRow(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer insertCols = new StringBuffer();
        StringBuffer sumCols = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        insertCols.append(" FID ,");
        insertCols.append("FBeginQty ,");
        insertCols.append("FBeginAmt ,");
        insertCols.append("FriInQty ,");
        insertCols.append("FriInAmt ,");
        insertCols.append("FriOutQty ,");
        insertCols.append("FriOutAmt ,");
        insertCols.append("FEndQty ,");
        insertCols.append("FEndAmt ,");
        insertCols.append("FBeginAssQty ,");
        insertCols.append("FriInAssQty ,");
        insertCols.append("FriOutAssQty ,");
        insertCols.append("FEndAssQty ,");
        insertCols.append("FStorageOrgName ,");
        insertCols.append("flevel ,");
        insertCols.append("fisleaf ");
        sumCols.append("newbosid('88888888'),");
        sumCols.append("ISNULL(sum(FBeginQty),0) ,");
        sumCols.append("ISNULL(sum(FBeginAmt),0) ,");
        sumCols.append("ISNULL(sum(FriInQty),0) ,");
        sumCols.append("ISNULL(sum(FriInAmt),0) ,");
        sumCols.append("ISNULL(sum(FriOutQty),0) ,");
        sumCols.append("ISNULL(sum(FriOutAmt),0) ,");
        sumCols.append("ISNULL(sum(FEndQty),0) ,");
        sumCols.append("ISNULL(sum(FEndAmt),0) ,");
        sumCols.append("ISNULL(sum(FBeginAssQty),0) ,");
        sumCols.append("ISNULL(sum(FriInAssQty ),0),");
        sumCols.append("ISNULL(sum(FriOutAssQty ),0),");
        sumCols.append("ISNULL(sum(FEndAssQty),0) ,");
        sumCols.append("'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz' ,");
        sumCols.append("1 ,");
        sumCols.append("0 ");
        sql.append(" INSERT INTO ");
        sql.append(tempTable);
        sql.append(" (");
        sql.append(insertCols);
        sql.append(" )");
        sql.append(" SELECT ");
        sql.append(sumCols);
        sql.append(" FROM ");
        sql.append(tempTable);
        sql.append(" WHERE ");
        sql.append(" flevel = 1 ");
        this.executeSQL(ctx, sql.toString());
    }

    private HashMap getResource(Context ctx, RptParams params) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        String resFile = "com.kingdee.eas.scm.im.rpt.IMRptResource";
        resMap.put("materialNumber", SCMUtils.getResource((String)resFile, (String)"materialNumber", (Context)ctx));
        resMap.put("materialName", SCMUtils.getResource((String)resFile, (String)"materialName", (Context)ctx));
        resMap.put("materialModel", SCMUtils.getResource((String)resFile, (String)"materialModel", (Context)ctx));
        resMap.put("baseUnit", SCMUtils.getResource((String)resFile, (String)"baseUnit", (Context)ctx));
        resMap.put("storageOrgUnit", SCMUtils.getResource((String)resFile, (String)"storageOrgUnit", (Context)ctx));
        resMap.put("beginInvQty", SCMUtils.getResource((String)resFile, (String)"beginInvQty", (Context)ctx));
        resMap.put("endInvQty", SCMUtils.getResource((String)resFile, (String)"endInvQty", (Context)ctx));
        resMap.put("qty", SCMUtils.getResource((String)resFile, (String)"qty", (Context)ctx));
        resMap.put("amount", SCMUtils.getResource((String)resFile, (String)"amount", (Context)ctx));
        resMap.put("price", SCMUtils.getResource((String)resFile, (String)"price", (Context)ctx));
        resMap.put("materialCostType", SCMUtils.getResource((String)resFile, (String)"materialCostType", (Context)ctx));
        resMap.put("materialType", SCMUtils.getResource((String)resFile, (String)"materialType", (Context)ctx));
        resMap.put("lot", SCMUtils.getResource((String)resFile, (String)"lot", (Context)ctx));
        resMap.put("warehouse", SCMUtils.getResource((String)resFile, (String)"warehouse", (Context)ctx));
        resMap.put("location", SCMUtils.getResource((String)resFile, (String)"location", (Context)ctx));
        resMap.put("none", SCMUtils.getResource((String)resFile, (String)"none", (Context)ctx));
        resMap.put("statUnit", SCMUtils.getResource((String)resFile, (String)"statUnit", (Context)ctx));
        resMap.put("assistQty", SCMUtils.getResource((String)resFile, (String)"assistQty", (Context)ctx));
        resMap.put("assistUnit", SCMUtils.getResource((String)resFile, (String)"assistUnit2", (Context)ctx));
        resMap.put("riIn", SCMUtils.getResource((String)resFile, (String)"riIn", (Context)ctx));
        resMap.put("riOut", SCMUtils.getResource((String)resFile, (String)"riOut", (Context)ctx));
        resMap.put("storePeriod", SCMUtils.getResource((String)resFile, (String)"storePeriod", (Context)ctx));
        resMap.put("assistProperty", SCMUtils.getResource((String)resFile, (String)"assistProperty", (Context)ctx));
        resMap.put("storeType", SCMUtils.getResource((String)resFile, (String)"FStoreTypeID", (Context)ctx));
        resMap.put("supplier", SCMUtils.getResource((String)resFile, (String)"Supplier", (Context)ctx));
        resMap.put("customer", SCMUtils.getResource((String)resFile, (String)"Customer", (Context)ctx));
        resMap.put("projectNumber", SCMUtils.getResource((String)resFile, (String)"projectNumber", (Context)ctx));
        resMap.put("projectName", SCMUtils.getResource((String)resFile, (String)"projectName", (Context)ctx));
        resMap.put("trackNumber", SCMUtils.getResource((String)resFile, (String)"trackNumber", (Context)ctx));
        resMap.put("trackName", SCMUtils.getResource((String)resFile, (String)"trackName", (Context)ctx));
        resMap.put("shortName", SCMUtils.getResource((String)resFile, (String)"shortName", (Context)ctx));
        return resMap;
    }

    private String querySql(RptParams params) throws BOSException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        boolean isShowProject = params.getBoolean("isShowProject");
        boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        String tempTable = params.getString("tempTable");
        String filedName = "FMaterialGroupName";
        StringBuffer sql = new StringBuffer();
        int pricePrecision = params.getInt("spinPricePrecission");
        if (ckBoxLevelGather.booleanValue() && coBoxGatherCondition == 1) {
            filedName = "FMaterialCostTypeName";
        }
        sql.append("Select ").append("FStoreTypeName").append(",").append(filedName).append(",").append("FMaterialNumber,FMaterialName,").append(ckBxShowMShortName ? "FShortName," : "").append("FMaterialSize,").append(ckBxShowAsstAttr ? "FAssistProperty," : "").append("FBaseUnit,").append("FAssistUnit,").append("FStorageOrgName,").append(ckBxShowWhs ? "FWarehouseName," : "").append(ckBxShowLocation ? "FLocationName," : "").append(ckBxShowLot ? "FLot," : "").append(isShowProject ? "FProjectNumber," : "").append(isShowProject ? "FProjectName," : "").append(isShowTrackNum ? "FTrackNumNumber," : "").append(isShowTrackNum ? "FTrackNumName," : "").append("FSupplierName,FCustomerName,").append("FBeginQty,FBeginAssQty,").append("case FBeginQty when 0 then 0 else round(FBeginAmt/FBeginQty,").append(pricePrecision).append(") end as FBeginPrice,").append("FBeginAmt,").append("FriInQty,FriInAssQty,").append("case FriInQty when 0 then 0 else round(FriInAmt/FriInQty,").append(pricePrecision).append(") end as FriInPrice,").append("FriInAmt,").append("FriOutQty,FriOutAssQty,").append("case FriOutQty when 0 then 0 else round(FriOutAmt/FriOutQty,").append(pricePrecision).append(") end as FriOutPrice,").append("FriOutAmt,").append("FEndQty,FEndAssQty,").append("case FEndQty when 0 then 0 else round(FEndAmt/FEndQty,").append(pricePrecision).append(") end as FEndPrice,").append("FEndAmt,").append("flevel,fisleaf,fparentid,FStorageOrgUnitID,case FWarehouseID when '1' then null else FWarehouseID end,").append("case FProjectId when '1' then null else FProjectId end,").append("case FTrackNumberId when '1' then null else FTrackNumberId end,").append("FMaterialID,FMaterialGroupID,FMaterialCostType,FStoreTypeID,FBlockID,FIndex,FAssistPropertyID,FOriBeginQty ").append("From ").append(tempTable).append(" ");
        return sql.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(this.querySql(params));
        int start = from + 1;
        int end = from + len;
        sql.append(" where KSQL_SEQ >=").append(start).append(" and KSQL_SEQ <=").append(end);
        sql.append(" Order by KSQL_SEQ ASC");
        IRowSet Irs = null;
        RptRowSet rs = null;
        if (params.containsKey("action") && "report".equals(params.getString("action"))) {
            Irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        } else {
            rs = this.executeQuery(sql.toString(), null, ctx);
        }
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        pp.setObject("IRowSet", (Object)Irs);
        return pp;
    }

    protected RptParams _findData(Context ctx, RptParams params, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        Boolean ckBoxStoreTypeGather = (Boolean)params.getObject("ckBoxStoreTypeGather");
        String findex = params.getString("findex");
        StringBuffer sql = new StringBuffer();
        if (ckBoxLevelGather.booleanValue()) {
            sql.append(this.querySql(params)).append(" where ");
            if (coBoxGatherCondition == 0) {
                if ("2".equals(findex)) {
                    sql.append(" fparentid = '").append(params.getString("fparentid")).append("' and findex = 1 ").append("order by FMaterialNumber");
                } else if ("1".equals(findex)) {
                    sql.append(" fmaterialid = '").append(params.getString("fmaterialid")).append("' and findex = 0 ").append("and fstoretypeid = '").append(params.getString("fstoretypeid")).append("' ").append("order by fwarehouseid,flot,FAssistProperty");
                } else {
                    sql.append(" fparentid = '").append(params.getString("fparentid")).append("' and findex<>1 and findex <> 0 ").append("order by FMaterialGroupNumber,FMaterialNumber,fwarehouseid,FLot,FAssistProperty");
                }
            } else {
                if ("2".equals(findex)) {
                    if (params.getString("fparentid") == null || params.getString("fparentid").equals("X")) {
                        sql.append(" fparentid is null").append(" and findex = 1 ");
                    } else {
                        sql.append(" fparentid = '").append(params.getString("fparentid")).append("' and findex = 1 ");
                    }
                    sql.append("order by FMaterialNumber,fwarehouseid,flot,FAssistProperty");
                } else if ("1".equals(findex)) {
                    sql.append(" fmaterialid = '").append(params.getString("fmaterialid")).append("' and findex = 0 ").append("order by fwarehouseid,flot,FAssistProperty");
                }
                if ("0".equals(findex) && sql.toString().trim().endsWith("where")) {
                    sql = sql.delete(sql.toString().lastIndexOf("where"), sql.toString().length());
                }
            }
        } else if (ckBoxStoreTypeGather.booleanValue()) {
            sql.append(this.querySql(params)).append(" where ");
            if ("2".equals(findex)) {
                sql.append("fparentid = '").append(params.getString("fparentid")).append("' and findex = 1 ");
                sql.append("order by FMaterialNumber,fwarehouseid,flot,FAssistProperty");
            }
        } else {
            sql.append(this.querySql(params)).append(" where fmaterialid='").append(params.getString("fmaterialid")).append("' ").append("and fstoretypeid = '").append(params.getString("fstoretypeid")).append("' ");
            if ("1".equals(findex)) {
                sql.append("and fstorageorgunitid = '").append(params.getString("fstorageorgunitid")).append("' ").append("and findex = 0 ").append("order by fwarehouseid,flot,FAssistProperty");
            } else {
                sql.append("and fparentid='").append(params.getString("fparentid")).append("' ").append("and findex <> 0 ").append("order by fwarehouseid,flot,FAssistProperty");
            }
        }
        RptRowSet rs = start <= -1 && count <= -1 ? this.executeQuery(sql.toString(), null, ctx) : this.executeQuery(sql.toString(), null, start, count, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        Boolean ckBxOnlyShowDetail = (Boolean)param.getObject("ckBxOnlyShowDetail");
        String orderBy = "";
        orderBy = ckBxOnlyShowDetail != false ? "order by Findex" : "order by Findex desc";
        String rsList = "select  fid from " + param.getString("tempTable") + " where flevel = 1 " + orderBy + " ,FMaterialGroupNumber,FMaterialNumber,fwarehouseid,flot,FId  ";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    protected RptParams _getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException {
        StringBuffer fid = new StringBuffer(" FId IN (  '").append(idList.get(0).toString()).append("'");
        int n = idList.size();
        for (int i = 1; i < n; ++i) {
            fid.append(", '").append(idList.get(i).toString()).append("'");
        }
        fid.append(" ) ");
        Boolean ckBxOnlyShowDetail = (Boolean)params.getObject("ckBxOnlyShowDetail");
        String orderBy = "";
        orderBy = ckBxOnlyShowDetail != false ? "order by Findex" : "order by Findex desc";
        String rsList = this.querySql(params) + "  where " + fid.toString() + orderBy + " ,FMaterialGroupNumber,FMaterialNumber,fwarehouseid,FLot,FId";
        RptRowSet rs = this.executeQuery(rsList, null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private Map buildQueryHead(Context ctx, RptParams params) {
        HashMap<String, Boolean> queryHeader = new HashMap<String, Boolean>();
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        Boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        boolean isShowProject = params.getBoolean("isShowProject");
        boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        queryHeader.put("FShortName", ckBxShowMShortName);
        queryHeader.put("FAssistProperty", ckBxShowAsstAttr);
        queryHeader.put("FWarehouseName", ckBxShowWhs);
        queryHeader.put("FLocationName", ckBxShowLocation);
        queryHeader.put("FLot", ckBxShowLot);
        queryHeader.put("FProjectNumber", isShowProject);
        queryHeader.put("FProjectName", isShowProject);
        queryHeader.put("FTrackNumNumber", isShowTrackNum);
        queryHeader.put("FTrackNumName", isShowTrackNum);
        String[] colName = new String[]{"FBeginQty", "FBeginAssQty", "FBeginPrice", "FBeginAmt", "FriInQty", "FriInAssQty", "FriInPrice", "FriInAmt", "FriOutQty", "FriOutAssQty", "FriOutPrice", "FriOutAmt", "FEndQty", "FEndAssQty", "FEndPrice", "FEndAmt"};
        for (int i = 0; i < colName.length; ++i) {
            queryHeader.put(colName[i], this.isQtyAmtPriceShow(params, colName[i]));
        }
        return queryHeader;
    }

    private RptTableHeader getReportHeader(RptParams params) {
        int i;
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        Boolean ckBxShowWhs = (Boolean)params.getObject("ckBxShowWhs");
        Boolean ckBxShowLocation = (Boolean)params.getObject("ckBxShowLocation");
        Boolean ckBxShowLot = (Boolean)params.getObject("ckBxShowLot");
        Boolean ckBxShowAsstAttr = (Boolean)params.getObject("ckBxShowAsstAttr");
        boolean isShowProject = params.getBoolean("isShowProject");
        boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        Boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        Boolean ckBxByStatUnit = (Boolean)params.getObject("ckBxByStatUnit");
        String[] colName = new String[]{"FBeginQty", "FBeginAssQty", "FBeginPrice", "FBeginAmt", "FriInQty", "FriInAssQty", "FriInPrice", "FriInAmt", "FriOutQty", "FriOutAssQty", "FriOutPrice", "FriOutAmt", "FEndQty", "FEndAssQty", "FEndPrice", "FEndAmt"};
        String[] colBockName = new String[]{"beginInvQty", "riIn", "riOut", "endInvQty"};
        col = new RptTableColumn("FStoreTypeName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialGroupName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialNumber");
        col.setWidth(80);
        col.setFormatPattern("@");
        header.addColumn(col);
        col = new RptTableColumn("FMaterialName");
        col.setWidth(100);
        col.setFormatPattern("@");
        header.addColumn(col);
        if (ckBxShowMShortName.booleanValue()) {
            col = new RptTableColumn("FShortName");
            col.setWidth(100);
            header.addColumn(col);
        }
        col = new RptTableColumn("FMaterialSize");
        col.setWidth(100);
        header.addColumn(col);
        if (ckBxShowAsstAttr.booleanValue()) {
            col = new RptTableColumn("FAssistProperty");
            col.setWidth(100);
            header.addColumn(col);
        }
        col = new RptTableColumn("FBaseUnit");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FAssistUnit");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FStorageOrgName");
        col.setWidth(150);
        header.addColumn(col);
        if (ckBxShowWhs.booleanValue()) {
            col = new RptTableColumn("FWarehouseName");
            col.setWidth(100);
            header.addColumn(col);
        }
        if (ckBxShowLocation.booleanValue()) {
            col = new RptTableColumn("FLocationName");
            col.setWidth(100);
            header.addColumn(col);
        }
        if (ckBxShowLot.booleanValue()) {
            col = new RptTableColumn("FLot");
            col.setWidth(100);
            header.addColumn(col);
        }
        if (isShowProject) {
            col = new RptTableColumn("FProjectNumber");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FProjectName");
            col.setWidth(100);
            header.addColumn(col);
        }
        if (isShowTrackNum) {
            col = new RptTableColumn("FTrackNumNumber");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FTrackNumName");
            col.setWidth(100);
            header.addColumn(col);
        }
        col = new RptTableColumn("FSupplierName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FCustomerName");
        col.setWidth(100);
        header.addColumn(col);
        for (int i2 = 0; i2 < colName.length; ++i2) {
            boolean isHide = !this.isQtyAmtPriceShow(params, colName[i2]);
            this.setRptColunm(header, colName[i2], 2, isHide);
        }
        boolean isHideCol = true;
        col = new RptTableColumn("Flevel");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("Fisleaf");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FParentID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FStorageOrgUnitID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FWarehouseID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FProjectId");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FTrackNumberId");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("fmaterialid");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialGroupID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialCostType");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FStoreTypeID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FBlockID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FIndex");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FAssistPropertyID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FOriBeginQty");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        HashMap resMap = (HashMap)params.getObject(this.resMapStr);
        int arrayLength = 41;
        if (ckBxShowWhs.booleanValue()) {
            ++arrayLength;
        }
        if (ckBxShowLocation.booleanValue()) {
            ++arrayLength;
        }
        if (ckBxShowLot.booleanValue()) {
            ++arrayLength;
        }
        if (isShowProject) {
            arrayLength += 2;
        }
        if (isShowTrackNum) {
            arrayLength += 2;
        }
        if (ckBxShowAsstAttr.booleanValue()) {
            ++arrayLength;
        }
        if (ckBxShowMShortName.booleanValue()) {
            ++arrayLength;
        }
        int m = 0;
        Object[][] labels = new Object[2][arrayLength];
        labels[0][m] = (String)resMap.get("storeType");
        ++m;
        Boolean ckBoxLevelGather = (Boolean)params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = params.getInt("coBoxGatherCondition");
        if (ckBoxLevelGather.booleanValue() && coBoxGatherCondition == 1) {
            labels[0][m] = (String)resMap.get("materialCostType");
            ++m;
        } else {
            labels[0][m] = (String)resMap.get("materialType");
            ++m;
        }
        labels[0][m] = (String)resMap.get("materialNumber");
        labels[0][++m] = (String)resMap.get("materialName");
        ++m;
        if (ckBxShowMShortName.booleanValue()) {
            labels[0][m] = (String)resMap.get("shortName");
            ++m;
        }
        labels[0][m] = (String)resMap.get("materialModel");
        ++m;
        if (ckBxShowAsstAttr.booleanValue()) {
            labels[0][m] = (String)resMap.get("assistProperty");
            ++m;
        }
        if (ckBxByStatUnit.booleanValue()) {
            labels[0][m] = (String)resMap.get("statUnit");
            ++m;
        } else {
            labels[0][m] = (String)resMap.get("baseUnit");
            ++m;
        }
        labels[0][m] = (String)resMap.get("assistUnit");
        labels[0][++m] = (String)resMap.get("storageOrgUnit");
        ++m;
        if (ckBxShowWhs.booleanValue()) {
            labels[0][m] = (String)resMap.get("warehouse");
            ++m;
        }
        if (ckBxShowLocation.booleanValue()) {
            labels[0][m] = (String)resMap.get("location");
            ++m;
        }
        if (ckBxShowLot.booleanValue()) {
            labels[0][m] = (String)resMap.get("lot");
            ++m;
        }
        if (isShowProject) {
            labels[0][m] = (String)resMap.get("projectNumber");
            labels[0][++m] = (String)resMap.get("projectName");
            ++m;
        }
        if (isShowTrackNum) {
            labels[0][m] = (String)resMap.get("trackNumber");
            labels[0][++m] = (String)resMap.get("trackName");
            ++m;
        }
        labels[0][m] = (String)resMap.get("supplier");
        labels[0][++m] = (String)resMap.get("customer");
        ++m;
        for (int i3 = 0; i3 < colBockName.length; ++i3) {
            String blockName = (String)resMap.get(colBockName[i3]);
            labels[0][m] = blockName;
            labels[0][++m] = blockName;
            labels[0][++m] = blockName;
            labels[0][++m] = blockName;
            ++m;
        }
        labels[0][m] = "level";
        labels[0][++m] = "isLeaf";
        labels[0][++m] = "FParentID";
        labels[0][++m] = "FStorageOrgID";
        labels[0][++m] = "FWarehouseID";
        labels[0][++m] = "FProjectId";
        labels[0][++m] = "FTrackNumberId";
        labels[0][++m] = "FMaterialID";
        labels[0][++m] = "FMaterialGroupID";
        labels[0][++m] = "FMaterialCostType";
        labels[0][++m] = "FBlockID";
        labels[0][++m] = "FIndex";
        labels[0][++m] = "FAssistPropertyID";
        labels[0][++m] = "FOriBeginQty";
        StringBuffer strtem = new StringBuffer();
        for (i = 0; i < labels[0].length; ++i) {
            strtem.append(i);
            strtem.append(labels[0][i]);
            strtem.append(" ,");
        }
        m = 0;
        labels[1][m] = (String)resMap.get("storeType");
        ++m;
        if (ckBoxLevelGather.booleanValue() && coBoxGatherCondition == 1) {
            labels[1][m] = (String)resMap.get("materialCostType");
            ++m;
        } else {
            labels[1][m] = (String)resMap.get("materialType");
            ++m;
        }
        labels[1][m] = (String)resMap.get("materialNumber");
        labels[1][++m] = (String)resMap.get("materialName");
        ++m;
        if (ckBxShowMShortName.booleanValue()) {
            labels[1][m] = (String)resMap.get("shortName");
            ++m;
        }
        labels[1][m] = (String)resMap.get("materialModel");
        ++m;
        if (ckBxShowAsstAttr.booleanValue()) {
            labels[1][m] = (String)resMap.get("assistProperty");
            ++m;
        }
        if (ckBxByStatUnit.booleanValue()) {
            labels[1][m] = (String)resMap.get("statUnit");
            ++m;
        } else {
            labels[1][m] = (String)resMap.get("baseUnit");
            ++m;
        }
        labels[1][m] = (String)resMap.get("assistUnit");
        labels[1][++m] = (String)resMap.get("storageOrgUnit");
        ++m;
        if (ckBxShowWhs.booleanValue()) {
            labels[1][m] = (String)resMap.get("warehouse");
            ++m;
        }
        if (ckBxShowLocation.booleanValue()) {
            labels[1][m] = (String)resMap.get("location");
            ++m;
        }
        if (ckBxShowLot.booleanValue()) {
            labels[1][m] = (String)resMap.get("lot");
            ++m;
        }
        if (isShowProject) {
            labels[1][m] = (String)resMap.get("projectNumber");
            labels[1][++m] = (String)resMap.get("projectName");
            ++m;
        }
        if (isShowTrackNum) {
            labels[1][m] = (String)resMap.get("trackNumber");
            labels[1][++m] = (String)resMap.get("trackName");
            ++m;
        }
        labels[1][m] = (String)resMap.get("supplier");
        labels[1][++m] = (String)resMap.get("customer");
        ++m;
        for (i = 0; i < colBockName.length; ++i) {
            labels[1][m] = (String)resMap.get("qty");
            labels[1][++m] = (String)resMap.get("assistQty");
            labels[1][++m] = (String)resMap.get("price");
            labels[1][++m] = (String)resMap.get("amount");
            ++m;
        }
        labels[1][m] = "level";
        labels[1][++m] = "isLeaf";
        labels[1][++m] = "FParentID";
        labels[1][++m] = "FStorageOrgID";
        labels[1][++m] = "FWarehouseID";
        labels[1][++m] = "FProjectId";
        labels[1][++m] = "FTrackNumberId";
        labels[1][++m] = "FMaterialID";
        labels[1][++m] = "FMaterialGroupID";
        labels[1][++m] = "FMaterialCostType";
        labels[1][++m] = "FBlockID";
        labels[1][++m] = "FIndex";
        labels[1][++m] = "FAssistPropertyID";
        labels[1][++m] = "FOriBeginQty";
        header.setLabels(labels, true);
        return header;
    }

    private boolean isQtyAmtPriceShow(RptParams params, String colName) {
        Boolean ckBxShowQty = (Boolean)params.getObject("ckBxShowQty");
        Boolean ckBxShowAmt = (Boolean)params.getObject("ckBxShowAmt");
        Boolean ckBxShowPrice = (Boolean)params.getObject("ckBxShowPrice");
        Boolean ckBxShowAssistQty = (Boolean)params.getObject("ckBxShowAssistQty");
        if (colName.indexOf("AssQty") != -1) {
            return ckBxShowAssistQty;
        }
        if (colName.indexOf("Qty") != -1) {
            return ckBxShowQty;
        }
        if (colName.indexOf("Amt") != -1) {
            return ckBxShowAmt;
        }
        if (colName.indexOf("Price") != -1) {
            return ckBxShowPrice;
        }
        return true;
    }

    private void setRptColunm(RptTableHeader header, String colName, int position, boolean isHide) {
        RptTableColumn col = new RptTableColumn(colName);
        col.setWidth(isHide ? -1 : 100);
        col.setAligment(position);
        col.setHided(isHide);
        header.addColumn(col);
    }

    public static String genRandomNum(int pwd_len) throws BOSException {
        int maxNum = 36;
        int count = 0;
        char[] str = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer pwd = new StringBuffer("");
        SecureRandom r = new SecureRandom();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(36));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private void insertBillDateToTempTable(Context ctx, String orgTempTable, RptParams params) throws BOSException, EASBizException {
        boolean isUpdateArBill = this.isUpdateArBill(ctx, params, orgTempTable);
        long lstart = 0L;
        long lstop = 0L;
        logger.info((Object)"########### handleInitData start ");
        lstart = System.currentTimeMillis();
        this.handleInitData(ctx, params, orgTempTable, isUpdateArBill);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### handleInitData end: " + (lstop - lstart)));
        logger.info((Object)"########### handleBizData start ");
        lstart = System.currentTimeMillis();
        this.handleBizData(ctx, params, orgTempTable, isUpdateArBill);
        lstop = System.currentTimeMillis();
        logger.info((Object)("########### handleBizData end: " + (lstop - lstart)));
        this.dealWithIndex99(ctx, params);
        this.updateAllData(ctx, params);
    }

    private void dealWithIndex99(Context ctx, RptParams params) throws BOSException {
        StringBuffer insertSQL = new StringBuffer();
        String tempTable = params.getString("tempTable");
        insertSQL.append("insert into ").append(tempTable).append("(");
        insertSQL.append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,").append(NEWLINE);
        insertSQL.append("FWarehouseID,FLocationID,FLot,FAssistPropertyID,FSupplierID,FCustomerID,").append(NEWLINE);
        insertSQL.append("FStoreTypePreID,FProjectID,FTrackNumberId,").append(NEWLINE);
        insertSQL.append("FBeginQty,FBeginAssQty,FBeginAmt,FriInQty,FriInAssQty,FriInAmt,FriOutQty,FriOutAssQty,FriOutAmt").append(")").append(NEWLINE);
        insertSQL.append("select newbosid('88888888') as fid, -2 as findex, FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,").append(NEWLINE);
        insertSQL.append("FStoreTypeID,FWarehouseID,FLocationID,FLot,FAssistPropertyID,FSupplierID,FCustomerID,").append(NEWLINE);
        insertSQL.append("FStoreTypePreID,FProjectID,FTrackNumberId,").append(NEWLINE);
        insertSQL.append("FBeginQty,FBeginAssQty,FBeginAmt,FriInQty,FriInAssQty,FriInAmt,").append(NEWLINE);
        insertSQL.append("0 as FriOutQty, 0 as FriOutAssQty, 0 as FriOutAmt ").append(NEWLINE);
        insertSQL.append("from ").append(tempTable).append(" ").append(NEWLINE);
        insertSQL.append("where findex = 99 and FStoreTypeID is not null ").append(NEWLINE);
        if (this.getStoreTypeNumber(ctx, params) != null) {
            insertSQL.append("and FStoreTypeID in (select fid from t_im_storetype where ");
            insertSQL.append("fnumber in (").append(this.getStoreTypeNumber(ctx, params)).append(")) ");
        }
        insertSQL.append("union all ").append(NEWLINE);
        insertSQL.append("select newbosid('88888888') as fid, -2 as findex, FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,").append(NEWLINE);
        insertSQL.append("FStoreTypePreID as FStoreTypeID,FWarehouseID,FLocationID,FLot,FAssistPropertyID,FSupplierID,FCustomerID,").append(NEWLINE);
        insertSQL.append("FStoreTypePreID,FProjectID,FTrackNumberId,").append(NEWLINE);
        insertSQL.append("(-1) * ISNULL(FBeginQty,0) as FBeginQty,(-1) * ISNULL(FBeginAssQty,0) as FBeginAssAmt,(-1) * ISNULL(FBeginAmt,0) as FBeginAmt, ").append(NEWLINE);
        insertSQL.append("0 as FriInQty,0 as FriInAssQty, 0 as FriInAmt,").append(NEWLINE);
        insertSQL.append("FriInQty as FriOutQty,FriInAssQty as FriOutAssQty,FriInAmt as FriOutAmt ").append(NEWLINE);
        insertSQL.append("from ").append(tempTable).append(" ").append(NEWLINE);
        insertSQL.append("where findex = 99 and FStoreTypePreID is not null ").append(NEWLINE);
        if (this.getStoreTypeNumber(ctx, params) != null) {
            insertSQL.append("and FStoreTypePreID in (select fid from t_im_storetype where ");
            insertSQL.append("fnumber in (").append(this.getStoreTypeNumber(ctx, params)).append(")) ");
        }
        this.executeSQL(ctx, insertSQL.toString());
        this.executeSQL(ctx, "delete from " + tempTable + " where findex = 99");
    }

    private boolean isUpdateArBill(Context ctx, RptParams params, String orgTempTable) throws BOSException, EASBizException {
        Object[] storageOrgUnitIds = (Object[])params.getObject(this.leafStorageOrgUnitStr);
        if (storageOrgUnitIds.length > 0) {
            boolean isContainStoreTypeE = false;
            Object[] obj = (Object[])params.getObject("storeType");
            if (obj != null && obj[0] != null && obj.length > 0) {
                for (int i = 0; i < obj.length; ++i) {
                    StoreTypeInfo storeTypeInfo = (StoreTypeInfo)obj[i];
                    if (!"E".equals(storeTypeInfo.getNumber())) continue;
                    isContainStoreTypeE = true;
                }
            } else {
                isContainStoreTypeE = true;
            }
            if (!isContainStoreTypeE) {
                return false;
            }
            String couID = this.getCouBySou(ctx, storageOrgUnitIds);
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            String isUpdateByARBILL = ipc.getParamValue((IObjectPK)new ObjectUuidPK(couID), "CONSIGNSALES");
            if (isUpdateByARBILL != null) {
                return isUpdateByARBILL.trim().equals("true");
            }
            return false;
        }
        return false;
    }

    private String getCouBySou(Context ctx, Object[] storageOrgIDs) throws BOSException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select toUnit.id where fromUnit.id in (");
        int size = storageOrgIDs.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            oql.append("'").append(storageOrgIDs[i]).append("'");
        }
        oql.append(") ").append("and typeRelation.fromType = '").append(4).append("' ").append("and typeRelation.toType = '").append(1).append("' ");
        OrgUnitRelationCollection orgRelColl = iOrgRelation.getOrgUnitRelationCollection(oql.toString());
        return orgRelColl.get(0).getToUnit().getId().toString();
    }

    private String getInsertInitDataSQL(String tempTable) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTable).append("(");
        insertSQL.append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,FStoreTypePreID,FSupplierID,FCustomerID,");
        insertSQL.append("FWarehouseID,FLocationID,FLot,FProjectId,FTrackNumberId,FAssistPropertyID,FBeginQty,FBeginAmt,FBeginAssQty)").append(NEWLINE);
        return insertSQL.toString();
    }

    private String getInsertBizDataSQL(String tempTable) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTable).append("(");
        insertSQL.append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,FStoreTypePreID,").append(NEWLINE);
        insertSQL.append("FSupplierID,FCustomerID,FWarehouseID,FLocationID,FLot,FProjectID,FTrackNumberId,FAssistPropertyID,").append(NEWLINE);
        insertSQL.append("FBeginQty,FBeginAssQty,FBeginAmt,FriInQty,FriInAssQty,FriInAmt,FriOutQty,FriOutAssQty,FriOutAmt").append(")").append(NEWLINE);
        return insertSQL.toString();
    }

    private String getSupplierType4PurInWarehsInsertSQL(boolean isHandleInitData, String tempTable) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTable).append("(");
        insertSQL.append("FID,FIndex,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FStoreTypeID,FStoreTypePreID,").append(NEWLINE);
        insertSQL.append("FSupplierID,FCustomerID,FWarehouseID,FLocationID,FLot,FProjectID,FTrackNumberId,FAssistPropertyID,").append(NEWLINE);
        insertSQL.append("FBeginQty,FBeginAssQty,FBeginAmt").append(NEWLINE);
        if (!isHandleInitData) {
            insertSQL.append(",FriInQty,FriInAssQty,FriInAmt,FriOutQty,FriOutAssQty,FriOutAmt");
        }
        insertSQL.append(")");
        return insertSQL.toString();
    }

    private String getInitDataSelectorSQL(String tableName) {
        StringBuffer selector = new StringBuffer();
        selector.append("select newbosid('88888888'),");
        if ("T_IM_PurInWarehsBill".equals(tableName)) {
            selector.append("-2 as FIndex,");
        } else {
            selector.append("99 as FIndex,");
        }
        selector.append("et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,");
        selector.append("st.fid as FStoreTypeID,st2.fid as FStoreTypePreID,");
        selector.append(this.getSupplierAndCustomer(tableName));
        selector.append("et.FWarehouseID,et.FLocationID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,").append(NEWLINE);
        selector.append("sum(et.FBaseQty) as FBeginQty,").append(NEWLINE);
        selector.append("sum(et.FActualCost) as FBeginAmt,").append(NEWLINE);
        selector.append("sum(et.FAssistQty) as FBeginAssQty ").append(NEWLINE);
        return selector.toString();
    }

    private String getBizBillDataSelectorSQL(String tableName) {
        StringBuffer selector = new StringBuffer();
        selector.append("select newbosid('88888888'),");
        if ("T_IM_PurInWarehsBill".equals(tableName)) {
            selector.append("-2 as FIndex,");
        } else {
            selector.append("99 as FIndex,");
        }
        selector.append("et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,");
        selector.append("st.fid as FStoreTypeID, st2.fid as FStoreTypePreID,");
        selector.append(this.getSupplierAndCustomer(tableName));
        selector.append("et.FWarehouseID,et.FLocationID,et.FLot,et.FProjectID,et.FTrackNumberId,et.FAssistPropertyID,").append(NEWLINE);
        selector.append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,").append(NEWLINE);
        selector.append("sum(et.FBaseQty) as FriInQty,").append(NEWLINE);
        selector.append("sum(et.FAssistQty) as FriInAssQty,").append(NEWLINE);
        selector.append("sum(et.FActualCost) as FriInAmt,").append(NEWLINE);
        selector.append("0 as FriOutQty,").append(NEWLINE);
        selector.append("0 as FriOutAssQty,").append(NEWLINE);
        selector.append("0 as FriOutAmt ").append(NEWLINE);
        return selector.toString();
    }

    private String getSupplierType4PurInwareSelectorSQL(boolean isHandleInitData) {
        StringBuffer selector = new StringBuffer();
        selector.append("select newbosid('88888888'),");
        selector.append("-2 as FIndex,");
        selector.append("et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,");
        selector.append("st2.fid as FStoreTypeID, null as FStoreTypePreID,");
        selector.append(this.getSupplierAndCustomer(invTableName[0][0]));
        selector.append("et.FOutWarehouseID as FWarehouseID,et.FOutLocationID as FLocationID,et.FLot,et.FProjectID,et.FTrackNumberId,et.FAssistPropertyID,").append(NEWLINE);
        if (isHandleInitData) {
            selector.append("(-1) * ISNULL(sum(et.FBaseQty),0) as FBeginQty,").append(NEWLINE);
            selector.append("(-1) * ISNULL(sum(et.FAssistQty),0) as FBeginAssQty, ").append(NEWLINE);
            selector.append("(-1) * ISNULL(sum(et.FActualCost),0) as FBeginAmt").append(NEWLINE);
        } else {
            selector.append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,").append(NEWLINE);
        }
        if (!isHandleInitData) {
            selector.append("0 as FriInQty,").append(NEWLINE);
            selector.append("0 as FriInAssQty,").append(NEWLINE);
            selector.append("0 as FriInAmt,").append(NEWLINE);
            selector.append("sum(et.FBaseQty) as FriOutQty,").append(NEWLINE);
            selector.append("sum(et.FAssistQty) as FriOutAssQty,").append(NEWLINE);
            selector.append("sum(et.FActualCost) as FriOutAmt ").append(NEWLINE);
        }
        return selector.toString();
    }

    private String getInitBillDataWhereSQL(Context ctx, RptParams params, boolean isCostAdjBill, boolean isHasST2) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        java.util.Date dateFrom = (java.util.Date)params.getObject("dateFrom");
        sqlWhere.append(" where o.fisleaf = 1 ");
        sqlWhere.append(this.buildParamWhereStr(ctx, params, isHasST2)).append(NEWLINE);
        sqlWhere.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        sqlWhere.append(" and h.fbizdate >= o.fbegindate and h.fbizdate < to_date('").append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')").append(NEWLINE);
        if (!isCostAdjBill) {
            sqlWhere.append(" and (ISNULL(h.fisinitbill, 0) = 0)");
        }
        return sqlWhere.toString();
    }

    private String getSupplierAndCustomer(String tableName) {
        String supplierAndCustomer = null;
        supplierAndCustomer = invTableName[0][0].equals(tableName) ? "h.FSupplierID,et.FCustomerID," : (invTableName[1][0].equals(tableName) ? "et.FSupplierID,h.FCustomerID," : (invTableName[4][0].equals(tableName) ? "h.FSupplierID,h.FCustomerID," : "et.FSupplierID,et.FCustomerID,"));
        return supplierAndCustomer;
    }

    private String getBizBillDataWhereSQL(Context ctx, RptParams params, boolean isCostAdjBill, boolean isHasST2) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append(" where o.fisleaf = 1 ");
        sqlWhere.append(this.buildParamWhereStr(ctx, params, isHasST2)).append(NEWLINE);
        sqlWhere.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        sqlWhere.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        if (!isCostAdjBill) {
            sqlWhere.append(" and (ISNULL(h.fisinitbill, 0) = 0)");
        }
        return sqlWhere.toString();
    }

    private String getOtherBillWhereSQL(Context ctx, RptParams params, boolean isInit) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append(" where o.fisleaf = 1 ");
        sqlWhere.append(this.buildParamWhereStr(ctx, params, false)).append(NEWLINE);
        int coBoxBillStatus = 0;
        if (params.getObject("coBoxBillStatus") != null) {
            coBoxBillStatus = params.getInt("coBoxBillStatus");
        }
        if (coBoxBillStatus == 0) {
            sqlWhere.append(" and (otherBill.fbillstatus = 2");
            sqlWhere.append(" or otherBill.fbillstatus = 3)");
        } else if (coBoxBillStatus == 1) {
            sqlWhere.append(" and (otherBill.fbillstatus = 2)");
        } else if (coBoxBillStatus == 2) {
            sqlWhere.append(" and (otherBill.fbillstatus = 3)");
        }
        if (isInit) {
            java.util.Date dateFrom = (java.util.Date)params.getObject("dateFrom");
            sqlWhere.append(" and otherBill.fbizdate >= o.fbegindate and otherBill.fbizdate < to_date('").append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')").append(NEWLINE);
        } else {
            java.util.Date dateFrom = (java.util.Date)params.getObject("dateFrom");
            java.util.Date dateTo = (java.util.Date)params.getObject("dateTo");
            sqlWhere.append(" and otherBill.fbizdate >= to_date('").append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')");
            sqlWhere.append(" and otherBill.fbizdate <= to_date('").append(IMRptUtils.getFilterEndDate(dateTo)).append("')");
        }
        sqlWhere.append(" and (ISNULL(h.fisinitbill, 0) = 0)");
        return sqlWhere.toString();
    }

    private String getGroupBySQL(String tableName) {
        StringBuffer groupByStr = new StringBuffer();
        groupByStr.append("group by et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,");
        if (tableName != null) {
            groupByStr.append("st.fid, st2.fid, ");
            groupByStr.append(this.getSupplierAndCustomer(tableName));
        } else {
            groupByStr.append("et.FStoreTypeID,et.FSupplierID,et.FCustomerID,");
        }
        if (this.isSupplierTypeByPurInWarehs) {
            groupByStr.append("et.FOutWarehouseID, et.FOutLocationID,");
        } else {
            groupByStr.append("et.FWarehouseID,et.FLocationID,");
        }
        groupByStr.append("et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID");
        return groupByStr.toString();
    }

    private String getBillStatusWhereSQL(RptParams params) {
        StringBuffer sqlWhere = new StringBuffer();
        int coBoxBillStatus = 0;
        if (params.getObject("coBoxBillStatus") != null) {
            coBoxBillStatus = params.getInt("coBoxBillStatus");
        }
        if (coBoxBillStatus == 0) {
            sqlWhere.append(" and (h.fbasestatus = 2");
            sqlWhere.append(" or h.fbasestatus = 7");
            sqlWhere.append(" or h.fbasestatus = 4)");
        } else if (coBoxBillStatus == 1) {
            sqlWhere.append(" and (h.fbasestatus = 2)");
        } else if (coBoxBillStatus == 2) {
            sqlWhere.append(" and (h.fbasestatus = 4");
            sqlWhere.append(" or h.fbasestatus = 7)");
        }
        return sqlWhere.toString();
    }

    private String getBizBillDateWhereSQL(RptParams params) {
        StringBuffer sqlWhere = new StringBuffer();
        java.util.Date dateFrom = (java.util.Date)params.getObject("dateFrom");
        java.util.Date dateTo = (java.util.Date)params.getObject("dateTo");
        sqlWhere.append(" and h.fbizdate >= to_date('").append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')");
        sqlWhere.append(" and h.fbizdate <= to_date('").append(IMRptUtils.getFilterEndDate(dateTo)).append("')");
        return sqlWhere.toString();
    }

    private String getInitCostAdjBillSQL(Context ctx, RptParams params, String orgTempTable) throws BOSException {
        StringBuffer costAdjSQL = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        costAdjSQL.append(this.getInsertInitDataSQL(tempTable));
        costAdjSQL.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,et.FStoreTypeID,null as FStoreTypePreID,").append(NEWLINE);
        costAdjSQL.append("'1',et.FCustomerID,et.FWarehouseID,et.FLocationID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,").append(NEWLINE);
        costAdjSQL.append("0 as FBeginQty,sum(case h.FCalculateKind when 1 then  -1* et.FAmount else et.FAmount end) as FBeginAmt,0 as FBeginAssQty").append(NEWLINE);
        costAdjSQL.append("from T_CL_CostAdjustBillEntry et").append(NEWLINE);
        costAdjSQL.append("inner join T_CL_CostAdjustBill h on et.fparentid = h.fid").append(NEWLINE);
        costAdjSQL.append(billJoinStr);
        costAdjSQL.append(this.builderJoinForStoreTypeAndCS(params, "T_CL_CostAdjustBill", false));
        costAdjSQL.append(this.getInitBillDataWhereSQL(ctx, params, true, false));
        costAdjSQL.append(" and et.FStoreTypeID is not null ").append(NEWLINE);
        costAdjSQL.append("group by et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FStoreTypeID,et.FCustomerID,");
        costAdjSQL.append("et.FWarehouseID,et.FLocationID,et.FMaterialID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID");
        return costAdjSQL.toString();
    }

    private String getBizCostAdjBillSelector() {
        StringBuffer costAdjSelector = new StringBuffer();
        costAdjSelector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,et.FStoreTypeID,").append("null as FStoreTypePreID,'1',et.FCustomerID,et.FWarehouseID,et.FLocationID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,").append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,").append("0 as FriInQty,0 as FriInAssQty,").append("sum(case h.FCalculateKind when 1 then 0 else et.FAmount end) as FriInAmt,").append("0 as FriOytQty,0 as FriOutAssQty,").append("sum(case h.FCalculateKind when 1 then et.FAmount else 0 end) as FriOutAmt ");
        return costAdjSelector.toString();
    }

    private String getBizCostAdjBillSQL(Context ctx, RptParams params, String orgTempTable) throws BOSException {
        StringBuffer costAdjSQL = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        costAdjSQL.append(this.getInsertBizDataSQL(tempTable));
        costAdjSQL.append(this.getBizCostAdjBillSelector()).append(NEWLINE);
        costAdjSQL.append("from T_CL_CostAdjustBillEntry et").append(NEWLINE);
        costAdjSQL.append("inner join T_CL_CostAdjustBill h on et.fparentid = h.fid").append(NEWLINE);
        costAdjSQL.append(billJoinStr);
        costAdjSQL.append(this.builderJoinForStoreTypeAndCS(params, "T_CL_CostAdjustBill", false));
        costAdjSQL.append(this.getBizBillDataWhereSQL(ctx, params, true, false)).append(NEWLINE);
        costAdjSQL.append(" and et.FStoreTypeID is not null ").append(NEWLINE);
        costAdjSQL.append("group by et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FStoreTypeID,");
        costAdjSQL.append("et.FWarehouseID,et.FLocationID,et.FMaterialID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,et.FCustomerID");
        return costAdjSQL.toString();
    }

    private String getInitMoveLocBillSQL(Context ctx, RptParams params, String orgTempTable) throws BOSException {
        StringBuffer moveLocSQL = new StringBuffer();
        java.util.Date dateFrom = (java.util.Date)params.getObject("dateFrom");
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        String sqlMoveWhere = this.buildParamWhereStr(ctx, params, false);
        moveLocSQL.append(this.getInsertInitDataSQL(tempTable));
        moveLocSQL.append("SELECT newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,et.FStoreTypeID,null as FStoreTypePreID,").append(NEWLINE);
        moveLocSQL.append("et.FSupplierID,et.FCustomerID,et.FWarehouseID,et.FReceiptLocationID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,").append(NEWLINE);
        moveLocSQL.append("SUM(et.FBaseQty) as FBeginQty,0 as FBeginAmt,SUM(et.FAssistQty ) as FBeginAssQty ").append(NEWLINE);
        moveLocSQL.append("from T_IM_MoveLocationBillEntry et").append(NEWLINE);
        moveLocSQL.append("inner join  T_IM_MoveLocationBill h on et.fparentid = h.fid").append(NEWLINE);
        moveLocSQL.append(billJoinStr.replaceAll("et.FLocationID", "et.FReceiptLocationID"));
        moveLocSQL.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_MoveLocationBill", false));
        moveLocSQL.append("where o.fisleaf = 1 ");
        moveLocSQL.append(sqlMoveWhere.replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(NEWLINE);
        moveLocSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append("and h.fbizdate >= o.fbegindate and h.fbizdate < to_date('");
        moveLocSQL.append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')").append(NEWLINE);
        moveLocSQL.append(" and et.FStoreTypeID is not null ").append(NEWLINE);
        moveLocSQL.append(this.getGroupBySQL(null).replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(";").append(NEWLINE);
        moveLocSQL.append(this.getInsertInitDataSQL(tempTable));
        moveLocSQL.append("SELECT newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,et.FStoreTypeID,null as FStoreTypePreID,").append(NEWLINE);
        moveLocSQL.append("et.FSupplierID,et.FCustomerID,et.FWarehouseID,et.FLocationID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,").append(NEWLINE);
        moveLocSQL.append("(-1) * SUM(et.FBaseQty) as FBeginQty,0 as FBeginAmt,(-1) * SUM(et.FAssistQty) as FBeginAssQty ").append(NEWLINE);
        moveLocSQL.append("from T_IM_MoveLocationBillEntry et").append(NEWLINE);
        moveLocSQL.append("inner join  T_IM_MoveLocationBill h on et.fparentid = h.fid").append(NEWLINE);
        moveLocSQL.append(billJoinStr);
        moveLocSQL.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_MoveLocationBill", false));
        moveLocSQL.append("where o.fisleaf = 1 ");
        moveLocSQL.append(sqlMoveWhere).append(NEWLINE);
        moveLocSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append("and h.fbizdate >= o.fbegindate and h.fbizdate < to_date('");
        moveLocSQL.append(IMRptUtils.getFilterBeginDate(dateFrom)).append("')").append(NEWLINE);
        moveLocSQL.append(" and et.FStoreTypeID is not null ").append(NEWLINE);
        moveLocSQL.append(this.getGroupBySQL(null));
        return moveLocSQL.toString();
    }

    private String getBizMoveLocSelector(boolean isMoveIn) {
        StringBuffer moveLocSelector = new StringBuffer();
        moveLocSelector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,").append("et.FStoreTypeID,null as FStoreTypePreID,et.FSupplierID,et.FCustomerID,").append("et.FWarehouseID,et.FLocationID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,").append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,");
        if (isMoveIn) {
            moveLocSelector.append("SUM( et.FBaseQty ) as FriInQty,").append("SUM( et.FAssistQty ) as FriInAssQty,").append("SUM( et.FAmount ) as FriInAmt,").append("0 as FriOutQty,").append("0 as FriOutAssQty,").append("0 as FriOutAmt ");
        } else {
            moveLocSelector.append("0 as FriInQty,").append("0 as FriInAssQty,").append("0 as FriInAmt,").append("SUM( et.FBaseQty ) as FriOutQty,").append("SUM( et.FAssistQty ) as FriOutAssQty,").append("SUM( et.FAmount ) as FriOutAmt ");
        }
        return moveLocSelector.toString();
    }

    private String getBizMoveLocBillSQL(Context ctx, RptParams params, String orgTempTable) throws BOSException {
        StringBuffer moveLocSQL = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        String sqlMoveWhere = this.buildParamWhereStr(ctx, params, false);
        moveLocSQL.append(this.getInsertBizDataSQL(tempTable));
        moveLocSQL.append(this.getBizMoveLocSelector(true).replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(NEWLINE);
        moveLocSQL.append("from T_IM_MoveLocationBillEntry et").append(NEWLINE);
        moveLocSQL.append("inner join T_IM_MoveLocationBill h on et.fparentid = h.fid").append(NEWLINE);
        moveLocSQL.append(billJoinStr.replaceAll("et.FLocationID", "et.FReceiptLocationID"));
        moveLocSQL.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_MoveLocationBill", false));
        moveLocSQL.append("where o.fisleaf = 1");
        moveLocSQL.append(sqlMoveWhere.replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(NEWLINE);
        moveLocSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append(" and et.FStoreTypeID is not null ").append(NEWLINE);
        moveLocSQL.append(this.getGroupBySQL(null).replaceAll("et.FLocationID", "et.FReceiptLocationID")).append(";").append(NEWLINE);
        moveLocSQL.append(this.getInsertBizDataSQL(tempTable));
        moveLocSQL.append(this.getBizMoveLocSelector(false)).append(NEWLINE);
        moveLocSQL.append("from T_IM_MoveLocationBillEntry et").append(NEWLINE);
        moveLocSQL.append("inner join T_IM_MoveLocationBill h on et.fparentid = h.fid").append(NEWLINE);
        moveLocSQL.append(billJoinStr);
        moveLocSQL.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_MoveLocationBill", false));
        moveLocSQL.append("where o.fisleaf = 1");
        moveLocSQL.append(sqlMoveWhere).append(NEWLINE);
        moveLocSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        moveLocSQL.append(" and et.FStoreTypeID is not null ").append(NEWLINE);
        moveLocSQL.append(this.getGroupBySQL(null));
        return moveLocSQL.toString();
    }

    private String getBizInvStateAdjustSelector() {
        StringBuffer invStateAdjustSelector = new StringBuffer();
        invStateAdjustSelector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,").append("et.FStoreTypeID,null as FStoreTypePreID,et.FSupplierID,et.FCustomerID,").append("et.FWarehouseID,et.FLocationID,et.FLot,FProjectId,FTrackNumberId,et.FAssistPropertyID,").append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,");
        invStateAdjustSelector.append("SUM( et.FBaseQty ) as FriInQty,").append("SUM( et.FAssistQty ) as FriInAssQty,").append("0 as FriInAmt,").append("SUM( et.FBaseQty ) as FriOutQty,").append("SUM( et.FAssistQty ) as FriOutAssQty,").append("0 as FriOutAmt ");
        return invStateAdjustSelector.toString();
    }

    private String getBizInvStateAdjustBillSQL(Context ctx, RptParams params, String orgTempTable) throws BOSException {
        StringBuffer invStateAdjustSQL = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        String sqlWhere = this.buildParamWhereStr(ctx, params, false);
        invStateAdjustSQL.append(this.getInsertBizDataSQL(tempTable));
        invStateAdjustSQL.append(this.getBizInvStateAdjustSelector()).append(NEWLINE);
        invStateAdjustSQL.append("from T_IM_InvstateAdjustBillEntry et").append(NEWLINE);
        invStateAdjustSQL.append("inner join T_IM_InvstateAdjustBill h on et.fparentid = h.fid").append(NEWLINE);
        invStateAdjustSQL.append(billJoinStr);
        invStateAdjustSQL.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_InvstateAdjustBill", false));
        invStateAdjustSQL.append("where o.fisleaf = 1");
        invStateAdjustSQL.append(sqlWhere).append(NEWLINE);
        invStateAdjustSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        invStateAdjustSQL.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        invStateAdjustSQL.append(" and et.FStoreTypeID is not null ").append(NEWLINE);
        invStateAdjustSQL.append(this.getGroupBySQL(null));
        return invStateAdjustSQL.toString();
    }

    private String getBizDecomposeSelector() {
        StringBuffer decomposeSelector = new StringBuffer();
        decomposeSelector.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,").append("et.FStoreTypeID,null as FStoreTypePreID,et.FSupplierID,et.FCustomerID,").append("et.FWarehouseID,et.FLocationID,et.FLot,FProjectId,FTrackNumberId,et.FAssistPropertyID,").append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,");
        decomposeSelector.append("SUM( et.FBaseQty ) as FriInQty,").append("SUM( et.FAssistQty ) as FriInAssQty,").append("0 as FriInAmt,").append("SUM( et.FBaseQty ) as FriOutQty,").append("SUM( et.FAssistQty ) as FriOutAssQty,").append("0 as FriOutAmt ");
        return decomposeSelector.toString();
    }

    private String getBizDecomposeBillSQL(Context ctx, RptParams params, String orgTempTable) throws BOSException {
        StringBuffer decomposeSQL = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        String sqlWhere = this.buildParamWhereStr(ctx, params, false);
        decomposeSQL.append(this.getInsertBizDataSQL(tempTable));
        decomposeSQL.append(this.getBizDecomposeSelector()).append(NEWLINE);
        decomposeSQL.append("from T_IM_DecomposeEntry et").append(NEWLINE);
        decomposeSQL.append("inner join T_IM_DecomposeBill h on et.fparentid = h.fid").append(NEWLINE);
        decomposeSQL.append(billJoinStr);
        decomposeSQL.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_DecomposeBill", false));
        decomposeSQL.append("where o.fisleaf = 1");
        decomposeSQL.append(sqlWhere).append(NEWLINE);
        decomposeSQL.append(this.getBillStatusWhereSQL(params)).append(NEWLINE);
        decomposeSQL.append(this.getBizBillDateWhereSQL(params)).append(NEWLINE);
        decomposeSQL.append(" and et.FStoreTypeID is not null ").append(NEWLINE);
        decomposeSQL.append(this.getGroupBySQL(null));
        return decomposeSQL.toString();
    }

    private void handleInitData(Context ctx, RptParams params, String orgTempTable, boolean isUpdateArBill) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        this.insertBeginDataForCombinTable(ctx, params, orgTempTable, this.getInsertInitDataSQL(tempTable));
        if (this.isFromAfterBeginDate(ctx, orgTempTable, params)) {
            String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
            int count = invTableName.length;
            String[] sqls = new String[count + 4];
            StringBuffer billBuff = new StringBuffer();
            boolean isHasST2 = true;
            for (int i = 0; i < count; ++i) {
                String table = invTableName[i][0];
                isHasST2 = true;
                if (table.equals("T_IM_PurInWarehsBill")) {
                    isHasST2 = false;
                }
                billBuff.setLength(0);
                billBuff.append(this.getInsertInitDataSQL(tempTable));
                billBuff.append(this.getInitDataSelectorSQL(table));
                billBuff.append("from ").append(invTableName[i][1]).append(" et ").append(NEWLINE);
                billBuff.append("inner join ").append(table).append(" h on et.fparentid = h.fid").append(NEWLINE);
                billBuff.append(billJoinStr);
                billBuff.append(this.builderJoinForStoreTypeAndCS(params, table, true));
                billBuff.append(this.getInitBillDataWhereSQL(ctx, params, false, isHasST2)).append(NEWLINE);
                billBuff.append(" and (st.fid is not null or st2.fid is not null) ");
                billBuff.append(this.getGroupBySQL(table)).append(NEWLINE).toString();
                sqls[i] = billBuff.toString();
            }
            sqls[count] = this.getInitCostAdjBillSQL(ctx, params, orgTempTable);
            if (((Boolean)params.getObject("ckBxShowLocation")).booleanValue()) {
                sqls[count + 1] = this.getInitMoveLocBillSQL(ctx, params, orgTempTable);
            }
            if (isUpdateArBill) {
                sqls[count + 2] = this.getInitOtherBillSQL(ctx, params, orgTempTable);
            }
            this.isSupplierTypeByPurInWarehs = true;
            sqls[count + 3] = this.getSupplierType4PurInwareBillSql(true, params, orgTempTable, ctx).toString();
            this.isSupplierTypeByPurInWarehs = false;
            this.executeBatchUpdate(ctx, sqls);
        }
    }

    private String getInitOtherBillSQL(Context ctx, RptParams params, String orgTempTable) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        StringBuffer otherBill = new StringBuffer();
        otherBill.append(this.getInsertInitDataSQL(tempTable));
        otherBill.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,").append(NEWLINE);
        otherBill.append("tr.FStoreTypeID as FStoreTypeID,null as FStoreTypePreID,'1',h.FCustomerID,et.FWarehouseID,et.FLocationID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,").append(NEWLINE);
        otherBill.append("(-1)*SUM(otherEntry.FBaseQty) as FBeginQty,(-1)*SUM(et.FActualCost) as FBeginAmt,(-1)*SUM(otherEntry.FAssistQty) as FBeginAssQty ").append(NEWLINE);
        otherBill.append("from T_AR_OtherBillEntry otherEntry ").append(NEWLINE);
        otherBill.append("inner join T_AR_OtherBill otherBill on otherBill.fid = otherEntry.fparentid ").append(NEWLINE);
        otherBill.append("inner join T_IM_SaleIssueEntry et on otherEntry.FSourceBillEntryID = et.fid ").append(NEWLINE);
        otherBill.append("inner join T_IM_SaleIssueBill h on h.fid = et.fparentid ").append(NEWLINE);
        otherBill.append("inner join T_SCM_TransactionType tr on tr.fid = h.FTransactionTypeID ").append(NEWLINE);
        otherBill.append("inner join T_SCM_BizType bizType on bizType.fid = otherBill.fbiztypeid ").append(NEWLINE);
        otherBill.append(billJoinStr);
        otherBill.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_SaleIssueBill", true));
        otherBill.append(this.getOtherBillWhereSQL(ctx, params, true)).append(NEWLINE);
        otherBill.append(" and tr.FStoreTypePreID is not null ").append(NEWLINE);
        otherBill.append(" and bizType.fid='d8e80652-0113-1000-e000-04c5c0a812202407435C' ");
        otherBill.append("group by et.FCompanyOrgUnitID,et.FStorageOrgUnitID,tr.FStoreTypeID,");
        otherBill.append("et.FWarehouseID,et.FLocationID,et.FMaterialID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,h.FCustomerID");
        return otherBill.toString();
    }

    private String getBizOtherBillSQL(Context ctx, RptParams params, String orgTempTable) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        StringBuffer otherBill = new StringBuffer();
        otherBill.append(this.getInsertBizDataSQL(tempTable));
        otherBill.append(this.getBizOtherBillSelector()).append(NEWLINE);
        otherBill.append("from T_AR_OtherBillEntry otherEntry ").append(NEWLINE);
        otherBill.append("inner join T_AR_OtherBill otherBill on otherBill.fid = otherEntry.fparentid ").append(NEWLINE);
        otherBill.append("inner join T_IM_SaleIssueEntry et on otherEntry.FSourceBillEntryID = et.fid ").append(NEWLINE);
        otherBill.append("inner join T_IM_SaleIssueBill h on h.fid = et.fparentid ").append(NEWLINE);
        otherBill.append("inner join T_SCM_TransactionType tr on tr.fid = h.FTransactionTypeID ").append(NEWLINE);
        otherBill.append("inner join T_SCM_BizType bizType on bizType.fid = otherBill.fbiztypeid ").append(NEWLINE);
        otherBill.append(billJoinStr);
        otherBill.append(this.builderJoinForStoreTypeAndCS(params, "T_IM_SaleIssueBill", true));
        otherBill.append(this.getOtherBillWhereSQL(ctx, params, false)).append(NEWLINE);
        otherBill.append(" and tr.FStoreTypePreID is not null ").append(NEWLINE);
        otherBill.append(" and bizType.fid='d8e80652-0113-1000-e000-04c5c0a812202407435C' ").append(NEWLINE);
        otherBill.append("group by et.FCompanyOrgUnitID,et.FStorageOrgUnitID,tr.FStoreTypeID,");
        otherBill.append("et.FWarehouseID,et.FLocationID,et.FMaterialID,et.FLot,et.FProjectId,et.FTrackNumberId,et.FAssistPropertyID,h.FCustomerID");
        return otherBill.toString();
    }

    private String getBizOtherBillSelector() {
        StringBuffer otherBillSelctor = new StringBuffer();
        otherBillSelctor.append("select newbosid('88888888'),-2 as FIndex,et.FCompanyOrgUnitID,et.FStorageOrgUnitID,et.FMaterialID,").append("tr.FStoreTypeID as FStoreTypeID,null as FStoreTypePreID,'1',h.FCustomerID,").append("et.FWarehouseID,et.FLocationID,et.FLot,et.FAssistPropertyID,").append("0 as FBeginQty,0 as FBeginAssQty,0 as FBeginAmt,").append("0 as FriInQty,0 as FriInAssQty,0 as FriInAmt,").append("SUM(otherEntry.fbaseqty) as FriOutQty,").append("SUM(otherEntry.fassistQty) as FriOutAssQty,").append("SUM(et.factualcost) as FriOutAmt ");
        return otherBillSelctor.toString();
    }

    private void handleBizData(Context ctx, RptParams params, String orgTempTable, boolean isUpdateArBill) throws BOSException, EASBizException {
        StringBuffer billBuff = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String billJoinStr = this.builderJoinSqlBuffer(orgTempTable, params, true);
        int count = invTableName.length;
        String[] sqls = new String[count + 6];
        boolean isHasST2 = true;
        boolean noSelectStorageMoveBill = false;
        boolean noSelectWarehouseMoveBill = false;
        noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        for (int i = 0; i < count; ++i) {
            String table = invTableName[i][0];
            billBuff.setLength(0);
            isHasST2 = true;
            if (table.equals("T_IM_PurInWarehsBill")) {
                isHasST2 = false;
            }
            billBuff.append(this.getInsertBizDataSQL(tempTable));
            billBuff.append(this.getBizBillDataSelectorSQL(table));
            billBuff.append("from ").append(invTableName[i][1]).append(" et ").append(NEWLINE);
            billBuff.append("inner join ").append(table).append(" h on et.fparentid = h.fid").append(NEWLINE);
            billBuff.append("inner join t_scm_transactiontype tr on tr.fid = h.ftransactiontypeid").append(NEWLINE);
            billBuff.append(billJoinStr);
            billBuff.append(this.builderJoinForStoreTypeAndCS(params, table, true));
            billBuff.append(this.getBizBillDataWhereSQL(ctx, params, false, isHasST2)).append(NEWLINE);
            if (table.equalsIgnoreCase("T_IM_MoveInWarehsBill") || table.equalsIgnoreCase("T_IM_MoveIssueBill")) {
                if (noSelectStorageMoveBill) {
                    billBuff.append("and h.FBizTypeID <>'d8e80652-011a-1000-e000-04c5c0a812202407435C' ");
                }
                if (noSelectWarehouseMoveBill) {
                    billBuff.append("and h.FBizTypeID <>'d8e80652-011b-1000-e000-04c5c0a812202407435C' ");
                }
            }
            billBuff.append(" and (st.fid is not null or st2.fid is not null) ").append(NEWLINE);
            billBuff.append(this.getGroupBySQL(table)).append(NEWLINE);
            sqls[i] = billBuff.toString();
        }
        sqls[count] = this.getBizCostAdjBillSQL(ctx, params, orgTempTable);
        if (((Boolean)params.getObject("ckBxShowLocation")).booleanValue()) {
            sqls[count + 1] = this.getBizMoveLocBillSQL(ctx, params, orgTempTable);
        }
        if (isUpdateArBill) {
            sqls[count + 2] = this.getBizOtherBillSQL(ctx, params, orgTempTable);
        }
        sqls[count + 3] = this.getBizInvStateAdjustBillSQL(ctx, params, orgTempTable);
        sqls[count + 4] = this.getBizDecomposeBillSQL(ctx, params, orgTempTable);
        this.isSupplierTypeByPurInWarehs = true;
        sqls[count + 5] = this.getSupplierType4PurInwareBillSql(false, params, orgTempTable, ctx).toString();
        this.isSupplierTypeByPurInWarehs = false;
        this.executeBatchUpdate(ctx, sqls);
    }

    private StringBuffer getSupplierType4PurInwareBillSql(boolean isHandleInitData, RptParams params, String orgTempTable, Context ctx) throws BOSException {
        String tempTable = params.getString("tempTable");
        String billTable = "T_IM_PurInWarehsBill";
        String entryTable = "T_IM_PurInWarehsEntry";
        StringBuffer billBuff = new StringBuffer();
        billBuff.append(this.getSupplierType4PurInWarehsInsertSQL(isHandleInitData, tempTable));
        billBuff.append(this.getSupplierType4PurInwareSelectorSQL(isHandleInitData));
        billBuff.append("from ").append(entryTable).append(" et ").append(NEWLINE);
        billBuff.append("inner join ").append(billTable).append(" h on et.fparentid = h.fid").append(NEWLINE);
        if (!isHandleInitData) {
            billBuff.append("inner join t_scm_transactiontype tr on tr.fid = h.ftransactiontypeid").append(NEWLINE);
        }
        billBuff.append(this.builderJoinSqlBuffer(orgTempTable, params, true));
        billBuff.append(this.builderJoinForStoreTypeAndCS(params, billTable, true));
        if (isHandleInitData) {
            billBuff.append(this.getInitBillDataWhereSQL(ctx, params, false, true)).append(NEWLINE);
        } else {
            billBuff.append(this.getBizBillDataWhereSQL(ctx, params, false, true)).append(NEWLINE);
        }
        billBuff.append(" and st2.fid is not null ").append(NEWLINE);
        billBuff.append(this.getGroupBySQL(billTable)).append("").append(NEWLINE);
        return billBuff;
    }

    private void updateAllData(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer updateSQL = new StringBuffer();
        if (!(RptParamSqlUtil.getObject(params, "supplierFrom") == null && params.getObject("supplierTo") == null || RptParamSqlUtil.getObject(params, "customerFrom") == null && params.getObject("customer") == null)) {
            updateSQL.append("delete from ").append(tempTable).append(";").append(NEWLINE);
        }
        if (RptParamSqlUtil.getObject(params, "supplierFrom") != null || params.getObject("supplierTo") != null) {
            updateSQL.append("delete from ").append(tempTable).append(" where FStoreTypeID in ");
            updateSQL.append("(select FID from T_IM_StoreType where FStoreFlag in (1,3,4))").append(";").append(NEWLINE);
        }
        if (RptParamSqlUtil.getObject(params, "customerFrom") != null || params.getObject("customerTo") != null) {
            updateSQL.append("delete from ").append(tempTable).append(" where FStoreTypeID in ");
            updateSQL.append("(select FID from T_IM_StoreType where FStoreFlag in (1,2,5))").append(";").append(NEWLINE);
        }
        updateSQL.append("update ").append(tempTable).append(" set FSupplierID = null, FCustomerID = null ");
        updateSQL.append("where FStoreTypeID in (select FID from T_IM_StoreType where FStoreFlag = 1)").append(";").append(NEWLINE);
        updateSQL.append("update ").append(tempTable).append(" set FCustomerID = null ");
        updateSQL.append("where FStoreTypeID in (select FID from T_IM_StoreType where FStoreFlag in (2,5))").append(";").append(NEWLINE);
        updateSQL.append("update ").append(tempTable).append(" set FSupplierID = null ");
        updateSQL.append("where FStoreTypeID in (select FID from T_IM_StoreType where FStoreFlag in (3,4))").append(";");
        this.executeBatchUpdate(ctx, updateSQL.toString().split(";"));
    }

    private String builderJoinSqlBuffer(String orgTempTable, RptParams params, boolean isJoinOrgTable) {
        String mgStandardID = ((MaterialGroupStandardInfo)params.getObject("materialGroupStandard")).getId().toString();
        StringBuilder billJoinBuff = new StringBuilder();
        if (isJoinOrgTable) {
            billJoinBuff.append("inner join ").append(orgTempTable).append(" o on et.fstorageorgunitid = o.fid and h.fstorageorgunitid = o.fid").append(NEWLINE);
        }
        Object materialTypeFrom = null;
        String materialTypeTo = null;
        if (params.getObject("materialTypeFrom") != null) {
            materialTypeFrom = params.getObject("materialTypeFrom");
        }
        if (params.getObject("materialTypeTo") != null) {
            materialTypeTo = ((MaterialGroupInfo)params.getObject("materialTypeTo")).getNumber();
        }
        if (materialTypeFrom != null || materialTypeTo != null || params.getObject("materialFrom") != null || params.getObject("materialTo") != null || params.getObject("shortNameFrom") != null && params.getObject("shortNameFrom").toString().length() > 0 || params.getObject("shortNameTo") != null && params.getObject("shortNameTo").toString().length() > 0 || !StringUtil.isEmpty((String)this.matpermSql) || mgStandardID != null) {
            billJoinBuff.append("inner join t_bd_material m on et.fmaterialid = m.fid ").append(NEWLINE);
            if (materialTypeFrom != null || materialTypeTo != null || mgStandardID != null) {
                billJoinBuff.append(" left join T_BD_MaterialGroupDetial as  MGD on MGD.FMaterialID = m.fid AND MGD.FMATERIALGROUPSTANDARDID = '").append(mgStandardID).append("'  ");
                billJoinBuff.append(" left join T_BD_MaterialGroup  g on g.FID = MGD.FMaterialGroupID  ");
            }
            if (!StringUtil.isEmpty((String)this.hMatPermJoinSql)) {
                billJoinBuff.append(this.hMatPermJoinSql);
            }
        }
        if (RptParamSqlUtil.getObject(params, "warehouseFrom") != null || params.getObject("warehouseTo") != null || !StringUtil.isEmpty((String)this.warepermSql)) {
            if (this.isSupplierTypeByPurInWarehs) {
                billJoinBuff.append("left join t_db_warehouse wh on et.foutwarehouseid = wh.fid ").append(NEWLINE);
            } else {
                billJoinBuff.append("left join t_db_warehouse wh on et.fwarehouseid = wh.fid ").append(NEWLINE);
            }
            if (!StringUtil.isEmpty((String)this.hWarePermJoinSql)) {
                billJoinBuff.append(this.hWarePermJoinSql);
            }
        }
        if (RptParamSqlUtil.getObject(params, "locationFrom") != null || params.getObject("locationTo") != null) {
            if (this.isSupplierTypeByPurInWarehs) {
                billJoinBuff.append("left join t_db_location lo on et.FOutLocationID = lo.fid").append(NEWLINE);
            } else {
                billJoinBuff.append("left join t_db_location lo on et.FLocationID = lo.fid ").append(NEWLINE);
            }
        }
        if (RptParamSqlUtil.getObject(params, "asstAttrFrom") != null || params.getObject("asstAttrTo") != null) {
            billJoinBuff.append("inner join t_bd_asstattrvalue asst on et.FAssistPropertyID = asst.fid ").append(NEWLINE);
        }
        if (RptParamSqlUtil.isNotBlank(params, "projectFrom").booleanValue() || !"".equals(params.getString("projectTo"))) {
            billJoinBuff.append("inner join T_MM_Project project on et.FProjectID = project.FID ").append("\r\n");
        }
        if (RptParamSqlUtil.isNotBlank(params, "trackNumFrom").booleanValue() || !"".equals(params.getString("trackNumTo"))) {
            billJoinBuff.append("inner join T_MM_TrackNumber track on et.FTrackNumberID = track.FID ").append("\r\n");
        }
        return billJoinBuff.toString();
    }

    private String builderJoinForStoreTypeAndCS(RptParams params, String tableName, boolean isHasInvUpdateType) {
        StringBuffer billJoinBuff = new StringBuffer();
        if (isHasInvUpdateType) {
            billJoinBuff.append("inner join T_IM_InvUpdateType ivt on ivt.fid = et.finvupdatetypeid");
            if (params.getBoolean("cbBxOnlyShowInventoryBill")) {
                billJoinBuff.append(" and ivt.FISNOTUPDATEINV = 0");
            }
            billJoinBuff.append(NEWLINE);
            billJoinBuff.append("left join t_im_storetype st on ivt.FStoreTypeID = st.fid ").append(NEWLINE);
            billJoinBuff.append("left join t_im_storetype st2 on ivt.FStoreTypePreID = st2.fid ").append(NEWLINE);
        } else {
            billJoinBuff.append("left join t_im_storetype st on et.fstoretypeid = st.fid ").append(NEWLINE);
        }
        if (RptParamSqlUtil.getObject(params, "supplierFrom") != null || params.getObject("supplierTo") != null) {
            if (invTableName[0][0].equals(tableName) || invTableName[4][0].equals(tableName) || "T_CL_CostAdjustBill".equals(tableName)) {
                billJoinBuff.append("left join t_bd_supplier su on h.fsupplierid = su.fid ");
            } else {
                billJoinBuff.append("left join t_bd_supplier su on et.fsupplierid = su.fid ").append(NEWLINE);
            }
        }
        if (RptParamSqlUtil.getObject(params, "customerFrom") != null || params.getObject("customerTo") != null) {
            if (invTableName[1][0].equals(tableName) || invTableName[4][0].equals(tableName)) {
                billJoinBuff.append("left join t_bd_customer cu on h.fcustomerid = cu.fid ").append(NEWLINE);
            } else {
                billJoinBuff.append("left join t_bd_customer cu on et.fcustomerid = cu.fid ").append(NEWLINE);
            }
        }
        return billJoinBuff.toString();
    }

    protected int[] executeBatchUpdate(Context ctx, String[] sqls) throws BOSException {
        int[] nArray;
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement();
            SQLThreadPool sqlExecute = new SQLThreadPool(ctx);
            int n = sqls.length;
            for (int i = 0; i < n; ++i) {
                if (sqls[i] == null) continue;
                ps.addBatch(sqls[i]);
                sqlExecute.addSQL(sqls[i]);
            }
            sqlExecute.startWorker();
            nArray = null;
        }
        catch (Exception e) {
            try {
                throw new BOSException("sqlBatch execute exception : ", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(con, ps);
                throw throwable;
            }
        }
        this.close(con, ps);
        return nArray;
    }

    private String getPeriodTypeId(Context ctx, String orgTempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct d.FAccountPeriodID from " + orgTempTable + " a ").append(" inner join T_ORG_UnitRelation b  on a.fid = b.ffromunitid").append(" inner join T_ORG_TypeRelation c  on b.FTypeRelationID = c.FID").append(" inner join t_org_company d on  b.ftounitid = d.fid ").append(" where c.FFromType = ").append(4).append(" and c.FToType = ").append(1);
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        String result = null;
        if (rs.next()) {
            result = rs.getString("FAccountPeriodID");
        }
        return result;
    }

    @Override
    protected RptRowSet _calFootRow(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(this.querySql(params));
        sql.append("where flevel = 1 and FStorageOrgName = 'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz'");
        sql.append(" order by FMaterialGroupNumber,FMaterialNumber,fwarehouseid,FLot,FAssistProperty,FId ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        return rs;
    }

    private void getPerm(Context ctx, RptParams params) throws BOSException {
        Set cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"inoutstoregatherreport_view");
        Object[] storageOrg = (Object[])params.getObject("fullStorageOrgUnit");
        Set orgUnitSets = InvServerUtils.getSelAuthorUnit(cuUnitSets, storageOrg);
        Map matpermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)orgUnitSets, (String)"bd_material_view", (String)"m", (String)"h");
        Map warepermRuleMap = PermissionUtil.getDataPermissionSQL((Context)ctx, (IObjectPK)ctx.getCaller(), (Set)orgUnitSets, (String)"warehous_view", (String)"wh", (String)"h");
        if (!CollectionUtil.isEmpty((Map)matpermRuleMap)) {
            this.hMatPermJoinSql = (String)matpermRuleMap.get("PERM_JOIN");
            this.matpermSql = (String)matpermRuleMap.get("PERM_WHERE");
            if (!StringUtil.isEmpty((String)this.matpermSql)) {
                this.matpermSql = " AND (" + this.matpermSql + ") ";
            }
        }
        if (!CollectionUtil.isEmpty((Map)warepermRuleMap)) {
            this.hWarePermJoinSql = (String)warepermRuleMap.get("PERM_JOIN");
            this.warepermSql = (String)warepermRuleMap.get("PERM_WHERE");
            if (!StringUtil.isEmpty((String)this.warepermSql)) {
                this.warepermSql = " AND (" + this.warepermSql + ") ";
            }
        }
    }

    class SQLThreadPool {
        private Vector sqls = new Vector();
        private int maxThreadCount = 0;
        private int currentThread = 0;
        private boolean isRunning = false;
        private Context ctx;

        public SQLThreadPool(Context ctx) {
            this.ctx = ctx;
        }

        public synchronized void addSQL(String sql) {
            if (!this.isRunning) {
                this.sqls.add(sql);
                this.addCurrentThreadCount();
            }
        }

        public synchronized int getMaxThreadCount() {
            return this.maxThreadCount;
        }

        public synchronized int getCurrentThread() {
            return this.currentThread;
        }

        public synchronized void subtract() {
            --this.maxThreadCount;
            --this.currentThread;
        }

        public synchronized void addMaxThreadCount() {
            ++this.maxThreadCount;
        }

        public synchronized void addCurrentThreadCount() {
            ++this.currentThread;
        }

        public void startWorker() {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
            for (String sql : this.sqls) {
                new ThreadWorker(sql, this.ctx).start();
            }
            while (this.getCurrentThread() > 0) {
            }
        }

        class ThreadWorker
        extends Thread {
            private String sql;
            private Context ctx;

            public ThreadWorker(String sql, Context ctx) {
                this.sql = sql;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                SQLThreadPool.this.addMaxThreadCount();
                try {
                    long beforeTime = System.currentTimeMillis();
                    InventoryTypeGatherReportFacadeControllerBean.this.executeUpdate(this.sql, null, this.ctx);
                    logger.info((Object)"-----------------------------------");
                    logger.info((Object)this.sql);
                    logger.info((Object)(" spend time is :" + (System.currentTimeMillis() - beforeTime) + "ms"));
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                finally {
                    SQLThreadPool.this.subtract();
                }
            }
        }
    }
}

