/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

public class MaterialReqRptServer
extends ReportServerBase {
    protected IRowSet getReportData(String arg0, RptParams params) throws Exception {
        String companyID = (String)params.getObject("companyPK");
        StringBuffer sqlwhere = new StringBuffer();
        Object[] storageOrgUnit = (Object[])params.getObject("fullOrgUnit");
        String BillStatus = (String)params.getObject("BillStatus");
        String StockNumber = (String)params.getObject("Stock");
        String materialNumFrom = (String)params.getObject("materialNumFrom");
        String materialNumTo = (String)params.getObject("materialNumTo");
        String SupplierFrom = (String)params.getObject("SupplierFrom");
        String SupplierTo = (String)params.getObject("SupplierTo");
        String YearFrom = (String)params.getObject("YearFrom");
        String YearTo = (String)params.getObject("YearTo");
        String PeriodFrom = (String)params.getObject("PeriodFrom");
        String PeriodTo = (String)params.getObject("PeriodTo");
        String bizDateFrom = (String)params.getObject("bizDateFrom");
        String bizDateTo = (String)params.getObject("bizDateTo");
        boolean PeriodType = params.getBoolean("PeriodType");
        sqlwhere.append("where ");
        StringBuffer storageOrgUnitStrList = new StringBuffer();
        if (storageOrgUnit != null && storageOrgUnit.length > 0) {
            int n = storageOrgUnit.length;
            for (int i = 0; i < n; ++i) {
                boolean fisleaf = (Boolean)((FullOrgUnitInfo)storageOrgUnit[i]).get("isleaf");
                if (!fisleaf) continue;
                storageOrgUnitStrList.append("'" + ((FullOrgUnitInfo)storageOrgUnit[i]).getNumber() + "'");
                storageOrgUnitStrList.append(",");
            }
        }
        if (!"".equals(storageOrgUnitStrList.toString())) {
            storageOrgUnitStrList.delete(storageOrgUnitStrList.length() - 1, storageOrgUnitStrList.length());
            sqlwhere.append("storage.fnumber in(" + storageOrgUnitStrList + ") and ");
        }
        if (BillStatus != null) {
            sqlwhere.append("v1.FBaseStatus =" + BillStatus + " and ");
        }
        if (StockNumber != null) {
            sqlwhere.append("warehouse.fNumber ='" + StockNumber + "' and ");
        }
        if (materialNumFrom != null) {
            sqlwhere.append("matr.FNumber >='" + materialNumFrom + "' and ");
        }
        if (materialNumTo != null) {
            sqlwhere.append("matr.FNumber <='" + materialNumTo + "' and ");
        }
        if (SupplierFrom != null) {
            sqlwhere.append("supp.FNumber>='" + SupplierFrom + "' and ");
        }
        if (SupplierTo != null) {
            sqlwhere.append("supp.FNumber<='" + SupplierTo + "' and ");
        }
        String sqllastDatewhere = sqlwhere.toString();
        String WriteOffBeginDate = "";
        String WriteOffBetweenDate = "";
        if (PeriodType) {
            WriteOffBeginDate = WriteOffBeginDate + this.buildWriteOffDate(bizDateFrom, bizDateTo, 1);
            WriteOffBetweenDate = WriteOffBetweenDate + this.buildWriteOffDate(bizDateFrom, bizDateTo, 0);
            sqllastDatewhere = sqllastDatewhere + this.buildPeriodDate(bizDateFrom, bizDateTo, 1);
            sqlwhere.append(this.buildPeriodDate(bizDateFrom, bizDateTo, 0));
        } else {
            WriteOffBeginDate = WriteOffBeginDate + this.buildWriteOffDate(YearFrom, YearTo, PeriodFrom, PeriodTo, 1);
            WriteOffBetweenDate = WriteOffBetweenDate + this.buildWriteOffDate(YearFrom, YearTo, PeriodFrom, PeriodTo, 0);
            sqllastDatewhere = sqllastDatewhere + this.buildPeriodDate(YearFrom, YearTo, PeriodFrom, PeriodTo, 1);
            sqlwhere.append(this.buildPeriodDate(YearFrom, YearTo, PeriodFrom, PeriodTo, 0));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE DataNew( \n");
        sql.append("FROWINDEX VARCHAR(50) DEFAULT(''),/*\u5355\u636e\u53f7\u7801*/ \n");
        sql.append("FBillNo VARCHAR(50) DEFAULT(''),/*\u5355\u636e\u53f7\u7801*/ \n");
        sql.append("FDate VARCHAR(255) DEFAULT(''),/*\u5355\u636e\u65e5\u671f*/ \n");
        sql.append("FSeq INT DEFAULT(0),/*\u5206\u5f55\u53f7*/ \n");
        sql.append("FStrOrgName VARCHAR(255) DEFAULT(''),//\u5e93\u5b58\u7ec4\u7ec7 \n");
        sql.append("FStrOrgNumber VARCHAR(255) DEFAULT(''), \n");
        sql.append("FSupplyNumber VARCHAR(255) DEFAULT(''),/*\u4f9b\u5e94\u5546\u7f16\u7801*/ \n");
        sql.append("FSupplyName VARCHAR(255) DEFAULT(''), \n");
        sql.append("FItemNumber VARCHAR(255) DEFAULT(''),/*\u7269\u6599\u53f7\u7801*/ \n");
        sql.append("FItemName VARCHAR(255) DEFAULT(''), \n");
        sql.append("FAuxPropName VARCHAR(255) DEFAULT(''),//--\u8f85\u52a9\u5c5e\u6027 \n");
        sql.append("FAuxPropNumber VARCHAR(255) DEFAULT(''), \n");
        sql.append("FModel VARCHAR(255) DEFAULT(''),/*\u89c4\u683c\u578b\u53f7*/ \n");
        sql.append("FStockName VARCHAR(255) DEFAULT(''),/*\u4ed3\u5e93*/ \n");
        sql.append("FBaseUnit VARCHAR(50) DEFAULT(''),/*\u57fa\u672c\u5355\u4f4d*/ \n");
        sql.append("FBaseBegQty DECIMAL(21,8) DEFAULT(0),/*\u671f\u521d\u6570\u91cf*/ \n");
        sql.append("FBaseUnitActualCost DECIMAL(21,8) DEFAULT(0),/*\u671f\u521d\u5355\u4f4d\u5b9e\u9645\u6210\u672c*/ \n");
        sql.append("FBegAmount DECIMAL(17,4) DEFAULT(0),/*\u671f\u521d\u91d1\u989d*/ \n");
        sql.append("FBaseQty DECIMAL(21,8) DEFAULT(0),/*\u53d1\u51fa\u6570\u91cf*/ \n");
        sql.append("FBasePrice DECIMAL(21,8) DEFAULT(0),/*\u5355\u4f4d\u5b9e\u9645\u6210\u672c*/ \n");
        sql.append("FAmount DECIMAL(17,4) DEFAULT(0),/*\u5b9e\u9645\u6210\u672c*/ \n");
        sql.append("FBaseCommitQty DECIMAL(21,8) DEFAULT(0),/*\u6838\u9500\u6570\u91cf*/ \n");
        sql.append("FWriteOffBasePrice DECIMAL(21,8) DEFAULT(0),/*\u6838\u9500\u5355\u4ef7*/ \n");
        sql.append("FCommitAmount DECIMAL(17,4) DEFAULT(0),/*\u6838\u9500\u91d1\u989d*/ \n");
        sql.append("FBalQty DECIMAL(21,8) DEFAULT(0),/*\u6838\u9500\u6570\u91cf*/ \n");
        sql.append("FBalAmt DECIMAL(17,4) DEFAULT(0),/*\u6838\u9500\u91d1\u989d*/ \n");
        sql.append("Fid VARCHAR(44) DEFAULT(''),/*\u5355\u636eID\uff0c\u7528\u4e8e\u8054\u67e5*/ \n");
        sql.append("FGroupSign int DEFAULT(-1),/* \u7528\u4e8e\u6392\u5e8f  \u5206\u7ec4 */ \n");
        sql.append("FMatQtyPrecision INT DEFAULT(0),/**/ \n");
        sql.append("FBPricePrecision INT DEFAULT(0),/**/ \n");
        sql.append("FAmountPrecision INT DEFAULT(0),/**/ \n");
        sql.append("FTypeEx INT DEFAULT(2) /*\u7528\u4e8e\u6392\u5e8f\uff1a0\uff1a\u671f\u521d2\uff1a\u5355\u636e3\uff1a\u6c47\u603b*/ \n");
        sql.append(") \n");
        String DataNew = "";
        DataNew = TempTablePool.getInstance((Context)this.getContext()).createTempTable(sql.toString());
        TempTablePool.getInstance((Context)this.getContext()).createTempTable(sql.toString());
        if (DataNew == null || DataNew.equals("")) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"160_MaterialReqRptServer", (Locale)this.getContext().getLocale()));
        }
        sql = new StringBuffer();
        sql.append("CREATE TABLE DataBal( \n");
        sql.append("FBillNo VARCHAR(50) DEFAULT(''),//--\u5355\u636e\u7f16\u53f7 \n");
        sql.append("FEntryID  VARCHAR(50) DEFAULT(''),//--\u5206\u5f55\u7f16\u53f7 \n");
        sql.append("FSeq INT DEFAULT(0),//\u5206\u5f55\u5e8f\u53f7 \n");
        sql.append("FDate VARCHAR(255) DEFAULT(''),//--\u5355\u636e\u65e5\u671f \n");
        sql.append("FStrOrgName VARCHAR(255) DEFAULT(''),//\u5e93\u5b58\u7ec4\u7ec7 \n");
        sql.append("FStrOrgNumber VARCHAR(255) DEFAULT(''), \n");
        sql.append("FSupplyNumber VARCHAR(255) DEFAULT(''),//--\u4f9b\u5e94\u5546 \n");
        sql.append("FSupplyName VARCHAR(255) DEFAULT(''), \n");
        sql.append("FItemNumber VARCHAR(255) DEFAULT(''),//--\u7269\u6599 \n");
        sql.append("FItemName VARCHAR(255) DEFAULT(''), \n");
        sql.append("FAuxPropName VARCHAR(255) DEFAULT(''),//--\u8f85\u52a9\u5c5e\u6027 \n");
        sql.append("FAuxPropNumber VARCHAR(255) DEFAULT(''), \n");
        sql.append("FModel VARCHAR(255) DEFAULT(''),//--\u578b\u53f7 \n");
        sql.append("FTypeEx INT DEFAULT(2),//--\u7528\u4e8e\u6392\u5e8f\uff1a0\uff1a\u671f\u521d2\uff1a\u5355\u636e3\uff1a\u6c47\u603b \n");
        sql.append("FStockName VARCHAR(255) DEFAULT(''),//--\u53d1\u6599\u4ed3\u5e93 \n");
        sql.append("FBaseUnit VARCHAR(50) DEFAULT(''),//--\u5355\u4f4d \n");
        sql.append("FBaseBegQty DECIMAL(21,8) DEFAULT(0),//--\u671f\u521d\u6570\u91cf \n");
        sql.append("FBaseUnitActualCost DECIMAL(21,8) DEFAULT(0), \n");
        sql.append("FBegAmount DECIMAL(17,4) DEFAULT(0),//--\u671f\u521d\u4f59\u989d \n");
        sql.append("FBaseQty DECIMAL(21,8) DEFAULT(0),//--\u5355\u636e\u6570\u91cf \n");
        sql.append("FBasePrice DECIMAL(21,8) DEFAULT(0), \n");
        sql.append("FAmount DECIMAL(17,4) DEFAULT(0), \n");
        sql.append("FBaseCommitQty DECIMAL(21,8) DEFAULT(0),//--\u6838\u9500\u6570\u91cf \n");
        sql.append("FCommitAmount DECIMAL(17,4) DEFAULT(0) \n");
        sql.append(") \n");
        String DataBal = "";
        DataBal = TempTablePool.getInstance((Context)this.getContext()).createTempTable(sql.toString());
        if (DataBal == null || DataBal.equals("")) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"160_MaterialReqRptServer", (Locale)this.getContext().getLocale()));
        }
        sql = new StringBuffer();
        sql.append(" Insert into " + DataBal + "(FBillNo,FDate,FEntryID,FSeq,FStrOrgNumber,FStrOrgName,FSupplyNumber,FSupplyName,FItemNumber,FItemName,FModel,FAuxPropNumber,FTypeEx,FBaseBegQty,FBaseUnitActualCost,FBegAmount) \n");
        sql.append(this.getBaseSelectSQL(sqllastDatewhere));
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        StringBuffer hexiaoSql = new StringBuffer();
        hexiaoSql.append(" select sum(FCurrWriteOffBaseQty) as FCurrWriteOffBaseQty, FBillEntryID from T_CL_DevolveWriteOffRecord v2 \n");
        hexiaoSql.append(" left join T_CL_DevolveWriteOffGroup writegroup on  v2.FparentId=writegroup.FID where  \n");
        hexiaoSql.append(" v2.FBillID in ( \n");
        hexiaoSql.append(this.getBaseSelectSQL("v1.Fid", sqllastDatewhere));
        hexiaoSql.append("group by v1.Fid ) \n");
        hexiaoSql.append("and  " + WriteOffBeginDate);
        hexiaoSql.append("group by v2.FBillEntryID  \n");
        sql = new StringBuffer();
        sql.append(" update " + DataBal + " \n");
        sql.append(" set (FBaseBegQty,FBegAmount)=(select " + DataBal + ".FBaseBegQty-t.FCurrWriteOffBaseQty, \n");
        sql.append(" case when " + DataBal + ".FBaseUnitActualCost=0 then 0 else (" + DataBal + ".FBaseBegQty-t.FCurrWriteOffBaseQty)*" + DataBal + ".FBaseUnitActualCost end \n");
        sql.append(" from (");
        sql.append(hexiaoSql);
        sql.append(") t  \n");
        sql.append(" where " + DataBal + ".FEntryID=t.FBillEntryID) \n");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Insert Into " + DataNew + " \n");
        sql.append(" (FROWINDEX,FStrOrgNumber,FStrOrgName,FSupplyNumber,FSupplyName,FItemNumber,FItemName,FModel,FAuxPropNumber,FTypeEx,FBaseBegQty,FBegAmount,FBaseUnitActualCost) \n");
        sql.append(" select NEWBOSID('D06006D0'),t.FStrOrgNumber,SUBSTRING(max(t.FStrOrgName),1,255),t.FSupplyNumber, \n");
        sql.append("SUBSTRING(max(t.FSupplyName),1,255),t.FItemNumber,SUBSTRING(max(t.FItemName),1,255),\n");
        sql.append("SUBSTRING(max(t.FModel),1,255),max(t.FAuxPropNumber),0,sum(t.FBaseBegQty),sum(t.FBegAmount), \n");
        sql.append(" case when sum(isnull(t.FBaseBegQty,0))=0 then 0 else to_decimal(to_decimal(sum(isnull(t.FBegAmount,0)),21,8)/to_decimal(sum(t.FBaseBegQty),21,8),21,8) end as f \n");
        sql.append(" from " + DataBal + " t \n");
        sql.append(" group by t.FStrOrgNumber,t.FSupplyNumber,t.FItemNumber \n");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Insert Into " + DataNew + "(FROWINDEX,FBillNo,FDate,FSeq,FSupplyNumber,FSupplyName,FItemNumber,FItemName,FModel,FAuxPropNumber,FAuxPropName,FStrOrgNumber, \n");
        sql.append(" FStrOrgName,FStockName,FBaseUnit,FBaseQty,FBasePrice,FAmount,FBaseCommitQty,FWriteOffBasePrice,FCommitAmount,FTypeEx,Fid) \n");
        sql.append(" select NEWBOSID('D06006D0'),v1.FNumber,to_char(max(v1.FBizDate),'yyyy-mm-dd'),0, \n");
        sql.append(" max(supp.FNumber),SUBSTRING(max(supp.FName_l2),1,255), \n");
        sql.append(" matr.FNumber,SUBSTRING(max(matr.FName_l2),1,255),SUBSTRING(max(matr.FModel),1,255), \n");
        sql.append(" aav.fnumber,SUBSTRING(max(aav.fname_l2),1,255), \n");
        sql.append(" max(storage.FNumber),SUBSTRING(max(storage.FName_l2),1,255), \n");
        sql.append(" SUBSTRING(warehouse.FName_l2,1,255), \n");
        sql.append(" SUBSTRING(max(measureunit.FName_l2),1,80), \n");
        sql.append(" sum(v2.fbaseqty),0 as FBasePrice,sum(v2.FActualCost), \n");
        sql.append(" 0 as FBaseCommitQty, 0 as FWrittenOffUnitActualCost, \n");
        sql.append(" 0 as FWrittenOffAmount,2,max(v1.fid) \n");
        sql.append(" from T_IM_MaterialReqBill v1  \n");
        sql.append(" inner join T_IM_MaterialReqBillEntry v2 ON v1.FID = v2.FParentID \n");
        sql.append(" inner join t_bd_Material matr on v2.FMaterialID=matr.FID \n");
        sql.append(" inner join t_bd_Supplier supp on v1.FSupplierID=supp.FID \n");
        sql.append(" inner join T_ORG_Storage storage on v2.FStorageOrgUnitID=storage.FID \n");
        sql.append(" left join T_DB_WAREHOUSE warehouse on v2.FWarehouseID=warehouse.FID \n");
        sql.append(" left join T_BD_MeasureUnit measureunit on v2.FBaseUnitID=measureunit.FID \n");
        sql.append(" LEFT JOIN T_BD_AsstAttrValue aav on v2.fassistpropertyid=aav.fid  \n");
        sql.append(sqlwhere);
        sql.append(" group by v1.FNumber,matr.FNumber,aav.fnumber,warehouse.FName_l2");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        hexiaoSql = new StringBuffer();
        hexiaoSql.append(this.getWriteoffData(sqlwhere.toString(), WriteOffBetweenDate));
        sql = new StringBuffer();
        sql.append(" update " + DataNew + " \n");
        sql.append(" set (FBaseCommitQty,FCommitAmount)=(select \n");
        sql.append("  VFCurrWriteOffBaseQty,VFWrittenOffAmount \n");
        sql.append(" from ( \n");
        sql.append(hexiaoSql);
        sql.append(" ) t\n");
        sql.append(" where \n");
        sql.append(" " + DataNew + ".FTYPEEX=2 and " + DataNew + ".FID=t.FbillID and " + DataNew + ".FItemNumber=t.FItemNumber and (" + DataNew + ".FAuxPropNumber= t.FAuxPropNumber or t.FAuxPropNumber is null ) and " + DataNew + ".FStockName =t.FStockName \n");
        sql.append(" )\n");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        hexiaoSql = new StringBuffer();
        hexiaoSql.append(this.getWriteoffData(sqllastDatewhere, WriteOffBetweenDate));
        sql = new StringBuffer();
        sql.append(" update " + DataNew + " \n");
        sql.append(" set (FBaseCommitQty,FCommitAmount)=(select \n");
        sql.append("  VFCurrWriteOffBaseQty,VFWrittenOffAmount  from ( select \n");
        sql.append("   t.FSupplyNumber,t.FItemNumber,t.FStrOrgNumber,\n");
        sql.append(" sum( VFCurrWriteOffBaseQty) as VFCurrWriteOffBaseQty,sum(VFWrittenOffAmount ) as VFWrittenOffAmount \n");
        sql.append(" from ( \n");
        sql.append(hexiaoSql);
        sql.append(" ) t\n");
        sql.append(" group by t.FSupplyNumber,t.FItemNumber,t.FStrOrgNumber \n");
        sql.append(" ) t2 \n");
        sql.append(" where \n");
        sql.append(" " + DataNew + ".FTYPEEX=0 and " + DataNew + ".FItemNumber=t2.FItemNumber and " + DataNew + ".FStrOrgNumber= t2.FStrOrgNumber  and " + DataNew + ".FSupplyNumber =t2.FSupplyNumber \n");
        sql.append(" )\n");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update " + DataNew + "  \n");
        sql.append(" set FBasePrice=FAmount/FBaseQty  \n");
        sql.append(" where (FTYPEEX=2 ) and FBaseQty is not null and FBaseQty!=0 \n");
        sql.append("  \n");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update " + DataNew + "  \n");
        sql.append(" set FWriteOffBasePrice=FCommitAmount/FBaseCommitQty \n");
        sql.append(" where (FTYPEEX=2  or FTYPEEX=0) and FBaseCommitQty is not null and FBaseCommitQty!=0 \n");
        sql.append("  \n");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Insert Into " + DataNew + "(FROWINDEX,FStrOrgNumber,FStrOrgName,FSupplyNumber,FSupplyName,FItemNumber,FItemName,FAuxPropNumber,FAuxPropName, \n");
        sql.append(" FBaseBegQty,FBegAmount, FBaseQty,FBasePrice,FAmount,FBaseCommitQty,FWriteOffBasePrice,FCommitAmount,FTypeEx) \n");
        sql.append(" select NEWBOSID('D06006D0'),t.FStrOrgNumber,'', \n");
        sql.append(" t.FSupplyNumber,'', \n");
        sql.append("  t.FItemNumber,'', \n");
        sql.append(" '','', \n");
        sql.append(" sum(FBaseBegQty),sum(FBegAmount),sum(FBaseQty),\n");
        sql.append("case when sum(isnull(FBaseQty,0))=0 then 0 else to_decimal(to_decimal(sum(isnull(FAmount,0)),21,8)/to_decimal(sum(FBaseQty),21,8),21,8) end ,sum(FAmount), \n");
        sql.append(" sum(FBaseCommitQty),case when sum(isnull(FBaseCommitQty,0))=0 then 0 else to_decimal(to_decimal(sum(isnull(FCommitAmount,0)),21,8)/to_decimal(sum(FBaseCommitQty),21,8),21,8) end,sum(FCommitAmount),3 \n");
        sql.append(" from " + DataNew + " \n");
        sql.append("t group by t.FStrOrgNumber,t.FSupplyNumber,t.FItemNumber \n");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" select FBillNo as F1,FDate as F2,FSeq as F3,FSupplyNumber as F4,FSupplyName as F5,FItemNumber as F6,FItemName as F7,FModel as F8,FAuxPropName as F9, \n");
        sql.append(" FStrOrgName as F10,FStockName as F11,FBaseUnit as F12,FBaseBegQty as F13,FBaseUnitActualCost as F14,FBegAmount as F15, \n");
        sql.append(" FBaseQty as F16,FBasePrice as F17,FAmount as F18,FBaseCommitQty as F19,FWriteOffBasePrice as F20,FCommitAmount as F21, \n");
        sql.append(" FBalQty as F22,FBalAmt as F23, \n");
        sql.append(" FStrOrgNumber ,FStrOrgName, \n");
        sql.append(" Fid as F24 ,FTypeEx,FRowIndex \n");
        sql.append(" from " + DataNew + " order by FStrOrgNumber,FSupplyNumber,FItemNumber, FTypeEx,FAuxPropNumber,FBillNo,FRowIndex \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        sql = new StringBuffer();
        StringBuffer tempHeji = new StringBuffer();
        boolean havingBegin = false;
        int group = 0;
        int index = 0;
        BigDecimal oldBalQty = SysConstant.BIGZERO;
        BigDecimal oldBalAmt = SysConstant.BIGZERO;
        BigDecimal BalQty = SysConstant.BIGZERO;
        BigDecimal bigZero = new BigDecimal("0E-8");
        Connection conn = null;
        Statement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            batchStatement = conn.createStatement();
            while (rs != null && rs.next()) {
                BigDecimal endAmt;
                ++index;
                int order = rs.getInt("FTypeEx");
                String rowIndex = rs.getString("FRowIndex");
                BigDecimal begQty = rs.getBigDecimal("F13") == null ? SysConstant.BIGZERO : rs.getBigDecimal("F13");
                BigDecimal midQty = rs.getBigDecimal("F16") == null ? SysConstant.BIGZERO : rs.getBigDecimal("F16");
                BigDecimal endQty = rs.getBigDecimal("F19") == null ? SysConstant.BIGZERO : rs.getBigDecimal("F19");
                BigDecimal begAmt = rs.getBigDecimal("F15") == null ? SysConstant.BIGZERO : rs.getBigDecimal("F15");
                BigDecimal midAmt = rs.getBigDecimal("F18") == null ? SysConstant.BIGZERO : rs.getBigDecimal("F18");
                BigDecimal bigDecimal = endAmt = rs.getBigDecimal("F21") == null ? SysConstant.BIGZERO : rs.getBigDecimal("F21");
                if (order == 0) {
                    havingBegin = true;
                    oldBalQty = SysConstant.BIGZERO;
                    oldBalAmt = SysConstant.BIGZERO;
                    BalQty = begQty.add(midQty).subtract(endQty);
                    if (BalQty.compareTo(bigZero) == 0) {
                        BalQty = SysConstant.BIGZERO;
                    }
                    sql.append(" update " + DataNew + " set FBalQty=" + BalQty + ",FBalAmt=" + begAmt.add(midAmt).subtract(endAmt) + ",FGroupSign=" + group + " where FRowIndex='" + rowIndex + "'; \n");
                    batchStatement.addBatch(sql.toString());
                    sql.setLength(0);
                    oldBalQty = begQty.add(midQty).subtract(endQty);
                    oldBalAmt = begAmt.add(midAmt).subtract(endAmt);
                } else if (order == 2) {
                    BalQty = oldBalQty.add(midQty).subtract(endQty);
                    if (BalQty.compareTo(bigZero) == 0) {
                        BalQty = SysConstant.BIGZERO;
                    }
                    sql.append(" update " + DataNew + " set FBalQty=" + BalQty + ",FBalAmt=" + oldBalAmt.add(midAmt).subtract(endAmt) + ",FGroupSign=" + group + " where FRowIndex='" + rowIndex + "'; \n");
                    batchStatement.addBatch(sql.toString());
                    sql.setLength(0);
                    oldBalQty = oldBalQty.add(midQty).subtract(endQty);
                    oldBalAmt = oldBalAmt.add(midAmt).subtract(endAmt);
                }
                if (!havingBegin) {
                    this.insertABeginRow(DataNew, rs.getString("FStrOrgNumber"), rs.getString("FStrOrgName"), rs.getString("F4"), rs.getString("F5"), rs.getString("F6"), rs.getString("F7"), group);
                    havingBegin = true;
                }
                if (order != 3) continue;
                BalQty = begQty.add(midQty).subtract(endQty);
                if (BalQty.compareTo(bigZero) == 0) {
                    BalQty = SysConstant.BIGZERO;
                }
                sql.append(" update " + DataNew + " set FBalQty=" + BalQty + ",FBalAmt=" + begAmt.add(midAmt).subtract(endAmt) + ",FGroupSign=" + group + " where FRowIndex='" + rowIndex + "'; \n");
                batchStatement.addBatch(sql.toString());
                batchStatement.addBatch(sql.toString());
                sql.setLength(0);
                oldBalQty = SysConstant.BIGZERO;
                oldBalAmt = SysConstant.BIGZERO;
                tempHeji.append(" update " + DataNew + " set FStrOrgNumber='',FSupplyNumber='',FItemNumber='',FItemName='" + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"175_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + "' where FRowIndex='" + rowIndex + "'; \n");
                batchStatement.addBatch(tempHeji.toString());
                tempHeji.setLength(0);
                ++group;
                havingBegin = false;
            }
            StringBuffer sbSQL = new StringBuffer();
            sbSQL.append(" UPDATE " + DataNew).append(" SET FMatQtyPrecision= \n").append(" (SELECT mmu.FqtyPrecision \n").append(" FROM t_bd_Material T3 \n").append("  INNER JOIN t_bd_multiMeasureUnit mmu on  T3.Fid=mmu.FMaterialID  ").append(" INNER JOIN t_bd_MeasureUnit T4 ON mmu.FMeasureUnitID = T4.FID and T3.FBaseUnit=T4.fid\n").append(" WHERE " + DataNew + ".FItemNumber=T3.Fnumber ) \n\n;");
            batchStatement.addBatch(sbSQL.toString());
            sbSQL.setLength(0);
            sbSQL.append(" UPDATE " + DataNew).append(" SET FBPricePrecision= \n").append(" (SELECT T3.FpricePrecision \n").append(" FROM t_bd_Material T3 \n").append(" WHERE " + DataNew + ".FItemNumber=T3.Fnumber );\n\n");
            batchStatement.addBatch(sbSQL.toString());
            sbSQL.setLength(0);
            if (storageOrgUnit != null && storageOrgUnit.length > 0) {
                int n = storageOrgUnit.length;
                for (int i = 0; i < n; ++i) {
                    boolean fisleaf = (Boolean)((FullOrgUnitInfo)storageOrgUnit[i]).get("isleaf");
                    if (!fisleaf) continue;
                    sbSQL.append("UPDATE ").append(DataNew).append(" SET (FAmountPrecision)= \n").append("\t(SELECT t1.FPrecision \n").append("\tFROM T_BD_Currency t1 \n").append("\tINNER JOIN T_ORG_Company t2 ON t2.FBaseCurrencyID = t1.FID \n").append("\tWHERE t2.FID='").append(((FullOrgUnitInfo)storageOrgUnit[i]).getId().toString()).append("'); \n");
                    batchStatement.addBatch(sbSQL.toString());
                    sbSQL.setLength(0);
                }
            }
            batchStatement.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        SQLUtils.cleanup((Connection)conn);
        if (!"".equalsIgnoreCase(tempHeji.toString()) && tempHeji.length() > 0) {
            DbUtil.execute((Context)this.getContext(), (String)tempHeji.toString());
            tempHeji = null;
        }
        sql = new StringBuffer();
        sql.append(" select FBillNo as F1,FDate as F2,FSeq as F3,FSupplyNumber as F4,FSupplyName as F5,FItemNumber as F6,FItemName as F7,FModel as F8,FAuxPropName as F9, \n");
        sql.append(" FStrOrgName as F10,FStockName as F11,FBaseUnit as F12,FBaseBegQty as F13,FBaseUnitActualCost as F14,FBegAmount as F15, \n");
        sql.append(" FBaseQty as F16,FBasePrice as F17,FAmount as F18,FBaseCommitQty as F19,FWriteOffBasePrice as F20,FCommitAmount as F21, \n");
        sql.append(" FBalQty as F22,FBalAmt as F23, \n");
        sql.append(" Fid,FTypeEx,FMatQtyPrecision,FBPricePrecision,FAmountPrecision \n");
        sql.append(" from " + DataNew + " order by FGroupSign, FStrOrgNumber,FSupplyNumber,FItemNumber,FTypeEx,FAuxPropNumber,FBillNo,FRowIndex  \n");
        IRowSet rs_end = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        return rs_end;
    }

    protected void insertABeginRow(String table, String FStrOrgNumber, String FStrOrgName, String FSupplyNumber, String FSupplyName, String FItemNumber, String FItemName, int group) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into " + table + "(FROWINDEX,FStrOrgNumber,FStrOrgName,FSupplyNumber,FSupplyName,FItemNumber,FItemName, FTypeEx,FGroupSign) \n");
        sql.append(" select NEWBOSID('D06006D0'),'" + FStrOrgNumber + "', '" + FStrOrgName + "', '" + FSupplyNumber + "', '" + FSupplyName + "', '" + FItemNumber + "', '" + FItemName + "', 0," + group + " ");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
    }

    protected ReportTitles getReportTitles(String arg0, RptParams arg1) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Object[] storageOrgUnit = (Object[])arg1.getObject("fullOrgUnit");
        String YearFrom = (String)arg1.getObject("YearFrom");
        String YearTo = (String)arg1.getObject("YearTo");
        String PeriodFrom = (String)arg1.getObject("PeriodFrom");
        String PeriodTo = (String)arg1.getObject("PeriodTo");
        String bizDateFrom = (String)arg1.getObject("bizDateFrom");
        String bizDateTo = (String)arg1.getObject("bizDateTo");
        boolean PeriodType = arg1.getBoolean("PeriodType");
        StringBuffer storageOrgUnitStrList = new StringBuffer();
        if (storageOrgUnit != null && storageOrgUnit.length > 0) {
            int n = storageOrgUnit.length;
            for (int i = 0; i < n; ++i) {
                boolean fisleaf = (Boolean)((FullOrgUnitInfo)storageOrgUnit[i]).get("isleaf");
                if (!fisleaf) continue;
                storageOrgUnitStrList.append(((FullOrgUnitInfo)storageOrgUnit[i]).getName(this.getContext().getLocale()));
                storageOrgUnitStrList.append(";");
            }
        }
        if (!"".equals(storageOrgUnitStrList.toString())) {
            storageOrgUnitStrList.delete(storageOrgUnitStrList.length() - 1, storageOrgUnitStrList.length());
        }
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"176_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + storageOrgUnitStrList.toString());
        if (PeriodType) {
            if (bizDateFrom != null && !bizDateFrom.equals("")) {
                bizDateFrom = bizDateFrom.substring(0, bizDateFrom.indexOf(" "));
            }
            if (bizDateTo != null && !bizDateTo.equals("")) {
                bizDateTo = bizDateTo.substring(0, bizDateTo.indexOf(" "));
            }
            if (bizDateFrom != null && !bizDateFrom.equals("") && bizDateTo != null && !bizDateTo.equals("")) {
                titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"177_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + bizDateFrom + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"177_MaterialReqRptServer_1", (Locale)this.getContext().getLocale()) + bizDateTo);
            } else {
                titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"178_MaterialReqRptServer", (Locale)this.getContext().getLocale()));
            }
        } else if (YearFrom != null && !YearFrom.equals("") && YearTo != null && !YearTo.equals("")) {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"179_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + YearFrom + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"182_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"183_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + PeriodFrom + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"184_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"180_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + YearTo + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"182_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"183_MaterialReqRptServer", (Locale)this.getContext().getLocale()) + PeriodTo + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"184_MaterialReqRptServer", (Locale)this.getContext().getLocale()));
        } else {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"181_MaterialReqRptServer", (Locale)this.getContext().getLocale()));
        }
        return titles;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions reportFormatConditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = Color.GREEN;
        Appearance b = new Appearance();
        b.backColor = Color.YELLOW;
        return reportFormatConditions;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        return super.getReportHeader(reportID, filter);
    }

    private StringBuffer buildPeriodDate(String bizDateFrom, String bizDateTo, int type) {
        StringBuffer sqldate = new StringBuffer();
        if (type == 0) {
            if (bizDateFrom != null && bizDateFrom.trim().length() > 0) {
                sqldate.append("v1.FbizDate>=To_Date('" + bizDateFrom + "') and ");
            }
            if (bizDateTo != null && bizDateTo.trim().length() > 0) {
                sqldate.append("v1.FbizDate<=To_Date('" + bizDateTo + "') ");
            }
        } else if (type == 1) {
            sqldate.append("v1.FbizDate<To_Date('" + bizDateFrom + "')  ");
        }
        return sqldate;
    }

    private StringBuffer buildPeriodDate(String YearFrom, String YearTo, String PeriodFrom, String PeriodTo, int type) {
        StringBuffer sqldate = new StringBuffer();
        if (type == 0) {
            if (YearFrom != null && YearFrom.trim().length() > 0 && PeriodFrom != null && PeriodFrom.trim().length() > 0) {
                sqldate.append("( FYear>'" + YearFrom + "' or ");
                sqldate.append("( FYear='" + YearFrom + "' and ");
                sqldate.append("FPeriod>='" + PeriodFrom + "' )) and ");
            }
            if (YearTo != null && YearTo.trim().length() > 0 && PeriodTo != null && PeriodTo.trim().length() > 0) {
                sqldate.append("( FYear<'" + YearTo + "' or ");
                sqldate.append("( FYear='" + YearTo + "' and ");
                sqldate.append("FPeriod<='" + PeriodTo + "' )) ");
            }
        } else if (type == 1 && YearFrom != null && YearFrom.trim().length() > 0 && PeriodFrom != null && PeriodFrom.trim().length() > 0) {
            sqldate.append("( FYear<'" + YearFrom + "' or ");
            sqldate.append("( FYear='" + YearFrom + "' and ");
            sqldate.append("FPeriod<'" + PeriodFrom + "' )) ");
        }
        return sqldate;
    }

    private StringBuffer buildWriteOffDate(String bizDateFrom, String bizDateTo, int type) {
        return this.buildWriteOffDate(bizDateFrom, bizDateTo, type, "writegroup");
    }

    private StringBuffer buildWriteOffDate(String bizDateFrom, String bizDateTo, int type, String alis) {
        StringBuffer sqldate = new StringBuffer();
        if (type == 0) {
            if (bizDateFrom != null && bizDateFrom.trim().length() > 0) {
                sqldate.append(alis + ".FWriteOffDate>=To_Date('" + bizDateFrom + "') and ");
            }
            if (bizDateTo != null && bizDateTo.trim().length() > 0) {
                sqldate.append(alis + ".FWriteOffDate<=To_Date('" + bizDateTo + "') ");
            }
        } else if (type == 1) {
            sqldate.append(alis + ".FWriteOffDate<To_Date('" + bizDateFrom + "')  ");
        }
        return sqldate;
    }

    private StringBuffer buildWriteOffDate(String YearFrom, String YearTo, String PeriodFrom, String PeriodTo, int type) {
        return this.buildWriteOffDate(YearFrom, YearTo, PeriodFrom, PeriodTo, type, "writegroup");
    }

    private StringBuffer buildWriteOffDate(String YearFrom, String YearTo, String PeriodFrom, String PeriodTo, int type, String alis) {
        StringBuffer sqlwhere = new StringBuffer();
        if (type == 0) {
            if (YearFrom != null && YearFrom.trim().length() > 0 && PeriodFrom != null && PeriodFrom.trim().length() > 0) {
                sqlwhere.append("( " + alis + ".FWriteOffYear>'" + YearFrom + "' or ");
                sqlwhere.append("( " + alis + ".FWriteOffYear='" + YearFrom + "' and ");
                sqlwhere.append(alis + ".FWriteOffPeriod>='" + PeriodFrom + "' )) and ");
            }
            if (YearTo != null && YearTo.trim().length() > 0 && PeriodTo != null && PeriodTo.trim().length() > 0) {
                sqlwhere.append("( " + alis + ".FWriteOffYear<'" + YearTo + "' or ");
                sqlwhere.append("( " + alis + ".FWriteOffYear='" + YearTo + "' and ");
                sqlwhere.append(alis + ".FWriteOffPeriod<='" + PeriodTo + "' )) ");
            }
        } else if (type == 1 && YearFrom != null && YearFrom.trim().length() > 0 && PeriodFrom != null && PeriodFrom.trim().length() > 0) {
            sqlwhere.append("( " + alis + ".FWriteOffYear<'" + YearFrom + "' or ");
            sqlwhere.append("( " + alis + ".FWriteOffYear='" + YearFrom + "' and ");
            sqlwhere.append(alis + ".FWriteOffPeriod<'" + PeriodFrom + "' )) ");
        }
        return sqlwhere;
    }

    protected StringBuffer getBaseSelectSQL(String sqlwhere) {
        return this.getBaseSelectSQL(null, sqlwhere);
    }

    protected StringBuffer getBaseSelectSQL(String selectorItem, String sqlwhere) {
        return this.getBaseSelectSQL(selectorItem, sqlwhere, null);
    }

    protected StringBuffer getBaseSelectSQL(String selectorItem, String sqlwhere, String appendstr) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select \n");
        if (selectorItem == null || "".equalsIgnoreCase(selectorItem)) {
            sql.append(" v1.FNumber,v1.FBizDate,v2.Fid,v2.FSeq, \n");
            sql.append(" storage.fnumber,SUBSTRING(storage.FName_l2,1,255),supp.FNumber,SUBSTRING(supp.FName_l2,1,255), \n");
            sql.append(" matr.FNumber,SUBSTRING(matr.FName_l2,1,255),SUBSTRING(matr.FModel,1,255),aav.fnumber, \n");
            sql.append(" 0,v2.fbaseqty,\n");
            sql.append(" case when v2.FbaseQTY =0 then 0 else v2.FActualCost/v2.FbaseQTY end  ,\n");
            sql.append(" v2.FActualCost \n");
        } else {
            sql.append(selectorItem);
            sql.append("  \n");
        }
        sql.append(" from T_IM_MaterialReqBill v1  \n");
        sql.append(" inner join T_IM_MaterialReqBillEntry v2 ON v1.FID = v2.FParentID \n");
        if (appendstr != null && appendstr.length() > 0) {
            sql.append(appendstr);
            sql.append(" \n");
        }
        sql.append(" inner join t_bd_Material matr on v2.FMaterialID=matr.FID \n");
        sql.append(" inner join t_bd_Supplier supp on v1.FSupplierID=supp.FID \n");
        sql.append(" inner join T_ORG_Storage storage on v2.FStorageOrgUnitID=storage.FID \n");
        sql.append(" left join T_DB_WAREHOUSE warehouse on v2.FWarehouseID=warehouse.FID \n");
        sql.append(" left join T_BD_MeasureUnit measureunit on v2.FBaseUnitID=measureunit.FID \n");
        sql.append(" LEFT JOIN T_BD_AsstAttrValue aav on v2.fassistpropertyid=aav.fid \n");
        sql.append(sqlwhere);
        return sql;
    }

    protected StringBuffer getWriteoffData(String bodySQLwhere, String writeWhere) {
        StringBuffer hexiaoSql = new StringBuffer();
        hexiaoSql.append("select \n");
        hexiaoSql.append("  v1.FbillID,supp.FNumber as FSupplyNumber,matr.FNumber as FItemNumber,storage.FNumber as FStrOrgNumber,aav.fnumber as FAuxPropNumber,SUBSTRING(warehouse.FName_l2,1,255)  as FStockName \n");
        hexiaoSql.append(",sum(v1.FCurrWriteOffBaseQty) as VFCurrWriteOffBaseQty \n");
        hexiaoSql.append(",case when sum(v2.FbaseQTY)=0 then 0 else sum(v1.FCurrWriteOffBaseQty*(v2.FActualCost/v2.FbaseQTY)) end as VFWrittenOffAmount \n");
        hexiaoSql.append("from T_CL_DevolveWriteOffRecord v1 \n");
        hexiaoSql.append(" left join T_CL_DevolveWriteOffGroup writegroup on v1.FparentId=writegroup.FID  \n");
        hexiaoSql.append(" left join T_IM_MaterialReqBillEntry v2 ON v1.FBillEntryID = v2.FID  \n");
        hexiaoSql.append(" inner join T_IM_MaterialReqBill v3 ON v3.FID = v2.FParentID  \n");
        hexiaoSql.append(" inner join t_bd_Supplier supp on v3.FSupplierID=supp.FID  \n");
        hexiaoSql.append(" inner join T_ORG_Storage storage on v2.FStorageOrgUnitID=storage.FID  \n");
        hexiaoSql.append(" inner join t_bd_Material matr on v1.FMaterialID=matr.FID  \n");
        hexiaoSql.append(" left join T_DB_WAREHOUSE warehouse on v2.FWarehouseID=warehouse.FID  \n");
        hexiaoSql.append(" left join T_BD_MeasureUnit measureunit on v2.FBaseUnitID=measureunit.FID  \n");
        hexiaoSql.append(" LEFT JOIN T_BD_AsstAttrValue aav on v2.fassistpropertyid=aav.fid   \n");
        hexiaoSql.append(" where \n");
        hexiaoSql.append("v1.FBillID in ( \n");
        hexiaoSql.append(this.getBaseSelectSQL("v1.Fid", bodySQLwhere));
        hexiaoSql.append("\tgroup by v1.Fid \n");
        hexiaoSql.append(") and   " + writeWhere + " \n");
        hexiaoSql.append("group by  v1.FbillID,supp.FNumber,matr.FNumber,aav.fnumber,warehouse.FName_l2,storage.FNumber  \n");
        return hexiaoSql;
    }
}

