/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.NSRMBizException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.nsrm.app.util.SyncStatusUpdateUtil;
import com.kingdee.eas.scm.nsrm.constant.SyncStatusConstants;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayRequestDeleteSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PayRequestDeleteSend.class);
    private PayRequestBillCollection oldBillCol = null;
    private PayRequestBillCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entries");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        FilterInfo filter = ev.getFilter();
        ev.setFilter(filter);
        try {
            this.oldBillCol = (PayRequestBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPayRequestBillCollection(ev);
            this.oldBillCol = this.getNewBillCol(ctx, this.oldBillCol);
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@PayRequestDeleteSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@PayRequestDeleteSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            logger.debug((Object)"@@@@PayRequestDeleteSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    private PayRequestBillCollection getNewBillCol(Context ctx, PayRequestBillCollection oldBillCol2) {
        PayRequestBillCollection newPayCol = new PayRequestBillCollection();
        PayRequestBillInfo payRequestBillInfo = new PayRequestBillInfo();
        for (int i = 0; i < oldBillCol2.size(); ++i) {
            String supplierID;
            PayRequestBillInfo info = oldBillCol2.get(i);
            BigDecimal exchangeRate = info.getExchange_rate();
            HashSet<String> supplierNumberSet = new HashSet<String>();
            HashMap<String, String> supplierMap = new HashMap<String, String>();
            for (int j = 0; j < info.getEntries().size(); ++j) {
                PayRequestBillEntryInfo entryInfo = (PayRequestBillEntryInfo)info.getEntries().getObject(j);
                payRequestBillInfo.getEntries().addObject((IObjectValue)entryInfo);
                if (!"T_BD_Supplier".equals(entryInfo.getAsstActType().getRealtionDataObject())) continue;
                String supplierNumber = entryInfo.getAsstActNumber();
                supplierID = entryInfo.getAsstActID();
                supplierNumberSet.add(supplierNumber);
                supplierMap.put(supplierNumber, supplierID);
            }
            for (String key : supplierNumberSet) {
                PayRequestBillInfo newInfo = info;
                newInfo.getEntries().clear();
                for (int j = 0; j < payRequestBillInfo.getEntries().size(); ++j) {
                    String supplierNumber;
                    PayRequestBillEntryInfo entryInfo = (PayRequestBillEntryInfo)payRequestBillInfo.getEntries().getObject(j);
                    if (!"T_BD_Supplier".equals(entryInfo.getAsstActType().getRealtionDataObject()) || !key.equals(supplierNumber = entryInfo.getAsstActNumber())) continue;
                    BigDecimal reqPayAmount = entryInfo.getReqPayAmount();
                    BigDecimal auditAmount = entryInfo.getReqPayAmount();
                    reqPayAmount = reqPayAmount.multiply(exchangeRate);
                    auditAmount = auditAmount.multiply(exchangeRate);
                    entryInfo.put("reqPayAmount", (Object)reqPayAmount);
                    entryInfo.put("auditAmount", (Object)auditAmount);
                    entryInfo.put("apAmount", (Object)auditAmount);
                    newInfo.getEntries().addObject((IObjectValue)entryInfo);
                }
                newInfo.setNumber(newInfo.getNumber().toString() + "_" + key);
                supplierID = (String)supplierMap.get(key);
                newInfo.put("supplier", (Object)key);
                newInfo.put("supplierID", (Object)supplierID);
                newPayCol.add(newInfo);
            }
        }
        return newPayCol;
    }

    public void checkData(Context ctx) throws Exception {
        PayRequestBillInfo purInfo = null;
        PayRequestBillEntryInfo entry = null;
        String supplierID = null;
        this.newBillCol = new PayRequestBillCollection();
        HashSet<String> oldSupplierIdSet = new HashSet<String>();
        Set<String> newSupplierIdSet = null;
        HashSet<String> orderSet = new HashSet<String>();
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            logger.debug((Object)"@@@@PayRequestDeleteSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        int size = this.oldBillCol.size();
        for (int i = 0; i < size; ++i) {
            purInfo = this.oldBillCol.get(i);
            if (purInfo.get("supplierID") != null) {
                supplierID = purInfo.get("supplierID").toString();
                oldSupplierIdSet.add(supplierID);
            }
            for (int j = 0; j < purInfo.getEntrys().size(); ++j) {
                if (null == purInfo.getEntrys().get(j).getCoreBillNumber()) continue;
                orderSet.add(purInfo.getEntrys().get(j).getCoreBillNumber());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("srmProgress"));
        sic.add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("number", orderSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurOrderCollection purOrderCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(evi);
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        for (int i = 0; i < purOrderCollection.size(); ++i) {
            orderMap.put(purOrderCollection.get(i).getNumber(), purOrderCollection.get(i).get("srmProgress"));
        }
        if (oldSupplierIdSet == null || oldSupplierIdSet.size() <= 0) {
            logger.debug((Object)"@@@@PayRequestDeleteSend.checkData():\u6ca1\u6709\u534f\u540c\u4f9b\u5e94\u5546\u7684\u5355\u636e\u96c6\u5408.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        newSupplierIdSet = JudgeSupplierIsSrmUtil.getSupplierIsSrm(ctx, oldSupplierIdSet);
        if (newSupplierIdSet == null || newSupplierIdSet.size() <= 0) {
            logger.debug((Object)"@@@@PayRequestDeleteSend.checkData():\u6ca1\u6709\u534f\u540c\u4f9b\u5e94\u5546\u7684\u5355\u636e\u96c6\u5408.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM003", cu);
        int size2 = this.oldBillCol.size();
        for (int i = 0; i < size2; ++i) {
            purInfo = this.oldBillCol.get(i);
            boolean issync = true;
            for (int j = 0; j < purInfo.getEntrys().size(); ++j) {
                Object srmPorgress;
                entry = purInfo.getEntrys().get(j);
                if (null == entry.getCoreBillNumber() || null != (srmPorgress = orderMap.get(entry.getCoreBillNumber())) && !"0".equals(srmPorgress) && !"3".equals(srmPorgress)) continue;
                issync = false;
                break;
            }
            if (purInfo.get("supplierID") == null || !newSupplierIdSet.contains(supplierID = purInfo.get("supplierID").toString()) || (!"0".equals(paramValue) || !issync) && !"1".equals(paramValue)) continue;
            this.newBillCol.add(purInfo);
        }
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            return null;
        }
        if (data instanceof Map) {
            Map retMap = (Map)data;
            String returnData = ConvertUtil.convertObj2Str(retMap.get("data"));
            if (returnData == null) {
                throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
            }
            Map dataMap = null;
            try {
                dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)returnData, Map.class);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            if (!"200".equals(dataMap.get("code"))) {
                throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
            }
        } else {
            throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
        }
        SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, SyncStatusConstants.NULL_STATUS, "T_AP_payrequestbill");
        return null;
    }
}

