/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarFactory;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONArray;
import org.apache.log4j.Logger;

public class ProjectHandSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(ProjectHandSend.class);
    private ProjectCollection oldBillCol = null;
    private ProjectCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entries");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        ProjectCarInfo info;
        int i;
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        try {
            this.oldBillCol = (ProjectCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getProjectCollection(ev);
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@ProjectHandSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@ProjectHandSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            logger.debug((Object)"@@@@ProjectHandSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.oldBillCol.size(); ++i2) {
            ProjectInfo info2 = this.oldBillCol.get(i2);
            idSet.add(info2.getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)((Object)idSet).toString(), CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        ProjectCarCollection projectCarCollection = ProjectCarFactory.getLocalInstance((Context)ctx).getProjectCarCollection(evi);
        HashMap projectMap = new HashMap();
        for (i = 0; i < projectCarCollection.size(); ++i) {
            info = projectCarCollection.get(i);
            String number = info.getTrackNumber().getNumber();
            if (projectMap.get(info.getProject().getNumber()) == null) {
                HashSet<String> set = new HashSet<String>();
                set.add(number);
                projectMap.put(info.getProject().getNumber(), set);
                continue;
            }
            ((Set)projectMap.get(info.getProject().getNumber())).add(number);
        }
        for (i = 0; i < this.oldBillCol.size(); ++i) {
            info = this.oldBillCol.get(i);
            Set numberSet = (Set)projectMap.get(info.getNumber());
            JSONArray json = JSONArray.fromObject((Object)numberSet);
            info.put("tracks", (Object)json.toString());
        }
    }

    public void checkData(Context ctx) throws Exception {
        this.newBillCol = this.oldBillCol;
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        return null;
    }
}

