/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmAttachmentUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmProgressUpdateUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.nsrm.util.ExceptionHelper;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurOrderAuditSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PurOrderAuditSend.class);
    private PurOrderCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entries");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = JudgeSupplierIsSrmUtil.getIsSrmFilterEVI(pks, null);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isSysBill", (Object)0, CompareType.EQUALS));
        ev.getFilter().mergeFilter(filter, "AND");
        this.newBillCol = (PurOrderCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurOrderCollection(ev);
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            logger.debug((Object)"@@@@PurOrderAuditSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    public void checkData(Context ctx) throws Exception {
        PurOrderInfo billInfoForAttach = null;
        for (int i = 0; i < this.newBillCol.size(); ++i) {
            billInfoForAttach = this.newBillCol.get(i);
            SrmAttachmentUtil.setAttachmentsForBill(ctx, (CoreBillBaseInfo)billInfoForAttach);
        }
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        logger.debug((Object)"@@@@PurOrderAuditSend.handleBizResult():\u65b9\u6cd5\u5f00\u59cb................");
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.newBillCol.size(); ++i) {
        }
        if (data instanceof Map) {
            Map retMap = (Map)data;
            String returnData = ConvertUtil.convertObj2Str(retMap.get("data"));
            if (returnData == null) {
                SrmProgressUpdateUtil.updateExecuteStatusForCol(ctx, (IObjectCollection)this.newBillCol, "0");
                SrmLoggerHelper.setErrorMsg(this.srmLogInfo, "PurOrderAuditSend.handleBizResult()\u65b9\u6cd5:\u8fd4\u56de\u503c\u6570\u636ereturnData\u4e3a\u7a7a!");
                return null;
            }
            Map dataMap = null;
            try {
                dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)returnData, Map.class);
            }
            catch (Exception e) {
                SrmProgressUpdateUtil.updateExecuteStatusForCol(ctx, (IObjectCollection)this.newBillCol, "0");
                logger.error((Object)("@@@@PurOrderAuditSend.handleBizResult(),errorMsg:" + ExceptionHelper.toString(e)));
                SrmLoggerHelper.setMsgAndException(this.srmLogInfo, e);
                return null;
            }
            if (!"200".equals(dataMap.get("code"))) {
                SrmProgressUpdateUtil.updateExecuteStatusForCol(ctx, (IObjectCollection)this.newBillCol, "0");
                SrmLoggerHelper.setErrorMsg(this.srmLogInfo, "PurOrderAuditSend.handleBizResult()\u65b9\u6cd5:\u8fd4\u56de\u6570\u636ecode\u4e0d\u7b49\u4e8eCODE_SUCCESS\u7684\u503c!");
                return null;
            }
            PurOrderCollection oldBillCol = (PurOrderCollection)this.newBillCol.clone();
            PurOrderCollection jdBillCol = new PurOrderCollection();
            PurOrderInfo oldInfo = null;
            for (int i = 0; i < oldBillCol.size(); ++i) {
                oldInfo = oldBillCol.get(i);
                if (!"2".equals(oldInfo.getString("srctype"))) continue;
                jdBillCol.add(oldInfo);
                this.newBillCol.remove(oldInfo);
            }
            if (jdBillCol.size() > 0) {
                SrmProgressUpdateUtil.updateExecuteStatusForCol(ctx, (IObjectCollection)jdBillCol, "6");
            }
            Map Id_logstatusMap = (Map)dataMap.get("logstatus");
            HashMap<String, String> newBillMap = new HashMap<String, String>();
            if (null != Id_logstatusMap) {
                for (int i = 0; i < this.newBillCol.size(); ++i) {
                    PurOrderInfo info = this.newBillCol.get(i);
                    String srmProgress = SrmProgressUpdateUtil.getsrmProgress((String)Id_logstatusMap.get(info.getNumber().toString()));
                    if (srmProgress == null) {
                        srmProgress = "1";
                    }
                    newBillMap.put(info.getId().toString(), srmProgress);
                }
                SrmProgressUpdateUtil.updateSrmProgressForMap(ctx, newBillMap);
            }
            if (this.newBillCol.size() > 0 && null == Id_logstatusMap) {
                SrmProgressUpdateUtil.updateExecuteStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1");
            }
            SrmProgressUpdateUtil.updateStatusByQty(ctx, this.newBillCol, false);
        } else {
            SrmProgressUpdateUtil.updateExecuteStatusForCol(ctx, (IObjectCollection)this.newBillCol, "0");
            SrmLoggerHelper.setErrorMsg(this.srmLogInfo, "PurOrderAuditSend.handleBizResult()\u65b9\u6cd5:\u8fd4\u56de\u503c\u6570\u636e\u4e0d\u662f\u4e00\u4e2aMap\u7c7b\u578b!");
        }
        return null;
    }
}

