/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.scm.im.inv.PurReceivalBillCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.NSRMBizException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmProgressUpdateUtil;
import com.kingdee.eas.scm.nsrm.app.util.SyncStatusUpdateUtil;
import com.kingdee.eas.scm.nsrm.constant.SyncStatusConstants;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurReceivalDeleteSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PurReceivalDeleteSend.class);
    private PurReceivalBillCollection oldBillCol = null;
    private PurReceivalBillCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entry");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        try {
            this.oldBillCol = (PurReceivalBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurReceivalBillCollection(ev);
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@PurReceivalDeleteSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@PurReceivalDeleteSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            logger.debug((Object)"@@@@PurReceivalDeleteSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        PurReceivalBillInfo info = null;
        for (int i = 0; i < this.oldBillCol.size(); ++i) {
            info = this.oldBillCol.get(i);
            if (info.getTransactionType().getRiType().getRI().getValue() == 1 && info.getTransactionType().getRiType().getBizDirection().getValue() == 1) {
                info.put("isreturn", (Object)0);
                continue;
            }
            info.put("isreturn", (Object)1);
        }
    }

    public void checkData(Context ctx) throws Exception {
        PurReceivalBillInfo purInfo = null;
        PurReceivalEntryInfo entry = null;
        String supplierID = null;
        this.newBillCol = new PurReceivalBillCollection();
        HashSet<String> oldSupplierIdSet = new HashSet<String>();
        Set<String> newSupplierIdSet = null;
        int size = this.oldBillCol.size();
        for (int i = 0; i < size; ++i) {
            purInfo = this.oldBillCol.get(i);
            supplierID = purInfo.getSupplier().getId().toString();
            oldSupplierIdSet.add(supplierID);
        }
        if (oldSupplierIdSet == null || oldSupplierIdSet.size() <= 0) {
            logger.debug((Object)"@@@@PurReceivalDeleteSend.checkData():\u6ca1\u6709\u534f\u540c\u4f9b\u5e94\u5546\u7684\u5355\u636e\u96c6\u5408.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        newSupplierIdSet = JudgeSupplierIsSrmUtil.getSupplierIsSrm(ctx, oldSupplierIdSet);
        if (newSupplierIdSet == null || newSupplierIdSet.size() <= 0) {
            logger.debug((Object)"@@@@PurReceivalDeleteSend.checkData():\u6ca1\u6709\u534f\u540c\u4f9b\u5e94\u5546\u7684\u5355\u636e\u96c6\u5408.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM003", cu);
        int size2 = this.oldBillCol.size();
        for (int i = 0; i < size2; ++i) {
            purInfo = this.oldBillCol.get(i);
            supplierID = purInfo.getSupplier().getId().toString();
            boolean issync = true;
            for (int j = 0; j < purInfo.getEntries().size(); ++j) {
                Object srmPorgress;
                entry = (PurReceivalEntryInfo)purInfo.getEntries().getObject(j);
                if (null == entry.getPurOrder() || null != (srmPorgress = entry.getPurOrder().get("srmProgress")) && !"0".equals(srmPorgress) && !"3".equals(srmPorgress)) continue;
                issync = false;
                break;
            }
            if (!newSupplierIdSet.contains(supplierID = (purInfo = this.oldBillCol.get(i)).getSupplier().getId().toString()) || (!"0".equals(paramValue) || !issync) && !"1".equals(paramValue)) continue;
            this.newBillCol.add(purInfo);
        }
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        HashMap<String, String> newBillMap;
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            return null;
        }
        if (data instanceof Map) {
            Map retMap = (Map)data;
            String returnData = ConvertUtil.convertObj2Str(retMap.get("data"));
            if (returnData == null) {
                SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, SyncStatusConstants.NULL_STATUS, "T_IM_purreceivalbill");
                throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
            }
            Map dataMap = null;
            try {
                dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)returnData, Map.class);
            }
            catch (Exception e) {
                SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, SyncStatusConstants.NULL_STATUS, "T_IM_purreceivalbill");
                return null;
            }
            if (!"200".equals(dataMap.get("code"))) {
                SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, SyncStatusConstants.NULL_STATUS, "T_IM_purreceivalbill");
                throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
            }
            SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, SyncStatusConstants.NULL_STATUS, "T_IM_purreceivalbill");
            Map billMap = (Map)dataMap.get("data");
            newBillMap = new HashMap<String, String>();
            for (Map.Entry entry : billMap.entrySet()) {
                String srmProgress = SrmProgressUpdateUtil.getsrmProgress(entry.getValue().toString());
                newBillMap.put((String)entry.getKey(), srmProgress);
            }
        } else {
            SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, SyncStatusConstants.NULL_STATUS, "T_IM_purreceivalbill");
            throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
        }
        SrmProgressUpdateUtil.updateSrmProgressForMap(ctx, newBillMap);
        return null;
    }
}

