/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.SouBillnoUpdateUtil;
import com.kingdee.eas.scm.nsrm.app.util.SyncStatusUpdateUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurRequestToSouBidBillSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PurRequestToSouBidBillSend.class);
    private PurRequestCollection oldBillCol = null;
    private PurRequestCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entries");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        IObjectPK[] idks = ConvertUtil.strArr2ObjArr(pks);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        try {
            this.oldBillCol = (PurRequestCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurRequestCollection(ev);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)user.getId(), CompareType.EQUALS));
            evi.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("person.name"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.number"));
            evi.setSelector(sic);
            UserCollection usercol = UserFactory.getLocalInstance((Context)ctx).getUserCollection(evi);
            if (null != usercol && usercol.size() > 0) {
                user = usercol.get(0);
            }
            PurRequestInfo info = null;
            for (int i = 0; i < this.oldBillCol.size(); ++i) {
                info = this.oldBillCol.get(i);
                if (null != user.getPerson()) {
                    info.put("user", (Object)(user.getPerson().getNumber() + "_" + user.getName()));
                    continue;
                }
                info.put("user", (Object)(user.getNumber() + "_" + user.getName()));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@PurRequestToSouBidBillSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@PurRequestToSouBidBillSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            logger.debug((Object)"@@@@PurRequestToSouBidBillSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    public void checkData(Context ctx) throws Exception {
        this.newBillCol = this.oldBillCol;
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            SyncStatusUpdateUtil.updateSynBidStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_SM_purrequest");
            return null;
        }
        if (data instanceof Map) {
            Map retMap = (Map)data;
            String returnData = ConvertUtil.convertObj2Str(retMap.get("success"));
            if (returnData == null) {
                SyncStatusUpdateUtil.updateSynBidStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_SM_purrequest");
                return null;
            }
            Map dataMap = null;
            try {
                String msgData = ConvertUtil.convertObj2Str(retMap.get("message"));
                if (null != msgData) {
                    dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)msgData, Map.class);
                }
            }
            catch (Exception e) {
                SyncStatusUpdateUtil.updateSynBidStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_SM_purrequest");
                return null;
            }
            SyncStatusUpdateUtil.updateSynBidStatusForCol(ctx, (IObjectCollection)this.newBillCol, "2", "T_SM_purrequest");
            if (null != dataMap && null != dataMap.get("data")) {
                Map billMap = (Map)dataMap.get("data");
                SouBillnoUpdateUtil.updateSouBillnoForCol(ctx, billMap, "CFSoubidno");
            }
        }
        return null;
    }
}

