/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.NSRMBizException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.nsrm.app.util.SyncStatusUpdateUtil;
import com.kingdee.eas.scm.nsrm.constant.SyncStatusConstants;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurReturnsDeleteSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PurReturnsDeleteSend.class);
    private PurReturnsCollection oldBillCol = null;
    private PurReturnsCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entries");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = JudgeSupplierIsSrmUtil.getIsSrmFilterEVI(pks, null);
        try {
            this.oldBillCol = (PurReturnsCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurReturnsCollection(ev);
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@PurReturnsDeleteSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@PurReturnsDeleteSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            logger.debug((Object)"@@@@PurReturnsDeleteSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    public void checkData(Context ctx) throws Exception {
        this.newBillCol = new PurReturnsCollection();
        HashSet<String> orderNumberSet = new HashSet<String>();
        PurReturnsInfo info = null;
        PurReturnsEntryInfo entry = null;
        for (int i = 0; i < this.oldBillCol.size(); ++i) {
            info = this.oldBillCol.get(i);
            for (int j = 0; j < info.getEntries().size(); ++j) {
                if (null == info.getEntries().get(j).getPurOrderNumber()) continue;
                orderNumberSet.add(info.getEntries().get(j).getPurOrderNumber());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("srmProgress"));
        sic.add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("number", orderNumberSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurOrderCollection purOrderCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(evi);
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        PurOrderInfo order = null;
        for (int i = 0; i < purOrderCollection.size(); ++i) {
            order = purOrderCollection.get(i);
            orderMap.put(order.getNumber(), order.get("srmProgress"));
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM003", cu);
        for (int i = 0; i < this.oldBillCol.size(); ++i) {
            info = this.oldBillCol.get(i);
            boolean issync = true;
            for (int j = 0; j < info.getEntries().size(); ++j) {
                Object srmPorgress;
                entry = info.getEntries().get(j);
                if (null == entry.getPurOrderNumber() || null != (srmPorgress = orderMap.get(entry.getPurOrderNumber())) && !"0".equals(srmPorgress) && !"3".equals(srmPorgress)) continue;
                issync = false;
                break;
            }
            if ((!"0".equals(paramValue) || !issync) && !"1".equals(paramValue)) continue;
            this.newBillCol.add(info);
        }
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            return null;
        }
        Map retMap = (Map)data;
        String returnData = ConvertUtil.convertObj2Str(retMap.get("data"));
        if (returnData == null) {
            throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
        }
        Map dataMap = null;
        try {
            dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)returnData, Map.class);
        }
        catch (Exception e) {
            return null;
        }
        if (!"200".equals(dataMap.get("code"))) {
            throw new NSRMBizException(NSRMBizException.BILL_UNAUDITFAIL);
        }
        SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, SyncStatusConstants.NULL_STATUS, "T_SM_purreturns");
        return null;
    }
}

