/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.fromeip.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.app.util.IerpToInwareUtil;
import com.kingdee.eas.scm.nsrm.app.util.QtyChangeCalUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.nsrm.util.SelectorFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurSaloutStocktoInwareReceive {
    public IerpToInwareUtil ierpToInwareUtil = IerpToInwareUtil.getInstance();
    private static Logger logger = Logger.getLogger(PurSaloutStocktoInwareReceive.class);
    private static PurSaloutStocktoInwareReceive single = null;

    public Object dealIerpData(Context ctx, Map<String, Object> dataMap, Object botpnumber, Map<String, Map<String, String>> msgMap, Object billstatus, Object billstatus1) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        HashSet<String> idSet = new HashSet<String>();
        Set<String> IerpidSet = dataMap.keySet();
        HashSet<String> entryidSet = new HashSet<String>();
        HashSet<String> baseUnitNumberSet = new HashSet<String>();
        HashMap<String, Object> IerpEntryMap = new HashMap<String, Object>();
        HashMap<String, Map<String, Set<String>>> IerpIdMap = new HashMap<String, Map<String, Set<String>>>();
        for (String key : IerpidSet) {
            HashMap orderIdMap = new HashMap();
            List ierpList = (List)dataMap.get(key);
            HashSet<String> ierpEntryIdset = new HashSet<String>();
            for (int i = 0; i < ierpList.size(); ++i) {
                Map entrymap = (Map)ierpList.get(i);
                String billid = ConvertUtil.convertObj2Str(entrymap.get("billid"));
                String ierpentryid = ConvertUtil.convertObj2Str(entrymap.get("srcEntryId"));
                String number = ConvertUtil.convertObj2Str(entrymap.get("basicUnit")).trim();
                String entryId = ConvertUtil.convertObj2Str(entrymap.get("entryId"));
                idSet.add(billid);
                baseUnitNumberSet.add(number);
                entryidSet.add(entryId);
                IerpEntryMap.put(ierpentryid, entrymap);
                ierpEntryIdset.add(ierpentryid);
                if (orderIdMap.get(billid) == null || ((Set)orderIdMap.get(billid)).size() <= 0) {
                    HashSet<String> ierpEntrySet = new HashSet<String>();
                    ierpEntrySet.add(ierpentryid);
                    orderIdMap.put(billid, ierpEntrySet);
                    continue;
                }
                ((Set)orderIdMap.get(billid)).add(ierpentryid);
            }
            IerpIdMap.put(key, orderIdMap);
        }
        Map<String, MeasureUnitInfo> unitMap = this.ierpToInwareUtil.getUnitMap(ctx, baseUnitNumberSet);
        Map<String, PurOrderInfo> orderMap = this.getOrderMap(ctx, idSet);
        Map<String, PurOrderEntryInfo> orderEntryMap = this.getOrderEntryMap(ctx, entryidSet);
        Map<String, Object> multiMap = this.getMultiMap(ctx, IerpEntryMap, orderEntryMap, unitMap);
        ArrayList<Map<String, Set<String>>> dataList = new ArrayList<Map<String, Set<String>>>();
        ArrayList<Map<String, Map<String, Object>>> dataEntryList = new ArrayList<Map<String, Map<String, Object>>>();
        ArrayList<Map<String, PurOrderInfo>> dataBillList = new ArrayList<Map<String, PurOrderInfo>>();
        ArrayList<Map<String, String>> IerpAandOrderIDLsit = new ArrayList<Map<String, String>>();
        boolean flag = true;
        for (String ierpEntryId : IerpEntryMap.keySet()) {
            Map entrymap = (Map)IerpEntryMap.get(ierpEntryId);
            String billid = ConvertUtil.convertObj2Str(entrymap.get("billid"));
            String entryId = ConvertUtil.convertObj2Str(entrymap.get("entryId"));
            PurOrderEntryInfo entry = orderEntryMap.get(entryId);
            PurOrderInfo info = orderMap.get(billid);
            this.dealSrcEntryData(ctx, info, entry, entrymap, unitMap, multiMap, msgMap);
            String baseunit = entrymap.get("basicUnit").toString().trim();
            if (!entry.getBaseUnit().getNumber().trim().toString().equals(baseunit)) {
                flag = false;
                break;
            }
            BigDecimal qty = entry.getQty();
            this.dealData(dataList, entry, info, dataEntryList, entrymap, dataBillList, IerpIdMap, IerpAandOrderIDLsit);
        }
        long currentTime = System.currentTimeMillis();
        logger.debug((Object)("@@@@PurSaloutStocktoInwareHandle.dealIerpData()\u65b9\u6cd5\u6267\u884c\u8017\u65f6\uff1a" + (currentTime - startTime)));
        if (!flag) {
            return null;
        }
        this.createNewCollection(ctx, dataBillList, dataEntryList, botpnumber.toString(), msgMap, billstatus, billstatus1);
        return null;
    }

    private Map<String, Object> getMultiMap(Context ctx, Map<String, Object> ierpEntryMap, Map<String, PurOrderEntryInfo> orderEntryMap, Map<String, MeasureUnitInfo> unitMap) throws BOSException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("SELECT MATERIAL.ID,MEASUREUNIT.ID,BASECONVSRATE   ");
        strBuilder.append("where ");
        int count = 0;
        int cost_count = 0;
        for (String ierpEntryId : ierpEntryMap.keySet()) {
            Map entrymap = (Map)ierpEntryMap.get(ierpEntryId);
            String entryId = ConvertUtil.convertObj2Str(entrymap.get("entryId"));
            String baseunit = ConvertUtil.convertObj2Str(entrymap.get("basicUnit"));
            MeasureUnitInfo baseunitinfo = unitMap.get(baseunit);
            PurOrderEntryInfo entry = orderEntryMap.get(entryId);
            ++count;
            if (null == entry.getMaterial() || null == baseunitinfo) {
                ++cost_count;
                continue;
            }
            strBuilder.append("(");
            strBuilder.append("MATERIAL.ID = '");
            strBuilder.append(entry.getMaterial().getId());
            strBuilder.append("' and ");
            strBuilder.append("MEASUREUNIT.ID = '");
            strBuilder.append(baseunitinfo.getId().toString());
            strBuilder.append("') ");
            strBuilder.append(" or ");
        }
        HashMap<String, Object> multiMap = new HashMap<String, Object>();
        if (cost_count != ierpEntryMap.keySet().size()) {
            MultiMeasureUnitCollection multiMeasureUnitCollection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(strBuilder.toString().substring(0, strBuilder.toString().length() - 3));
            for (int i = 0; i < multiMeasureUnitCollection.size(); ++i) {
                MultiMeasureUnitInfo info = multiMeasureUnitCollection.get(i);
                multiMap.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info);
            }
        }
        return multiMap;
    }

    private void dealSrcEntryData(Context ctx, PurOrderInfo info, PurOrderEntryInfo entry, Map<String, Object> entrymap, Map<String, MeasureUnitInfo> unitMap, Map<String, Object> multiMap, Map<String, Map<String, String>> msgMap) throws EASBizException, BOSException {
        entry.setTotalReceiptBaseQty(BigDecimal.ZERO);
        entry.setTotalReceiptQty(BigDecimal.ZERO);
        String unitQtyStr = ConvertUtil.convertObj2Str(entrymap.get("qty"));
        String unit = ConvertUtil.convertObj2Str(entrymap.get("unit")).trim();
        String baseunit = ConvertUtil.convertObj2Str(entrymap.get("basicUnit")).trim();
        BigDecimal unitQty = BigDecimal.ZERO;
        BigDecimal baseunitQty = BigDecimal.ZERO;
        if (unitQtyStr != null) {
            unitQty = new BigDecimal(unitQtyStr);
        }
        MeasureUnitInfo baseunitinfo = unitMap.get(baseunit);
        if (null != entry.getMaterial() && null != baseunitinfo) {
            String materialId = entry.getMaterial().getId().toString();
            String baseUnitId = baseunitinfo.getId().toString();
            baseunitQty = QtyChangeCalUtil.getBaseUnitQty(ctx, materialId, baseUnitId, unitQty, multiMap);
        } else {
            baseunitQty = unitQty;
        }
        if (entry.getBaseUnit().getNumber().trim().toString().equals(baseunit)) {
            if (entry.getUnit().getNumber().trim().toString().equals(unit)) {
                if (entry.getQty().compareTo(unitQty) != 0) {
                    entry.setQty(unitQty);
                    entry.setBaseQty(baseunitQty);
                    QtyChangeCalUtil.handRelationParams(ctx, entry, info);
                }
            } else if (entry.getUnit().getNumber().trim().toString().equals(baseunit)) {
                if (entry.getQty().compareTo(baseunitQty) != 0) {
                    entry.setQty(baseunitQty);
                    entry.setBaseQty(baseunitQty);
                    QtyChangeCalUtil.handRelationParams(ctx, entry, info);
                }
            } else {
                entry.setBaseQty(baseunitQty);
                QtyChangeCalUtil.handRelationParams(ctx, entry, info);
            }
        } else {
            logger.debug((Object)"@@@@PurSaloutStocktoInwareHandle.changeQty()errorMsg:\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u4e00\u81f4");
            this.ierpToInwareUtil.setEntryReturnMsg(entrymap, info.getNumber().toString() + "\u7684" + entry.getMaterialName() + "\u534f\u540c\u8ba2\u5355\u4e0eEAS\u8ba2\u5355\u7684\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u76f8\u540cBOTP\u8f6c\u6362\u5931\u8d25", "", "", "", msgMap);
        }
    }

    private Map<String, PurOrderEntryInfo> getOrderEntryMap(Context ctx, Set<String> entryidSet) throws BOSException {
        EntityViewInfo entryEv = ConvertUtil.convertPKSet2EVI(entryidSet);
        SelectorItemCollection sic = SelectorFactory.getPurOrderEntrySelector("");
        entryEv.setSelector(sic);
        PurOrderEntryCollection purOrdeEntryrCollection = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryCollection(entryEv);
        HashMap<String, PurOrderEntryInfo> orderEntryMap = new HashMap<String, PurOrderEntryInfo>();
        for (int i = 0; i < purOrdeEntryrCollection.size(); ++i) {
            PurOrderEntryInfo purOrderEntryInfo = purOrdeEntryrCollection.get(i);
            String id = purOrderEntryInfo.getId().toString();
            orderEntryMap.put(id, purOrderEntryInfo);
        }
        return orderEntryMap;
    }

    private Map<String, PurOrderInfo> getOrderMap(Context ctx, Set<String> idSet) throws EASBizException, BOSException {
        EntityViewInfo ev = ConvertUtil.convertPKSet2EVI(idSet);
        PurOrderCollection purOrderCollection = (PurOrderCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurOrderCollection(ev);
        HashMap<String, PurOrderInfo> orderMap = new HashMap<String, PurOrderInfo>();
        for (int i = 0; i < purOrderCollection.size(); ++i) {
            PurOrderInfo purOrderInfo = purOrderCollection.get(i);
            String id = purOrderInfo.getId().toString();
            orderMap.put(id, purOrderInfo);
        }
        return orderMap;
    }

    private Map<String, MeasureUnitInfo> getUnitMap(Context ctx, Set<String> baseUnitNumberSet) throws BOSException {
        HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
        EntityViewInfo unitev = ConvertUtil.convertNumSet2EVI(baseUnitNumberSet);
        MeasureUnitCollection measureUnitCollection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(unitev);
        for (int i = 0; i < measureUnitCollection.size(); ++i) {
            MeasureUnitInfo info = measureUnitCollection.get(i);
            unitMap.put(info.getNumber().toString(), info);
        }
        return unitMap;
    }

    private void createNewCollection(Context ctx, List<Map<String, PurOrderInfo>> dataList, List<Map<String, Map<String, Object>>> dataEntryList, String botpnumber, Map<String, Map<String, String>> msgMap, Object billstatus, Object billstatus1) throws EASBizException, BOSException {
        for (int i = 0; i < dataList.size(); ++i) {
            PurOrderCollection col = new PurOrderCollection();
            HashMap<String, Map<String, Object>> entryDetailMap = new HashMap<String, Map<String, Object>>();
            for (String billid : dataList.get(i).keySet()) {
                PurOrderInfo purOrderInfo = dataList.get(i).get(billid);
                col.add(purOrderInfo);
                this.dealEntryDetailData(entryDetailMap, dataEntryList.get(i).get(billid));
            }
            this.ierpToInwareUtil.updateBill(ctx, (IObjectCollection)col, entryDetailMap, botpnumber, msgMap, billstatus, billstatus1);
        }
    }

    private void dealEntryDetailData(Map<String, Map<String, Object>> entryDetailMap, Map<String, Object> map) {
        for (String entryId : map.keySet()) {
            Map entrymap = (Map)map.get(entryId);
            entryDetailMap.put(entryId, entrymap);
        }
    }

    private void dealData(List<Map<String, Set<String>>> dataList, PurOrderEntryInfo oldEntry, PurOrderInfo info, List<Map<String, Map<String, Object>>> dataEntryList, Map<String, Object> entrymap, List<Map<String, PurOrderInfo>> dataBillList, Map<String, Map<String, Set<String>>> ierpIdMap, List<Map<String, String>> ierpAandOrderIDLsit) {
        PurOrderEntryInfo entry = (PurOrderEntryInfo)oldEntry.clone();
        String billid = info.getId().toString();
        String ierpId = ConvertUtil.convertObj2Str(entrymap.get("srcBillId"));
        String ierpEntryid = ConvertUtil.convertObj2Str(entrymap.get("srcEntryId"));
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                String newIerpid = "";
                if (ierpAandOrderIDLsit.get(i).get(billid) != null) {
                    newIerpid = ierpAandOrderIDLsit.get(i).get(billid).split(":")[1];
                }
                if (dataList.get(i).get(billid) == null) {
                    HashSet<String> entryIdSet = new HashSet<String>();
                    entryIdSet.add(entry.getId().toString());
                    dataList.get(i).put(billid, entryIdSet);
                    HashMap<String, Map<String, Object>> entryDataMap = new HashMap<String, Map<String, Object>>();
                    entryDataMap.put(entry.getId().toString(), entrymap);
                    dataEntryList.get(i).put(billid, entryDataMap);
                    info.getEntries().clear();
                    PurOrderInfo newInfo = (PurOrderInfo)info.clone();
                    newInfo.getEntries().add(entry);
                    dataBillList.get(i).put(newInfo.getId().toString(), newInfo);
                    ierpAandOrderIDLsit.get(i).put(billid, billid + ":" + ierpId);
                } else if (!dataList.get(i).get(billid).contains(entry.getId().toString()) && ierpIdMap.get(newIerpid).get(billid).contains(ierpEntryid)) {
                    dataList.get(i).get(billid).add(entry.getId().toString());
                    dataEntryList.get(i).get(billid).put(entry.getId().toString(), entrymap);
                    dataBillList.get(i).get(billid).getEntries().add(entry);
                    ierpAandOrderIDLsit.get(i).put(billid, billid + ":" + ierpId);
                } else {
                    if (i != dataList.size() - 1) continue;
                    HashMap billDataMap = new HashMap();
                    HashSet<String> entryIdSet = new HashSet<String>();
                    entryIdSet.add(entry.getId().toString());
                    billDataMap.put(billid, entryIdSet);
                    dataList.add(billDataMap);
                    HashMap entryDataMap = new HashMap();
                    HashMap<String, Map<String, Object>> entryMap = new HashMap<String, Map<String, Object>>();
                    entryMap.put(entry.getId().toString(), entrymap);
                    entryDataMap.put(billid, entryMap);
                    dataEntryList.add(entryDataMap);
                    info.getEntries().clear();
                    PurOrderInfo newInfo = (PurOrderInfo)info.clone();
                    newInfo.getEntries().add(entry);
                    HashMap<String, PurOrderInfo> dataBillMap = new HashMap<String, PurOrderInfo>();
                    dataBillMap.put(newInfo.getId().toString(), newInfo);
                    dataBillList.add(dataBillMap);
                    HashMap<String, String> orderIdMap = new HashMap<String, String>();
                    orderIdMap.put(billid, billid + ":" + ierpId);
                    ierpAandOrderIDLsit.add(orderIdMap);
                }
                break;
            }
        } else {
            HashMap billDataMap = new HashMap();
            HashSet<String> entryIdSet = new HashSet<String>();
            entryIdSet.add(entry.getId().toString());
            billDataMap.put(billid, entryIdSet);
            dataList.add(billDataMap);
            HashMap entryDataMap = new HashMap();
            HashMap<String, Map<String, Object>> entryMap = new HashMap<String, Map<String, Object>>();
            entryMap.put(entry.getId().toString(), entrymap);
            entryDataMap.put(billid, entryMap);
            dataEntryList.add(entryDataMap);
            info.getEntries().clear();
            PurOrderInfo newInfo = (PurOrderInfo)info.clone();
            newInfo.getEntries().add(entry);
            HashMap<String, PurOrderInfo> dataBillMap = new HashMap<String, PurOrderInfo>();
            dataBillMap.put(newInfo.getId().toString(), newInfo);
            dataBillList.add(dataBillMap);
            HashMap<String, String> orderIdMap = new HashMap<String, String>();
            orderIdMap.put(billid, billid + ":" + ierpId);
            ierpAandOrderIDLsit.add(orderIdMap);
        }
    }

    public void addPurOrderEntry(PurOrderEntryCollection entrycol, PurOrderEntryInfo entry) {
        if (EntryBaseStatusEnum.AUDITED == entry.getBaseStatus()) {
            entrycol.add(entry);
        }
    }

    private PurSaloutStocktoInwareReceive() {
    }

    public static PurSaloutStocktoInwareReceive getInstance() {
        if (single == null) {
            single = new PurSaloutStocktoInwareReceive();
        }
        return single;
    }
}

