/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.fromeip.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.message.util.sendmsg.util.StringUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionCollection;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.app.compatible.VersionCompatibleHelper;
import com.kingdee.eas.scm.nsrm.app.fromeip.AbstractReceiveHandler;
import com.kingdee.eas.scm.nsrm.app.util.QtyChangeCalUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SouCompareToOrderReceive
extends AbstractReceiveHandler {
    private static Logger logger = Logger.getLogger(SouCompareToOrderReceive.class);
    private Map<String, Map<String, Map<String, String>>> msgMap = null;
    private HashMap<String, String> returnMsg = null;
    private final String SAVE = "1";
    private final String SUBMIT = "2";
    private final String TOORDER = "toOrder";

    @Override
    public Object handleReceive(Context ctx, Object data) throws Exception {
        this.msgMap = new HashMap<String, Map<String, Map<String, String>>>();
        this.returnMsg = new HashMap();
        if (this.msgMap != null) {
            this.msgMap.clear();
        }
        if (this.returnMsg != null) {
            this.returnMsg.clear();
        }
        Map retMap = ConvertUtil.convertJsonToMap(ctx, data);
        Map returnData = (Map)retMap.get("data");
        this.dealData(ctx, returnData);
        if (this.returnMsg != null && this.returnMsg.size() > 0) {
            return JSONObject.fromObject(this.returnMsg).toString();
        }
        JSONObject jsonObject = JSONObject.fromObject(this.msgMap);
        return jsonObject.toString();
    }

    private void dealData(Context ctx, Map returnData) throws EASBizException, BOSException, SQLException {
        Map dataMap = returnData;
        Set compareIdSet = dataMap.keySet();
        HashMap re4 = new HashMap();
        Object botpnumber = this.getBotpNumber(dataMap);
        if (botpnumber != null) {
            dataMap.remove("botpNumber");
            HashSet<String> purReqIdMSet = new HashSet<String>();
            HashSet<String> purReqEntryIdSet = new HashSet<String>();
            HashSet<String> payConSet = new HashSet<String>();
            HashSet<String> settleTypeSet = new HashSet<String>();
            HashSet<String> currSet = new HashSet<String>();
            HashSet<String> supplierSet = new HashSet<String>();
            HashSet<String> purorgSet = new HashSet<String>();
            HashSet<String> personSet = new HashSet<String>();
            HashSet<String> personGroupSet = new HashSet<String>();
            HashMap<String, List<String>> supplierByList = new HashMap<String, List<String>>();
            HashMap<String, Map<String, Map<String, Object>>> supplierByMap = new HashMap<String, Map<String, Map<String, Object>>>();
            String currStr = null;
            Map<String, Object> billMap = new HashMap();
            for (String key : compareIdSet) {
                billMap = (Map)dataMap.get(key);
                Map entrydataMap = (Map)billMap.get("entry");
                for (String entryKey : entrydataMap.keySet()) {
                    Map detailDataMap = (Map)entrydataMap.get(entryKey);
                    HashMap<String, Map> entryDetailMap = new HashMap<String, Map>();
                    String purReqId = detailDataMap.get("srcbillid").toString();
                    String purReqEntryId = detailDataMap.get("srcbillentryid").toString();
                    String supplierNumber = detailDataMap.get("supplier").toString();
                    purReqIdMSet.add(purReqId);
                    purReqEntryIdSet.add(purReqEntryId);
                    ArrayList<String> entryIdList = new ArrayList<String>();
                    String newKey = key + ":" + supplierNumber;
                    if (supplierByList.get(newKey) == null) {
                        entryIdList.add(purReqEntryId);
                        supplierByList.put(newKey, entryIdList);
                    } else {
                        List newEntryIdList = (List)supplierByList.get(newKey);
                        newEntryIdList.add(purReqEntryId);
                        supplierByList.put(newKey, newEntryIdList);
                    }
                    if (detailDataMap.get("supplier") != null) {
                        String supplier = detailDataMap.get("supplier").toString();
                        supplierSet.add(supplier);
                    }
                    detailDataMap.put("paycond", billMap.get("paycond"));
                    detailDataMap.put("settletype", billMap.get("settletype"));
                    detailDataMap.put("localcurr", billMap.get("localcurr"));
                    currStr = billMap.get("settlecurr").toString();
                    detailDataMap.put("settlecurr", billMap.get("settlecurr"));
                    detailDataMap.put("taxtype", billMap.get("taxtype"));
                    detailDataMap.put("purorg", billMap.get("purorg"));
                    detailDataMap.put("purperson", billMap.get("purperson"));
                    detailDataMap.put("group", billMap.get("group"));
                    detailDataMap.put("souBillId", key);
                    detailDataMap.put("souEntryId", entryKey);
                    if (supplierByMap.get(newKey) == null) {
                        entryDetailMap.put(purReqEntryId, detailDataMap);
                        supplierByMap.put(newKey, entryDetailMap);
                        continue;
                    }
                    Map newentryDetailMap = (Map)supplierByMap.get(newKey);
                    newentryDetailMap.put(purReqEntryId, detailDataMap);
                    supplierByMap.put(newKey, newentryDetailMap);
                }
                if (billMap.get("paycond") != null) {
                    String payCon = billMap.get("paycond").toString();
                    payConSet.add(payCon);
                }
                if (billMap.get("settletype") != null) {
                    String settleWay = billMap.get("settletype").toString();
                    settleTypeSet.add(settleWay);
                }
                if (billMap.get("localcurr") != null) {
                    String curr = billMap.get("localcurr").toString();
                    currSet.add(curr);
                }
                if (billMap.get("settlecurr") != null) {
                    String settleCurr = billMap.get("settlecurr").toString();
                    currSet.add(settleCurr);
                }
                if (billMap.get("purorg") != null) {
                    String purorg = billMap.get("purorg").toString();
                    purorgSet.add(purorg);
                }
                if (billMap.get("supplier") != null) {
                    String supplier = billMap.get("supplier").toString();
                    supplierSet.add(supplier);
                }
                if (billMap.get("purperson") != null) {
                    String person = billMap.get("purperson").toString();
                    personSet.add(person);
                }
                if (billMap.get("group") == null) continue;
                String group = billMap.get("group").toString();
                personGroupSet.add(group);
            }
            Map<String, Object> purReqMap = this.getPurReqMap(ctx, purReqIdMSet);
            Map<String, Object> purReqEntryMap = this.getPurReqEntryMap(ctx, purReqEntryIdSet);
            Map<String, Object> payConMap = this.getPayConMap(ctx, payConSet);
            Map<String, Object> settlementTypeMap = this.getSettlementTypeMap(ctx, settleTypeSet);
            Map<String, Object> currMap = this.getCurrMap(ctx, currSet);
            if (currMap.get(currStr) == null) {
                this.returnMsg.put("code", "404");
                this.returnMsg.put("error", "\u5e01\u522b\u7f16\u7801" + currStr + "\u5728EAS\u4e0d\u5b58\u5728");
                return;
            }
            Map<String, Object> supplierMap = this.getSupplierMap(ctx, supplierSet);
            Map<String, Object> purchaseOrgUnitMap = this.getPurchaseOrgUnitMap(ctx, purorgSet);
            Map<String, Object> personMap = this.getPurchasePersonMap(ctx, personSet);
            Map<String, Object> personGroupMap = this.getPurchaseGroupMap(ctx, personGroupSet);
            HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
            params.put("purreq", purReqMap);
            params.put("purreqentry", purReqEntryMap);
            params.put("paycon", payConMap);
            params.put("settype", settlementTypeMap);
            params.put("curr", currMap);
            params.put("supplier", supplierMap);
            params.put("purorg", purchaseOrgUnitMap);
            params.put("person", personMap);
            params.put("group", personGroupMap);
            this.buildData(ctx, supplierByList, supplierByMap, params, botpnumber, billMap);
        } else {
            ArrayList<ObjectUuidPK> list1 = new ArrayList<ObjectUuidPK>();
            returnData.remove("botpNumber");
            Map srcData = null;
            for (Object key : returnData.keySet()) {
                srcData = (Map)returnData.get(key);
            }
            Object purorg = srcData.get("purorg");
            Object purPerson = srcData.get("purperson");
            Object loccurr = srcData.get("localcurr");
            Object settlecurr = srcData.get("settlecurr");
            Object taxType = srcData.get("taxtype");
            Object settletype = srcData.get("settletype");
            Object paycond = srcData.get("paycond");
            Object exchrate = srcData.get("exchrate");
            Object group = srcData.get("group");
            Object srmBillId = srcData.get("id");
            PayConditionInfo payConditionInfo = null;
            if (paycond != null) {
                String paycondSql = "select fid from T_BD_PayCondition where fnumber = '" + paycond + "'";
                IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)paycondSql);
                String payConId = null;
                if (rowSet.next()) {
                    payConId = rowSet.getString("fid");
                }
                if (payConId != null) {
                    payConditionInfo = new PayConditionInfo();
                    payConditionInfo.setId(BOSUuid.read((String)payConId));
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            String bizDateStr = sdf.format(new Date());
            Timestamp bizDate = Timestamp.valueOf(bizDateStr);
            Map entryData = (Map)srcData.get("entry");
            HashSet<String> currSet = new HashSet<String>();
            if (loccurr != null) {
                currSet.add((String)loccurr);
            }
            if (settlecurr != null) {
                currSet.add((String)settlecurr);
            }
            HashSet<String> supplierSet = new HashSet<String>();
            HashSet<String> materialSet = new HashSet<String>();
            HashSet<String> unitSet = new HashSet<String>();
            HashSet<String> settlementTypeSet = new HashSet<String>();
            HashSet<String> storageOrgSet = new HashSet<String>();
            HashSet<String> purchaseOrgSet = new HashSet<String>();
            HashSet<String> personSet = new HashSet<String>();
            HashSet<String> purchaseGroupSet = new HashSet<String>();
            personSet.add((String)purPerson);
            purchaseOrgSet.add((String)purorg);
            settlementTypeSet.add((String)settletype);
            purchaseGroupSet.add((String)group);
            HashMap dataGroupBySupplier = new HashMap();
            for (String key : entryData.keySet()) {
                Object material;
                Map entryDetail = (Map)entryData.get(key);
                entryDetail.put("entryid", key);
                Object supplier = entryDetail.get("supplier");
                if (supplier != null) {
                    supplierSet.add((String)supplier);
                }
                if ((material = entryDetail.get("material")) != null) {
                    materialSet.add((String)material);
                }
                String unit = (String)entryDetail.get("unit");
                unitSet.add(unit);
                Object entryrcvorg = entryDetail.get("entryrcvorg");
                if (entryrcvorg != null) {
                    storageOrgSet.add((String)entryrcvorg);
                }
                if (group != null) {
                    purchaseGroupSet.add((String)group);
                }
                if (dataGroupBySupplier.containsKey(supplier)) {
                    ((List)dataGroupBySupplier.get(supplier)).add(entryDetail);
                    continue;
                }
                ArrayList<Map> list = new ArrayList<Map>();
                list.add(entryDetail);
                dataGroupBySupplier.put((String)supplier, list);
            }
            System.out.println(dataGroupBySupplier);
            Map<String, Object> supplierMap = this.getSupplierMap(ctx, supplierSet);
            Map<String, Object> materialMap = SouCompareToOrderReceive.getMaterialMap(ctx, materialSet);
            Map<String, Object> settlementTypeMap = this.getSettlementTypeMap(ctx, settlementTypeSet);
            Map<String, Object> unitMap = SouCompareToOrderReceive.getMeasureUnitMap(ctx, unitSet);
            Map<String, Object> storageOrgMap = SouCompareToOrderReceive.getstorageOrgMap(ctx, storageOrgSet);
            Map<String, Object> currencyMap = SouCompareToOrderReceive.getCurrencyMap(ctx, currSet);
            Map<String, Object> purchaseOrgMap = this.getPurchaseOrgMap(ctx, purchaseOrgSet);
            Map<String, Object> personMap = this.getPurchasePersonMap(ctx, personSet);
            Map<String, Object> purchaseGroupMap = this.getPurchaseGroupMap(ctx, purchaseGroupSet);
            boolean isSucc = true;
            for (String supp : dataGroupBySupplier.keySet()) {
                PurOrderInfo info = new PurOrderInfo();
                List entryList = (List)dataGroupBySupplier.get(supp);
                SupplierInfo supplier = (SupplierInfo)supplierMap.get(supp);
                boolean isSupp = true;
                boolean isCurr = true;
                boolean isPurchaseOrg = true;
                boolean isExchangeRate = true;
                if (supplier == null) {
                    isSupp = false;
                }
                SettlementTypeInfo settlementTypeInfo = (SettlementTypeInfo)settlementTypeMap.get(settletype);
                CurrencyInfo currencyInfo = (CurrencyInfo)currencyMap.get(settlecurr);
                if ("1".equals(taxType)) {
                    info.setIsInTax(true);
                    info.setIsPriceInTax(true);
                } else if ("3".equals(taxType)) {
                    info.setIsInTax(true);
                    info.setIsPriceInTax(false);
                } else if ("2".equals(taxType)) {
                    info.setIsInTax(false);
                    info.setIsPriceInTax(true);
                }
                PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)purchaseOrgMap.get(purorg);
                if (purchaseOrgUnitInfo == null) {
                    isPurchaseOrg = false;
                }
                BigDecimal exchangeRate = BigDecimal.ZERO;
                if (currencyInfo == null) {
                    isCurr = false;
                } else if (isPurchaseOrg) {
                    try {
                        exchangeRate = this.getExchangeRate(ctx, purchaseOrgUnitInfo, new ObjectUuidPK(currencyInfo.getId()));
                    }
                    catch (Exception e) {
                        isExchangeRate = false;
                    }
                }
                PersonInfo purchasePerson = (PersonInfo)personMap.get(purPerson);
                info.setPurchaseGroup((PurchaseGroupInfo)purchaseGroupMap.get(group));
                info.setCurrency(currencyInfo);
                BizTypeInfo bizTypeInfo = new BizTypeInfo();
                bizTypeInfo.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
                info.setBizType(bizTypeInfo);
                info.setPurchaseOrgUnit(purchaseOrgUnitInfo);
                info.setPurchasePerson(purchasePerson);
                info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                info.setSupplier(supplier);
                info.setPaymentCondition(payConditionInfo);
                info.setBizDate((Date)bizDate);
                info.setSettlementType(settlementTypeInfo);
                info.setExchangeRate(exchangeRate);
                HashMap re3 = new HashMap();
                for (Map entryMap : entryList) {
                    int seq = 0;
                    MaterialInfo materialInfo = (MaterialInfo)materialMap.get(entryMap.get("material"));
                    HashMap re = new HashMap();
                    HashMap<String, String> re2 = new HashMap<String, String>();
                    if (!isSupp) {
                        re2 = new HashMap();
                        re2.put("billtype", "toOrder");
                        re2.put("error", "\u4f9b\u5e94\u5546\u7f16\u7801: " + supp + " \u5728EAS\u4e2d\u4e0d\u5b58\u5728");
                        re2.put("billstatus", "");
                        re.put((String)entryMap.get("entryid"), re2);
                        re3.putAll(re);
                        isSucc = false;
                        continue;
                    }
                    if (!isPurchaseOrg) {
                        re2 = new HashMap();
                        re2.put("billtype", "toOrder");
                        re2.put("error", "\u91c7\u8d2d\u7ec4\u7ec7\u7f16\u7801\uff1a " + purorg + " \u5728EAS\u4e2d\u4e0d\u5b58\u5728");
                        re2.put("billstatus", "");
                        re.put((String)entryMap.get("entryid"), re2);
                        re3.putAll(re);
                        isSucc = false;
                        continue;
                    }
                    if (!isCurr) {
                        re2 = new HashMap();
                        re2.put("billtype", "toOrder");
                        re2.put("error", "\u5e01\u522b\u7f16\u7801\uff1a " + settlecurr + " \u5728EAS\u4e2d\u4e0d\u5b58\u5728");
                        re2.put("billstatus", "");
                        re.put((String)entryMap.get("entryid"), re2);
                        re3.putAll(re);
                        isSucc = false;
                        continue;
                    }
                    if (!isExchangeRate) {
                        re2 = new HashMap();
                        re2.put("billtype", "toOrder");
                        re2.put("error", "\u5e01\u522b\u7f16\u7801" + settlecurr + "\u5728eas\u5bf9\u5e94\u7684\u91c7\u8d2d\u7ec4\u7ec7\u6240\u59d4\u6258\u7684\u8d22\u52a1\u7ec4\u7ec7\u4e2d\u5bf9\u5e94\u7684\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u7ef4\u62a4");
                        re2.put("billstatus", "");
                        re.put((String)entryMap.get("entryid"), re2);
                        re3.putAll(re);
                        isSucc = false;
                        continue;
                    }
                    if (materialInfo == null) {
                        re2 = new HashMap();
                        re2.put("billtype", "toOrder");
                        re2.put("error", "\u7269\u6599\u7f16\u7801\uff1a " + entryMap.get("material") + " \u5728EAS\u4e2d\u4e0d\u5b58\u5728");
                        re2.put("billstatus", "");
                        re.put((String)entryMap.get("entryid"), re2);
                        re3.putAll(re);
                        isSucc = false;
                        continue;
                    }
                    re2.put("billtype", "toOrder");
                    re2.put("error", "");
                    re2.put("billstatus", "");
                    re.put((String)entryMap.get("entryid"), re2);
                    re3.putAll(re);
                    MeasureUnitInfo baseUnit = materialInfo.getBaseUnit();
                    PurOrderEntryInfo purOrderEntryInfo = new PurOrderEntryInfo();
                    MeasureUnitInfo unit = (MeasureUnitInfo)unitMap.get(entryMap.get("unit"));
                    if (unit == null) {
                        re2 = new HashMap();
                        re2.put("billtype", "toOrder");
                        re2.put("error", "\u8ba1\u91cf\u5355\u4f4d\u7f16\u7801:" + entryMap.get("unit") + " \u5728eas\u4e0d\u5b58\u5728");
                        re2.put("billstatus", "");
                        re.put((String)entryMap.get("entryid"), re2);
                        re3.putAll(re);
                        isSucc = false;
                        continue;
                    }
                    BigDecimal amount = new BigDecimal((String)entryMap.get("amount"));
                    BigDecimal qty = new BigDecimal((String)entryMap.get("confirmqty"));
                    purOrderEntryInfo.setBaseQty(QtyChangeCalUtil.getBaseUnitQty1(ctx, materialInfo.getId().toString(), unit.getId().toString(), baseUnit.getId().toString(), qty));
                    BigDecimal tax = new BigDecimal((String)entryMap.get("tax"));
                    BigDecimal taxrate = new BigDecimal((String)entryMap.get("taxrate"));
                    BigDecimal taxamount = new BigDecimal((String)entryMap.get("taxamount"));
                    Object delidat = entryMap.get("entrydelidat");
                    if (delidat != null && delidat instanceof Double) {
                        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
                        purOrderEntryInfo.setDeliveryDate((Date)Timestamp.valueOf(sdf1.format(((Double)delidat).longValue())));
                    } else if (StringUtil.isNotEmpty((String)((String)delidat)) && !"null".equals(delidat)) {
                        SimpleDateFormat sdff = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            Date date = sdff.parse(delidat.toString());
                            purOrderEntryInfo.setDeliveryDate(date);
                        }
                        catch (ParseException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                    purOrderEntryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                    purOrderEntryInfo.setMaterial(materialInfo);
                    purOrderEntryInfo.setMaterialName(materialInfo.getName());
                    purOrderEntryInfo.setBaseUnit(materialInfo.getBaseUnit());
                    purOrderEntryInfo.setUnit(unit);
                    purOrderEntryInfo.setAmount(amount);
                    purOrderEntryInfo.setTax(tax);
                    purOrderEntryInfo.setTaxRate(taxrate);
                    purOrderEntryInfo.setTaxAmount(taxamount);
                    StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)storageOrgMap.get(entryMap.get("entryrcvorg"));
                    CompanyOrgUnitInfo companyInfoForStorage = InvServerUtils.getCompanyInfoForStorage((Context)ctx, (StorageOrgUnitInfo)storageOrgUnitInfo);
                    purOrderEntryInfo.setStorageOrgUnit(storageOrgUnitInfo);
                    purOrderEntryInfo.setCompanyOrgUnit(companyInfoForStorage);
                    purOrderEntryInfo.setQty(qty);
                    purOrderEntryInfo.setDeliveryAddress((String)entryMap.get("entrydeliaddr"));
                    purOrderEntryInfo.setDiscountRate(new BigDecimal((String)entryMap.get("dctrate")));
                    purOrderEntryInfo.setPrice(new BigDecimal((String)entryMap.get("price")));
                    purOrderEntryInfo.setTaxPrice(new BigDecimal((String)entryMap.get("confirmtaxprice")));
                    purOrderEntryInfo.setSeq(seq++);
                    purOrderEntryInfo.setNoNumMaterialModel(entryMap.get("materialmodel") == null ? null : (String)entryMap.get("materialmodel"));
                    RowTypeInfo rowTypeInfo = new RowTypeInfo();
                    rowTypeInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000017C7DC4A3"));
                    purOrderEntryInfo.setRowType(rowTypeInfo);
                    purOrderEntryInfo.put("thirdBillEntryId", (Object)((String)entryMap.get("id")));
                    purOrderEntryInfo.put("thirdBillId", srmBillId);
                    purOrderEntryInfo.put("srmQty", (Object)purOrderEntryInfo.getBaseQty());
                    if ("1".equals(entryMap.get("quantityUnCtrl"))) {
                        purOrderEntryInfo.setQuantityUnCtrl(true);
                    } else {
                        purOrderEntryInfo.setQuantityUnCtrl(false);
                    }
                    info.getEntries().add(purOrderEntryInfo);
                    VersionCompatibleHelper.calByEntryPriceChange((SCMBillBaseInfo)info, (SCMBillEntryBaseInfo)purOrderEntryInfo, info.isIsInTax());
                }
                if (isSucc) {
                    PurOrderFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
                    BOSUuid id = info.getId();
                    ObjectUuidPK objectUuidPK = new ObjectUuidPK(id);
                    list1.add(objectUuidPK);
                    for (HashMap value : re3.values()) {
                        value.put("billnumber", info.getNumber());
                    }
                    re4.putAll(re3);
                    continue;
                }
                for (HashMap value : re3.values()) {
                    value.put("billnumber", "");
                }
                re4.putAll(re3);
            }
            if (!isSucc) {
                IObjectPK[] s = new IObjectPK[list1.size()];
                for (int i = 0; i < list1.size(); ++i) {
                    s[i] = (IObjectPK)list1.get(i);
                }
                for (Map value : re4.values()) {
                    value.put("billnumber", "");
                }
                PurOrderFactory.getLocalInstance((Context)ctx).delete(s);
            }
            this.msgMap.put((String)returnData.keySet().toArray()[0], re4);
        }
    }

    private Map<String, Object> getPurchaseOrgMap(Context ctx, Set<String> purchaseOrgSet) throws BOSException {
        EntityViewInfo purchaseOrgEV = ConvertUtil.convertNumSet2EVI(purchaseOrgSet);
        PurchaseOrgUnitCollection purchaseOrgUnitCollection = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitCollection(purchaseOrgEV);
        HashMap<String, Object> purchaseOrgMap = new HashMap<String, Object>();
        if (purchaseOrgUnitCollection != null && purchaseOrgUnitCollection.size() > 0) {
            for (int i = 0; i < purchaseOrgUnitCollection.size(); ++i) {
                PurchaseOrgUnitInfo info = purchaseOrgUnitCollection.get(i);
                String number = info.getNumber();
                purchaseOrgMap.put(number, info);
            }
        }
        return purchaseOrgMap;
    }

    private Map<String, Object> getPurchasePersonMap(Context ctx, Set<String> personSet) throws BOSException {
        EntityViewInfo purorgEV = ConvertUtil.convertNumSet2EVI(personSet);
        PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(purorgEV);
        HashMap<String, Object> personMap = new HashMap<String, Object>();
        if (personCollection != null && personCollection.size() > 0) {
            for (int i = 0; i < personCollection.size(); ++i) {
                PersonInfo info = personCollection.get(i);
                String number = info.getNumber().toString();
                personMap.put(number, info);
            }
        }
        return personMap;
    }

    private void buildData(Context ctx, Map<String, List<String>> supplierByList, Map<String, Map<String, Map<String, Object>>> supplierByMap, Map<String, Map<String, Object>> params, Object botpnumber, Map<String, Object> billMap) throws EASBizException, BOSException {
        Map<String, Object> purReqMap = params.get("purreq");
        Map<String, Object> purReqEntryMap = params.get("purreqentry");
        Map<String, Object> payConMap = params.get("paycon");
        Map<String, Object> settlementTypeMap = params.get("settype");
        Map<String, Object> currMap = params.get("curr");
        Map<String, Object> supplierMap = params.get("supplier");
        Map<String, Object> purchaseOrgUnitMap = params.get("purorg");
        Map<String, Object> personMap = params.get("person");
        Map<String, Object> personGroupMap = params.get("group");
        PurRequestCollection infoCol = new PurRequestCollection();
        for (String key : supplierByList.keySet()) {
            int i;
            List<String> entryIdList = supplierByList.get(key);
            PurRequestEntryCollection entrycol = new PurRequestEntryCollection();
            PurRequestInfo info = null;
            PurRequestInfo newInfo = null;
            for (i = 0; i < entryIdList.size(); ++i) {
                String entryId = entryIdList.get(i);
                Map<String, Object> detailDataMap = supplierByMap.get(key).get(entryId);
                PurRequestEntryInfo entryInfo = (PurRequestEntryInfo)purReqEntryMap.get(entryId);
                String purReq = (String)detailDataMap.get("srcbillid");
                info = (PurRequestInfo)purReqMap.get(purReq);
                if (detailDataMap.get("paycond") != null) {
                    String payCon = detailDataMap.get("paycond").toString();
                    detailDataMap.put("paycond", payConMap.get(payCon));
                }
                if (detailDataMap.get("settletype") != null) {
                    String settleWay = detailDataMap.get("settletype").toString();
                    detailDataMap.put("settletype", settlementTypeMap.get(settleWay));
                }
                if (detailDataMap.get("localcurr") != null) {
                    String curr = detailDataMap.get("localcurr").toString();
                    detailDataMap.put("localcurr", currMap.get(curr));
                }
                if (detailDataMap.get("settlecurr") != null) {
                    String settleCurr = detailDataMap.get("settlecurr").toString();
                    detailDataMap.put("settlecurr", currMap.get(settleCurr));
                }
                if (detailDataMap.get("supplier") != null) {
                    String supplier = detailDataMap.get("supplier").toString();
                    detailDataMap.put("supplier", supplierMap.get(supplier));
                }
                if (detailDataMap.get("purorg") != null) {
                    String purorg = detailDataMap.get("purorg").toString();
                    detailDataMap.put("purorg", purchaseOrgUnitMap.get(purorg));
                }
                if (detailDataMap.get("purperson") != null) {
                    String person = detailDataMap.get("purperson").toString();
                    detailDataMap.put("purperson", personMap.get(person));
                }
                if (detailDataMap.get("group") != null) {
                    String group = detailDataMap.get("group").toString();
                    detailDataMap.put("group", personGroupMap.get(group));
                }
                entrycol.add(entryInfo);
            }
            newInfo = (PurRequestInfo)info.clone();
            newInfo.getEntries().clear();
            for (i = 0; i < entrycol.size(); ++i) {
                newInfo.getEntries().add(entrycol.get(i));
            }
            this.dealBotpPurContract(ctx, newInfo, supplierByMap.get(key), entryIdList, botpnumber.toString(), billMap);
        }
    }

    private Map<String, Object> getPurReqEntryMap(Context ctx, Set<String> purReqEntryIdSet) throws BOSException {
        EntityViewInfo ev = ConvertUtil.convertPKSet2EVI(purReqEntryIdSet);
        PurRequestEntryCollection col = PurRequestEntryFactory.getLocalInstance((Context)ctx).getPurRequestEntryCollection(ev);
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                PurRequestEntryInfo info = col.get(i);
                String id = info.getId().toString();
                infoMap.put(id, info);
            }
        }
        return infoMap;
    }

    private Map<String, Object> getPurchaseOrgUnitMap(Context ctx, Set<String> purorgSet) throws BOSException {
        EntityViewInfo purorgEV = ConvertUtil.convertNumSet2EVI(purorgSet);
        PurchaseOrgUnitCollection purchaseOrgUnitCollection = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitCollection(purorgEV);
        HashMap<String, Object> purchaseOrgUnitMap = new HashMap<String, Object>();
        if (purchaseOrgUnitCollection != null && purchaseOrgUnitCollection.size() > 0) {
            for (int i = 0; i < purchaseOrgUnitCollection.size(); ++i) {
                PurchaseOrgUnitInfo purchaseOrgUnitInfoInfo = purchaseOrgUnitCollection.get(i);
                String number = purchaseOrgUnitInfoInfo.getNumber().toString();
                purchaseOrgUnitMap.put(number, purchaseOrgUnitInfoInfo);
            }
        }
        return purchaseOrgUnitMap;
    }

    private Map<String, Object> getSupplierMap(Context ctx, Set<String> supplierSet) throws BOSException {
        EntityViewInfo supplierEV = ConvertUtil.convertNumSet2EVI(supplierSet);
        SupplierCollection supplierCollection = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(supplierEV);
        HashMap<String, Object> supplierMap = new HashMap<String, Object>();
        if (supplierCollection != null && supplierCollection.size() > 0) {
            for (int i = 0; i < supplierCollection.size(); ++i) {
                SupplierInfo supplierInfo = supplierCollection.get(i);
                String number = supplierInfo.getNumber().toString();
                supplierMap.put(number, supplierInfo);
            }
        }
        return supplierMap;
    }

    private Map<String, Object> getCurrMap(Context ctx, Set<String> currSet) throws BOSException {
        EntityViewInfo currEV = ConvertUtil.convertNumSet2EVI(currSet);
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(currEV);
        HashMap<String, Object> currMap = new HashMap<String, Object>();
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currencyInfo = currencyCollection.get(i);
                String number = currencyInfo.getNumber().toString();
                currMap.put(number, currencyInfo);
            }
        }
        return currMap;
    }

    private Map<String, Object> getSettlementTypeMap(Context ctx, Set<String> settleTypeSet) throws BOSException {
        EntityViewInfo settleWayEV = ConvertUtil.convertNumSet2EVI(settleTypeSet);
        SettlementTypeCollection settlementTypeCollection = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(settleWayEV);
        HashMap<String, Object> settlementTypeMap = new HashMap<String, Object>();
        if (settlementTypeCollection != null && settlementTypeCollection.size() > 0) {
            for (int i = 0; i < settlementTypeCollection.size(); ++i) {
                SettlementTypeInfo settlementTypeInfo = settlementTypeCollection.get(i);
                String number = settlementTypeInfo.getNumber().toString();
                settlementTypeMap.put(number, settlementTypeInfo);
            }
        }
        return settlementTypeMap;
    }

    private Map<String, Object> getPayConMap(Context ctx, Set<String> payConSet) throws BOSException {
        EntityViewInfo payconEV = ConvertUtil.convertNumSet2EVI(payConSet);
        PayConditionCollection payConditionCollection = PayConditionFactory.getLocalInstance((Context)ctx).getPayConditionCollection(payconEV);
        HashMap<String, Object> payConMap = new HashMap<String, Object>();
        if (payConditionCollection != null && payConditionCollection.size() > 0) {
            for (int i = 0; i < payConditionCollection.size(); ++i) {
                PayConditionInfo payConditionInfo = payConditionCollection.get(i);
                String number = payConditionInfo.getNumber().toString();
                payConMap.put(number, payConditionInfo);
            }
        }
        return payConMap;
    }

    private Map<String, Object> getPurReqMap(Context ctx, Set<String> purReqIdMSet) throws EASBizException, BOSException {
        EntityViewInfo ev = ConvertUtil.convertPKSet2EVI(purReqIdMSet);
        PurRequestCollection purRequestCollection = (PurRequestCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurRequestCollection(ev);
        HashMap<String, Object> purReqMap = new HashMap<String, Object>();
        for (int i = 0; i < purRequestCollection.size(); ++i) {
            PurRequestInfo purRequestInfo = purRequestCollection.get(i);
            String id = purRequestInfo.getId().toString();
            purReqMap.put(id, purRequestInfo);
        }
        return purReqMap;
    }

    private BTPTransformResult PurRequestBotpPurContract(Context ctx, PurRequestInfo purRequestInfo, String botpnumber) throws BOSException, BTPException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection cbc = new CoreBillBaseCollection();
        cbc.addObject((IObjectValue)purRequestInfo);
        String purContractType = "3171BFAD";
        String botpID = this.getBotpIDFromBotpNumber(ctx, botpnumber);
        if (botpID == null) {
            return null;
        }
        return iBTPManager.transformForBotp(cbc, purContractType, (IObjectPK)new ObjectUuidPK(botpID));
    }

    private String getBotpIDFromBotpNumber(Context ctx, String botpnumber) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select mapping.fid fid, ext.FIsEffected FIsEffected from T_BOT_MAPPING mapping ").append(" left outer join T_BOT_ExtMapping ext on mapping.FExtMappingID = ext.fid").append(" where mapping.fName = '").append(botpnumber).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        boolean hasRule = false;
        boolean isEffected = false;
        String botpID = null;
        try {
            if (rs.next()) {
                botpID = rs.getString("fid");
                isEffected = rs.getBoolean("FIsEffected");
                hasRule = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        if (!hasRule) {
            logger.error((Object)"@@@@PurSaloutStocktoInwareHandle,errorMsg:\u6ca1\u6709\u5b9a\u4e49BOTP\u89c4\u5219");
            return null;
        }
        if (!isEffected) {
            logger.error((Object)"@@@@PurSaloutStocktoInwareHandle,errorMsg:BOTP\u89c4\u5219\u672a\u542f\u7528");
        }
        return botpID;
    }

    private void dealBotpPurContract(Context ctx, PurRequestInfo purRequestInfo, Map<String, Map<String, Object>> entryDataMap, List<String> entryIdList, String botpnumber, Map<String, Object> billMap) throws EASBizException, BOSException {
        BTPTransformResult btpTransformResult = new BTPTransformResult();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent.id"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(entryIdList), CompareType.INCLUDE));
        viewInfo.setSelector(selector);
        viewInfo.setFilter(filterInfo);
        PurRequestEntryCollection purEntryColl = PurRequestEntryFactory.getLocalInstance((Context)ctx).getPurRequestEntryCollection(viewInfo);
        HashSet<String> srcBillIDs = new HashSet<String>();
        for (int i = 0; i < purEntryColl.size(); ++i) {
            srcBillIDs.add(purEntryColl.get(i).getParent().getId().toString());
        }
        String botMappingId = this.getBotpIDFromBotpNumber(ctx, botpnumber);
        try {
            BTPTransformResult newBtpTransformResult = null;
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            newBtpTransformResult = iBTPManager.transformForBotp(srcBillIDs.toArray(new String[0]), new String[]{"entries"}, entryIdList, null, "3171BFAD", (IObjectPK)new ObjectUuidPK(botMappingId), "25428F2E");
            if (newBtpTransformResult == null) {
                this.setBotpBeforeReturnMsg(entryDataMap, purRequestInfo.getNumber() + "BOTP\u8f6c\u6362\u5931\u8d25", "", "", "", purRequestInfo, entryIdList);
            } else {
                IObjectCollection iObjectCollection = newBtpTransformResult.getBills();
                btpTransformResult.addBills(iObjectCollection);
            }
        }
        catch (Exception e) {
            this.setBotpBeforeReturnMsg(entryDataMap, purRequestInfo.getNumber() + e.getMessage(), "", "", "", purRequestInfo, entryIdList);
        }
        if (btpTransformResult == null || btpTransformResult.getBills() == null || btpTransformResult.getBills().size() <= 0) {
            this.setBotpBeforeReturnMsg(entryDataMap, purRequestInfo.getNumber() + "BOTP\u8f6c\u6362\u5931\u8d25", "", "", "", purRequestInfo, entryIdList);
            return;
        }
        PurOrderCollection purOrderCollection = (PurOrderCollection)btpTransformResult.getBills();
        for (int i = 0; i < purOrderCollection.size(); ++i) {
            PurOrderInfo info = purOrderCollection.get(i);
            PurOrderEntryInfo entryinfo = info.getEntries().get(0);
            String srcId = entryinfo.getSourceBillId().toString();
            Map<String, Object> billAndEntryMap = entryDataMap.get(entryinfo.getSourceBillEntryId().toString());
            PurchaseOrgUnitInfo purorg = (PurchaseOrgUnitInfo)billAndEntryMap.get("purorg");
            PersonInfo purPerson = null;
            if (billAndEntryMap.get("purperson") != null && !billAndEntryMap.get("purperson").equals("")) {
                purPerson = (PersonInfo)billAndEntryMap.get("purperson");
            }
            info.setPurchasePerson(purPerson);
            PurchaseGroupInfo purchaseGroupInfo = null;
            if (billAndEntryMap.get("group") != null && !billAndEntryMap.get("group").equals("")) {
                purchaseGroupInfo = (PurchaseGroupInfo)billAndEntryMap.get("group");
            }
            info.setPurchaseGroup(purchaseGroupInfo);
            PayConditionInfo payCon = (PayConditionInfo)billAndEntryMap.get("paycond");
            SettlementTypeInfo settleWay = (SettlementTypeInfo)billAndEntryMap.get("settletype");
            CurrencyInfo curr = (CurrencyInfo)billAndEntryMap.get("localcurr");
            CurrencyInfo settleCurr = (CurrencyInfo)billAndEntryMap.get("settlecurr");
            if (billAndEntryMap.get("taxtype") != null) {
                String taxtype = billAndEntryMap.get("taxtype").toString();
                if ("1".equals(taxtype)) {
                    info.setIsInTax(true);
                    info.setIsPriceInTax(true);
                } else if ("3".equals(taxtype)) {
                    info.setIsInTax(true);
                    info.setIsPriceInTax(false);
                } else if ("2".equals(taxtype)) {
                    info.setIsInTax(false);
                    info.setIsPriceInTax(true);
                }
            }
            info.setPaymentCondition(payCon);
            info.setSettlementType(settleWay);
            this.returnMsg = new HashMap();
            info.setCurrency(settleCurr);
            BigDecimal exchangeRate = null;
            try {
                exchangeRate = this.getExchangeRate(ctx, info.getPurchaseOrgUnit(), new ObjectUuidPK(settleCurr.getId()));
            }
            catch (BOSException e) {
                PurOrderFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
                this.returnMsg.put("code", "404");
                this.returnMsg.put("error", settleCurr.getNumber() + "\u5728EAS\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u7ef4\u62a4\u76f8\u5173\u7684\u6c47\u7387");
                return;
            }
            info.setExchangeRate(exchangeRate);
            SupplierInfo supplierInfo = (SupplierInfo)billAndEntryMap.get("supplier");
            if (supplierInfo == null) {
                this.returnMsg.put("code", "404");
                this.returnMsg.put("error", "\u4f9b\u5e94\u5546\u7f16\u7801\u5728EAS\u4e0d\u5b58\u5728");
                return;
            }
            info.setSupplier(supplierInfo);
            for (int j = 0; j < info.getEntries().size(); ++j) {
                PurOrderEntryInfo entry = info.getEntries().get(j);
                billAndEntryMap = entryDataMap.get(entry.getSourceBillEntryId().toString());
                String confirmqtyStr = (String)billAndEntryMap.get("confirmqty");
                String confirmtaxpriceStr = (String)billAndEntryMap.get("confirmtaxprice");
                String taxrateStr = (String)billAndEntryMap.get("taxrate");
                String priceStr = (String)billAndEntryMap.get("price");
                Object deliDate = billAndEntryMap.get("entrydelidat");
                String entrydeliaddr = (String)billAndEntryMap.get("entrydeliaddr");
                BigDecimal confirmqty = BigDecimal.ZERO;
                if (!"null".equals(confirmqtyStr)) {
                    confirmqty = new BigDecimal(confirmqtyStr);
                }
                BigDecimal confirmtaxprice = BigDecimal.ZERO;
                if (!"null".equals(confirmtaxpriceStr)) {
                    confirmtaxprice = new BigDecimal(confirmtaxpriceStr);
                }
                BigDecimal taxrate = BigDecimal.ZERO;
                if (!"null".equals(taxrateStr)) {
                    taxrate = new BigDecimal(taxrateStr);
                }
                BigDecimal price = BigDecimal.ZERO;
                if (!"null".equals(priceStr)) {
                    price = new BigDecimal(priceStr);
                }
                if (deliDate != null && deliDate instanceof Double) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
                    entry.setDeliveryDate((Date)Timestamp.valueOf(sdf.format(((Double)deliDate).longValue())));
                } else if (com.kingdee.lightapp.util.StringUtil.isNotEmpty((String)(deliDate + "")) && !"null".equals(deliDate + "")) {
                    SimpleDateFormat sdff = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date date = sdff.parse(deliDate.toString());
                        entry.setDeliveryDate(date);
                    }
                    catch (ParseException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (StringUtil.isNotEmpty((String)entrydeliaddr)) {
                    entry.setDeliveryAddress(entrydeliaddr);
                }
                BigDecimal baseunitQty = BigDecimal.ZERO;
                MeasureUnitInfo baseunitinfo = entry.getBaseUnit();
                String materialId = entry.getMaterial().getId().toString();
                String baseUnitId = baseunitinfo.getId().toString();
                entry.setQty(confirmqty);
                baseunitQty = QtyChangeCalUtil.getBaseUnitQty1(ctx, materialId, entry.getUnit().getId().toString(), baseUnitId, entry.getQty());
                entry.setBaseQty(baseunitQty);
                entry.setTaxPrice(confirmtaxprice);
                entry.setTaxRate(taxrate);
                entry.setPrice(price);
                entry.put("thirdBillEntryId", (Object)((String)billAndEntryMap.get("id")));
                entry.put("thirdBillId", (Object)((String)billMap.get("id")));
                VersionCompatibleHelper.calByEntryPriceChange((SCMBillBaseInfo)info, (SCMBillEntryBaseInfo)entry, info.isIsInTax());
            }
            try {
                PurOrderFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
                this.setBotpAfterReturnMsg(entryDataMap, "", "toOrder", info.getNumber().toString(), "2", info);
                for (String srcBillID : srcBillIDs) {
                    SCMServerUtils.traceUpAndDown((Context)ctx, (String)srcBillID, (String)info.getId().toString(), (String)"25428F2E", (String)"3171BFAD");
                }
                continue;
            }
            catch (Exception e) {
                this.setBotpAfterReturnMsg(entryDataMap, e.getMessage(), "toOrder", info.getNumber().toString(), "1", info);
            }
        }
    }

    public void addPurRequestEntry(PurRequestEntryCollection entrycol, PurRequestEntryInfo entry) {
        if (entry.getBaseStatus().getValue() == 4) {
            entrycol.add(entry);
        }
    }

    public void setBotpBeforeReturnMsg(Map orderCalMap, String error, String billtype, String number, String billstatus, PurRequestInfo newInfo, List<String> entryIdList) {
        Map entryMap = orderCalMap;
        if (newInfo.getEntries().size() == 0) {
            for (int i = 0; i < entryIdList.size(); ++i) {
                if (!entryMap.keySet().contains(entryIdList.get(i).toString())) continue;
                this.setPurInReturnMsg(entryMap, error, billtype, number, billstatus, entryIdList.get(i).toString());
            }
        } else {
            for (int i = 0; i < newInfo.getEntries().size(); ++i) {
                PurRequestEntryInfo entry = newInfo.getEntries().get(i);
                if (!entryMap.keySet().contains(entry.getId().toString())) continue;
                this.setPurInReturnMsg(entryMap, error, billtype, number, billstatus, entry.getId().toString());
            }
        }
    }

    public void setBotpAfterReturnMsg(Map orderCalMap, String error, String billtype, String number, String billstatus, PurOrderInfo newInfo) {
        Map entryMap = orderCalMap;
        for (int i = 0; i < newInfo.getEntries().size(); ++i) {
            PurOrderEntryInfo entry = newInfo.getEntries().get(i);
            if (!orderCalMap.keySet().contains(entry.getSourceBillEntryId().toString())) continue;
            this.setPurInReturnMsg(entryMap, error, billtype, number, billstatus, entry.getSourceBillEntryId().toString());
        }
    }

    public void setPurInReturnMsg(Map<String, Map<String, Object>> orderCalMap, String error, String billtype, String number, String billstatus, String id) {
        Map<String, Object> returnMsgMap = orderCalMap.get(id);
        HashMap<String, String> errMap = new HashMap<String, String>();
        errMap.put("error", error);
        errMap.put("billtype", billtype);
        errMap.put("billnumber", number);
        errMap.put("billstatus", billstatus);
        String souEntryId = returnMsgMap.get("souEntryId").toString();
        String souId = returnMsgMap.get("souBillId").toString();
        HashMap<String, HashMap<String, String>> souEntryMap = new HashMap<String, HashMap<String, String>>();
        souEntryMap.put(souEntryId, errMap);
        if (this.msgMap.get(souId) != null) {
            this.msgMap.get(souId).put(souEntryId, errMap);
        } else {
            this.msgMap.put(souId, souEntryMap);
        }
    }

    public void setEntryReturnMsg(Map<String, Map<String, Object>> orderCalMap, String error, String billtype, String number, String billstatus, String entryID) {
        if (orderCalMap.keySet().contains(entryID)) {
            Map<String, Object> returnMsgMap = orderCalMap.get(entryID);
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", error);
            errMap.put("billtype", billtype);
            errMap.put("billnumber", number);
            errMap.put("billstatus", billstatus);
            String souEntryId = returnMsgMap.get("souEntryId").toString();
            String souId = returnMsgMap.get("souBillId").toString();
            HashMap<String, HashMap<String, String>> souEntryMap = new HashMap<String, HashMap<String, String>>();
            souEntryMap.put(souEntryId, errMap);
            if (this.msgMap.get(souId) != null) {
                this.msgMap.get(souId).put(souEntryId, errMap);
            } else {
                this.msgMap.put(souId, souEntryMap);
            }
        }
    }

    private Object getBotpNumber(Map<String, Object> dataMap) {
        if (null == dataMap.get("botpNumber")) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "\u6ca1\u6709\u5bf9\u5e94\u7684BOTP\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5");
            errMap.put("billtype", "");
            errMap.put("billnumber", "");
            errMap.put("billstatus", "");
            HashMap<String, HashMap<String, String>> souEntryMap = new HashMap<String, HashMap<String, String>>();
            souEntryMap.put("error", errMap);
            this.msgMap.put("error", souEntryMap);
            return null;
        }
        Map newDataMap = (Map)dataMap.get("botpNumber");
        return newDataMap.get("botpNumber");
    }

    @Override
    protected String getInterfaceNumber() {
        return "NEXT_SouCompare_ToOrder_Rec";
    }

    private static Map<String, Object> getMaterialMap(Context ctx, Set<String> materialSet) throws BOSException {
        EntityViewInfo materialEv = ConvertUtil.convertNumSet2EVI(materialSet);
        MaterialCollection materialCollection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(materialEv);
        HashMap<String, Object> MaterialMap = new HashMap<String, Object>();
        if (materialCollection != null && materialCollection.size() > 0) {
            for (int i = 0; i < materialCollection.size(); ++i) {
                MaterialInfo materialInfo = materialCollection.get(i);
                String number = materialInfo.getNumber();
                MaterialMap.put(number, materialInfo);
            }
        }
        return MaterialMap;
    }

    private static Map<String, Object> getMeasureUnitMap(Context ctx, Set<String> unitSet) throws BOSException {
        EntityViewInfo unitEV = ConvertUtil.convertNumSet2EVI(unitSet);
        MeasureUnitCollection measureUnitCollection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(unitEV);
        HashMap<String, Object> measureUnitMap = new HashMap<String, Object>();
        if (measureUnitCollection != null && measureUnitCollection.size() > 0) {
            for (int i = 0; i < measureUnitCollection.size(); ++i) {
                MeasureUnitInfo measureUnitInfo = measureUnitCollection.get(i);
                String number = measureUnitInfo.getNumber();
                measureUnitMap.put(number, measureUnitInfo);
            }
        }
        return measureUnitMap;
    }

    private static Map<String, Object> getstorageOrgMap(Context ctx, Set<String> storageOrgSet) throws BOSException {
        EntityViewInfo storageOrgEV = ConvertUtil.convertNumSet2EVI(storageOrgSet);
        StorageOrgUnitCollection storageOrgUnitCollection = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(storageOrgEV);
        HashMap<String, Object> storageOrgMap = new HashMap<String, Object>();
        if (storageOrgUnitCollection != null && storageOrgUnitCollection.size() > 0) {
            for (int i = 0; i < storageOrgUnitCollection.size(); ++i) {
                StorageOrgUnitInfo storageOrgUnitInfo = storageOrgUnitCollection.get(i);
                String number = storageOrgUnitInfo.getNumber();
                storageOrgMap.put(number, storageOrgUnitInfo);
            }
        }
        return storageOrgMap;
    }

    private static Map<String, Object> getCurrencyMap(Context ctx, Set<String> currSet) throws BOSException {
        EntityViewInfo currEV = ConvertUtil.convertNumSet2EVI(currSet);
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(currEV);
        HashMap<String, Object> currMap = new HashMap<String, Object>();
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currencyInfo = currencyCollection.get(i);
                String number = currencyInfo.getNumber().toString();
                currMap.put(number, currencyInfo);
            }
        }
        return currMap;
    }

    private Map<String, Object> getPurchaseGroupMap(Context ctx, Set<String> purchaseGrooupSet) throws BOSException {
        EntityViewInfo purorgEV = ConvertUtil.convertNumSet2EVI(purchaseGrooupSet);
        PurchaseGroupCollection purchaseGroupCollection = PurchaseGroupFactory.getLocalInstance((Context)ctx).getPurchaseGroupCollection(purorgEV);
        HashMap<String, Object> purchaseGroupMap = new HashMap<String, Object>();
        if (purchaseGroupCollection != null && purchaseGroupCollection.size() > 0) {
            for (int i = 0; i < purchaseGroupCollection.size(); ++i) {
                PurchaseGroupInfo info = purchaseGroupCollection.get(i);
                String number = info.getNumber().toString();
                purchaseGroupMap.put(number, info);
            }
        }
        return purchaseGroupMap;
    }

    private BigDecimal getExchangeRate(Context ctx, PurchaseOrgUnitInfo purchaseInfo, ObjectUuidPK desCurrId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfoForPurchase = InvServerUtils.getCompanyInfoForPurchase((Context)ctx, (PurchaseOrgUnitInfo)purchaseInfo);
        CurrencyInfo baseCurrency = companyInfoForPurchase.getBaseCurrency();
        ObjectUuidPK ss = new ObjectUuidPK(baseCurrency.getId());
        if (ss.toString().equals(desCurrId.toString())) {
            return BigDecimal.ONE;
        }
        ExchangeRateInfo exchangeRate = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)companyInfoForPurchase, (IObjectPK)desCurrId, (IObjectPK)ss);
        if (exchangeRate == null) {
            throw new BOSException("\u5728EAS\u6ca1\u6709\u7ef4\u62a4\u5bf9\u5e94\u5e01\u522b\u7684\u6c47\u7387");
        }
        return exchangeRate.getConvertRate();
    }
}

