/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.fromeip.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.sm.sc.MaterialPurchaseTypeEnum;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.CreatTypeEnum;
import com.kingdee.eas.basedata.scm.sm.srm.IApprovedSupplier;
import com.kingdee.eas.basedata.scm.sm.srm.ISupplyInfo;
import com.kingdee.eas.basedata.scm.sm.srm.IsUseableEnum;
import com.kingdee.eas.basedata.scm.sm.srm.SharePriceCtrlStrategyEnum;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.nsrm.app.fromeip.AbstractReceiveHandler;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SouCompareUpdateSupplierPriceReceive
extends AbstractReceiveHandler {
    private static Logger logger = Logger.getLogger(SouCompareUpdateSupplierPriceReceive.class);

    @Override
    public Object handleReceive(Context ctx, Object data) throws Exception {
        logger.error((Object)("\u4e0a\u4e0b\u6587\u7528\u6237id=" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        HashMap<String, Map<String, String>> msgMap = new HashMap<String, Map<String, String>>();
        if (msgMap != null) {
            msgMap.clear();
        }
        Map retMap = ConvertUtil.convertJsonToMap(ctx, data);
        Map returnData = (Map)retMap.get("data");
        this.dealData(ctx, returnData, msgMap);
        JSONObject jsonObject = JSONObject.fromObject(msgMap);
        return jsonObject.toString();
    }

    private void dealData(Context ctx, Map returnData, Map<String, Map<String, String>> msgMap) throws EASBizException, BOSException {
        Map dataMap = returnData;
        Set compareIdSet = dataMap.keySet();
        HashSet<String> unitSet = new HashSet<String>();
        HashSet<String> materialGroupSet = new HashSet<String>();
        HashSet<String> userSet = new HashSet<String>();
        HashSet<String> supplierSet = new HashSet<String>();
        HashSet<String> materialSet = new HashSet<String>();
        HashSet<String> purOrgSet = new HashSet<String>();
        HashSet<String> recOrgSet = new HashSet<String>();
        HashSet<String> bizTypeSet = new HashSet<String>();
        HashSet<String> assistPropertySet = new HashSet<String>();
        HashSet<String> curSet = new HashSet<String>();
        for (String key : compareIdSet) {
            Map billMap = (Map)dataMap.get(key);
            Map entrydataMap = (Map)billMap.get("entry");
            if (billMap.get("purorg") != null) {
                String payorg = billMap.get("purorg").toString();
                purOrgSet.add(payorg);
            }
            if (billMap.get("biztype") != null) {
                String bizType = billMap.get("biztype").toString();
                bizTypeSet.add(bizType);
            }
            if (billMap.get("settlecurr") != null) {
                String cur = billMap.get("settlecurr").toString();
                curSet.add(cur);
            }
            for (String souid : entrydataMap.keySet()) {
                Map detailDataMap = (Map)entrydataMap.get(souid);
                if (detailDataMap.get("purorg") != null) {
                    String payorg = detailDataMap.get("purorg").toString();
                    purOrgSet.add(payorg);
                }
                if (detailDataMap.get("recorg") != null) {
                    recOrgSet.add(detailDataMap.get("recorg").toString());
                }
                if (detailDataMap.get("unit") != null) {
                    String unit = detailDataMap.get("unit").toString();
                    unitSet.add(unit);
                }
                if (detailDataMap.get("material") != null) {
                    String matreial = detailDataMap.get("material").toString();
                    materialSet.add(matreial);
                }
                if (detailDataMap.get("materialgroup") != null) {
                    String materialGroup = detailDataMap.get("materialgroup").toString();
                    materialGroupSet.add(materialGroup);
                }
                if (detailDataMap.get("supplier") != null) {
                    String supplier = detailDataMap.get("supplier").toString();
                    supplierSet.add(supplier);
                }
                if (detailDataMap.get("user") != null) {
                    String user = detailDataMap.get("user").toString();
                    String[] userArr = user.split("+");
                    userSet.add(userArr[0]);
                    userSet.add(userArr[1]);
                }
                if (detailDataMap.get("basicUnit") != null) {
                    String baseunit = detailDataMap.get("basicUnit").toString();
                    unitSet.add(baseunit);
                }
                if (detailDataMap.get("assistProperty") != null) {
                    String assistproperty = detailDataMap.get("assistProperty").toString();
                    assistPropertySet.add(assistproperty);
                }
                if (billMap.get("purorg") != null) {
                    detailDataMap.put("purorg", billMap.get("purorg").toString());
                }
                if (billMap.get("biztype") != null) {
                    detailDataMap.put("biztype", billMap.get("biztype").toString());
                }
                if (billMap.get("settlecurr") == null) continue;
                detailDataMap.put("settlecurr", billMap.get("settlecurr").toString());
            }
        }
        EntityViewInfo purorgEV = ConvertUtil.convertNumSet2EVI(purOrgSet);
        PurchaseOrgUnitCollection purchaseOrgUnitCollection = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitCollection(purorgEV);
        HashMap<String, PurchaseOrgUnitInfo> payOrgMap = new HashMap<String, PurchaseOrgUnitInfo>();
        if (purchaseOrgUnitCollection != null && purchaseOrgUnitCollection.size() > 0) {
            for (int i = 0; i < purchaseOrgUnitCollection.size(); ++i) {
                PurchaseOrgUnitInfo purchaseOrgUnitInfo = purchaseOrgUnitCollection.get(i);
                String number = purchaseOrgUnitInfo.getNumber().toString();
                payOrgMap.put(number, purchaseOrgUnitInfo);
            }
        }
        EntityViewInfo recOrgEn = ConvertUtil.convertNumSet2EVI(recOrgSet);
        StorageOrgUnitCollection storageOrgColl = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(recOrgEn);
        HashMap<String, StorageOrgUnitInfo> recOrgMap = new HashMap<String, StorageOrgUnitInfo>();
        if (storageOrgColl != null && storageOrgColl.size() > 0) {
            for (int i = 0; i < storageOrgColl.size(); ++i) {
                StorageOrgUnitInfo purchaseOrgUnitInfo = storageOrgColl.get(i);
                String number = purchaseOrgUnitInfo.getNumber().toString();
                recOrgMap.put(number, purchaseOrgUnitInfo);
            }
        }
        EntityViewInfo curEV = ConvertUtil.convertNumSet2EVI(curSet);
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(curEV);
        HashMap<String, CurrencyInfo> curMap = new HashMap<String, CurrencyInfo>();
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo info = currencyCollection.get(i);
                String number = info.getNumber().toString();
                curMap.put(number, info);
            }
        }
        EntityViewInfo unitEV = ConvertUtil.convertNumSet2EVI(unitSet);
        MeasureUnitCollection measureUnitCollection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(unitEV);
        HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
        if (measureUnitCollection != null && measureUnitCollection.size() > 0) {
            for (int i = 0; i < measureUnitCollection.size(); ++i) {
                MeasureUnitInfo measureUnitInfo = measureUnitCollection.get(i);
                String number = measureUnitInfo.getNumber().toString();
                unitMap.put(number, measureUnitInfo);
            }
        }
        EntityViewInfo materialEV = ConvertUtil.convertNumSet2EVI(materialSet);
        MaterialCollection materialCollection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(materialEV);
        HashMap<String, MaterialInfo> materialMap = new HashMap<String, MaterialInfo>();
        if (materialCollection != null && materialCollection.size() > 0) {
            for (int i = 0; i < materialCollection.size(); ++i) {
                MaterialInfo materialInfo = materialCollection.get(i);
                String number = materialInfo.getNumber().toString();
                materialMap.put(number, materialInfo);
            }
        }
        EntityViewInfo materialgroupEV = ConvertUtil.convertNumSet2EVI(materialGroupSet);
        MaterialGroupCollection materialGroupCollection = MaterialGroupFactory.getLocalInstance((Context)ctx).getMaterialGroupCollection(materialgroupEV);
        HashMap<String, MaterialGroupInfo> materialGroupMap = new HashMap<String, MaterialGroupInfo>();
        if (materialGroupCollection != null && materialGroupCollection.size() > 0) {
            for (int i = 0; i < materialGroupCollection.size(); ++i) {
                MaterialGroupInfo materialGroupInfo = materialGroupCollection.get(i);
                String number = materialGroupInfo.getNumber().toString();
                materialGroupMap.put(number, materialGroupInfo);
            }
        }
        EntityViewInfo supplierEV = ConvertUtil.convertNumSet2EVI(supplierSet);
        SupplierCollection supplierCollection = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(supplierEV);
        HashMap<String, SupplierInfo> supplierMap = new HashMap<String, SupplierInfo>();
        if (supplierCollection != null && supplierCollection.size() > 0) {
            for (int i = 0; i < supplierCollection.size(); ++i) {
                SupplierInfo supplierInfo = supplierCollection.get(i);
                String number = supplierInfo.getNumber().toString();
                supplierMap.put(number, supplierInfo);
            }
        }
        EntityViewInfo userEV = ConvertUtil.convertNumSet2EVI(userSet);
        UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(userEV);
        HashMap<String, UserInfo> userMap = new HashMap<String, UserInfo>();
        if (userCollection != null && userCollection.size() > 0) {
            for (int i = 0; i < userCollection.size(); ++i) {
                UserInfo userInfo = userCollection.get(i);
                String number = userInfo.getNumber().toString();
                userMap.put(number, userInfo);
            }
        }
        EntityViewInfo biztypeEV = ConvertUtil.convertNumSet2EVI(bizTypeSet);
        BizTypeCollection biztypeCollection = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeCollection(biztypeEV);
        HashMap<String, BizTypeInfo> biztypeMap = new HashMap<String, BizTypeInfo>();
        if (biztypeCollection != null && biztypeCollection.size() > 0) {
            for (int i = 0; i < biztypeCollection.size(); ++i) {
                BizTypeInfo bizTypeInfo = biztypeCollection.get(i);
                String number = bizTypeInfo.getNumber().toString();
                biztypeMap.put(number, bizTypeInfo);
            }
        }
        EntityViewInfo assistPropertyEV = ConvertUtil.convertNumSet2EVI(bizTypeSet);
        AsstAttrValueCollection asstAttrValueCollection = AsstAttrValueFactory.getLocalInstance((Context)ctx).getAsstAttrValueCollection(assistPropertyEV);
        HashMap<String, AsstAttrValueInfo> assistPropertyMap = new HashMap<String, AsstAttrValueInfo>();
        if (asstAttrValueCollection != null && asstAttrValueCollection.size() > 0) {
            for (int i = 0; i < asstAttrValueCollection.size(); ++i) {
                AsstAttrValueInfo asstAttrValueInfo = asstAttrValueCollection.get(i);
                String number = asstAttrValueInfo.getNumber().toString();
                assistPropertyMap.put(number, asstAttrValueInfo);
            }
        }
        for (String key : compareIdSet) {
            Map billMap = (Map)dataMap.get(key);
            Map entrydataMap = (Map)billMap.get("entry");
            for (String souid : entrydataMap.keySet()) {
                String unit;
                Map detailDataMap = (Map)entrydataMap.get(souid);
                detailDataMap.put("taxtype", billMap.get("taxtype"));
                if (detailDataMap.get("purorg") != null) {
                    String payorg = detailDataMap.get("purorg").toString();
                    if (payOrgMap.get(payorg) == null) {
                        detailDataMap.put("purOrgUnitError", "\u91c7\u8d2d\u7ec4\u7ec7\u7f16\u7801:" + payorg + "\u5728EAS\u4e0d\u5b58\u5728!");
                    }
                    detailDataMap.put("purorg", payOrgMap.get(payorg));
                }
                if (detailDataMap.get("recorg") != null) {
                    String recOrg = detailDataMap.get("recorg").toString();
                    if (recOrgMap.get(recOrg) == null) {
                        detailDataMap.put("recOrgError", "\u6536\u8d27\u7ec4\u7ec7\u7f16\u7801:" + recOrg + "\u5728EAS\u4e0d\u5b58\u5728!");
                    }
                    detailDataMap.put("recorg", recOrgMap.get(recOrg));
                }
                if (detailDataMap.get("unit") != null) {
                    unit = detailDataMap.get("unit").toString();
                    if (unitMap.get(unit) == null) {
                        detailDataMap.put("unitError", "\u8ba1\u91cf\u5355\u4f4d\u7f16\u7801:" + unit + "\u5728EAS\u4e0d\u5b58\u5728!");
                    }
                    detailDataMap.put("unit", unitMap.get(unit));
                }
                if (detailDataMap.get("basicUnit") != null) {
                    unit = detailDataMap.get("basicUnit").toString();
                    detailDataMap.put("basicUnit", unitMap.get(unit));
                }
                if (detailDataMap.get("biztype") != null) {
                    String biztype = detailDataMap.get("biztype").toString();
                    detailDataMap.put("biztype", biztypeMap.get(biztype));
                }
                if (detailDataMap.get("material") != null) {
                    String material = detailDataMap.get("material").toString();
                    if (materialMap.get(material) == null) {
                        detailDataMap.put("materialError", "\u7269\u6599\u7f16\u7801:" + material + " \u5728EAS\u4e2d\u4e0d\u5b58\u5728");
                    }
                    detailDataMap.put("material", materialMap.get(material));
                }
                if (detailDataMap.get("materialgroup") != null) {
                    String materialGroup = detailDataMap.get("materialgroup").toString();
                    detailDataMap.put("materialgroup", materialGroupMap.get(materialGroup));
                }
                if (detailDataMap.get("supplier") != null) {
                    String supplier = detailDataMap.get("supplier").toString();
                    if (supplierMap.get(supplier) == null) {
                        detailDataMap.put("supplierError", "\u4f9b\u5e94\u5546\u7f16\u7801:" + supplier + "\u5728EAS\u4e0d\u5b58\u5728\uff01");
                    }
                    detailDataMap.put("supplier", supplierMap.get(supplier));
                }
                if (detailDataMap.get("settlecurr") != null) {
                    String cur = detailDataMap.get("settlecurr").toString();
                    if (curMap.get(cur) == null) {
                        detailDataMap.put("currError", "\u5e01\u522b\u7f16\u7801:" + cur + "\u5728EAS\u4e0d\u5b58\u5728");
                    }
                    detailDataMap.put("settlecurr", curMap.get(cur));
                }
                if (detailDataMap.get("user") != null) {
                    String user = detailDataMap.get("user").toString();
                    String[] userArr = user.split("+");
                    if (userMap.get(userArr[0]) != null) {
                        detailDataMap.put("user", userMap.get(userArr[0]));
                    } else {
                        detailDataMap.put("user", userMap.get(userArr[1]));
                    }
                }
                String entryId = souid;
                try {
                    String supplierPriceId = this.GeneralSupplierPrice(ctx, detailDataMap);
                    String approedSupplierId = this.GeneralApprovedSupplier(ctx, detailDataMap);
                    this.setReturnMsg(entryId, "200", "", msgMap);
                    msgMap.get(entryId).put("supplierPriceId", supplierPriceId);
                    msgMap.get(entryId).put("approedSupplierId", approedSupplierId);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    this.setReturnMsg(entryId, "500", e.getMessage(), msgMap);
                }
            }
        }
    }

    private void setReturnMsg(String entryId, String status, String message, Map<String, Map<String, String>> msgMap) {
        HashMap<String, String> detailMsg = new HashMap<String, String>();
        detailMsg.put("status", status);
        detailMsg.put("error", message);
        msgMap.put(entryId, detailMsg);
    }

    @Override
    public Object handleOriginal(Context ctx, Object data) throws Exception {
        return super.handleOriginal(ctx, data);
    }

    private String GeneralSupplierPrice(Context ctx, Map<String, Object> detailDataMap) throws EASBizException, BOSException {
        String taxtype;
        String toStr;
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)detailDataMap.get("purorg");
        MaterialInfo materialInfo = (MaterialInfo)detailDataMap.get("material");
        SupplierInfo supplierInfo = (SupplierInfo)detailDataMap.get("supplier");
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)detailDataMap.get("unit");
        BizTypeInfo bizTypeInfo = (BizTypeInfo)detailDataMap.get("biztype");
        CurrencyInfo currencyInfo = (CurrencyInfo)detailDataMap.get("settlecurr");
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)detailDataMap.get("basicUnit");
        AsstAttrValueInfo asstAttrValueInfo = (AsstAttrValueInfo)detailDataMap.get("assistProperty");
        UserInfo userinfo = (UserInfo)detailDataMap.get("user");
        StorageOrgUnitInfo recOrg = (StorageOrgUnitInfo)detailDataMap.get("recorg");
        if (null == userinfo) {
            userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        toStr = !StringUtil.isEmpty((String)(toStr = (String)detailDataMap.get("dateto"))) ? toStr + " 23:59:59" : "2050-01-01 23:59:59";
        String fromStr = (String)detailDataMap.get("datefrom");
        if (!StringUtil.isEmpty((String)fromStr)) {
            fromStr = fromStr + " 00:00:00";
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            fromStr = sdf.format(new Date());
        }
        BigDecimal fromQty = BigDecimal.ZERO;
        BigDecimal qtyTo = BigDecimal.ZERO;
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal taxprice = BigDecimal.ZERO;
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal minOrderQty = BigDecimal.ZERO;
        BigDecimal purLeadDay = BigDecimal.ZERO;
        if (detailDataMap.get("price") != null) {
            price = new BigDecimal(String.valueOf(detailDataMap.get("price")));
        }
        if (detailDataMap.get("discountRate") != null) {
            discount = new BigDecimal(String.valueOf(detailDataMap.get("discountRate")));
        }
        if (detailDataMap.get("confirmtaxprice") != null) {
            taxprice = new BigDecimal(String.valueOf(detailDataMap.get("confirmtaxprice")));
        }
        if (detailDataMap.get("taxrate") != null) {
            taxRate = new BigDecimal(String.valueOf(detailDataMap.get("taxrate")));
        }
        if (detailDataMap.get("qtyFrom") != null) {
            fromQty = new BigDecimal(String.valueOf(detailDataMap.get("qtyFrom")));
        }
        if (detailDataMap.get("qtyTo") != null) {
            qtyTo = new BigDecimal(String.valueOf(detailDataMap.get("qtyTo")));
        }
        if (detailDataMap.get("minorderqty") != null) {
            minOrderQty = new BigDecimal(String.valueOf(detailDataMap.get("minorderqty")));
        }
        if (detailDataMap.get("purleadday") != null) {
            purLeadDay = new BigDecimal(String.valueOf(detailDataMap.get("purleadday")));
        }
        if (materialInfo == null) {
            throw new BOSException(detailDataMap.get("materialError") + "");
        }
        ArrayList supplyInfoList = new ArrayList();
        SupplyInfoInfo suppPriceInfo = new SupplyInfoInfo();
        boolean isHasSupplierPrice = false;
        ISupplyInfo iSuppInfo = SupplyInfoFactory.getLocalInstance((Context)ctx);
        SupplyInfoInfo oldSuppPriceInfo = new SupplyInfoInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (purchaseOrgUnitInfo == null) {
            throw new BOSException(detailDataMap.get("purOrgUnitError").toString());
        }
        if (supplierInfo == null) {
            throw new BOSException(detailDataMap.get("supplierError").toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrg", (Object)purchaseOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplier", (Object)supplierInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialItem", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        if (this.isSubContractBillData(bizTypeInfo)) {
            filter.getFilterItems().add(new FilterItemInfo("materialPurchaseType", (Object)"1", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("materialPurchaseType", (Object)"0", CompareType.EQUALS));
        }
        if (measureUnitInfo == null) {
            throw new BOSException(detailDataMap.get("unitError").toString());
        }
        if (currencyInfo == null) {
            throw new BOSException(detailDataMap.get("currError").toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("purMeasureUnit.id", (Object)measureUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)fromStr, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)toStr, CompareType.EQUALS));
        if (fromQty != null) {
            filter.getFilterItems().add(new FilterItemInfo("fromQty", (Object)fromQty.toPlainString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fromQty", null, CompareType.EQUALS));
        }
        if (asstAttrValueInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("assistProperty", (Object)asstAttrValueInfo.getId().toString(), CompareType.EQUALS));
        }
        if (currencyInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyInfo.getId().toString(), CompareType.EQUALS));
        }
        if (recOrg == null) {
            filter.getFilterItems().add(new FilterItemInfo("recOrg", null, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("recOrg", (Object)recOrg.getId().toString(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.setSelector(SCMSelectorFactory.getSupplyInfoSelector());
        SupplyInfoCollection collection = iSuppInfo.getSupplyInfoCollection(view);
        if (collection != null && collection.size() > 0 && (oldSuppPriceInfo = collection.get(0)) != null) {
            isHasSupplierPrice = true;
        }
        UserInfo user = userinfo;
        Date today = new Date();
        if (!isHasSupplierPrice) {
            suppPriceInfo.setId(BOSUuid.create((String)BOSObjectType.create((String)"6584F9A8").toString()));
            suppPriceInfo.setPurchaseOrg(purchaseOrgUnitInfo);
            suppPriceInfo.setSupplier(supplierInfo);
            if (materialInfo != null) {
                suppPriceInfo.setMaterialItem(materialInfo);
                suppPriceInfo.setMeasureUnit(materialInfo.getBaseUnit());
            }
            suppPriceInfo.setPurMeasureUnit(measureUnitInfo);
            suppPriceInfo.setEffectualDate((Date)Timestamp.valueOf(fromStr));
            suppPriceInfo.setUneffectualDate((Date)Timestamp.valueOf(toStr));
            suppPriceInfo.setQtyOrderBottom(minOrderQty);
            suppPriceInfo.setFromQty(minOrderQty);
            suppPriceInfo.setQtyOrderTop(BigDecimal.ZERO);
            suppPriceInfo.setMaxPrice(BigDecimal.ZERO);
            suppPriceInfo.setMinPrice(BigDecimal.ZERO);
            suppPriceInfo.setLeadtime(purLeadDay.intValue());
            if (qtyTo != null) {
                suppPriceInfo.setToQty(qtyTo);
            }
            if ("1".equals(taxtype = (String)detailDataMap.get("taxtype"))) {
                suppPriceInfo.setIsTaxPrice(true);
            } else if ("3".equals(taxtype)) {
                suppPriceInfo.setIsTaxPrice(true);
            } else if ("2".equals(taxtype)) {
                suppPriceInfo.setIsTaxPrice(false);
            }
            suppPriceInfo.put("taxRate", (Object)taxRate);
            if (suppPriceInfo.isIsTaxPrice()) {
                suppPriceInfo.setPrice(taxprice);
            } else {
                suppPriceInfo.setPrice(price);
            }
            suppPriceInfo.setPrice(this.getActPriceForSupplier(ctx, detailDataMap, suppPriceInfo.getPrice()));
            suppPriceInfo.setDiscountRate(discount);
            suppPriceInfo.setLastPrice(BigDecimal.ZERO);
            suppPriceInfo.setLastPurTime(null);
            suppPriceInfo.setIsUseable(IsUseableEnum.Useable);
            logger.error((Object)("user\u4e0a\u4e0b\u6587\u7528\u6237id=" + user.getId().toString()));
            suppPriceInfo.setCreator(user);
            suppPriceInfo.setCreateTime(new Timestamp(today.getTime()));
            suppPriceInfo.setLastUpdateUser(user);
            suppPriceInfo.setLastUpdateTime(new Timestamp(today.getTime()));
            suppPriceInfo.setAuditor(user);
            suppPriceInfo.setAuditDate((Date)new Timestamp(today.getTime()));
            suppPriceInfo.setRecOrg(recOrg);
        } else {
            suppPriceInfo = oldSuppPriceInfo;
            taxtype = (String)detailDataMap.get("taxtype");
            if ("1".equals(taxtype)) {
                suppPriceInfo.setIsTaxPrice(true);
            } else if ("3".equals(taxtype)) {
                suppPriceInfo.setIsTaxPrice(true);
            } else if ("2".equals(taxtype)) {
                suppPriceInfo.setIsTaxPrice(false);
            }
            suppPriceInfo.put("taxRate", (Object)taxRate);
            if (suppPriceInfo.isIsTaxPrice()) {
                suppPriceInfo.setPrice(taxprice);
            } else {
                suppPriceInfo.setPrice(price);
            }
            suppPriceInfo.setPrice(this.getActPriceForSupplier(ctx, detailDataMap, suppPriceInfo.getPrice()));
            suppPriceInfo.setEffectualDate((Date)Timestamp.valueOf(fromStr));
            suppPriceInfo.setUneffectualDate((Date)Timestamp.valueOf(toStr));
            suppPriceInfo.setIsUseable(IsUseableEnum.Useable);
            user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            suppPriceInfo.setCreator(user);
            suppPriceInfo.setCreateTime(new Timestamp(today.getTime()));
            suppPriceInfo.setLastUpdateUser(user);
            suppPriceInfo.setLastUpdateTime(new Timestamp(today.getTime()));
            suppPriceInfo.setAuditor(user);
            suppPriceInfo.setAuditDate((Date)new Timestamp(today.getTime()));
            suppPriceInfo.setQtyOrderBottom(minOrderQty);
            suppPriceInfo.setFromQty(minOrderQty);
            if (qtyTo != null) {
                suppPriceInfo.setToQty(qtyTo);
            }
            suppPriceInfo.setDiscountRate(discount);
        }
        if (this.isSubContractBillData(bizTypeInfo)) {
            suppPriceInfo.setMaterialPurchaseType(MaterialPurchaseTypeEnum.SUBCONTRACT);
        } else {
            suppPriceInfo.setMaterialPurchaseType(MaterialPurchaseTypeEnum.PURCHASE);
        }
        if (asstAttrValueInfo != null) {
            suppPriceInfo.setAssistProperty(asstAttrValueInfo);
        }
        if (currencyInfo != null) {
            suppPriceInfo.setCurrency(currencyInfo);
        }
        if (null != detailDataMap.get("seq")) {
            suppPriceInfo.setSourceBillEntrySeq(Integer.valueOf(detailDataMap.get("seq").toString()).intValue());
        }
        if (null != detailDataMap.get("number")) {
            suppPriceInfo.setSourceBillNo(detailDataMap.get("number").toString());
        }
        if (null != detailDataMap.get("billtype")) {
            String billType = detailDataMap.get("billtype").toString();
            int priceSource = 5;
            if ("sou_bidbillcfm".equals(billType)) {
                priceSource = 6;
            } else if ("src_contract".equals(billType)) {
                priceSource = 7;
            }
            suppPriceInfo.setInt("PriceSource", priceSource);
        }
        suppPriceInfo.setCreatePurchaseOrg(suppPriceInfo.getPurchaseOrg());
        suppPriceInfo.setPriceCtrlStrategy(SharePriceCtrlStrategyEnum.NO_CTRL);
        if (!isHasSupplierPrice) {
            iSuppInfo.addnew(suppPriceInfo);
        } else {
            iSuppInfo.update((IObjectPK)new ObjectUuidPK(suppPriceInfo.getId()), suppPriceInfo);
        }
        return suppPriceInfo.getId().toString();
    }

    private boolean IsInActiveWorkFlow(Context ctx, String keyIDs) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo instInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(keyIDs);
        int n = procInsts.length;
        for (int j = 0; j < n; ++j) {
            if (!"open.running".equals(procInsts[j].getState())) continue;
            instInfo = procInsts[j];
        }
        return instInfo != null;
    }

    private BigDecimal getActPriceForSupplier(Context ctx, Map<String, Object> detailDataMap, BigDecimal oldPrice) throws EASBizException, BOSException {
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)detailDataMap.get("purorg");
        SupplierInfo supplierInfo = (SupplierInfo)detailDataMap.get("supplier");
        CurrencyInfo currencyInfo = (CurrencyInfo)detailDataMap.get("currency");
        ISupplier supplier = SupplierFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK supplierPK = new ObjectUuidPK(supplierInfo.getId());
        SupplierCompanyInfoInfo supplierCompanyInfoInfo = null;
        CurrencyInfo billCurrencyInfo = null;
        CurrencyInfo supplierCurrencyInfo = null;
        billCurrencyInfo = currencyInfo;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(purchaseOrgUnitInfo.getId().toString(), 3, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(purchaseOrgUnitInfo.getId().toString(), 3, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        ObjectUuidPK companyOrgUnitPK = new ObjectUuidPK(ret.getId());
        SelectorItemCollection supplierCompanyInfoSelector = new SelectorItemCollection();
        supplierCompanyInfoSelector.add(new SelectorItemInfo("settlementCurrency.id"));
        supplierCompanyInfoInfo = supplier.getCompanyInfo((IObjectPK)supplierPK, (IObjectPK)companyOrgUnitPK, supplierCompanyInfoSelector);
        if (supplierCompanyInfoInfo != null) {
            supplierCurrencyInfo = supplierCompanyInfoInfo.getSettlementCurrency();
        }
        if (billCurrencyInfo != null && supplierCurrencyInfo != null && billCurrencyInfo.getId() != supplierCurrencyInfo.getId()) {
            BigDecimal actPrice = oldPrice;
            if (oldPrice.compareTo(actPrice = this.exchangeRateChangeForSupplier(ctx, ret, supplierCurrencyInfo, billCurrencyInfo, actPrice)) != 0) {
                oldPrice = actPrice;
            }
        }
        return oldPrice;
    }

    private BigDecimal exchangeRateChangeForSupplier(Context ctx, CompanyOrgUnitInfo companyOrgInfo, CurrencyInfo currencyInfo, CurrencyInfo baseCurrForSupplierInfo, BigDecimal actPrice) throws EASBizException, BOSException {
        BigDecimal ONE = new BigDecimal("1.00");
        int DEFAULTPRECISION = 2;
        if (currencyInfo == null) {
            return actPrice;
        }
        ExchangeRateInfo exchangeRateForSupplierInfo = null;
        BigDecimal exchangeRate = ONE;
        int exchangeRatePrecision = DEFAULTPRECISION;
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(currencyInfo.getId());
        ObjectUuidPK destCurrPK = new ObjectUuidPK(baseCurrForSupplierInfo.getId());
        exchangeRateForSupplierInfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)companyOrgInfo, (IObjectPK)destCurrPK, (IObjectPK)sourceCurrPK);
        if (exchangeRateForSupplierInfo != null) {
            exchangeRate = exchangeRateForSupplierInfo.getConvertRate();
            exchangeRatePrecision = exchangeRateForSupplierInfo.getPrecision();
            actPrice = exchangeRateForSupplierInfo == null || exchangeRateForSupplierInfo.getConvertMode().getValue() == 1 ? actPrice.divide(exchangeRate, exchangeRatePrecision, 4) : actPrice.multiply(exchangeRate).setScale(exchangeRatePrecision, 4);
        }
        return actPrice;
    }

    private boolean isSubContractBillData(BizTypeInfo info) {
        boolean isSub = false;
        if (info != null && info.getId() != null && "1x7KMBq4mUmpj58T4jNPqiQHQ1w=".equals(info.getId().toString())) {
            isSub = true;
        }
        return isSub;
    }

    private String GeneralApprovedSupplier(Context ctx, Map<String, Object> detailDataMap) throws BOSException, EASBizException {
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)detailDataMap.get("purorg");
        MaterialInfo materialInfo = (MaterialInfo)detailDataMap.get("material");
        MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)detailDataMap.get("materialgroup");
        SupplierInfo supplierInfo = (SupplierInfo)detailDataMap.get("supplier");
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)detailDataMap.get("unit");
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal expiryDate = BigDecimal.ZERO;
        BigDecimal purAdvance = BigDecimal.ZERO;
        BigDecimal minOrderQty = BigDecimal.ZERO;
        BigDecimal purLeadDay = BigDecimal.ZERO;
        if (detailDataMap.get("taxrate") != null) {
            taxRate = new BigDecimal(String.valueOf(detailDataMap.get("taxrate")));
        }
        if (detailDataMap.get("expiryDate") != null) {
            expiryDate = new BigDecimal(String.valueOf(detailDataMap.get("expiryDate")));
        }
        if (detailDataMap.get("purAdvance") != null) {
            purAdvance = new BigDecimal(String.valueOf(detailDataMap.get("purAdvance")));
        }
        if (detailDataMap.get("minorderqty") != null) {
            minOrderQty = new BigDecimal(String.valueOf(detailDataMap.get("minorderqty")));
        }
        if (detailDataMap.get("purleadday") != null) {
            purLeadDay = new BigDecimal(String.valueOf(detailDataMap.get("purleadday")));
        }
        ApprovedSupplierCollection ApprovedSupColl = null;
        ApprovedSupColl = new ApprovedSupplierCollection();
        ApprovedSupplierInfo approveSupp = new ApprovedSupplierInfo();
        boolean isHasApprovedSupplier = false;
        IApprovedSupplier iAS = ApprovedSupplierFactory.getLocalInstance((Context)ctx);
        String materialID = null;
        String materialGroupID = null;
        if (materialInfo != null) {
            materialID = materialInfo.getId().toString();
        }
        if (materialGroupInfo != null) {
            materialGroupID = materialGroupInfo.getId().toString();
        }
        ApprovedSupplierInfo oldApproveSupp = new ApprovedSupplierInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (purchaseOrgUnitInfo == null) {
            throw new BOSException(detailDataMap.get("purOrgUnitError").toString());
        }
        if (supplierInfo == null) {
            throw new BOSException(detailDataMap.get("supplierError").toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)purchaseOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierInfo.getId().toString(), CompareType.EQUALS));
        if (materialID != null && materialID.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)materialID, CompareType.EQUALS));
        }
        if (materialGroupID != null && materialGroupID.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("materialGroup1.id", (Object)materialGroupID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("purchaseOrg.name");
        selector.add("purchaseOrg.number");
        selector.add("materialItem.name");
        selector.add("materialItem.number");
        selector.add("supplier.name");
        selector.add("supplier.number");
        selector.add("isUseable");
        selector.add("materialAttr");
        selector.add("creatType");
        view.setSelector(selector);
        ApprovedSupplierCollection collection = iAS.getApprovedSupplierCollection(view);
        if (collection != null && collection.size() >= 1) {
            oldApproveSupp = collection.get(0);
            isHasApprovedSupplier = true;
        } else {
            isHasApprovedSupplier = false;
        }
        if (!isHasApprovedSupplier) {
            approveSupp.setId(BOSUuid.create((String)BOSObjectType.create((String)"30690305").toString()));
        } else {
            approveSupp = oldApproveSupp;
        }
        approveSupp.setPurchaseOrg(purchaseOrgUnitInfo);
        approveSupp.setSupplier(supplierInfo);
        if (materialInfo != null) {
            approveSupp.setMaterialItem(materialInfo);
        }
        if (materialGroupInfo != null) {
            approveSupp.setMaterialGroup1(materialGroupInfo);
        }
        approveSupp.setExpiryDate(expiryDate.intValue());
        approveSupp.setLeadtime(purLeadDay.intValue());
        if (taxRate != null) {
            approveSupp.setTaxRate(taxRate);
        }
        approveSupp.setPurMeasureUnit(measureUnitInfo);
        approveSupp.setQtyOrderBottom(minOrderQty);
        approveSupp.setQtyOrderTop(PurUtil.MAXVAL);
        if (purchaseOrgUnitInfo != null) {
            IMaterialPurchasing ima = MaterialPurchasingFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("daysDelay"));
            sic.add(new SelectorItemInfo("daydAhead"));
            sic.add(new SelectorItemInfo("receiveBottomRatio"));
            sic.add(new SelectorItemInfo("receiveTopRatio"));
            sic.add(new SelectorItemInfo("isNotControlQty"));
            sic.add(new SelectorItemInfo("isNotControlTime"));
            viewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)purchaseOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            MaterialPurchasingCollection con = ima.getMaterialPurchasingCollection(viewInfo);
            MaterialPurchasingInfo mpInfo = null;
            if (con.size() > 0) {
                mpInfo = con.get(0);
            }
            if (mpInfo != null) {
                approveSupp.setDayBottom(new BigDecimal(mpInfo.getDaysDelay()));
                approveSupp.setDayTop(new BigDecimal(mpInfo.getDaydAhead()));
                approveSupp.setQtySupplyBottom(new BigDecimal(mpInfo.getReceiveBottomRatio()));
                approveSupp.setQtySupplyTop(new BigDecimal(mpInfo.getReceiveTopRatio()));
                if (mpInfo.isIsNotControlQty()) {
                    approveSupp.setQuantityUnCtrl(Boolean.TRUE.booleanValue());
                } else {
                    approveSupp.setQuantityUnCtrl(Boolean.FALSE.booleanValue());
                }
                if (mpInfo.isIsNotControlTime()) {
                    approveSupp.setTimeUnCtrl(Boolean.TRUE.booleanValue());
                } else {
                    approveSupp.setTimeUnCtrl(Boolean.FALSE.booleanValue());
                }
            }
        }
        approveSupp.setIsUseable(IsUseableEnum.Useable);
        UserInfo user = (UserInfo)detailDataMap.get("user");
        if (null == detailDataMap.get("user")) {
            user = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        logger.error((Object)("user\u4e0a\u4e0b\u6587\u7528\u6237id=" + user.getId().toString()));
        Date today = new Date();
        approveSupp.setCreator(user);
        approveSupp.setCreateTime(new Timestamp(today.getTime()));
        approveSupp.setLastUpdateUser(user);
        approveSupp.setLastUpdateTime(new Timestamp(today.getTime()));
        approveSupp.setAuditor(user);
        approveSupp.setAuditDate((Date)new Timestamp(today.getTime()));
        approveSupp.setPurOrgCreator(approveSupp.getPurchaseOrg());
        approveSupp.setCreatType(CreatTypeEnum.ADD_NEW);
        approveSupp.setString("isFromQuo", "isFromQuo");
        if (null != detailDataMap.get("billtype")) {
            String billType = detailDataMap.get("billtype").toString();
            int createType = 2;
            if ("sou_bidbillcfm".equals(billType)) {
                createType = 3;
            } else if ("src_contract".equals(billType)) {
                createType = 4;
            }
            approveSupp.setInt("creatType", createType);
        }
        if (null != detailDataMap.get("seq")) {
            approveSupp.setInt("sourceBillEntrySeq", Integer.valueOf(detailDataMap.get("seq").toString()).intValue());
        }
        if (null != detailDataMap.get("number")) {
            approveSupp.setString("sourceBillNo", detailDataMap.get("number").toString());
        }
        if (null != detailDataMap.get("quotaRate")) {
            approveSupp.setQuotaRate(new BigDecimal(detailDataMap.get("quotaRate").toString()));
        }
        if (null != detailDataMap.get("minPackingQty")) {
            approveSupp.setMinPackingQty(new BigDecimal(detailDataMap.get("minPackingQty").toString()));
        }
        ApprovedSupColl.addObject((IObjectValue)approveSupp);
        ApprovedSupplierCollection updateCol = null;
        ApprovedSupplierCollection submitCol = null;
        if (!isHasApprovedSupplier) {
            submitCol = ApprovedSupColl;
        } else {
            updateCol = ApprovedSupColl;
        }
        iAS.doSave((IObjectCollection)updateCol, (IObjectCollection)submitCol);
        HashSet<String> idset = new HashSet<String>();
        if (null != submitCol) {
            for (int i = 0; i < submitCol.size(); ++i) {
                idset.add(String.valueOf(submitCol.getObject(i).get("id")));
            }
        }
        if (null != updateCol) {
            for (int i = 0; i < updateCol.size(); ++i) {
                idset.add(String.valueOf(updateCol.getObject(i).get("id")));
            }
        }
        if (idset.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = new SelectorItemCollection();
            selector.add("isUseable");
            selector.add("id");
            selector.add("number");
            selector.add("auditor");
            selector.add("auditDate");
            view.setSelector(selector);
            collection = iAS.getApprovedSupplierCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                collection.get(i).setAuditor(user);
                collection.get(i).setAuditDate((Date)new Timestamp(today.getTime()));
                collection.get(i).setIsUseable(IsUseableEnum.Useable);
                iAS.update((IObjectPK)new ObjectUuidPK(collection.get(i).getId().toString()), (CoreBaseInfo)collection.get(i));
            }
            return collection.get(0).getId().toString();
        }
        return null;
    }

    @Override
    protected String getInterfaceNumber() {
        return "NEXT_SouCompare_UpdateSupp_Rec";
    }
}

