/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.fromisc.callback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.app.util.SrmProgressUpdateUtil;
import com.kingdee.eas.scm.nsrm.app.util.SyncStatusUpdateUtil;
import com.kingdee.eas.scm.nsrm.constant.SyncStatusConstants;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurInwarehUnAuditCallBack {
    private static Logger logger = Logger.getLogger(PurInwarehUnAuditCallBack.class);

    public static void handle(Context ctx, Map<String, Object> data) throws Exception {
        Map dataMap = (Map)data.get("data");
        List dataList = (List)dataMap.get("$SRC_BILL_INFO");
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> failids = new ArrayList<String>();
        Map billData = null;
        for (int i = 0; i < dataList.size(); ++i) {
            billData = (Map)dataList.get(i);
            if ("9".equals(billData.get("status"))) {
                ids.add(String.valueOf(billData.get("oid")));
                continue;
            }
            failids.add(String.valueOf(billData.get("oid")));
        }
        if (ids.size() > 0) {
            EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(ids.toArray(new String[0]));
            PurInWarehsBillCollection newBillCol = (PurInWarehsBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(ev);
            PurInwarehUnAuditCallBack.updataStatus(ctx, newBillCol);
        }
    }

    public static void updataStatus(Context ctx, PurInWarehsBillCollection newBillCol) throws BOSException {
        SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)newBillCol, SyncStatusConstants.NULL_STATUS, "T_IM_purinwarehsbill");
        PurInWarehsBillInfo billInfo = null;
        PurInWarehsEntryCollection entryCol = null;
        PurInWarehsEntryInfo entryInfo = null;
        HashSet<String> orderIdSet = new HashSet<String>();
        int size = newBillCol.size();
        for (int i = 0; i < size; ++i) {
            billInfo = newBillCol.get(i);
            entryCol = (PurInWarehsEntryCollection)billInfo.getEntries();
            int length = entryCol.size();
            for (int j = 0; j < length; ++j) {
                entryInfo = entryCol.get(j);
                if (entryInfo == null || entryInfo.getCoreBillType() == null || !"510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(entryInfo.getCoreBillType().getId().toString()) || entryInfo.getPurOrder() == null) continue;
                orderIdSet.add(entryInfo.getPurOrder());
            }
        }
        if (orderIdSet == null || orderIdSet.size() == 0) {
            logger.debug((Object)"@@@@PurInWarehsAuditSend.handleResult,errorMsg:\u91c7\u8d2d\u6536\u8d27\u5355\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u7684ID\u96c6\u5408\u4e3a\u7a7a\uff01");
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("srmProgress"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.qty"));
        sic.add(new SelectorItemInfo("entries.quantityUnCtrl"));
        sic.add(new SelectorItemInfo("entries.totalReceiveQty"));
        sic.add(new SelectorItemInfo("entries.receiveOwingRate"));
        sic.add(new SelectorItemInfo("entries.saloutQty"));
        sic.add(new SelectorItemInfo("entries.totalReceiptQty"));
        sic.add(new SelectorItemInfo("entries.totalReturnedQty"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orderIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("srmProgress", null, CompareType.NOTEQUALS));
        view.setFilter(filter);
        PurOrderCollection purCol = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(view);
        if (purCol == null || purCol.size() == 0) {
            logger.debug((Object)"@@@@PurInWarehsAuditSend.handleResult,errorMsg:\u91c7\u8d2d\u5165\u5e93\u5355\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u7684ID\u96c6\u5408\u4e3a\u7a7a\uff01");
            return;
        }
        SrmProgressUpdateUtil.updateStatusByQty(ctx, purCol, true);
    }
}

