/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.job;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.eas.scm.nsrm.SrmCommonLogCollection;
import com.kingdee.eas.scm.nsrm.SrmCommonLogFactory;
import com.kingdee.eas.scm.nsrm.SrmCommonLogInfo;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SrmCommonLogCallHandler
implements IJobHandler {
    private static final Map<String, String> operate = new HashMap<String, String>();
    private static final Logger LOGGER = Logger.getLogger((String)"com.kingdee.eas.scm.nsrm.app.job.HandlerDemo");

    public Object execute(Job job) throws Exception {
        Map parameters = (Map)job.getParameters();
        LOGGER.error((Object)("\u82cd\u7a79\u6267\u884c\u5b8c\u96c6\u6210\u65b9\u6848\uff0c\u56de\u8c03EAS" + parameters));
        Context ctx = job.getContext();
        String trigger_number = (String)parameters.get("trigger_number");
        String source_id = (String)parameters.get("source_id");
        String event = (String)parameters.get("event");
        LOGGER.error((Object)("trigger_number:" + trigger_number + ",source_id:" + source_id + ",event:" + event));
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("relationBill", (Object)source_id, CompareType.EQUALS));
        String interfaceNum = operate.get(trigger_number);
        if (StringUtils.isEmpty((String)interfaceNum)) {
            return false;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("interfaceNo", (Object)interfaceNum, CompareType.EQUALS));
        final SorterItemInfo startTime = new SorterItemInfo("startTime");
        startTime.setSortType(SortType.DESCEND);
        SorterItemCollection sorterItemCollection = new SorterItemCollection(){
            {
                this.add(startTime);
            }
        };
        viewinfo.setFilter(filterInfo);
        viewinfo.setSorter(sorterItemCollection);
        viewinfo.setTopCount(1);
        SrmCommonLogCollection srmCommonLogCollection = SrmCommonLogFactory.getLocalInstance(ctx).getSrmCommonLogCollection(viewinfo);
        SrmCommonLogInfo logInfo = null;
        if (srmCommonLogCollection != null) {
            logInfo = srmCommonLogCollection.get(0);
            SrmLoggerHelper.setBizRemark(logInfo, "\u82cd\u7a79\u6267\u884c\u5b8c\u96c6\u6210\u65b9\u6848\uff0c\u56de\u8c03EAS");
            LOGGER.error((Object)("\u67e5\u8be2\u65e5\u5fd7\u5bf9\u8c61\uff1a" + logInfo));
            if (!"OnRowSuccess".equalsIgnoreCase(event) && "OnRowFailed".equalsIgnoreCase(event)) {
                logInfo.setException("BizException: \u82cd\u7a79\u6267\u884c\u96c6\u6210\u65b9\u6848\u5931\u8d25");
                Object error = parameters.get("error");
                if (error != null) {
                    if (error instanceof Map) {
                        SrmLoggerHelper.setErrorMsg(logInfo, (String)((Map)error).get("#message"));
                    } else {
                        SrmLoggerHelper.setErrorMsg(logInfo, error.toString());
                    }
                }
                SrmLoggerHelper.setBizRemark(logInfo, "\u82cd\u7a79\u96c6\u6210\u65b9\u6848\u6267\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u53c2\u8003\u9519\u8bef\u4fe1\u606f\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u82cd\u7a79\u65e5\u5fd7");
            }
            SrmLoggerHelper.end(ctx, null, logInfo);
        }
        return "success";
    }

    static {
        operate.put("EAS_PurorderInit__Audit(EAS-IERP)", "EAS_PurOrder_Sync_Send");
        operate.put("EAS_PurOrder__UnAudit(EAS-IERP)", "EAS_PurOrder_Del_Send");
        operate.put("KD_SRM_SouInquiry(EAS_IERP)", "EAS_BatchPurRequestForPurQuo_Send");
        operate.put("KD_SRM_SouBid(EAS_IERP)", "EAS_BatchPurReqToSouBid_Send");
        operate.put("EAS_PurReceipt__UnAudit(EAS-IERP)", "EAS_PurReceivalBill_Del_Send");
        operate.put("EAS_PurReceipt__Audit(EAS-IERP)", "EAS_PurReceivalBill_Sync_Send");
        operate.put("IERP_PurInstock__UnAudit(EAS-IERP)", "EAS_PurInWarehsBill_Del_Send");
        operate.put("EAS_PurInstock__Audit(EAS-IERP)", "EAS_PurInWarehsBill_Sync_Send");
    }
}

