/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.logger;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.scm.nsrm.OprtStatusEnum;
import com.kingdee.eas.scm.nsrm.SrmCommonLogCollection;
import com.kingdee.eas.scm.nsrm.SrmCommonLogFactory;
import com.kingdee.eas.scm.nsrm.SrmCommonLogInfo;
import com.kingdee.eas.scm.nsrm.util.ExceptionHelper;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SrmLoggerHelper {
    private static Logger logger = Logger.getLogger(SrmLoggerHelper.class);

    public static SrmCommonLogInfo start(Context ctx, String tempKey) {
        CompanyOrgUnitInfo companyInfo;
        SrmCommonLogInfo srmLog = new SrmCommonLogInfo();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (userInfo != null) {
            srmLog.setUser(userInfo);
            srmLog.setUserName(userInfo.getName());
            srmLog.setUserType(userInfo.getType().toString());
        }
        if ((companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company)) != null) {
            srmLog.setCompanyName(companyInfo.getName());
        }
        srmLog.setClientIP(ctx.getClientHostIP());
        srmLog.setClientName(ctx.getClientHostName());
        srmLog.setOprtStatus(OprtStatusEnum.PROCESS);
        srmLog.setOprtObject(null);
        srmLog.setOprtDescription(null);
        srmLog.setEnterBillCount(0);
        srmLog.setBillCount(0);
        srmLog.setBillCount(0);
        srmLog.setStartTime(SrmLoggerHelper.getCurrentTimestamp());
        srmLog.setEndTime(null);
        srmLog.setTotalTime(null);
        srmLog.setTempKey(tempKey);
        SrmLoggerHelper.setBizRemark(srmLog, "execute start.............");
        SrmLoggerHelper.save(ctx, srmLog);
        return srmLog;
    }

    public static void end(Context ctx, String tempKey, SrmCommonLogInfo info) {
        if (info == null) {
            info = SrmLoggerHelper.getSrmCommonLogInfo(ctx, tempKey);
        }
        Timestamp endTime = SrmLoggerHelper.getCurrentTimestamp();
        Timestamp startTime = info.getStartTime();
        info.setEndTime(endTime);
        String totalTime = SrmLoggerHelper.getFormatTime(endTime.getTime() - startTime.getTime());
        info.setTotalTime(totalTime);
        SrmLoggerHelper.setBizRemark(info, "execute end.............");
        SrmLoggerHelper.save(ctx, info);
    }

    public static void save(Context ctx, SrmCommonLogInfo info) {
        try {
            if (info.getErrorMsg() == null && info.getException() == null && info.getTotalTime() != null) {
                info.setOprtStatus(OprtStatusEnum.SUCCESS);
            } else if (info.getErrorMsg() != null || info.getException() != null) {
                info.setOprtStatus(OprtStatusEnum.FAIL);
            }
            SrmCommonLogFactory.getLocalInstance(ctx).save(info);
        }
        catch (Exception e) {
            logger.error((Object)("@@@@SrmLoggerHelper.save(),\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25\uff01" + e.getMessage()));
        }
    }

    public static void delete(Context ctx, SrmCommonLogInfo info) {
        try {
            SrmCommonLogFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
        }
        catch (Exception e) {
            logger.error((Object)("@@@@SrmLoggerHelper.save(),\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25\uff01" + e.getMessage()));
        }
    }

    public static SrmCommonLogInfo getSrmCommonLogInfo(Context ctx, String tempKey) {
        SrmCommonLogInfo info = null;
        try {
            SrmCommonLogCollection col = SrmCommonLogFactory.getLocalInstance(ctx).getSrmCommonLogCollection("where tempKey = '" + tempKey + "'");
            if (col == null || col.size() == 0) {
                if (tempKey == null) {
                    tempKey = SrmLoggerHelper.createTempKey();
                }
                info = SrmLoggerHelper.start(ctx, tempKey);
            } else {
                info = col.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("@@@@SrmLoggerHelper.getSrmCommonLogInfo(),\u65e5\u5fd7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01\u67e5\u8be2Key:" + tempKey + ";\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            tempKey = SrmLoggerHelper.createTempKey();
            info = SrmLoggerHelper.start(ctx, tempKey);
        }
        return info;
    }

    public static String createTempKey() {
        return "TK" + SrmLoggerHelper.getCurrentTimestamp().toString().replace("-", "").replace(":", "").replace(".", "").replace(" ", "") + SrmLoggerHelper.random3Str();
    }

    private static String random3Str() {
        return String.valueOf((int)(Math.random() * 900.0) + 100);
    }

    public static void setBizRemark(SrmCommonLogInfo srmLogInfo, String str) {
        String preStr = srmLogInfo.getBizRemark();
        if (preStr != null) {
            String separator = System.getProperty("line.separator") == null ? "/n" : System.getProperty("line.separator");
            str = preStr + separator + "@@" + str;
        } else {
            str = "@@" + str;
        }
        if (str != null && str.length() > 2000) {
            str = str.substring(0, 1999);
        }
        srmLogInfo.setBizRemark(str);
    }

    public static void setErrorMsg(SrmCommonLogInfo srmLogInfo, String str) {
        if (str != null && str.length() > 1024) {
            str = str.substring(0, 1023);
        }
        srmLogInfo.setErrorMsg(str);
    }

    private static void setException(SrmCommonLogInfo srmLogInfo, String str) {
        if (str != null && str.length() > 2000) {
            str = str.substring(0, 1999);
        }
        srmLogInfo.setException(str);
    }

    public static void setMsgAndException(SrmCommonLogInfo srmLogInfo, Exception e) {
        SrmLoggerHelper.setErrorMsg(srmLogInfo, e.getMessage());
        SrmLoggerHelper.setException(srmLogInfo, ExceptionHelper.toString(e));
    }

    public static void calBillAndEntryCount(SrmCommonLogInfo srmLogInfo, IObjectCollection objCol, String entryID) {
        int billCount = 0;
        int entryCount = 0;
        int size = objCol == null || objCol.size() == 0 ? 0 : objCol.size();
        String numberMsg = "\u5b9e\u9645\u53d1\u9001\u7684\u5355\u636e\u7f16\u7801\uff1a";
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                numberMsg = numberMsg + objCol.getObject(i).getString("number");
            } else if (i > 0 && i < 5) {
                numberMsg = numberMsg + "," + objCol.getObject(i).getString("number");
            }
            ++billCount;
            if (objCol.getObject(i) == null || objCol.getObject(i).get(entryID == null ? "entries" : entryID) == null) continue;
            entryCount += ((IObjectCollection)objCol.getObject(i).get(entryID == null ? "entries" : entryID)).size();
        }
        if (size > 0) {
            if (size < 5) {
                SrmLoggerHelper.setBizRemark(srmLogInfo, numberMsg);
            } else {
                SrmLoggerHelper.setBizRemark(srmLogInfo, numberMsg + "\u7b49");
            }
        }
        srmLogInfo.setBillCount(billCount);
        srmLogInfo.setEntryCount(entryCount);
    }

    private static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getFormatTime(long t) {
        long hour = t / 3600000L;
        long left = t % 3600000L;
        long minus = left / 60000L;
        long second = (left %= 60000L) / 1000L;
        return hour + "\u65f6" + minus + "\u5206" + second + "\u79d2" + (left %= 1000L) + "\u6beb\u79d2";
    }
}

