/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Map;

public class QtyChangeCalUtil {
    private static final BigDecimal BIGZERO = new BigDecimal("0.00");

    public static void qtyChange(Context ctx, PurReceivalEntryInfo entry) {
        BigDecimal qualifiedQty = entry.getQualifiedQty();
        BigDecimal unQualifiedQty = entry.getUnqualifiedBaseQty();
        BigDecimal concessiveRecQty = entry.getConcessiveRecQty();
        BigDecimal qty = entry.getQty();
        BigDecimal baseQty = entry.getBaseQty();
        if (qualifiedQty != null && qualifiedQty.compareTo(BigDecimal.ZERO) != 0 && unQualifiedQty != null && qty != null && qty.subtract(unQualifiedQty).compareTo(InvClientUtils.ZERO) > 0 && (concessiveRecQty == null || concessiveRecQty.compareTo(new BigDecimal("0.00")) == 0)) {
            entry.setQualifiedQty(qty.subtract(unQualifiedQty));
            BigDecimal unQualifiedBaseQty = entry.getUnqualifiedBaseQty();
            if (baseQty == null) {
                baseQty = entry.getBaseQty();
            }
            if (baseQty != null && unQualifiedBaseQty != null) {
                entry.setUnqualifiedBaseQty(baseQty.subtract(unQualifiedBaseQty));
            }
        }
    }

    public static void calByEntryTaxPriceChange(PurContractInfo info, PurContractEntryInfo entryInfo) {
        QtyChangeCalUtil.calEntryTaxAmount(info, entryInfo);
        QtyChangeCalUtil.calEntryTax(info, entryInfo);
        QtyChangeCalUtil.calEntryAmount(info, entryInfo);
        QtyChangeCalUtil.calEntryActualPrice(info, entryInfo);
        QtyChangeCalUtil.calEntryActualTaxPrice(info, entryInfo);
        QtyChangeCalUtil.calEntryDiscountAmount(info, entryInfo);
    }

    public static void calEntryDiscountAmount(PurContractInfo info, PurContractEntryInfo entryInfo) {
        boolean containTax = Boolean.valueOf(info.get("isInTax").toString());
        BigDecimal qty = entryInfo.getQty();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        BigDecimal discount = entryInfo.getDiscount();
        BigDecimal discountAmount = BigDecimal.ZERO;
        int scale = 2;
        scale = info.getCurrency().getPrecision();
        DiscountModeEnum discountType = entryInfo.getDiscountType();
        if (discountType == null) {
            discountType = DiscountModeEnum.PERCENT;
        }
        discountAmount = discountType.equals((Object)DiscountModeEnum.PERCENT) ? CalculateUtils.calDiscountAmountByPercent((BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (int)scale) : CalculateUtils.calDiscountAmountByPerunit((BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxRate, (int)scale, (boolean)containTax);
        entryInfo.setDiscountAmount(discountAmount);
    }

    public static void calEntryActualTaxPrice(PurContractInfo info, PurContractEntryInfo entryInfo) {
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal qty = entryInfo.getQty();
        int scale = QtyChangeCalUtil.getEntryBigDecimalValue((SCMBillEntryBaseInfo)entryInfo, "price").scale();
        BigDecimal actualTaxPrice = CalculateUtils.calActualTaxPrice((BigDecimal)taxAmount, (BigDecimal)qty, (int)scale);
        entryInfo.setActualTaxPrice(actualTaxPrice);
    }

    public static void calEntryActualPrice(PurContractInfo info, PurContractEntryInfo entryInfo) {
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal qty = entryInfo.getQty();
        int scale = QtyChangeCalUtil.getEntryBigDecimalValue((SCMBillEntryBaseInfo)entryInfo, "price").scale();
        BigDecimal actualPrice = CalculateUtils.calActualPrice((BigDecimal)amount, (BigDecimal)qty, (int)scale);
        entryInfo.setActualPrice(actualPrice);
    }

    protected static BigDecimal getEntryBigDecimalValue(SCMBillEntryBaseInfo entryInfo, String fieldName) {
        if (fieldName.equals(null)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = BigDecimal.ZERO;
        if (entryInfo.get(fieldName) == null) {
            return value;
        }
        if (entryInfo.get(fieldName) instanceof BigDecimal) {
            value = (BigDecimal)entryInfo.get(fieldName);
        }
        return value;
    }

    public static void calEntryAmount(PurContractInfo info, PurContractEntryInfo entryInfo) {
        boolean containTax = Boolean.valueOf(info.get("isInTax").toString());
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal discount = entryInfo.getDiscount();
        BigDecimal tax = entryInfo.getTax();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal price = entryInfo.getPrice();
        BigDecimal amount = BigDecimal.ZERO;
        int scale = 2;
        scale = info.getCurrency().getPrecision();
        DiscountModeEnum discountType = entryInfo.getDiscountType();
        if (discountType == null) {
            discountType = DiscountModeEnum.PERCENT;
        }
        amount = containTax ? CalculateUtils.calAmountInTax((BigDecimal)taxAmount, (BigDecimal)tax, (int)scale) : (discountType.equals((Object)DiscountModeEnum.PERCENT) ? CalculateUtils.calAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)price, (BigDecimal)discount, (int)scale) : CalculateUtils.calAmountByDiscountAmount((BigDecimal)qty, (BigDecimal)price, (BigDecimal)discount, (int)scale));
        entryInfo.setAmount(amount);
    }

    public static void calEntryTax(PurContractInfo info, PurContractEntryInfo entryInfo) {
        boolean containTax = Boolean.valueOf(info.get("isInTax").toString());
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal taxRate = entryInfo.getTaxRate();
        BigDecimal tax = BigDecimal.ZERO;
        int scale = info.getCurrency().getPrecision();
        if (scale <= 4) {
            scale = 4;
        }
        tax = containTax ? CalculateUtils.calTaxWhenPriceExludeTax((BigDecimal)taxAmount, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
        entryInfo.setTax(tax);
    }

    public static void calEntryTaxAmount(PurContractInfo info, PurContractEntryInfo entryInfo) {
        BigDecimal qty = entryInfo.getQty();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal discount = entryInfo.getDiscount();
        BigDecimal taxAmount = BigDecimal.ZERO;
        int scale = info.getCurrency().getPrecision();
        DiscountModeEnum discountType = entryInfo.getDiscountType();
        if (discountType == null) {
            discountType = DiscountModeEnum.PERCENT;
        }
        if (Boolean.valueOf(info.get("isInTax").toString()).booleanValue()) {
            taxAmount = discountType.equals((Object)DiscountModeEnum.PERCENT) ? QtyChangeCalUtil.calTotalTaxAmountByDiscountPercent(qty, taxPrice, discount, scale) : CalculateUtils.calTotalTaxAmountByDiscountAmount((BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)discount, (int)scale);
        } else {
            BigDecimal amount = entryInfo.getAmount();
            BigDecimal tax = entryInfo.getTax();
            taxAmount = CalculateUtils.calTotalTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
        }
        entryInfo.setTaxAmount(taxAmount);
    }

    public static BigDecimal calTotalTaxAmountByDiscountPercent(BigDecimal qty, BigDecimal taxPrice, BigDecimal discount, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal discountAmount = new BigDecimal("0.0");
        qty = qty == null ? zero : qty;
        taxPrice = taxPrice == null ? zero : taxPrice;
        discountAmount = taxPrice.multiply(qty).multiply(discount).divide(oneHundred, 10, 4);
        BigDecimal totalTaxAmount = taxPrice.multiply(qty).subtract(discountAmount).divide(one, scale, 4);
        return totalTaxAmount;
    }

    public static void handRelationParams(Context ctx, PurOrderEntryInfo entry, PurOrderInfo info) throws EASBizException, BOSException {
        ExchangeRateInfo exchangeRateinfo = QtyChangeCalUtil.getExchangeRateInfo(ctx, entry, info);
        if (info.isIsInTax()) {
            QtyChangeCalUtil.calEntryAssistQty(ctx, entry, info);
            QtyChangeCalUtil.calDiscountAmountByTaxPrice(entry, info);
            QtyChangeCalUtil.calTaxAmountByTaxPrice(entry, info);
            QtyChangeCalUtil.calLocalTaxAmount(entry, exchangeRateinfo, info);
            QtyChangeCalUtil.calTax(entry, info);
            QtyChangeCalUtil.calLocalTax(entry, exchangeRateinfo, info);
            QtyChangeCalUtil.calAmount(entry, info);
            QtyChangeCalUtil.calLocalAmount(entry, exchangeRateinfo, info);
            QtyChangeCalUtil.calActualTaxPrice(entry, exchangeRateinfo, info);
            QtyChangeCalUtil.calActualPrice(entry, info);
        } else {
            QtyChangeCalUtil.calEntryAssistQty(ctx, entry, info);
            QtyChangeCalUtil.calAmount(entry, info);
            QtyChangeCalUtil.calLocalAmount(entry, exchangeRateinfo, info);
            QtyChangeCalUtil.calTax(entry, info);
            QtyChangeCalUtil.calLocalTax(entry, exchangeRateinfo, info);
            QtyChangeCalUtil.calTaxAmountByTaxPrice(entry, info);
            QtyChangeCalUtil.calLocalTaxAmount(entry, exchangeRateinfo, info);
            QtyChangeCalUtil.calDiscountAmountByTaxPrice(entry, info);
            QtyChangeCalUtil.calActualTaxPrice(entry, exchangeRateinfo, info);
            QtyChangeCalUtil.calActualPrice(entry, info);
        }
    }

    public static void calEntryQty(Context ctx, PurOrderEntryInfo entry, MeasureUnitInfo baseUnit, BigDecimal baseunitQty) throws EASBizException, BOSException {
        String materialID = entry.getMaterial().getId().toString();
        MeasureUnitInfo unit = entry.getUnit();
        BigDecimal qty = QtyChangeCalUtil.getBaseUnitQty1(ctx, materialID, baseUnit.getId().toString(), unit.getId().toString(), baseunitQty);
        entry.setQty(qty);
    }

    public static void calEntryBaseQty(Context ctx, PurOrderEntryInfo entry) throws EASBizException, BOSException {
        String materialID = entry.getMaterial().getId().toString();
        MeasureUnitInfo unit = entry.getUnit();
        MeasureUnitInfo baseUnit = entry.getBaseUnit();
        BigDecimal baseQty = QtyChangeCalUtil.getBaseUnitQty1(ctx, materialID, unit.getId().toString(), baseUnit.getId().toString(), entry.getQty());
        entry.setBaseQty(baseQty);
    }

    public static void calEntryAssistQty(Context ctx, PurOrderEntryInfo entry, PurOrderInfo info) throws EASBizException, BOSException {
        if (entry.getAssistUnit() == null) {
            return;
        }
        String materialID = entry.getMaterial().getId().toString();
        MeasureUnitInfo unit = entry.getUnit();
        MeasureUnitInfo assistUnit = entry.getAssistUnit();
        BigDecimal assistQty = QtyChangeCalUtil.getBaseUnitQty1(ctx, materialID, unit.getId().toString(), assistUnit.getId().toString(), entry.getQty());
        entry.setAssistQty(assistQty);
    }

    public static void calActualPrice(PurOrderEntryInfo entry, PurOrderInfo info) {
        if (entry.getPrice() == null || entry.getAmount() == null || entry.getQty() == null || entry.getActualPrice() == null || entry.getDiscountAmount() == null) {
            return;
        }
        BigDecimal zero = new BigDecimal("0.0");
        int scale = info.getCurrency().getPrecision();
        BigDecimal amount = entry.getAmount();
        BigDecimal qty = entry.getQty();
        amount = QtyChangeCalUtil.validateNullValue(amount);
        qty = QtyChangeCalUtil.validateNullValue(qty);
        BigDecimal discountRate = entry.getDiscountRate();
        if (discountRate == null || discountRate.compareTo(zero) == 0) {
            BigDecimal price = entry.getPrice();
            price = QtyChangeCalUtil.validateNullValue(price);
            entry.setActualPrice(price);
        } else if (amount != null && qty != null && qty.compareTo(zero) != 0) {
            BigDecimal actualPrice = amount.divide(qty, scale, 4);
            entry.setActualPrice(actualPrice);
        }
    }

    public static void calActualTaxPrice(PurOrderEntryInfo entry, ExchangeRateInfo exchangeRateinfo, PurOrderInfo info) {
        if (entry.getPrice() == null || entry.getTaxPrice() == null || entry.getActualTaxPrice() == null || entry.getTaxAmount() == null || entry.getQty() == null) {
            return;
        }
        BigDecimal discountRate = entry.getDiscountAmount();
        BigDecimal zero = new BigDecimal("0.0");
        int scale = info.getCurrency().getPrecision();
        if ((discountRate == null || discountRate.compareTo(zero) == 0) && entry.getTaxPrice() != null) {
            BigDecimal taxPrice = entry.getTaxPrice().abs();
            entry.setActualTaxPrice(taxPrice);
        } else {
            BigDecimal taxAmount = entry.getAmount();
            BigDecimal qty = entry.getQty();
            taxAmount = QtyChangeCalUtil.validateNullValue(taxAmount);
            qty = QtyChangeCalUtil.validateNullValue(qty);
            BigDecimal actualTaxPrice = SysConstant.BIGZERO;
            if (taxAmount != null && qty != null && qty.compareTo(zero) != 0) {
                actualTaxPrice = taxAmount.divide(qty, scale, 4);
                entry.setActualTaxPrice(actualTaxPrice);
            }
        }
    }

    public static void calDiscountAmountByTaxPrice(PurOrderEntryInfo entry, PurOrderInfo info) {
        int amountPricision = info.getCurrency().getPrecision();
        if (entry.getDiscountRate() == null) {
            return;
        }
        int scale = amountPricision;
        BigDecimal taxPrice = entry.getTaxPrice();
        BigDecimal qty = entry.getQty();
        BigDecimal discountRate = entry.getDiscountRate();
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxPrice = QtyChangeCalUtil.validateNullValue(taxPrice);
        qty = QtyChangeCalUtil.validateNullValue(qty);
        discountRate = QtyChangeCalUtil.validateNullValue(discountRate);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(oneHundred, 10, 4)).setScale(scale, 4);
        entry.setDiscountAmount(discountAmount);
    }

    private static BigDecimal validateNullValue(BigDecimal value) {
        if (value == null) {
            return BIGZERO;
        }
        return value;
    }

    public static void calAmount(PurOrderEntryInfo entry, PurOrderInfo info) {
        int scale = info.getCurrency().getPrecision();
        if (info.isIsInTax()) {
            BigDecimal taxAmount = entry.getTaxAmount();
            BigDecimal tax = entry.getTax();
            taxAmount = QtyChangeCalUtil.validateNullValue(taxAmount);
            tax = QtyChangeCalUtil.validateNullValue(tax);
            entry.setAmount(SysConstant.BIGZERO);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                entry.setAmount(actualTaxPrice);
            }
        } else {
            BigDecimal price = entry.getPrice();
            BigDecimal discountRate = entry.getDiscountRate();
            BigDecimal qty = entry.getQty();
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            price = QtyChangeCalUtil.validateNullValue(price);
            discountRate = QtyChangeCalUtil.validateNullValue(discountRate);
            qty = QtyChangeCalUtil.validateNullValue(qty);
            BigDecimal amount = qty.multiply(price).multiply(one.subtract(discountRate.divide(oneHundred, 10, 4)));
            amount = amount.setScale(scale, 4);
            entry.setAmount(amount);
        }
    }

    public static void calLocalAmount(PurOrderEntryInfo entry, ExchangeRateInfo exchangeRateinfo, PurOrderInfo info) {
        int scale = info.getCompanyOrgUnit().getBaseCurrency().getPrecision();
        BigDecimal amount = entry.getAmount();
        BigDecimal exchangerate = info.getExchangeRate();
        amount = QtyChangeCalUtil.validateNullValue(amount);
        exchangerate = QtyChangeCalUtil.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BIGZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalAmount(amount.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(BIGZERO) != 0) {
            entry.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalAmount(amount);
        }
    }

    public static void calLocalTax(PurOrderEntryInfo entry, ExchangeRateInfo exchangeRateinfo, PurOrderInfo info) {
        int scale = info.getCompanyOrgUnit().getBaseCurrency().getPrecision();
        BigDecimal tax = entry.getTax();
        BigDecimal exchangerate = info.getExchangeRate();
        tax = QtyChangeCalUtil.validateNullValue(tax);
        exchangerate = QtyChangeCalUtil.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BIGZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTax(tax.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(BIGZERO) != 0) {
            entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalTax(tax);
        }
    }

    public static void calTax(PurOrderEntryInfo entry, PurOrderInfo info) {
        int scale = info.getCurrency().getPrecision();
        if (info.isIsInTax()) {
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal taxAmount = entry.getTaxAmount();
            BigDecimal taxRate = entry.getTaxRate();
            taxAmount = QtyChangeCalUtil.validateNullValue(taxAmount);
            taxRate = QtyChangeCalUtil.validateNullValue(taxRate);
            BigDecimal tax = SysConstant.BIGZERO;
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = info.isIsPriceInTax() ? taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate) : taxAmount.multiply(taxRate);
                if (!info.isIsPriceInTax()) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
            }
            entry.setTax(tax);
        } else {
            BigDecimal amount = entry.getAmount();
            amount = QtyChangeCalUtil.validateNullValue(amount);
            BigDecimal taxRate = entry.getTaxRate();
            BigDecimal tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)(taxRate = QtyChangeCalUtil.validateNullValue(taxRate)), (int)scale);
            if (tax != null) {
                entry.setTax(tax);
            } else {
                entry.setTax(SysConstant.BIGZERO);
            }
        }
    }

    public static void calTaxAmountByTaxPrice(PurOrderEntryInfo entry, PurOrderInfo info) {
        int scale = info.getCurrency().getPrecision();
        if (info.isIsInTax()) {
            BigDecimal taxPrice = entry.getTaxPrice();
            BigDecimal qty = entry.getQty();
            BigDecimal discountAmount = entry.getDiscountAmount();
            taxPrice = QtyChangeCalUtil.validateNullValue(taxPrice);
            qty = QtyChangeCalUtil.validateNullValue(qty);
            discountAmount = QtyChangeCalUtil.validateNullValue(discountAmount);
            BigDecimal taxAmount = taxPrice.multiply(qty).subtract(discountAmount);
            taxAmount = taxAmount.setScale(scale, 4);
            entry.setTaxAmount(taxAmount);
        } else {
            BigDecimal amount = entry.getAmount();
            BigDecimal tax = entry.getTax();
            amount = QtyChangeCalUtil.validateNullValue(amount);
            tax = QtyChangeCalUtil.validateNullValue(tax);
            BigDecimal taxAmount = amount.add(tax);
            taxAmount = taxAmount.setScale(scale, 4);
            entry.setTaxAmount(taxAmount);
        }
    }

    public static void calLocalTaxAmount(PurOrderEntryInfo entry, ExchangeRateInfo exchangeRateinfo, PurOrderInfo info) {
        int scale = info.getCompanyOrgUnit().getBaseCurrency().getPrecision();
        BigDecimal taxAmount = entry.getTaxAmount();
        BigDecimal exchangerate = info.getExchangeRate();
        taxAmount = QtyChangeCalUtil.validateNullValue(taxAmount);
        exchangerate = QtyChangeCalUtil.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BIGZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(BIGZERO) != 0) {
            entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalTaxAmount(taxAmount);
        }
    }

    public static ExchangeRateInfo getExchangeRateInfo(Context ctx, PurOrderEntryInfo entry, PurOrderInfo info) throws EASBizException, BOSException {
        CurrencyInfo srcCurrInfo = info.getCurrency();
        CompanyOrgUnitInfo ficompanyOrgInfo = info.getCompanyOrgUnit();
        CurrencyInfo baseCurrInfo = null;
        if (ficompanyOrgInfo != null) {
            baseCurrInfo = info.getCompanyOrgUnit().getBaseCurrency();
        }
        if (ficompanyOrgInfo != null && srcCurrInfo != null && baseCurrInfo != null && !srcCurrInfo.equals((Object)baseCurrInfo)) {
            String key = ficompanyOrgInfo.getId().toString() + srcCurrInfo.getId().toString() + baseCurrInfo.getId().toString();
            ObjectUuidPK excTablepk = null;
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            ExchangeTableInfo baseExchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
            if (baseExchangeTableInfo == null) {
                CompanyOrgUnitInfo icomUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getId()));
                baseExchangeTableInfo = icomUnit.getBaseExchangeTable();
            }
            if (baseExchangeTableInfo == null) {
                throw new PurOrderException(PurOrderException.EXCHANGETABLENULL);
            }
            excTablepk = new ObjectUuidPK(baseExchangeTableInfo.getId());
            sourceCurrPK = new ObjectUuidPK(srcCurrInfo.getId());
            destCurrPK = new ObjectUuidPK(baseCurrInfo.getId());
            IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
            return tempexrateinfo;
        }
        return null;
    }

    public static BigDecimal getBaseUnitQty(Context ctx, String materialID, String baseUnitID, BigDecimal qty, Map<String, Object> multiMap) throws EASBizException, BOSException {
        MultiMeasureUnitInfo sourceMulUnit = (MultiMeasureUnitInfo)multiMap.get(materialID + baseUnitID);
        BigDecimal coefficient = new BigDecimal(1);
        if (sourceMulUnit != null) {
            coefficient = sourceMulUnit.getBaseConvsRate();
        }
        BigDecimal baseQty = BigDecimal.ZERO;
        if (coefficient != null) {
            baseQty = qty.multiply(coefficient);
        }
        return baseQty;
    }

    public static BigDecimal getBaseUnitQty1(Context ctx, String materialID, String unitID, String baseUnitID, BigDecimal qty) throws EASBizException, BOSException {
        MeasureUnitInfo unitInfo = new MeasureUnitInfo();
        unitInfo.setId(BOSUuid.read((String)unitID));
        MeasureUnitInfo otherUnitInfo = new MeasureUnitInfo();
        otherUnitInfo.setId(BOSUuid.read((String)baseUnitID));
        BigDecimal baseQty = SCMUtil.getExchangePrecisionQtyForServer((Context)ctx, (String)materialID, (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)otherUnitInfo, (BigDecimal)qty);
        return baseQty;
    }
}

