/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.sf.json.JSONArray;

public class SrmAttachmentUtil {
    public static AttachmentCollection getAttachmentsByBOId(Context ctx, String billId) throws BOSException {
        String[] attchIds = BoAttchAssoFactory.getLocalInstance((Context)ctx).getAttchIDsByBoID(billId);
        HashSet<String> idSet = new HashSet<String>();
        for (String attchId : attchIds) {
            idSet.add(attchId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("name"));
        coll.add(new SelectorItemInfo("simpleName"));
        coll.add(new SelectorItemInfo("size"));
        coll.add(new SelectorItemInfo("sizeInByte"));
        coll.add(new SelectorItemInfo("beizhu"));
        coll.add(new SelectorItemInfo("description"));
        coll.add(new SelectorItemInfo("isSupplierView"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isSupplierView", (Object)true, CompareType.EQUALS));
        view.setFilter(filter);
        return AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentCollection(view);
    }

    public static void setAttachmentsForBill(Context ctx, CoreBillBaseInfo info) throws BOSException {
        String id = info.getId().toString();
        AttachmentCollection attachmentCollection = SrmAttachmentUtil.getAttachmentsByBOId(ctx, id);
        if (attachmentCollection == null || attachmentCollection.size() < 0) {
            info.put("attachment", (Object)"");
            return;
        }
        ArrayList attList = new ArrayList();
        for (int j = 0; j < attachmentCollection.size(); ++j) {
            AttachmentInfo attachmentInfo = attachmentCollection.get(j);
            HashMap<String, Object> fileMap = new HashMap<String, Object>();
            fileMap.put("id", attachmentInfo.getId().toString());
            fileMap.put("name", attachmentInfo.getName().toString());
            fileMap.put("simpleName", attachmentInfo.getSimpleName());
            fileMap.put("size", attachmentInfo.getSize());
            fileMap.put("sizeInByte", attachmentInfo.getSizeInByte());
            fileMap.put("beizhu", attachmentInfo.getBeizhu());
            fileMap.put("description", attachmentInfo.getDescription());
            attList.add(fileMap);
        }
        JSONArray jsonObject = JSONArray.fromObject(attList);
        info.put("attachment", (Object)jsonObject.toString());
    }
}

