/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionCollection;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Number2ObjUtil {
    public static Map<String, PersonInfo> getPurchasePersonMap(Context ctx, Set<String> personSet) throws BOSException {
        EntityViewInfo purOrgEV = ConvertUtil.convertNumSet2EVI(personSet);
        PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(purOrgEV);
        HashMap<String, PersonInfo> personMap = new HashMap<String, PersonInfo>();
        if (personCollection != null && personCollection.size() > 0) {
            for (int i = 0; i < personCollection.size(); ++i) {
                PersonInfo info = personCollection.get(i);
                String number = info.getNumber();
                personMap.put(number, info);
            }
        }
        return personMap;
    }

    public static Map<String, PurchaseOrgUnitInfo> getPurchaseOrgMap(Context ctx, Set<String> purchaseOrgSet) throws BOSException {
        EntityViewInfo purchaseOrgEV = ConvertUtil.convertNumSet2EVI(purchaseOrgSet);
        PurchaseOrgUnitCollection purchaseOrgUnitCollection = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitCollection(purchaseOrgEV);
        HashMap<String, PurchaseOrgUnitInfo> purchaseOrgMap = new HashMap<String, PurchaseOrgUnitInfo>();
        if (purchaseOrgUnitCollection != null && purchaseOrgUnitCollection.size() > 0) {
            for (int i = 0; i < purchaseOrgUnitCollection.size(); ++i) {
                PurchaseOrgUnitInfo info = purchaseOrgUnitCollection.get(i);
                String number = info.getNumber();
                purchaseOrgMap.put(number, info);
            }
        }
        return purchaseOrgMap;
    }

    public static Map<String, SupplierInfo> getSupplierMap(Context ctx, Set<String> supplierSet) throws BOSException {
        EntityViewInfo supplierEV = ConvertUtil.convertNumSet2EVI(supplierSet);
        SupplierCollection supplierCollection = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(supplierEV);
        HashMap<String, SupplierInfo> supplierMap = new HashMap<String, SupplierInfo>();
        if (supplierCollection != null && supplierCollection.size() > 0) {
            for (int i = 0; i < supplierCollection.size(); ++i) {
                SupplierInfo supplierInfo = supplierCollection.get(i);
                String number = supplierInfo.getNumber();
                supplierMap.put(number, supplierInfo);
            }
        }
        return supplierMap;
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, PurchaseOrgUnitInfo purchaseInfo, ObjectUuidPK desCurrId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfoForPurchase = InvServerUtils.getCompanyInfoForPurchase((Context)ctx, (PurchaseOrgUnitInfo)purchaseInfo);
        CurrencyInfo baseCurrency = companyInfoForPurchase.getBaseCurrency();
        ObjectUuidPK ss = new ObjectUuidPK(baseCurrency.getId());
        if (ss.toString().equals(desCurrId.toString())) {
            ExchangeRateInfo exchangeRateInfo = new ExchangeRateInfo();
            exchangeRateInfo.setConvertRate(BigDecimal.ONE);
            return exchangeRateInfo;
        }
        return SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)companyInfoForPurchase, (IObjectPK)desCurrId, (IObjectPK)ss);
    }

    public static Map<String, SettlementTypeInfo> getSettlementTypeMap(Context ctx, Set<String> settleTypeSet) throws BOSException {
        EntityViewInfo settleWayEV = ConvertUtil.convertNumSet2EVI(settleTypeSet);
        SettlementTypeCollection settlementTypeCollection = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(settleWayEV);
        HashMap<String, SettlementTypeInfo> settlementTypeMap = new HashMap<String, SettlementTypeInfo>();
        if (settlementTypeCollection != null && settlementTypeCollection.size() > 0) {
            for (int i = 0; i < settlementTypeCollection.size(); ++i) {
                SettlementTypeInfo settlementTypeInfo = settlementTypeCollection.get(i);
                String number = settlementTypeInfo.getNumber();
                settlementTypeMap.put(number, settlementTypeInfo);
            }
        }
        return settlementTypeMap;
    }

    public static Map<String, CurrencyInfo> getCurrMap(Context ctx, Set<String> currSet) throws BOSException {
        EntityViewInfo currEV = ConvertUtil.convertNumSet2EVI(currSet);
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(currEV);
        HashMap<String, CurrencyInfo> currMap = new HashMap<String, CurrencyInfo>();
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currencyInfo = currencyCollection.get(i);
                String number = currencyInfo.getNumber();
                currMap.put(number, currencyInfo);
            }
        }
        return currMap;
    }

    public static Map<String, MeasureUnitInfo> getMeasureUnitMap(Context ctx, Set<String> unitSet) throws BOSException {
        EntityViewInfo unitEV = ConvertUtil.convertNumSet2EVI(unitSet);
        MeasureUnitCollection measureUnitCollection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(unitEV);
        HashMap<String, MeasureUnitInfo> measureUnitMap = new HashMap<String, MeasureUnitInfo>();
        if (measureUnitCollection != null && measureUnitCollection.size() > 0) {
            for (int i = 0; i < measureUnitCollection.size(); ++i) {
                MeasureUnitInfo measureUnitInfo = measureUnitCollection.get(i);
                String number = measureUnitInfo.getNumber();
                measureUnitMap.put(number, measureUnitInfo);
            }
        }
        return measureUnitMap;
    }

    public static Map<String, PayConditionInfo> getPaymentConditionMap(Context ctx, Set<String> payConditionSet) throws BOSException {
        EntityViewInfo payConditionEv = ConvertUtil.convertNumSet2EVI(payConditionSet);
        PayConditionCollection paymentConditionCollection = PayConditionFactory.getLocalInstance((Context)ctx).getPayConditionCollection(payConditionEv);
        HashMap<String, PayConditionInfo> payConditionMap = new HashMap<String, PayConditionInfo>();
        if (paymentConditionCollection != null && paymentConditionCollection.size() > 0) {
            for (int i = 0; i < paymentConditionCollection.size(); ++i) {
                PayConditionInfo payConditionInfo = paymentConditionCollection.get(i);
                String number = payConditionInfo.getNumber();
                payConditionMap.put(number, payConditionInfo);
            }
        }
        return payConditionMap;
    }

    public static Map<String, MaterialInfo> getMaterialMap(Context ctx, Set<String> materialSet) throws BOSException, EASBizException {
        EntityViewInfo materialEv = ConvertUtil.convertNumSet2EVI(materialSet);
        MaterialCollection materialCollection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(materialEv);
        HashMap<String, MaterialInfo> MaterialMap = new HashMap<String, MaterialInfo>();
        if (materialCollection != null && materialCollection.size() > 0) {
            for (int i = 0; i < materialCollection.size(); ++i) {
                MaterialInfo materialInfo = materialCollection.get(i);
                String number = materialInfo.getNumber();
                MaterialMap.put(number, materialInfo);
            }
        }
        return MaterialMap;
    }

    public static Map<String, StorageOrgUnitInfo> getStorageMap(Context ctx, HashSet<String> storageSet) throws BOSException {
        EntityViewInfo storageEv = ConvertUtil.convertNumSet2EVI(storageSet);
        StorageOrgUnitCollection StorageCollection = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(storageEv);
        HashMap<String, StorageOrgUnitInfo> storageMap = new HashMap<String, StorageOrgUnitInfo>();
        if (StorageCollection != null && StorageCollection.size() > 0) {
            for (int i = 0; i < StorageCollection.size(); ++i) {
                StorageOrgUnitInfo storageOrgUnitInfo = StorageCollection.get(i);
                String number = storageOrgUnitInfo.getNumber();
                storageMap.put(number, storageOrgUnitInfo);
            }
        }
        return storageMap;
    }
}

