/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBackFromCarryBillSQLHelper;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CB2SRWriteBackHandler
extends AbstractWriteBackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{false, false, false, false, false, true};
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            String coreBosType;
            BOSObjectType coreBosTypeObj;
            BOSObjectType bOSObjectType = coreBosTypeObj = ids[i][1] == null ? null : BOSUuid.read((String)ids[i][1]).getType();
            if (coreBosTypeObj == null || (coreBosType = coreBosTypeObj.toString()) == null || !coreBosType.equals("C48A423A")) continue;
            isWriteCore[1] = true;
        }
        String idList = WriteBackSQLHelper.getKeyIdList((String[])billId);
        String tablename_core = null;
        String tablename_source = null;
        try {
            ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            tablename_source = iTableManager.getTableName("WRITEBACK_CB2SR");
            String CR_TEMP = WriteBackFromCarryBillSQLHelper.getCB2SRTempTableSQL((String)tablename_source);
            iTableManager.createTempTable(CR_TEMP);
            String WB_TEMP = WriteBackFromCarryBillSQLHelper.getCB2SRInsertTempSQL((String)idList, (String)tablename_source);
            PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
            this.executeUpdate(ps, null);
            tablename_core = iTableManager.getTableName("WRITEBACK_CB2SO");
            String CR_TEMP2 = WriteBackFromCarryBillSQLHelper.getCB2SOTempTableSQL((String)tablename_core);
            iTableManager.createTempTable(CR_TEMP2);
            String WB_TEMP2 = WriteBackFromCarryBillSQLHelper.getCB2SOInsertTempSQL((String)idList, (String)tablename_core);
            PreparedStatement ps2 = this.createPreparedStatement("WB_TEMP2", WB_TEMP2);
            this.executeUpdate(ps2, null);
            if (isWriteCore[5]) {
                this.batchWriteBackSaleReturnsBill(bizAction, idList, tablename_source);
            }
            if (isWriteCore[1]) {
                this.batchWriteBackSaleOrder(bizAction, idList, tablename_core);
            }
            if (bizAction == BizActionEnum.AUDIT) {
                this.verify(ctx, idList, isWriteCore, tablename_core);
            }
            this.dropTempTable(ctx, tablename_source);
            this.dropTempTable(ctx, tablename_core);
        }
        catch (Throwable throwable) {
            this.dropTempTable(ctx, tablename_source);
            this.dropTempTable(ctx, tablename_core);
            throw throwable;
        }
    }

    protected boolean directlyInDB() {
        return true;
    }

    private void batchWriteBackSaleReturnsBill(BizActionEnum bizAction, String idList, String tablename) throws SQLException, BOSException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_SR_Audit", WriteBackFromCarryBillSQLHelper.createCB2SRWriteSQL((BizActionEnum)bizAction, (String)idList, (String)tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_SR_UnAduit", WriteBackFromCarryBillSQLHelper.createCB2SRWriteSQL((BizActionEnum)bizAction, (String)idList, (String)tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void batchWriteBackSaleOrder(BizActionEnum bizAction, String idList, String tablename) throws SQLException {
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_SO_Audit", WriteBackFromCarryBillSQLHelper.createCB2SOForSRWriteSQL((BizActionEnum)bizAction, (String)idList, (String)tablename));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_SO_UnAduit", WriteBackFromCarryBillSQLHelper.createCB2SOForSRWriteSQL((BizActionEnum)bizAction, (String)idList, (String)tablename));
        }
        this.executeUpdate(ps, null);
    }

    private void verify(Context ctx, String idList, boolean[] isWriteCore, String tablename) throws SCMBillException, SQLException {
        String VERIFY = WriteBackFromCarryBillSQLHelper.createCBWriteBackVerifySQL((Context)ctx, (String)idList, (boolean[])isWriteCore, (String)tablename, (boolean)false);
        if (!StringUtils.isEmpty((String)VERIFY)) {
            PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
            IRowSet rs = this.executeQuery(ps, null);
            WriteBackFromCarryBillSQLHelper.verifyCBWriteBack((IRowSet)rs);
        }
    }

    private void dropTempTable(Context ctx, String temptable) {
        if (temptable != null) {
            try {
                ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                iTableManager.releaseTemporaryTableName(temptable);
                iTableManager.dropReleasedTable();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

