/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.ParamsUtil;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryCollection;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractPostRequisitionWebFacadeControllerBean;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PostRequisitionWebFacadeControllerBean
extends AbstractPostRequisitionWebFacadeControllerBean {
    private static final long serialVersionUID = -2785902264343378382L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.PostRequisitionWebFacadeControllerBean");

    protected Map _handleBillByOprtState(Context ctx, String billId, String oprtState) throws BOSException, EASBizException {
        return super._handleBillByOprtState(ctx, billId, oprtState);
    }

    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PostRequisitionInfo info = (PostRequisitionInfo)model;
        CompanyOrgUnitInfo companyInfo = null;
        if (info != null && info.getSaleOrgUnit() != null && info.getSaleOrgUnit().getId() != null) {
            info.setCU(info.getSaleOrgUnit().getCU());
            companyInfo = this.getCompanyOrgBySaleOrg(ctx, info.getSaleOrgUnit().getId().toString());
            if (companyInfo != null) {
                CurrencyInfo baseCurrencyInfo = this.getBaseCurrencyByCompany(ctx, companyInfo);
                companyInfo.setBaseCurrency(baseCurrencyInfo);
                info.setCompanyOrgUnit(companyInfo);
                info.setCurrency(baseCurrencyInfo);
            }
        }
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        Calendar cal = Calendar.getInstance();
        info.setBizDate(cal.getTime());
        info.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        info.setCreator(userInfo);
        PostRequisitionEntryInfo entryInfo = (PostRequisitionEntryInfo)this.createNewDetailData(ctx);
        for (int i = 0; i < 5; ++i) {
            info.getEntries().add(entryInfo);
        }
        return info;
    }

    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        Date bizData;
        HashMap<String, Object> map = new HashMap<String, Object>();
        PostRequisitionInfo info = (PostRequisitionInfo)model;
        String saleOrgFilter = "id in " + this.getSaleOrgFilter(ctx);
        map.put("saleOrgFilter", saleOrgFilter);
        String saleOrgUnitId = info.getSaleOrgUnit().getId().toString();
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(saleOrgUnitId);
        map.put("bizOrgCUID", bizOrgCUID);
        if (info.getSaleOrgUnit() == null && info.getSaleOrgUnit().getId() != null) {
            return map;
        }
        if (info.getSourceBillType() == null) {
            return map;
        }
        map.put("defaultSaleOrg", info.getSaleOrgUnit());
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgBySaleOrg(ctx, saleOrgUnitId);
        CurrencyInfo baseCurrencyInfo = null;
        if (companyInfo != null) {
            baseCurrencyInfo = this.getBaseCurrencyByCompany(ctx, companyInfo);
            companyInfo.setBaseCurrency(baseCurrencyInfo);
            map.put("defaultCompany", companyInfo);
            map.put("baseCurrency", baseCurrencyInfo);
        }
        if (info.getStorageOrgUnit() != null && info.getStorageOrgUnit().getId() != null) {
            map.put("defaultStorageOrg", info.getStorageOrgUnit());
        }
        map.put("storageF7Filter", this.getStorageOrgFilter(ctx, saleOrgUnitId));
        if (info.getCurrency() != null) {
            map.put("currency", CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()), this.getCurrencySelectors()));
        }
        if ((bizData = info.getBizDate()) == null) {
            bizData = new Date();
        }
        info.setCU(info.getSaleOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new PostRequisitionInfo(), info.getSaleOrgUnit().getId().toString());
        if (ruleInfo != null) {
            map.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getNumber() == null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                map.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getSaleOrgUnit().getId().toString()));
            }
        }
        if (null != baseCurrencyInfo) {
            ExchangeRateInfo exchangeRateInfo = PostRequisitionWebFacadeControllerBean.getExchangeRate(ctx, companyInfo, (IObjectPK)new ObjectUuidPK(info.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId()), bizData);
            map.put("exchangeRateInfo", exchangeRateInfo);
        }
        Map paramMap = this.batchGetParamValue(ctx, null, new String[]{"SALEORDER002", "POSTREQUISITION001"});
        map.put("params", paramMap);
        map.put("adminF7Filter", this.getAdminF7Filter(ctx, saleOrgUnitId));
        PostRequisitionEntryCollection entryColl = info.getEntries();
        HashSet<String> sendAddressInfoSet = new HashSet<String>();
        PostRequisitionEntryInfo entry = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entry = entryColl.get(i);
            if (info.getBaseStatus() == BillBaseStatusEnum.ADD && info.getSourceBillType() != null && entry.getMaterial() != null) {
                MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entry.getMaterial().getId()));
                entry.setMaterial(material);
            }
            if (entry.getDeliveryAddress() == null) continue;
            sendAddressInfoSet.add(entry.getDeliveryAddress());
        }
        if (sendAddressInfoSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("address", sendAddressInfoSet, CompareType.INCLUDE));
            view.setFilter(filter);
            CoreBaseCollection addressCollection = CustomerDeliveryAddressFactory.getLocalInstance((Context)ctx).getCollection(view);
            HashMap<String, CustomerDeliveryAddressInfo> sendAddressInfoMap = new HashMap<String, CustomerDeliveryAddressInfo>();
            for (int i = 0; i < addressCollection.size(); ++i) {
                sendAddressInfoMap.put(((CustomerDeliveryAddressInfo)addressCollection.get(i)).getAddress(), (CustomerDeliveryAddressInfo)addressCollection.get(i));
            }
            map.put("sendAddressInfoMap", sendAddressInfoMap);
        }
        return map;
    }

    protected Map _handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        if (mainOrgId == null) {
            return null;
        }
        HashMap<String, CurrencyInfo> map = new HashMap<String, CurrencyInfo>();
        String saleOrgUnitId = mainOrgId;
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgBySaleOrg(ctx, saleOrgUnitId);
        CurrencyInfo baseCurrencyInfo = null;
        if (companyInfo != null) {
            baseCurrencyInfo = this.getBaseCurrencyByCompany(ctx, companyInfo);
            map.put("baseCurrency", baseCurrencyInfo);
        }
        return map;
    }

    public IObjectValue createNewDetailData(Context context) throws BOSException, EASBizException {
        PostRequisitionEntryInfo entryInfo = new PostRequisitionEntryInfo();
        entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
        return entryInfo;
    }

    private String getSaleOrgFilter(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullSaleColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Sale, null, "postreq_addnew");
        if (fullSaleColl == null || fullSaleColl.size() == 0) {
            return "('xxxxxxxx')";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < fullSaleColl.size(); ++i) {
            sb.append("'").append(fullSaleColl.get(i).getId().toString()).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    private CompanyOrgUnitInfo getCompanyOrgBySaleOrg(Context ctx, String souId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getToUnit(souId, 2, 1);
        if (coll != null && coll.size() > 0) {
            company = (CompanyOrgUnitInfo)coll.get(0);
        }
        return company;
    }

    private String getStorageOrgFilter(Context ctx, String orgId) throws BOSException, EASBizException {
        StringBuffer filter = new StringBuffer();
        String orgFilter = this.getOrgFilterStr(ctx, this.getStorageOrgUnitBySaleOrg(ctx, orgId));
        filter.append("id in").append(orgFilter);
        return filter.toString();
    }

    private CurrencyInfo getBaseCurrencyByCompany(Context ctx, CompanyOrgUnitInfo cou) throws BOSException, EASBizException {
        if (cou != null && cou.getBaseCurrency() != null) {
            CurrencyInfo baseCurrencyInfo = cou.getBaseCurrency().getName() != null ? cou.getBaseCurrency() : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()), this.getCurrencySelectors());
            return baseCurrencyInfo;
        }
        return null;
    }

    private OrgUnitCollection getStorageOrgUnitBySaleOrg(Context ctx, String souId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getFromUnit(souId, 2, 4);
        return coll;
    }

    private OrgUnitCollection getAdminOrgUnitBySou(Context ctx, String souId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getToUnit(souId, 2, 0);
        return coll;
    }

    private String getAdminF7Filter(Context ctx, String orgId) throws EASBizException, BOSException {
        StringBuffer filter = new StringBuffer();
        String orgFilter = this.getOrgFilterStr(ctx, this.getAdminOrgUnitBySou(ctx, orgId));
        filter.append("id in").append(orgFilter);
        return filter.toString();
    }

    public String getParamValue(ObjectUuidPK orgUnitID, String paramNumber) throws EASBizException, BOSException {
        return ParamsUtil.getParamsValue((ObjectUuidPK)orgUnitID, (String)paramNumber);
    }

    public Map batchGetParamValue(Context ctx, String orgId, String[] numbers) throws EASBizException, BOSException {
        return ParamManager.getParamHashMap((Context)ctx, (String[])numbers, (String)orgId);
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK, Date bizDate) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK, bizDate);
        return exchangeRateInfo;
    }

    public OrgType getMainOrgType() {
        return OrgType.Sale;
    }

    public String getPermissionItem() {
        return "postreq_addnew";
    }
}

