/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.scm.sd.sale.BlockedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.sd.sale.PromotionModeEntryCollection;
import com.kingdee.eas.scm.sd.sale.PromotionModeEntryInfo;
import com.kingdee.eas.scm.sd.sale.PromotionModeInfo;
import com.kingdee.eas.scm.sd.sale.SalePromotionException;
import com.kingdee.eas.scm.sd.sale.app.AbstractPromotionModeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class PromotionModeControllerBean
extends AbstractPromotionModeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.PromotionModeControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PromotionModeInfo pmInfo = (PromotionModeInfo)model;
        PromotionModeEntryCollection pmEColl = pmInfo.getEntry();
        PromotionModeEntryInfo pmEInfo = null;
        int size = pmEColl.size();
        for (int i = 0; i < size; ++i) {
            pmEInfo = pmEColl.get(i);
            if (pmEInfo.isIsSupport()) continue;
            pmEColl.remove(pmEInfo);
            size = pmEColl.size();
            --i;
        }
        if (pmEColl.size() > 0) {
            return super._submit(ctx, model);
        }
        throw new SalePromotionException(SalePromotionException.PROMOTIONMODENINPUTENTRY);
    }

    protected void addnewCheck(Context ctx, PromotionModeInfo model) throws BOSException, EASBizException {
        model.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this._checkNumberBlank(ctx, (IObjectValue)model);
        try {
            this._checkNumberDup(ctx, (IObjectValue)model);
        }
        catch (EASBizException er) {
            throw new SalePromotionException(SalePromotionException.PROMOTIONMODENUMBERDUPLICATED, new Object[]{model.getNumber()});
        }
        this._checkNameBlank(ctx, (IObjectValue)model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (PromotionModeInfo)model);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (PromotionModeInfo)model);
        super._addnew(ctx, pk, model);
    }

    protected void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PromotionModeInfo oldModel = this.getPromotionModeInfo(ctx, pk);
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            try {
                this._checkNumberDup(ctx, model);
            }
            catch (EASBizException er) {
                throw new SalePromotionException(SalePromotionException.PROMOTIONMODENUMBERDUPLICATED, new Object[]{((PromotionModeInfo)model).getNumber()});
            }
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    @Override
    public void _block(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.canBlock(ctx, pks);
        for (IObjectPK aPK : pks) {
            PromotionModeInfo info = (PromotionModeInfo)this.getValue(ctx, aPK);
            info.setBlockedStatus(BlockedStatusEnum.BLOCKED);
            super.update(ctx, aPK, info);
        }
    }

    private void canBlock(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        for (IObjectPK aPK : pk) {
            PromotionModeInfo info = (PromotionModeInfo)this.getValue(ctx, aPK);
            if (info.getId() == null) {
                throw new SalePromotionException(SalePromotionException.NULL_ID);
            }
            if (info.getBlockedStatus().getValue() != 2) continue;
            throw new SalePromotionException(SalePromotionException.PART_CANNOT_BLOCKED);
        }
    }

    @Override
    public void _unBlock(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.canUnBlock(ctx, pks);
        for (IObjectPK aPK : pks) {
            PromotionModeInfo info = (PromotionModeInfo)this.getValue(ctx, aPK);
            info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
            super.update(ctx, aPK, info);
        }
    }

    private void canUnBlock(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        for (IObjectPK aPK : pk) {
            PromotionModeInfo info = (PromotionModeInfo)this.getValue(ctx, aPK);
            if (info.getId() == null) {
                throw new SalePromotionException(SalePromotionException.NULL_ID);
            }
            if (info.getBlockedStatus().getValue() == 2) continue;
            throw new SalePromotionException(SalePromotionException.PART_CANNOT_UNBLOCKED);
        }
    }

    @Override
    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PromotionModeInfo promotionMode = this.getPromotionModeInfo(ctx, pk);
        if (promotionMode.isIsSysPreSet()) {
            throw new SalePromotionException(SalePromotionException.CANNOTDELETEMODEPRESET);
        }
        super._delete(ctx, pk);
    }
}

