/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.IQuotationEntry;
import com.kingdee.eas.scm.sd.sale.QuotationEntryCollection;
import com.kingdee.eas.scm.sd.sale.QuotationEntryFactory;
import com.kingdee.eas.scm.sd.sale.QuotationEntryInfo;
import com.kingdee.eas.scm.sd.sale.QuotationException;
import com.kingdee.eas.scm.sd.sale.app.AbstractQuotationEntryControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class QuotationEntryControllerBean
extends AbstractQuotationEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.QuotationEntryControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.scm.sd.sale.QuotationResource";
    private static final String SP = "\r\n";

    protected void checkClose(Context ctx, String[] pks) throws BOSException, EASBizException {
        if (pks != null && pks.length > 0) {
            IQuotationEntry iQuotationEntry = QuotationEntryFactory.getLocalInstance(ctx);
            HashSet<String> idSet = new HashSet<String>();
            for (String pk : pks) {
                idSet.add(pk);
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("qty"));
            selector.add(new SelectorItemInfo("baseStatus"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            QuotationEntryCollection quotationCollection = iQuotationEntry.getQuotationEntryCollection(view);
            int size = quotationCollection.size();
            for (int i = 0; i < size; ++i) {
                QuotationEntryInfo quotationEntryInfo = quotationCollection.get(i);
                if (quotationEntryInfo.getBaseStatus().getValue() == 4) continue;
                if (pks.length > 1) {
                    throw new QuotationException(QuotationException.QUO_PARTCANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)RESOURCE, (String)"OPERATOR_CLOSE", (Context)ctx)});
                }
                throw new QuotationException(QuotationException.QUO_CANNOT_CLOSE);
            }
        } else {
            throw new QuotationException(QuotationException.ENTRY_CANNOT_EMPTY);
        }
    }

    @Override
    protected void _handClose(Context ctx, String pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        this.checkClose(ctx, new String[]{pk});
        this.closeOrUnCloseEntries(ctx, new String[]{pk}, ((ReasonCodeInfo)reasonCode).getName(), true);
        this.closeOrUnCloseBills(ctx, new String[]{pk}, true);
    }

    @Override
    protected void _handClose(Context ctx, String[] pks, IObjectValue reasonCodes) throws BOSException, EASBizException {
        this.checkClose(ctx, pks);
        this.closeOrUnCloseEntries(ctx, pks, ((ReasonCodeInfo)reasonCodes).getName(), true);
        this.closeOrUnCloseBills(ctx, pks, true);
    }

    @Override
    protected void _handClose(Context ctx, String pk, String reasonStr) throws BOSException, EASBizException {
        this.checkClose(ctx, new String[]{pk});
        this.closeOrUnCloseEntries(ctx, new String[]{pk}, reasonStr, true);
        this.closeOrUnCloseBills(ctx, new String[]{pk}, true);
    }

    @Override
    protected void _handClose(Context ctx, String[] pks, String reasonStr) throws BOSException, EASBizException {
        this.checkClose(ctx, pks);
        this.closeOrUnCloseEntries(ctx, pks, reasonStr, true);
        this.closeOrUnCloseBills(ctx, pks, true);
    }

    @Override
    protected void _handUnClose(Context ctx, String pk) throws BOSException, EASBizException {
        this.checkUnClose(ctx, new String[]{pk});
        this.closeOrUnCloseEntries(ctx, new String[]{pk}, null, false);
        this.closeOrUnCloseBills(ctx, new String[]{pk}, false);
    }

    @Override
    protected void _handUnClose(Context ctx, String[] pks) throws BOSException, EASBizException {
        this.checkUnClose(ctx, pks);
        this.closeOrUnCloseEntries(ctx, pks, null, false);
        this.closeOrUnCloseBills(ctx, pks, false);
    }

    protected void checkUnClose(Context ctx, String[] pks) throws BOSException, EASBizException {
        String queryEntrySql = "SELECT 1 FROM T_SD_QUOTATIONENTRY WHERE FID IN (" + this.generateQuestionMarkAndCommaBySize(pks.length) + ") AND FBASESTATUS <> ?";
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(pks));
        tmp.add((String)((Object)Integer.valueOf(7)));
        Object[] param = tmp.toArray();
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)queryEntrySql, (Object[])param);
        try {
            if (set.next()) {
                if (pks.length > 1) {
                    throw new QuotationException(QuotationException.QUO_PARTCANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)RESOURCE, (String)"OPERATOR_UNCLOSE", (Context)ctx)});
                }
                throw new QuotationException(QuotationException.QUO_CANNOT_UNCLOSE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void closeOrUnCloseEntries(Context ctx, String[] id, String reason, Boolean isClose) throws BOSException {
        String closeSql = "UPDATE T_SD_QUOTATIONENTRY SET FBASESTATUS = ?, FREASON = ? WHERE FID IN (" + this.generateQuestionMarkAndCommaBySize(id.length) + ") AND FBASESTATUS = ?";
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (isClose.booleanValue()) {
            paramList.add(7);
            paramList.add(reason);
            for (int i = 0; i < id.length; ++i) {
                paramList.add(id[i]);
            }
            paramList.add(4);
        } else {
            paramList.add(4);
            paramList.add(null);
            for (int i = 0; i < id.length; ++i) {
                paramList.add(id[i]);
            }
            paramList.add(7);
        }
        DbUtil.execute((Context)ctx, (String)closeSql, (Object[])paramList.toArray());
    }

    protected void closeOrUnCloseBills(Context ctx, String[] entriesIds, Boolean isClose) throws BOSException {
        String queryParentIdsSql = "SELECT FPARENTID FROM T_SD_QUOTATIONENTRY WHERE FID IN (" + this.generateQuestionMarkAndCommaBySize(entriesIds.length) + ")";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)queryParentIdsSql, (Object[])entriesIds);
        HashSet<String> parentIdSet = new HashSet<String>();
        try {
            set.beforeFirst();
            while (set.next()) {
                parentIdSet.add(set.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Object[] parentIds = parentIdSet.toArray();
        StringBuffer closeSql = new StringBuffer();
        closeSql.append("UPDATE T_SD_QUOTATION SET FBASESTATUS = ?").append(" WHERE ").append(SP);
        closeSql.append(isClose != false ? "NOT" : "").append(" EXISTS ");
        closeSql.append("(SELECT 1 FROM T_SD_QUOTATIONENTRY WHERE FBASESTATUS = ? AND FPARENTID = ?)").append(SP);
        closeSql.append(" AND FID = ?");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        if (isClose.booleanValue()) {
            for (int i = 0; i < parentIds.length; ++i) {
                Object[] param = new Object[]{7, 4, parentIds[i], parentIds[i]};
                paramsList.add(param);
            }
        } else {
            for (int i = 0; i < parentIds.length; ++i) {
                Object[] param = new Object[]{4, 4, parentIds[i], parentIds[i]};
                paramsList.add(param);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)closeSql.toString(), paramsList);
    }

    private String generateQuestionMarkAndCommaBySize(Integer size) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                result.append("?");
                continue;
            }
            result.append("?,");
        }
        return result.toString();
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("seq"));
        QuotationEntryInfo info = this.getQuotationEntryInfo(ctx, pk, sic);
        String logInfoStr = null;
        logInfoStr = null != info.getParent() && null != info.getParent().getNumber() ? info.getParent().getNumber().toString() + "  " + info.getSeq() : pk.toString();
        return logInfoStr;
    }
}

