/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountCollection;
import com.kingdee.eas.basedata.assistant.CashDiscountFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICashDiscount;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeCollection;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeFactory;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceCollection;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceFactory;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceTreeFactory;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceTreeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IContrace;
import com.kingdee.eas.basedata.scm.sd.sale.ISaleGroup;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sd.sale.AbstractSaleContractInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractTermCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractTermInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SaleContractDataImport
extends SCMDataImport {
    HashMap bizTypeMap = new HashMap();
    HashMap orderCusMap = new HashMap();
    HashMap deliverTypeMap = new HashMap();
    HashMap salePersonMap = new HashMap();
    HashMap currencyMap = new HashMap();
    HashMap paramMap = new HashMap();
    HashMap saleRelationMap = new HashMap();
    Map<String, ContraceTreeInfo> contraceTreeInfoMap = new HashMap<String, ContraceTreeInfo>();
    HashMap propertyMap = new HashMap();
    String[] BIGDECIMAL_FIELDS = new String[]{"FExchangeRate"};
    String[] BIGDECIMAL_OBJ = new String[]{"exchangeRate"};
    String[] STRING_FIELDS = new String[]{"FDescription", "FDeliveryAddress", "FSignAddress"};
    String[] STRING_OBJS = new String[]{"description", "deliveryAddress", "signAddress"};
    String[] DATE_FIELDS = new String[]{"FBizDate", "FValidTo"};
    String[] DATE_OBJS = new String[]{"bizDate", "validTo"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsInTax"};
    String[] BOOLEAN_OBJS = new String[]{"isInTax"};
    String[] ENUM_FIELDS = new String[]{"FBaseStatus"};
    String[] ENUM_OBJS = new String[]{"baseStatus"};
    String[] INTEGER_FIELDS = new String[]{"FTransLeadTime"};
    String[] INTEGER_OBJS = new String[]{"transLeadTime", "year", "period"};
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    BigDecimal oneHundred = new BigDecimal("100.0");
    HashMap exchangeRateMap = new HashMap();
    CtrlUnitInfo cu = null;
    SaleOrgUnitInfo sou = null;
    ImportDataCache dataPool = new ImportDataCache();
    private int discountRatePrePrecision = 6;
    private int materialPricePrecision = 2;
    int currencyPrecision = 2;
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FEntries_price", "FEntries_taxPrice", "FEntries_amount", "FEntries_taxRate", "FEntries_tax", "FEntries_taxAmount", "FEntries_qty", "FEntries_assistQty", "FEntries_discount", "FEntries_discountAmount", "FEntries_actualTaxPrice", "FEntries_sendOverRate", "FEntries_sendOwingRate", "FEntries_sendAdvanceDay", "FEntries_sendDeferralDay", "FEntries_prepaymentRate", "FEntries_preReceived"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"price", "taxPrice", "amount", "taxRate", "tax", "taxAmount", "qty", "assistQty", "discount", "discountAmount", "actualTaxPrice", "sendOverRate", "sendOwingRate", "sendAdvanceDay", "sendDeferralDay", "prepaymentRate", "preReceived"};
    String[] STRING_FIELDS_EN = new String[]{"FEntries_remark"};
    String[] STRING_OBJS_EN = new String[]{"remark"};
    String[] DATE_FIELDS_EN = new String[]{"FEntries_sendDate", "FEntries_deliveryDate"};
    String[] DATE_OBJS_EN = new String[]{"sendDate", "deliveryDate"};
    String[] BOOLEAN_FIELDS_EN = new String[]{"FEntries_quantityUnCtrl"};
    String[] BOOLEAN_OBJS_EN = new String[]{"quantityUnCtrl"};
    String[] ENUM_FIELDS_EN = new String[]{"FDiscountCondition", "FDiscountType", "FEntryBaseStatus"};
    String[] ENUM_OBJS_EN = new String[]{"discountCondition", "discountType", "baseStatus"};
    String[] MUST_NEED = new String[]{"FSaleOrgUnit_number", "FEntries$material_number", "FSalePerson_number", "FEntries$unit_number", "FEntries_qty", "FCurrency_number", "FExchangeRate", "FBizType_number", "FBizDate", "FCustomer_number", "FEntries_price", "FDeliveryType_number", "FEntries$storageOrgUnit_number", "FEntries_sendDate"};
    private final String[] priceFields = new String[]{"price", "taxPrice", "actualTaxPrice", "actualPrice"};
    private final String[] amountFields = new String[]{"amount", "taxRate", "tax", "taxAmount", "discountAmount", "totalReceivedAmount", "prepayment", "preReceived", "invoiceReqAmount", "unInvoiceReqAmount"};
    private final String[] localAmountFields = new String[]{"localTax", "localTaxAmount", "localAmount", "invoiceReqAmountLocal", "unInvoiceReqAmountLocal"};
    private static final String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";

    public ContraceTreeInfo getContraceTreeInfo(String propertyName) {
        return this.contraceTreeInfoMap.get(propertyName);
    }

    public void setContraceTreeInfo(String key, ContraceTreeInfo info) {
        this.contraceTreeInfoMap.put(key, info);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SaleContractFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        AbstractSaleContractInfo saleContractInfo = null;
        int keyCursor = 0;
        TaskExternalException ex = new TaskExternalException("");
        String[] rateFields = new String[]{"sendOverRate", "sendOwingRate", "prepaymentRate"};
        for (int k = 0; k < hsData.size(); ++k) {
            try {
                Map lineData = (Map)hsData.get(new Integer(k));
                if (keyCursor == 0) {
                    saleContractInfo = this.transmitHead(lineData, ctx);
                    this.afterBuildHead(ctx, (SCMBillBaseInfo)saleContractInfo, lineData);
                    this.doContractTerms((SaleContractInfo)saleContractInfo, ctx);
                }
                SaleContractEntryInfo entryInfo = null;
                SaleContractEntryCollection entryCollection = saleContractInfo.getEntries();
                int seq = entryCollection.size() + 1;
                entryInfo = new SaleContractEntryInfo();
                entryInfo.setParent((SaleContractInfo)saleContractInfo);
                entryInfo.setSeq(seq);
                entryCollection.add(entryInfo);
                this.handleEntry((SaleContractInfo)saleContractInfo, entryInfo, lineData, ctx);
                this.calEntry(ctx, (SaleContractInfo)saleContractInfo, entryInfo);
                this.afterBuildEntry(ctx, (SCMBillBaseInfo)saleContractInfo, (SCMBillEntryBaseInfo)entryInfo, hsData);
                this.setFieldPrecision((SCMBillEntryBaseInfo)entryInfo, 2, rateFields);
                if (keyCursor == hsData.size() - 1) {
                    this.recalAmount(ctx, (SaleContractInfo)saleContractInfo);
                }
            }
            catch (TaskExternalException e) {
                if (keyCursor == hsData.size() - 1) {
                    ex.addEntryErrorReason(0, e.getMessage());
                } else {
                    ex.addEntryErrorReason(k, e.getMessage());
                }
                if (ex.getEntryErrorReasons().size() == 1) {
                    this.recycleNumber(ctx, (SCMBillBaseInfo)saleContractInfo);
                }
                if (keyCursor == 0) break;
            }
            ++keyCursor;
        }
        if (ex.getEntryErrorReasons().size() > 0) {
            throw ex;
        }
        return saleContractInfo;
    }

    private void doContractTerms(SaleContractInfo saleContractInfo, Context ctx) throws TaskExternalException {
        ContraceTreeInfo info = saleContractInfo.getContractType();
        if (info != null) {
            SaleContractTermCollection coll = saleContractInfo.getTerms();
            if (info != null) {
                try {
                    IContrace contrace = ContraceFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    String treeId = info.getId().toString();
                    filter.getFilterItems().add(new FilterItemInfo("treeid", (Object)treeId, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("FStart", (Object)true, CompareType.EQUALS));
                    filter.setMaskString("#0 and #1 ");
                    ev.setFilter(filter);
                    SorterItemCollection sic = ev.getSorter();
                    sic.add(new SorterItemInfo("fseq"));
                    ContraceCollection contraceCollection = contrace.getContraceCollection(ev);
                    ContraceInfo contraceInfo = null;
                    SaleContractTermInfo saleContractTermInfo = null;
                    int num = contraceCollection.size();
                    for (int i = 0; i < num; ++i) {
                        contraceInfo = (ContraceInfo)contraceCollection.getObject(i);
                        saleContractTermInfo = new SaleContractTermInfo();
                        saleContractTermInfo.setTermContent(contraceInfo.getName());
                        saleContractTermInfo.setParent(saleContractInfo);
                        coll.add(saleContractTermInfo);
                    }
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage());
                }
            }
        }
    }

    private void recalAmount(Context ctx, SaleContractInfo saleContractInfo) throws TaskExternalException {
        BigDecimal exchangerate;
        BigDecimal bigDecimal = exchangerate = saleContractInfo.getExchangeRate() == null ? new BigDecimal("1.00") : saleContractInfo.getExchangeRate();
        if (exchangerate.compareTo(ZERO) == 0) {
            exchangerate = new BigDecimal("1.00");
        }
        CurrencyInfo baseCurrencyInfo = null;
        Object currencyInfo = null;
        ExchangeRateInfo exchangeRateInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        int baseCurrencyPrecision = 2;
        int currencyPrecision = 2;
        String number = "";
        if (saleContractInfo.getNumber() != null && saleContractInfo.getNumber().toString().length() > 0) {
            number = saleContractInfo.getNumber().toString();
        }
        try {
            if (!this.exchangeRateMap.containsKey("exchangeRateInfo" + number)) {
                CurrencyInfo info;
                ICurrency icurreny;
                CurrencyCollection collection;
                if (saleContractInfo.getCurrency() != null && saleContractInfo.getCurrency().getId() != null && (collection = (icurreny = CurrencyFactory.getLocalInstance((Context)ctx)).getCurrencyCollection("where id='" + saleContractInfo.getCurrency().getId().toString() + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    this.exchangeRateMap.put("currencyInfo" + number, info);
                }
                if (saleContractInfo.getCompanyOrgUnit() != null && saleContractInfo.getCompanyOrgUnit().getBaseCurrency() != null) {
                    baseCurrencyInfo = saleContractInfo.getCompanyOrgUnit().getBaseCurrency();
                    companyInfo = saleContractInfo.getCompanyOrgUnit();
                    this.exchangeRateMap.put("baseCurrencyInfo" + number, CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId())));
                } else {
                    IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                    OrgUnitCollection orgCollection = null;
                    if (saleContractInfo.getSaleOrgUnit() != null) {
                        orgCollection = iOrgRelation.getToUnit(saleContractInfo.getSaleOrgUnit().getId().toString(), 2, 1);
                    }
                    if (orgCollection != null && orgCollection.size() > 0) {
                        Object[] objs = orgCollection.toArray();
                        OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
                        System.arraycopy(objs, 0, orgs, 0, objs.length);
                        companyInfo = (CompanyOrgUnitInfo)orgs[0];
                        baseCurrencyInfo = companyInfo.getBaseCurrency();
                        this.exchangeRateMap.put("baseCurrencyInfo" + number, CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId())));
                    }
                }
                if (baseCurrencyInfo != null && baseCurrencyInfo.getId() != null && companyInfo != null && companyInfo.getBaseExchangeTable() != null) {
                    baseCurrencyPrecision = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId())).getPrecision();
                    if (saleContractInfo.getCurrency() != null && saleContractInfo.getCurrency().getId() != null) {
                        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)new ObjectUuidPK(companyInfo.getBaseExchangeTable().getId()), (IObjectPK)new ObjectUuidPK(saleContractInfo.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId()));
                        this.exchangeRateMap.put("exchangeRateInfo" + number, exchangeRateInfo);
                    }
                }
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        if (this.exchangeRateMap.containsKey("exchangeRateInfo" + number)) {
            exchangeRateInfo = (ExchangeRateInfo)this.exchangeRateMap.get("exchangeRateInfo" + number);
        }
        if (this.exchangeRateMap.containsKey("baseCurrencyInfo" + number)) {
            baseCurrencyPrecision = ((CurrencyInfo)this.exchangeRateMap.get("baseCurrencyInfo" + number)).getPrecision();
        }
        if (this.exchangeRateMap.containsKey("currencyInfo" + number)) {
            currencyPrecision = ((CurrencyInfo)this.exchangeRateMap.get("currencyInfo" + number)).getPrecision();
        }
        BigDecimal amount = ZERO;
        BigDecimal tax = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal localAmount = ZERO;
        BigDecimal localTax = ZERO;
        BigDecimal localTaxAmount = ZERO;
        BigDecimal prepareAmount = ZERO;
        int size = saleContractInfo.getEntries().size();
        for (int n = 0; n < size; ++n) {
            SaleContractEntryInfo entryInfo = saleContractInfo.getEntries().get(n);
            amount = ZERO;
            tax = ZERO;
            taxAmount = ZERO;
            if (entryInfo.getAmount() != null) {
                amount = entryInfo.getAmount();
            }
            if (entryInfo.getTax() != null) {
                tax = entryInfo.getTax();
            }
            if (entryInfo.getTaxAmount() != null) {
                taxAmount = entryInfo.getTaxAmount();
            }
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            if (tax != null && exchangerate != null) {
                if (exchangeRateInfo != null) {
                    if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        entryInfo.setLocalTax(tax.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                    } else {
                        entryInfo.setLocalTax(tax.divide(exchangerate, baseCurrencyPrecision, 4));
                    }
                } else {
                    entryInfo.setLocalTax(tax.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                }
            } else {
                entryInfo.setLocalTax(ZERO);
            }
            localTax = localTax.add(entryInfo.getLocalTax());
            if (taxAmount != null && exchangerate != null) {
                if (exchangeRateInfo != null) {
                    if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        entryInfo.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                    } else {
                        entryInfo.setLocalTaxAmount(taxAmount.divide(exchangerate, baseCurrencyPrecision, 4));
                    }
                } else {
                    entryInfo.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                }
            } else {
                entryInfo.setLocalTaxAmount(ZERO);
            }
            localTaxAmount = localTaxAmount.add(entryInfo.getLocalTaxAmount());
            if (entryInfo.getPrepayment() != null && entryInfo.getPrepayment().compareTo(ZERO) != 0) {
                prepareAmount = prepareAmount.add(entryInfo.getPrepayment());
            }
            entryInfo.setLocalAmount(entryInfo.getLocalTaxAmount().subtract(entryInfo.getLocalTax()));
            localAmount = localAmount.add(entryInfo.getLocalAmount());
        }
        saleContractInfo.setLocalTotalAmount(localAmount);
        saleContractInfo.setLocalTotalTaxAmount(localTaxAmount);
        saleContractInfo.setTotalAmount(totalAmount);
        saleContractInfo.setTotalTax(totalTax);
        saleContractInfo.setTotalTaxAmount(totalTaxAmount);
        saleContractInfo.setPrepayment(prepareAmount);
    }

    private void handleEntry(SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo, Map hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        for (int i2 = 0; i2 < this.BIGDECIMAL_FIELDS_EN.length; ++i2) {
            try {
                if (hsData.get(this.BIGDECIMAL_FIELDS_EN[i2]) == null) continue;
                Object o2 = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS_EN[i2])).data;
                if (o2 != null && o2.toString().trim().length() > 0) {
                    BigDecimal value2 = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)((String)o2));
                    if (value2 == null) continue;
                    value2 = value2.abs();
                    entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i2], value2);
                    continue;
                }
                if (this.BIGDECIMAL_FIELDS_EN[i2].equals("FPrice")) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDPRICE", (Context)ctx));
                }
                if (this.BIGDECIMAL_FIELDS_EN[i2].equals("FQty")) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDQTY", (Context)ctx));
                }
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i2], BigDecimal.ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ_EN[i2] + " format error, it must be a number!!!");
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (i = 0; i < this.DATE_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS_EN[i])).data;
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                Logger.error((Throwable)pex);
                throw new TaskExternalException(this.DATE_FIELDS_EN[i] + " format error, it must be a date String, xxxx-xx-xx!!!current date is " + o.toString());
            }
            if (o != null && o instanceof Date) {
                value = (Date)o;
                if (value == null) continue;
                entryInfo.setDate(this.DATE_OBJS_EN[i], (Date)value);
                continue;
            }
            entryInfo.setDate(this.DATE_OBJS_EN[i], new Date());
        }
        for (i = 0; i < this.BOOLEAN_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS_EN[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            entryInfo.setBoolean(this.BOOLEAN_OBJS_EN[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
            Object o3;
            DataToken dataToken = (DataToken)hsData.get(this.STRING_FIELDS_EN[i]);
            if (dataToken == null || (o3 = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data) == null) continue;
            String value3 = o3.toString();
            entryInfo.setString(this.STRING_OBJS_EN[i], value3);
        }
        String value4 = null;
        Object data = ((DataToken)hsData.get((Object)"FEntries_discountType")).data;
        value4 = null;
        if (data != null && (value4 = data.toString()) != null) {
            entryInfo.setDiscountType(this.getDiscountModeEnumValue(value4));
        }
        try {
            MeasureUnitInfo info;
            String str = null;
            MaterialInfo materialInfo = null;
            int contractDetail = 0;
            data = ((DataToken)hsData.get((Object)"FEntries$material_number")).data;
            Object materialGroup_number = ((DataToken)hsData.get((Object)"FEntries$materialGroup_number")).data;
            if (data != null && data.toString().length() > 0) {
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    materialInfo = this.getMaterial(ctx, str, new OrgUnitInfo[0]);
                    ContraceTreeInfo contraceTreeInfo = saleContractInfo.getContractType();
                    if (contraceTreeInfo != null && contraceTreeInfo.getContractDetail() != null) {
                        contractDetail = contraceTreeInfo.getContractDetail().getValue();
                    }
                    if (contractDetail != 2) {
                        entryInfo.setMaterial(materialInfo);
                    }
                }
            } else if (materialGroup_number != null && materialGroup_number.toString().length() > 0) {
                str = materialGroup_number.toString();
                if (str != null && str.trim().length() > 0) {
                    IMaterialGroup iMaterialGroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
                    CoreBaseCollection collection = iMaterialGroup.getCollection("where number='" + str + "'");
                    ContraceTreeInfo contraceTreeInfo = saleContractInfo.getContractType();
                    if (contraceTreeInfo != null && contraceTreeInfo.getContractDetail() != null) {
                        contractDetail = contraceTreeInfo.getContractDetail().getValue();
                    }
                    if (contractDetail == 2 && !CollectionUtil.isEmpty((AbstractObjectCollection)collection) && collection.get(0) != null) {
                        entryInfo.setMaterialGroup((MaterialGroupInfo)collection.get(0));
                    }
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"MATERIAL_NOT_NULL", (Context)ctx));
            }
            if ((data = ((DataToken)hsData.get((Object)"FEntries$unit_number")).data) != null) {
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    info = this.getMeasureUnit(ctx, str, materialInfo);
                    entryInfo.setUnit(info);
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"UNIT_NOT_NULL", (Context)ctx));
            }
            if (null != materialInfo) {
                if (null != materialInfo.getBaseUnit() && (str = materialInfo.getBaseUnit().getNumber()) != null && str.trim().length() > 0) {
                    info = this.getMeasureUnit(ctx, str, materialInfo);
                    entryInfo.setBaseUnit(info);
                    if (entryInfo.getQty() != null && !entryInfo.getQty().equals(BigDecimal.ZERO) && entryInfo.getUnit() != null && entryInfo.getMaterial() != null) {
                        BigDecimal baseUnitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getQty());
                        entryInfo.setBaseQty(baseUnitQty);
                    }
                }
                entryInfo.setAssistUnit(materialInfo.getAssistUnit());
            }
            data = ((DataToken)hsData.get((Object)"FEntries_assistQty")).data;
            if (entryInfo.getAssistUnit() != null && !StringUtil.isEmpty((String)data.toString())) {
                BigDecimal assistQty = new BigDecimal(data.toString());
                entryInfo.setAssistQty(assistQty);
            } else {
                entryInfo.setAssistQty(ZERO);
            }
            if (null != materialInfo && (data = ((DataToken)hsData.get((Object)"FEntries$assistProperty_number")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info = this.getAsstAttr(ctx, str, materialInfo.getAssistAttr());
                entryInfo.setAssistProperty((AsstAttrValueInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FEntries$storageOrgUnit_number")).data) != null) {
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    info = this.getStorageOrgUnit(ctx, "number", str);
                    if (this.sou != null && !this.storageHasRelationwithSale(ctx, this.sou.getId().toString(), info.getId().toString())) {
                        throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"NO_ENTRUST_SALE", (Context)ctx));
                    }
                    entryInfo.setStorageOrgUnit((StorageOrgUnitInfo)info);
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"STORAGE_NOT_NULL", (Context)ctx));
            }
            data = ((DataToken)hsData.get((Object)"FEntries$warehouse_number")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                if (this.dataPool.getWarehouseInfo(str) == null) {
                    WarehouseInfo info2;
                    IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0");
                    viewInfo.setFilter(filter);
                    WarehouseCollection collection = iWarehouse.getWarehouseCollection(viewInfo);
                    if (collection != null && collection.size() > 0 && (info2 = collection.get(0)) != null) {
                        entryInfo.setWarehouse(info2);
                        this.dataPool.setWarehouseInfo(str, info2);
                    }
                } else {
                    entryInfo.setWarehouse(this.dataPool.getWarehouseInfo(str));
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FEntries$project_number")).data) != null && data.toString().trim().length() > 0) {
                entryInfo.setProject(this.getProject(ctx, data.toString(), this.cu));
            }
            if ((data = ((DataToken)hsData.get((Object)"FEntries$trackNumber_number")).data) != null && data.toString().trim().length() > 0) {
                entryInfo.setTrackNumber(this.getTrackNumber(ctx, data.toString(), this.sou.getCU()));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        if (entryInfo.getUnit() != null && entryInfo.getMaterial() != null) {
            MultiMeasureUnitInfo mmu = null;
            try {
                mmu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(entryInfo.getMaterial().getId().toString(), entryInfo.getUnit().getId().toString());
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
            if (mmu != null) {
                int qtyPrecision = mmu.getQtyPrecision();
                if (entryInfo.getQty() != null) {
                    entryInfo.setQty(entryInfo.getQty().setScale(qtyPrecision, 4));
                }
            }
        }
    }

    private boolean storageHasRelationwithSale(Context ctx, String saleOrgID, String storageID) throws EASBizException, BOSException {
        if (this.saleRelationMap.get(saleOrgID) == null) {
            IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection ioc = iour.getFromUnit(saleOrgID, 2, 4);
            HashSet<String> orgSet = new HashSet<String>();
            int size = ioc.size();
            for (int i = 0; i < size; ++i) {
                orgSet.add(ioc.get(i).getId().toString());
            }
            this.saleRelationMap.put(saleOrgID, orgSet);
        }
        HashSet orgSet = (HashSet)this.saleRelationMap.get(saleOrgID);
        return orgSet.contains(storageID);
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, String storgeID) {
        CompanyOrgUnitInfo company = null;
        if (storgeID != null) {
            try {
                IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitCollection orgCol = iOrgUnitRelation.getToUnit(storgeID, 4, 1);
                company = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return company;
    }

    private boolean getBooleanValue(String value) {
        return !(value = value.trim()).equalsIgnoreCase("N") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("0") && !value.equalsIgnoreCase("FALSE");
    }

    private BillBaseStatusEnum getBaseStatusValue(String value) {
        BillBaseStatusEnum tSaved = BillBaseStatusEnum.TEMPORARILYSAVED;
        return tSaved;
    }

    private EntryBaseStatusEnum getEntryBaseStatusValue(String value) {
        EntryBaseStatusEnum tSaved = EntryBaseStatusEnum.TEMPORARILYSAVED;
        return tSaved;
    }

    private DiscountModeEnum getDiscountModeEnumValue(String value) {
        DiscountModeEnum tSaved = DiscountModeEnum.NULL;
        if (value != null) {
            value = value.trim();
            List EnumList = DiscountModeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                DiscountModeEnum enumList = (DiscountModeEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = enumList;
                break;
            }
        }
        return tSaved;
    }

    private DiscountConditionEnum getDiscountConditionEnumValue(String value) {
        DiscountConditionEnum tSaved = DiscountConditionEnum.NULL;
        if (value != null) {
            value = value.trim();
            List EnumList = DiscountConditionEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                DiscountConditionEnum enumList = (DiscountConditionEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = enumList;
                break;
            }
        }
        return tSaved;
    }

    private UserInfo getUserFromNumber(Context ctx, String number) throws BOSException, TaskExternalException {
        UserInfo userInfo = this.getCreator(ctx, null);
        return userInfo;
    }

    private BigDecimal dealPrecision(BigDecimal number, String precision) {
        int _precision = precision != null ? Integer.parseInt(precision) : 2;
        number = number != null && number.toString().indexOf("0E") == -1 ? number.setScale(_precision, 4) : ZERO.setScale(_precision);
        return number;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String currencyPrecision = rs.getString("currency.precision") == null ? "2" : rs.getString("currency.precision");
            String pricePrecision = rs.getString("material.pricePrecision") == null ? "6" : rs.getString("material.pricePrecision");
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizType_number", rs.getString("bizType.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FCustomer_number", rs.getString("CUSTOMER.NUMBER"));
            this.putTable(result, "FSaleOrgUnit_number", rs.getString("saleOrgUnit.number"));
            this.putTable(result, "FSaleGroup_number", rs.getString("saleGroup.number"));
            this.putTable(result, "FSalePerson_number", rs.getString("salePerson.number"));
            this.putTable(result, "FSignAddress", rs.getString("SIGNADDRESS"));
            this.putTable(result, "FValidTo", rs.getString("VALIDTO"));
            this.putTable(result, "FDeliveryType_number", rs.getString("DELIVERYTYPE.NUMBER"));
            this.putTable(result, "FDeliveryAddress", rs.getString("DELIVERYADDRESS"));
            this.putTable(result, "FSettlementType_number", rs.getString("settlementType.number"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FPaymentType_number", rs.getString("PAYMENTTYPE.NUMBER"));
            this.putTable(result, "FCashDiscount_number", rs.getString("cashDiscount.number"));
            this.putTable(result, "FPaymentType_number", rs.getString("paymentType.number"));
            this.putTable(result, "FTransLeadTime", rs.getString("transLeadTime"));
            this.putTable(result, "FContractType_number", rs.getString("contractType.number"));
            this.putTable(result, "FReceiveCondition_number", rs.getString("receiveCondition.number"));
            this.putTable(result, "FIsInTax", rs.getString("isInTax"));
            this.putTable(result, "FExchangeRate", rs.getString("exchangeRate"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FAdminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FEntries$materialGroup_number", rs.getString("materialGroup.number"));
            this.putTable(result, "FEntries_prepaymentRate", rs.getBigDecimal("entries.prepaymentRate"));
            this.putTable(result, "FEntries_preReceived", rs.getBigDecimal("entries.preReceived"));
            this.putTable(result, "FEntries_sendDate", rs.getString("entries.sendDate"));
            this.putTable(result, "FEntries_deliveryDate", rs.getString("entries.deliveryDate"));
            this.putTable(result, "FEntries$storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FEntries$warehouse_number", rs.getString("warehouse.number"));
            this.putTable(result, "FEntries_sendOverRate", rs.getString("entries.sendOverRate"));
            this.putTable(result, "FEntries_sendOwingRate", rs.getString("entries.sendOwingRate"));
            this.putTable(result, "FEntries_sendAdvanceDay", rs.getString("entries.sendAdvanceDay"));
            this.putTable(result, "FEntries_sendDeferralDay", rs.getString("entries.sendDeferralDay"));
            this.putTable(result, "FEntries_quantityUnCtrl", rs.getString("entries.quantityUnCtrl"));
            this.putTable(result, "FEntries$project_number", rs.getString("project.number"));
            this.putTable(result, "FEntries$trackNumber_number", rs.getString("trackNumber.number"));
            this.putTable(result, "FEntries_isPresent", rs.getString("entries.isPresent"));
            this.putTable(result, "FEntries_qty", rs.getBigDecimal("entries.qty"));
            this.putTable(result, "FEntries_assistQty", rs.getBigDecimal("entries.assistQty"));
            this.putTable(result, "FEntries_price", rs.getBigDecimal("entries.price"));
            this.putTable(result, "FEntries_amount", rs.getBigDecimal("entries.amount"));
            this.putTable(result, "FEntries_localAmount", rs.getBigDecimal("entries.localAmount"));
            this.putTable(result, "FEntries_taxRate", rs.getBigDecimal("entries.taxRate"));
            this.putTable(result, "FEntries_taxPrice", rs.getBigDecimal("entries.taxPrice"));
            this.putTable(result, "FEntries_tax", rs.getBigDecimal("entries.tax"));
            this.putTable(result, "FEntries_localTax", rs.getBigDecimal("entries.localTax"));
            this.putTable(result, "FEntries_taxAmount", rs.getBigDecimal("entries.taxAmount"));
            this.putTable(result, "FEntries_localTaxAmount", rs.getBigDecimal("entries.localTaxAmount"));
            this.putTable(result, "FEntries_discount", rs.getBigDecimal("entries.discount"));
            this.putTable(result, "FEntries_actualTaxPrice", rs.getBigDecimal("entries.actualTaxPrice"));
            this.putTable(result, "FEntries_discountAmount", rs.getBigDecimal("entries.discountAmount"));
            this.putTable(result, "FEntries_discountType", rs.getString("entries.discountType"));
            this.putTable(result, "FEntries$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntries$assistProperty_number", rs.getString("assistProperty.number"));
            this.putTable(result, "FEntries$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FEntries$assistUnit_number", rs.getString("assistUnit.number"));
            this.putTable(result, "FEntries_remark", rs.getString("entries.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.sale.app.SaleContractExportQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Sale, (String)"saleorder_export");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return oldFilterInfo;
    }

    public TrackNumberInfo getTrackByNumber(Context ctx, String number, StorageOrgUnitInfo storageUnit) throws TaskExternalException, BOSException {
        TrackNumberInfo track = null;
        if (number != null && number.trim().length() > 0) {
            ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            HashSet<Integer> status = new HashSet<Integer>();
            status.add(new Integer(10));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
            FilterInfo filter2 = new FilterInfo();
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (storageUnit != null && storageUnit.getCU() != null) {
                cu = storageUnit.getCU();
            }
            ObjectUuidPK cuPK = null;
            cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
            try {
                filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            if (filter2 != null) {
                filter.mergeFilter(filter2, "and");
            }
            viewInfo.setFilter(filter);
            TrackNumberCollection coll = iTrackNumber.getTrackNumberCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                track = coll.get(0);
                this.dataPool.setTrackNumber(number, track);
            } else {
                throw new TaskExternalException(number.toString() + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"TRACK_NUMBER_ERROR", (Context)ctx));
            }
        }
        return track;
    }

    public int getSubmitType() {
        return 1;
    }

    private boolean isNeed(String columnName, Object bizType) {
        for (int i = 0; i < this.MUST_NEED.length; ++i) {
            if (!columnName.equals(this.MUST_NEED[i]) || !StringUtil.isEmpty((String)bizType.toString())) continue;
            return true;
        }
        return false;
    }

    private Object getbizObjectByNumber(Context ctx, String bizType, String number) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        if (bizType.equals("FBizType_number")) {
            if (!this.bizTypeMap.containsKey(number)) {
                BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo(view.toString());
                this.bizTypeMap.put(number, bizTypeInfo);
            }
            return this.bizTypeMap.get(number);
        }
        if (bizType.equals("FCustomer_number")) {
            if (!this.orderCusMap.containsKey(number)) {
                CustomerInfo bizTypeInfo = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo(view.toString());
                this.orderCusMap.put(number, bizTypeInfo);
            }
            return this.orderCusMap.get(number);
        }
        if ("FDeliveryType_number".equals(bizType)) {
            if (!this.deliverTypeMap.containsKey(number)) {
                DeliveryTypeInfo deliveryTypeInfo = DeliveryTypeFactory.getLocalInstance((Context)ctx).getDeliveryTypeInfo(view.toString());
                this.deliverTypeMap.put(number, deliveryTypeInfo);
            }
            return this.deliverTypeMap.get(number);
        }
        if ("FCurrency_number".equals(bizType)) {
            if (!this.currencyMap.containsKey(number)) {
                CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view.toString());
                if (currencyCollection != null && currencyCollection.size() > 0) {
                    this.currencyMap.put(number, currencyCollection.get(0));
                } else {
                    this.currencyMap.put(number, null);
                }
            }
            return this.currencyMap.get(number);
        }
        return null;
    }

    private void setBillInfo(Context ctx, Map lineData, String bizTypeName, SaleContractInfo saleContractInfo, String propertyName, String nullSoureceKey, String notExistKey) throws TaskExternalException {
        Object bizObj = ((DataToken)lineData.get((Object)bizTypeName)).data;
        if (this.isNeed(bizTypeName, bizObj)) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)nullSoureceKey, (Context)ctx));
        }
        try {
            Object bizTypeInfo = this.getbizObjectByNumber(ctx, bizTypeName, bizObj.toString());
            if (bizTypeInfo == null) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)notExistKey, (Context)ctx));
            }
            saleContractInfo.put(propertyName, bizTypeInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)notExistKey, (Context)ctx));
        }
    }

    private SaleContractInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        SaleContractInfo saleContractInfo = new SaleContractInfo();
        Object str = null;
        Object data = null;
        try {
            this.discountRatePrePrecision = Integer.parseInt(ParamManager.getParamValue((Context)ctx, null, (String)"DISCOUNTRATEPRECISION"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        Object bizDate = ((DataToken)lineData.get((Object)"FBizDate")).data;
        if (this.isNeed("FBizDate", bizDate)) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"BIZDATE_NOT_NULL", (Context)ctx));
        }
        this.setBillInfo(ctx, lineData, "FBizType_number", saleContractInfo, "bizType", "SALEINV_NEEDTRANSTYPE", "BIZTYPE_NOT_EXIST");
        this.setBillInfo(ctx, lineData, "FCustomer_number", saleContractInfo, "customer", "ORDER_CUS_NULL", "ORDER_CUS_NOT_EXIST");
        this.setBillInfo(ctx, lineData, "FDeliveryType_number", saleContractInfo, "deliveryType", "SENDTYPE_NULL", "SENDTYPE_NOT_EXIST");
        this.doSaleOrgUnit(lineData, ctx);
        this.doDecimalField(lineData, ctx, saleContractInfo);
        this.doDateField(lineData, ctx, saleContractInfo);
        this.doBoolField(lineData, saleContractInfo);
        this.doStringField(lineData, saleContractInfo);
        this.doIntField(lineData, saleContractInfo);
        this.setBillInfo(ctx, lineData, "FCurrency_number", saleContractInfo, "currency", "SALEINV_NEEDCURRENCY", "CURRENCY_NOT_EXIST");
        try {
            this.doCompanyOrgUnit(lineData, ctx, saleContractInfo);
            this.doSaleGroup(lineData, ctx, saleContractInfo);
            this.doSalePerson(lineData, ctx, saleContractInfo);
            this.doSettlementType(lineData, ctx, saleContractInfo);
            this.doPaymentType(lineData, ctx, saleContractInfo);
            this.doCashDiscount(lineData, ctx, saleContractInfo);
            this.doAdminOrgUnit(lineData, ctx, saleContractInfo);
            this.doContractType(lineData, ctx, saleContractInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        return saleContractInfo;
    }

    public void doDecimalField(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws TaskExternalException {
        for (int i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                BigDecimal value;
                Object o = ((DataToken)lineData.get((Object)this.BIGDECIMAL_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)((String)o))) == null) continue;
                saleContractInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], value);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + " format error, it must be a number!!!");
            }
        }
    }

    public void doIntField(Map lineData, SaleContractInfo saleContractInfo) {
        for (int i = 0; i < this.INTEGER_FIELDS.length; ++i) {
            Object o = ((DataToken)lineData.get((Object)this.INTEGER_FIELDS[i])).data;
            if (o == null || o.toString().equals("")) continue;
            Integer value = new Integer(o.toString());
            saleContractInfo.setInt(this.INTEGER_OBJS[i], value);
        }
    }

    public void doStringField(Map lineData, SaleContractInfo saleContractInfo) {
        for (int i = 0; i < this.STRING_FIELDS.length; ++i) {
            Object o;
            if (lineData.get(this.STRING_FIELDS[i]) == null || (o = ((DataToken)lineData.get((Object)this.STRING_FIELDS[i])).data) == null) continue;
            String value = o.toString();
            saleContractInfo.setString(this.STRING_OBJS[i], value);
        }
    }

    public void doBoolField(Map lineData, SaleContractInfo saleContractInfo) {
        for (int i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            String value;
            Object o = ((DataToken)lineData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            saleContractInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue(value));
        }
    }

    public void doDateField(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws TaskExternalException {
        for (int i = 0; i < this.DATE_FIELDS.length; ++i) {
            Date value;
            Object o = ((DataToken)lineData.get((Object)this.DATE_FIELDS[i])).data;
            if (o == null || o.toString().length() <= 0 || (o = this.formatNationalDate(ctx, o.toString())) == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
            saleContractInfo.setDate(this.DATE_OBJS[i], value);
            if (!"bizDate".equals(this.DATE_OBJS[i])) continue;
            this.propertyMap.put("bizDate", value);
        }
    }

    public void doCompanyOrgUnit(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws TaskExternalException, BOSException, EASBizException {
        Object data = ((DataToken)lineData.get((Object)"FSaleOrgUnit_number")).data;
        if (data != null && data.toString().trim().length() > 0) {
            IOrgUnitRelation iOrgRelation;
            OrgUnitCollection orgCollection;
            SaleOrgUnitInfo info = new SaleOrgUnitInfo();
            String str = data.toString();
            if (str != null && str.trim().length() > 0) {
                info = this.getSaleOrgUnit(ctx, "number", str);
                saleContractInfo.setSaleOrgUnit(info);
                saleContractInfo.setCU(info.getCU());
                this.sou = info;
            }
            if ((orgCollection = (iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(info.getId().toString(), 2, 1)) != null && orgCollection.size() > 0) {
                Object[] objs = orgCollection.toArray();
                OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
                System.arraycopy(objs, 0, orgs, 0, objs.length);
                saleContractInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)orgs[0]);
            }
        }
    }

    public void doSaleOrgUnit(Map lineData, Context ctx) throws TaskExternalException {
        Object numberdata = ((DataToken)lineData.get((Object)"FNumber")).data;
        Object saleOrgData = ((DataToken)lineData.get((Object)"FSaleOrgUnit_number")).data;
        Object str1 = null;
        String str = numberdata != null ? numberdata.toString() : null;
        String saleOrgNum = null;
        String cuID = null;
        String saleOrgUnitID = null;
        if (saleOrgData != null) {
            saleOrgNum = saleOrgData.toString();
            if (saleOrgNum != null && saleOrgNum.trim().length() > 0) {
                try {
                    SaleOrgUnitInfo info = this.getSaleOrgUnit(ctx, "number", saleOrgNum);
                    cuID = info.getCU().getId().toString();
                    this.cu = info.getCU();
                    saleOrgUnitID = info.getId().toString();
                }
                catch (TaskExternalException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEORG_NOT_EXISTS", (Context)ctx));
            }
        }
    }

    public void doSaleGroup(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws BOSException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FSaleGroup_number")).data;
        if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
            if (this.dataPool.getSaleGroup(str) == null) {
                SaleGroupInfo info;
                ISaleGroup isaleGroup = SaleGroupFactory.getLocalInstance((Context)ctx);
                SaleGroupCollection collection = isaleGroup.getSaleGroupCollection("where number='" + str + "'");
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleContractInfo.setSaleGroup(info);
                    this.dataPool.setSaleGroup(str, info);
                }
            } else {
                saleContractInfo.setSaleGroup(this.dataPool.getSaleGroup(str));
            }
        }
    }

    public void doSalePerson(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws TaskExternalException {
        Object bizObj = ((DataToken)lineData.get((Object)"FSalePerson_number")).data;
        String number = bizObj.toString();
        if (this.isNeed("FSalePerson_number", bizObj)) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALE_PERSON_NULL", (Context)ctx));
        }
        try {
            SalePersonInfo salePersonInfo;
            if (this.dataPool.getSalePersonInfo(this.sou.getId().toString() + number) == null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo numberFilter = new FilterInfo();
                numberFilter.getFilterItems().add(new FilterItemInfo("person.number", (Object)number, CompareType.EQUALS));
                String paramValue = this.getParamValueByNumberAndOrg(ctx, "SALE001", this.sou.getId().toString());
                if ("0".equals(paramValue)) {
                    numberFilter.getFilterItems().add(new FilterItemInfo("saleGroup.saleOrg", (Object)this.sou.getId().toString(), CompareType.EQUALS));
                }
                viewInfo.setFilter(numberFilter);
                SalePersonCollection collection = SalePersonFactory.getLocalInstance((Context)ctx).getSalePersonCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    this.dataPool.setSalePersonInfo(this.sou.getId().toString() + number, collection.get(0));
                }
            }
            if ((salePersonInfo = this.dataPool.getSalePersonInfo(this.sou.getId().toString() + number)) == null) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALE_PEROSN_NOT_EXIST", (Context)ctx));
            }
            saleContractInfo.setSalePerson(salePersonInfo.getPerson());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public void doAdminOrgUnit(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws TaskExternalException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FAdminOrgUnit_number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0) {
            AdminOrgUnitInfo info = this.getAdminOrgUnit(ctx, "number", str);
            saleContractInfo.setAdminOrgUnit(info);
        }
    }

    public void doContractType(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FContractType_number")).data;
        if (data != null) {
            String str = data.toString();
            if (str != null && str.length() > 0) {
                ContraceTreeInfo info = this.getContractType(ctx, "number", str);
                saleContractInfo.setContractType(info);
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"CONTRACTTYPE_NOT_NULL", (Context)ctx));
            }
        }
    }

    public void doCashDiscount(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws BOSException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FCashDiscount_number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0) {
            if (this.dataPool.getCashDiscountInfo(str) == null) {
                CashDiscountInfo info;
                ICashDiscount iCashDiscount = CashDiscountFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                CashDiscountCollection collection = iCashDiscount.getCashDiscountCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleContractInfo.setCashDiscount(info);
                    this.dataPool.setCashDiscountInfo(str, info);
                }
            } else {
                saleContractInfo.setCashDiscount(this.dataPool.getCashDiscountInfo(str));
            }
        }
    }

    public void doPaymentType(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws BOSException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FPaymentType_number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0) {
            if (this.dataPool.getPaymentTypeInfo(str) == null) {
                PaymentTypeInfo info;
                IPaymentType ipaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                PaymentTypeCollection collection = ipaymentType.getPaymentTypeCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleContractInfo.setPaymentType(info);
                    this.dataPool.setPaymentTypeInfo(str, info);
                }
            } else {
                saleContractInfo.setPaymentType(this.dataPool.getPaymentTypeInfo(str));
            }
        }
    }

    public void doSettlementType(Map lineData, Context ctx, SaleContractInfo saleContractInfo) throws BOSException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FSettlementType_number")).data;
        if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
            if (this.dataPool.getSettlementTypeInfo(str) == null) {
                SettlementTypeInfo info;
                ISettlementType isettlement = SettlementTypeFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                SettlementTypeCollection collection = isettlement.getSettlementTypeCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleContractInfo.setSettlementType(info);
                    this.dataPool.setSettlementTypeInfo(str, info);
                }
            } else {
                saleContractInfo.setSettlementType(this.dataPool.getSettlementTypeInfo(str));
            }
        }
    }

    protected ContraceTreeInfo getContractType(Context ctx, String propertyName, Object data) throws TaskExternalException {
        CoreBaseCollection coll;
        String key = data.toString().trim();
        ContraceTreeInfo contraceTreeInfo = this.getContraceTreeInfo(key);
        if (contraceTreeInfo != null) {
            return contraceTreeInfo;
        }
        EntityViewInfo view = this.getFilter(key);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("number");
        selector.add("name");
        selector.add("contractDetail");
        selector.add("id");
        view.setSelector(selector);
        try {
            coll = ContraceTreeFactory.getLocalInstance((Context)ctx).getCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (coll == null || coll.size() <= 0 || coll.get(0) == null) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"CONTRACTTYPE_NOT_NULL", (Context)ctx));
        }
        contraceTreeInfo = (ContraceTreeInfo)coll.get(0);
        this.setContraceTreeInfo(key, contraceTreeInfo);
        return contraceTreeInfo;
    }

    public void afterBuildEntry(Context ctx, SCMBillBaseInfo info, SCMBillEntryBaseInfo entry, Map lineData) throws TaskExternalException {
        super.afterBuildEntry(ctx, info, entry, lineData);
        this.checkEntryValue(ctx, (SaleContractEntryInfo)entry);
    }

    private void checkEntryValue(Context ctx, SaleContractEntryInfo entry) throws TaskExternalException {
        BigDecimal tax = this.setNullToZero(entry.getTax());
        BigDecimal amount = this.setNullToZero(entry.getAmount());
        BigDecimal taxAmount = this.setNullToZero(entry.getTaxAmount());
        if (tax.add(amount).compareTo(taxAmount) != 0) {
            String str = SaleContractDataImport.getResources((Context)ctx, (String)"TAXAMOUNT_NOTEQUALS_OTHERAMOUNT", (String)"com.kingdee.eas.scm.im.inv.app.PurInImportResource");
            throw new TaskExternalException(str);
        }
    }

    private String getParamValueByNumberAndOrg(Context ctx, String number, String orgID) throws EASBizException, BOSException {
        if (this.paramMap.get(orgID + number) == null) {
            ParamItemInfo paramItem = ParamControlFactory.getLocalInstance((Context)ctx).getParamItemByNumberAndOrg(number, orgID);
            this.paramMap.put(orgID + number, paramItem.getValue());
        }
        return this.paramMap.get(orgID + number).toString();
    }

    private Date formatNationalDate(Context ctx, String dateStr) throws TaskExternalException {
        Date date = null;
        if (!StringUtil.isEmpty((String)dateStr) && (date = ExcelUtil.formatNationalDate((Context)ctx, (String)dateStr)) == null) {
            String format = ExcelUtil.getDateFomartString((Context)ctx);
            try {
                date = BOSLocaleUtil.getDateFormat().parse(dateStr);
            }
            catch (ParseException e) {
                throw new TaskExternalException(SCMUtils.getResource((String)resources, (String)"InvalidDateFiled", (String[])new String[]{format}, (Context)ctx));
            }
        }
        return date;
    }

    protected String[] getPriceFields() {
        return this.priceFields;
    }

    protected String[] getAmountFields() {
        return this.amountFields;
    }

    protected String[] getLocalAmountFields() {
        return this.localAmountFields;
    }

    protected String getDiscountField() {
        return "discount";
    }

    protected String getTaxRateField() {
        return "taxRate";
    }

    public String getImportPermissionItem() {
        return "salecontract_addnew";
    }

    private void calEntry(Context ctx, SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo) {
        boolean isInTax = saleContractInfo.isIsInTax();
        this.materialPricePrecision = 2;
        if (entryInfo.getMaterial() != null) {
            this.materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        }
        this.currencyPrecision = 2;
        if (saleContractInfo.getCurrency() != null) {
            this.currencyPrecision = saleContractInfo.getCurrency().getPrecision();
        }
        if (isInTax) {
            this.calEntryPriceByTaxPrice(saleContractInfo, entryInfo);
            this.calEntryTotalTaxAmount(saleContractInfo, entryInfo);
            this.calEntryTax(saleContractInfo, entryInfo);
            this.calEntryAmount(saleContractInfo, entryInfo);
            this.calEntryActualPrice(saleContractInfo, entryInfo);
            this.calEntryActualTaxPrice(saleContractInfo, entryInfo);
            this.calEntryDiscountAmount(saleContractInfo, entryInfo);
        } else {
            this.calEntryTaxPricebyPrice(saleContractInfo, entryInfo);
            this.calEntryDiscountAmount(saleContractInfo, entryInfo);
            this.calEntryAmount(saleContractInfo, entryInfo);
            this.calEntryActualPrice(saleContractInfo, entryInfo);
            this.calEntryTax(saleContractInfo, entryInfo);
            this.calEntryTotalTaxAmount(saleContractInfo, entryInfo);
            this.calEntryActualTaxPrice(saleContractInfo, entryInfo);
        }
        BigDecimal prepaymentRate = entryInfo.getPrepaymentRate();
        BigDecimal prepayment = entryInfo.getTaxAmount().multiply(prepaymentRate.divide(new BigDecimal("100"))).setScale(this.currencyPrecision, 4);
        entryInfo.setPrepayment(prepayment);
    }

    private void calEntryTaxPricebyPrice(SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo) {
        BigDecimal price = entryInfo.getPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)this.materialPricePrecision);
        entryInfo.setTaxPrice(taxPrice);
    }

    private void calEntryDiscountAmount(SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo) {
        BigDecimal discount = entryInfo.getDiscount();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal bigDecimal = taxPrice = taxPrice == null ? ZERO : taxPrice;
        if (qty == null) {
            entryInfo.setDiscountAmount(null);
            return;
        }
        if (entryInfo.getDiscount() != null && entryInfo.getDiscount().compareTo(ZERO) > 0 && taxPrice.compareTo(ZERO) > 0) {
            BigDecimal discountAmount = CalculateUtils.calDiscountAmountByPercent((BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (int)this.currencyPrecision);
            entryInfo.setDiscountAmount(discountAmount);
            if (entryInfo.getDiscount().compareTo(this.oneHundred) > 0) {
                entryInfo.setDiscount(this.oneHundred);
                entryInfo.setDiscountAmount(entryInfo.getQty().multiply(taxPrice).setScale(this.currencyPrecision, 4));
            }
        } else if (entryInfo.getDiscountAmount() != null && entryInfo.getDiscountAmount().compareTo(ZERO) > 0 && taxPrice.compareTo(ZERO) > 0) {
            BigDecimal discountRate = entryInfo.getDiscountAmount().divide(entryInfo.getQty().multiply(taxPrice), this.discountRatePrePrecision, 4).multiply(this.oneHundred);
            entryInfo.setDiscount(discountRate);
            if (discountRate.compareTo(this.oneHundred) > 0) {
                entryInfo.setDiscount(this.oneHundred);
                entryInfo.setDiscountAmount(entryInfo.getQty().multiply(taxPrice).setScale(this.currencyPrecision, 4));
            }
        }
    }

    private void calEntryActualTaxPrice(SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo) {
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal actualTaxPrice = ZERO;
        if (taxAmount != null && qty != null && qty.compareTo(ZERO) > 0) {
            actualTaxPrice = taxAmount.divide(qty, this.materialPricePrecision, 4);
        }
        entryInfo.setActualTaxPrice(actualTaxPrice);
    }

    private void calEntryActualPrice(SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo) {
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal actualTaxPrice = ZERO;
        if (amount != null && qty != null && qty.compareTo(ZERO) > 0) {
            actualTaxPrice = amount.divide(qty, this.materialPricePrecision, 4);
        }
        entryInfo.setActualPrice(actualTaxPrice);
    }

    private void calEntryAmount(SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo) {
        boolean isInTax = saleContractInfo.isIsInTax();
        if (isInTax) {
            BigDecimal taxAmount = entryInfo.getTaxAmount();
            BigDecimal tax = entryInfo.getTax();
            BigDecimal amount = ZERO;
            if (taxAmount != null && tax != null) {
                amount = taxAmount.subtract(tax).setScale(this.currencyPrecision, 4);
            }
            entryInfo.setAmount(amount);
        } else {
            BigDecimal price = entryInfo.getPrice();
            BigDecimal discount = entryInfo.getDiscount();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal actualPrice = null;
            BigDecimal bigDecimal = discount = discount == null ? ZERO : discount;
            if (price != null && discount != null) {
                actualPrice = price.multiply(BigDecimal.ONE.subtract(discount.divide(this.oneHundred, 10, 4)));
            }
            BigDecimal amount = CalculateUtils.calAmount((BigDecimal)qty, actualPrice, (int)this.currencyPrecision);
            entryInfo.setAmount(amount);
        }
    }

    private void calEntryTax(SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo) {
        boolean isInTax = saleContractInfo.isIsInTax();
        BigDecimal taxAmount = ZERO;
        BigDecimal taxRate = ZERO;
        if (isInTax) {
            if (entryInfo.getTaxAmount() != null) {
                taxAmount = entryInfo.getTaxAmount();
            }
            if (entryInfo.getTaxRate() != null) {
                taxRate = entryInfo.getTaxRate();
            }
            BigDecimal tax = ZERO;
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(this.oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(BigDecimal.ONE), 10, 4).multiply(taxRate);
                tax = tax.setScale(this.currencyPrecision, 4);
            }
            entryInfo.setTax(tax);
        } else {
            BigDecimal tax;
            BigDecimal amount = entryInfo.getAmount();
            if (amount == null) {
                amount = ZERO;
            }
            if (entryInfo.getTaxRate() != null) {
                taxRate = entryInfo.getTaxRate();
            }
            entryInfo.setTax((tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)this.currencyPrecision)) != null ? tax : ZERO);
        }
    }

    private void calEntryTotalTaxAmount(SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo) {
        boolean isInTax = saleContractInfo.isIsInTax();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        if (isInTax) {
            BigDecimal discount = entryInfo.getDiscount();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal actualPrice = null;
            BigDecimal discountAmount = ZERO;
            qty = qty == null ? ZERO : qty;
            taxPrice = taxPrice == null ? ZERO : taxPrice;
            BigDecimal bigDecimal = discount = discount == null ? ZERO : discount;
            if (taxPrice != null && discount != null && qty != null) {
                discountAmount = taxPrice.multiply(qty).multiply(discount).divide(this.oneHundred, 10, 4);
                actualPrice = taxPrice.multiply(qty).subtract(discountAmount).divide(BigDecimal.ONE, this.currencyPrecision, 4);
                entryInfo.setTaxAmount(actualPrice);
            }
        } else {
            BigDecimal amount = entryInfo.getAmount();
            if (amount == null) {
                amount = ZERO;
            }
            BigDecimal tax = entryInfo.getTax();
            BigDecimal totalTaxAmount = ZERO;
            if (tax != null) {
                totalTaxAmount = amount.add(tax);
            }
            entryInfo.setTaxAmount(totalTaxAmount);
        }
    }

    private void calEntryPriceByTaxPrice(SaleContractInfo saleContractInfo, SaleContractEntryInfo entryInfo) {
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        entryInfo.setPrice(CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)this.materialPricePrecision));
    }
}

