/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sd.sale.ISaleContractEntry;
import com.kingdee.eas.scm.sd.sale.SaleContractCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractException;
import com.kingdee.eas.scm.sd.sale.SaleContractFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleContractEntryControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleContractEntryControllerBean
extends AbstractSaleContractEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleContractEntryControllerBean");

    @Override
    protected void _freeze(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        String reason = reasonCode == null ? null : ((ReasonCodeInfo)reasonCode).getName();
        this._freeze(ctx, pk, reason);
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK[] pks, IObjectValue[] reasonCodes) throws BOSException, EASBizException {
        String[] reasons = null;
        if (reasonCodes != null) {
            reasons = new String[reasonCodes.length];
            int num = reasonCodes.length;
            for (int i = 0; i < num; ++i) {
                reasons[i] = reasonCodes[i] == null ? null : ((ReasonCodeInfo)reasonCodes[i]).getName();
            }
        }
        this._freeze(ctx, pks, reasons);
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        this._freeze(ctx, new IObjectPK[]{pk}, new String[]{reason});
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        SaleContractInfo info = null;
        SaleContractEntryInfo entryInfo = null;
        SaleContractEntryCollection entryColl = null;
        this.checkSaleContractEntryFreezed(ctx, pks);
        if (pks != null && pks.length > 0) {
            String tableName = "T_SD_SaleContractEntry";
            Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, (IObjectPK[])pks);
            if (map.size() > 0) {
                HashSet idSet = new HashSet();
                for (Map.Entry entry : map.entrySet()) {
                    idSet.add(entry.getValue());
                }
                if (idSet.size() > 0) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SaleContractCollection coll = SaleContractFactory.getLocalInstance(ctx).getSaleContractCollection(view);
                    if (coll != null && coll.size() > 0) {
                        int size = coll.size();
                        for (int i = 0; i < size; ++i) {
                            info = coll.get(i);
                            entryColl = (SaleContractEntryCollection)((Object)info.getEntries().clone());
                            info.getEntries().clear();
                            int n = entryColl.size();
                            for (int j = 0; j < n; ++j) {
                                entryInfo = entryColl.get(j);
                                if (!map.containsKey(entryInfo.getId().toString())) continue;
                                info.getEntries().add(entryInfo);
                            }
                            SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.FREEZE);
                        }
                    }
                }
            }
            StringBuffer sql = new StringBuffer();
            String reason = reasons != null && reasons.length > 0 ? reasons[0] : "";
            sql.append("UPDATE T_SD_SALECONTRACTENTRY SET FBASESTATUS = ").append(6);
            sql.append(",FREASON = '").append(reason).append("'");
            sql.append(" WHERE FID IN (").append(StringUtil.getPKList((IObjectPK[])pks)).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            this.changeHeadStatus(ctx, pks, 6);
        }
    }

    @Override
    protected void _canFreeze(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkSaleContractEntryFreezed(ctx, pks);
    }

    @Override
    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unFreeze(ctx, new IObjectPK[]{pk});
    }

    @Override
    protected void _unFreeze(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        String tableName;
        Map map;
        SaleContractInfo info = null;
        SaleContractEntryInfo entryInfo = null;
        SaleContractEntryCollection entryColl = null;
        this.checkSaleContractEntryUnFreezed(ctx, pks);
        if (pks != null && pks.length > 0 && (map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)(tableName = "T_SD_SaleContractEntry"), (IObjectPK[])pks)).size() > 0) {
            HashSet idSet = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                idSet.add(entry.getValue());
            }
            if (idSet.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                SaleContractCollection coll = SaleContractFactory.getLocalInstance(ctx).getSaleContractCollection(view);
                if (coll != null && coll.size() > 0) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        info = coll.get(i);
                        entryColl = (SaleContractEntryCollection)((Object)info.getEntries().clone());
                        info.getEntries().clear();
                        int n = entryColl.size();
                        for (int j = 0; j < n; ++j) {
                            entryInfo = entryColl.get(j);
                            if (!map.containsKey(entryInfo.getId().toString())) continue;
                            info.getEntries().add(entryInfo);
                        }
                        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNFREEZE);
                    }
                }
            }
        }
        this.changeStatusToAudit(ctx, pks);
    }

    @Override
    protected void _autoClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ISaleContractEntry iSaleContractEntry = SaleContractEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("totalOrderedQty"));
        SaleContractEntryInfo saleContractEntryInfo = iSaleContractEntry.getSaleContractEntryInfo(pk, sic);
        BigDecimal qty = saleContractEntryInfo.getQty();
        BigDecimal totalOrderedQty = saleContractEntryInfo.getTotalOrderedQty();
        if (qty != null && totalOrderedQty != null && totalOrderedQty.compareTo(qty) >= 0) {
            this.checkSaleContractEntryHandClose(ctx, new IObjectPK[]{pk});
            DbUtil.execute((Context)ctx, (String)("UPDATE T_SD_SALECONTRACTENTRY SET FBASESTATUS = 7, FREASON = '' WHERE FID = '" + pk.toString() + "'"));
            this.changeHeadStatus(ctx, new IObjectPK[]{pk}, 7);
        }
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        String reason = reasonCode == null ? null : ((ReasonCodeInfo)reasonCode).getName();
        this._handClose(ctx, pk, reason);
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK[] pks, IObjectValue[] reasonCodes) throws BOSException, EASBizException {
        String[] reasons = null;
        if (reasonCodes != null) {
            reasons = new String[reasonCodes.length];
            int num = reasonCodes.length;
            for (int i = 0; i < num; ++i) {
                reasons[i] = reasonCodes[i] == null ? null : ((ReasonCodeInfo)reasonCodes[i]).getName();
            }
        }
        this._handClose(ctx, pks, reasons);
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        this._handClose(ctx, new IObjectPK[]{pk}, new String[]{reason});
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        SaleContractInfo info = null;
        SaleContractEntryInfo entryInfo = null;
        SaleContractEntryCollection entryColl = null;
        this.checkSaleContractEntryHandClose(ctx, pks);
        if (pks != null && pks.length > 0) {
            String tableName = "T_SD_SaleContractEntry";
            Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, (IObjectPK[])pks);
            if (map.size() > 0) {
                HashSet idSet = new HashSet();
                for (Map.Entry entry : map.entrySet()) {
                    idSet.add(entry.getValue());
                }
                if (idSet.size() > 0) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SaleContractCollection coll = SaleContractFactory.getLocalInstance(ctx).getSaleContractCollection(view);
                    if (coll != null && coll.size() > 0) {
                        int size = coll.size();
                        for (int i = 0; i < size; ++i) {
                            info = coll.get(i);
                            entryColl = (SaleContractEntryCollection)((Object)info.getEntries().clone());
                            info.getEntries().clear();
                            int n = entryColl.size();
                            for (int j = 0; j < n; ++j) {
                                entryInfo = entryColl.get(j);
                                if (!map.containsKey(entryInfo.getId().toString())) continue;
                                info.getEntries().add(entryInfo);
                            }
                            SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CLOSE);
                        }
                    }
                }
            }
            StringBuffer sql = new StringBuffer();
            String reason = reasons != null && reasons.length > 0 ? reasons[0] : "";
            sql.append("UPDATE T_SD_SALECONTRACTENTRY SET FBASESTATUS = ").append(7);
            sql.append(",FREASON = '").append(reason).append("'");
            sql.append(" WHERE FID IN (").append(StringUtil.getPKList((IObjectPK[])pks)).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            this.changeHeadStatus(ctx, pks, 7);
        }
    }

    @Override
    protected void _canHandClose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkSaleContractEntryHandClose(ctx, pks);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleContractEntryInfo info = (SaleContractEntryInfo)this.getValue(ctx, pk);
        SaleContractInfo sInfo = SaleContractFactory.getLocalInstance(ctx).getSaleContractInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        return sInfo.getNumber() + "  " + info.getSeq();
    }

    @Override
    protected void _handleUnclose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._handleUnclose(ctx, new IObjectPK[]{pk});
    }

    @Override
    protected void _handleUnclose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        SaleContractInfo info = null;
        SaleContractEntryInfo entryInfo = null;
        SaleContractEntryCollection entryColl = null;
        if (pks == null || pks.length == 0) {
            return;
        }
        this.checkEntryCanHandleUnclose(ctx, pks);
        String tableName = "T_SD_SaleContractEntry";
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, (IObjectPK[])pks);
        if (map.size() > 0) {
            HashSet idSet = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                idSet.add(entry.getValue());
            }
            if (idSet.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                SaleContractCollection coll = SaleContractFactory.getLocalInstance(ctx).getSaleContractCollection(view);
                if (coll != null && coll.size() > 0) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        info = coll.get(i);
                        entryColl = (SaleContractEntryCollection)((Object)info.getEntries().clone());
                        info.getEntries().clear();
                        int n = entryColl.size();
                        for (int j = 0; j < n; ++j) {
                            entryInfo = entryColl.get(j);
                            if (!map.containsKey(entryInfo.getId().toString())) continue;
                            info.getEntries().add(entryInfo);
                        }
                        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                    }
                }
            }
        }
        this.changeStatusToAudit(ctx, pks);
    }

    private boolean checkHasNoEqualsStatus(Context ctx, IObjectPK[] pks, int statusValue) throws BOSException, EASBizException {
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT count(FID) counter FROM T_SD_SALECONTRACTENTRY ");
        sql.append(" WHERE FID IN (").append(StringUtil.getPKList((IObjectPK[])pks)).append(") AND FBASESTATUS <> ").append(statusValue);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null && rowSet.next() && rowSet.getInt("counter") > 0) {
                flag = true;
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
        }
        return flag;
    }

    private void changeHeadStatus(Context ctx, IObjectPK[] pks, int statusValue) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ");
        sql.append(" T_SD_SaleContract set FBaseStatus = ").append(statusValue);
        sql.append(" where not exists (select FParentid from T_SD_SaleContractEntry where FBaseStatus <> ").append(statusValue);
        sql.append(" and fparentid in (select FParentId from T_SD_SaleContractEntry where fid in(");
        sql.append(StringUtil.getPKList((IObjectPK[])pks)).append(") group by fparentid))");
        sql.append(" and fid in(select FParentId from T_SD_SaleContractEntry where fid in (");
        sql.append(StringUtil.getPKList((IObjectPK[])pks)).append(") group by fparentid)");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    private void checkSaleContractEntryFreezed(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks == null) {
            return;
        }
        if (this.checkHasNoEqualsStatus(ctx, pks, 4)) {
            if (pks.length > 1) {
                throw new SaleContractException(SaleContractException.PART_CANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_FREEZED", (Context)ctx)});
            }
            throw new SaleContractException(SaleContractException.ONLY_AUDITED_CAN_FREEZE);
        }
    }

    private void checkSaleContractEntryUnFreezed(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks == null) {
            return;
        }
        if (this.checkHasNoEqualsStatus(ctx, pks, 6)) {
            if (pks.length > 1) {
                throw new SaleContractException(SaleContractException.PART_CANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_UNFREEZED", (Context)ctx)});
            }
            throw new SaleContractException(SaleContractException.ONLY_FREEZED_CAN_UNFREEZE);
        }
    }

    private void checkSaleContractEntryHandClose(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks == null) {
            return;
        }
        if (this.checkHasNoEqualsStatus(ctx, pks, 4)) {
            if (pks.length > 1) {
                throw new SaleContractException(SaleContractException.PART_CANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_CLOSE", (Context)ctx)});
            }
            throw new SaleContractException(SaleContractException.ONLY_AUDITED_OR_FREEZED_CAN_CLOSE);
        }
    }

    private void checkEntryCanHandleUnclose(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null && this.checkHasNoEqualsStatus(ctx, pks, 7)) {
            throw new SaleContractException(SaleContractException.ONLY_CLOSED_CAN_UNCLOSE);
        }
    }

    private void changeStatusToAudit(Context ctx, IObjectPK[] pks) throws BOSException {
        if (pks != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE T_SD_SALECONTRACTENTRY SET ");
            sql.append(" FBASESTATUS = ").append(4).append(",FREASON = ''");
            sql.append(" WHERE FID IN (").append(StringUtil.getPKList((IObjectPK[])pks)).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("UPDATE T_SD_SALECONTRACT SET FBASESTATUS = ").append(4);
            sql.append(" WHERE FID IN (");
            sql.append("   SELECT FPARENTID FROM T_SD_SALECONTRACTENTRY WHERE FID IN (").append(StringUtil.getPKList((IObjectPK[])pks)).append(")");
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

