/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeFactory;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.IDeliveryType;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.util.ParamsUtil;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.sd.sale.PriceTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleContractWebFacadeControllerBean;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class SaleContractWebFacadeControllerBean
extends AbstractSaleContractWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleContractWebFacadeControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private Map parametersMap = null;
    private static BigDecimal DEFAULT_TAXRATE = SCMConstant.DefaultTaxRate;

    protected Map _handleBillByCopy(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        SaleContractInfo saleContractInfo = (SaleContractInfo)info;
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(saleContractInfo.getSaleOrgUnit().getId().toString()), "salecontract_addnew");
        if (null != saleContractInfo.getSalePerson()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            viewInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)saleContractInfo.getSalePerson().getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            PersonCollection personCol = PersonFactory.getRemoteInstance().getPersonCollection(viewInfo);
            if (null == personCol || personCol.size() == 0) {
                saleContractInfo.setSalePerson(null);
            }
        }
        return map;
    }

    protected Map _handleBillByOprtState(Context ctx, String id, String oprtState) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou;
        SaleContractInfo info = (SaleContractInfo)model;
        if (null != info.getSaleOrgUnit() && null != info.getSaleOrgUnit().getId().toString()) {
            this.parametersMap = this.batchGetParamValue(ctx, info.getSaleOrgUnit().getId().toString());
        }
        info.setIsInTax(true);
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        Timestamp date = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        info.setBizDate(date);
        info.setCreateTime(date);
        Calendar calendar = Calendar.getInstance();
        Date curDate = calendar.getTime();
        calendar.add(2, 1);
        Date validToDate = calendar.getTime();
        info.setValidTo(validToDate);
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        info.setCreator(user);
        info.setExchangeRate(ZERO);
        String bizTypeID = "";
        bizTypeID = "d8e80652-010e-1000-e000-04c5c0a812202407435C";
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo(null, (String)bizTypeID, (String)"510b6503-0105-1000-e000-0113c0a812fd463ED552");
        info.setBizType(bizType);
        IDeliveryType iDeliveryType = DeliveryTypeFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        DeliveryTypeInfo aDeliveryTypeInfo = iDeliveryType.getDeliveryTypeInfo((IObjectPK)new ObjectUuidPK("51eb893e-0105-1000-e000-0c00c0a8123362E9EE3F"), selector);
        info.setDeliveryType(aDeliveryTypeInfo);
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"), selector);
        info.setPaymentType(paymentTypeInfo);
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"DEZBNUYZRM6ieHZ5GGlRc0Y+1VI="));
        aBillTypeInfo.setNumber("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=");
        info.setBillType(aBillTypeInfo);
        info.setExchangeRate(SCMUtil.BIGDECIMAL_ONE);
        SaleOrgUnitInfo sou = null;
        sou = info.getSaleOrgUnit() != null ? info.getSaleOrgUnit() : (SaleOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg((Context)ctx, (OrgType)OrgType.Sale, (String)"salecontract_addnew");
        info.setSaleOrgUnit(sou);
        if (sou == null) {
            return info;
        }
        AdminOrgUnitInfo admin = null;
        String enable_sale_admin = this.getParamValue(new ObjectUuidPK(info.getSaleOrgUnit().getId().toString()), "SALEORDER001");
        if (enable_sale_admin != null && !Boolean.valueOf(enable_sale_admin).booleanValue() && info.getSaleOrgUnit() != null) {
            admin = (AdminOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg((Context)ctx, (OrgType)OrgType.Admin, (String)"salecontract_addnew");
            info.setAdminOrgUnit(admin);
        }
        if (sou.getCU() != null) {
            info.setCU(sou.getCU());
        }
        if ((cou = this.getCouBySou(ctx, sou.getId().toString())) != null && cou.getBaseCurrency() != null) {
            info.setCompanyOrgUnit(cou);
            info.setCurrency(this.getBaseCurrencyByCou(ctx, cou));
            info.setExchangeRate(new BigDecimal(1));
        }
        SaleContractEntryInfo entryInfo = this.createEntryData(ctx, info);
        info.getEntries().add(entryInfo);
        return info;
    }

    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SaleContractInfo info = (SaleContractInfo)model;
        String saleOrgFilter = "id in " + this.getSaleOrgFilter(ctx);
        map.put("saleOrgFilter", saleOrgFilter);
        if (info.getSaleOrgUnit() == null) {
            return map;
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection collSto = iOrgUnitRelation.getFromUnit(info.getSaleOrgUnit().getId().toString(), 2, 4);
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(info.getSaleOrgUnit().getId().toString());
        map.put("bizOrgCUID", bizOrgCUID);
        CompanyOrgUnitInfo cou = null;
        cou = this.getCouBySou(ctx, info.getSaleOrgUnit().getId().toString());
        map.put("cou", cou);
        map.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        if (info.getCurrency() != null) {
            map.put("currency", CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()), this.getCurrencySelectors()));
        }
        IPaymentType iPaymentType = PaymentTypeFactory.getRemoteInstance();
        PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        map.put("commissionsale", paymentTypeInfo);
        Map paramMap = this.batchGetParamValue(ctx, info.getSaleOrgUnit().getId().toString());
        String saleOrdId = info.getSaleOrgUnit().getId().toString();
        String billType = info.getBillType().getId().toString();
        ISCMBillParam iSCMBillParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String botpBillAddEntry = iSCMBillParam.getParamByBillTypeID("botpBillAddEntry", 2, saleOrdId, billType);
        paramMap.put("botpBillAddEntry", "1".equals(botpBillAddEntry));
        map.put("params", paramMap);
        this.parametersMap = paramMap;
        this.handleEntryDefaultValue(ctx, info, map);
        info.setCU(info.getSaleOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new SaleContractInfo(), info.getSaleOrgUnit().getId().toString());
        if (ruleInfo != null) {
            map.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                map.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getSaleOrgUnit().getId().toString()));
            }
        }
        AdminOrgUnitInfo admin = null;
        String enable_sale_admin = this.getParamValue(new ObjectUuidPK(info.getSaleOrgUnit().getId().toString()), "SALEORDER001");
        if (enable_sale_admin != null && !Boolean.valueOf(enable_sale_admin).booleanValue() && info.getSaleOrgUnit().getId().toString() != null) {
            OrgUnitCollection coll = this.getAdminOrgUnitBySou(ctx, info.getSaleOrgUnit().getId().toString());
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(info.getSaleOrgUnit().getId().toString())) continue;
                    admin = (AdminOrgUnitInfo)coll.get(i);
                    break;
                }
                if (admin == null && coll.get(0) != null) {
                    admin = (AdminOrgUnitInfo)coll.get(0);
                }
            }
            map.put("adminOrg", admin);
        } else {
            map.put("adminOrg", null);
        }
        map.put("storageF7Filter", this.getStorageOrgFilter(ctx, info.getSaleOrgUnit().getId().toString()));
        map.put("paymentTypeF7Filter", this.paymentTypeF7Filter());
        map.put("projectF7Filter", this.getProjectF7Filter(ctx, info.getSaleOrgUnit().getId().toString()));
        map.put("trackNumberF7Filter", this.getTrackNumberF7Filter(ctx, info.getSaleOrgUnit().getId().toString()));
        map.put("priceSourceType", this.getPriceSourceType());
        String discountRatePrecision = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getSaleOrgUnit().getId()), "DISCOUNTRATEPRECISION");
        if (null != discountRatePrecision) {
            map.put("DISCOUNTRATEPRECISION", Integer.valueOf(discountRatePrecision));
        }
        return map;
    }

    private String getStorageOrgFilter(Context ctx, String orgId) throws BOSException, EASBizException {
        StringBuffer filter = new StringBuffer();
        String orgFilter = this.getOrgFilterStr(ctx, this.getStorageOrgUnitBySaleOrg(ctx, orgId));
        filter.append("id in").append(orgFilter);
        return filter.toString();
    }

    private OrgUnitCollection getStorageOrgUnitBySaleOrg(Context ctx, String souId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getFromUnit(souId, 2, 4);
        return coll;
    }

    private Map<String, Object> getPriceSourceType() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isNull", (Object)PriceTypeEnum.NULL);
        map.put("pricePolicy", (Object)PriceTypeEnum.PRICEPOLICY);
        map.put("basePrice", (Object)PriceTypeEnum.BASEPRICE);
        map.put("materialSaleInfo", (Object)PriceTypeEnum.SALEPRICE);
        map.put("value", -1);
        return map;
    }

    public String getTrackNumberF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        return filterInfo.toString();
    }

    public String getProjectF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = ProjectFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)false, CompareType.EQUALS));
        return filterInfo.toString();
    }

    private String paymentTypeF7Filter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 ");
        viewInfo.setFilter(filter);
        return viewInfo.toString();
    }

    public SelectorItemCollection getCurrencySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    private Map batchGetParamValue(Context ctx, String saleId) throws EASBizException, BOSException {
        SaleOrgUnitInfo sale = new SaleOrgUnitInfo();
        sale.setId(BOSUuid.read((String)saleId));
        SCMBizDataVO vo = new SCMBizDataVO(OrgType.Sale, (OrgUnitInfo)sale, 19, UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()), null);
        vo.setParameters(new String[]{"SALEORDER001", "SALEORDERALTER2", "SALEBILL001", "SALE001", "SALEORDER100", "RESALEORDERALTER2"});
        vo.setBOSType("29F55EA6");
        vo.setFirstLoading(true);
        SCMBizDataVO bizDataVO = SCMGroupFacadeFactory.getRemoteInstance().loadSCMBizDataVO(vo);
        HashMap paramMap = bizDataVO.getParametersMap();
        paramMap.putAll(bizDataVO.getSalePriceParamInfo().getParamItems());
        return paramMap;
    }

    public String getParamValue(ObjectUuidPK orgUnitID, String paramNumber) throws EASBizException, BOSException {
        return ParamsUtil.getParamsValue((ObjectUuidPK)orgUnitID, (String)paramNumber);
    }

    private SaleContractEntryInfo createEntryData(Context ctx, SaleContractInfo info) throws BOSException, EASBizException {
        SaleContractEntryInfo entry = new SaleContractEntryInfo();
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        BigDecimal defaultQty = ZERO;
        entry.setDiscount(defaultQty);
        entry.setDiscountType(DiscountModeEnum.PERCENT);
        entry.setDiscountCondition(DiscountConditionEnum.NULL);
        entry.setPriceSourceType(PriceTypeEnum.NULL);
        entry.setPreReceived(defaultQty);
        entry.setDiscountAmount(ZERO);
        entry.setPrepaymentRate(ZERO);
        entry.setPrepayment(ZERO);
        entry.setUnPreReceivedAmount(ZERO);
        entry.setTimeUnCtrl(true);
        entry.setAmountUnCtrl(true);
        entry.setTotalOrderedQty(ZERO);
        entry.setTotalOrderedAmt(ZERO);
        entry.setTotalReceivedAmt(ZERO);
        if (null != info.getSaleOrgUnit() && null != info.getSaleOrgUnit().getId().toString()) {
            entry.setQuantityUnCtrl(true);
            if (this.getBoolParam("SALEBILL001", false) && null != info.getCustomer() && null != info.getCustomer().getTaxRate()) {
                entry.setTaxRate(info.getCustomer().getTaxRate());
            } else {
                entry.setTaxRate(DEFAULT_TAXRATE);
            }
        }
        entry.setStorageOrgUnit(this.getStorageOrgUnitBySou(ctx, info.getSaleOrgUnit().getId().toString()));
        entry.setIsPresent(false);
        entry.setQuantityUnCtrl(true);
        DeliveryTypeInfo deliveryTypeInfo = info.getDeliveryType();
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate());
        Date dayTime = DateUtils.truncate((Date)curDate.getTime(), (int)5);
        entry.setSendDate(dayTime);
        if (deliveryTypeInfo != null) {
            if ("CARRY".equalsIgnoreCase(deliveryTypeInfo.getNumber())) {
                entry.setDeliveryDate(dayTime);
            } else {
                int leadTime = info.getTransLeadTime();
                curDate.add(5, leadTime);
                entry.setDeliveryDate(DateUtils.truncate((Date)curDate.getTime(), (int)5));
            }
        } else {
            entry.setDeliveryDate(dayTime);
        }
        return entry;
    }

    private StorageOrgUnitInfo getStorageOrgUnitBySou(Context ctx, String souId) throws BOSException, EASBizException {
        StorageOrgUnitInfo pou = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getFromUnit(souId, 2, 4);
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(souId)) continue;
                pou = (StorageOrgUnitInfo)coll.get(i);
                break;
            }
            if (pou == null && coll.get(0) != null) {
                pou = (StorageOrgUnitInfo)coll.get(0);
            }
        }
        return pou;
    }

    public boolean getBoolParam(String key, boolean defaultValue) throws EASBizException, BOSException {
        boolean isPurParam = defaultValue;
        String strPurParam = this.getCacheParameter(key);
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    protected final String getCacheParameter(String parameter) {
        return (String)this.parametersMap.get(parameter);
    }

    private OrgUnitCollection getAdminOrgUnitBySou(Context ctx, String souId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getToUnit(souId, 2, 0);
        return coll;
    }

    private String getSaleOrgFilter(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Sale, null, "salecontract_addnew");
        OrgUnitCollection saleOrgColl = new OrgUnitCollection();
        HashSet<String> iSet = new HashSet<String>();
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            iSet.add(fullCompanyColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", iSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Boolean(false), CompareType.EQUALS));
        view.setFilter(filter);
        SaleOrgUnitCollection stoOrgColl = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitCollection(view);
        for (int i = 0; i < stoOrgColl.size(); ++i) {
            saleOrgColl.add((OrgUnitInfo)stoOrgColl.get(i));
        }
        return this.getOrgFilterStr(ctx, saleOrgColl);
    }

    private void handleEntryDefaultValue(Context ctx, SaleContractInfo info, Map<String, Object> map) throws EASBizException, BOSException {
        SaleContractEntryInfo entryInfo = this.createEntryData(ctx, info);
        map.put("defaultEntryTaxRate", entryInfo.getTaxRate());
        map.put("defaultSendDate", entryInfo.getSendDate());
        map.put("defaultDeliveryDate", entryInfo.getDeliveryDate());
        map.put("defaultStorageOrgUnit", entryInfo.getStorageOrgUnit());
        map.put("defaultQuantityUnCtrl", entryInfo.isQuantityUnCtrl());
        map.put("defaultBaseStatus", EntryBaseStatusEnum.ADD);
        map.put("defaultDiscountType", DiscountModeEnum.PERCENT);
        map.put("defaultPrepaymentRate", entryInfo.getPrepaymentRate());
        map.put("defaultPrepayment", entryInfo.getPrepayment());
        map.put("defaultPreReceived", entryInfo.getPreReceived());
        map.put("defaultUnPreReceivedAmount", entryInfo.getUnPreReceivedAmount());
        map.put("defaultDiscount", entryInfo.getDiscount());
        map.put("defaultDiscountAmount", entryInfo.getDiscountAmount());
        map.put("defaultIsPresent", entryInfo.isIsPresent());
        map.put("defaultTotalOrderedQty", entryInfo.getTotalOrderedQty());
        map.put("defaultTotalOrderedAmt", entryInfo.getTotalOrderedAmt());
        map.put("defaultTotalReceivedAmt", entryInfo.getTotalReceivedAmt());
        map.put("nullDiscountType", DiscountModeEnum.NULL);
    }

    public CompanyOrgUnitInfo getCouBySou(Context ctx, String souId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getToUnit(souId, 2, 1);
        if (coll != null && coll.size() > 0) {
            company = (CompanyOrgUnitInfo)coll.get(0);
        }
        return company;
    }

    public CurrencyInfo getBaseCurrencyByCou(Context ctx, CompanyOrgUnitInfo cou) throws BOSException, EASBizException {
        if (cou != null && cou.getBaseCurrency() != null) {
            CurrencyInfo baseCurrInfo = cou.getBaseCurrency().getName() != null ? cou.getBaseCurrency() : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()), this.getCurrencySelectors());
            return baseCurrInfo;
        }
        return null;
    }
}

