/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceCollection;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleInnerDealPriceControllerBean;
import com.kingdee.eas.scm.sd.sale.util.BillInfoForPrice;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleInnerDealPriceControllerBean
extends AbstractSaleInnerDealPriceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleInnerDealPriceControllerBean");

    @Override
    protected IObjectValue _getInnerDealPrice(Context ctx, String saleorderid, String saleorderentryid) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("saleOrder.id", (Object)saleorderid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("saleOrderEntry.id", (Object)saleorderentryid, CompareType.EQUALS));
        view.setFilter(filter);
        SaleInnerDealPriceCollection collection = this.getSaleInnerDealPriceCollection(ctx, view);
        if (collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    @Override
    protected IObjectValue _getInnerDealPrice(Context ctx, String saleOrderID, String saleOrderEntryID, String companyOrgUnitID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("saleOrder.id", (Object)saleOrderID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("saleOrderEntry.id", (Object)saleOrderEntryID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgUnitID, CompareType.EQUALS));
        view.setFilter(filter);
        SaleInnerDealPriceCollection collection = this.getSaleInnerDealPriceCollection(ctx, view);
        if (collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    @Override
    protected void _batchSave(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        this.checkSave(ctx, collection);
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            SaleInnerDealPriceInfo info = (SaleInnerDealPriceInfo)collection.getObject(i);
            sql.setLength(0);
            sql.append("update t_sd_saleinnerdealprice set ");
            sql.append(" fprice = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getPrice())).append(",");
            sql.append(" ftaxprice = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getTaxPrice())).append(",");
            sql.append(" FActuralPrice = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getActualPrice())).append(",");
            sql.append(" factualtaxprice = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getActualTaxPrice())).append(",");
            sql.append(" ftaxrate = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getTaxRate())).append(",");
            sql.append(" fdiscount = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getDiscount())).append(",");
            sql.append(" fdiscountmode = ").append(info.getDiscountMode().getValue());
            sql.append(" where fid = '").append(info.getId().toString()).append("'");
            sqls.add(sql.toString());
        }
        com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, sqls);
    }

    private void checkSave(Context ctx, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() < 1) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            SaleInnerDealPriceInfo info = (SaleInnerDealPriceInfo)collection.getObject(i);
            if (i > 0) {
                ids.append(",");
            }
            ids.append("'").append(info.getSaleOrderEntry().getId().toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select entries.fid from t_im_saleissueentry entries where entries.fsaleorderentryid in (").append(ids).append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null && rowSet.size() > 0) {
            throw new OrderException(OrderException.HASBOTPSALEISSUE);
        }
    }

    @Override
    protected void _clearInnerDealPrice(Context ctx, IObjectPK[] pks) throws BOSException {
        StringBuffer str = new StringBuffer();
        String params = StringUtil.getKeyIdList((Object[])pks);
        str.append(" delete T_SD_SaleInnerDealPrice ").append(" where FSaleOrderId in(").append(params).append(")");
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    @Override
    protected void _caculateInnerDealPrice(Context ctx, IObjectPK[] pks) throws BOSException {
        IRowSet verifyResult = null;
        IRowSet centralBalanceResult = null;
        IRowSet squareBalanceResult1 = null;
        IRowSet squareBalanceResult2 = null;
        try {
            String params = StringUtil.getKeyIdList((Object[])pks);
            String verifySquareSQL = this.getVerifySquareSQL(params);
            String VerifyCentralSQL = this.getVerifyCentralSQL(params);
            String centralBalanceSQL = this.getCentralBalanceSQL(params);
            String squareBalance4BalanceSQL = this.getSquareBalance4BalanceSQL(params);
            String squareBalanceSQL = this.getSquareBalanceSQL(params);
            verifyResult = DbUtil.executeQuery((Context)ctx, (String)verifySquareSQL);
            if (verifyResult.next()) {
                this._clearInnerDealPrice(ctx, pks);
                squareBalanceResult1 = DbUtil.executeQuery((Context)ctx, (String)squareBalance4BalanceSQL);
                this.processSaleInnerDealPrice(ctx, squareBalanceResult1, true);
                squareBalanceResult2 = DbUtil.executeQuery((Context)ctx, (String)squareBalanceSQL);
                this.processSaleInnerDealPrice(ctx, squareBalanceResult2, true);
            }
            if ((verifyResult = DbUtil.executeQuery((Context)ctx, (String)VerifyCentralSQL)).next()) {
                this._clearInnerDealPrice(ctx, pks);
                centralBalanceResult = DbUtil.executeQuery((Context)ctx, (String)centralBalanceSQL);
                this.processSaleInnerDealPrice(ctx, centralBalanceResult, false);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            throw new BOSException(sqle.getMessage());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getVerifySquareSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select so.FID from T_SD_SaleOrder so ");
        sql.append(" inner join T_SD_SaleOrderEntry se on se.FParentID = so.FID ");
        sql.append(" where so.FID in(").append(params);
        sql.append(") and so.FIsSquareBalance = 1 and so.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 and se.fispresent = 0 ");
        return sql.toString();
    }

    private String getVerifyCentralSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select so.FID from T_SD_SaleOrder so ");
        sql.append(" inner join T_SD_SaleOrderEntry se on se.FParentID = so.FID ");
        sql.append(" where so.FID in(").append(params);
        sql.append(") and so.FIsSquareBalance = 0 and so.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 and se.fispresent = 0 ");
        return sql.toString();
    }

    private String getCentralBalanceSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select so.fid id,se.fid entryid,so.FSaleOrgUnitID saleOrgUntiID,so.FBizDate bizDate, ");
        sql.append(" se.FCompanyOrgUnitID companyOrgUntiID,so.FCurrencyID currencyid,se.FMaterialID materialid,");
        sql.append(" se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,");
        sql.append(" cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FCheapRate secheaprate,se.FPrice price,");
        sql.append(" se.FDiscountType discounttype,se.FDiscount discount,se.FActualPrice actualprice,");
        sql.append(" se.FActualTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision");
        sql.append("  from T_SD_SaleOrder so ");
        sql.append(" inner join T_SD_SaleOrderEntry se on se.FParentID = so.FID ");
        sql.append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = so.FCompanyOrgUnitID and cus.fusedstatus = 1");
        sql.append(" inner join T_BD_Material material on se.FMaterialID = material.FID ");
        sql.append(" where so.FID in(").append(params);
        sql.append(") and so.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 and se.fispresent = 0 ");
        return sql.toString();
    }

    private String getSquareBalance4BalanceSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select so.fid id,se.fid entryid,so.FSaleOrgUnitID saleOrgUntiID,so.FBizDate bizDate, ");
        sql.append(" se.FCompanyOrgUnitID companyOrgUntiID,so.FCurrencyID currencyid,se.FMaterialID materialid,");
        sql.append(" se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,");
        sql.append(" cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FCheapRate secheaprate,se.FPrice price,");
        sql.append(" se.FDiscountType discounttype,se.FDiscount discount,se.FActualPrice actualprice,");
        sql.append(" se.FActualTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision");
        sql.append("  from T_SD_SaleOrder so ");
        sql.append(" inner join T_SD_SaleOrderEntry se on se.FParentID = so.FID ");
        sql.append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = so.FBalanceCompanyOrgUnitID and cus.fusedstatus = 1");
        sql.append(" inner join T_BD_Material material on se.FMaterialID = material.FID ");
        sql.append(" where so.FID in(").append(params);
        sql.append(") and so.FIsSquareBalance = 1 and so.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 and se.fispresent = 0 ");
        return sql.toString();
    }

    private String getSquareBalanceSQL(String params) {
        StringBuffer sql = new StringBuffer();
        sql.append("select so.fid id,se.fid entryid,so.FSaleOrgUnitID saleOrgUntiID,so.FBizDate bizDate, ");
        sql.append(" so.FBalanceCompanyOrgUnitID companyOrgUntiID,so.FCurrencyID currencyid,se.FMaterialID materialid,");
        sql.append(" se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,");
        sql.append(" cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FCheapRate secheaprate,se.FPrice price,");
        sql.append(" se.FDiscountType discounttype,se.FDiscount discount,se.FActualPrice actualprice,");
        sql.append(" se.FActualTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision");
        sql.append("  from T_SD_SaleOrder so ");
        sql.append(" inner join T_SD_SaleOrderEntry se on se.FParentID = so.FID ");
        sql.append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = so.FCompanyOrgUnitID and cus.fusedstatus = 1 ");
        sql.append(" inner join T_BD_Material material on se.FMaterialID = material.FID ");
        sql.append(" where so.FID in(").append(params);
        sql.append(") and so.FIsSquareBalance = 1 and so.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 and se.fispresent = 0 ");
        return sql.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSaleInnerDealPrice(Context ctx, IRowSet result, boolean flag) throws BOSException {
        PriceCondition[] priceConditions;
        BillInfoForPrice[] tos;
        int resultCount;
        boolean isControlSaleInnerPrice;
        StringBuffer insertStr;
        IPriceProvider iProvider;
        Statement batchStatement;
        block22: {
            Connection con = null;
            batchStatement = null;
            con = this.getConnection(ctx);
            batchStatement = con.createStatement();
            iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
            insertStr = new StringBuffer();
            isControlSaleInnerPrice = false;
            resultCount = 0;
            tos = this.getBillInfoForPrice(result);
            priceConditions = this.getPriceConditionsByBillInfo(tos);
            if (priceConditions != null && priceConditions.length >= 1) break block22;
            SQLUtils.cleanup((Statement)batchStatement);
            return;
        }
        try {
            List[] priceList = iProvider.getPrices(priceConditions);
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            int length = tos.length;
            for (int i = 0; i < length; ++i) {
                BillInfoForPrice to = tos[i];
                insertStr.setLength(0);
                insertStr.append(" insert T_SD_SaleInnerDealPrice(");
                insertStr.append("    FID,FCreatorID,FCreateTime ,FLastUpdateUserID,FLastUpdateTime ,");
                insertStr.append("    FControlUnitID,FSaleOrderID ,FSaleOrderEntryID,FCompanyOrgUnitID,");
                insertStr.append("    FPrice,FDiscountMode,FDiscount,FActuralPrice ,");
                insertStr.append("    FTaxRate,FTaxPrice,FActualTaxPrice");
                insertStr.append(")values(");
                insertStr.append(" newbosid('").append("6C5E091B'),");
                insertStr.append("'").append(userId).append("',");
                insertStr.append("getdate(),");
                insertStr.append("'").append(userId).append("',");
                insertStr.append("getdate(),");
                insertStr.append("'").append(userId).append("',");
                insertStr.append("'").append(to.id).append("',");
                insertStr.append("'").append(to.entryid).append("'");
                if (flag) {
                    insertStr.append(",'").append(to.companyOrgUnitID).append("'");
                } else {
                    insertStr.append(",''");
                }
                int precision = to.priceprecision;
                BigDecimal taxPrice = SCMConstant.BIGDECIMAL_ZERO.setScale(precision, 4);
                BigDecimal discountValue = SCMConstant.BIGDECIMAL_ZERO.setScale(precision, 4);
                BigDecimal taxrate = SCMConstant.BIGDECIMAL_ZERO.setScale(precision, 4);
                BigDecimal actualTaxPrice = SCMConstant.BIGDECIMAL_ZERO.setScale(precision, 4);
                BigDecimal actualPrice = SCMConstant.BIGDECIMAL_ZERO.setScale(precision, 4);
                BigDecimal price = SCMConstant.BIGDECIMAL_ZERO.setScale(precision, 4);
                BigDecimal cheapRate = SCMConstant.BIGDECIMAL_ZERO.setScale(precision, 4);
                if (resultCount == 0) {
                    ++resultCount;
                    String saleOrgUnitID = to.saleOrgUntiID;
                    isControlSaleInnerPrice = Boolean.valueOf(this._isControlSaleInnerPrice(ctx, saleOrgUnitID));
                }
                if (isControlSaleInnerPrice && !flag) {
                    int priceprecision = to.priceprecision;
                    cheapRate = to.secheaprate != null ? to.secheaprate : SCMConstant.BIGDECIMAL_ZERO;
                    discountValue = to.discount;
                    taxrate = to.taxrate;
                    actualTaxPrice = taxPrice = to.actualtaxprice.multiply(SCMConstant.BIGDECIMAL_ONE.subtract(cheapRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 13, 4)));
                    price = taxPrice.divide(SCMConstant.BIGDECIMAL_ONE.add(taxrate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 13, 4)), priceprecision, 4);
                    actualPrice = taxPrice;
                    insertStr.append(",").append(price);
                    insertStr.append(",").append(0);
                    insertStr.append(",").append(0);
                    insertStr.append(",").append(actualPrice);
                    insertStr.append(",").append(taxrate);
                    insertStr.append(",").append(taxPrice);
                    insertStr.append(",").append(actualTaxPrice).append(")");
                    batchStatement.addBatch(insertStr.toString());
                    continue;
                }
                SalePriceTO salePriceTo = null;
                if (priceList[i] != null) {
                    List prices = priceList[i];
                    salePriceTo = prices != null ? (SalePriceTO)prices.get(0) : null;
                }
                PriceParamInfo priceparamInfo = null;
                if (salePriceTo != null) {
                    priceparamInfo = salePriceTo.priceType != null && salePriceTo.priceType.equals("basePrice") ? this.getPriceParmaByCompany(ctx, to.companyOrgUnitID) : PriceParamFactory.getLocalInstance((Context)ctx).getParameter(to.saleOrgUntiID);
                    int priceprecision = to.priceprecision;
                    taxrate = to.taxrate;
                    BigDecimal transferTaxRate = taxrate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 12, 4).add(SCMConstant.BIGDECIMAL_ONE);
                    BigDecimal discountRate = SCMConstant.BIGDECIMAL_ONEHUNDRED.subtract(discountValue).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 12, 4);
                    BigDecimal bigDecimal = discountValue = salePriceTo.discountValue != null ? salePriceTo.discountValue : SCMConstant.BIGDECIMAL_ZERO;
                    if (priceparamInfo != null && !priceparamInfo.isContainTax()) {
                        price = salePriceTo.price != null ? salePriceTo.price : SCMConstant.BIGDECIMAL_ZERO;
                        taxPrice = price.multiply(transferTaxRate).setScale(priceprecision, 4);
                    } else {
                        taxPrice = salePriceTo.price != null ? salePriceTo.price : SCMConstant.BIGDECIMAL_ZERO;
                        price = taxPrice.divide(transferTaxRate, priceprecision, 4);
                    }
                    if ("0".equals(salePriceTo.discountMode)) {
                        actualPrice = price.multiply(discountRate).setScale(priceprecision, 4);
                        actualTaxPrice = taxPrice.multiply(discountRate).setScale(priceprecision, 4);
                    } else if ("1".equals(salePriceTo.discountMode)) {
                        actualPrice = price.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                        actualTaxPrice = taxPrice.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                    } else {
                        actualPrice = price;
                        actualTaxPrice = taxPrice;
                    }
                    insertStr.append(",").append(price);
                    insertStr.append(",").append(salePriceTo.discountMode);
                    insertStr.append(",").append(discountValue);
                    insertStr.append(",").append(actualPrice);
                    insertStr.append(",").append(taxrate);
                    insertStr.append(",").append(taxPrice);
                    insertStr.append(",").append(actualTaxPrice).append(")");
                } else {
                    insertStr.append(",").append(to.price);
                    insertStr.append(",").append(to.discounttype);
                    insertStr.append(",").append(to.discount);
                    insertStr.append(",").append(to.actualprice);
                    insertStr.append(",").append(to.taxrate);
                    insertStr.append(",").append(to.taxprice);
                    insertStr.append(",").append(to.actualtaxprice).append(")");
                }
                batchStatement.addBatch(insertStr.toString());
            }
            batchStatement.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
                catch (PricePolicyException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (PriceParamException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (EASBizException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement);
        return;
    }

    private PriceParamInfo getPriceParmaByCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        IPriceParam iPriceParam = PriceParamFactory.getLocalInstance((Context)ctx);
        PriceParamInfo priceparamInfo = null;
        OrgUnitCollection orgUnitCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Company, (OrgType)OrgType.Sale, (String)companyId);
        int c = orgUnitCollection.size();
        for (int ii = 0; ii < c; ++ii) {
            String cuid = orgUnitCollection.get(ii).getId().toString();
            PriceParamInfo tempInfo = iPriceParam.getParameter(cuid);
            if (!tempInfo.isStartPriceDiscountM()) continue;
            priceparamInfo = tempInfo;
            break;
        }
        return priceparamInfo;
    }

    private BillInfoForPrice[] getBillInfoForPrice(IRowSet result) throws SQLException {
        if (result == null || result.size() < 1) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        int size = result.size();
        BillInfoForPrice[] tos = new BillInfoForPrice[size];
        int position = 0;
        while (result.next()) {
            BillInfoForPrice to = new BillInfoForPrice();
            to.id = result.getString("id");
            to.entryid = result.getString("entryid");
            to.companyOrgUnitID = result.getString("companyOrgUntiID");
            to.priceprecision = result.getInt("priceprecision");
            to.saleOrgUntiID = result.getString("saleOrgUntiID");
            to.bizDate = result.getDate("bizDate") != null ? result.getDate("bizDate") : ts;
            to.secheaprate = result.getBigDecimal("secheaprate");
            to.discount = this.setBigDecimalForZero(result.getBigDecimal("discount"));
            to.taxrate = this.setBigDecimalForZero(result.getBigDecimal("taxrate"));
            to.taxprice = this.setBigDecimalForZero(result.getBigDecimal("taxprice"));
            to.actualtaxprice = this.setBigDecimalForZero(result.getBigDecimal("actualtaxprice"));
            to.customerid = result.getString("customerid");
            to.materialid = result.getString("materialid");
            to.baseUnitiId = result.getString("baseUnitID");
            to.unitid = result.getString("unitid");
            to.qty = this.setBigDecimalForZero(result.getBigDecimal("qty"));
            to.currencyid = result.getString("currencyid");
            to.price = this.setBigDecimalForZero(result.getBigDecimal("price"));
            to.actualprice = this.setBigDecimalForZero(result.getBigDecimal("actualprice"));
            to.discounttype = result.getInt("discounttype");
            if (!StringUtils.isEmpty((String)result.getString("assistProperyID"))) {
                to.assistPropertyID = result.getString("assistProperyID");
            }
            tos[position++] = to;
        }
        return tos;
    }

    private BigDecimal setBigDecimalForZero(BigDecimal value) {
        if (value != null && value.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0) {
            value = SCMConstant.BIGDECIMAL_ZERO;
        }
        return value;
    }

    private PriceCondition[] getPriceConditionsByBillInfo(BillInfoForPrice[] infos) {
        if (infos == null || infos.length < 1) {
            return null;
        }
        PriceCondition[] priceConditions = new PriceCondition[infos.length];
        for (BillInfoForPrice info : infos) {
            CustomerInfo customerInfo = new CustomerInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            CurrencyInfo currencyInfo = new CurrencyInfo();
            CompanyOrgUnitInfo companyOrgInfo = new CompanyOrgUnitInfo();
            SaleOrgUnitInfo saleOrgInfo = new SaleOrgUnitInfo();
            MeasureUnitInfo baseUnitInfo = new MeasureUnitInfo();
            PriceCondition priceCondition = new PriceCondition();
            customerInfo.setId(BOSUuid.read((String)info.customerid));
            priceCondition.setCustomerInfo(customerInfo);
            materialInfo.setId(BOSUuid.read((String)info.materialid));
            baseUnitInfo.setId(BOSUuid.read((String)info.baseUnitiId));
            materialInfo.setBaseUnit(baseUnitInfo);
            priceCondition.setMaterialInfo(materialInfo);
            priceCondition.setMeasureUnit(info.unitid);
            companyOrgInfo.setId(BOSUuid.read((String)info.companyOrgUnitID));
            priceCondition.setCompanyOrg(companyOrgInfo);
            saleOrgInfo.setId(BOSUuid.read((String)info.saleOrgUntiID));
            priceCondition.setSaleOrg(saleOrgInfo);
            priceCondition.setOrderQty(info.qty);
            currencyInfo.setId(BOSUuid.read((String)info.currencyid));
            priceCondition.setCurrencyInfo(currencyInfo);
            priceCondition.setCurDate(info.bizDate);
            priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
            if (!StringUtils.isEmpty((String)info.assistPropertyID)) {
                AsstAttrValueInfo asstAttrValueInfo = new AsstAttrValueInfo();
                asstAttrValueInfo.setId(BOSUuid.read((String)info.assistPropertyID));
                priceCondition.setAssiProperty(asstAttrValueInfo);
            }
            priceConditions[i] = priceCondition;
        }
        return priceConditions;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _isControlSaleInnerPrice(Context ctx, String saleOrgUnitID) throws BOSException, EASBizException {
        IRowSet paramResultSet = null;
        String isPrioCusDis = "false";
        try {
            StringBuffer sb = new StringBuffer("");
            sb.append(" select p.fnumber,p.fdefaultval_l2,pi.Fvalue_l2 ");
            sb.append(" from t_bas_param p ");
            sb.append(" left join t_bas_paramitem pi on pi.FKeyID = p.fid  ");
            sb.append(" where p.fnumber = 'PricePa023' ");
            sb.append(" and pi.forgunitid ='").append(saleOrgUnitID).append("'");
            paramResultSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (paramResultSet.next() && (isPrioCusDis = paramResultSet.getString("Fvalue_l2")) == null) {
                isPrioCusDis = paramResultSet.getString("fdefaultval_l2");
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
                catch (BOSException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(paramResultSet);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)paramResultSet);
        return isPrioCusDis;
    }

    @Override
    protected Map _isPricePolicyPriceExist(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        HashMap<String, String> retMap;
        block8: {
            IPriceProvider iProvider;
            HashMap<String, MaterialInfo> map;
            boolean isCentralBalance;
            SaleOrderInfo saleOrderInfo;
            CustomerInfo customerInfo;
            block7: {
                retMap = new HashMap<String, String>();
                customerInfo = null;
                CustomerInfo balanceCustomerInfo = null;
                saleOrderInfo = (SaleOrderInfo)objectValue;
                isCentralBalance = saleOrderInfo.isIsCentralBalance();
                SaleOrderEntryCollection saleOrderEntryCollection = saleOrderInfo.getEntries();
                Object[] pks = new ObjectUuidPK[saleOrderEntryCollection.size()];
                int n = saleOrderEntryCollection.size();
                for (int i = 0; i < n; ++i) {
                    pks[i] = new ObjectUuidPK(saleOrderEntryCollection.get(i).getMaterial().getId().toString());
                }
                CoreBaseCollection coreBaseCollection = MaterialFactory.getLocalInstance((Context)ctx).getCollection(" where id in  (" + StringUtil.getKeyIdList((Object[])pks) + ")");
                map = new HashMap<String, MaterialInfo>();
                for (int i = 0; i < coreBaseCollection.size(); ++i) {
                    MaterialInfo materialInfo = (MaterialInfo)coreBaseCollection.get(i);
                    if (materialInfo == null) continue;
                    map.put(materialInfo.getId().toString(), materialInfo);
                }
                if (!isCentralBalance || !saleOrderInfo.isIsSquareBalance()) break block7;
                balanceCustomerInfo = this.getInnerCustomerByCompany(ctx, saleOrderInfo.getBalanceCompanyOrgUnit().getId().toString());
                customerInfo = this.getInnerCustomerByCompany(ctx, saleOrderInfo.getCompanyOrgUnit().getId().toString());
                if (balanceCustomerInfo == null || customerInfo == null) {
                    return retMap;
                }
                PriceCondition priceCondition = new PriceCondition();
                iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
                priceCondition.setSaleOrg(saleOrderInfo.getSaleOrgUnit());
                priceCondition.setCurrencyInfo(saleOrderInfo.getCurrency());
                priceCondition.setCurDate(saleOrderInfo.getBizDate());
                priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
                SaleOrderEntryCollection entryColl = saleOrderInfo.getEntries();
                String issueToBalance = ResourceBase.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"IssueToBalance", (Locale)ctx.getLocale());
                String balanceToSale = ResourceBase.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"BalanceToSale", (Locale)ctx.getLocale());
                int n2 = entryColl.size();
                for (int i = 0; i < n2; ++i) {
                    String msgStr;
                    String keyStr;
                    MaterialInfo materialInfo;
                    SaleOrderEntryInfo saleOrderEntry = entryColl.get(i);
                    if (!saleOrderEntry.isIsBetweenCompanySend() || saleOrderEntry.isIsPresent()) continue;
                    priceCondition.setMaterialInfo(saleOrderEntry.getMaterial());
                    priceCondition.setMeasureUnit(saleOrderEntry.getUnit().getId().toString());
                    priceCondition.setCustomerInfo(balanceCustomerInfo);
                    priceCondition.setCompanyOrg(saleOrderEntry.getCompanyOrgUnit());
                    priceCondition.setOrderQty(saleOrderEntry.getQty());
                    priceCondition.setAssiProperty(saleOrderEntry.getAssistProperty());
                    List[] priceList = iProvider.getPrices(new PriceCondition[]{priceCondition});
                    if ((priceList == null || priceList.length < 1 || priceList[0] == null || priceList[0].size() < 1) && map.containsKey(saleOrderEntry.getMaterial().getId().toString())) {
                        materialInfo = (MaterialInfo)map.get(saleOrderEntry.getMaterial().getId().toString());
                        keyStr = "number_" + i + saleOrderEntry.getCompanyOrgUnit().getId().toString();
                        msgStr = issueToBalance + materialInfo.getNumber() + "," + materialInfo.getName();
                        retMap.put(keyStr, msgStr);
                    }
                    priceCondition.setCustomerInfo(customerInfo);
                    priceCondition.setCompanyOrg(saleOrderInfo.getBalanceCompanyOrgUnit());
                    priceList = iProvider.getPrices(new PriceCondition[]{priceCondition});
                    if (priceList != null && priceList.length >= 1 && priceList[0] != null && priceList[0].size() >= 1 || !map.containsKey(saleOrderEntry.getMaterial().getId().toString())) continue;
                    materialInfo = (MaterialInfo)map.get(saleOrderEntry.getMaterial().getId().toString());
                    keyStr = "number_" + i + saleOrderInfo.getBalanceCompanyOrgUnit().getId().toString();
                    msgStr = balanceToSale + materialInfo.getNumber() + "," + materialInfo.getName();
                    retMap.put(keyStr, msgStr);
                }
                break block8;
            }
            if (!isCentralBalance) break block8;
            customerInfo = this.getInnerCustomerByCompany(ctx, saleOrderInfo.getCompanyOrgUnit().getId().toString());
            if (customerInfo == null) {
                return retMap;
            }
            PriceCondition priceCondition = new PriceCondition();
            iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
            priceCondition.setCustomerInfo(customerInfo);
            priceCondition.setSaleOrg(saleOrderInfo.getSaleOrgUnit());
            priceCondition.setCurrencyInfo(saleOrderInfo.getCurrency());
            priceCondition.setCurDate(saleOrderInfo.getBizDate());
            priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
            SaleOrderEntryCollection entryColl = saleOrderInfo.getEntries();
            int n = entryColl.size();
            for (int i = 0; i < n; ++i) {
                SaleOrderEntryInfo saleOrderEntry = entryColl.get(i);
                if (!saleOrderEntry.isIsBetweenCompanySend() || saleOrderEntry.isIsPresent()) continue;
                priceCondition.setMaterialInfo(saleOrderEntry.getMaterial());
                priceCondition.setMeasureUnit(saleOrderEntry.getUnit().getId().toString());
                priceCondition.setCompanyOrg(saleOrderEntry.getCompanyOrgUnit());
                priceCondition.setOrderQty(saleOrderEntry.getQty());
                priceCondition.setAssiProperty(saleOrderEntry.getAssistProperty());
                List[] priceList = iProvider.getPrices(new PriceCondition[]{priceCondition});
                if (priceList != null && priceList.length >= 1 && priceList[0] != null && priceList[0].size() >= 1 || !map.containsKey(saleOrderEntry.getMaterial().getId().toString())) continue;
                MaterialInfo materialInfo = (MaterialInfo)map.get(saleOrderEntry.getMaterial().getId().toString());
                String keyStr = "number_" + i;
                String msgStr = materialInfo.getNumber() + "," + materialInfo.getName();
                retMap.put(keyStr, msgStr);
            }
        }
        return retMap;
    }

    private CustomerInfo getInnerCustomerByCompany(Context ctx, String companyId) throws BOSException {
        CustomerInfo customerInfo = null;
        CustomerCollection customerCol = null;
        customerCol = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection("select id,number where internalCompany.id = '" + companyId + "'");
        if (customerCol != null && customerCol.size() > 0) {
            customerInfo = customerCol.get(0);
        }
        return customerInfo;
    }
}

