/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeCollection;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.InitializeInvoiceTypeEnum;
import com.kingdee.eas.basedata.scm.common.InvoiceTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CheckOffStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.RedBlueEnum;
import com.kingdee.eas.scm.common.ReversingStateEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.sd.sale.ISaleInvoice;
import com.kingdee.eas.scm.sd.sale.ISaleInvoiceEntry;
import com.kingdee.eas.scm.sd.sale.SaleInvBizException;
import com.kingdee.eas.scm.sd.sale.SaleInvReceivePlanCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvReceivePlanInfo;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleInvoiceControllerBean;
import com.kingdee.eas.scm.sd.sale.util.SaleInvoiceUtil;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.sm.pur.IPurInvoice;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurInvBizException;
import com.kingdee.eas.scm.sm.pur.PurInvoiceEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurInvoiceEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurInvoiceFactory;
import com.kingdee.eas.scm.sm.pur.PurInvoiceInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleInvoiceControllerBean
extends AbstractSaleInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleInvoiceControllerBean");

    protected void _audit(Context ctx, IObjectPK model) throws BOSException, EASBizException {
        this.newAudit(ctx, model);
    }

    protected void newAudit(Context ctx, IObjectPK model) throws BOSException, EASBizException {
        ResultSet rs;
        Statement updateStatement;
        Statement statement;
        Connection cn;
        block6: {
            super._audit(ctx, model);
            cn = null;
            statement = null;
            updateStatement = null;
            rs = null;
            try {
                cn = this.getConnection(ctx);
                updateStatement = cn.createStatement();
                PreparedStatement pstmt = cn.prepareStatement("select FSourceBillID,FSourceBillTypeID,FisReversed,FInitializeInvoiceType,FBaseStatus,FBizTypeID, FCompanyOrgUnitID,FPaymentTypeID,FCustomerID,FLocalTotalTaxAmount  from T_SD_SaleInvoice where fid=?");
                pstmt.setString(1, model.toString());
                rs = pstmt.executeQuery();
                int initialType = 0;
                int state = 0;
                boolean isReversed = false;
                String sourceBillId = null;
                String sourcebillTypeId = null;
                SaleInvoiceInfo invoice = null;
                if (!rs.next()) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                initialType = rs.getInt("FInitializeInvoiceType");
                state = rs.getInt("FBaseStatus");
                isReversed = rs.getBoolean("FisReversed");
                sourceBillId = rs.getString("FSourceBillID");
                sourcebillTypeId = rs.getString("FSourceBillTypeID");
                invoice = new SaleInvoiceInfo();
                invoice.setId(BOSUuid.read((String)model.toString()));
                invoice.setSourceBillId(sourceBillId);
                BillTypeInfo ti = new BillTypeInfo();
                ti.setId(BOSUuid.read((String)sourcebillTypeId));
                invoice.setSourceBillType(ti);
                invoice.setBaseStatus(BillBaseStatusEnum.AUDITED);
                BizTypeInfo bti = new BizTypeInfo();
                bti.setId(BOSUuid.read((String)rs.getString("FBizTypeID")));
                invoice.setBizType(bti);
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)rs.getString("FCompanyOrgUnitID")));
                invoice.setCompanyOrgUnit(company);
                PaymentTypeInfo pt = new PaymentTypeInfo();
                pt.setId(BOSUuid.read((String)rs.getString("FPaymentTypeID")));
                invoice.setPaymentType(pt);
                CustomerInfo ct = new CustomerInfo();
                ct.setId(BOSUuid.read((String)rs.getString("FCustomerID")));
                invoice.setCustomer(ct);
                invoice.setLocalTotalTaxAmount(rs.getBigDecimal("FLocalTotalTaxAmount"));
                this.checkCanAudit(initialType, state);
                StringBuffer updateSql = new StringBuffer("update T_SD_SaleInvoice set FBaseStatus=");
                updateSql.append(BillBaseStatusEnum.AUDITED.getValue()).append(" , FAuditorId='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("',FAuditTime = getDate() where fid='").append(model.toString()).append("'");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
                if (isReversed) {
                    this.auditReverseInvoice(ctx, cn, model, sourceBillId);
                    break block6;
                }
                this.auditNormalInvoice(ctx, cn, model, sourcebillTypeId);
            }
            catch (SQLException er) {
                try {
                    throw new BOSException("sql Execute Error :", (Throwable)er);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    SQLUtils.cleanup(statement, (Connection)cn);
                    SQLUtils.cleanup((Statement)updateStatement, (Connection)cn);
                    SQLUtils.cleanup((Connection)cn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup(statement, (Connection)cn);
        SQLUtils.cleanup((Statement)updateStatement, (Connection)cn);
        SQLUtils.cleanup((Connection)cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auditNormalInvoice(Context ctx, Connection cn, IObjectPK invPk, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        Statement stmt = null;
        IRowSet rs = null;
        String bizTypeID = null;
        SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
        saleInvoiceInfo.setId(BOSUuid.read((String)invPk.toString()));
        try {
            String sql = "select fbizTypeID ,FRedBlueType,FBaseStatus,FCompanyOrgUnitID,FSourceBillID,FSourceBillTypeID,FisReversed from T_SD_SaleInvoice where fid='" + invPk.toString() + "'";
            stmt = cn.createStatement();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                bizTypeID = rs.getString("fbizTypeID");
                saleInvoiceInfo.setRedBlueType(RedBlueEnum.getEnum((int)rs.getInt("FRedBlueType")));
                saleInvoiceInfo.setBaseStatus(BillBaseStatusEnum.getEnum((int)rs.getInt("FBaseStatus")));
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)rs.getString("FCompanyOrgUnitID")));
                saleInvoiceInfo.setCompanyOrgUnit(companyInfo);
                saleInvoiceInfo.setSourceBillId(rs.getString("FSourceBillID"));
                BillTypeInfo billTypeInfo = new BillTypeInfo();
                billTypeInfo.setId(BOSUuid.read((String)rs.getString("FSourceBillTypeID")));
                saleInvoiceInfo.setSourceBillType(billTypeInfo);
                saleInvoiceInfo.setIsReversed(rs.getBoolean("FisReversed"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt);
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((ResultSet)rs);
        this.writeBackPreBill(ctx, cn, invPk, true, sourceBillTypeId);
        this.autoCheckOff(ctx, saleInvoiceInfo);
        this.updateInventroy(ctx, invPk, bizTypeID);
        this.createPurInvoice(ctx, invPk, bizTypeID, sourceBillTypeId);
    }

    private void updateInventroy(Context ctx, IObjectPK saleInvoicePK, String bizTypeID) throws BOSException, EASBizException, SQLException {
        if (bizTypeID != null) {
            String sql = "SELECT TOP 1 FID FROM T_SCM_TRANSACTIONTYPE T WHERE T.FNUMBER = ?";
            IRowSet rowSet = null;
            IInventoryUpdate inventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
            if (bizTypeID.equals("d8e80652-0113-1000-e000-04c5c0a812202407435C")) {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"224E"});
                try {
                    if (rowSet != null && rowSet.next()) {
                        inventoryUpdate.updateInventory(BizActionEnum.AUDIT, saleInvoicePK.toString(), rowSet.getString("FID"));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
            if (bizTypeID.equals("d8e80652-0114-1000-e000-04c5c0a812202407435C")) {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"223E"});
                try {
                    if (rowSet != null && rowSet.next()) {
                        inventoryUpdate.updateInventory(BizActionEnum.AUDIT, saleInvoicePK.toString(), rowSet.getString("FID"));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private void writeBackPreBill(Context ctx, Connection cn, IObjectPK invPk, boolean isAdd, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        if (sourceBillTypeId != null && sourceBillTypeId.equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
            this.writeBackOrder(ctx, cn, invPk, isAdd, sourceBillTypeId);
        } else if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
            this.writeBackSaleIssueBill(ctx, cn, invPk, isAdd, sourceBillTypeId);
            this.writeBackOrder(ctx, cn, invPk, isAdd, sourceBillTypeId);
            this.writeBackStockTrans(ctx, cn, invPk, isAdd, sourceBillTypeId);
            this.writeBackSaleReturn(ctx, cn, invPk, isAdd, sourceBillTypeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackSaleReturn(Context ctx, Connection cn, IObjectPK invPk, boolean isAdd, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        Statement selectpstmt = null;
        PreparedStatement updateStatement = null;
        IRowSet rs = null;
        HashMap returnentryPKInvNumberMap = new HashMap();
        try {
            if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select saleInv.fnumber \"saleInv.fnumber\",");
                sql.append("saleInvEntry.fseq \"saleInvEntry.fseq\",");
                sql.append("saleInvEntry.fqty \"saleInvEntry.fqty\",");
                sql.append("saleInvEntry.fbaseQty \"saleInvEntry.fbaseQty\",");
                sql.append("saleInvEntry.fUnitid  \"saleInvEntry.fUnitid\",");
                sql.append("saleInvEntry.fBaseUnitid \"saleInvEntry.fBaseUnitid\",");
                sql.append("saleReturn.fnumber  \"saleReturn.fnumber\",");
                sql.append("saleReturnsEntry.fid \"returnEntry.fid\",");
                sql.append("saleReturnsEntry.fseq \"returnEntry.fseq\",");
                sql.append("saleReturnsEntry.fqty \"returnEntry.fqty\",");
                sql.append("saleReturnsEntry.fbaseQty \"returnEntry.fbaseQty\",");
                sql.append("saleReturnsEntry.fInvoicedQty \"returnEntry.fInvQty\",");
                sql.append("saleReturnsEntry.fInvoicedBaseQty \"returnEntry.fInvBaseQty\",");
                sql.append("saleReturnsEntry.fUnitid \"returnEntry.fUnitid\",");
                sql.append("saleReturnsEntry.fBaseUnitid \"returnEntry.fBaseUnitid\", ");
                sql.append("saleReturnsEntry.fMaterialid \"returnEntry.fMaterialid\" ");
                sql.append("from t_sd_SaleInvoice saleInv ");
                sql.append("inner join t_SD_SaleInvoiceEntry saleInvEntry on saleInv.fid=saleInvEntry.fparentid ");
                sql.append("inner join T_SD_SaleReturnsEntry  saleReturnsEntry on saleInvEntry.FSaleOrderEntryID=saleReturnsEntry.fid ");
                sql.append("inner join T_SD_SaleReturns saleReturn on saleReturn.fid=saleReturnsEntry.fparentid ");
                sql.append("where saleInv.fid='").append(invPk.toString()).append("' and saleInvEntry.fcorebillTypeid='").append("50957179-0105-1000-e008-8152c0a812fd463ED552").append("'");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                String updateOrderSql = "update T_SD_SaleReturnsEntry set FInvoicedQty = ?,FInvoicedBaseQty=? where Fid = ?";
                updateStatement = cn.prepareStatement(updateOrderSql);
                int batchNum = 0;
                while (rs.next()) {
                    BigDecimal newbaseInvQty;
                    BigDecimal newinvoiceQty;
                    Map numberMap;
                    HashMap<String, BigDecimal> map;
                    ++batchNum;
                    BigDecimal invoicedqty = rs.getBigDecimal("returnEntry.fInvQty");
                    BigDecimal invoiceBaseQty = rs.getBigDecimal("returnEntry.fInvBaseQty");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("saleInvEntry.fbaseQty").abs();
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("returnEntry.fUnitid").equals(rs.getString("saleInvEntry.fUnitid")) ? rs.getBigDecimal("saleInvEntry.fqty").abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("returnEntry.fMaterialid"), (String)rs.getString("returnEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("returnEntry.fUnitid"));
                    if (isAdd) {
                        if (!returnentryPKInvNumberMap.containsKey(rs.getString("returnEntry.fid"))) {
                            map = new HashMap<String, BigDecimal>();
                            map.put("invoiceQty", invoicedqty);
                            map.put("invoiceBaseQty", invoiceBaseQty);
                            returnentryPKInvNumberMap.put(rs.getString("returnEntry.fid"), map);
                        }
                        numberMap = (Map)returnentryPKInvNumberMap.get(rs.getString("returnEntry.fid"));
                        newinvoiceQty = ((BigDecimal)numberMap.get("invoiceQty")).add(deltaQty);
                        newbaseInvQty = ((BigDecimal)numberMap.get("invoiceBaseQty")).add(deltaBaseQty);
                        numberMap.put("invoiceQty", newinvoiceQty);
                        numberMap.put("invoiceBaseQty", newbaseInvQty);
                        updateStatement.setBigDecimal(1, newinvoiceQty);
                        updateStatement.setBigDecimal(2, newbaseInvQty);
                        updateStatement.setString(3, rs.getString("returnEntry.fid"));
                    } else {
                        if (!returnentryPKInvNumberMap.containsKey(rs.getString("returnEntry.fid"))) {
                            map = new HashMap();
                            map.put("invoiceQty", invoicedqty);
                            map.put("invoiceBaseQty", invoiceBaseQty);
                            returnentryPKInvNumberMap.put(rs.getString("returnEntry.fid"), map);
                        }
                        numberMap = (Map)returnentryPKInvNumberMap.get(rs.getString("returnEntry.fid"));
                        newinvoiceQty = ((BigDecimal)numberMap.get("invoiceQty")).subtract(deltaQty);
                        newbaseInvQty = ((BigDecimal)numberMap.get("invoiceBaseQty")).subtract(deltaBaseQty);
                        numberMap.put("invoiceQty", newinvoiceQty);
                        numberMap.put("invoiceBaseQty", newbaseInvQty);
                        updateStatement.setBigDecimal(1, newinvoiceQty);
                        updateStatement.setBigDecimal(2, newbaseInvQty);
                        updateStatement.setString(3, rs.getString("returnEntry.fid"));
                    }
                    updateStatement.addBatch();
                }
                if (batchNum > 0) {
                    updateStatement.executeBatch();
                }
            }
        }
        finally {
            SQLUtils.cleanup(selectpstmt);
            SQLUtils.cleanup(updateStatement);
            SQLUtils.cleanup(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackStockTrans(Context ctx, Connection cn, IObjectPK invPk, boolean isAdd, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        Statement selectpstmt = null;
        PreparedStatement updateStatement = null;
        IRowSet rs = null;
        HashMap stockentryPKInvNumberMap = new HashMap();
        try {
            if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select saleInv.fnumber \"saleInv.fnumber\",");
                sql.append("saleInvEntry.fseq \"saleInvEntry.fseq\",");
                sql.append("saleInvEntry.fqty \"saleInvEntry.fqty\",");
                sql.append("saleInvEntry.fbaseQty \"saleInvEntry.fbaseQty\",");
                sql.append("saleInvEntry.fUnitid  \"saleInvEntry.fUnitid\",");
                sql.append("saleInvEntry.fBaseUnitid \"saleInvEntry.fBaseUnitid\",");
                sql.append("stockTrans.fnumber  \"stockTrans.fnumber\",");
                sql.append("stockTransEntry.fid \"stockTransEntry.fid\",");
                sql.append("stockTransEntry.fseq \"stockTransEntry.fseq\",");
                sql.append("stockTransEntry.fqty \"stockTransEntry.fqty\",");
                sql.append("stockTransEntry.fbaseQty \"stockTransEntry.fbaseQty\",");
                sql.append("stockTransEntry.fSaleInvoiceQty \"stockTransEntry.saleInvQty\",");
                sql.append("stockTransEntry.fSaleInvoiceBaseQty \"stockTransEntry.saleInvBaseQty\",");
                sql.append("stockTransEntry.fUnitid \"stockTransEntry.fUnitid\",");
                sql.append("stockTransEntry.fBaseUnitid \"stockTransEntry.fBaseUnitid\", ");
                sql.append("stockTransEntry.fMaterialid \"stockTransEntry.fMaterialid\" ");
                sql.append("from t_sd_SaleInvoice saleInv ");
                sql.append("inner join t_SD_SaleInvoiceEntry saleInvEntry on saleInv.fid=saleInvEntry.fparentid ");
                sql.append("inner join T_IM_StockTransferBillEntry  stockTransEntry on saleInvEntry.FSaleOrderEntryID=stockTransEntry.fid ");
                sql.append("inner join T_IM_StockTransferBill stockTrans on stockTrans.fid=stockTransEntry.fparentid ");
                sql.append("where saleInv.fid='").append(invPk.toString()).append("' and saleInvEntry.fcorebillTypeid='").append("50957179-0105-1000-e003-3152c0a812fd463ED552").append("'");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                String updateOrderSql = "update T_IM_StockTransferBillEntry set fSaleInvoiceQty = ?,fSaleInvoiceBaseQty=? where Fid = ?";
                updateStatement = cn.prepareStatement(updateOrderSql);
                int batchNum = 0;
                while (rs.next()) {
                    BigDecimal newbaseInvQty;
                    BigDecimal newinvoiceQty;
                    Map numberMap;
                    HashMap<String, BigDecimal> map;
                    ++batchNum;
                    BigDecimal invoicedqty = rs.getBigDecimal("stockTransEntry.saleInvQty");
                    BigDecimal invoiceBaseQty = rs.getBigDecimal("stockTransEntry.saleInvBaseQty");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("saleInvEntry.fbaseQty").abs();
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("stockTransEntry.fUnitid").equals(rs.getString("saleInvEntry.fUnitid")) ? rs.getBigDecimal("saleInvEntry.fqty").abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("stockTransEntry.fMaterialid"), (String)rs.getString("stockTransEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("stockTransEntry.fUnitid"));
                    if (isAdd) {
                        if (!stockentryPKInvNumberMap.containsKey(rs.getString("stockTransEntry.fid"))) {
                            map = new HashMap<String, BigDecimal>();
                            map.put("invoiceQty", invoicedqty);
                            map.put("invoiceBaseQty", invoiceBaseQty);
                            stockentryPKInvNumberMap.put(rs.getString("stockTransEntry.fid"), map);
                        }
                        numberMap = (Map)stockentryPKInvNumberMap.get(rs.getString("stockTransEntry.fid"));
                        newinvoiceQty = ((BigDecimal)numberMap.get("invoiceQty")).add(deltaQty);
                        newbaseInvQty = ((BigDecimal)numberMap.get("invoiceBaseQty")).add(deltaBaseQty);
                        numberMap.put("invoiceQty", newinvoiceQty);
                        numberMap.put("invoiceBaseQty", newbaseInvQty);
                        updateStatement.setBigDecimal(1, newinvoiceQty);
                        updateStatement.setBigDecimal(2, newbaseInvQty);
                        updateStatement.setString(3, rs.getString("stockTransEntry.fid"));
                    } else {
                        if (!stockentryPKInvNumberMap.containsKey(rs.getString("stockTransEntry.fid"))) {
                            map = new HashMap();
                            map.put("invoiceQty", invoicedqty);
                            map.put("invoiceBaseQty", invoiceBaseQty);
                            stockentryPKInvNumberMap.put(rs.getString("stockTransEntry.fid"), map);
                        }
                        numberMap = (Map)stockentryPKInvNumberMap.get(rs.getString("stockTransEntry.fid"));
                        newinvoiceQty = ((BigDecimal)numberMap.get("invoiceQty")).subtract(deltaQty);
                        newbaseInvQty = ((BigDecimal)numberMap.get("invoiceBaseQty")).subtract(deltaBaseQty);
                        numberMap.put("invoiceQty", newinvoiceQty);
                        numberMap.put("invoiceBaseQty", newbaseInvQty);
                        updateStatement.setBigDecimal(1, newinvoiceQty);
                        updateStatement.setBigDecimal(2, newbaseInvQty);
                        updateStatement.setString(3, rs.getString("stockTransEntry.fid"));
                    }
                    updateStatement.addBatch();
                }
                if (batchNum > 0) {
                    updateStatement.executeBatch();
                }
            }
        }
        finally {
            SQLUtils.cleanup(selectpstmt);
            SQLUtils.cleanup(updateStatement);
            SQLUtils.cleanup(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackSaleIssueBill(Context ctx, Connection cn, IObjectPK invPk, boolean isAdd, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        Statement selectpstmt = null;
        PreparedStatement updateStatement = null;
        IRowSet rs = null;
        try {
            if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select saleInv.fnumber \"saleInv.fnumber\",");
                sql.append("saleInvEntry.fseq \"saleInvEntry.fseq\",");
                sql.append("saleInvEntry.fqty \"saleInvEntry.fqty\",");
                sql.append("saleInvEntry.fbaseQty \"saleInvEntry.fbaseQty\",");
                sql.append("saleInvEntry.fUnitid  \"saleInvEntry.fUnitid\",");
                sql.append("saleInvEntry.fBaseUnitid \"saleInvEntry.fBaseUnitid\",");
                sql.append("saleIssue.fnumber  \"saleIssue.fnumber\",");
                sql.append("saleIssueEntry.fid \"saleIssEntry.fid\",");
                sql.append("saleIssueEntry.fseq \"saleIssEntry.fseq\",");
                sql.append("saleIssueEntry.fqty \"saleIssEntry.fqty\",");
                sql.append("saleIssueEntry.fbaseQty \"saleIssEntry.fbaseQty\",");
                sql.append("saleIssueEntry.fDrewQty \"saleIssEntry.fDrewQty\",");
                sql.append("saleIssueEntry.fDrewBaseQty \"saleIssEntry.fDrewBaseQty\",");
                sql.append("saleIssueEntry.fUnitid \"saleIssEntry.fUnitid\",");
                sql.append("saleIssueEntry.fBaseUnitid \"saleIssEntry.fBaseUnitid\", ");
                sql.append("saleIssueEntry.fMaterialid \"saleIssEntry.fMaterialid\" ");
                sql.append("from t_sd_SaleInvoice saleInv ");
                sql.append("inner join t_SD_SaleInvoiceEntry saleInvEntry on saleInv.fid=saleInvEntry.fparentid ");
                sql.append("inner join t_IM_SaleIssueEntry  saleIssueEntry on saleInvEntry.FSourceBillEntryID=saleIssueEntry.fid ");
                sql.append("inner join t_IM_SaleIssueBill saleIssue on saleIssue.fid=saleIssueEntry.fparentid ");
                sql.append("where saleInv.fid='").append(invPk.toString()).append("'");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                String updateOrderSql = "update t_IM_SaleIssueEntry set fDrewQty = ?,fDrewBaseQty=?,FAssociateQty=? where Fid = ?";
                updateStatement = cn.prepareStatement(updateOrderSql);
                int batchNum = 0;
                while (rs.next()) {
                    ++batchNum;
                    BigDecimal qty = rs.getBigDecimal("saleIssEntry.fDrewQty");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("saleInvEntry.fbaseQty");
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("saleIssEntry.fUnitid").equals(rs.getString("saleInvEntry.fUnitid")) ? rs.getBigDecimal("saleInvEntry.fqty") : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("saleIssEntry.fMaterialid"), (String)rs.getString("saleIssEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("saleIssEntry.fUnitid"));
                    if (isAdd) {
                        BigDecimal newinvoiceQty = qty.add(deltaQty);
                        BigDecimal tBaseInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("saleIssEntry.fDrewBaseQty")).add(deltaBaseQty);
                        if (tBaseInvoiceQty.abs().compareTo(SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("saleIssEntry.fbaseQty")).abs()) > 0) {
                            throw new SaleInvBizException(SaleInvBizException.WRITEBACKSALEISSUEERROR, new Object[]{rs.getString("saleInv.fnumber"), rs.getString("saleInvEntry.fseq"), rs.getString("saleIssue.fnumber"), rs.getString("saleIssEntry.fseq")});
                        }
                        updateStatement.setBigDecimal(1, newinvoiceQty);
                        BigDecimal newdrewQty = rs.getBigDecimal("saleIssEntry.fDrewBaseQty").add(deltaBaseQty);
                        updateStatement.setBigDecimal(2, newdrewQty);
                        updateStatement.setBigDecimal(3, rs.getBigDecimal("saleIssEntry.fbaseQty").subtract(newdrewQty));
                        updateStatement.setString(4, rs.getString("saleIssEntry.fid"));
                    } else {
                        updateStatement.setBigDecimal(1, qty.subtract(deltaQty));
                        BigDecimal newdrewQty = rs.getBigDecimal("saleIssEntry.fDrewBaseQty").subtract(deltaBaseQty);
                        updateStatement.setBigDecimal(2, newdrewQty);
                        updateStatement.setBigDecimal(3, rs.getBigDecimal("saleIssEntry.fbaseQty").subtract(newdrewQty));
                        updateStatement.setString(4, rs.getString("saleIssEntry.fid"));
                    }
                    updateStatement.addBatch();
                }
                if (batchNum > 0) {
                    updateStatement.executeBatch();
                }
            }
        }
        finally {
            SQLUtils.cleanup(selectpstmt);
            SQLUtils.cleanup(updateStatement);
            SQLUtils.cleanup(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPurInvoice(Context ctx, IObjectPK invPK, String bizTypeID, String sourceBillTypeID) throws BOSException, EASBizException {
        SaleInvoiceInfo saleInvoiceInfo = null;
        if (bizTypeID != null && bizTypeID.equals("d8e80652-0111-1000-e000-04c5c0a812202407435C")) {
            saleInvoiceInfo = SaleInvoiceFactory.getLocalInstance(ctx).getSaleInvoiceInfo(invPK);
            if (sourceBillTypeID != null && sourceBillTypeID.equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                IBOTRelation ibotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
                SaleInvoiceEntryCollection entrycollection = saleInvoiceInfo.getEntries();
                HashMap<String, String> findedBillID = new HashMap<String, String>();
                if (entrycollection != null) {
                    int csize = entrycollection.size();
                    for (int n = 0; n < csize; ++n) {
                        SaleInvoiceEntryInfo entryInfo = entrycollection.get(n);
                        if (findedBillID.containsValue(entryInfo.getSourceBillId())) continue;
                        findedBillID.put(entryInfo.getSourceBillId(), entryInfo.getSourceBillId());
                        ArrayList list = ibotRelation.getDestObjIdByDestType(entryInfo.getSourceBillId(), new PurOrderInfo().getBOSType().toString());
                        IBTPManager ibtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                        if (list != null && list.size() > 0) {
                            IPurOrder ipurOrder = PurOrderFactory.getLocalInstance((Context)ctx);
                            IPurInvoice ipurInvoice = PurInvoiceFactory.getLocalInstance((Context)ctx);
                            int num = list.size();
                            for (int j = 0; j < num; ++j) {
                                String id = list.get(j).toString();
                                PurOrderInfo purorderInfo = ipurOrder.getPurOrderInfo((IObjectPK)new ObjectStringPK(id));
                                if (!purorderInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                                    throw new SaleInvBizException(SaleInvBizException.CREATEDIRECTPURINVERROR, new Object[]{saleInvoiceInfo.getNumber()});
                                }
                                BTPTransformResult result = ibtpManager.transform((CoreBillBaseInfo)purorderInfo, new PurInvoiceInfo().getBOSType().toString());
                                if (result == null) continue;
                                IObjectCollection collection = result.getBills();
                                int size = collection.size();
                                for (int i = 0; i < size; ++i) {
                                    PurInvoiceInfo purInvInfo = (PurInvoiceInfo)collection.getObject(i);
                                    this.updateDirectPurInvQty(ctx, purInvInfo, saleInvoiceInfo);
                                    if (purInvInfo.getEntries() == null && purInvInfo.getEntries().size() <= 0) continue;
                                    if ((purInvInfo = ipurInvoice.initRelateCreateInvoiceInfo(purInvInfo)).getNumber() == null || purInvInfo.getNumber().trim().length() == 0) {
                                        String number = "PurInv_Auto_" + purorderInfo.getNumber() + i;
                                        while (ipurInvoice.exists("where number ='" + number + "'")) {
                                            number = number + "1";
                                        }
                                        purInvInfo.setNumber(number);
                                    }
                                    boolean b = WfEventListenerStateManager.getInstance().isEnable();
                                    try {
                                        if (!b) {
                                            WfEventListenerStateManager.getInstance().enableEventListener();
                                        }
                                        IObjectPK objectpk = ibtpManager.submitRelations((CoreBillBaseInfo)purInvInfo, result.getBOTRelationCollection());
                                        if (SCMServerUtils.isAuditAfterSubmitPurInv((Context)ctx, (String)purInvInfo.getCompanyOrgUnit().getId().toString())) continue;
                                        ipurInvoice.audit(objectpk);
                                        continue;
                                    }
                                    finally {
                                        if (!b) {
                                            WfEventListenerStateManager.getInstance().disableEventListener();
                                        }
                                    }
                                }
                            }
                            continue;
                        }
                        throw new SaleInvBizException(SaleInvBizException.SOURCEBILLNOTCREATEPURORDER_CANNOTCREATEPURINV, new Object[]{saleInvoiceInfo.getNumber()});
                    }
                }
            } else {
                throw new SaleInvBizException(SaleInvBizException.SOURCEBILLNOTORDER_CANNOTCREATEPURINV, new Object[]{saleInvoiceInfo.getNumber()});
            }
        }
    }

    private void updateDirectPurInvQty(Context ctx, PurInvoiceInfo purInvInfo, SaleInvoiceInfo saleInvInfo) throws BOSException, EASBizException {
        PurInvoiceEntryCollection purInvEntryCollect = purInvInfo.getEntries();
        SaleInvoiceEntryCollection saleInvEntryCollect = saleInvInfo.getEntries();
        if (purInvEntryCollect != null && purInvEntryCollect.size() > 0) {
            IPurOrderEntry ipurorderEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
            int num = purInvEntryCollect.size();
            for (int i = 0; i < num; ++i) {
                PurOrderEntryInfo purOrderEntryInfo;
                boolean found = false;
                PurInvoiceEntryInfo purEntryInfo = purInvEntryCollect.get(i);
                if (purEntryInfo.getSourceBillEntryId() == null || (purOrderEntryInfo = ipurorderEntry.getPurOrderEntryInfo((IObjectPK)new ObjectStringPK(purEntryInfo.getSourceBillEntryId()))) == null || purOrderEntryInfo.getSourceBillEntryId() == null) continue;
                int size = saleInvEntryCollect.size();
                for (int j = 0; j < size; ++j) {
                    SaleInvoiceEntryInfo saleInvEntryInfo = saleInvEntryCollect.get(j);
                    if (saleInvEntryInfo.getSourceBillEntryId() != null && saleInvEntryInfo.getSourceBillEntryId().equals(purOrderEntryInfo.getSourceBillEntryId())) {
                        if (saleInvEntryInfo.getUnit() == null) {
                            ISaleInvoiceEntry isaleInvEntry = SaleInvoiceEntryFactory.getLocalInstance(ctx);
                            saleInvEntryInfo = isaleInvEntry.getSaleInvoiceEntryInfo((IObjectPK)new ObjectUuidPK(saleInvEntryInfo.getId()));
                        }
                        if (purEntryInfo.getUnit() != null) {
                            if (saleInvEntryInfo.getUnit().getId().equals((Object)purEntryInfo.getUnit().getId())) {
                                purEntryInfo.setQty(saleInvEntryInfo.getQty());
                            } else {
                                BigDecimal deltaBaseQty = saleInvEntryInfo.getBaseQty().abs();
                                BigDecimal deltaQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)saleInvEntryInfo.getMaterial().getId().toString(), (String)saleInvEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)deltaBaseQty, (String)purEntryInfo.getUnit().getId().toString());
                                purEntryInfo.setQty(deltaQty);
                            }
                        } else {
                            purEntryInfo.setQty(saleInvEntryInfo.getQty());
                        }
                        found = true;
                        break;
                    }
                    found = false;
                }
                if (!found) {
                    purInvEntryCollect.remove(purEntryInfo);
                    --i;
                    --num;
                }
                if (purEntryInfo.getQty().compareTo(new BigDecimal("0.00")) != 0) continue;
                purInvEntryCollect.remove(purEntryInfo);
                --i;
                --num;
            }
        }
    }

    private void autoCheckOff(Context ctx, SaleInvoiceInfo saleInvoiceInfo) throws BOSException, EASBizException {
        if (!this.isRelateCreate(saleInvoiceInfo)) {
            return;
        }
        ICalculateFacade iCalculateFacade = CalculateFacadeFactory.getLocalInstance((Context)ctx);
        iCalculateFacade.calculate((CoreBillBaseInfo)saleInvoiceInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auditReverseInvoice(Context ctx, Connection cn, IObjectPK invPk, String srcBillidstr) throws BOSException, EASBizException, SQLException {
        Statement updateStatement = null;
        IRowSet rs = null;
        try {
            String sourceBillTypeId = null;
            updateStatement = cn.createStatement();
            StringBuffer updateSql = new StringBuffer("update T_SD_SaleInvoice set FReversingStatus=");
            updateSql.append(ReversingStateEnum.REVERSED.getValue()).append("where fid='").append(srcBillidstr).append("'");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
            rs = DbUtil.executeQuery((Context)ctx, (String)("select FSourceBillTypeID from t_SD_SaleInvoice where fid='" + srcBillidstr + "'"));
            if (rs.next()) {
                sourceBillTypeId = rs.getString("FSourceBillTypeID");
            }
            this.writeBackPreBill(ctx, cn, (IObjectPK)new ObjectStringPK(srcBillidstr), false, sourceBillTypeId);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(updateStatement);
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)updateStatement);
        SQLUtils.cleanup((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackOrder(Context ctx, Connection cn, IObjectPK invPk, boolean isAdd, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        PreparedStatement selectpstmt = null;
        PreparedStatement updateStatement = null;
        ResultSet rs = null;
        HashMap orderentryPKInvNumberMap = new HashMap();
        try {
            if (sourceBillTypeId != null && sourceBillTypeId.equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select saleInv.fnumber \"saleInv.fnumber\",");
                sql.append("saleInvEntry.fseq \"saleInvEntry.fseq\",");
                sql.append("saleInvEntry.fqty \"saleInvEntry.fqty\",");
                sql.append("saleInvEntry.fbaseQty \"saleInvEntry.fbaseQty\",");
                sql.append("saleInvEntry.fUnitid  \"saleInvEntry.fUnitid\",");
                sql.append("saleInvEntry.fBaseUnitid \"saleInvEntry.fBaseUnitid\",");
                sql.append("saleOrder.fnumber  \"saleOrder.fnumber\",");
                sql.append("saleOrderEntry.fid \"saleOrderEntry.fid\",");
                sql.append("saleOrderEntry.fseq \"saleOrderEntry.fseq\",");
                sql.append("saleOrderEntry.fqty \"saleOrderEntry.fqty\",");
                sql.append("saleOrderEntry.fbaseQty \"saleOrderEntry.fbaseQty\",");
                sql.append("saleOrderEntry.fTotalInvoicedQty \"saleOrderEntry.tolInvoiceQty\",");
                sql.append("saleOrderEntry.fTolInvoidBaseQty \"saleOrderEntry.tolInvBaseQty\",");
                sql.append("saleOrderEntry.FQuantityUnCtrl \"saleOrderEntry.FQuantityUnCtrl\",");
                sql.append("saleOrderEntry.fUnitid \"saleOrderEntry.fUnitid\",");
                sql.append("saleOrderEntry.fBaseUnitid \"saleOrderEntry.fBaseUnitid\", ");
                sql.append("saleOrderEntry.fMaterialid \"saleOrderEntry.fMaterialid\" ");
                sql.append("from t_sd_SaleInvoice saleInv ");
                sql.append("inner join t_SD_SaleInvoiceEntry saleInvEntry on saleInv.fid=saleInvEntry.fparentid ");
                sql.append("inner join t_SD_SaleOrderEntry  saleOrderEntry on saleInvEntry.fSaleOrderEntryID=saleOrderEntry.fid ");
                sql.append("inner join t_SD_SaleOrder saleOrder on saleOrder.fid=saleOrderEntry.fparentid ");
                sql.append("where saleInv.fid=?");
                selectpstmt = cn.prepareStatement(sql.toString());
                selectpstmt.setString(1, invPk.toString());
                rs = selectpstmt.executeQuery();
                String updateOrderSql = "update T_SD_SaleOrderEntry set FTotalInvoicedQty = ?,FTolInvoidBaseQty=?,FAssociateQty=? where Fid = ?";
                updateStatement = cn.prepareStatement(updateOrderSql);
                int batchNum = 0;
                while (rs.next()) {
                    BigDecimal tolInvBaseQty;
                    BigDecimal newinvoiceQty;
                    BigDecimal temp;
                    Map numberMap;
                    HashMap<String, BigDecimal> map;
                    ++batchNum;
                    BigDecimal qty = rs.getBigDecimal("saleOrderEntry.tolInvoiceQty");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("saleInvEntry.fbaseQty").abs();
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("saleOrderEntry.fUnitid").equals(rs.getString("saleInvEntry.fUnitid")) ? rs.getBigDecimal("saleInvEntry.fqty") : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("saleOrderEntry.fMaterialid"), (String)rs.getString("saleOrderEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("saleOrderEntry.fUnitid"));
                    if (isAdd) {
                        BigDecimal tBaseInvoiceQty;
                        if (!orderentryPKInvNumberMap.containsKey(rs.getString("saleOrderEntry.fid"))) {
                            map = new HashMap<String, BigDecimal>();
                            map.put("invoiceQty", qty);
                            map.put("invoiceBaseQty", rs.getBigDecimal("saleOrderEntry.tolInvBaseQty"));
                            orderentryPKInvNumberMap.put(rs.getString("saleOrderEntry.fid"), map);
                        }
                        numberMap = (Map)orderentryPKInvNumberMap.get(rs.getString("saleOrderEntry.fid"));
                        temp = (BigDecimal)numberMap.get("invoiceQty");
                        newinvoiceQty = temp = temp.add(deltaQty);
                        if (!rs.getBoolean("saleOrderEntry.FQuantityUnCtrl") && (tBaseInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)((BigDecimal)numberMap.get("invoiceBaseQty"))).add(deltaBaseQty)).compareTo(rs.getBigDecimal("saleOrderEntry.fbaseQty")) > 0) {
                            throw new SaleInvBizException(SaleInvBizException.WRITEBACKORDERERROR, new Object[]{rs.getString("saleInv.fnumber"), rs.getString("saleInvEntry.fseq"), rs.getString("saleOrder.fnumber"), rs.getString("saleOrderEntry.fseq")});
                        }
                        numberMap.put("invoiceQty", newinvoiceQty);
                        temp = (BigDecimal)numberMap.get("invoiceBaseQty");
                        tolInvBaseQty = temp.add(deltaBaseQty);
                        numberMap.put("invoiceBaseQty", tolInvBaseQty);
                        updateStatement.setBigDecimal(1, newinvoiceQty);
                        updateStatement.setBigDecimal(2, tolInvBaseQty);
                        updateStatement.setBigDecimal(3, rs.getBigDecimal("saleOrderEntry.fbaseQty").subtract(tolInvBaseQty));
                        updateStatement.setString(4, rs.getString("saleOrderEntry.fid"));
                    } else {
                        if (!orderentryPKInvNumberMap.containsKey(rs.getString("saleOrderEntry.fid"))) {
                            map = new HashMap();
                            map.put("invoiceQty", qty);
                            map.put("invoiceBaseQty", rs.getBigDecimal("saleOrderEntry.tolInvBaseQty"));
                            orderentryPKInvNumberMap.put(rs.getString("saleOrderEntry.fid"), map);
                        }
                        numberMap = (Map)orderentryPKInvNumberMap.get(rs.getString("saleOrderEntry.fid"));
                        temp = (BigDecimal)numberMap.get("invoiceQty");
                        newinvoiceQty = temp = temp.subtract(deltaQty);
                        numberMap.put("invoiceQty", newinvoiceQty);
                        temp = (BigDecimal)numberMap.get("invoiceBaseQty");
                        tolInvBaseQty = temp.subtract(deltaBaseQty);
                        numberMap.put("invoiceBaseQty", tolInvBaseQty);
                        updateStatement.setBigDecimal(1, newinvoiceQty);
                        updateStatement.setBigDecimal(2, tolInvBaseQty);
                        updateStatement.setBigDecimal(3, rs.getBigDecimal("saleOrderEntry.fbaseQty").subtract(tolInvBaseQty));
                        updateStatement.setString(4, rs.getString("saleOrderEntry.fid"));
                    }
                    updateStatement.addBatch();
                }
                if (batchNum > 0) {
                    updateStatement.executeBatch();
                }
            } else if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select saleInv.fnumber \"saleInv.fnumber\",");
                sql.append("saleInvEntry.fseq \"saleInvEntry.fseq\",");
                sql.append("saleInvEntry.fqty \"saleInvEntry.fqty\",");
                sql.append("saleInvEntry.fbaseQty \"saleInvEntry.fbaseQty\",");
                sql.append("saleInvEntry.fUnitid  \"saleInvEntry.fUnitid\",");
                sql.append("saleInvEntry.fBaseUnitid \"saleInvEntry.fBaseUnitid\",");
                sql.append("saleOrder.fnumber  \"saleOrder.fnumber\",");
                sql.append("saleOrderEntry.fid \"saleOrderEntry.fid\",");
                sql.append("saleOrderEntry.fseq \"saleOrderEntry.fseq\",");
                sql.append("saleOrderEntry.fqty \"saleOrderEntry.fqty\",");
                sql.append("saleOrderEntry.fbaseQty \"saleOrderEntry.fbaseQty\",");
                sql.append("saleOrderEntry.fTotalInvoicedQty \"saleOrderEntry.tolInvoiceQty\",");
                sql.append("saleOrderEntry.fTolInvoidBaseQty \"saleOrderEntry.tolInvBaseQty\",");
                sql.append("saleOrderEntry.fUnitid \"saleOrderEntry.fUnitid\",");
                sql.append("saleOrderEntry.FTotalIssueQty \"saleOrderEntry.FTotalIssueQty\", ");
                sql.append("saleOrderEntry.FTotalIssueBaseQty \"saleOrderEntry.issueBaseQty\", ");
                sql.append("saleOrderEntry.fMaterialid \"saleOrderEntry.fMaterialid\", ");
                sql.append("saleOrderEntry.FQuantityUnCtrl \"saleOrderEntry.FQuantityUnCtrl\", ");
                sql.append("saleOrderEntry.fBaseUnitid \"saleOrderEntry.fBaseUnitid\" ");
                sql.append("from t_sd_SaleInvoice saleInv ");
                sql.append("inner join t_SD_SaleInvoiceEntry saleInvEntry on saleInv.fid=saleInvEntry.fparentid ");
                sql.append("inner join t_SD_SaleOrderEntry  saleOrderEntry on saleInvEntry.fSaleOrderEntryID=saleOrderEntry.fid ");
                sql.append("inner join t_SD_SaleOrder saleOrder on saleOrder.fid=saleOrderEntry.fparentid ");
                sql.append("where saleInv.fid='").append(invPk.toString()).append("' and saleInvEntry.fcorebillTypeid='").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("'");
                selectpstmt = cn.prepareStatement(sql.toString());
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                String updateOrderSql = "update T_SD_SaleOrderEntry set FTotalInvoicedQty = ?,FTolInvoidBaseQty=?,FAssociateQty=? where Fid = ?";
                updateStatement = cn.prepareStatement(updateOrderSql);
                int batchNum = 0;
                while (rs.next()) {
                    BigDecimal tolInvBaseQty;
                    BigDecimal newinvoiceQty;
                    BigDecimal temp;
                    Map numberMap;
                    HashMap<String, BigDecimal> map;
                    ++batchNum;
                    BigDecimal qty = rs.getBigDecimal("saleOrderEntry.tolInvoiceQty");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("saleInvEntry.fbaseQty").abs();
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("saleOrderEntry.fUnitid").equals(rs.getString("saleInvEntry.fUnitid")) ? rs.getBigDecimal("saleInvEntry.fqty") : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("saleOrderEntry.fMaterialid"), (String)rs.getString("saleOrderEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("saleOrderEntry.fUnitid"));
                    if (isAdd) {
                        BigDecimal unInvoiceQty;
                        if (!orderentryPKInvNumberMap.containsKey(rs.getString("saleOrderEntry.fid"))) {
                            map = new HashMap<String, BigDecimal>();
                            map.put("invoiceQty", qty);
                            map.put("invoiceBaseQty", rs.getBigDecimal("saleOrderEntry.tolInvBaseQty"));
                            orderentryPKInvNumberMap.put(rs.getString("saleOrderEntry.fid"), map);
                        }
                        numberMap = (Map)orderentryPKInvNumberMap.get(rs.getString("saleOrderEntry.fid"));
                        temp = (BigDecimal)numberMap.get("invoiceQty");
                        newinvoiceQty = temp = temp.add(deltaQty);
                        if (!rs.getBoolean("saleOrderEntry.FQuantityUnCtrl") && (unInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("saleOrderEntry.issueBaseQty")).subtract(SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("saleOrderEntry.tolInvBaseQty")))) != null && SCMUtils.effectualNumeric((BigDecimal)deltaBaseQty).compareTo(unInvoiceQty) > 0) {
                            throw new SaleInvBizException(SaleInvBizException.WRITEBACKORDERERROR, new Object[]{rs.getString("saleInv.fnumber"), rs.getString("saleInvEntry.fseq"), rs.getString("saleOrder.fnumber"), rs.getString("saleOrderEntry.fseq")});
                        }
                        numberMap.put("invoiceQty", newinvoiceQty);
                        temp = (BigDecimal)numberMap.get("invoiceBaseQty");
                        tolInvBaseQty = temp.add(deltaBaseQty);
                        numberMap.put("invoiceBaseQty", tolInvBaseQty);
                        updateStatement.setBigDecimal(1, newinvoiceQty);
                        updateStatement.setBigDecimal(2, tolInvBaseQty);
                        updateStatement.setBigDecimal(3, rs.getBigDecimal("saleOrderEntry.fbaseQty").subtract(tolInvBaseQty));
                        updateStatement.setString(4, rs.getString("saleOrderEntry.fid"));
                    } else {
                        if (!orderentryPKInvNumberMap.containsKey(rs.getString("saleOrderEntry.fid"))) {
                            map = new HashMap();
                            map.put("invoiceQty", qty);
                            map.put("invoiceBaseQty", rs.getBigDecimal("saleOrderEntry.tolInvBaseQty"));
                            orderentryPKInvNumberMap.put(rs.getString("saleOrderEntry.fid"), map);
                        }
                        numberMap = (Map)orderentryPKInvNumberMap.get(rs.getString("saleOrderEntry.fid"));
                        temp = (BigDecimal)numberMap.get("invoiceQty");
                        newinvoiceQty = temp = temp.subtract(deltaQty);
                        numberMap.put("invoiceQty", newinvoiceQty);
                        temp = (BigDecimal)numberMap.get("invoiceBaseQty");
                        tolInvBaseQty = temp.subtract(deltaBaseQty);
                        numberMap.put("invoiceBaseQty", tolInvBaseQty);
                        updateStatement.setBigDecimal(1, newinvoiceQty);
                        updateStatement.setBigDecimal(2, tolInvBaseQty);
                        updateStatement.setBigDecimal(3, rs.getBigDecimal("saleOrderEntry.fbaseQty").subtract(tolInvBaseQty));
                        updateStatement.setString(4, rs.getString("saleOrderEntry.fid"));
                    }
                    updateStatement.addBatch();
                }
                if (batchNum > 0) {
                    updateStatement.executeBatch();
                }
            }
        }
        finally {
            SQLUtils.cleanup(selectpstmt);
            SQLUtils.cleanup(updateStatement);
            SQLUtils.cleanup(rs);
        }
    }

    private void canAudit(SaleInvoiceInfo saleInvoiceInfo) throws SaleInvBizException {
        BillBaseStatusEnum state = saleInvoiceInfo.getBaseStatus();
        InitializeInvoiceTypeEnum initialType = saleInvoiceInfo.getInitializeInvoiceType();
        if (!initialType.equals((Object)InitializeInvoiceTypeEnum.GENERAL)) {
            throw new SaleInvBizException(SaleInvBizException.INITINVCANNOTAUDIT);
        }
        if (state.equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new SaleInvBizException(SaleInvBizException.DELETED_CANNOTAUDIT);
        }
        if (state.equals((Object)BillBaseStatusEnum.CLOSED)) {
            throw new SaleInvBizException(SaleInvBizException.CLOSED_CANNOTAUDIT);
        }
        if (state.equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new SaleInvBizException(SaleInvBizException.TEMPSAVED_CANNOTAUDIT);
        }
        if (state.equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SaleInvBizException(SaleInvBizException.AUDITED_CANNOTAUDIT);
        }
        if (!state.equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new SaleInvBizException(SaleInvBizException.ONLYSAVEDCANAUDIT);
        }
    }

    private void checkCanAudit(int initialType, int state) throws SaleInvBizException, SQLException {
        if (initialType != InitializeInvoiceTypeEnum.GENERAL.getValue()) {
            throw new SaleInvBizException(SaleInvBizException.INITINVCANNOTAUDIT);
        }
        if (state == BillBaseStatusEnum.DELETED.getValue()) {
            throw new SaleInvBizException(SaleInvBizException.DELETED_CANNOTAUDIT);
        }
        if (state == BillBaseStatusEnum.CLOSED.getValue()) {
            throw new SaleInvBizException(SaleInvBizException.CLOSED_CANNOTAUDIT);
        }
        if (state == BillBaseStatusEnum.TEMPORARILYSAVED.getValue()) {
            throw new SaleInvBizException(SaleInvBizException.TEMPSAVED_CANNOTAUDIT);
        }
        if (state == BillBaseStatusEnum.AUDITED.getValue()) {
            throw new SaleInvBizException(SaleInvBizException.AUDITED_CANNOTAUDIT);
        }
        if (state != BillBaseStatusEnum.SUBMITED.getValue()) {
            throw new SaleInvBizException(SaleInvBizException.ONLYSAVEDCANAUDIT);
        }
    }

    protected void checkValid(IObjectValue model) throws SaleInvBizException {
        SaleInvoiceInfo saleInvoiceInfo = (SaleInvoiceInfo)model;
        if (saleInvoiceInfo.getInvoiceType() == null) {
            throw new SaleInvBizException(SaleInvBizException.INVTYPE_NOTSET);
        }
        if (saleInvoiceInfo.getBizType() == null) {
            throw new SaleInvBizException(SaleInvBizException.BIZTYPE_NOTSET);
        }
        if (saleInvoiceInfo.getSaleOrgUnit() == null) {
            throw new SaleInvBizException(SaleInvBizException.SALEORG_NOTSET);
        }
        if (saleInvoiceInfo.getCompanyOrgUnit() == null) {
            throw new SaleInvBizException(SaleInvBizException.FINCOM_NOTSET);
        }
        if (saleInvoiceInfo.getCustomer() == null) {
            throw new SaleInvBizException(SaleInvBizException.CUSTOMER_NOTSET);
        }
        if (saleInvoiceInfo.getPaymentType() == null) {
            throw new SaleInvBizException(SaleInvBizException.PAYMENTTYPE_NOTSET);
        }
        if (saleInvoiceInfo.getSettlementType() == null) {
            throw new SaleInvBizException(SaleInvBizException.SETTLEMENTTYPE_NOTSET);
        }
        if (saleInvoiceInfo.getCurrency() == null) {
            throw new SaleInvBizException(SaleInvBizException.CURRENCY_NOTSET);
        }
        if (saleInvoiceInfo.getExchangeRate() == null) {
            throw new SaleInvBizException(SaleInvBizException.EXCHANGERATE_NOTSET);
        }
        if (saleInvoiceInfo.getEntries() != null) {
            this.checkEntriesValid(saleInvoiceInfo.getEntries());
        } else if (saleInvoiceInfo.getEntries() == null) {
            throw new SaleInvBizException(SaleInvBizException.NOENTRYERROR);
        }
    }

    private void checkEntriesValid(SaleInvoiceEntryCollection entries) throws SaleInvBizException {
        SaleInvoiceEntryInfo saleInvoiceEntryInfo = null;
        int num = entries.size();
        if (num == 0) {
            throw new SaleInvBizException(SaleInvBizException.NOENTRYERROR);
        }
        for (int i = 0; i < num; ++i) {
            saleInvoiceEntryInfo = entries.get(i);
            if (saleInvoiceEntryInfo.getSeq() <= 0) {
                throw new SaleInvBizException(SaleInvBizException.LINENUMBER_NOTSET);
            }
            if (saleInvoiceEntryInfo.getMaterial() == null) {
                throw new SaleInvBizException(SaleInvBizException.MATERIALNUM_NOTSET);
            }
            if (saleInvoiceEntryInfo.getUnit() == null) {
                throw new SaleInvBizException(SaleInvBizException.UNIT_NOTSET);
            }
            if (saleInvoiceEntryInfo.getQty() == null) {
                throw new SaleInvBizException(SaleInvBizException.QUANTITY_NOTSET);
            }
            if (saleInvoiceEntryInfo.getPrice() == null) {
                throw new SaleInvBizException(SaleInvBizException.PRICE_NOTSET);
            }
            if (saleInvoiceEntryInfo.getAmount() == null) {
                throw new SaleInvBizException(SaleInvBizException.AMOUT_NOTSET);
            }
            if (saleInvoiceEntryInfo.getLocalAmount() == null) {
                throw new SaleInvBizException(SaleInvBizException.LOCALAMOUNT_NOTSET);
            }
            if (saleInvoiceEntryInfo.getTaxRate() == null) {
                throw new SaleInvBizException(SaleInvBizException.TAXRATE_NOTSET);
            }
            if (saleInvoiceEntryInfo.getTaxPrice() == null) {
                throw new SaleInvBizException(SaleInvBizException.TAXPRICE_NOTSET);
            }
            if (saleInvoiceEntryInfo.getTaxAmount() != null) continue;
            throw new SaleInvBizException(SaleInvBizException.TOTALTAXPRICE_NOTSET);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleInvoiceInfo saleInvoiceInfo = (SaleInvoiceInfo)model;
        boolean isAddNew = true;
        isAddNew = saleInvoiceInfo.getId() == null || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(saleInvoiceInfo.getId()));
        if (!isAddNew) {
            ObjectUuidPK pk = new ObjectUuidPK(saleInvoiceInfo.getId());
            this.canManualUpdate(ctx, (IObjectPK)pk);
        }
        this.checkValid(model);
        saleInvoiceInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        if (saleInvoiceInfo.getBillType() == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0117c0a812fd463ED552"));
            saleInvoiceInfo.setBillType(billType);
        }
        SaleInvoiceEntryCollection entryInfos = saleInvoiceInfo.getEntries();
        SaleInvoiceEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        }
        if ((saleInvoiceInfo.getBizType().getId().toString().equals("d8e80652-0110-1000-e000-04c5c0a812202407435C") || saleInvoiceInfo.getBizType().getId().toString().equals("d8e80652-0114-1000-e000-04c5c0a812202407435C") || saleInvoiceInfo.getRedBlueType().equals((Object)RedBlueEnum.RED)) && !saleInvoiceInfo.isIsReversed()) {
            saleInvoiceInfo = SaleUtil.getNagtiveAmountInfo(saleInvoiceInfo);
            saleInvoiceInfo.setRedBlueType(RedBlueEnum.RED);
        }
        IObjectPK pk = super._submit(ctx, model);
        if (SCMServerUtils.isAuditAfterSubmitSaleInv((Context)ctx, (String)saleInvoiceInfo.getCompanyOrgUnit().getId().toString())) {
            this._audit(ctx, pk);
        }
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleInvoiceInfo saleInvoiceInfo = (SaleInvoiceInfo)model;
        boolean isAddNew = true;
        isAddNew = saleInvoiceInfo.getId() == null || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(saleInvoiceInfo.getId()));
        if (!isAddNew) {
            ObjectUuidPK pk = new ObjectUuidPK(saleInvoiceInfo.getId());
            SaleInvoiceInfo saleInvoiceInfo1 = this.getSaleInvoiceInfo(ctx, (IObjectPK)pk);
            if (saleInvoiceInfo1.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                throw new SaleInvBizException(SaleInvBizException.SUBMITED_CANNOTTEMPSAVE);
            }
            this.canManualUpdate(ctx, (IObjectPK)pk);
        }
        saleInvoiceInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        if (saleInvoiceInfo.getBillType() == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0117c0a812fd463ED552"));
            saleInvoiceInfo.setBillType(billType);
        }
        SaleInvoiceEntryCollection entryInfos = saleInvoiceInfo.getEntries();
        SaleInvoiceEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        return super._save(ctx, model);
    }

    private void canManualUpdate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleInvoiceInfo saleInvoiceInfo = this.getSaleInvoiceInfo(ctx, pk);
        if (saleInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SaleInvBizException(SaleInvBizException.AUDITED_CANNOTUPDATE);
        }
        if (saleInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new SaleInvBizException(SaleInvBizException.DELETED_CANNOTUPDATE);
        }
        if (saleInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.CLOSED)) {
            throw new SaleInvBizException(SaleInvBizException.CLOSED_CANNOTUPDATE);
        }
        super._canUpdate(ctx, pk);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleInvoiceInfo saleInvoiceInfo = this.getSaleInvoiceInfo(ctx, pk);
        this.canCancel(saleInvoiceInfo);
        if (saleInvoiceInfo.isIsReversed()) {
            this.resetReversedInv(ctx, saleInvoiceInfo);
        }
        saleInvoiceInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
        this.update(ctx, pk, (CoreBaseInfo)saleInvoiceInfo);
    }

    private void resetReversedInv(Context ctx, SaleInvoiceInfo saleInvoiceInfo) throws BOSException, EASBizException {
        if (saleInvoiceInfo.getSourceBillId() != null) {
            ObjectStringPK srcpk = new ObjectStringPK(saleInvoiceInfo.getSourceBillId());
            SaleInvoiceInfo srcSaleInvInfo = this.getSaleInvoiceInfo(ctx, (IObjectPK)new ObjectStringPK(saleInvoiceInfo.getSourceBillId()));
            srcSaleInvInfo.setReverseInvNumber(null);
            srcSaleInvInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
            srcSaleInvInfo.setIsReversed(false);
            this.update(ctx, (IObjectPK)srcpk, (CoreBaseInfo)srcSaleInvInfo);
        }
    }

    private void canCancel(SaleInvoiceInfo saleInvoiceInfo) throws BOSException, EASBizException {
        InitializeInvoiceTypeEnum initialType = saleInvoiceInfo.getInitializeInvoiceType();
        if (!initialType.equals((Object)InitializeInvoiceTypeEnum.GENERAL)) {
            throw new SaleInvBizException(SaleInvBizException.INITINVCANNOTCANCEL);
        }
        if (saleInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SaleInvBizException(SaleInvBizException.ADUITED_CANNOTCANCEL);
        }
        if (saleInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.CLOSED)) {
            throw new SaleInvBizException(SaleInvBizException.CLOSED_CANNOTCANCEL);
        }
        if (saleInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new SaleInvBizException(SaleInvBizException.CANCELED_CANNOTCANCEL);
        }
        if (saleInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new SaleInvBizException(SaleInvBizException.TEMPSAVED_CANNOTCANCEL);
        }
        if (!saleInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new SaleInvBizException(SaleInvBizException.CANNOTCANCEL);
        }
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        try {
            SaleInvoiceInfo saleInvoiceInfo = this.getSaleInvoiceInfo(ctx, pk);
            BillBaseStatusEnum state = saleInvoiceInfo.getBaseStatus();
            if (state.equals((Object)BillBaseStatusEnum.AUDITED)) {
                throw new SaleInvBizException(SaleInvBizException.AUDITED_CANNOTDELETE);
            }
            if (state.equals((Object)BillBaseStatusEnum.DELETED)) {
                throw new SaleInvBizException(SaleInvBizException.CANCELED_CANNOTDELETE);
            }
            if (state.equals((Object)BillBaseStatusEnum.CLOSED)) {
                throw new SaleInvBizException(SaleInvBizException.CLOSED_CANNOTDELETE);
            }
            if (!state.equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && !state.equals((Object)BillBaseStatusEnum.SUBMITED)) {
                throw new SaleInvBizException(SaleInvBizException.CANNOTDELETE);
            }
        }
        catch (BOSException bosex) {
            throw new CanNotDeleteException(bosex.getMessage(), (Throwable)bosex);
        }
        catch (EASBizException easex) {
            throw new CanNotDeleteException(easex.getMessage(), (Throwable)easex);
        }
        super._canDelete(ctx, pk, cn);
    }

    @Override
    protected void _audit(Context ctx, String[] ids) throws BOSException, EASBizException {
        int num = ids.length;
        for (int i = 0; i < num; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(ids[i]);
            this._audit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _cancel(Context ctx, String[] ids) throws BOSException, EASBizException {
        int num = ids.length;
        for (int i = 0; i < num; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(ids[i]);
            this._cancel(ctx, (IObjectPK)pk);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this._canDelete(ctx, pk, null);
            SaleInvoiceInfo saleInvoiceInfo = this.getSaleInvoiceInfo(ctx, pk);
            if (saleInvoiceInfo.isIsReversed()) {
                this.deleteReverseInv(ctx, saleInvoiceInfo);
            } else {
                super._delete(ctx, pk);
            }
        }
        catch (BOSException bex) {
            if (bex instanceof CanNotDeleteException && bex.getCause() instanceof SaleInvBizException) {
                throw (SaleInvBizException)((Object)bex.getCause());
            }
            throw bex;
        }
    }

    private void deleteReverseInv(Context ctx, SaleInvoiceInfo saleInvoiceInfo) throws BOSException, EASBizException {
        this.resetReversedInv(ctx, saleInvoiceInfo);
        super._delete(ctx, (IObjectPK)new ObjectUuidPK(saleInvoiceInfo.getId()));
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleInvoiceInfo saleInvoiceInfo = this.getSaleInvoiceInfo(ctx, pk);
        this.canAudit(saleInvoiceInfo);
        saleInvoiceInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        this.update(ctx, pk, (CoreBaseInfo)saleInvoiceInfo);
    }

    @Override
    protected void _endInitialize(Context ctx) throws BOSException, SaleInvBizException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("initializeInvoiceType", (Object)InitializeInvoiceTypeEnum.BUSINESSINVOICE, CompareType.EQUALS));
        viewInfo.getFilter().setMaskString("#0");
        SaleInvoiceCollection saleInvoiceCollection = this.getSaleInvoiceCollection(ctx, viewInfo);
        SaleInvoiceInfo saleInvoiceInfo = null;
        int num = saleInvoiceCollection.size();
        for (int i = 0; i < num; ++i) {
            saleInvoiceInfo = saleInvoiceCollection.get(i);
            saleInvoiceInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
            saleInvoiceInfo.setFiVouchered(true);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(saleInvoiceInfo.getId()), (CoreBaseInfo)saleInvoiceInfo);
        }
    }

    @Override
    protected void _unInitialize(Context ctx) throws BOSException, SaleInvBizException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("initializeInvoiceType", (Object)InitializeInvoiceTypeEnum.BUSINESSINVOICE, CompareType.EQUALS));
        viewInfo.getFilter().setMaskString("#0");
        SaleInvoiceCollection saleInvoiceCollection = this.getSaleInvoiceCollection(ctx, viewInfo);
        SaleInvoiceInfo saleInvoiceInfo = null;
        int num = saleInvoiceCollection.size();
        for (int i = 0; i < num; ++i) {
            saleInvoiceInfo = saleInvoiceCollection.get(i);
            saleInvoiceInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            saleInvoiceInfo.setFiVouchered(false);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(saleInvoiceInfo.getId()), (CoreBaseInfo)saleInvoiceInfo);
        }
    }

    protected boolean _checkIsVouchered(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        SaleInvoiceInfo saleInvoiceInfo = (SaleInvoiceInfo)model;
        if (isOk) {
            if (saleInvoiceInfo.isFiVouchered()) {
                throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDOK, new Object[]{saleInvoiceInfo.getNumber(), ""});
            }
        } else if (!saleInvoiceInfo.isFiVouchered()) {
            throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDNOTOK, new Object[]{saleInvoiceInfo.getNumber(), ""});
        }
        return true;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        SaleInvoiceInfo info = this.getSaleInvoiceInfo(ctx, sourceBillPk);
        info.setVoucher(null);
        info.setVoucherNumber(null);
        this.update(ctx, sourceBillPk, (CoreBaseInfo)info);
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    @Override
    protected IObjectPK[] _createReverseInv(Context ctx, IObjectPK[] sourceInvPKs) throws BOSException, SaleInvBizException, EASBizException {
        SaleInvoiceInfo srcInvInfo = null;
        SaleInvoiceInfo destInvInfo = null;
        IObjectPK[] newPKs = new IObjectPK[sourceInvPKs.length];
        for (int i = 0; i < sourceInvPKs.length; ++i) {
            srcInvInfo = this.getSaleInvoiceInfo(ctx, sourceInvPKs[i]);
            this.checkCanReverse(ctx, srcInvInfo);
            destInvInfo = (SaleInvoiceInfo)srcInvInfo.clone();
            String oldnumber = srcInvInfo.getNumber();
            destInvInfo.setId(null);
            destInvInfo.setNumber(oldnumber + "-R");
            if (this.isSameNumber(ctx, sourceInvPKs[i], (IObjectValue)destInvInfo)) {
                destInvInfo.setNumber(oldnumber + "-R-1");
            }
            destInvInfo = SaleUtil.getReverseAmountInfo(destInvInfo);
            destInvInfo.setInvoiceDate(new Timestamp(System.currentTimeMillis()));
            destInvInfo.setIsReversed(true);
            destInvInfo.setSourceBillId(srcInvInfo.getId().toString());
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0117c0a812fd463ED552"));
            destInvInfo.setSourceBillType(billTypeInfo);
            destInvInfo.setAuditor(null);
            destInvInfo.setAuditTime(null);
            destInvInfo.setLastUpdateUser(null);
            destInvInfo.setLastUpdateTime(null);
            destInvInfo.setCreator(null);
            destInvInfo.setCreateTime(null);
            SaleInvoiceEntryCollection collection = destInvInfo.getEntries();
            SaleInvoiceEntryInfo entryInfo = null;
            int num = collection.size();
            for (int j = 0; j < num; ++j) {
                entryInfo = collection.get(j);
                entryInfo.setId(null);
                entryInfo.setParent(null);
            }
            SaleInvReceivePlanCollection recePlanCollection = destInvInfo.getReceivePlans();
            SaleInvReceivePlanInfo receivePlanInfo = null;
            int num2 = recePlanCollection.size();
            for (int j = 0; j < num2; ++j) {
                receivePlanInfo = recePlanCollection.get(j);
                receivePlanInfo.setId(null);
                receivePlanInfo.setParent(null);
            }
            ISaleInvoice isaleInvoice = SaleInvoiceFactory.getLocalInstance(ctx);
            newPKs[i] = isaleInvoice.submit((CoreBaseInfo)destInvInfo);
            destInvInfo.setId(BOSUuid.read((String)newPKs[i].toString()));
            srcInvInfo.setReverseInvNumber(destInvInfo.getNumber());
            srcInvInfo.setIsReversed(true);
            srcInvInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
            this._update(ctx, sourceInvPKs[i], (IObjectValue)srcInvInfo);
            String strid = newPKs[i].toString();
            String bosType = strid.substring(strid.length() - 8);
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcObjectID(sourceInvPKs[i].toString());
            info.setDestEntityID(bosType);
            info.setSrcEntityID(bosType);
            info.setDestObjectID(strid);
            info.setOperatorID("unknown");
            info.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
        }
        return newPKs;
    }

    private void checkCanReverse(Context ctx, SaleInvoiceInfo srcInvInfo) throws SaleInvBizException, BOSException {
    }

    private boolean isRelateCreate(SaleInvoiceInfo saleInvoiceInfo) {
        return saleInvoiceInfo.getSourceBillType() != null;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleInvoiceInfo saleInvoiceInfo = (SaleInvoiceInfo)model;
        if (saleInvoiceInfo.getCompanyOrgUnit() != null) {
            ICompanyOrgUnit icompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo info = icompanyOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleInvoiceInfo.getCompanyOrgUnit().getId()));
            return info;
        }
        return null;
    }

    @Override
    protected int[] _getAlertPlan(Context ctx, BOSUuid saleInvID, int perAlertDays) throws BOSException, SaleInvBizException, EASBizException {
        int[] palnSeqs = null;
        return palnSeqs;
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SaleInvoiceInfo saleInvoiceInfo = (SaleInvoiceInfo)model;
        this.canCancel(saleInvoiceInfo);
        SaleInvoiceInfo storedInvInfo = this.getSaleInvoiceInfo(ctx, pk);
        if (storedInvInfo.isIsReversed()) {
            this.resetReversedInv(ctx, storedInvInfo);
        }
        saleInvoiceInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
        this.update(ctx, pk, (CoreBaseInfo)saleInvoiceInfo);
    }

    @Override
    protected void _createReceiveBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _createOtherBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("companyOrgUnit.*"));
        SaleInvoiceInfo info = this.getSaleInvoiceInfo(ctx, pk, selectors);
        return info.getCompanyOrgUnit();
    }

    @Override
    protected IObjectValue _initRelateCreateInvoiceInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleInvoiceInfo saleInvInfo = (SaleInvoiceInfo)model;
        saleInvInfo.setInvoiceType(InvoiceTypeEnum.VALUEADDEDTAX);
        saleInvInfo.setBizDate(new Date());
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0117c0a812fd463ED552"));
        saleInvInfo.setBillType(billTypeInfo);
        Timestamp timestamp = new Timestamp(new Date().getTime());
        saleInvInfo.setInvoiceDate(timestamp);
        CompanyOrgUnitInfo companyOrgInfo = null;
        CurrencyInfo baseCurrInfo = null;
        if (saleInvInfo.getCompanyOrgUnit() != null) {
            ICompanyOrgUnit icompanyOrg = CompanyOrgUnitFactory.getRemoteInstance();
            companyOrgInfo = icompanyOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleInvInfo.getCompanyOrgUnit().getId()));
            baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgInfo.getBaseCurrency().getId()));
            saleInvInfo.setCompanyOrgUnit(companyOrgInfo);
        } else {
            companyOrgInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            saleInvInfo.setCompanyOrgUnit(companyOrgInfo);
            baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgInfo.getBaseCurrency().getId()));
        }
        ExchangeRateInfo exchangeRateinfo = null;
        if (saleInvInfo.getCurrency() == null) {
            saleInvInfo.setCurrency(baseCurrInfo);
            exchangeRateinfo = this.getDefaultExchangeRateInfo();
        } else {
            exchangeRateinfo = this.getExchangeRate(ctx, companyOrgInfo, saleInvInfo.getCurrency(), baseCurrInfo);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            saleInvInfo.setCurrency(icurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(saleInvInfo.getCurrency().getId()), selectors));
        }
        if (saleInvInfo.getCurrency() == null) {
            saleInvInfo.setExchangeRate(new BigDecimal("1.00"));
        } else if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
            saleInvInfo.setExchangeRate(exchangeRateinfo.getConvertRate());
        }
        this.calculateAmountForRelateCreate(ctx, saleInvInfo, exchangeRateinfo, baseCurrInfo.getPrecision(), saleInvInfo.getCurrency().getPrecision());
        this.initOtherRelateDateForEntries(saleInvInfo);
        saleInvInfo.getReceivePlans().clear();
        saleInvInfo.getReceivePlans().add(this.createDefaultPlanForRelateCreate(saleInvInfo.getTotalTaxAmount(), exchangeRateinfo));
        if (saleInvInfo.getSettlementType() == null) {
            this.setDefaultSettleType(saleInvInfo, ctx);
        }
        if (saleInvInfo.getPaymentType() == null) {
            this.setDefaultPaymentType(saleInvInfo, ctx);
        }
        this.calculateBaseAndAssistQtyForRelateCreate(ctx, saleInvInfo);
        SaleInvoiceUtil.storeDefaultValues(saleInvInfo, exchangeRateinfo);
        return saleInvInfo;
    }

    private void initOtherRelateDateForEntries(SaleInvoiceInfo newData) {
        SaleInvoiceEntryCollection collection = newData.getEntries();
        int num = collection.size();
        for (int i = 0; i < num; ++i) {
            SaleInvoiceEntryInfo entryInfo = collection.get(i);
            if (entryInfo.getWriteOffStatus() != null) continue;
            entryInfo.setWriteOffStatus(CheckOffStatusEnum.UNCHECKOFF);
        }
    }

    private void calculateBaseAndAssistQtyForRelateCreate(Context ctx, SaleInvoiceInfo newData) throws BOSException, EASBizException {
        SaleInvoiceEntryCollection collection = newData.getEntries();
        SaleInvoiceEntryInfo entryInfo = null;
        int num = collection.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = collection.get(i);
            BigDecimal qty = entryInfo.getQty();
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            if (qty != null && unitInfo != null && assistUnitInfo != null) {
                entryInfo.setAssistQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)assistUnitInfo, (BigDecimal)qty));
            }
            if (qty == null || unitInfo == null || baseunitInfo == null) continue;
            entryInfo.setBaseQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)baseunitInfo, (BigDecimal)qty));
        }
    }

    private ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo ficompanyOrgInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr) throws BOSException, EASBizException {
        ExchangeRateInfo exchangeRateinfo = null;
        if (sourceCurr != null && destCurr != null) {
            if (sourceCurr.getId().equals((Object)destCurr.getId())) {
                exchangeRateinfo = this.getDefaultExchangeRateInfo();
            } else {
                ObjectUuidPK excTablepk = null;
                ObjectUuidPK sourceCurrPK = null;
                ObjectUuidPK destCurrPK = null;
                ExchangeTableInfo exchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
                if (exchangeTableInfo == null) {
                    throw new PurInvBizException(PurInvBizException.EXCHANGETABLENULL);
                }
                excTablepk = new ObjectUuidPK(ficompanyOrgInfo.getBaseExchangeTable().getId());
                sourceCurrPK = new ObjectUuidPK(sourceCurr.getId());
                destCurrPK = new ObjectUuidPK(destCurr.getId());
                IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("exchangeAux.*"));
                ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
                exchangeRateinfo = tempexrateinfo != null ? iexchangRate.getExchangeRateInfo((IObjectPK)new ObjectUuidPK(tempexrateinfo.getId()), sic) : this.getDefaultExchangeRateInfo();
            }
        }
        return exchangeRateinfo;
    }

    private ExchangeRateInfo getDefaultExchangeRateInfo() {
        ExchangeRateInfo innerexchangeRateinfo = new ExchangeRateInfo();
        innerexchangeRateinfo.setConvertRate(new BigDecimal("1.00"));
        ExchangeAuxInfo exAux = new ExchangeAuxInfo();
        exAux.setPrecision(2);
        exAux.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        innerexchangeRateinfo.setExchangeAux(exAux);
        return innerexchangeRateinfo;
    }

    private void calculateAmountForRelateCreate(Context ctx, SaleInvoiceInfo newData, ExchangeRateInfo exchangeRateinfo, int baseCurrPrecision, int sourceCurrPrecision) throws BOSException, EASBizException {
        SaleInvoiceEntryCollection collection = newData.getEntries();
        SaleInvoiceEntryInfo entryInfo = null;
        BigDecimal totalAmount = new BigDecimal("0.00");
        BigDecimal totalTax = new BigDecimal("0.00");
        BigDecimal totalTaxAmount = new BigDecimal("0.00");
        IMaterial imaterial = null;
        int num = collection.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = collection.get(i);
            entryInfo.setSeq(i + 1);
            BigDecimal price = entryInfo.getPrice();
            BigDecimal taxPrice = entryInfo.getTaxPrice();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal discount = entryInfo.getDiscount();
            DiscountModeEnum discountType = entryInfo.getDiscountType();
            BigDecimal taxRate = entryInfo.getTaxRate();
            MaterialInfo materialInfo = entryInfo.getMaterial();
            if (materialInfo.getPricePrecision() <= 0) {
                try {
                    if (imaterial == null) {
                        imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                    }
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add(new SelectorItemInfo("id"));
                    selectors.add(new SelectorItemInfo("name"));
                    selectors.add(new SelectorItemInfo("number"));
                    selectors.add(new SelectorItemInfo("pricePrecision"));
                    materialInfo = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()), selectors);
                    entryInfo.setMaterial(materialInfo);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            int pricePrecision = materialInfo.getPricePrecision();
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MeasureUnitInfo baseUnitInfo = entryInfo.getBaseUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            if (unitInfo != null && materialInfo != null && baseUnitInfo != null) {
                entryInfo.setBaseQty(SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)baseUnitInfo, (BigDecimal)qty));
            }
            if (unitInfo != null && materialInfo != null && assistUnitInfo != null) {
                entryInfo.setAssistQty(SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)assistUnitInfo, (BigDecimal)qty));
            }
            if (taxPrice != null && price == null) {
                price = SaleInvoiceUtil.caculatePrice(taxRate, taxPrice).setScale(pricePrecision, 4);
                entryInfo.setPrice(price);
            } else if (taxPrice == null && price != null) {
                taxPrice = SaleInvoiceUtil.calculateTaxPrice(price, taxRate).setScale(pricePrecision, 4);
                entryInfo.setTaxPrice(taxPrice);
            }
            BigDecimal amount = SaleInvoiceUtil.calculateAmount(price, qty, discount, discountType, taxRate, pricePrecision);
            amount = amount.setScale(sourceCurrPrecision, 4);
            entryInfo.setAmount(amount);
            totalAmount = totalAmount.add(amount);
            entryInfo.setTaxPrice(taxPrice);
            entryInfo.setActualPrice(SaleInvoiceUtil.calculateDealPrice(taxPrice, discount, discountType).setScale(pricePrecision, 4));
            entryInfo.setLocalAmount(SaleInvoiceUtil.calculateLocalAmount(amount, exchangeRateinfo).setScale(baseCurrPrecision, 4));
            if (taxRate == null) {
                taxRate = new BigDecimal("0.00");
            }
            BigDecimal entryTaxAmount = SaleInvoiceUtil.calculateTaxAmount(amount, taxRate).setScale(sourceCurrPrecision, 4);
            entryInfo.setTaxAmount(entryTaxAmount);
            totalTaxAmount = totalTaxAmount.add(entryTaxAmount);
            entryInfo.setLocalTaxAmount(SaleInvoiceUtil.calculateLocalAmount(entryTaxAmount, exchangeRateinfo).setScale(baseCurrPrecision, 4));
            BigDecimal littletaxRate = SaleInvoiceUtil.getLittleRate(taxRate);
            BigDecimal tax = SaleInvoiceUtil.calculateTax(amount, littletaxRate).setScale(sourceCurrPrecision, 4);
            entryInfo.setTax(tax);
            totalTax = totalTax.add(tax);
            entryInfo.setLocalTax(SaleInvoiceUtil.calculateLocalAmount(tax, exchangeRateinfo).setScale(baseCurrPrecision, 4));
            BigDecimal discountAmount = SaleInvoiceUtil.caculateDiscountAmount(discountType, discount, qty, taxPrice);
            discountAmount = discountAmount.setScale(sourceCurrPrecision, 4);
            entryInfo.setDiscountAmount(discountAmount);
        }
        newData.setTotalAmount(totalAmount);
        newData.setTotalTax(totalTax);
        newData.setTotalTaxAmount(totalTaxAmount);
    }

    private void setDefaultPaymentType(SaleInvoiceInfo newData, Context ctx) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5", CompareType.EQUALS));
        filter.setMaskString("#0");
        viewInfo.setFilter(filter);
        IPaymentType ipaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        PaymentTypeCollection collection = ipaymentType.getPaymentTypeCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            newData.setPaymentType(collection.get(0));
        }
    }

    private void setDefaultSettleType(SaleInvoiceInfo newData, Context ctx) throws BOSException, EASBizException {
        ISettlementType isettlementType = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.setMaskString("#0");
        viewInfo.setFilter(filter);
        SettlementTypeCollection settlementCollection = isettlementType.getSettlementTypeCollection(viewInfo);
        if (settlementCollection != null && settlementCollection.size() > 0) {
            newData.setSettlementType(settlementCollection.get(0));
        }
    }

    public SaleInvReceivePlanInfo createDefaultPlanForRelateCreate(BigDecimal totalTaxAmount, ExchangeRateInfo exchangeRateinfo) {
        SaleInvReceivePlanInfo saleInvPlanInfo = new SaleInvReceivePlanInfo();
        saleInvPlanInfo.setReceiveDate(new Date());
        saleInvPlanInfo.setReceiveAmount(totalTaxAmount);
        saleInvPlanInfo.setLocalReceiveAmount(SaleInvoiceUtil.calculateLocalAmount(totalTaxAmount, exchangeRateinfo));
        return saleInvPlanInfo;
    }

    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((SaleInvoiceInfo)model).getCompanyOrgUnit()) != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }
}

