/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICashDiscount;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.IReasonCode;
import com.kingdee.eas.basedata.scm.common.InitializeInvoiceTypeEnum;
import com.kingdee.eas.basedata.scm.common.InvoiceTypeEnum;
import com.kingdee.eas.basedata.scm.common.ReasonCodeFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ISaleGroup;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckOffStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.RedBlueEnum;
import com.kingdee.eas.scm.common.ReversingStateEnum;
import com.kingdee.eas.scm.common.SettlementStateEnum;
import com.kingdee.eas.scm.sd.sale.ISaleInvoice;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class SaleInvoiceDataImport
extends AbstractDataTransmission {
    String[] DECIMAL_FIELDS = new String[]{"FExchangeRate", "FTotalAmount", "FTotalTax", "FTotalTaxAmount", "FLocalTotalAmount", "FLocalTotalTaxAmount"};
    String[] DECIMAL_OBJS = new String[]{"exchangeRate", "totalAmount", "totalTax", "totalTaxAmount", "localTotalAmount", "localTotalTaxAmount"};
    String[] ENTRY_DECIMAL_FIELDS = new String[]{"FAssCoefficient", "FAssociateQty", "FQty", "FAssistQty", "FDiscount", "FAmount", "FPrice", "FActualPrice", "FTaxPrice", "FTaxRate", "FTax", "FTaxAmount", "FWrittenOffQty", "FUnwriteOffQty", "FWrittenOffAmount", "FUnwriteOffAmount", "FLocalAmount", "FLocalWrittenOffAmount", "FLocalUnwriteOffAmount", "FLocalTax", "FDiscountRate", "FDiscountAmount", "FLocalTaxAmount", "FBaseQty"};
    String[] ENTRY_DECIMAL_OBJS = new String[]{"assCoefficient", "associateQty", "qty", "assistQty", "discount", "amount", "price", "actualPrice", "taxPrice", "taxRate", "tax", "taxAmount", "writtenOffQty", "FUnwriteOffQty", "writtenOffAmount", "unwriteOffAmount", "localAmount", "localWrittenOffAmount", "localUnwriteOffAmount", "localTax", "discountRate", "discountAmount", "localTaxAmount", "baseQty"};
    String[] DATE_FIELDS = new String[]{"FCreateTime", "FBizDate", "FInvoiceDate", "FAccountDate", "FModificationTime"};
    String[] DATE_OBJS = new String[]{"createTime", "bizDate", "invoiceDate", "accountDate", "modificationTime"};
    String[] ENTRY_DATE_FIELDS = new String[]{"FDeliveryDate"};
    String[] ENTRY_DATE_OBJS = new String[]{"deliveryDate"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsReversed", "FFiVouchered"};
    String[] BOOLEAN_OBJS = new String[]{"isReversed", "FiVouchered"};
    String[] ENTRY_BOOLEAN_FIELDS = new String[]{"FIsPresent"};
    String[] ENTRY_BOOLEAN_OBJS = new String[]{"isPresent"};
    String[] STRING_FIELDS = new String[]{"FReverseInvNumber", "FSummary"};
    String[] STRING_OBJS = new String[]{"reverseInvNumber", "summary"};
    String[] ENTRY_STRING_FIELDS = new String[]{"FRemark"};
    String[] ENTRY_STRING_OBJS = new String[]{"remark"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SaleInvoiceFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase isaleInvoice = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !isaleInvoice.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                isaleInvoice.addnew(coreBaseInfo);
            } else {
                isaleInvoice.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        Object value2;
        SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
        Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
        String str = null;
        if (numberdata != null) {
            str = numberdata.toString();
            if (str != null && str.trim().length() > 0) {
                saleInvoiceInfo.setNumber(str);
                try {
                    ISaleInvoice isaleInvoice = SaleInvoiceFactory.getLocalInstance(ctx);
                    SaleInvoiceCollection collection = isaleInvoice.getSaleInvoiceCollection("where number ='" + str + "'");
                    if (collection != null && collection.size() > 0) {
                        saleInvoiceInfo = collection.get(0);
                    }
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                }
            }
        } else {
            throw new TaskExternalException("number  not found!!!!");
        }
        for (int i2 = 0; i2 < this.DECIMAL_FIELDS.length; ++i2) {
            try {
                Object o2 = ((DataToken)hsData.get((Object)this.DECIMAL_FIELDS[i2])).data;
                if (o2 == null || o2.toString().trim().length() <= 0 || (value2 = new BigDecimal(o2.toString())) == null) continue;
                saleInvoiceInfo.setBigDecimal(this.DECIMAL_OBJS[i2], (BigDecimal)value2);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.DECIMAL_OBJS[i2] + " format error, it must be a number!!!");
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS[i])).data;
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                Logger.error((Throwable)pex);
                throw new TaskExternalException(this.DATE_FIELDS[i] + " format error, it must be a date String, xxxx-xx-xx!!!current date is " + o.toString());
            }
            if (o == null || (value = (Date)o) == null) continue;
            saleInvoiceInfo.setDate(this.DATE_OBJS[i], (Date)value);
        }
        for (i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            saleInvoiceInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            saleInvoiceInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FInitializeInvoiceType")).data;
        value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            saleInvoiceInfo.setInitializeInvoiceType(this.getInitInvTypeValue((String)value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FInvoiceType")).data) != null) {
            value2 = data.toString();
            saleInvoiceInfo.setInvoiceType(this.getInvTypeValue((String)value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FBaseStatus")).data) != null) {
            value2 = data.toString();
            saleInvoiceInfo.setBaseStatus(this.getInvStatusValue((String)value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FRedBlueType")).data) != null) {
            value2 = data.toString();
            saleInvoiceInfo.setRedBlueType(this.getRedBlueValue((String)value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FReversingStatus")).data) != null) {
            value2 = data.toString();
            saleInvoiceInfo.setReversingStatus(this.getReversingStatusValue((String)value2));
        }
        try {
            ISaleGroup isaleGroup;
            IReasonCode iReasonCode;
            ICustomer icustomer;
            ICompanyOrgUnit icompanyOrg;
            SettlementTypeInfo info;
            SettlementTypeCollection collection;
            FilterInfo filter;
            EntityViewInfo viewInfo;
            ICurrency icurreny;
            BizTypeInfo info2;
            IBizType ibizType;
            BizTypeCollection collection2;
            CtrlUnitInfo cuinfo;
            ICtrlUnit ictrlUnit;
            CtrlUnitCollection cuCollection;
            IUser iuser = UserFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = null;
            data = ((DataToken)hsData.get((Object)"FCreatorID")).data;
            if (data != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                saleInvoiceInfo.setCreator(userInfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FControlUnitID")).data) != null && (str = ((DataToken)hsData.get((Object)"FControlUnitID")).data.toString()) != null && str.length() > 0 && (cuCollection = (ictrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx)).getCtrlUnitCollection("where number='" + str + "'")) != null && cuCollection.size() > 0 && (cuinfo = cuCollection.get(0)) != null) {
                saleInvoiceInfo.setCU(cuinfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FBizTypeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (ibizType = BizTypeFactory.getLocalInstance((Context)ctx)).getBizTypeCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                saleInvoiceInfo.setBizType(info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FCurrencyID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (icurreny = CurrencyFactory.getLocalInstance((Context)ctx)).getCurrencyCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                saleInvoiceInfo.setCurrency((CurrencyInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FSettlementTypeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                ISettlementType isettlement = SettlementTypeFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = isettlement.getSettlementTypeCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleInvoiceInfo.setSettlementType(info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FCompanyOrgUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (icompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                saleInvoiceInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FSaleOrgUnitID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                ISaleOrgUnit isaleOrg = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = isaleOrg.getSaleOrgUnitCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleInvoiceInfo.setSaleOrgUnit((SaleOrgUnitInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FCustomerID")).data) != null && (str = data.toString()) != null && str.length() > 0 && (collection2 = (icustomer = CustomerFactory.getLocalInstance((Context)ctx)).getCustomerCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                saleInvoiceInfo.setCustomer((CustomerInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FPaymentTypeID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IPaymentType ipaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = ipaymentType.getPaymentTypeCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleInvoiceInfo.setPaymentType((PaymentTypeInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FInvoiceReasonID")).data) != null && (str = data.toString()) != null && str.length() > 0 && (collection2 = (iReasonCode = ReasonCodeFactory.getLocalInstance((Context)ctx)).getReasonCodeCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                saleInvoiceInfo.setInvoiceReason((ReasonCodeInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FSaleGroupID")).data) != null && (str = data.toString()) != null && str.length() > 0 && (collection2 = (isaleGroup = SaleGroupFactory.getLocalInstance((Context)ctx)).getSaleGroupCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                saleInvoiceInfo.setSaleGroup((SaleGroupInfo)info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FSalePersonID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IPerson isalePerson = PersonFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = isalePerson.getPersonCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleInvoiceInfo.setSalePerson((PersonInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FVoucherID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IVoucher ivoucher = VoucherFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = ivoucher.getVoucherCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleInvoiceInfo.setVoucher((VoucherInfo)info);
                    saleInvoiceInfo.setVoucherNumber(info.getNumber());
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FAdminOrgUnitID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IAdminOrgUnit iadminorg = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = iadminorg.getAdminOrgUnitCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleInvoiceInfo.setAdminOrgUnit((AdminOrgUnitInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FCashDiscountID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                ICashDiscount icashDis = CashDiscountFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = icashDis.getCashDiscountCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    saleInvoiceInfo.setCashDiscount((CashDiscountInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FModifierID")).data) != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                saleInvoiceInfo.setModifier(userInfo);
            }
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
        }
        SaleInvoiceEntryInfo entryInfo = null;
        boolean isUpdateEntry = false;
        data = ((DataToken)hsData.get((Object)"FSeq")).data;
        if (data != null && data.toString().trim().length() > 0) {
            int seq = Integer.parseInt(data.toString());
            SaleInvoiceEntryCollection entryCollection = saleInvoiceInfo.getEntries();
            int num = entryCollection.size();
            for (int i3 = 0; i3 < num; ++i3) {
                SaleInvoiceEntryInfo tempentryInfo = entryCollection.get(i3);
                if (tempentryInfo.getSeq() != seq) continue;
                entryInfo = tempentryInfo;
                isUpdateEntry = true;
            }
            if (!isUpdateEntry) {
                entryInfo = new SaleInvoiceEntryInfo();
                entryInfo.setParent(saleInvoiceInfo);
                entryInfo.setSeq(seq);
                entryCollection.add(entryInfo);
            }
        } else {
            SaleInvoiceEntryCollection entryCollection = saleInvoiceInfo.getEntries();
            int seq = entryCollection.size() + 1;
            entryInfo = new SaleInvoiceEntryInfo();
            entryInfo.setParent(saleInvoiceInfo);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        }
        this.createEntry(entryInfo, hsData, ctx);
        return saleInvoiceInfo;
    }

    private void createEntry(SaleInvoiceEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        Object value2;
        for (int i2 = 0; i2 < this.ENTRY_DECIMAL_FIELDS.length; ++i2) {
            try {
                Object o2 = ((DataToken)hsData.get((Object)this.ENTRY_DECIMAL_FIELDS[i2])).data;
                if (o2 == null || o2.toString().trim().length() <= 0 || (value2 = new BigDecimal(o2.toString())) == null) continue;
                entryInfo.setBigDecimal(this.ENTRY_DECIMAL_OBJS[i2], (BigDecimal)value2);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.ENTRY_DECIMAL_OBJS[i2] + " format error, it must be a number!!!");
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (i = 0; i < this.ENTRY_DATE_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.ENTRY_DATE_FIELDS[i])).data;
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                Logger.error((Throwable)pex);
                throw new TaskExternalException(this.ENTRY_DATE_FIELDS[i] + " format error, it must be a date String, xxxx-xx-xx!!!current date is " + o.toString());
            }
            value = (Date)o;
            if (value == null) continue;
            entryInfo.setDate(this.ENTRY_DATE_OBJS[i], (Date)value);
        }
        for (i = 0; i < this.ENTRY_BOOLEAN_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.ENTRY_BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            entryInfo.setBoolean(this.ENTRY_BOOLEAN_OBJS[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.ENTRY_STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.ENTRY_STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            entryInfo.setString(this.ENTRY_STRING_OBJS[i], (String)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FWriteOffStatus")).data;
        value2 = null;
        if (data != null) {
            value2 = data.toString();
            entryInfo.setWriteOffStatus(this.getCheckoffStatusValue((String)value2));
        }
        data = ((DataToken)hsData.get((Object)"FDiscountCondition")).data;
        value2 = null;
        if (data != null) {
            value2 = data.toString();
            entryInfo.setDiscountCondition(this.getDiscountCondition((String)value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FDiscountType")).data) != null) {
            value2 = data.toString();
            entryInfo.setDiscountType(this.getDiscountType((String)value2));
        }
        try {
            IReasonCode iReasonCode;
            IAsstAttrValue iasstAttrValue;
            MeasureUnitInfo info;
            IMeasureUnit iunit;
            MeasureUnitCollection collection;
            String str = null;
            data = ((DataToken)hsData.get((Object)"FMaterialID")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                MaterialInfo info2;
                IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                MaterialCollection collection2 = imaterial.getMaterialCollection(viewInfo);
                if (collection2 != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                    entryInfo.setMaterial(info2);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setUnit(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FBaseUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setBaseUnit(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FAssistUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setAssistUnit(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FAssistPropertyID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iasstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx)).getAsstAttrValueCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setAssistProperty((AsstAttrValueInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FReasonCodeID_E")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iReasonCode = ReasonCodeFactory.getLocalInstance((Context)ctx)).getReasonCodeCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setReasonCode((ReasonCodeInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FSaleOrderID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                entryInfo.setSaleOrder(str);
            }
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
        }
    }

    private UserInfo getUserFromNumber(IUser iuser, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    private boolean getBooleanValue(String sourceValue) {
        return !(sourceValue = sourceValue.trim()).equalsIgnoreCase("N") && !sourceValue.equalsIgnoreCase("NO") && !sourceValue.equalsIgnoreCase("0");
    }

    private InitializeInvoiceTypeEnum getInitInvTypeValue(String value) {
        InitializeInvoiceTypeEnum retval = InitializeInvoiceTypeEnum.GENERAL;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = InitializeInvoiceTypeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                InitializeInvoiceTypeEnum enums = (InitializeInvoiceTypeEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private InvoiceTypeEnum getInvTypeValue(String value) {
        InvoiceTypeEnum retval = InvoiceTypeEnum.GENERAL;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = InvoiceTypeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                InvoiceTypeEnum enums = (InvoiceTypeEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private BillBaseStatusEnum getInvStatusValue(String value) {
        BillBaseStatusEnum retval = BillBaseStatusEnum.TEMPORARILYSAVED;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = BillBaseStatusEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                BillBaseStatusEnum enums = (BillBaseStatusEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private CheckOffStatusEnum getCheckoffStatusValue(String value) {
        CheckOffStatusEnum retval = CheckOffStatusEnum.UNCHECKOFF;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = CheckOffStatusEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                CheckOffStatusEnum enums = (CheckOffStatusEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private SettlementStateEnum getSettleStatusValue(String value) {
        SettlementStateEnum retval = SettlementStateEnum.UNSETTLED;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = SettlementStateEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                SettlementStateEnum enums = (SettlementStateEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private BlockedStatusEnum getBlockStatus(String value) {
        BlockedStatusEnum retval = BlockedStatusEnum.UNBLOCKED;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = BlockedStatusEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                BlockedStatusEnum enums = (BlockedStatusEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private RedBlueEnum getRedBlueValue(String value) {
        RedBlueEnum retval = RedBlueEnum.BLUE;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = RedBlueEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                RedBlueEnum enums = (RedBlueEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private ReversingStateEnum getReversingStatusValue(String value) {
        ReversingStateEnum retval = ReversingStateEnum.UNREVERSED;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = ReversingStateEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                ReversingStateEnum enums = (ReversingStateEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private DiscountConditionEnum getDiscountCondition(String value) {
        DiscountConditionEnum retval = DiscountConditionEnum.NULL;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = DiscountConditionEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                DiscountConditionEnum enums = (DiscountConditionEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private DiscountModeEnum getDiscountType(String value) {
        DiscountModeEnum retval = DiscountModeEnum.NULL;
        if (value != null && value.trim().length() > 0) {
            value = value.trim();
            List EnumList = DiscountModeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                DiscountModeEnum enums = (DiscountModeEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }
}

