/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.IReasonCode;
import com.kingdee.eas.basedata.scm.common.ReasonCodeFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.framework.CheckOffStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.sd.sale.ISaleInvoice;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class SaleInvoiceEntryImport
extends AbstractDataTransmission {
    String[] DECIMAL_FIELDS = new String[]{"FDiscount", "FQuantity", "FAssistQuantity", "FAmount", "FPrice", "FDealPrice", "FTaxPrice", "FTaxRate", "FTaxAmount", "FTotalTaxPrice", "FCheckOffQty", "FNonCheckOffQty", "FCheckOffAmoun", "NonCheckOffAmount", "FReceived", "FNonReceive", "FLocalAmount", "FLocalCheckOff", "FLocalNonCheckOff", "FLocalReceived", "FLocalNonReceived", "FBadAmout", "FLocalBadAmout", "FDiscountAmount", "FLocalTaxAmount", "FLocalTotalTaxPrice"};
    String[] DECIMAL_OBJS = new String[]{"discount", "quantity", "assistQuantity", "amount", "price", "dealPrice", "taxPrice", "taxRate", "taxAmount", "totalTaxPrice", "checkOffQty", "nonCheckOffQty", "checkOffAmoun", "nonCheckOffAmount", "received", "nonReceive", "localAmount", "localCheckOff", "localNonCheckOff", "localReceived", "localNonReceived", "badAmout", "localBadAmout", "discountAmount", "localTaxAmount", "localTotalTaxPrice"};
    String[] DATE_FIELDS = new String[]{"FDeliveryDate", "FReceivableDate"};
    String[] DATE_OBJS = new String[]{"deliveryDate", "receivableDate"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsPresent"};
    String[] BOOLEAN_OBJS = new String[]{"isPresent"};
    String[] STRING_FIELDS = new String[]{"FAsistProperty", "FRemark"};
    String[] STRING_OBJS = new String[]{"asistProperty", "remark"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SaleInvoiceEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase isaleInvoiceEntry = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !isaleInvoiceEntry.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                isaleInvoiceEntry.addnew(coreBaseInfo);
            } else {
                isaleInvoiceEntry.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        SaleInvoiceEntryInfo entryInfo;
        block26: {
            entryInfo = new SaleInvoiceEntryInfo();
            try {
                Object data = ((DataToken)hsData.get((Object)"FSaleInvoiceID")).data;
                if (data != null) {
                    String str = data.toString();
                    if (str != null && str.trim().length() > 0) {
                        ISaleInvoice isaleInvoice = SaleInvoiceFactory.getLocalInstance(ctx);
                        SaleInvoiceCollection collection = isaleInvoice.getSaleInvoiceCollection("where number ='" + str + "'");
                        if (collection == null || collection.size() == 0) {
                            throw new TaskExternalException("the saleInvoice  not found in database!!!!");
                        }
                        SaleInvoiceInfo saleInvoiceInfo = collection.get(0);
                        SaleInvoiceEntryCollection entryCollection = saleInvoiceInfo.getEntries();
                        entryInfo.setParent(saleInvoiceInfo);
                        if (entryCollection != null && entryCollection.size() > 0) {
                            entryInfo.setSeq(this.getMaxRowNum(entryCollection));
                        } else {
                            entryInfo.setSeq(1);
                        }
                    }
                    break block26;
                }
                throw new TaskExternalException("saleInvoiceID  not found!!!!");
            }
            catch (BOSException bex) {
                Logger.error((Throwable)bex);
                throw new TaskExternalException("process saleinvoiceid  error!!!!");
            }
        }
        for (i = 0; i < this.DECIMAL_FIELDS.length; ++i) {
            try {
                o = ((DataToken)hsData.get((Object)this.DECIMAL_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = new BigDecimal(o.toString())) == null) continue;
                entryInfo.setBigDecimal(this.DECIMAL_OBJS[i], (BigDecimal)value);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.DECIMAL_OBJS[i] + " format error, it must be a number!!!");
            }
        }
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS[i])).data;
            if (o != null && o instanceof Date) {
                value = (Date)o;
                if (value == null) continue;
                entryInfo.setDate(this.DATE_OBJS[i], (Date)value);
                continue;
            }
            if (o == null || o.toString() != null) continue;
            throw new TaskExternalException(this.DATE_FIELDS[i] + " format error, it must be a date String, xxxx-xx-xx!!!");
        }
        for (i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            entryInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            entryInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FDiscountCondition")).data;
        String value2 = null;
        if (data != null) {
            value2 = data.toString();
            entryInfo.setDiscountCondition(this.getDiscountCondition(value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FDiscountType")).data) != null) {
            value2 = data.toString();
            entryInfo.setDiscountType(this.getDiscountType(value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FCheckOffStatus")).data) != null) {
            value2 = data.toString();
            entryInfo.setWriteOffStatus(this.getCheckoffStatusValue(value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FBaseStatus")).data) != null) {
            value2 = data.toString();
            entryInfo.setBaseStatus(this.getEntryStatus(value2));
        }
        try {
            IReasonCode iReasonCode;
            MeasureUnitInfo info;
            IMeasureUnit iunit;
            MeasureUnitCollection collection;
            String str = null;
            data = ((DataToken)hsData.get((Object)"FMaterialID")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                MaterialInfo info2;
                IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                MaterialCollection collection2 = imaterial.getMaterialCollection(viewInfo);
                if (collection2 != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                    entryInfo.setMaterial(info2);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setUnit(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FBaseUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setBaseUnit(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FAssistantUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setAssistUnit(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FReasonCodeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iReasonCode = ReasonCodeFactory.getLocalInstance((Context)ctx)).getReasonCodeCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setReasonCode((ReasonCodeInfo)info);
            }
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
        }
        return entryInfo;
    }

    private int getMaxRowNum(SaleInvoiceEntryCollection entryCollection) {
        int max = 0;
        int temp = 0;
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            SaleInvoiceEntryInfo info = entryCollection.get(i);
            if (info == null || (temp = info.getSeq()) <= max) continue;
            max = temp;
        }
        return max;
    }

    private boolean getBooleanValue(String sourceValue) {
        return !(sourceValue = sourceValue.trim()).equalsIgnoreCase("N") && !sourceValue.equalsIgnoreCase("NO") && !sourceValue.equalsIgnoreCase("0");
    }

    private EntryBaseStatusEnum getEntryStatus(String value) {
        EntryBaseStatusEnum retval = EntryBaseStatusEnum.TEMPORARILYSAVED;
        if (value != null) {
            value = value.trim();
            List EnumList = EntryBaseStatusEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                EntryBaseStatusEnum enums = (EntryBaseStatusEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enums;
                break;
            }
        }
        return retval;
    }

    private CheckOffStatusEnum getCheckoffStatusValue(String value) {
        CheckOffStatusEnum retval = CheckOffStatusEnum.UNCHECKOFF;
        value = value.trim();
        List EnumList = CheckOffStatusEnum.getEnumList();
        int num = EnumList.size();
        for (int i = 0; i < num; ++i) {
            CheckOffStatusEnum enums = (CheckOffStatusEnum)EnumList.get(i);
            String enumValue = String.valueOf(enums.getValue());
            String enumName = enums.getName();
            String enumAlias = enums.getAlias();
            if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
            retval = enums;
            break;
        }
        return retval;
    }

    private DiscountConditionEnum getDiscountCondition(String value) {
        DiscountConditionEnum retval = DiscountConditionEnum.NULL;
        value = value.trim();
        List EnumList = DiscountConditionEnum.getEnumList();
        int num = EnumList.size();
        for (int i = 0; i < num; ++i) {
            DiscountConditionEnum enums = (DiscountConditionEnum)EnumList.get(i);
            String enumValue = String.valueOf(enums.getValue());
            String enumName = enums.getName();
            String enumAlias = enums.getAlias();
            if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
            retval = enums;
            break;
        }
        return retval;
    }

    private DiscountModeEnum getDiscountType(String value) {
        DiscountModeEnum retval = DiscountModeEnum.NULL;
        value = value.trim();
        List EnumList = DiscountModeEnum.getEnumList();
        int num = EnumList.size();
        for (int i = 0; i < num; ++i) {
            DiscountModeEnum enums = (DiscountModeEnum)EnumList.get(i);
            String enumValue = String.valueOf(enums.getValue());
            String enumName = enums.getName();
            String enumAlias = enums.getAlias();
            if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
            retval = enums;
            break;
        }
        return retval;
    }
}

