/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICashDiscount;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeFactory;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ISaleGroup;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.helper.SaleImportHandlingHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sd.sale.AbstractSaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SupplyModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SaleOrderDataImport
extends SCMDataImport {
    HashMap bizTypeMap = new HashMap();
    HashMap orderCusMap = new HashMap();
    HashMap deliverTypeMap = new HashMap();
    HashMap salePersonMap = new HashMap();
    HashMap currencyMap = new HashMap();
    HashMap paramMap = new HashMap();
    HashMap saleRelationMap = new HashMap();
    HashMap propertyMap = new HashMap();
    String[] BIGDECIMAL_FIELDS = new String[]{"FExchangeRate", "FPreReceived"};
    String[] BIGDECIMAL_OBJ = new String[]{"exchangeRate", "preReceived"};
    String[] STRING_FIELDS = new String[]{"FDescription", "FCustomerOrderNumber", "FSendAddressID"};
    String[] STRING_OBJS = new String[]{"description", "customerOrderNumber", "sendAddress"};
    String[] DATE_FIELDS = new String[]{"FAuditTime", "FBizDate", "FModificationTime", "FCreateTime", "FLastUpdateTime"};
    String[] DATE_OBJS = new String[]{"auditTime", "bizDate", "modificationTime", "createTime", "lastUpdateTime"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsInnerSale", "FIsInTax"};
    String[] BOOLEAN_OBJS = new String[]{"isInnerSale", "isInTax"};
    String[] ENUM_FIELDS = new String[]{"FBaseStatus"};
    String[] ENUM_OBJS = new String[]{"baseStatus"};
    String[] INTEGER_FIELDS = new String[]{"FTransLeadTime", "FYear", "FPeriod"};
    String[] INTEGER_OBJS = new String[]{"transLeadTime", "year", "period"};
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    HashMap exchangeRateMap = new HashMap();
    CtrlUnitInfo cu = null;
    SaleImportHandlingHelper importHandlingHelper = new SaleImportHandlingHelper();
    SaleOrgUnitInfo sou = null;
    ImportDataCache dataPool = new ImportDataCache();
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FPrice", "FTaxPrice", "FAmount", "FTaxRate", "FTax", "FTaxAmount", "FQty", "FAssistQty", "FDiscount", "FDiscountAmount", "FActualTaxPrice", "FSendOverRate", "FSendOwingRate", "FSendAdvanceDay", "FSendDeferralDay", "FTotalShippingQty", "FTotalReturnedQty", "FTotalInvoicedQty", "FTotalIssueQty", "FTotalReceivedAmount", "FTotalIssueBaseQty", "FTotalReBaseQty", "FTolInvoidBaseQty", "FTotalShipBaseQty", "FPrepaymentRate", "FPrepaymentEn", "FTotalReturnedQty", "FPreReceivedEn", "FActualPrice", "FBaseQty", "FTotalCancellingStockQty", "FTotalSupplyStockQty", "FUnOrderedQty"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"price", "taxPrice", "amount", "taxRate", "tax", "taxAmount", "qty", "assistQty", "discount", "discountAmount", "actualTaxPrice", "sendOverRate", "sendOwingRate", "sendAdvanceDay", "sendDeferralDay", "totalShippingQty", "totalReturnedQty", "totalInvoicedQty", "totalIssueQty", "totalReceivedAmount", "totalIssueBaseQty", "totalReBaseQty", "tolInvoidBaseQty", "totalShipBaseQty", "prepaymentRate", "prepayment", "totalReturnedQty", "preReceived", "actualPrice", "baseQty", "totalCancellingStockQty", "totalSupplyStockQty", "unOrderedQty"};
    String[] STRING_FIELDS_EN = new String[]{"FRemark", "FSendAddress"};
    String[] STRING_OBJS_EN = new String[]{"remark", "sendAddress"};
    String[] DATE_FIELDS_EN = new String[]{"FSendDate", "FDeliveryDate"};
    String[] DATE_OBJS_EN = new String[]{"sendDate", "deliveryDate"};
    String[] BOOLEAN_FIELDS_EN = new String[]{"FIsPresent", "FQuantityUnCtrl", "FTimeUnCtrl", "FIsBySaleOrder", "FEntries_isIncomeConfirm"};
    String[] BOOLEAN_OBJS_EN = new String[]{"isPresent", "quantityUnCtrl", "timeUnCtrl", "isBySaleOrder", "isIncomeConfirm"};
    String[] ENUM_FIELDS_EN = new String[]{"FDiscountCondition", "FDiscountType", "FEntryBaseStatus"};
    String[] ENUM_OBJS_EN = new String[]{"discountCondition", "discountType", "baseStatus"};
    String[] MUST_NEED = new String[]{"FSaleOrgUnitID", "FMaterialID", "FSalePersonID", "FUnitID", "FQty", "FCurrencyID", "FExchangeRate", "FTotalTaxAmount", "FTotalAmount", "FTotalTax", "FBizTypeID", "FBizDate", "FOrderCustomerID", "FPrice", "FDeliveryTypeID", "FStorageOrgUnitID", "FDeliveryCustomerID", "FReceiveCustomerID", "FPaymentCustomerID", "FSendDate", "FUnOrderedQty", "FIsBySaleOrder"};
    private final String[] priceFields = new String[]{"price", "taxPrice", "actualTaxPrice", "actualPrice"};
    private final String[] amountFields = new String[]{"amount", "taxRate", "tax", "taxAmount", "discountAmount", "totalReceivedAmount", "prepayment", "preReceived", "invoiceReqAmount", "unInvoiceReqAmount"};
    private final String[] localAmountFields = new String[]{"localTax", "localTaxAmount", "localAmount", "invoiceReqAmountLocal", "unInvoiceReqAmountLocal"};
    private static final String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SaleOrderFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        AbstractSaleOrderInfo saleOrderInfo = null;
        int keyCursor = 0;
        TaskExternalException ex = new TaskExternalException("");
        String[] rateFields = new String[]{"sendOverRate", "sendOwingRate", "prepaymentRate"};
        for (int k = 0; k < hsData.size(); ++k) {
            try {
                Map lineData = (Map)hsData.get(new Integer(k));
                if (keyCursor == 0) {
                    saleOrderInfo = this.transmitHead(lineData, ctx);
                    this.afterBuildHead(ctx, saleOrderInfo, lineData);
                }
                SaleOrderEntryInfo entryInfo = null;
                SaleOrderEntryCollection entryCollection = saleOrderInfo.getEntries();
                int seq = entryCollection.size() + 1;
                entryInfo = new SaleOrderEntryInfo();
                entryInfo.setParent((SaleOrderInfo)saleOrderInfo);
                entryInfo.setSeq(seq);
                entryInfo.setIsMrpCal(false);
                entryCollection.add(entryInfo);
                this.handleEntry(entryInfo, lineData, ctx, saleOrderInfo.isIsInTax());
                this.afterBuildEntry(ctx, saleOrderInfo, entryInfo, hsData);
                this.setFieldPrecision(entryInfo, 2, rateFields);
                if (keyCursor == hsData.size() - 1) {
                    this.recalAmountNew(ctx, (SaleOrderInfo)saleOrderInfo);
                }
            }
            catch (TaskExternalException e) {
                if (keyCursor == hsData.size() - 1) {
                    ex.addEntryErrorReason(0, e.getMessage());
                } else {
                    ex.addEntryErrorReason(k, e.getMessage());
                }
                if (ex.getEntryErrorReasons().size() == 1) {
                    this.recycleNumber(ctx, saleOrderInfo);
                }
                if (keyCursor == 0) break;
            }
            ++keyCursor;
        }
        if (ex.getEntryErrorReasons().size() > 0) {
            throw ex;
        }
        return saleOrderInfo;
    }

    private void recalAmount(Context ctx, SaleOrderInfo saleOrderInfo) throws TaskExternalException {
        BigDecimal exchangerate;
        BigDecimal bigDecimal = exchangerate = saleOrderInfo.getExchangeRate() == null ? BigDecimal.ONE : saleOrderInfo.getExchangeRate();
        if (exchangerate.compareTo(ZERO) == 0) {
            exchangerate = BigDecimal.ONE;
        }
        ExchangeRateInfo exchangeRateInfo = null;
        int baseCurrencyPrecision = 2;
        int currencyPrecision = 2;
        String number = "";
        if (saleOrderInfo.getNumber() != null && saleOrderInfo.getNumber().toString().length() > 0) {
            number = saleOrderInfo.getNumber().toString();
        }
        if (!this.exchangeRateMap.containsKey("exchangeRateInfo" + number)) {
            this.setExchangeRateMap(ctx, saleOrderInfo, number);
        }
        if (this.exchangeRateMap.containsKey("exchangeRateInfo" + number)) {
            exchangeRateInfo = (ExchangeRateInfo)this.exchangeRateMap.get("exchangeRateInfo" + number);
        }
        if (this.exchangeRateMap.containsKey("baseCurrencyInfo" + number)) {
            baseCurrencyPrecision = ((CurrencyInfo)this.exchangeRateMap.get("baseCurrencyInfo" + number)).getPrecision();
        }
        if (this.exchangeRateMap.containsKey("currencyInfo" + number)) {
            currencyPrecision = ((CurrencyInfo)this.exchangeRateMap.get("currencyInfo" + number)).getPrecision();
        }
        BigDecimal amount = ZERO;
        BigDecimal tax = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal localAmount = ZERO;
        BigDecimal localTax = ZERO;
        BigDecimal localTaxAmount = ZERO;
        BigDecimal prepareAmount = ZERO;
        int size = saleOrderInfo.getEntries().size();
        for (int n = 0; n < size; ++n) {
            SaleOrderEntryInfo entryInfo = saleOrderInfo.getEntries().get(n);
            amount = ZERO;
            tax = ZERO;
            taxAmount = ZERO;
            if (entryInfo.getAmount() != null) {
                amount = entryInfo.getAmount();
            }
            if (entryInfo.getTax() != null) {
                tax = entryInfo.getTax();
            }
            if (entryInfo.getTaxAmount() != null) {
                taxAmount = entryInfo.getTaxAmount();
            }
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            if (tax != null && exchangerate != null) {
                if (exchangeRateInfo != null) {
                    if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        entryInfo.setLocalTax(tax.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                    } else {
                        entryInfo.setLocalTax(tax.divide(exchangerate, baseCurrencyPrecision, 4));
                    }
                } else {
                    entryInfo.setLocalTax(tax.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                }
            } else {
                entryInfo.setLocalTax(ZERO);
            }
            localTax = localTax.add(entryInfo.getLocalTax());
            if (taxAmount != null && exchangerate != null) {
                if (exchangeRateInfo != null) {
                    if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        entryInfo.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                    } else {
                        entryInfo.setLocalTaxAmount(taxAmount.divide(exchangerate, baseCurrencyPrecision, 4));
                    }
                } else {
                    entryInfo.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                }
            } else {
                entryInfo.setLocalTaxAmount(ZERO);
            }
            localTaxAmount = localTaxAmount.add(entryInfo.getLocalTaxAmount());
            if (entryInfo.getPrepayment() != null && entryInfo.getPrepayment().compareTo(ZERO) != 0) {
                prepareAmount = prepareAmount.add(entryInfo.getPrepayment());
            }
            entryInfo.setLocalAmount(entryInfo.getLocalTaxAmount().subtract(entryInfo.getLocalTax()));
            localAmount = localAmount.add(entryInfo.getLocalAmount());
            if (entryInfo.getPrepayment() == null || entryInfo.getPrepayment().compareTo(ZERO) == 0 || entryInfo.getTaxAmount() == null || entryInfo.getTaxAmount().compareTo(ZERO) == 0) continue;
            entryInfo.setUnPrereceivedAmount(entryInfo.getPrepayment().subtract(entryInfo.getPreReceived()));
        }
        saleOrderInfo.setLocalTotalAmount(localAmount);
        saleOrderInfo.setLocalTotalTaxAmount(localTaxAmount);
        saleOrderInfo.setTotalAmount(totalAmount);
        saleOrderInfo.setTotalTax(totalTax);
        saleOrderInfo.setTotalTaxAmount(totalTaxAmount);
        saleOrderInfo.setPrepayment(prepareAmount);
        if (saleOrderInfo.getPrepayment() != null && saleOrderInfo.getPrepayment().compareTo(ZERO) != 0 && saleOrderInfo.getTotalTaxAmount() != null && saleOrderInfo.getTotalTaxAmount().compareTo(ZERO) != 0) {
            saleOrderInfo.setPrepaymentRate(prepareAmount.divide(saleOrderInfo.getTotalTaxAmount(), 6, 4).multiply(new BigDecimal("100.00")));
        }
    }

    private void handleEntry(SaleOrderEntryInfo entryInfo, Map hsData, Context ctx, boolean isTax) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        Object value2;
        String importOption = this.getSMSDBillConfig(ctx, "com.kingdee.eas.scm.sd.sale.client.SaleOrderListUI", "importOption");
        boolean isCalEntryByAmt = "2".equals(importOption);
        boolean isNotCal = "0".equals(importOption);
        for (int i2 = 0; i2 < this.BIGDECIMAL_FIELDS_EN.length; ++i2) {
            try {
                if (hsData.get(this.BIGDECIMAL_FIELDS_EN[i2]) == null) continue;
                Object o2 = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS_EN[i2])).data;
                if (o2 != null && o2.toString().trim().length() > 0) {
                    value2 = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)((String)o2));
                    if (value2 == null) continue;
                    value2 = ((BigDecimal)value2).abs();
                    entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i2], (BigDecimal)value2);
                    continue;
                }
                if (this.BIGDECIMAL_FIELDS_EN[i2].equals("FTaxAmount") && isCalEntryByAmt && isTax) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDTOTALTAXPRICE", (Context)ctx));
                }
                if (this.BIGDECIMAL_FIELDS_EN[i2].equals("FAmount") && isCalEntryByAmt && !isTax) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDAMOUNT", (Context)ctx));
                }
                if (this.BIGDECIMAL_FIELDS_EN[i2].equals("FPrice") && (!isCalEntryByAmt && !isTax || isNotCal)) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDPRICE", (Context)ctx));
                }
                if (this.BIGDECIMAL_FIELDS_EN[i2].equals("FTaxPrice") && !isCalEntryByAmt && isTax) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDTAXPRICE", (Context)ctx));
                }
                if (this.BIGDECIMAL_FIELDS_EN[i2].equals("FQty")) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDQTY", (Context)ctx));
                }
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i2], BigDecimal.ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ_EN[i2] + " format error, it must be a number!!!");
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (i = 0; i < this.DATE_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS_EN[i])).data;
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                Logger.error((Throwable)pex);
                throw new TaskExternalException(this.DATE_FIELDS_EN[i] + " format error, it must be a date String, xxxx-xx-xx!!!current date is " + o.toString());
            }
            if (o != null && o instanceof Date) {
                value = (Date)o;
                if (value == null) continue;
                entryInfo.setDate(this.DATE_OBJS_EN[i], (Date)value);
                continue;
            }
            entryInfo.setDate(this.DATE_OBJS_EN[i], new Date());
        }
        for (i = 0; i < this.BOOLEAN_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS_EN[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            entryInfo.setBoolean(this.BOOLEAN_OBJS_EN[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
            Object o3;
            DataToken dataToken = (DataToken)hsData.get(this.STRING_FIELDS_EN[i]);
            if (dataToken == null || (o3 = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data) == null) continue;
            String value3 = o3.toString();
            entryInfo.setString(this.STRING_OBJS_EN[i], value3);
        }
        Object data = ((DataToken)hsData.get((Object)"FEntryBaseStatus")).data;
        value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            entryInfo.setBaseStatus(this.getEntryBaseStatusValue((String)value2));
        }
        data = ((DataToken)hsData.get((Object)"FDiscountCondition")).data;
        value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            entryInfo.setDiscountCondition(this.getDiscountConditionEnumValue((String)value2));
        }
        data = ((DataToken)hsData.get((Object)"FDiscountType")).data;
        value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            entryInfo.setDiscountType(this.getDiscountModeEnumValue((String)value2));
        }
        try {
            MeasureUnitInfo info;
            String str = null;
            MaterialInfo materialInfo = null;
            data = ((DataToken)hsData.get((Object)"FMaterialID")).data;
            if (data != null && data.toString().length() > 0) {
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    materialInfo = this.getMaterial(ctx, str, new OrgUnitInfo[0]);
                    entryInfo.setMaterial(materialInfo);
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"MATERIAL_NOT_NULL", (Context)ctx));
            }
            data = ((DataToken)hsData.get((Object)"FUnitID")).data;
            if (data != null) {
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    info = this.getMeasureUnit(ctx, str, materialInfo);
                    entryInfo.setUnit(info);
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"UNIT_NOT_NULL", (Context)ctx));
            }
            if (null != materialInfo && null != materialInfo.getBaseUnit() && (str = materialInfo.getBaseUnit().getNumber()) != null && str.trim().length() > 0) {
                info = this.getMeasureUnit(ctx, str, materialInfo);
                entryInfo.setBaseUnit(info);
                if (entryInfo.getQty() != null && !entryInfo.getQty().equals(BigDecimal.ZERO) && entryInfo.getUnit() != null && entryInfo.getMaterial() != null) {
                    BigDecimal baseUnitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getQty());
                    entryInfo.setBaseQty(baseUnitQty);
                }
            }
            if (null != materialInfo) {
                entryInfo.setAssistUnit(materialInfo.getAssistUnit());
                data = ((DataToken)hsData.get((Object)"FAssistPropertyID")).data;
                if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                    info = this.getAsstAttr(ctx, str, materialInfo.getAssistAttr());
                    entryInfo.setAssistProperty((AsstAttrValueInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FStorageOrgUnitID")).data) != null) {
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    info = this.getStorageOrgUnit(ctx, "number", str);
                    if (this.sou != null && !this.storageHasRelationwithSale(ctx, this.sou.getId().toString(), info.getId().toString())) {
                        throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"NO_ENTRUST_SALE", (Context)ctx));
                    }
                    entryInfo.setStorageOrgUnit((StorageOrgUnitInfo)info);
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"STORAGE_NOT_NULL", (Context)ctx));
            }
            data = ((DataToken)hsData.get((Object)"FProStorageOrgUnitID")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info = this.getStorageOrgUnit(ctx, "number", str);
                entryInfo.setProStorageOrgUnit((StorageOrgUnitInfo)info);
            }
            this.setSupplyMode(ctx, entryInfo);
            data = ((DataToken)hsData.get((Object)"FCompanyOrgUnitID")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info = this.getCompanyOrgUnit(ctx, "number", str);
                entryInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FWarehouseID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                if (this.dataPool.getWarehouseInfo(str) == null) {
                    WarehouseInfo info2;
                    IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0");
                    viewInfo.setFilter(filter);
                    WarehouseCollection collection = iWarehouse.getWarehouseCollection(viewInfo);
                    if (collection != null && collection.size() > 0 && (info2 = collection.get(0)) != null) {
                        entryInfo.setWarehouse(info2);
                        this.dataPool.setWarehouseInfo(str, info2);
                    }
                } else {
                    entryInfo.setWarehouse(this.dataPool.getWarehouseInfo(str));
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FDeliveryCustomerID")).data) != null) {
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    info = this.getCustomer(ctx, str);
                    entryInfo.setDeliveryCustomer((CustomerInfo)info);
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"DELIVERYCUSTOMER_NULL", (Context)ctx));
            }
            data = ((DataToken)hsData.get((Object)"FPaymentCustomerID")).data;
            if (data != null) {
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    info = this.getCustomer(ctx, str);
                    entryInfo.setPaymentCustomer((CustomerInfo)info);
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"PAYMENTCUSTOMER_NOT_EXIST", (Context)ctx));
            }
            data = ((DataToken)hsData.get((Object)"FReceiveCustomerID")).data;
            if (data != null) {
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    info = this.getCustomer(ctx, str);
                    entryInfo.setReceiveCustomer((CustomerInfo)info);
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"ReceiveCustomer_NOT_EXIST", (Context)ctx));
            }
            data = ((DataToken)hsData.get((Object)"FProjectNumber")).data;
            if (data != null && data.toString().trim().length() > 0) {
                entryInfo.setProject(this.getProject(ctx, data.toString(), this.cu));
            }
            if ((data = ((DataToken)hsData.get((Object)"FTrackNumber")).data) != null && data.toString().trim().length() > 0) {
                entryInfo.setTrackNumber(this.getTrackNumber(ctx, data, this.sou.getCU()));
            }
            if (this.propertyMap.get("bizDate") != null) {
                Date d = (Date)this.propertyMap.get("bizDate");
                entryInfo.setBizDate(d);
            }
            if (this.sou != null) {
                entryInfo.setSaleOrgUnit(this.sou.getId().toString());
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        if (entryInfo.getUnit() != null && entryInfo.getMaterial() != null) {
            MultiMeasureUnitInfo mmu = null;
            try {
                mmu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(entryInfo.getMaterial().getId().toString(), entryInfo.getUnit().getId().toString());
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
            if (mmu != null) {
                int qtyPrecision = mmu.getQtyPrecision();
                if (entryInfo.getQty() != null) {
                    entryInfo.setQty(entryInfo.getQty().setScale(qtyPrecision, 4));
                }
            }
        }
        entryInfo.setUnInvoiceReqQty(entryInfo.getQty());
        entryInfo.setUnInvoiceReqBaseQty(entryInfo.getBaseQty());
        entryInfo.setUnInvoiceReqAmount(entryInfo.getTaxAmount());
        entryInfo.setUnInvoiceReqAmountLocal(entryInfo.getLocalTaxAmount());
    }

    private boolean storageHasRelationwithSale(Context ctx, String saleOrgID, String storageID) throws EASBizException, BOSException {
        if (this.saleRelationMap.get(saleOrgID) == null) {
            IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection ioc = iour.getFromUnit(saleOrgID, 2, 4);
            HashSet<String> orgSet = new HashSet<String>();
            int size = ioc.size();
            for (int i = 0; i < size; ++i) {
                orgSet.add(ioc.get(i).getId().toString());
            }
            this.saleRelationMap.put(saleOrgID, orgSet);
        }
        HashSet orgSet = (HashSet)this.saleRelationMap.get(saleOrgID);
        return orgSet.contains(storageID);
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, String storgeID) {
        CompanyOrgUnitInfo company = null;
        if (storgeID != null) {
            try {
                IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitCollection orgCol = iOrgUnitRelation.getToUnit(storgeID, 4, 1);
                company = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return company;
    }

    private void setSupplyMode(Context ctx, SaleOrderEntryInfo entryInfo) {
        String storage2;
        StorageOrgUnitInfo obj1 = entryInfo.getStorageOrgUnit();
        StorageOrgUnitInfo obj2 = entryInfo.getProStorageOrgUnit();
        String storage1 = obj1 != null ? obj1.getId().toString() : "";
        String string = storage2 = obj2 != null ? obj2.getId().toString() : "";
        if (obj1 == null || obj2 == null || storage1.equals(storage2)) {
            entryInfo.setSupplyMode(SupplyModeEnum.SELF_STORAGE);
        } else {
            CompanyOrgUnitInfo company1 = SaleOrderDataImport.getCompanyInfo(ctx, storage1);
            CompanyOrgUnitInfo company2 = SaleOrderDataImport.getCompanyInfo(ctx, storage2);
            if (company1 != null && company2 != null && company1.getId().toString().equals(company2.getId().toString())) {
                entryInfo.setSupplyMode(SupplyModeEnum.INTER_STORAGE);
            } else {
                entryInfo.setSupplyMode(SupplyModeEnum.INTER_COMPANY);
            }
        }
    }

    private boolean getBooleanValue(String value) {
        return !(value = value.trim()).equalsIgnoreCase("N") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("0") && !value.equalsIgnoreCase("FALSE");
    }

    private BillBaseStatusEnum getBaseStatusValue(String value) {
        BillBaseStatusEnum tSaved = BillBaseStatusEnum.TEMPORARILYSAVED;
        return tSaved;
    }

    private EntryBaseStatusEnum getEntryBaseStatusValue(String value) {
        EntryBaseStatusEnum tSaved = EntryBaseStatusEnum.TEMPORARILYSAVED;
        return tSaved;
    }

    private DiscountModeEnum getDiscountModeEnumValue(String value) {
        DiscountModeEnum tSaved = DiscountModeEnum.NULL;
        if (value != null) {
            value = value.trim();
            List EnumList = DiscountModeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                DiscountModeEnum enumList = (DiscountModeEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = enumList;
                break;
            }
        }
        return tSaved;
    }

    private DiscountConditionEnum getDiscountConditionEnumValue(String value) {
        DiscountConditionEnum tSaved = DiscountConditionEnum.NULL;
        if (value != null) {
            value = value.trim();
            List EnumList = DiscountConditionEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                DiscountConditionEnum enumList = (DiscountConditionEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = enumList;
                break;
            }
        }
        return tSaved;
    }

    private UserInfo getUserFromNumber(Context ctx, String number) throws BOSException, TaskExternalException {
        UserInfo userInfo = this.getCreator(ctx, null);
        return userInfo;
    }

    private BigDecimal dealPrecision(BigDecimal number, String precision) {
        int _precision = precision != null ? Integer.parseInt(precision) : 2;
        number = number != null && number.toString().indexOf("0E") == -1 ? number.setScale(_precision, 4) : ZERO.setScale(_precision);
        return number;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String currencyPrecision = rs.getString("currency.precision") == null ? "2" : rs.getString("currency.precision");
            String qtyPrecision = rs.getString("multiMeasureUnit.qtyPrecision") == null ? "4" : rs.getString("multiMeasureUnit.qtyPrecision");
            String pricePrecision = rs.getString("material.pricePrecision") == null ? "6" : rs.getString("material.pricePrecision");
            String localCurrencyPrecision = rs.getString("baseCurrency.precision") == null ? "2" : rs.getString("baseCurrency.precision");
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizTypeID", rs.getString("bizType.number"));
            this.putTable(result, "FBaseStatus", rs.getString("baseStatus"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FOrderCustomerID", rs.getString("orderCustomer.number"));
            this.putTable(result, "FCustomerOrderNumber", rs.getString("customerOrderNumber"));
            this.putTable(result, "FSourceBillTypeID", rs.getString("sourceBillType1.number"));
            this.putTable(result, "FSaleOrgUnitID", rs.getString("saleOrgUnit.number"));
            this.putTable(result, "FSaleGroupID", rs.getString("saleGroup.number"));
            this.putTable(result, "FSalePersonID", rs.getString("salePerson.number"));
            this.putTable(result, "FControlUnitID", rs.getString("CU.number"));
            this.putTable(result, "FIsInnerSale", rs.getString("isInnerSale"));
            this.putTable(result, "FPurchaseOrgUnitID", rs.getString("purchaseOrgUnit.number"));
            this.putTable(result, "FDirectSupplierID", rs.getString("directSupplier.number"));
            this.putTable(result, "FAdminOrgUnitID", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FCurrencyID", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getString("exchangeRate"));
            this.putTable(result, "FIsInTax", rs.getString("isInTax"));
            this.putTable(result, "FDeliveryTypeID", rs.getString("deliveryType.number"));
            this.putTable(result, "FTransLeadTime", rs.getString("transLeadTime"));
            this.putTable(result, "FPaymentTypeID", rs.getString("paymentType.number"));
            this.putTable(result, "FCashDiscountID", rs.getString("cashDiscount.number"));
            this.putTable(result, "FSettlementTypeID", rs.getString("settlementType.number"));
            this.putTable(result, "FPrepaymentRate", this.dealPrecision(rs.getBigDecimal("entries.prepaymentRate"), "4"));
            this.putTable(result, "FPreReceived", rs.getString("preReceived"));
            this.putTable(result, "FYear", rs.getString("year1"));
            this.putTable(result, "FPeriod", rs.getString("period1"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FHasEffect", rs.getString("hasEffected"));
            this.putTable(result, "FSeq", rs.getString("entries.seq"));
            this.putTable(result, "FMaterialID", rs.getString("material.number"));
            this.putTable(result, "FAssistPropertyID", rs.getString("assistProperty.number"));
            this.putTable(result, "FIsPresent", rs.getString("entries.isPresent"));
            this.putTable(result, "FUnitID", rs.getString("unit.number"));
            this.putTable(result, "FQty", this.dealPrecision(rs.getBigDecimal("entries.qty"), qtyPrecision));
            this.putTable(result, "FBaseUnitID", rs.getString("baseUnit.number"));
            this.putTable(result, "FBaseQty", rs.getBigDecimal("entries.baseQty") == null ? null : rs.getBigDecimal("entries.baseQty").toPlainString());
            this.putTable(result, "FAssistUnitID", rs.getString("assistUnit.number"));
            this.putTable(result, "FAssistQty", this.dealPrecision(rs.getBigDecimal("entries.assistQty"), qtyPrecision));
            this.putTable(result, "FPrice", this.dealPrecision(rs.getBigDecimal("entries.price"), pricePrecision));
            this.putTable(result, "FTaxRate", rs.getString("entries.taxRate"));
            this.putTable(result, "FTaxPrice", this.dealPrecision(rs.getBigDecimal("entries.taxPrice"), pricePrecision));
            this.putTable(result, "FDiscountCondition", rs.getString("entries.discountCondition"));
            this.putTable(result, "FDiscountType", rs.getString("entries.discountType"));
            this.putTable(result, "FDiscount", this.dealPrecision(rs.getBigDecimal("entries.discount"), "4"));
            this.putTable(result, "FActualPrice", this.dealPrecision(rs.getBigDecimal("entries.actualPrice"), pricePrecision));
            this.putTable(result, "FActualTaxPrice", this.dealPrecision(rs.getBigDecimal("entries.actualTaxPrice"), pricePrecision));
            this.putTable(result, "FDiscountAmount", this.dealPrecision(rs.getBigDecimal("entries.discountAmount"), currencyPrecision));
            this.putTable(result, "FAmount", rs.getString("entries.amount"));
            this.putTable(result, "FTax", rs.getString("entries.tax"));
            this.putTable(result, "FTaxAmount", rs.getString("entries.taxAmount"));
            this.putTable(result, "FPrepaymentEn", rs.getString("entries.prepayment"));
            this.putTable(result, "FPreReceivedEn", rs.getString("entries.preReceived"));
            this.putTable(result, "FEntryBaseStatus", rs.getString("entries.baseStatus"));
            this.putTable(result, "FReasonCodeID", rs.getString("reasonCode.number"));
            this.putTable(result, "FRemark", rs.getString("entries.remark"));
            this.putTable(result, "FStorageOrgUnitID", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FCompanyOrgUnitID", rs.getString("companyOrgUnit.number"));
            this.putTable(result, "FWarehouseID", rs.getString("warehouse.number"));
            this.putTable(result, "FDeliveryCustomerID", rs.getString("deliveryCustomer.number"));
            this.putTable(result, "FReceiveCustomerID", rs.getString("receiveCustomer.number"));
            this.putTable(result, "FPaymentCustomerID", rs.getString("paymentCustomer.number"));
            this.putTable(result, "FSendAddress", rs.getString("entries.sendAddress"));
            this.putTable(result, "FSendDate", rs.getString("entries.sendDate"));
            this.putTable(result, "FDeliveryDate", rs.getString("entries.deliveryDate"));
            this.putTable(result, "FQuantityUnCtrl", rs.getString("entries.quantityUnCtrl"));
            this.putTable(result, "FTimeUnCtrl", rs.getString("entries.timeUnCtrl"));
            this.putTable(result, "FSendOverRate", this.dealPrecision(rs.getBigDecimal("entries.sendOverRate"), "4"));
            this.putTable(result, "FSendOwingRate", this.dealPrecision(rs.getBigDecimal("entries.sendOwingRate"), "4"));
            this.putTable(result, "FSendAdvanceDay", this.dealPrecision(rs.getBigDecimal("entries.sendAdvanceDay"), "0"));
            this.putTable(result, "FSendDeferralDay", this.dealPrecision(rs.getBigDecimal("entries.sendDeferralDay"), "0"));
            this.putTable(result, "FCreatorID", rs.getString("creator.number"));
            this.putTable(result, "FCreateTime", rs.getString("createTime"));
            this.putTable(result, "FModifierID", rs.getString("modifier.number"));
            this.putTable(result, "FModificationTime", rs.getString("modificationTime"));
            this.putTable(result, "FLastUpdateUserID", rs.getString("lastUpdateUser.number"));
            this.putTable(result, "FLastUpdateTime", rs.getString("lastUpdateTime"));
            this.putTable(result, "FAuditorID", rs.getString("auditor.number"));
            this.putTable(result, "FAuditTime", rs.getString("auditTime"));
            this.putTable(result, "FIsBySaleOrder", rs.getString("entries.isBySaleOrder"));
            this.putTable(result, "FUnOrderedQty", this.dealPrecision(rs.getBigDecimal("entries.unOrderedQty"), qtyPrecision));
            this.putTable(result, "FProjectNumber", rs.getString("project.number"));
            this.putTable(result, "FTrackNumber", rs.getString("trackNumber.number"));
            this.putTable(result, "FProStorageOrgUnitID", rs.getString("proStorageOrgUnit.number"));
            this.putTable(result, "FSupplyMode", rs.getString("entries.supplyMode"));
            this.putTable(result, "FInvoiceNumber", rs.getString("invoiceNumber"));
            this.putTable(result, "FEntries_invoiceReqQty", this.dealPrecision(rs.getBigDecimal("entries.invoiceReqQty"), qtyPrecision));
            this.putTable(result, "FEntries_unInvoiceReqQty", this.dealPrecision(rs.getBigDecimal("entries.unInvoiceReqQty"), qtyPrecision));
            this.putTable(result, "FEntries_invoiceReqBaseQty", rs.getBigDecimal("entries.invoiceReqBaseQty") == null ? null : rs.getBigDecimal("entries.invoiceReqBaseQty").toPlainString());
            this.putTable(result, "FEntries_unInvoiceReqBaseQty", rs.getBigDecimal("entries.unInvoiceReqBaseQty") == null ? null : rs.getBigDecimal("entries.unInvoiceReqBaseQty").toPlainString());
            this.putTable(result, "FEntries_invoiceReqAmount", this.dealPrecision(rs.getBigDecimal("entries.invoiceReqAmount"), currencyPrecision));
            this.putTable(result, "FEntries_invoiceReqAmountLocal", this.dealPrecision(rs.getBigDecimal("entries.invoiceReqAmountLocal"), localCurrencyPrecision));
            this.putTable(result, "FEntries_unInvoiceReqAmount", this.dealPrecision(rs.getBigDecimal("entries.unInvoiceReqAmount"), currencyPrecision));
            this.putTable(result, "FEntries_unInvoiceReqAmountLocal", this.dealPrecision(rs.getBigDecimal("entries.unInvoiceReqAmountLocal"), localCurrencyPrecision));
            this.putTable(result, "FEntries_isIncomeConfirm", rs.getString("entries.isIncomeConfirm"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.sale.app.ExportSaleOrderQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Sale, (String)"saleorder_export");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return oldFilterInfo;
    }

    public TrackNumberInfo getTrackByNumber(Context ctx, String number, StorageOrgUnitInfo storageUnit) throws TaskExternalException, BOSException {
        TrackNumberInfo track = null;
        if (number != null && number.trim().length() > 0) {
            ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            HashSet<Integer> status = new HashSet<Integer>();
            status.add(new Integer(10));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
            FilterInfo filter2 = new FilterInfo();
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (storageUnit != null && storageUnit.getCU() != null) {
                cu = storageUnit.getCU();
            }
            ObjectUuidPK cuPK = null;
            cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
            try {
                filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            if (filter2 != null) {
                filter.mergeFilter(filter2, "and");
            }
            viewInfo.setFilter(filter);
            TrackNumberCollection coll = iTrackNumber.getTrackNumberCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                track = coll.get(0);
                this.dataPool.setTrackNumber(number, track);
            } else {
                throw new TaskExternalException(number.toString() + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"TRACK_NUMBER_ERROR", (Context)ctx));
            }
        }
        return track;
    }

    public int getSubmitType() {
        return 1;
    }

    private boolean isNeed(String columnName, Object bizType) {
        for (int i = 0; i < this.MUST_NEED.length; ++i) {
            if (!columnName.equals(this.MUST_NEED[i]) || !StringUtil.isEmpty((String)bizType.toString())) continue;
            return true;
        }
        return false;
    }

    private Object getbizObjectByNumber(Context ctx, String bizType, String number) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        if (bizType.equals("FBizTypeID")) {
            if (!this.bizTypeMap.containsKey(number)) {
                BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo(view.toString());
                this.bizTypeMap.put(number, bizTypeInfo);
            }
            return this.bizTypeMap.get(number);
        }
        if (bizType.equals("FOrderCustomerID")) {
            if (!this.orderCusMap.containsKey(number)) {
                CustomerInfo bizTypeInfo = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo(view.toString());
                this.orderCusMap.put(number, bizTypeInfo);
            }
            return this.orderCusMap.get(number);
        }
        if ("FDeliveryTypeID".equals(bizType)) {
            if (!this.deliverTypeMap.containsKey(number)) {
                DeliveryTypeInfo deliveryTypeInfo = DeliveryTypeFactory.getLocalInstance((Context)ctx).getDeliveryTypeInfo(view.toString());
                this.deliverTypeMap.put(number, deliveryTypeInfo);
            }
            return this.deliverTypeMap.get(number);
        }
        if ("FCurrencyID".equals(bizType)) {
            if (!this.currencyMap.containsKey(number)) {
                CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view.toString());
                if (currencyCollection != null && currencyCollection.size() > 0) {
                    this.currencyMap.put(number, currencyCollection.get(0));
                } else {
                    this.currencyMap.put(number, null);
                }
            }
            return this.currencyMap.get(number);
        }
        return null;
    }

    private void setBillInfo(Context ctx, Map lineData, String bizTypeName, SaleOrderInfo saleOrderInfo, String propertyName, String nullSoureceKey, String notExistKey) throws TaskExternalException {
        Object bizObj = ((DataToken)lineData.get((Object)bizTypeName)).data;
        if (this.isNeed(bizTypeName, bizObj)) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)nullSoureceKey, (Context)ctx));
        }
        try {
            Object bizTypeInfo = this.getbizObjectByNumber(ctx, bizTypeName, bizObj.toString());
            if (bizTypeInfo == null) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)notExistKey, (Context)ctx));
            }
            saleOrderInfo.put(propertyName, bizTypeInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private SaleOrderInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        String str = null;
        Object data = null;
        Object bizDate = ((DataToken)lineData.get((Object)"FBizDate")).data;
        if (this.isNeed("FBizDate", bizDate)) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"BIZDATE_NOT_NULL", (Context)ctx));
        }
        this.setBillInfo(ctx, lineData, "FBizTypeID", saleOrderInfo, "bizType", "SALEINV_NEEDTRANSTYPE", "BIZTYPE_NOT_EXIST");
        this.setBillInfo(ctx, lineData, "FOrderCustomerID", saleOrderInfo, "orderCustomer", "ORDER_CUS_NULL", "ORDER_CUS_NOT_EXIST");
        this.setBillInfo(ctx, lineData, "FDeliveryTypeID", saleOrderInfo, "deliveryType", "SENDTYPE_NULL", "SENDTYPE_NOT_EXIST");
        this.doBillType(saleOrderInfo);
        Object numberdata = ((DataToken)lineData.get((Object)"FNumber")).data;
        Object saleOrgData = ((DataToken)lineData.get((Object)"FSaleOrgUnitID")).data;
        Object str1 = null;
        str = numberdata != null ? numberdata.toString() : null;
        String saleOrgNum = null;
        String cuID = null;
        String saleOrgUnitID = null;
        if (saleOrgData != null) {
            saleOrgNum = saleOrgData.toString();
            if (saleOrgNum != null && saleOrgNum.trim().length() > 0) {
                try {
                    SaleOrgUnitInfo info = this.getSaleOrgUnit(ctx, "number", saleOrgNum);
                    cuID = info.getCU().getId().toString();
                    this.cu = info.getCU();
                    saleOrgUnitID = info.getId().toString();
                }
                catch (TaskExternalException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEORG_NOT_EXISTS", (Context)ctx));
            }
        }
        for (i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                o = ((DataToken)lineData.get((Object)this.BIGDECIMAL_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)((String)o))) == null) continue;
                saleOrderInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], (BigDecimal)value);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + " format error, it must be a number!!!");
            }
        }
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            o = ((DataToken)lineData.get((Object)this.DATE_FIELDS[i])).data;
            if (o == null || o.toString().length() <= 0 || (o = this.formatNationalDate(ctx, o.toString())) == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
            saleOrderInfo.setDate(this.DATE_OBJS[i], (Date)value);
            if (!"bizDate".equals(this.DATE_OBJS[i])) continue;
            this.propertyMap.put("bizDate", value);
        }
        for (i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            o = ((DataToken)lineData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            saleOrderInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            if (lineData.get(this.STRING_FIELDS[i]) == null || (o = ((DataToken)lineData.get((Object)this.STRING_FIELDS[i])).data) == null) continue;
            value = o.toString();
            saleOrderInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        for (i = 0; i < this.INTEGER_FIELDS.length; ++i) {
            o = ((DataToken)lineData.get((Object)this.INTEGER_FIELDS[i])).data;
            if (o == null || o.toString().equals("")) continue;
            value = new Integer(o.toString());
            saleOrderInfo.setInt(this.INTEGER_OBJS[i], (Integer)value);
        }
        data = ((DataToken)lineData.get((Object)"FBaseStatus")).data;
        String value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            saleOrderInfo.setBaseStatus(this.getBaseStatusValue(value2));
        }
        try {
            PurchaseOrgUnitInfo info;
            FilterInfo filter;
            EntityViewInfo viewInfo;
            SalePersonCollection collection;
            SaleGroupInfo info2;
            IUser iuser = UserFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = null;
            data = ((DataToken)lineData.get((Object)"FCreatorID")).data;
            if (data != null && (userInfo = this.getUserFromNumber(ctx, str = data.toString())) != null) {
                saleOrderInfo.setCreator(userInfo);
            }
            if ((data = ((DataToken)lineData.get((Object)"FLastUpdateUserID")).data) != null && (userInfo = this.getUserFromNumber(ctx, str = data.toString())) != null) {
                saleOrderInfo.setLastUpdateUser(userInfo);
            }
            this.setBillInfo(ctx, lineData, "FCurrencyID", saleOrderInfo, "currency", "SALEINV_NEEDCURRENCY", "CURRENCY_NOT_EXIST");
            data = ((DataToken)lineData.get((Object)"FSaleOrgUnitID")).data;
            if (data != null && data.toString().trim().length() > 0) {
                IOrgUnitRelation iOrgRelation;
                OrgUnitCollection orgCollection;
                SaleOrgUnitInfo info3 = new SaleOrgUnitInfo();
                str = data.toString();
                if (str != null && str.trim().length() > 0) {
                    info3 = this.getSaleOrgUnit(ctx, "number", str);
                    saleOrderInfo.setSaleOrgUnit(info3);
                    saleOrderInfo.setCU(info3.getCU());
                    this.sou = info3;
                }
                if ((orgCollection = (iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(info3.getId().toString(), 2, 1)) != null && orgCollection.size() > 0) {
                    Object[] objs = orgCollection.toArray();
                    OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
                    System.arraycopy(objs, 0, orgs, 0, objs.length);
                    saleOrderInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)orgs[0]);
                }
            }
            if ((data = ((DataToken)lineData.get((Object)"FSaleGroupID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                if (this.dataPool.getSaleGroup(str) == null) {
                    ISaleGroup isaleGroup = SaleGroupFactory.getLocalInstance((Context)ctx);
                    SaleGroupCollection collection2 = isaleGroup.getSaleGroupCollection("where number='" + str + "'");
                    if (collection2 != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                        saleOrderInfo.setSaleGroup(info2);
                        this.dataPool.setSaleGroup(str, info2);
                    }
                } else {
                    saleOrderInfo.setSaleGroup(this.dataPool.getSaleGroup(str));
                }
            }
            Object bizObj = ((DataToken)lineData.get((Object)"FSalePersonID")).data;
            String number = bizObj.toString();
            if (this.isNeed("FSalePersonID", bizObj)) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALE_PERSON_NULL", (Context)ctx));
            }
            try {
                SalePersonInfo salePersonInfo;
                if (this.dataPool.getSalePersonInfo(this.sou.getId().toString() + number) == null) {
                    EntityViewInfo viewInfo2 = new EntityViewInfo();
                    FilterInfo numberFilter = new FilterInfo();
                    numberFilter.getFilterItems().add(new FilterItemInfo("person.number", (Object)number, CompareType.EQUALS));
                    String paramValue = this.getParamValueByNumberAndOrg(ctx, "SALE001", this.sou.getId().toString());
                    if ("0".equals(paramValue)) {
                        numberFilter.getFilterItems().add(new FilterItemInfo("saleGroup.saleOrg", (Object)this.sou.getId().toString(), CompareType.EQUALS));
                    }
                    viewInfo2.setFilter(numberFilter);
                    collection = SalePersonFactory.getLocalInstance((Context)ctx).getSalePersonCollection(viewInfo2);
                    if (collection != null && collection.size() > 0) {
                        this.dataPool.setSalePersonInfo(this.sou.getId().toString() + number, collection.get(0));
                    }
                }
                if ((salePersonInfo = this.dataPool.getSalePersonInfo(this.sou.getId().toString() + number)) == null) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALE_PEROSN_NOT_EXIST", (Context)ctx));
                }
                saleOrderInfo.setSalePerson(salePersonInfo.getPerson());
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
            data = ((DataToken)lineData.get((Object)"FPurchaseOrgUnitID")).data;
            if (data != null && (str = data.toString()) != null && str.length() > 0) {
                if (this.dataPool.getPurchaseOrgUnitInfo(str) == null) {
                    IPurchaseOrgUnit ipurOrg = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0");
                    viewInfo.setFilter(filter);
                    collection = ipurOrg.getPurchaseOrgUnitCollection(viewInfo);
                    if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                        saleOrderInfo.setPurchaseOrgUnit(info);
                        this.dataPool.setPurchaseOrgUnitInfo(str, info);
                    }
                } else {
                    saleOrderInfo.setPurchaseOrgUnit(this.dataPool.getPurchaseOrgUnitInfo(str));
                }
            }
            if ((data = ((DataToken)lineData.get((Object)"FDirectSupplierID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                info2 = this.getSupplier(ctx, "number", str);
                saleOrderInfo.setDirectSupplier((SupplierInfo)info2);
            }
            if ((data = ((DataToken)lineData.get((Object)"FSettlementTypeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                if (this.dataPool.getSettlementTypeInfo(str) == null) {
                    ISettlementType isettlement = SettlementTypeFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0");
                    viewInfo.setFilter(filter);
                    collection = isettlement.getSettlementTypeCollection(viewInfo);
                    if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                        saleOrderInfo.setSettlementType((SettlementTypeInfo)info);
                        this.dataPool.setSettlementTypeInfo(str, (SettlementTypeInfo)info);
                    }
                } else {
                    saleOrderInfo.setSettlementType(this.dataPool.getSettlementTypeInfo(str));
                }
            }
            if ((data = ((DataToken)lineData.get((Object)"FPaymentTypeID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                if (this.dataPool.getPaymentTypeInfo(str) == null) {
                    IPaymentType ipaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0");
                    viewInfo.setFilter(filter);
                    collection = ipaymentType.getPaymentTypeCollection(viewInfo);
                    if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                        saleOrderInfo.setPaymentType((PaymentTypeInfo)info);
                        this.dataPool.setPaymentTypeInfo(str, (PaymentTypeInfo)info);
                    }
                } else {
                    saleOrderInfo.setPaymentType(this.dataPool.getPaymentTypeInfo(str));
                }
            }
            if ((data = ((DataToken)lineData.get((Object)"FCashDiscountID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                if (this.dataPool.getCashDiscountInfo(str) == null) {
                    ICashDiscount iCashDiscount = CashDiscountFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0");
                    viewInfo.setFilter(filter);
                    collection = iCashDiscount.getCashDiscountCollection(viewInfo);
                    if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                        saleOrderInfo.setCashDiscount((CashDiscountInfo)info);
                        this.dataPool.setCashDiscountInfo(str, (CashDiscountInfo)info);
                    }
                } else {
                    saleOrderInfo.setCashDiscount(this.dataPool.getCashDiscountInfo(str));
                }
            }
            if ((data = ((DataToken)lineData.get((Object)"FAdminOrgUnitID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                info2 = this.getAdminOrgUnit(ctx, "number", str);
                saleOrderInfo.setAdminOrgUnit((AdminOrgUnitInfo)info2);
            }
            if ((data = ((DataToken)lineData.get((Object)"FModifierID")).data) != null && (userInfo = this.getUserFromNumber(ctx, str = data.toString())) != null) {
                saleOrderInfo.setModifier(userInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        return saleOrderInfo;
    }

    public void afterBuildEntry(Context ctx, SCMBillBaseInfo info, SCMBillEntryBaseInfo entry, Map lineData) throws TaskExternalException {
        super.afterBuildEntry(ctx, info, entry, lineData);
        String sdBillConfig = this.getSMSDBillConfig(ctx, "com.kingdee.eas.scm.sm.pur.client.SaleOrderListUI", "importOption");
        if (sdBillConfig == null || "0".equals(sdBillConfig)) {
            this.checkEntryValue(ctx, (SaleOrderEntryInfo)entry);
        }
    }

    private void checkEntryValue(Context ctx, SaleOrderEntryInfo entry) throws TaskExternalException {
        BigDecimal tax = this.setNullToZero(entry.getTax());
        BigDecimal amount = this.setNullToZero(entry.getAmount());
        BigDecimal taxAmount = this.setNullToZero(entry.getTaxAmount());
        if (tax.add(amount).compareTo(taxAmount) != 0) {
            String str = SaleOrderDataImport.getResources((Context)ctx, (String)"TAXAMOUNT_NOTEQUALS_OTHERAMOUNT", (String)"com.kingdee.eas.scm.im.inv.app.PurInImportResource");
            throw new TaskExternalException(str);
        }
    }

    private String getParamValueByNumberAndOrg(Context ctx, String number, String orgID) throws EASBizException, BOSException {
        if (this.paramMap.get(orgID + number) == null) {
            ParamItemInfo paramItem = ParamControlFactory.getLocalInstance((Context)ctx).getParamItemByNumberAndOrg(number, orgID);
            this.paramMap.put(orgID + number, paramItem.getValue());
        }
        return this.paramMap.get(orgID + number).toString();
    }

    private Date formatNationalDate(Context ctx, String dateStr) throws TaskExternalException {
        Date date = null;
        if (!StringUtil.isEmpty((String)dateStr) && (date = ExcelUtil.formatNationalDate((Context)ctx, (String)dateStr)) == null) {
            String format = ExcelUtil.getDateFomartString((Context)ctx);
            try {
                date = BOSLocaleUtil.getDateFormat().parse(dateStr);
            }
            catch (ParseException e) {
                throw new TaskExternalException(SCMUtils.getResource((String)resources, (String)"InvalidDateFiled", (String[])new String[]{format}, (Context)ctx));
            }
        }
        return date;
    }

    protected String[] getPriceFields() {
        return this.priceFields;
    }

    protected String[] getAmountFields() {
        return this.amountFields;
    }

    protected String[] getLocalAmountFields() {
        return this.localAmountFields;
    }

    protected String getDiscountField() {
        return "discount";
    }

    protected String getTaxRateField() {
        return "taxRate";
    }

    public String getImportPermissionItem() {
        return "saleorder_addnew";
    }

    private void doBillType(SaleOrderInfo saleOrderInfo) {
        BillTypeInfo billTypeinfo = new BillTypeInfo();
        billTypeinfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0113c0a812fd463ED552"));
        saleOrderInfo.setBillType(billTypeinfo);
    }

    private void recalAmountNew(Context ctx, SaleOrderInfo saleOrderInfo) throws TaskExternalException {
        BigDecimal exchangeRate;
        String importOption = this.getSMSDBillConfig(ctx, "com.kingdee.eas.scm.sd.sale.client.SaleOrderListUI", "importOption");
        if (importOption == null || "0".equals(importOption)) {
            this.recalAmount(ctx, saleOrderInfo);
            return;
        }
        BigDecimal bigDecimal = exchangeRate = saleOrderInfo.getExchangeRate() == null ? BigDecimal.ONE : saleOrderInfo.getExchangeRate();
        if (exchangeRate.compareTo(ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        ExchangeRateInfo exchangeRateInfo = null;
        int baseCurrencyPrecision = 2;
        int currencyPrecision = 2;
        String number = "";
        if (saleOrderInfo.getNumber() != null && saleOrderInfo.getNumber().toString().length() > 0) {
            number = saleOrderInfo.getNumber().toString();
        }
        if (!this.exchangeRateMap.containsKey("exchangeRateInfo" + number)) {
            this.setExchangeRateMap(ctx, saleOrderInfo, number);
        }
        if (this.exchangeRateMap.containsKey("exchangeRateInfo" + number)) {
            exchangeRateInfo = (ExchangeRateInfo)this.exchangeRateMap.get("exchangeRateInfo" + number);
        }
        if (this.exchangeRateMap.containsKey("baseCurrencyInfo" + number)) {
            baseCurrencyPrecision = ((CurrencyInfo)this.exchangeRateMap.get("baseCurrencyInfo" + number)).getPrecision();
        }
        if (this.exchangeRateMap.containsKey("currencyInfo" + number)) {
            currencyPrecision = ((CurrencyInfo)this.exchangeRateMap.get("currencyInfo" + number)).getPrecision();
        }
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal localTotalTaxAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal localTotalTax = ZERO;
        BigDecimal prepareAmount = ZERO;
        boolean isInTax = saleOrderInfo.isIsInTax();
        SaleOrderEntryInfo entryInfo = null;
        int pricePrecision = 6;
        int size = saleOrderInfo.getEntries().size();
        for (int n = 0; n < size; ++n) {
            entryInfo = saleOrderInfo.getEntries().get(n);
            pricePrecision = entryInfo.getMaterial().getPricePrecision();
            if ("1".equals(importOption) && isInTax) {
                this.importHandlingHelper.calEntryByTaxPrice((SCMBillEntryBaseInfo)entryInfo, isInTax, currencyPrecision, baseCurrencyPrecision, pricePrecision, exchangeRate, exchangeRateInfo, true);
            } else if ("1".equals(importOption) && !isInTax) {
                this.importHandlingHelper.calEntryByPrice((SCMBillEntryBaseInfo)entryInfo, isInTax, currencyPrecision, baseCurrencyPrecision, pricePrecision, exchangeRate, exchangeRateInfo, true);
            } else if ("2".equals(importOption) && isInTax) {
                this.importHandlingHelper.calEntryByTaxAmount((SCMBillEntryBaseInfo)entryInfo, isInTax, currencyPrecision, baseCurrencyPrecision, pricePrecision, exchangeRate, exchangeRateInfo, true);
            } else if ("2".equals(importOption) && !isInTax) {
                this.importHandlingHelper.calEntryByAmount((SCMBillEntryBaseInfo)entryInfo, isInTax, currencyPrecision, baseCurrencyPrecision, pricePrecision, exchangeRate, exchangeRateInfo, true);
            }
            totalTaxAmount = totalTaxAmount.add(entryInfo.getTaxAmount());
            localTotalTaxAmount = localTotalTaxAmount.add(entryInfo.getLocalTaxAmount());
            totalTax = totalTax.add(entryInfo.getTax());
            localTotalTax = localTotalTax.add(entryInfo.getLocalTax());
            prepareAmount = prepareAmount.add(entryInfo.getPrepayment());
        }
        saleOrderInfo.setTotalTaxAmount(totalTaxAmount);
        saleOrderInfo.setLocalTotalTaxAmount(localTotalTaxAmount);
        saleOrderInfo.setTotalTax(totalTax);
        saleOrderInfo.setTotalAmount(totalTaxAmount.subtract(totalTax));
        saleOrderInfo.setLocalTotalAmount(localTotalTaxAmount.subtract(localTotalTax));
        saleOrderInfo.setPrepayment(prepareAmount);
        if (saleOrderInfo.getPrepayment() != null && saleOrderInfo.getPrepayment().compareTo(ZERO) != 0 && saleOrderInfo.getTotalTaxAmount() != null && saleOrderInfo.getTotalTaxAmount().compareTo(ZERO) != 0) {
            saleOrderInfo.setPrepaymentRate(prepareAmount.divide(saleOrderInfo.getTotalTaxAmount(), 6, 4).multiply(new BigDecimal("100.00")));
        }
    }

    public void setExchangeRateMap(Context ctx, SaleOrderInfo saleOrderInfo, String number) throws TaskExternalException {
        CurrencyInfo baseCurrencyInfo = null;
        Object currencyInfo = null;
        ExchangeRateInfo exchangeRateInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        try {
            CurrencyInfo info;
            ICurrency icurreny;
            CurrencyCollection collection;
            if (saleOrderInfo.getCurrency() != null && saleOrderInfo.getCurrency().getId() != null && (collection = (icurreny = CurrencyFactory.getLocalInstance((Context)ctx)).getCurrencyCollection("where id='" + saleOrderInfo.getCurrency().getId().toString() + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                this.exchangeRateMap.put("currencyInfo" + number, info);
            }
            if (saleOrderInfo.getCompanyOrgUnit() != null && saleOrderInfo.getCompanyOrgUnit().getBaseCurrency() != null) {
                baseCurrencyInfo = saleOrderInfo.getCompanyOrgUnit().getBaseCurrency();
                companyInfo = saleOrderInfo.getCompanyOrgUnit();
                this.exchangeRateMap.put("baseCurrencyInfo" + number, CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId())));
            } else {
                IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitCollection orgCollection = null;
                if (saleOrderInfo.getSaleOrgUnit() != null) {
                    orgCollection = iOrgRelation.getToUnit(saleOrderInfo.getSaleOrgUnit().getId().toString(), 2, 1);
                }
                if (orgCollection != null && orgCollection.size() > 0) {
                    Object[] objs = orgCollection.toArray();
                    OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
                    System.arraycopy(objs, 0, orgs, 0, objs.length);
                    companyInfo = (CompanyOrgUnitInfo)orgs[0];
                    baseCurrencyInfo = companyInfo.getBaseCurrency();
                    this.exchangeRateMap.put("baseCurrencyInfo" + number, CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId())));
                }
            }
            if (baseCurrencyInfo != null && baseCurrencyInfo.getId() != null && companyInfo != null && companyInfo.getBaseExchangeTable() != null && saleOrderInfo.getCurrency() != null && saleOrderInfo.getCurrency().getId() != null) {
                exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)new ObjectUuidPK(companyInfo.getBaseExchangeTable().getId()), (IObjectPK)new ObjectUuidPK(saleOrderInfo.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId()));
                this.exchangeRateMap.put("exchangeRateInfo" + number, exchangeRateInfo);
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }
}

