/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeFactory;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.IDeliveryType;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.util.ParamsUtil;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.sd.sale.PriceTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderArClosedStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsException;
import com.kingdee.eas.scm.sd.sale.SupplyModeEnum;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleOrderWebFacadeControllerBean;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleOrderWebFacadeControllerBean
extends AbstractSaleOrderWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleOrderWebFacadeControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static BigDecimal DEFAULT_TAXRATE = SCMConstant.DefaultTaxRate;
    private Map parametersMap = null;

    protected Map _handleBillByCopy(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)info;
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(saleOrderInfo.getSaleOrgUnit().getId().toString()), "saleorder_addnew");
        if (null != saleOrderInfo.getSalePerson()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            viewInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)saleOrderInfo.getSalePerson().getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            PersonCollection personCol = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
            if (null == personCol || personCol.size() == 0) {
                saleOrderInfo.setSalePerson(null);
            }
        }
        return map;
    }

    protected Map _handleBillByOprtState(Context ctx, String id, String oprtState) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleOrderEntryInfo entryInfo;
        CompanyOrgUnitInfo cou;
        SaleOrderInfo info = (SaleOrderInfo)model;
        if (null != info.getSaleOrgUnit() && null != info.getSaleOrgUnit().getId().toString()) {
            this.parametersMap = this.batchGetParamValue(ctx, info.getSaleOrgUnit().getId().toString());
        }
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setIsInTax(true);
        Timestamp date = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        info.setBizDate(date);
        info.setCreateTime(date);
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        info.setCreator(user);
        String bizTypeID = "";
        bizTypeID = "d8e80652-010e-1000-e000-04c5c0a812202407435C";
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)ctx, (String)bizTypeID, (String)"510b6503-0105-1000-e000-0113c0a812fd463ED552");
        info.setBizType(bizType);
        IDeliveryType iDeliveryType = DeliveryTypeFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        DeliveryTypeInfo aDeliveryTypeInfo = iDeliveryType.getDeliveryTypeInfo((IObjectPK)new ObjectUuidPK("51eb893e-0105-1000-e000-0c00c0a8123362E9EE3F"), selector);
        info.setDeliveryType(aDeliveryTypeInfo);
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"), selector);
        info.setPaymentType(paymentTypeInfo);
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0113c0a812fd463ED552"));
        aBillTypeInfo.setNumber("310");
        info.setBillType(aBillTypeInfo);
        info.setExchangeRate(SCMUtil.BIGDECIMAL_ONE);
        SaleOrgUnitInfo sou = null;
        sou = info.getSaleOrgUnit() != null ? info.getSaleOrgUnit() : (SaleOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg((Context)ctx, (OrgType)OrgType.Sale, (String)"saleorder_addnew");
        info.setSaleOrgUnit(sou);
        if (sou == null) {
            return info;
        }
        AdminOrgUnitInfo admin = null;
        String enable_sale_admin = this.getParamValue(ctx, new ObjectUuidPK(info.getSaleOrgUnit().getId().toString()), "SALEORDER001");
        if (enable_sale_admin != null && !Boolean.valueOf(enable_sale_admin).booleanValue() && info.getSaleOrgUnit() != null) {
            admin = (AdminOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg((Context)ctx, (OrgType)OrgType.Admin, (String)"saleorder_addnew");
            info.setAdminOrgUnit(admin);
        }
        if (sou.getCU() != null) {
            info.setCU(sou.getCU());
        }
        if ((cou = this.getCouBySou(ctx, sou.getId().toString())) != null && cou.getBaseCurrency() != null) {
            info.setCompanyOrgUnit(cou);
            info.setCurrency(this.getBaseCurrencyByCou(ctx, cou));
            info.setExchangeRate(new BigDecimal(1));
        }
        if ((entryInfo = this.createEntryData(ctx, info)).isIsBetweenCompanySend()) {
            info.setIsCentralBalance(true);
        } else {
            info.setIsCentralBalance(false);
        }
        info.getEntries().add(entryInfo);
        return info;
    }

    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SaleOrderInfo info = (SaleOrderInfo)model;
        String saleOrgFilter = "id in " + this.getSaleOrgFilter(ctx);
        map.put("saleOrgFilter", saleOrgFilter);
        String proStorageOrgFilter = "id in " + this.getProStorageOrgFilter(ctx);
        map.put("proStorageOrgFilter", proStorageOrgFilter);
        if (info.getSaleOrgUnit() == null) {
            return map;
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection collSto = iOrgUnitRelation.getFromUnit(info.getSaleOrgUnit().getId().toString(), 2, 4);
        map.put("entryStoFilter", "id in " + this.getOrgFilterStr(ctx, collSto));
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(info.getSaleOrgUnit().getId().toString());
        map.put("bizOrgCUID", bizOrgCUID);
        CompanyOrgUnitInfo cou = null;
        cou = this.getCouBySou(ctx, info.getSaleOrgUnit().getId().toString());
        map.put("cou", cou);
        CurrencyInfo baseCurrency = this.getBaseCurrencyByCou(ctx, cou);
        CurrencyInfo currency = info.getCurrency();
        ExchangeRateInfo exchangeRate = this.getExchangeRate(cou, currency, baseCurrency);
        map.put("baseCurrency", baseCurrency);
        if (exchangeRate != null) {
            map.put("exchangeRatePercision", exchangeRate.getPrecision());
        } else {
            map.put("exchangeRatePercision", 2);
        }
        map.put("exchangeRateColl", this.getExchangeRateCollByCou(ctx, cou.getId().toString()));
        if (info.getCurrency() != null) {
            map.put("currency", CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()), this.getCurrencySelectors()));
        }
        if (info.getOrderCustomer() != null && info.getOrderCustomer().getNumber() == null) {
            info.setOrderCustomer(CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(info.getOrderCustomer().getId())));
        }
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        map.put("commissionsale", paymentTypeInfo);
        Map paramMap = this.batchGetParamValue(ctx, info.getSaleOrgUnit().getId().toString());
        String saleOrdId = info.getSaleOrgUnit().getId().toString();
        String billType = info.getBillType().getId().toString();
        ISCMBillParam iSCMBillParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String botpBillAddEntry = iSCMBillParam.getParamByBillTypeID("botpBillAddEntry", 2, saleOrdId, billType);
        paramMap.put("botpBillAddEntry", "1".equals(botpBillAddEntry));
        map.put("params", paramMap);
        this.parametersMap = paramMap;
        this.handleEntryDefaultValue(ctx, info, map);
        info.setCU(info.getSaleOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new SaleOrderInfo(), info.getSaleOrgUnit().getId().toString());
        if (ruleInfo != null) {
            map.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                map.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getSaleOrgUnit().getId().toString()));
            }
        }
        SaleOrderEntryCollection entryColl = info.getEntries();
        HashSet<String> sendAddressInfoSet = new HashSet<String>();
        SaleOrderEntryInfo entry = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entry = entryColl.get(i);
            if (entry.getSendAddress() != null) {
                sendAddressInfoSet.add(entry.getSendAddress());
            }
            if (null == entry.getMaterial() || null == entry.getMaterial().getId() || null != entry.getMaterial().getNumber()) continue;
            entry.setMaterial(MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entry.getMaterial().getId())));
        }
        if (sendAddressInfoSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("address", sendAddressInfoSet, CompareType.INCLUDE));
            view.setFilter(filter);
            CoreBaseCollection addressCollection = CustomerDeliveryAddressFactory.getLocalInstance((Context)ctx).getCollection(view);
            HashMap<String, CustomerDeliveryAddressInfo> sendAddressInfoMap = new HashMap<String, CustomerDeliveryAddressInfo>();
            for (int i = 0; i < addressCollection.size(); ++i) {
                sendAddressInfoMap.put(((CustomerDeliveryAddressInfo)addressCollection.get(i)).getAddress(), (CustomerDeliveryAddressInfo)addressCollection.get(i));
            }
            map.put("sendAddressInfoMap", sendAddressInfoMap);
        }
        AdminOrgUnitInfo admin = null;
        String enable_sale_admin = this.getParamValue(ctx, new ObjectUuidPK(info.getSaleOrgUnit().getId().toString()), "SALEORDER001");
        if (enable_sale_admin != null && !Boolean.valueOf(enable_sale_admin).booleanValue() && info.getSaleOrgUnit().getId().toString() != null) {
            OrgUnitCollection coll = this.getAdminOrgUnitBySou(ctx, info.getSaleOrgUnit().getId().toString());
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(info.getSaleOrgUnit().getId().toString())) continue;
                    admin = (AdminOrgUnitInfo)coll.get(i);
                    break;
                }
                if (admin == null && coll.get(0) != null) {
                    admin = (AdminOrgUnitInfo)coll.get(0);
                }
            }
            map.put("adminOrg", admin);
        } else {
            map.put("adminOrg", null);
        }
        map.put("storageF7Filter", this.getStorageOrgFilter(ctx, info.getSaleOrgUnit().getId().toString()));
        map.put("projectF7Filter", this.getProjectF7Filter(ctx, info.getSaleOrgUnit().getId().toString()));
        map.put("trackNumberF7Filter", this.getTrackNumberF7Filter(ctx, info.getSaleOrgUnit().getId().toString()));
        map.put("adminF7Filter", this.getAdminF7Filter(ctx, info.getSaleOrgUnit().getId().toString()));
        map.put("priceSourceType", this.getPriceSourceType());
        return map;
    }

    protected Map _handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(mainOrgId);
        map.put("bizOrgCUID", bizOrgCUID);
        CompanyOrgUnitInfo cou = null;
        cou = this.getCouBySou(ctx, mainOrgId);
        map.put("cou", cou);
        map.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        map.put("exchangeRateColl", this.getExchangeRateCollByCou(ctx, cou.getId().toString()));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new SaleOrderInfo(), mainOrgId);
        if (ruleInfo != null) {
            map.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (ruleInfo.isIsAddView()) {
                map.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)new SaleOrderInfo(), mainOrgId));
            }
        }
        Map paramMap = this.batchGetParamValue(ctx, mainOrgId);
        map.put("params", paramMap);
        AdminOrgUnitInfo admin = null;
        String enable_sale_admin = this.getParamValue(ctx, new ObjectUuidPK(mainOrgId), "SALEORDER001");
        if (enable_sale_admin != null && !Boolean.valueOf(enable_sale_admin).booleanValue() && mainOrgId != null) {
            OrgUnitCollection coll = this.getAdminOrgUnitBySou(ctx, mainOrgId);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(mainOrgId)) continue;
                    admin = (AdminOrgUnitInfo)coll.get(i);
                    break;
                }
                if (admin == null && coll.get(0) != null) {
                    admin = (AdminOrgUnitInfo)coll.get(0);
                }
            }
            map.put("adminOrg", admin);
        } else {
            map.put("adminOrg", null);
        }
        StorageOrgUnitInfo storage = this.getStorageOrgUnitBySou(ctx, mainOrgId);
        map.put("storageOrg", storage);
        if (storage != null) {
            map.put("entry_companyOrgUnit", this.getCouByStorageOrg(ctx, storage.getId().toString()));
        }
        map.put("storageF7Filter", this.getStorageOrgFilter(ctx, mainOrgId));
        map.put("projectF7Filter", this.getProjectF7Filter(ctx, mainOrgId));
        map.put("trackNumberF7Filter", this.getTrackNumberF7Filter(ctx, mainOrgId));
        map.put("adminF7Filter", this.getAdminF7Filter(ctx, mainOrgId));
        return map;
    }

    private SaleOrderEntryInfo createEntryData(Context ctx, SaleOrderInfo info) throws BOSException, EASBizException {
        SaleOrderEntryInfo entry = new SaleOrderEntryInfo();
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        BigDecimal defaultQty = ZERO;
        entry.setTotalIssueQty(defaultQty);
        entry.setDiscount(defaultQty);
        entry.setDiscountType(DiscountModeEnum.PERCENT);
        entry.setDiscountCondition(DiscountConditionEnum.NULL);
        entry.setOrderedQty(defaultQty);
        entry.setPlanDeliveryQty(defaultQty);
        entry.setCheapRate(defaultQty);
        entry.setPriceSourceType(PriceTypeEnum.NULL);
        entry.setIsMrpCal(false);
        entry.setPreReceived(defaultQty);
        entry.setUnPrereceivedAmount(defaultQty);
        entry.setIsIncomeConfirm(false);
        if (null != info.getSaleOrgUnit() && null != info.getSaleOrgUnit().getId().toString()) {
            boolean isDefaultValue = this.getBoolParam("SALEORDER004", true);
            entry.setQuantityUnCtrl(isDefaultValue);
            boolean isDefaultTimeValue = this.getBoolParam("SALEORDER006", true);
            entry.setTimeUnCtrl(isDefaultTimeValue);
            if (this.getBoolParam("SALEBILL001", false) && null != info.getOrderCustomer() && null != info.getOrderCustomer().getTaxRate()) {
                entry.setTaxRate(info.getOrderCustomer().getTaxRate());
            } else {
                entry.setTaxRate(DEFAULT_TAXRATE);
            }
        }
        DeliveryTypeInfo deliveryTypeInfo = info.getDeliveryType();
        boolean flag = false;
        if (deliveryTypeInfo == null || "SEND".equalsIgnoreCase(deliveryTypeInfo.getNumber())) {
            flag = true;
        }
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate());
        entry.setSendDate(curDate.getTime());
        if (flag) {
            int leadTime = info.getTransLeadTime();
            curDate.add(5, leadTime);
            entry.setDeliveryDate(curDate.getTime());
        } else {
            entry.setDeliveryDate(curDate.getTime());
        }
        entry.setStorageOrgUnit(this.getStorageOrgUnitBySou(ctx, info.getSaleOrgUnit().getId().toString()));
        if (entry.getStorageOrgUnit() != null) {
            entry.setCompanyOrgUnit(this.getCouByStorageOrg(ctx, entry.getStorageOrgUnit().getId().toString()));
        }
        entry.setProStorageOrgUnit(entry.getStorageOrgUnit());
        entry.setSupplyMode(SupplyModeEnum.SELF_STORAGE);
        entry.setIsMrpCal(false);
        entry.setArClosedStatus(SaleOrderArClosedStatusEnum.NONE);
        if (null != info.getSaleOrgUnit() && null != info.getSaleOrgUnit().getId() && null != entry.getStorageOrgUnit() && null != entry.getStorageOrgUnit().getId()) {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection pcoll = iOrgUnitRelation.getToUnit(info.getSaleOrgUnit().getId().toString(), 2, 1);
            OrgUnitCollection scoll = iOrgUnitRelation.getToUnit(entry.getStorageOrgUnit().getId().toString(), 4, 1);
            if (pcoll != null && pcoll.size() != 0 && scoll != null && scoll.size() != 0) {
                if (!pcoll.get(0).getId().toString().equals(scoll.get(0).getId().toString())) {
                    entry.setIsBetweenCompanySend(true);
                } else {
                    entry.setIsBetweenCompanySend(false);
                }
            }
        }
        return entry;
    }

    private void handleEntryDefaultValue(Context ctx, SaleOrderInfo info, Map map) throws EASBizException, BOSException {
        SaleOrderEntryInfo entryInfo = this.createEntryData(ctx, info);
        map.put("defaultSendDate", entryInfo.getSendDate());
        map.put("defaultDeliveryDate", entryInfo.getDeliveryDate());
        map.put("defaultStorageOrgUnit", entryInfo.getStorageOrgUnit());
        map.put("defaultQuantityUnCtrl", entryInfo.isQuantityUnCtrl());
        map.put("defaultTimeUnCtrl", entryInfo.isTimeUnCtrl());
        map.put("defaultCompanyOrgUnit", entryInfo.getCompanyOrgUnit());
        map.put("defaultIsBetweenCompanySend", entryInfo.isIsBetweenCompanySend());
        map.put("defaultBaseStatus", EntryBaseStatusEnum.ADD);
        map.put("defaultDiscountType", DiscountModeEnum.PERCENT);
        map.put("defaultArClosedStatus", SaleOrderArClosedStatusEnum.NONE);
        map.put("defaultPreReceived", entryInfo.getPreReceived());
        map.put("defaultUnPrereceivedAmount", entryInfo.getUnPrereceivedAmount());
        CustomerInfo defaultPaymentCustomer = null;
        CustomerInfo defaultReceiveCustomer = null;
        CustomerInfo defaultDeliveryCustomer = null;
        CustomerDeliveryAddressInfo defaultAddressInfo = null;
        String defaultAddress = "";
        BigDecimal defaultTaxRate = DEFAULT_TAXRATE;
        if (null != info && null != info.getOrderCustomer()) {
            CustomerCompanyInfoInfo companyInfo;
            String saleOrgId = info.getSaleOrgUnit().getId().toString();
            SelectorItemCollection siCol = new SelectorItemCollection();
            siCol.add(new SelectorItemInfo("settlementOrgUnit.id"));
            siCol.add(new SelectorItemInfo("settlementOrgUnit.name"));
            siCol.add(new SelectorItemInfo("billingOrgUnit.id"));
            siCol.add(new SelectorItemInfo("billingOrgUnit.name"));
            siCol.add(new SelectorItemInfo("deliverOrgUnit.id"));
            siCol.add(new SelectorItemInfo("deliverOrgUnit.name"));
            siCol.add(new SelectorItemInfo("customer.id"));
            siCol.add(new SelectorItemInfo("customer.taxRate"));
            siCol.add(new SelectorItemInfo("deliveryAddresses.id"));
            siCol.add(new SelectorItemInfo("deliveryAddresses.address"));
            siCol.add(new SelectorItemInfo("deliveryAddresses.name"));
            siCol.add(new SelectorItemInfo("customer.name"));
            siCol.add(new SelectorItemInfo("customer.number"));
            siCol.add(new SelectorItemInfo("customerSaler.id"));
            siCol.add(new SelectorItemInfo("customerSaler.name"));
            siCol.add(new SelectorItemInfo("customerSaler.person.id"));
            siCol.add(new SelectorItemInfo("customerSaler.person.name"));
            CustomerSaleInfoInfo csInfo = this.getCustomerSaleInfo(ctx, info.getOrderCustomer().getId().toString(), saleOrgId, siCol);
            if (csInfo == null) {
                return;
            }
            CustomerSaleInfoInfo settlementCustomer = this.getCustomerSaleInfo2(ctx, csInfo.getSettlementOrgUnit().getId().toString(), saleOrgId);
            CustomerSaleInfoInfo billingCustomer = this.getCustomerSaleInfo2(ctx, csInfo.getBillingOrgUnit().getId().toString(), saleOrgId);
            CustomerSaleInfoInfo deliverCustomer = this.getCustomerSaleInfo2(ctx, csInfo.getDeliverOrgUnit().getId().toString(), saleOrgId);
            if (null != settlementCustomer && null != settlementCustomer.getCustomer() && settlementCustomer.getUsingStatus().equals((Object)UsingStatusEnum.USING) && settlementCustomer.getCustomer().getUsedStatus().getValue() == 1) {
                defaultPaymentCustomer = csInfo.getSettlementOrgUnit();
            }
            if (null != billingCustomer && null != billingCustomer.getCustomer() && billingCustomer.getUsingStatus().equals((Object)UsingStatusEnum.USING) && billingCustomer.getCustomer().getUsedStatus().getValue() == 1) {
                defaultReceiveCustomer = csInfo.getBillingOrgUnit();
            }
            if (null != deliverCustomer && null != deliverCustomer.getCustomer() && deliverCustomer.getUsingStatus().equals((Object)UsingStatusEnum.USING) && deliverCustomer.getCustomer().getUsedStatus().getValue() == 1) {
                defaultDeliveryCustomer = csInfo.getDeliverOrgUnit();
            }
            if (csInfo != null && csInfo.getDeliveryAddresses() != null && csInfo.getDeliveryAddresses().size() > 0) {
                defaultAddress = csInfo.getDeliveryAddresses().get(0).getAddress();
                defaultAddressInfo = csInfo.getDeliveryAddresses().get(0);
            }
            if (this.getBoolParam("SALEBILL001", false) && null != csInfo.getCustomer()) {
                defaultTaxRate = csInfo.getCustomer().getTaxRate();
            }
            if ((companyInfo = this.getCustomerCompanyInfo(ctx, info.getOrderCustomer().getId().toString(), info.getCompanyOrgUnit().getId().toString())) != null && companyInfo.getPayCondition() != null) {
                map.put("defaultPrepaymentRate", companyInfo.getPayCondition().getPrepayRate());
            } else {
                map.put("defaultPrepaymentRate", null);
            }
        }
        map.put("defaultPaymentCustomer", defaultPaymentCustomer);
        map.put("defaultDeliveryCustomer", defaultDeliveryCustomer);
        map.put("defaultReceiveCustomer", defaultReceiveCustomer);
        map.put("defaultEntryTaxRate", defaultTaxRate);
        map.put("defaultAddressInfo", defaultAddressInfo);
        map.put("defaultAddress", defaultAddress);
    }

    private CustomerCompanyInfoInfo getCustomerCompanyInfo(Context ctx, String customerId, String companyOrgId) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection companyInfoSelector = new SelectorItemCollection();
        companyInfoSelector.add(new SelectorItemInfo("payCondition.prepayRate"));
        CustomerCompanyInfoInfo customerCompanyInfoInfo = iCustomer.getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(customerId), (IObjectPK)new ObjectUuidPK(companyOrgId), companyInfoSelector);
        return customerCompanyInfoInfo;
    }

    private CustomerSaleInfoInfo getCustomerSaleInfo(Context ctx, String customerId, String saleOrgId, SelectorItemCollection siCol) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)siCol);
        FilterInfo filter = new FilterInfo();
        if (customerId != null) {
            filter.appendFilterItem("customer.id", (Object)customerId);
        }
        if (saleOrgId != null) {
            filter.appendFilterItem("saleOrgUnit.id", (Object)saleOrgId);
        }
        viewInfo.setFilter(filter);
        CustomerSaleInfoCollection csInfoCol = CustomerSaleInfoFactory.getLocalInstance((Context)ctx).getCustomerSaleInfoCollection(viewInfo);
        CustomerSaleInfoInfo csInfo = null;
        if (csInfoCol.size() > 0) {
            csInfo = csInfoCol.get(0);
        }
        return csInfo;
    }

    private CustomerSaleInfoInfo getCustomerSaleInfo2(Context ctx, String customerId, String saleOrgId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select usingStatus,customer.usedStatus,customer.id where customer.id = '").append(customerId);
        sb.append("' and saleOrgUnit.id = '").append(saleOrgId).append("'");
        DataBaseCollection dbc = CustomerSaleInfoFactory.getLocalInstance((Context)ctx).getDataBaseCollection(sb.toString());
        CustomerSaleInfoInfo csInfo = null;
        if (dbc.size() > 0) {
            csInfo = (CustomerSaleInfoInfo)dbc.get(0);
        }
        return csInfo;
    }

    public CompanyOrgUnitInfo getCouBySou(Context ctx, String souId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getToUnit(souId, 2, 1);
        if (coll != null && coll.size() > 0) {
            company = (CompanyOrgUnitInfo)coll.get(0);
        }
        return company;
    }

    public CurrencyInfo getBaseCurrencyByCou(Context ctx, CompanyOrgUnitInfo cou) throws BOSException, EASBizException {
        if (cou != null && cou.getBaseCurrency() != null) {
            CurrencyInfo baseCurrInfo = cou.getBaseCurrency().getName() != null ? cou.getBaseCurrency() : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()), this.getCurrencySelectors());
            return baseCurrInfo;
        }
        return null;
    }

    public SelectorItemCollection getCurrencySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    private StorageOrgUnitInfo getStorageOrgUnitBySou(Context ctx, String souId) throws BOSException, EASBizException {
        StorageOrgUnitInfo pou = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getFromUnit(souId, 2, 4);
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(souId)) continue;
                pou = (StorageOrgUnitInfo)coll.get(i);
                break;
            }
            if (pou == null && coll.get(0) != null) {
                pou = (StorageOrgUnitInfo)coll.get(0);
            }
        }
        return pou;
    }

    private String getSaleOrgFilter(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Sale, null, "saleorder_addnew");
        OrgUnitCollection saleOrgColl = new OrgUnitCollection();
        HashSet<String> iSet = new HashSet<String>();
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            iSet.add(fullCompanyColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", iSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Boolean(false), CompareType.EQUALS));
        view.setFilter(filter);
        SaleOrgUnitCollection stoOrgColl = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitCollection(view);
        for (int i = 0; i < stoOrgColl.size(); ++i) {
            saleOrgColl.add((OrgUnitInfo)stoOrgColl.get(i));
        }
        return this.getOrgFilterStr(ctx, saleOrgColl);
    }

    private String getProStorageOrgFilter(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Storage, null, null);
        OrgUnitCollection saleOrgColl = new OrgUnitCollection();
        HashSet<String> iSet = new HashSet<String>();
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            iSet.add(fullCompanyColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", iSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Boolean(false), CompareType.EQUALS));
        view.setFilter(filter);
        StorageOrgUnitCollection stoOrgColl = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
        for (int i = 0; i < stoOrgColl.size(); ++i) {
            saleOrgColl.add((OrgUnitInfo)stoOrgColl.get(i));
        }
        return this.getOrgFilterStr(ctx, saleOrgColl);
    }

    public Object getExchangeRateCollByCou(Context ctx, String couId) throws EASBizException, BOSException {
        ExchangeRateCollection exColl = null;
        if (couId != null) {
            Date curDate = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.format(curDate);
            StringBuilder oql = new StringBuilder();
            oql.append("select convertRate,exchangeAux.sourceCurrency,exchangeAux.targetCurrency,exchangeAux.precision, \n");
            oql.append("exchangeAux.convertMode,exchangeAux.exchangeRateType,exchangeAux.exchangeTable.name,exchangeAux.exchangeTable.number \n");
            oql.append("where availTime <= '" + dateFormat.format(curDate) + "' and invalidTime >= '" + dateFormat.format(curDate) + "'");
            oql.append(" and  exchangeAux.exchangeTable.id in (select FBaseExgTableID from T_ORG_Company where fid ='" + couId + "'))");
            try {
                exColl = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateCollection(new EntityViewInfo(oql.toString()));
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return exColl;
    }

    private Map batchGetParamValue(Context ctx, String saleId) throws EASBizException, BOSException {
        SaleOrgUnitInfo sale = new SaleOrgUnitInfo();
        sale.setId(BOSUuid.read((String)saleId));
        SCMBizDataVO vo = new SCMBizDataVO(OrgType.Sale, (OrgUnitInfo)sale, 19, UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()), null);
        vo.setParameters(new String[]{"SALEORDER001", "SALEORDER002", "SALEORDER003", "SALEORDER004", "SALEORDERALTER3", "SALEORDERALTER1", "SALEORDER100", "SALEORDER006", "SALEORDER007", "SALEBILL001", "SALEORDER008", "SALEORDERSEL001", "PricePa023", "SCM_SD_CHECK_RECEIVED_WHILE_POST_ORDER", "SALEORDPRTAGAIN", "RESALEORDERALTER3", "SALE001"});
        vo.setBOSType("C48A423A");
        vo.setFirstLoading(true);
        SCMBizDataVO bizDataVO = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadSCMBizDataVO(vo);
        HashMap paramMap = bizDataVO.getParametersMap();
        paramMap.putAll(bizDataVO.getSalePriceParamInfo().getParamItems());
        return paramMap;
    }

    public boolean getBoolParam(String key, boolean defaultValue) throws EASBizException, BOSException {
        boolean isPurParam = defaultValue;
        String strPurParam = this.getCacheParameter(key);
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    protected final String getCacheParameter(String parameter) {
        return (String)this.parametersMap.get(parameter);
    }

    public String getProjectF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = ProjectFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)false, CompareType.EQUALS));
        return filterInfo.toString();
    }

    public String getTrackNumberF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        return filterInfo.toString();
    }

    private Map<String, Object> getPriceSourceType() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isNull", (Object)PriceTypeEnum.NULL);
        map.put("pricePolicy", (Object)PriceTypeEnum.PRICEPOLICY);
        map.put("basePrice", (Object)PriceTypeEnum.BASEPRICE);
        map.put("materialSaleInfo", (Object)PriceTypeEnum.SALEPRICE);
        return map;
    }

    private OrgUnitCollection getAdminOrgUnitBySou(Context ctx, String souId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getToUnit(souId, 2, 0);
        return coll;
    }

    private String getAdminF7Filter(Context ctx, String orgId) throws EASBizException, BOSException {
        StringBuffer filter = new StringBuffer();
        String enable_sale_admin = this.getParamValue(ctx, new ObjectUuidPK(orgId), "SALEORDER001");
        if (enable_sale_admin != null && Boolean.valueOf(enable_sale_admin).booleanValue()) {
            filter.append("id = 'xxxx-xxx'");
        } else {
            String orgFilter = this.getOrgFilterStr(ctx, this.getAdminOrgUnitBySou(ctx, orgId));
            filter.append("id in").append(orgFilter);
        }
        return filter.toString();
    }

    public String getParamValue(Context ctx, ObjectUuidPK orgUnitID, String paramNumber) throws EASBizException, BOSException {
        return ParamsUtil.getParamsValue((Context)ctx, (ObjectUuidPK)orgUnitID, (String)paramNumber);
    }

    private CompanyOrgUnitInfo getCouByStorageOrg(Context ctx, String souId) throws BOSException, EASBizException {
        return SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(BOSUuid.read((String)souId));
    }

    private String getStorageOrgFilter(Context ctx, String orgId) throws BOSException, EASBizException {
        StringBuffer filter = new StringBuffer();
        String orgFilter = this.getOrgFilterStr(ctx, this.getStorageOrgUnitBySaleOrg(ctx, orgId));
        filter.append("id in").append(orgFilter);
        return filter.toString();
    }

    private OrgUnitCollection getStorageOrgUnitBySaleOrg(Context ctx, String souId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getFromUnit(souId, 2, 4);
        return coll;
    }

    public ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo ficompanyOrgInfo, CurrencyInfo srcCurrInfo, CurrencyInfo destCurrInfo) throws EASBizException, BOSException {
        String srcCurrid = srcCurrInfo.getId().toString();
        String destCurrid = destCurrInfo.getId().toString();
        if (!destCurrid.equals(srcCurrid)) {
            ObjectUuidPK excTablepk = null;
            ObjectUuidPK sourceCurrPK = new ObjectUuidPK(srcCurrid);
            ObjectUuidPK destCurrPK = new ObjectUuidPK(destCurrid);
            ExchangeTableInfo baseExchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
            if (baseExchangeTableInfo == null) {
                CompanyOrgUnitInfo icomUnit = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getId()));
                baseExchangeTableInfo = icomUnit.getBaseExchangeTable();
            }
            if (baseExchangeTableInfo == null) {
                throw new SaleReturnsException(SaleReturnsException.NULL_EXCHANGETABLE);
            }
            excTablepk = new ObjectUuidPK(baseExchangeTableInfo.getId());
            sourceCurrPK = new ObjectUuidPK(srcCurrid);
            destCurrPK = new ObjectUuidPK(destCurrid);
            IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
            ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
            return tempexrateinfo;
        }
        return null;
    }
}

