/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeCollection;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.InvoiceReasonEnum;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ISaleGroup;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sd.sale.ISaleReturns;
import com.kingdee.eas.scm.sd.sale.SaleReturnsCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SaleReturnsDataImport
extends SCMDataImport {
    String[] BIGDECIMAL_FIELDS = new String[]{"FExchangeRate", "FTotalAmount", "FTotalTax", "FTotalTaxAmount"};
    String[] BIGDECIMAL_OBJ = new String[]{"exchangeRate", "totalAmount", "totalTax", "totalTaxAmount"};
    String[] BIGDECIMAL_OBJ_MATCHNAME = new String[]{"SALEINV_NEEDEXCHANGE", "SALEINV_NEEDTOTALAMOUNT", "SALEINV_NEEDTOTALTAX", "SALEINV_NEEDTOTALTAXPRICE"};
    String[] STRING_FIELDS = new String[]{"FDescription"};
    String[] STRING_OBJS = new String[]{"description"};
    String[] DATE_FIELDS = new String[]{"FAuditTime", "FBizDate", "FModificationTime", "FCreateTime", "FLastUpdateTime"};
    String[] DATE_OBJS = new String[]{"auditTime", "bizDate", "modificationTime", "createTime", "lastUpdateTime"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsInTax", "FQuantityUnCtrl"};
    String[] BOOLEAN_OBJS = new String[]{"isInTax", "quantityUnCtrl"};
    String[] INTEGER_FIELDS = new String[]{"FYear", "FPeriod"};
    String[] INTEGER_OBJS = new String[]{"year", "period"};
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FPrice", "FTaxPrice", "FAmount", "FTaxRate", "FTax", "FTaxAmount", "FQty", "FAssistQty", "FInvoicedQty", "FRemainingQty", "FInvoicePrice", "FLocalAmount", "FReturnsQty", "FBaseQty"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"price", "taxPrice", "amount", "taxRate", "tax", "taxAmount", "qty", "assistQty", "invoicedQty", "remainingQty", "invoicePrice", "localAmount", "returnsQty", "baseQty"};
    String[] STRING_FIELDS_EN = new String[]{"FRemark"};
    String[] STRING_OBJS_EN = new String[]{"remark"};
    String[] DATE_FIELDS_EN = new String[]{"FReturnsDate"};
    String[] DATE_OBJS_EN = new String[]{"returnsDate"};
    String[] BOOLEAN_FIELDS_EN = new String[]{"FIsPresent", "FQuantityUnCtrl"};
    String[] BOOLEAN_OBJS_EN = new String[]{"isPresent", "quantityUnCtrl"};
    BigDecimal ZERO = new BigDecimal("0.00");
    HashMap exchangeRateMap = new HashMap();
    ImportDataCache dataPool = new ImportDataCache();
    SaleReturnsInfo saleReturnsInfo = new SaleReturnsInfo();
    SaleOrgUnitInfo sou = null;
    private static final String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SaleReturnsFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            SaleReturnsInfo bill = (SaleReturnsInfo)coreBaseInfo;
            IObjectPK userPK = ctx.getCaller();
            ObjectUuidPK orgPK = new ObjectUuidPK(bill.getSaleOrgUnit().getId());
            SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)userPK, (IObjectPK)orgPK, (String)"saleReturns_addnew");
            ICoreBase isaleReturns = this.getController(ctx);
            String str = this.saleReturnsInfo.getNumber();
            SaleReturnsCollection coll = ((ISaleReturns)isaleReturns).getSaleReturnsCollection("select *,entries.*,currency.precision where number ='" + str + "'");
            if (this.isSltImportUpdate() && coll != null && coll.size() != 0 && coll.get(0).getId() != null) {
                String sql2;
                String sql1 = "Delete From t_sd_salereturns where fid ='" + coll.get(0).getId().toString() + "'";
                String[] updateSql = new String[]{sql1, sql2 = "Delete from t_sd_salereturnsentry where fparentid = '" + coll.get(0).getId().toString() + "'"};
                try {
                    DBUtil.executeBatch((Context)ctx, (String[])updateSql);
                }
                catch (BOSException e) {
                    throw new TaskExternalException("", (Throwable)e);
                }
            }
            if (coreBaseInfo.getId() == null || !isaleReturns.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                isaleReturns.addnew(coreBaseInfo);
            } else {
                isaleReturns.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Map chsData, Context ctx) throws TaskExternalException {
        TaskExternalException tex = new TaskExternalException("");
        boolean isImportDataByRule = DataImportUtils.getImportParam((Context)ctx);
        this.saleReturnsInfo = new SaleReturnsInfo();
        boolean keyCursor = false;
        for (int t = 0; t < chsData.size(); ++t) {
            Map hsData = (Map)chsData.get(new Integer(t));
            if (!keyCursor) {
                try {
                    this.transmitHead(hsData, ctx);
                    this.afterBuildHead(ctx, this.saleReturnsInfo, hsData);
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(t, e.getMessage());
                    this.recycleNumber(ctx, this.saleReturnsInfo);
                    break;
                }
            }
            try {
                BigDecimal exchangerate;
                SaleReturnsEntryInfo entryInfo = null;
                boolean isUpdateEntry = false;
                Object data = ((DataToken)hsData.get((Object)"FSeq")).data;
                if (data != null && data.toString().trim().length() > 0) {
                    int seq = Integer.parseInt(data.toString());
                    SaleReturnsEntryCollection entryCollection = this.saleReturnsInfo.getEntries();
                    int num = entryCollection.size();
                    for (int i = 0; i < num; ++i) {
                        SaleReturnsEntryInfo tempentryInfo = entryCollection.get(i);
                        if (tempentryInfo.getSeq() != seq) continue;
                        entryInfo = tempentryInfo;
                        isUpdateEntry = true;
                    }
                    if (!isUpdateEntry) {
                        entryInfo = new SaleReturnsEntryInfo();
                        entryInfo.setParent(this.saleReturnsInfo);
                        entryInfo.setSeq(seq);
                        entryCollection.add(entryInfo);
                    }
                } else {
                    SaleReturnsEntryCollection entryCollection = this.saleReturnsInfo.getEntries();
                    int seq = entryCollection.size() + 1;
                    entryInfo = new SaleReturnsEntryInfo();
                    entryInfo.setParent(this.saleReturnsInfo);
                    entryInfo.setSeq(seq);
                    entryCollection.add(entryInfo);
                }
                this.handleEntry(entryInfo, hsData, ctx);
                BigDecimal bigDecimal = exchangerate = this.saleReturnsInfo.getExchangeRate() == null ? new BigDecimal("1.00") : this.saleReturnsInfo.getExchangeRate();
                if (exchangerate.compareTo(this.ZERO) == 0) {
                    exchangerate = new BigDecimal("1.00");
                }
                CurrencyInfo baseCurrencyInfo = null;
                Object currencyInfo = null;
                ExchangeRateInfo exchangeRateInfo = null;
                CompanyOrgUnitInfo companyInfo = null;
                int baseCurrencyPrecision = 2;
                int currencyPrecision = 2;
                String number = "";
                if (this.saleReturnsInfo.getNumber() != null && this.saleReturnsInfo.getNumber().toString().length() > 0) {
                    number = this.saleReturnsInfo.getNumber().toString();
                }
                if (!this.exchangeRateMap.containsKey("exchangeRateInfo" + number)) {
                    CurrencyInfo info;
                    ICurrency icurreny;
                    CurrencyCollection collection;
                    if (this.saleReturnsInfo.getCurrency() != null && this.saleReturnsInfo.getCurrency().getId() != null && (collection = (icurreny = CurrencyFactory.getLocalInstance((Context)ctx)).getCurrencyCollection("where id='" + this.saleReturnsInfo.getCurrency().getId().toString() + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                        this.exchangeRateMap.put("currencyInfo" + number, info);
                    }
                    if (this.saleReturnsInfo.getCompanyOrgUnit() != null && this.saleReturnsInfo.getCompanyOrgUnit().getBaseCurrency() != null) {
                        baseCurrencyInfo = this.saleReturnsInfo.getCompanyOrgUnit().getBaseCurrency();
                        companyInfo = this.saleReturnsInfo.getCompanyOrgUnit();
                        this.exchangeRateMap.put("baseCurrencyInfo" + number, CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId())));
                    } else {
                        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                        OrgUnitCollection orgCollection = null;
                        if (this.saleReturnsInfo.getSaleOrgUnit() != null) {
                            orgCollection = iOrgRelation.getToUnit(this.saleReturnsInfo.getSaleOrgUnit().getId().toString(), 2, 1);
                        }
                        if (orgCollection != null && orgCollection.size() > 0) {
                            Object[] objs = orgCollection.toArray();
                            OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
                            System.arraycopy(objs, 0, orgs, 0, objs.length);
                            companyInfo = (CompanyOrgUnitInfo)orgs[0];
                            baseCurrencyInfo = companyInfo.getBaseCurrency();
                            this.exchangeRateMap.put("baseCurrencyInfo" + number, CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId())));
                        }
                    }
                    if (baseCurrencyInfo != null && baseCurrencyInfo.getId() != null && companyInfo != null && companyInfo.getBaseExchangeTable() != null) {
                        baseCurrencyPrecision = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId())).getPrecision();
                        if (this.saleReturnsInfo.getCurrency() != null && this.saleReturnsInfo.getCurrency().getId() != null) {
                            exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)new ObjectUuidPK(companyInfo.getBaseExchangeTable().getId()), (IObjectPK)new ObjectUuidPK(this.saleReturnsInfo.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId()));
                            this.exchangeRateMap.put("exchangeRateInfo" + number, exchangeRateInfo);
                        }
                    }
                }
                if (this.exchangeRateMap.containsKey("exchangeRateInfo" + number)) {
                    exchangeRateInfo = (ExchangeRateInfo)this.exchangeRateMap.get("exchangeRateInfo" + number);
                }
                if (this.exchangeRateMap.containsKey("baseCurrencyInfo" + number)) {
                    baseCurrencyPrecision = ((CurrencyInfo)this.exchangeRateMap.get("baseCurrencyInfo" + number)).getPrecision();
                }
                if (this.exchangeRateMap.containsKey("currencyInfo" + number)) {
                    currencyPrecision = ((CurrencyInfo)this.exchangeRateMap.get("currencyInfo" + number)).getPrecision();
                }
                BigDecimal amount = this.ZERO;
                BigDecimal tax = this.ZERO;
                BigDecimal taxAmount = this.ZERO;
                BigDecimal totalAmount = this.ZERO;
                BigDecimal totalTax = this.ZERO;
                BigDecimal totalTaxAmount = this.ZERO;
                BigDecimal localAmount = this.ZERO;
                BigDecimal localTax = this.ZERO;
                BigDecimal localTaxAmount = this.ZERO;
                BigDecimal prepareAmount = this.ZERO;
                int size = this.saleReturnsInfo.getEntries().size();
                for (int n = 0; n < size; ++n) {
                    entryInfo = this.saleReturnsInfo.getEntries().get(n);
                    amount = this.ZERO;
                    tax = this.ZERO;
                    taxAmount = this.ZERO;
                    if (entryInfo.getAmount() != null) {
                        amount = entryInfo.getAmount();
                    }
                    if (entryInfo.getTax() != null) {
                        tax = entryInfo.getTax();
                    }
                    if (entryInfo.getTaxAmount() != null) {
                        taxAmount = entryInfo.getTaxAmount();
                    }
                    totalAmount = totalAmount.add(amount);
                    totalTax = totalTax.add(tax);
                    totalTaxAmount = totalTaxAmount.add(taxAmount);
                    if (totalTax.add(totalAmount).compareTo(totalTaxAmount) != 0) {
                        String exestr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.app.PurInImportResource", (String)"TAXAMOUNT_NOTEQUALS_OTHERAMOUNT", (Context)ctx);
                        throw new TaskExternalException(exestr);
                    }
                    if (tax != null && exchangerate != null) {
                        if (exchangeRateInfo != null) {
                            if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                                entryInfo.setLocalTax(tax.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                            } else {
                                entryInfo.setLocalTax(tax.divide(exchangerate, baseCurrencyPrecision, 4));
                            }
                        } else {
                            entryInfo.setLocalTax(tax.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                        }
                    } else {
                        entryInfo.setLocalTax(this.ZERO);
                    }
                    localTax = localTax.add(entryInfo.getLocalTax());
                    if (taxAmount != null && exchangerate != null) {
                        if (exchangeRateInfo != null) {
                            if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                                entryInfo.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                            } else {
                                entryInfo.setLocalTaxAmount(taxAmount.divide(exchangerate, baseCurrencyPrecision, 4));
                            }
                        } else {
                            entryInfo.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(baseCurrencyPrecision, 4));
                        }
                    } else {
                        entryInfo.setLocalTaxAmount(this.ZERO);
                    }
                    localTaxAmount = localTaxAmount.add(entryInfo.getLocalTaxAmount());
                    entryInfo.setLocalAmount(entryInfo.getLocalTaxAmount().subtract(entryInfo.getLocalTax()));
                    localAmount = localAmount.add(entryInfo.getLocalAmount());
                }
                this.saleReturnsInfo.setLocalTotalAmount(localAmount);
                this.saleReturnsInfo.setLocalTotalTaxAmount(localTaxAmount);
                this.saleReturnsInfo.setLocalTotalTax(localTax);
                this.saleReturnsInfo.setTotalAmount(totalAmount);
                this.saleReturnsInfo.setTotalTax(totalTax);
                this.saleReturnsInfo.setTotalTaxAmount(totalTaxAmount);
                continue;
            }
            catch (Exception e) {
                tex.addEntryErrorReason(t, e.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, this.saleReturnsInfo);
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.saleReturnsInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transmitHead(Map hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        Object saleOrgData = ((DataToken)hsData.get((Object)"FSaleOrgUnitID")).data;
        String str = null;
        String saleOrgNum = null;
        if (saleOrgData == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEORG_NOT_NULL", (Context)ctx));
        if (StringUtils.isEmpty((CharSequence)saleOrgData.toString())) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEORG_NOT_NULL", (Context)ctx));
        saleOrgNum = saleOrgData.toString();
        SaleOrgUnitInfo info = null;
        if (saleOrgNum != null && saleOrgNum.trim().length() > 0) {
            try {
                info = this.getSaleOrgUnit(ctx, "number", saleOrgNum);
                if (info == null) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEORG_NOT_EXISTS", (Context)ctx));
                }
                if (info == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEORG_NOT_EXISTS", (Context)ctx));
                this.saleReturnsInfo.setSaleOrgUnit(info);
                this.sou = info;
                this.saleReturnsInfo.setCU(info.getCU());
                IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitCollection orgCollection = null;
                try {
                    orgCollection = iOrgRelation.getToUnit(info.getId().toString(), 2, 1);
                }
                catch (EASBizException e) {
                    Logger.error((Throwable)e);
                    throw new TaskExternalException(e.getMessage());
                }
                if (orgCollection != null && orgCollection.size() > 0) {
                    Object[] objs = orgCollection.toArray();
                    OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
                    System.arraycopy(objs, 0, orgs, 0, objs.length);
                    this.saleReturnsInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)orgs[0]);
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
        for (i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                o = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = new BigDecimal(o.toString())) == null) continue;
                this.saleReturnsInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], (BigDecimal)value);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + " " + SCMUtils.getResource((String)resources, (String)"FormatMustBeNumber", (Context)ctx));
            }
        }
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS[i])).data;
            o = ImRptAppUtils.formatNationalDate((Context)ctx, (String)(o == null ? null : o.toString()));
            if (o == null) continue;
            this.saleReturnsInfo.setDate(this.DATE_OBJS[i], (Date)o);
        }
        for (i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            this.saleReturnsInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            this.saleReturnsInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        for (i = 0; i < this.INTEGER_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.INTEGER_FIELDS[i])).data;
            if (o == null || o.toString().equals("")) continue;
            value = new Integer(o.toString());
            this.saleReturnsInfo.setInt(this.INTEGER_OBJS[i], (Integer)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FBaseStatus")).data;
        String value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            this.saleReturnsInfo.setBaseStatus(this.getBaseStatusValue(value2));
        }
        if ((data = ((DataToken)hsData.get((Object)"FReturnsReason")).data) != null && (value2 = data.toString()) != null) {
            this.saleReturnsInfo.setReturnsReason(this.getReturnsReasonValue(value2));
        }
        try {
            BizTypeInfo info2;
            CurrencyInfo info3;
            CurrencyCollection collection;
            CtrlUnitInfo cuinfo;
            ICtrlUnit ictrlUnit;
            CtrlUnitCollection cuCollection;
            IUser iuser = UserFactory.getLocalInstance((Context)ctx);
            Object userInfo = null;
            this.saleReturnsInfo.setCreator(this.getCreator(ctx, null));
            this.saleReturnsInfo.setLastUpdateUser(this.getCreator(ctx, null));
            data = ((DataToken)hsData.get((Object)"FControlUnitID")).data;
            if (data != null && (str = ((DataToken)hsData.get((Object)"FControlUnitID")).data.toString()) != null && str.length() > 0 && (cuCollection = (ictrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx)).getCtrlUnitCollection("where number='" + str + "'")) != null && cuCollection.size() > 0 && (cuinfo = cuCollection.get(0)) != null) {
                this.saleReturnsInfo.setCU(cuinfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FCurrencyID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                if (this.dataPool.getCurrencyInfo(str) == null) {
                    ICurrency icurreny = CurrencyFactory.getLocalInstance((Context)ctx);
                    collection = icurreny.getCurrencyCollection("where number='" + str + "'");
                    if (collection != null && collection.size() > 0 && (info3 = collection.get(0)) != null) {
                        this.dataPool.setCurrencyInfo(str, info3);
                        this.saleReturnsInfo.setCurrency(info3);
                    }
                } else {
                    this.saleReturnsInfo.setCurrency(this.dataPool.getCurrencyInfo(str));
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FReturnsCustomerID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                this.saleReturnsInfo.setReturnsCustomer(this.getCustomer(ctx, str));
            }
            if ((data = ((DataToken)hsData.get((Object)"FSaleGroupID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                if (this.dataPool.getSaleGroup(str) == null) {
                    ISaleGroup isaleGroup = SaleGroupFactory.getLocalInstance((Context)ctx);
                    collection = isaleGroup.getSaleGroupCollection("where number='" + str + "'");
                    if (collection != null && collection.size() > 0 && (info3 = collection.get(0)) != null) {
                        this.dataPool.setSaleGroup(str, (SaleGroupInfo)info3);
                        this.saleReturnsInfo.setSaleGroup((SaleGroupInfo)info3);
                    }
                } else {
                    this.saleReturnsInfo.setSaleGroup(this.dataPool.getSaleGroup(str));
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FSalePersonID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                if (this.dataPool.getPersonInfo(str) == null) {
                    PersonInfo info4;
                    IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0");
                    viewInfo.setFilter(filter);
                    PersonCollection collection2 = iPerson.getPersonCollection(viewInfo);
                    if (collection2 != null && collection2.size() > 0 && (info4 = collection2.get(0)) != null) {
                        this.dataPool.setPersonInfo(str, info4);
                        this.saleReturnsInfo.setSalePerson(info4);
                    }
                } else {
                    this.saleReturnsInfo.setSalePerson(this.dataPool.getPersonInfo(str));
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FPaymentTypeID")).data) == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"PAYMENTTYPE_NOT_EXISTS", (Context)ctx));
            str = data.toString();
            if (str == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"PAYMENTTYPE_NOT_EXISTS", (Context)ctx));
            if (str.trim().length() <= 0) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"PAYMENTTYPE_NOT_EXISTS", (Context)ctx));
            if (this.dataPool.getPaymentTypeInfo(str) == null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                view.setFilter(filter);
                PaymentTypeCollection payColl = PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeCollection(view);
                if (payColl == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"PAYMENTTYPE_NOT_EXISTS", (Context)ctx));
                if (payColl.size() <= 0) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"PAYMENTTYPE_NOT_EXISTS", (Context)ctx));
                this.saleReturnsInfo.setPaymentType(payColl.get(0));
                this.dataPool.setPaymentTypeInfo(str, payColl.get(0));
            } else {
                this.saleReturnsInfo.setPaymentType(this.dataPool.getPaymentTypeInfo(str));
            }
            data = ((DataToken)hsData.get((Object)"FAdminOrgUnitID")).data;
            if (data != null && (str = data.toString()) != null && str.length() > 0) {
                AdminOrgUnitInfo info5 = this.getAdminOrgUnit(ctx, "number", str);
                this.saleReturnsInfo.setAdminOrgUnit(info5);
            }
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"50957179-0105-1000-e008-8152c0a812fd463ED552"));
            this.saleReturnsInfo.setBillType(billType);
            data = ((DataToken)hsData.get((Object)"FBizTypeID")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info2 = this.getBizType(ctx, this.saleReturnsInfo.getBillType().getId().toString(), "number", str);
                this.saleReturnsInfo.setBizType(info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FPaymentTypeID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                info2 = this.getPaymentType(ctx, "number", str, null);
                this.saleReturnsInfo.setPaymentType((PaymentTypeInfo)info2);
            }
            this.saleReturnsInfo.setModifier(this.getCreator(ctx, null));
            return;
        }
        catch (TaskExternalException ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        catch (BOSException ex) {
            Logger.error((Throwable)ex);
        }
    }

    private void handleEntry(SaleReturnsEntryInfo entryInfo, Map hsData, Context ctx) throws TaskExternalException {
        try {
            MaterialInfo info;
            int i;
            Object value;
            for (int i2 = 0; i2 < this.BIGDECIMAL_FIELDS_EN.length; ++i2) {
                try {
                    Object o = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS_EN[i2])).data;
                    if (o == null || o.toString().trim().length() <= 0 || (value = new BigDecimal(o.toString())) == null) continue;
                    entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i2], (BigDecimal)value);
                    continue;
                }
                catch (NumberFormatException nex) {
                    Logger.error((Throwable)nex);
                    throw new TaskExternalException(this.BIGDECIMAL_OBJ_EN[i2] + " " + SCMUtils.getResource((String)resources, (String)"FormatMustBeNumber", (Context)ctx));
                }
            }
            for (i = 0; i < this.DATE_FIELDS_EN.length; ++i) {
                Object o = ((DataToken)hsData.get((Object)this.DATE_FIELDS_EN[i])).data;
                o = ImRptAppUtils.formatNationalDate((Context)ctx, (String)(o == null ? null : o.toString()));
                if (o == null) continue;
                entryInfo.setDate(this.DATE_OBJS_EN[i], (Date)o);
            }
            for (i = 0; i < this.BOOLEAN_FIELDS_EN.length; ++i) {
                Object o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS_EN[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
                entryInfo.setBoolean(this.BOOLEAN_OBJS_EN[i], this.getBooleanValue((String)value));
            }
            for (i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
                Object o = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data;
                if (o == null) continue;
                value = o.toString();
                entryInfo.setString(this.STRING_OBJS_EN[i], (String)value);
            }
            Object data = ((DataToken)hsData.get((Object)"FEntryBaseStatus")).data;
            value = null;
            if (data != null && (value = data.toString()) != null) {
                entryInfo.setBaseStatus(this.getEntryBaseStatusValue((String)value));
            }
            MaterialInfo materialInfo = new MaterialInfo();
            String str = null;
            data = ((DataToken)hsData.get((Object)"FMaterialID")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info = this.getMaterial(ctx, "number", str, new OrgUnitInfo[]{this.sou});
                entryInfo.setMaterial(info);
                materialInfo = info;
            }
            if ((data = ((DataToken)hsData.get((Object)"FUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info = this.getMeasureUnit(ctx, str, materialInfo);
                entryInfo.setUnit((MeasureUnitInfo)info);
            }
            entryInfo.setBaseUnit(materialInfo.getBaseUnit());
            if (entryInfo.getQty() != null && !entryInfo.getQty().equals(BigDecimal.ZERO) && entryInfo.getUnit() != null && entryInfo.getMaterial() != null) {
                BigDecimal baseUnitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getQty());
                entryInfo.setBaseQty(baseUnitQty);
            }
            entryInfo.setAssistUnit(materialInfo.getAssistUnit());
            data = ((DataToken)hsData.get((Object)"FAssistPropertyID")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info = this.getAsstAttr(ctx, str, materialInfo.getAssistAttr());
                entryInfo.setAssistProperty((AsstAttrValueInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FStorageOrgUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info = this.getStorageOrgUnit(ctx, "number", str);
                entryInfo.setStorageOrgUnit((StorageOrgUnitInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FCompanyOrgUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info = this.getCompanyOrgUnit(ctx, "number", str);
                entryInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FWarehouseID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                if (this.dataPool.getWarehouseInfo(str) == null) {
                    WarehouseInfo info2;
                    IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0");
                    viewInfo.setFilter(filter);
                    WarehouseCollection collection = iWarehouse.getWarehouseCollection(viewInfo);
                    if (collection != null && collection.size() > 0 && (info2 = collection.get(0)) != null) {
                        entryInfo.setWarehouse(info2);
                        this.dataPool.setWarehouseInfo(str, info2);
                    }
                } else {
                    entryInfo.setWarehouse(this.dataPool.getWarehouseInfo(str));
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FDeliveryCustomerID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                str = str.trim();
                info = this.getCustomer(ctx, str);
                entryInfo.setDeliveryCustomer((CustomerInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FReceiveCustomerID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                str = str.trim();
                info = this.getCustomer(ctx, str);
                entryInfo.setReceiveCustomer((CustomerInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FPaymentCustomerID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                str = str.trim();
                info = this.getCustomer(ctx, str);
                entryInfo.setPaymentCustomer((CustomerInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FProjectName")).data) != null && data.toString().trim().length() > 0) {
                str = data.toString();
                entryInfo.setProject(this.getProject(ctx, str, this.sou.getCU()));
            }
            if ((data = ((DataToken)hsData.get((Object)"FTrackNumberName")).data) != null && data.toString().trim().length() > 0) {
                str = data.toString();
                entryInfo.setTrackNumber(this.getTrackNumber(ctx, str, this.sou.getCU()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private boolean getBooleanValue(String value) {
        return !(value = value.trim()).equalsIgnoreCase("N") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("0") && !value.equalsIgnoreCase("FALSE");
    }

    private BillBaseStatusEnum getBaseStatusValue(String value) {
        BillBaseStatusEnum tSaved = BillBaseStatusEnum.TEMPORARILYSAVED;
        return tSaved;
    }

    private EntryBaseStatusEnum getEntryBaseStatusValue(String value) {
        EntryBaseStatusEnum tSaved = EntryBaseStatusEnum.TEMPORARILYSAVED;
        return tSaved;
    }

    private InvoiceReasonEnum getReturnsReasonValue(String value) {
        InvoiceReasonEnum general = InvoiceReasonEnum.GENERAL;
        if (value != null) {
            value = value.trim();
            List EnumList = InvoiceReasonEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                InvoiceReasonEnum enumList = (InvoiceReasonEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                general = enumList;
                break;
            }
        }
        return general;
    }

    private UserInfo getUserFromNumber(IUser iuser, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
            this.dataPool.setUserInfo(number, userInfo);
        }
        return userInfo;
    }

    public ProjectInfo getMMProjectByNumber(Context ctx, String number, StorageOrgUnitInfo storageUnit) throws TaskExternalException, BOSException {
        ProjectInfo project = null;
        if (number != null && number.trim().length() > 0) {
            IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            HashSet<Integer> status = new HashSet<Integer>();
            status.add(new Integer(4));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
            FilterInfo filter2 = new FilterInfo();
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (storageUnit != null && storageUnit.getCU() != null) {
                cu = storageUnit.getCU();
            }
            ObjectUuidPK cuPK = null;
            cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
            try {
                filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            if (filter2 != null) {
                filter.mergeFilter(filter2, "and");
            }
            viewInfo.setFilter(filter);
            ProjectCollection coll = iProject.getProjectCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                project = coll.get(0);
                this.dataPool.setProjectNumber(number, coll.get(0));
            } else {
                throw new TaskExternalException(number.toString() + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"PROJECT_NUMBER_ERROR", (Context)ctx));
            }
        }
        return project;
    }

    public TrackNumberInfo getTrackByNumber(Context ctx, String number, StorageOrgUnitInfo storageUnit) throws TaskExternalException, BOSException {
        TrackNumberInfo track = null;
        if (number != null && number.trim().length() > 0) {
            ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            HashSet<Integer> status = new HashSet<Integer>();
            status.add(new Integer(10));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
            FilterInfo filter2 = new FilterInfo();
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (storageUnit != null && storageUnit.getCU() != null) {
                cu = storageUnit.getCU();
            }
            ObjectUuidPK cuPK = null;
            cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
            try {
                filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            if (filter2 != null) {
                filter.mergeFilter(filter2, "and");
            }
            viewInfo.setFilter(filter);
            TrackNumberCollection coll = iTrackNumber.getTrackNumberCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                track = coll.get(0);
                this.dataPool.setTrackNumber(number, coll.get(0));
            } else {
                throw new TaskExternalException(number.toString() + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"TRACK_NUMBER_ERROR", (Context)ctx));
            }
        }
        return track;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        return oldFilterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.sale.app.SaleReturnsQuery";
    }

    public int getSubmitType() {
        return 1;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("bizDate")));
            this.putTable(result, "FSaleOrgUnitID", rs.getString("saleOrgUnit.number"));
            this.putTable(result, "FBizTypeID", rs.getString("bizType.number"));
            this.putTable(result, "FSaleGroupID", rs.getString("saleGroup.number"));
            this.putTable(result, "FSalePersonID", rs.getString("salePerson.number"));
            this.putTable(result, "FBaseStatus", rs.getString("baseStatus"));
            this.putTable(result, "FReturnsReason", rs.getString("returnsReason"));
            this.putTable(result, "FReturnsCustomerID", rs.getString("returnsCustomer.number"));
            this.putTable(result, "FPaymentTypeID", rs.getString("paymentType.number"));
            this.putTable(result, "FBillTypeID", rs.getString("billType.number"));
            this.putTable(result, "FCurrencyID", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getString("exchangeRate"));
            this.putTable(result, "FCompanyOrgUnitID", rs.getString("companyOrgUnit.number"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FMaterialID", rs.getString("material.number"));
            this.putTable(result, "FAssistPropertyID", rs.getString("assistProperty.number"));
            this.putTable(result, "FUnitID", rs.getString("unit.number"));
            this.putTable(result, "FQty", rs.getString("entries.quantity"));
            this.putTable(result, "FAssistUnitID", rs.getString("assistantUnit.number"));
            this.putTable(result, "FAssistQty", rs.getString("entries.assistQuantity"));
            this.putTable(result, "FBaseQty", rs.getString("entries.baseunitQty"));
            this.putTable(result, "FLot", rs.getString("ENTRIES.BATCHNUMBER"));
            this.putTable(result, "FPrice", rs.getString("ENTRIES.PRICE"));
            this.putTable(result, "FTaxRate", rs.getString("ENTRIES.TAXRATE"));
            this.putTable(result, "FTaxPrice", rs.getString("ENTRIES.TAXPRICE"));
            this.putTable(result, "FAmount", rs.getString("ENTRIES.AMOUNT"));
            this.putTable(result, "FLocalAmount", rs.getString("ENTRIES.LOCALAMOUNT"));
            this.putTable(result, "FTax", rs.getString("ENTRIES.TAX"));
            this.putTable(result, "FTaxAmount", rs.getString("ENTRIES.TAXAMOUNT"));
            this.putTable(result, "FStorageOrgUnitID", rs.getString("STORAGEORGUNIT.NUMBER"));
            this.putTable(result, "FRemainingQty", rs.getString("ENTRIES.REMAININGQTY"));
            this.putTable(result, "FInvoicedQty", rs.getString("ENTRIES.INVOICEQTY"));
            this.putTable(result, "FInvoicePrice", rs.getString("ENTRIES.INVOICEPRICE"));
            this.putTable(result, "FReturnsQty", rs.getString("ENTRIES.RETURNSQTY"));
            this.putTable(result, "FReturnsDate", rs.getString("ENTRIES.RETURNSDATE"));
            this.putTable(result, "FTotalAmount", rs.getString("TOTALAMOUNT"));
            this.putTable(result, "FTotalTax", rs.getString("TOTALTAX"));
            this.putTable(result, "FTotalTaxAmount", rs.getString("TOTALTAXAMOUNT"));
            this.putTable(result, "FDeliveryCustomerID", rs.getString("DELIVERYCUSTOMER.NUMBER"));
            this.putTable(result, "FReceiveCustomerID", rs.getString("RECEIVECUSTOMER.NUMBER"));
            this.putTable(result, "FPaymentCustomerID", rs.getString("PAYMENTCUSTOMER.NUMBER"));
            this.putTable(result, "FReasonCodeID", rs.getString("ENTRYS.REASONCODE.NUMBER"));
            this.putTable(result, "FSaleSymbol", rs.getString("SALESYMBOL"));
            this.putTable(result, "FWarehouseID", rs.getString("WAREHOUSE.NUMBER"));
            this.putTable(result, "FQuantityUnCtrl", rs.getString("ENTRIES.QUANTITYUNCTRL"));
            this.putTable(result, "FRemark", rs.getString("ENTRIES.REMARK"));
            this.putTable(result, "FCreatorID", rs.getString("CREATOR.NUMBER"));
            this.putTable(result, "FCreateTime", rs.getString("CREATETIME"));
            this.putTable(result, "FModifierID", rs.getString("MODIFIER.NUMBER"));
            this.putTable(result, "FModificationTime", rs.getString("MODIFYTIME"));
            this.putTable(result, "FAuditorID", rs.getString("AUDITOR.NUMBER"));
            this.putTable(result, "FAuditTime", rs.getString("AUDITTIME"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }
}

