/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.ISaleReturns;
import com.kingdee.eas.scm.sd.sale.ISaleReturnsEntry;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsException;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleReturnsEntryControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleReturnsEntryControllerBean
extends AbstractSaleReturnsEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleReturnsEntryControllerBean");

    @Override
    protected void _freezeLine(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SaleReturnsEntryInfo info = (SaleReturnsEntryInfo)this.getValue(ctx, pk);
        if (!info.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTFREEZELINE);
        }
        info.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
        this.update(ctx, pk, (CoreBaseInfo)info);
    }

    @Override
    protected void _unfreezeLine(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String tableName = "T_SD_SaleReturnsEntry";
        SaleReturnsEntryInfo info = (SaleReturnsEntryInfo)this.getValue(ctx, pk);
        if (info != null && info.getBaseStatus().equals((Object)EntryBaseStatusEnum.BLOCKED)) {
            info.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            info.setReasonCode(null);
            info.setReason("");
            this.update(ctx, pk, (CoreBaseInfo)info);
            String billId = info.getParent().getId().toString();
            ISaleReturns is = SaleReturnsFactory.getLocalInstance(ctx);
            SaleReturnsInfo sInfo = is.getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(billId));
            info.put("parentNum", sInfo.getNumber());
            if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)billId)) {
                SaleReturnsEntryCollection entryColl = (SaleReturnsEntryCollection)((Object)sInfo.getEntries().clone());
                sInfo.getEntries().clear();
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    info = entryColl.get(i);
                    if (!pk.toString().equals(info.getId().toString())) continue;
                    sInfo.getEntries().add(info);
                }
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)sInfo, (BatchActionEnum)BatchActionEnum.UNFREEZE);
            }
        } else {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTUNFREEZELINE);
        }
        this.changeSaleReturnsStatus(ctx, pk, BillBaseStatusEnum.AUDITED);
    }

    @Override
    protected void _closeLine(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SaleReturnsEntryInfo info = (SaleReturnsEntryInfo)this.getValue(ctx, pk);
        boolean isOK = true;
        if (!isOK) {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTCLOSELINE);
        }
        info.setBaseStatus(EntryBaseStatusEnum.CLOSED);
        this.update(ctx, pk, (CoreBaseInfo)info);
    }

    @Override
    protected void _freezeWithReason(Context ctx, IObjectPK pk, IObjectValue reasonInfo) throws BOSException, EASBizException {
        SaleReturnsEntryInfo info = (SaleReturnsEntryInfo)this.getValue(ctx, pk);
        ReasonCodeInfo rInfo = (ReasonCodeInfo)reasonInfo;
        if (info.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
            info.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
            info.setReason(rInfo.getName());
            super.freezeWithLog(ctx, info);
            this.update(ctx, pk, (CoreBaseInfo)info);
            if (this.checkAllEntryStatus(ctx, pk, BillBaseStatusEnum.BLOCKED)) {
                this.changeSaleReturnsStatus(ctx, pk, BillBaseStatusEnum.BLOCKED);
            }
        } else {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTFREEZELINE);
        }
        ISaleReturns is = SaleReturnsFactory.getLocalInstance(ctx);
        SaleReturnsInfo sInfo = is.getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        info.put("parentNum", sInfo.getNumber());
    }

    @Override
    protected void _freezeWithReason(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        String tableName = "T_SD_SaleReturnsEntry";
        SaleReturnsEntryInfo info = (SaleReturnsEntryInfo)this.getValue(ctx, pk);
        String rInfo = reason;
        if (info != null && info.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
            info.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
            info.setReason(rInfo);
            super.freezeWithLog(ctx, info);
            this.update(ctx, pk, (CoreBaseInfo)info);
            String billId = info.getParent().getId().toString();
            ISaleReturns is = SaleReturnsFactory.getLocalInstance(ctx);
            SaleReturnsInfo sInfo = is.getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(billId));
            info.put("parentNum", sInfo.getNumber());
            if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)billId)) {
                SaleReturnsEntryCollection entryColl = (SaleReturnsEntryCollection)((Object)sInfo.getEntries().clone());
                sInfo.getEntries().clear();
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    info = entryColl.get(i);
                    if (!pk.toString().equals(info.getId().toString())) continue;
                    sInfo.getEntries().add(info);
                }
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)sInfo, (BatchActionEnum)BatchActionEnum.FREEZE);
            }
            if (this.checkAllEntryStatus(ctx, pk, BillBaseStatusEnum.BLOCKED)) {
                this.changeSaleReturnsStatus(ctx, pk, BillBaseStatusEnum.BLOCKED);
            }
        } else {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTFREEZELINE);
        }
    }

    @Override
    protected void _closewithReason(Context ctx, IObjectPK pk, IObjectValue reasonInfo) throws BOSException, EASBizException {
        this._closewithReason(ctx, new IObjectPK[]{pk}, reasonInfo != null ? ((ReasonCodeInfo)reasonInfo).getName() : "");
    }

    protected void writeBack2SaleOrder(Context ctx, SaleReturnsEntryInfo entryInfo, boolean isClose) throws BOSException, EASBizException {
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        if (entryInfo.getSourceBillEntryId() == null || !"88882A58".equals(BOSUuid.getBOSObjectType((String)entryInfo.getSourceBillEntryId(), (boolean)false).toString())) {
            return;
        }
        ObjectStringPK orderEntryPK = new ObjectStringPK(entryInfo.getSourceBillEntryId());
        SaleOrderEntryInfo orderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo((IObjectPK)orderEntryPK);
        if (orderEntryInfo == null || entryInfo.getQty().compareTo(entryInfo.getReturnsQty()) <= 0) {
            return;
        }
        BigDecimal returnQty = entryInfo.getQty().subtract(entryInfo.getReturnsQty());
        BigDecimal returnBaseQty = entryInfo.getBaseQty().subtract(entryInfo.getReturnsBaseQty());
        if (!entryInfo.getUnit().getId().toString().equals(orderEntryInfo.getUnit().getId().toString())) {
            returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)returnBaseQty, (String)orderEntryInfo.getUnit().getId().toString());
        }
        if (!isClose && orderEntryInfo.getTotalIssueQty().subtract(orderEntryInfo.getTotalReturnedQty()).compareTo(returnQty) < 0) {
            throw new SaleReturnsException(SaleReturnsException.QTY_IS_NOT_ENOUGH);
        }
        if (isClose) {
            orderEntryInfo.setTotalReturnedQty(orderEntryInfo.getTotalReturnedQty().subtract(returnQty));
            orderEntryInfo.setTotalReBaseQty(orderEntryInfo.getTotalReBaseQty().subtract(returnBaseQty));
            orderEntryInfo.setTotalUnReturnBaseQty(orderEntryInfo.getTotalUnReturnBaseQty().add(returnQty));
        } else {
            orderEntryInfo.setTotalReturnedQty(orderEntryInfo.getTotalReturnedQty().add(returnQty));
            orderEntryInfo.setTotalReBaseQty(orderEntryInfo.getTotalReBaseQty().add(returnBaseQty));
            orderEntryInfo.setTotalUnReturnBaseQty(orderEntryInfo.getTotalUnReturnBaseQty().subtract(returnQty));
        }
        iSaleOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
    }

    @Override
    protected void _unCloseLine(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        String tableName;
        Map flowMap;
        SaleReturnsInfo info = null;
        SaleReturnsEntryInfo entryInfo = null;
        SaleReturnsEntryCollection entryColl = null;
        StringBuffer idsBuf = new StringBuffer();
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                idsBuf.append(",");
            }
            idsBuf.append(pks[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idsBuf.toString(), CompareType.INCLUDE));
        view.setFilter(filter);
        SaleReturnsEntryCollection srEntrys = SaleReturnsEntryFactory.getLocalInstance(ctx).getSaleReturnsEntryCollection(view);
        if (null == srEntrys) {
            return;
        }
        HashSet<String> billIdSet = new HashSet<String>();
        for (int i = 0; i < srEntrys.size(); ++i) {
            entryInfo = srEntrys.get(i);
            if (entryInfo == null || entryInfo.getBaseStatus() == EntryBaseStatusEnum.CLOSED) continue;
            String msg = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"CAN_NOT_UNCLOSE_ENTRY", (Context)ctx);
            throw new EASBizException(new NumericExceptionSubItem("salException", msg));
        }
        SaleReturnsInfo sri = SaleReturnsFactory.getLocalInstance(ctx).getSaleReturnsInfo((IObjectPK)new ObjectStringPK(srEntrys.get(0).getParent().getId().toString()));
        BizTypeInfo bizType = sri.getBizType();
        if (null != bizType) {
            String tmp = bizType.getId().toString();
            if (tmp.equalsIgnoreCase("d8e80652-0110-1000-e000-04c5c0a812202407435C") || tmp.equalsIgnoreCase("7eD9TwIyTMmt7ELiDSC65CQHQ1w=")) {
                CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])pks, CreditOperationEnum.UNCLOSE);
            }
            int size = srEntrys.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = srEntrys.get(i);
                entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                entryInfo.setReason(null);
                billIdSet.add(entryInfo.getParent().getId().toString());
                ObjectUuidPK pk = new ObjectUuidPK(entryInfo.getId());
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)entryInfo);
            }
        }
        if ((flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)(tableName = "T_SD_SaleReturnsEntry"), (IObjectPK[])pks)) != null && flowMap.size() > 0) {
            HashSet idSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                idSet.add(entry.getValue());
            }
            if (idSet.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                SaleReturnsCollection coll = SaleReturnsFactory.getLocalInstance(ctx).getSaleReturnsCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        info = coll.get(i);
                        entryColl = (SaleReturnsEntryCollection)((Object)info.getEntries().clone());
                        info.getEntries().clear();
                        int n = entryColl.size();
                        for (int j = 0; j < n; ++j) {
                            entryInfo = entryColl.get(j);
                            if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                            info.getEntries().add(entryInfo);
                        }
                        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                    }
                }
            }
        }
        if (billIdSet.size() > 0) {
            StringBuffer sql = new StringBuffer();
            String parentids = SCMServerUtils.getInStringFromSet(billIdSet);
            sql.append(" update T_SD_SaleReturns set fbasestatus = ").append(4);
            sql.append(" where fid in ").append(parentids);
            sql.append(" and fid not in (select fparentid from T_SD_SaleReturnsEntry where fbasestatus = ");
            sql.append(-2).append(" and fparentid in");
            sql.append(parentids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        for (int i = 0; i < srEntrys.size(); ++i) {
            entryInfo = srEntrys.get(i);
            if (entryInfo == null || flowMap != null && flowMap.size() != 0 && flowMap.containsKey(entryInfo.getId().toString())) continue;
            this.writeBack2SaleOrder(ctx, entryInfo, false);
        }
    }

    @Override
    protected void _unCloseLine(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unCloseLine(ctx, new IObjectPK[]{pk});
    }

    private boolean checkAllEntryStatus(Context ctx, IObjectPK entryPk, BillBaseStatusEnum targeStatus) throws EASBizException, BOSException {
        ISaleReturnsEntry iSaleReturnsEntry = SaleReturnsEntryFactory.getLocalInstance(ctx);
        SaleReturnsEntryInfo saleReturnsEntryInfo = iSaleReturnsEntry.getSaleReturnsEntryInfo(entryPk);
        ISaleReturns iSaleReturns = SaleReturnsFactory.getLocalInstance(ctx);
        ObjectUuidPK orderPK = new ObjectUuidPK(saleReturnsEntryInfo.getParent().getId());
        SaleReturnsInfo saleReturnsInfo = iSaleReturns.getSaleReturnsInfo((IObjectPK)orderPK);
        SaleReturnsEntryCollection saleReturnsCollenction = saleReturnsInfo.getEntries();
        int num = saleReturnsCollenction.size();
        for (int i = 0; i < num; ++i) {
            if (saleReturnsCollenction.get(i).getBaseStatus().getValue() == targeStatus.getValue()) continue;
            return false;
        }
        return true;
    }

    private void changeSaleReturnsStatus(Context ctx, IObjectPK entryPk, BillBaseStatusEnum newStatus) throws EASBizException, BOSException {
        ISaleReturnsEntry iSaleReturnsEntry = SaleReturnsEntryFactory.getLocalInstance(ctx);
        SaleReturnsEntryInfo saleReturnsEntryInfo = iSaleReturnsEntry.getSaleReturnsEntryInfo(entryPk);
        ISaleReturns iSaleReturns = SaleReturnsFactory.getLocalInstance(ctx);
        ObjectUuidPK orderPK = new ObjectUuidPK(saleReturnsEntryInfo.getParent().getId());
        SaleReturnsInfo saleReturnsInfo = iSaleReturns.getSaleReturnsInfo((IObjectPK)orderPK);
        saleReturnsInfo.setBaseStatus(newStatus);
        iSaleReturns.update((IObjectPK)new ObjectUuidPK(saleReturnsInfo.getId()), (CoreBaseInfo)saleReturnsInfo);
    }

    @Override
    protected void _closewithReason(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        this._closewithReason(ctx, new IObjectPK[]{pk}, reason);
    }

    @Override
    protected void _freezeWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _closeWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleReturnsEntryInfo info = (SaleReturnsEntryInfo)this.getValue(ctx, pk);
        SaleReturnsInfo sInfo = SaleReturnsFactory.getLocalInstance(ctx).getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        return sInfo.getNumber() + "  " + info.getSeq();
    }

    @Override
    protected void _closewithReason(Context ctx, IObjectPK[] pks, String reason) throws BOSException, EASBizException {
        SaleReturnsInfo info = null;
        SaleReturnsEntryInfo entryInfo = null;
        SaleReturnsEntryCollection entryColl = null;
        StringBuffer ids = new StringBuffer();
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ids.append(",");
            }
            ids.append(pks[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
        view.setFilter(filter);
        SaleReturnsEntryCollection srEntrys = SaleReturnsEntryFactory.getLocalInstance(ctx).getSaleReturnsEntryCollection(view);
        if (srEntrys == null) {
            return;
        }
        HashSet<String> billIdSet = new HashSet<String>();
        for (int i = 0; i < srEntrys.size(); ++i) {
            entryInfo = srEntrys.get(i);
            if (entryInfo == null) continue;
            if (entryInfo.getBaseStatus() == EntryBaseStatusEnum.AUDITED) {
                entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
                entryInfo.setReason(reason);
                ObjectUuidPK pk = new ObjectUuidPK(entryInfo.getId().toString());
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)entryInfo);
                super.closeWithLog(ctx, entryInfo);
                billIdSet.add(entryInfo.getParent().getId().toString());
                continue;
            }
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTCLOSELINE);
        }
        String tableName = "T_SD_SaleReturnsEntry";
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, (IObjectPK[])pks);
        if (flowMap != null && flowMap.size() > 0) {
            HashSet idSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                idSet.add(entry.getValue());
            }
            if (idSet.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                SaleReturnsCollection coll = SaleReturnsFactory.getLocalInstance(ctx).getSaleReturnsCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        info = coll.get(i);
                        entryColl = (SaleReturnsEntryCollection)((Object)info.getEntries().clone());
                        info.getEntries().clear();
                        int n = entryColl.size();
                        for (int j = 0; j < n; ++j) {
                            entryInfo = entryColl.get(j);
                            if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                            info.getEntries().add(entryInfo);
                        }
                        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CLOSE);
                    }
                }
            }
        }
        if (billIdSet.size() > 0) {
            StringBuffer sql = new StringBuffer();
            String parentids = SCMServerUtils.getInStringFromSet(billIdSet);
            sql.append(" update T_SD_SaleReturns set fbasestatus = ").append(7);
            sql.append(" where fid in ").append(parentids);
            sql.append(" and fid not in (select fparentid from T_SD_SaleReturnsEntry where fbasestatus <> 7 and fparentid in");
            sql.append(parentids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        for (int i = 0; i < srEntrys.size(); ++i) {
            entryInfo = srEntrys.get(i);
            if (entryInfo == null || flowMap != null && flowMap.size() != 0 && flowMap.containsKey(entryInfo.getId().toString())) continue;
            this.writeBack2SaleOrder(ctx, entryInfo, true);
        }
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])pks, CreditOperationEnum.CLOSE);
    }
}

